*
*	This file contains routines called at the end of each message,folder,
*	each file, and at the end of everything, to do any logging necessary
*	and to accumulate statistics.
*++MLSEARCHed
*
	Subroutine Smsg_End
	Implicit None
*
*	End of message routine. Don't do any reporting, but update folder
*	level message statistics.
*
	Include 'STATCOM.INC'

	Folrec = Folrec + Recs
	Folmat = Folmat + Matches
	Folmsg = Folmsg + 1
	If(Matches .ne. 0) FolMmsg = FolMMsg + 1
	Matches = 0
	Recs = 0

	Return
	end

	Subroutine Folder_End(Folder)
	Implicit None
	Character*(*) Folder

	Include 'STATCOM.INC'
	Include 'QUALCOM.INC'

	External MLSEARCH_MATCHEDFOL,MLSEARCH_NOMATCHFOL
*-------------------------------------------------------------------------
*
*	Accumulate file-level statistics
*

	Frec = Frec + Folrec
	FMatch = Fmatch + Folmat
	Fmsg = Fmsg + Folmsg
	Fmsgmatch = Fmsgmatch + FolMMsg
	Ffold = Ffold + 1
	If(Fmatch .ne. 0) FFoldMatch = FFoldMatch + 1
*
*	Report if necessary
*
	If(Log) Then
		If(Folmat .ne. 0) Then
		  Call Lib$Signal(MLSEARCH_MATCHEDFOL,
     $                       %val(5),Folder,%val(FolMsg),%Val(FolMmsg),
     $                                  %Val(Folrec),%Val(Folmat))
		Else
		  Call Lib$Signal(MLSEARCH_NOMATCHFOL,
     $                        %val(3),Folder,%Val(Folmsg),%val(Folrec))
		Endif
	Endif
*
*	Zero statistics for next module
*
	Folrec = 0
	Folmat = 0
	Folmsg = 0
	FolMMsg = 0
	Return
	End


	Subroutine File_End(Fstat)
	Implicit None
	Integer FSTAT

	Include 'STATCOM.INC'
	Include 'QUALCOM.INC'
	Include 'FILCOM.INC'

	External MLSEARCH_MATCHED,MLSEARCH_NOMATCH
*-------------------------------------------------------------------------
*
*	Accumulate overall statistics for total things searched and matched.
*
	Totrec = Totrec + Frec
	Totmat = Totmat + Fmatch
	Totmsg = Totmsg + Fmsg
	TotMmat = TotMmat + Fmsgmatch
	TotFolMat = TotFolmat + FFoldmatch
	If(FFoldMatch .ne. 0) TotfMat = Totfmat + 1
	TotFol = TotFol + FFold
	Totfil = Totfil + 1
*
*	We are passed the status code from Mail$....
*	If it is not good, then there were no folders. If it is OK, but
*	Ffold is zero, then there were no matching folders.
*
*	Report if necessary
*
	If(Log) Then
		If(FFoldmatch .ne. 0) Then
		  Call Lib$Signal(MLSEARCH_MATCHED,
     $                          %val(7),Current_File(1:Cfilnaml),
     $    %Val(FFold),%Val(FFoldmatch),%Val(Fmsg),%Val(Fmsgmatch),
     $    %Val(FRec),%Val(FMatch))
		FStat = %Loc(MLSEARCH_MATCHED)
		Else
*
*	Check status codes when there is no match
*
		  Call Lib$Signal(MLSEARCH_NOMATCH,
     $                          %val(4),Current_File(1:Cfilnaml),
     $                             %Val(FFold),%val(Fmsg),%Val(FRec))
		FStat = %Loc(MLSEARCH_NOMATCH)
		Endif
	Endif
*
*	Zero statistics for next file
*
	FRec = 0
	FFold = 0
	Fmsg  = 0
	Fmatch = 0
	Fmsgmatch = 0
	FFoldmatch = 0
	Return
	End

	Subroutine Stat_Rep(Estatus)
*
*	Do final statistics reporting, and any other cleanup necessary.
*	Return final exit status to caller
*
	Implicit None
	Integer EStatus
	Include 'STATCOM.INC'
	Include 'QUALCOM.INC'
	Character*(*) Fmt1,Fmt2,Fmt3,Fmtf
	Parameter (Fmt1 = '(1X,A,T22,I13,T41,A,T61,I10)')
	Parameter (Fmt2 = '(1X,A,T22,I13,T41,A,T58,A)')
	Parameter (Fmt3 = '(1X,A,T22,I13,T41,A,T58,I13)')
	Parameter (Fmtf = '(1X,T16,A,I4,T41,A,1X,I4/)')
	Character*17 CPU,Elapsed
	Character*20 Criteria
	Integer PF,Bio,Dio,Tl
	Integer Tims,Time(2)
	Integer Lib$Stat_Timer,Lib$Sys_Asctim,Lib$Show_VM,Status
	Logical Debuging
	External MLSEARCH_NOMATCHALL,MLSEARCH_NOFILES
	Character*4 Match_type(0:3) /'OR','AND','NAND','NOR'/
*
*	If no files, signal error
*
	If(Totfil .eq. 0) Then
		Call Lib$Signal(MLSEARCH_NOFILES)
		EStatus = %Loc(MLSEARCH_NOFILES)
*
*	If no matches, always report this.
*
	Else If(TotMat .eq. 0) Then
	  Call Lib$Signal(MLSEARCH_NOMATCHALL)
	  EStatus = %Loc(MLSEARCH_NOMATCHALL)
	Else
	  EStatus = 1
	Endif

	If(.Not.Statistics) Return
*
*	They want statistics. Produce a picture like this:
*
*               Files searched:  3       Files matched: 1
*
*Folders searched:               6       Match Criteria:     /MATCH=AND/NOEXACT
*Messages searched:             20       Buffered I/O count:        15
*Records searched:             646       Direct I/O count:           8
*Characters searched:        14424       Page faults:               47
*Folders matched:		 0       Elapsed CPU time:  0 00:00:00.87
*Messages matched:		 0       Elapsed time:      0 00:00:01.45
*Records matched:                0	 Lines printed:              0
*
	Status = Lib$Stat_Timer(3,Bio,Timctx)
	Call StChek(Status)
	Status = Lib$Stat_Timer(4,Dio,Timctx)
	Call StChek(Status)
	Status = Lib$Stat_Timer(5,Pf,Timctx)
	Call StChek(Status)
	Status = Lib$Stat_Timer(2,Tims,Timctx)
	Call StChek(Status)
	Call Lib$Emul(Tims,-100 000,0,Time)
	Status = Lib$Sys_AscTim(Tl,CPU,Time,0)
	Call StChek(Status)
	Criteria = ' /MATCH='//Match_type(Match)
	If(Exact) Then
		Criteria(13:) ='/EXACT'
	Else
		Criteria(13:) ='/NOEXACT'
	Endif

	If(Totfil .ne. 1) Then
	  Write(*,Fmtf) 'Files searched:',Totfil,'Files matched:',TotFmat
	Endif
	Write(*,Fmt2) 'Folders searched:',Totfol,'Match Criteria:',Criteria
	Write(*,Fmt1) 'Messages searched:',Totmsg,'Buffered I/O count:',Bio
	Write(*,Fmt1) 'Records searched:',Totrec,'Direct I/O count:',Dio
	Write(*,Fmt1) 'Characters searched:',TotChr,'Page faults:',Pf

	Write(*,Fmt2) 'Folders matched:',TotFolMat,'Elapsed CPU time:',CPU

	Status = Lib$Stat_Timer(1,Time,Timctx)
	Call StChek(Status)
	Status = Lib$Sys_AscTim(Tl,Elapsed,Time,0)
	Call StChek(Status)
	Write(*,Fmt2) 'Messages matched:',TotMmat,'Elapsed time:',Elapsed
	Write(*,Fmt3) 'Records matched:',Totmat,'Lines printed:',Totout

	If(Debuging()) Then
		Call Srv(Lib$Show_VM())
	Endif
	Return
	End

	Subroutine Stat_Ini
*
*	Initialize statistics
*
	Implicit None
	Integer Status,Lib$Init_Timer
	Include 'STATCOM.INC'

	Totrec = 0
	Totfil = 0
	TotFol = 0
	Totmsg = 0
	TotChr = 0
	TotMat = 0
	TotOut = 0
	TotFmat = 0
	TotFolmat = 0
	TotMmat = 0
	Status = Lib$Init_Timer(TimCtx)
	Call StChek(Status)
	Return
	End

