 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkexit.cD This file contains the exit handler, make_exit(), along with all theD code necessary to trap interrupts and otherwise ensure that the exitC handler will always be called when the program exits.  If this file = is compiled for stand-alone operation (by defining the symbol A AST_STAND_ALONE at compile time) additional code will be included ; to produce a terminal locking program for testing purposes.  */   #include <iodef.h>   #ifdef AST_STAND_ALONE  5 #define ___	0		/* blank value for unused arguments */ . #define PASSLEN	15		/* max size of password */B #define PASSWD	"OK_OK"		/* password required to unlock terminal */# #define ERRSTAT(stat)	(~(stat) & 1)    typedef struct { 	int sd_len; 	char *sd_str; } STR_DESC;    #else    #include "make.h"    #endif   int make_exit();   static int Tt_chan;  static int Oldmask, Ex_stat;4 static int Mask = 0x02000000;		/* LIB$M_CLI_CTRLY */: static int Desblk[4] = { 0, (int)make_exit, 1, &Ex_stat };   #ifdef AST_STAND_ALONE main() { ! 	char *prompt = "\r\nPassword: ";  	char password[PASSLEN + 1];  / 	/* Set up exit handler and CTRL/Y trapping. */   
 	estexhand();   7 	/* Read passwords until the correct one is entered. */    	password[0] = '\0';# 	while (strcmp(password, PASSWD)) {   		printf("\nGet it right!\n\n"); 		getpass(password, prompt); 	}  & 	printf("\nBy Golly you did it.\n\n");4 	printf("About to call exit ... Exit handler?\n\n"); }   , /* Read password guess using no-echo QIO. */   getpass(password, prompt)  char *password, *prompt; { 
 	int stat;	 	struct {  		unsigned short ri_stat;  		unsigned short ri_len; 		unsigned short ri_termstr; 		unsigned short ri_termlen;
 	} read_iosb;    	*password = '\0'; 	stat = sys$qiow( $ 	    ___,			/* default event flag */) 	    Tt_chan,			/* device to read from */ 6 	    IO$_READPROMPT | IO$M_NOECHO, /* function code */6 	    &read_iosb,			/* iosb used to get input length */( 	    ___, ___,			/* no completion AST */: 	    password, PASSLEN,		/* P1, P2; buffer to read into *// 	    ___, ___,			/* P3, P4; no timeout limit */ ; 	    prompt, strlen(prompt));	/* P5, P6; prompt to print */  	if (ERRSTAT(stat)) {  		lib$stop(stat);  	}# 	password[read_iosb.ri_len] = '\0';  }  #endif  = /* This routine initiates CTRL/C and CTRL/Y trapping and sets < up the exit handler routine.  Although CTRL/C and CTRL/Y can: be trapped without setting up an exit handler, this should= not be done, because the exit handler ensures that CTRL/C and > CTRL/Y interrupts will be re-enabled, regardless of the reason  the program eventually exits. */   estexhand()  {  	char ttdev[] = "TT";  	int intr_handler(); 	STR_DESC ttname;     	/* Declare the exit handler. */   	sys$dclexh(Desblk);  . 	/* Tell DCL, "I'll Handle all the CTRL/Ys" */  # 	lib$disable_ctrl(&Mask, &Oldmask);   4 	/* Assign Tt_chan for terminal AST QIOs.  (Also for3 	NOECHO read QIOs if AST_STAND_ALONE is defined. */   # 	ttname.sd_len = sizeof(ttdev) - 1;  	ttname.sd_str = ttdev; ) 	sys$assign(&ttname, &Tt_chan, ___, ___);   4 	/* Enable ASTs to be called on CTRL/C and CTRL/Y */  ) 	catch_intr(IO$M_CTRLCAST, intr_handler); ) 	catch_intr(IO$M_CTRLYAST, intr_handler);  }	  D /* This is the exit handler for make.  Its main purpose is to ensureD that the sub-process which executes makefile commands is killed when2 make exits, and to re-enable CTRL/C and CTRL/Y. */   make_exit()  {  #ifdef AST_STAND_ALONE? 	printf("Exit Handler here ... Enabling CRTL/Y and exiting\n");  #else . 	/* Close command file being built, if any. */   	if (Bldfile != NULL) {  		fclose(Bldfile); 		Bldfile = NULL;  	}   	/* Kill sub-process. */  
 	sub_close();  #endif  @ 	/* Re-enable CTRL/Y trapping by DCL.  This is necessary becauseE 	CTRL/Y trapping affects the process (not just the current image). */     	lib$enable_ctrl(&Oldmask, ___);  - 	/* Turn off exit control for normal exit. */    	sys$canexh(Desblk);   	/* Good-bye. */   	exit(); }   F /* This routine sets up an interrupt handler AST routine.  The routineG can catch CTRL/C's or CTRL/Y's, according to the value of intr_mask. */    static  catch_intr(intr_mask, intr_rout)K int intr_mask;	/* which interrupt, either IO$M_CTRLCAST or IO$M_CTRLYAST */ J int (*intr_rout)();	/* address of routine to call when interrupt occurs */ { 
 	int stat;   	stat = sys$qiow( $ 	    ___,			/* default event flag */) 	    Tt_chan,			/* channel to terminal */ D 	    IO$_SETMODE | intr_mask,	/* function code to catch interrupt */ 	    ___,			/* no iosb */ ( 	    ___, ___,			/* no completion AST */1 	    intr_rout,			/* P1; AST interrupt handler */ 8 	    intr_mask,			/* P2; mask is argument for handler */1 	    3,				/* P3; access mode for AST delivery */ : 	    ___, ___, ___);		/* P4, P5, P6; unused by this QIO */ 	if (ERRSTAT(stat)) {  		lib$stop(stat);  	} }   K /* This routine is called when a CTRL/C or CTRL/Y is pressed.  The argument L is IO$M_CTRLCAST if CTRL/C was pressed, IO$M_CTRLYAST if CTRL/Y was pressed.K Notice that this routine is declared static, so it can't be directly called $ by code outside this source file. */   static intr_handler(intr_mask)  int intr_mask; {  	/* Fix the stack frame. */    	sys$unwind();  3 	/* Re-enable the AST which called this routine. */   % 	catch_intr(intr_mask, intr_handler);   : 	/* Do whatever seems fun in response to the interrupt. */   #ifdef AST_STAND_ALONE" 	if (intr_mask == IO$M_CTRLYAST) {) 		printf("**** Really ouch!!! ****\n\n"); 	 	} else {  		printf("**** Ouch ****\n\n");  	} #else  	sub_zap(); 
 	make_exit();  #endif } 