  M /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *    *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |            PERSONA-DECW           %%   \ @  *                %% |        persona_decw.c  c2003      %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2003 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *  *  * FACILITY: PERSONA_DECW   *L  * ABSTRACT:  This program allows a privileged user to obtain an interactiveN  *            session on behalf of another user.  The privileged user inheritsP  *            the complete environment of the target user including DCL symbols,M  *            PROCESS/JOB/GROUP logical names, process quotas, privileges and K  *            rights identifiers and all environmentals which are set up in )  *            the target user's LOGIN.COM   *  * ENVIRONMENT: User mode   *D  * SECURITY: Install with CMKRNL, DETACH(IMPERSONATE), SYSPRV, WORLD  *$  * Usage:    $ PERSONA_DECW USERNAME  *O  *           PERSONA_DECW (or any chosen name) is defined as a foreign symbol,  8  *           USERNAME is a valid username on the system.G  *           Although no qualifiers are present for remote displays, if F  *           user currently has Decw$Display job logical defined, the I  *           resultant DecTerm will display on the appropriate screen, if 5  *           correct Decw security info is present.     *I  * INFO:     Requires the FTA psuedo terminal driver. PERSONA_DECW  is an F  *           enhancement of the PERSONA utility written by this authorK  *           several years back. Unlike PERSONA, PERSONA_DECW  does not use J  *           a pseudo-terminal, it creates a separate DecTerm window ownedG  *           by the target user. Control of the originating terminal is H  *           then immediately returned to the invoking user, independentJ  *           from the created decterm process. Unlike PERSONA, the createdI  *           DecTerm will be a detached process, the subprocess option is M  *           not available. Otherwise, both tools are functionally identical.   *O  *           Unlike the pseudo-term version, PERSONA_DECW will require the user L  *           to enable DecWindows security on the orignating display system,G  *           entering the username, node and transport. Otherwise, tne  I  *           invoking user will receive an error message stating the user "  *           'can't open display'.  *F  * STYLE:    Everyone has a number of 'style' diffs when using C, mineI  *           shows up with descriptor names. Every descriptor starts with I  *           'Dsc'. A descriptor named 'DscVerb' is global, it is used in I  *           more than one module, and is cross referenced externally as:   *7  *              extern struct dsc$descriptor_s DscVerb;   *G  *           Local descriptors are named as 'Dsc_Cli' and generally are J  *           used within a function. It is possible and acceptable to haveG  *           local descriptors decared in multiple functions within any E  *           given module. Such an example in this code is 'Dsc_User'   *  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h"# #pragma module PERSONA_DECW VERSION   9 #include <stdio.h>          /* Standard IO definitions */ 1 #include <clidef.h>         /* Cli definitions */  #include <climsgdef.h>> #include <descrip.h>        /* Descriptor Definition Macros */? #include <dvidef.h>         /* Device Information item codes */ > #include <impdef.h>         /* persona services definitions */6 #include <iodef.h>          /* I/O Definition codes */D #include <jpidef.h>         /* Job/Process Information item codes */0 #include <prvdef.h>         /* Priv mask defs */8 #include <prcdef.h>         /* Process Creation flags */= #include <ssdef.h>          /* System Service return codes */ 8 #include <string.h>         /* currently for strlen() */@ #include <ttdef.h>          /* basic terminal characteristics */C #include <tt2def.h>         /* extended terminal characteristics */ K #include <uaidef.h>         /* User Authorization Information item codes */ , #include "defs.h"           /* local defs */  ; struct ITEM DviItem[2];     /* Itemlist for $GETDVI info */ < struct ITEM JpiUser[7];     /* Itemlist for invoking user */C struct ITEM UaiItem[15];    /* Itemlist for Target user uaf info */   2 struct IOSB DviIosb;        /* iosb for $GETDVI */2 struct IOSB JpiIosb;        /* iosb for $GETJPI */2 struct IOSB QioIosb;        /* iosb for $QIO(W) */5 struct IOSB TtdIosb;        /* iosb for TT: device */   > struct PQLLIST PqlTbl[15];  /* pql table for target process */  K int  IgnoreId;              /* Ignore identifier checking (undocumented) */ A int  OldPid;                /* process id for original process */ C int  OldTTChar[3];          /* Invoking terminal characteristics */ A int  NewPid;                /* process id for detached process */ A int  NewTTChar[3];          /* Target terminal characteristics */ 6 int  UicBufO;               /* uic of original user */I int  UicBufN;               /* uic of new user (fetched, but not used) */ ; int  UaiFlags;              /* uai flags for target user */ ; int  status;                /* global status return info */ - int  indx;                  /* index value */   5 uint  CurPriv[2];           /* Image process privs */ 7 uint  DefPriv[2];           /* Installed image privs */   8 short CvLen;                /* Length of command verb */; short FlagLen;              /* size in bytes of uaiflags */ G short LogFlag;              /* boolean determines if logging enabled */ L short LogStat;              /* boolean determines if entry log successful */= short OldProt;              /* Protection of orig terminal */  short NameLen;H short NewProt;              /* Protection for terms during this image */1 short PrvLen;               /* size of CurPriv */ M short ResourceFlg;          /* user entered valid resource filespec, maybe */ H short ResourceLen;          /* size of /RESOURCE_FILE qualifier value */? short TtdChan;              /* Channel for original terminal */ ? short TimLen;               /* Length of current time string */ < short UicLen;               /* size of UIC value (UicBuf) */C short UserLen;              /* size of username buffer (NewUser) */   J char CmdVerb[32];           /* foreign symbol used to invoke this image */: char CliStr[80];            /* buffer to store cli info */@ char CurTime[28];           /* buffer for current time string */@ char EscStr[16];            /* clr screen and home cursor str */@ char FtaDev[50];            /* device name of created DecTerm */A char ImgStr[50];            /* image name str for loginout.exe */ 6 char LogFileSpec[80];       /* filespec for logfile */; char NewProcN[18];          /* New invoking process name */ 2 char NewUser[16];           /* Target user name */D char NewUserTrim[14];       /* non padded string for new username */? char OldProcN[18];          /* Process name of invoking user */ 4 char OldUser[16];           /* Invoking user name */@ char OldUserTrim[14];       /* Invoking user name w/o padding */B char PrcName[18];           /* Process name of detached DecTerm */< char ResourceStr[80];       /* filespec for user defaults */2 char TtdName[32];           /* Original TT name */= char display[20];           /* Display name we are viewing */   @ char DispNode[16];          /* Decw display node we are using */M char TransPort[8];          /* Decw display transport (decnet, tcpip, ...) */   = $DESCRIPTOR(DscTT, "TT:");  /* originating terminal device */ K $DESCRIPTOR(DscUserT, NewUserTrim); /* target username string (unpadded) */  $DESCRIPTOR(DscVerb, CmdVerb);  : FILE *logfp;                /* file pointer for logfile */   extern int  lib$get_input();   globalvalue PERSONA_DECW_CLD;   
 int main() { <     int  CliStat;           /* status value for cli calls */@     int  ImpFlags;          /* flags for $PERSONA_CREATE call */     int  ImpHandle; N     int  StsFlg;            /* runtime options for created detached process */  B     char CmdLine[132];      /* buffer reflecting input cmd line */     char LineBuf[132];?     char device_name[50];   /* must be exactly 50 characters */      char *ptr1;      char *ptr2;        short CmdLen;      short DevLen = 0;   (         /* Initialize descriptor list */  K     $DESCRIPTOR(Dsc_Cli, CliStr);       /* cli param or qualifier string */ J     $DESCRIPTOR(Dsc_Cmd, CmdLine);      /* user supplied input cmd line */E     $DESCRIPTOR(Dsc_Fta, FtaDev);       /* FTAn device name string */ F     $DESCRIPTOR(Dsc_Img, ImgStr);       /* image string for $creprc */@     $DESCRIPTOR(Dsc_InpF, "");          /* input for $creprc */ #     $DESCRIPTOR(Dsc_Lbuf, LineBuf); @     $DESCRIPTOR(Dsc_OutF, "");          /* output for $creprc */G     $DESCRIPTOR(Dsc_PrnN, NewProcN);    /* new invoking process name */ K     $DESCRIPTOR(Dsc_Prn, PrcName);      /* detached DecTerm process name */ D     $DESCRIPTOR(Dsc_UserN, NewUser);    /* target username string */K     $DESCRIPTOR(Dsc_Resource, ResourceStr);   /* terminal defaults file */    1     memset(&device_name, 0, sizeof(device_name)); /     sprintf(ImgStr, "SYS$SYSTEM:LOGINOUT.EXE"); *     Dsc_Img.dsc$w_length = strlen(ImgStr);  O     status = GetCmdLine(&Dsc_Cmd, &CmdLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = 0;  3         /* extract foreign cmd verb from CmdLine */   #     sscanf(CmdLine, "%s", CmdVerb);       ptr1 = strchr(CmdVerb, '/');     if(ptr1) *ptr1 = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);  G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */  6     status = lib$get_foreign(&Dsc_Cmd, 0, &CmdLen, 0);*     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0'; %     strcpy(LineBuf, "PERSONA_DECW ");      strcat(LineBuf, CmdLine); ,     Dsc_Lbuf.dsc$w_length = strlen(LineBuf);N     CliStat = cli$dcl_parse(&Dsc_Lbuf, PERSONA_DECW_CLD, lib$get_input, 0, 0);,     if(CliStat != CLI$_NORMAL) exit(status);  >         /* if user typed /HELP then show help text and exit */       strcpy(CliStr,"HELP");9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); $     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowHelp();   @         /* if user typed /VERSION then show versinfo and exit */       strcpy(CliStr, "VERSION");*     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);+     if(CliStat == CLI$_PRESENT) ShowVers();   >         /* if user typed /IGNOREID then set the ignore flag */       strcpy(CliStr, "IGNOREID"); *     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);0     if(CliStat == CLI$_PRESENT) IgnoreId = TRUE;  F         /* if user entered /RESOURCE_FILE then get entered filespec */  $     strcpy(CliStr, "RESOURCE_FILE");*     Dsc_Cli.dsc$w_length = strlen(CliStr);$     CliStat = cli$present(&Dsc_Cli);!     if(CliStat == CLI$_PRESENT) { G         CliStat = cli$get_value(&Dsc_Cli, &Dsc_Resource, &ResourceLen); 8         if(CliStat == 0x0248201) {      /* %STR-S-TRU */N             printf("%%%s-E-STRTOOLONG, /RESOURCE_FILE value length error\n\n",                 CmdVerb);              exit(1);	         }          else {,             ResourceStr[ResourceLen] = '\0';<             Dsc_Resource.dsc$w_length = strlen(ResourceStr);             ResourceFlg = TRUE; 	         }      } 
     else {L         strcpy(ResourceStr, "DECW$USER_DEFAULTS:DECW$TERMINAL_DEFAULT.DAT");8         Dsc_Resource.dsc$w_length = strlen(ResourceStr);     }   7         /* get the target username from command line */   -     strcpy(Dsc_Cli.dsc$a_pointer,"USERNAME"); 9     Dsc_Cli.dsc$w_length = strlen(Dsc_Cli.dsc$a_pointer); ;     CliStat = cli$get_value(&Dsc_Cli, &DscUserT, &UserLen); .     status = str$upcase(&DscUserT, &DscUserT);:     if(CliStat == SS$_NORMAL) NewUserTrim[UserLen] = '\0';:     else {  /* if no username, display message and exit */A         printf("\n%%%s-E-NOUSERID,  Usage Syntax: %s Username\n",              CmdVerb,  CmdVerb); 1         printf("\t(type %s /HELP)\n\n", CmdVerb);          exit(1);     } *     sprintf(NewUser,"%-12s", NewUserTrim);-     Dsc_UserN.dsc$w_length = strlen(NewUser);   K         /* Check the required priv bits for this image. If returned status  F            is SS$_NOTALLPRIV then we exit due to insufficient privs */       status = ChkPriv();      if(status != SS$_NORMAL) {P         printf("%%%s-E-NOTALLPRIV, not all requested privileges authorized\n\n",                 CmdVerb);          exit(1);     }      StsFlg = 0;   6         /* Verify DecTerm is installed, exit if not */       strcpy(FtaDev, "FTA0:");)     DviItem[0].buf_size = strlen(FtaDev); '     DviItem[0].item_code = DVI$_DEVNAM; "     DviItem[0].buf_addr = &FtaDev;"     DviItem[0].buf_len = &NameLen;     DviItem[1].buf_size = 0;     DviItem[1].item_code = 0;   F     status = sys$getdviw(0, 0, &Dsc_Fta, &DviItem, &DviIosb, 0, 0, 0);     if(!(status & 1)) { J         printf("\n%%%s-E-NOSUCHDEV, device FTA0: not found\n\n", CmdVerb);         exit(1);     }   @         /* check if the username really exists on this system */  +     UaiItem[0].buf_size = sizeof(UaiFlags); &     UaiItem[0].item_code = UAI$_FLAGS;$     UaiItem[0].buf_addr = &UaiFlags;     UaiItem[0].buf_len  = 0;*     UaiItem[1].buf_size = sizeof(UicBufN);$     UaiItem[1].item_code = UAI$_UIC;#     UaiItem[1].buf_addr = &UicBufN; "     UaiItem[1].buf_len  = &UicLen;     UaiItem[2].buf_size = 0;     UaiItem[2].item_code = 0;   0     DscUserT.dsc$w_length = strlen(NewUserTrim);<     status = sys$getuai(0, 0, &DscUserT, &UaiItem, 0, 0, 0);9     if (status == RMS$_RNF || status == SS$_NOSUCHUSER) { <         printf("\n%%%s-E-NOSUCHUSER, User %s not found\n\n",&                 CmdVerb, NewUserTrim);         exit(1);     }      if (status == SS$_NORMAL) { '         if (UaiFlags & UAI$M_DISACNT) { M             printf("\n%%%s-E-DISUSER, The UIC record for %s is disabled\n\n", *                     CmdVerb, NewUserTrim);             exit(1);	         }      }      else lib$stop(status);  8         /* get pql info from target user's uaf record */  C     GetPql();       /* if error, GetPql function will call exit  */   /         /* get some info about invoking user */   *     JpiUser[0].buf_size = sizeof(UicBufO);$     JpiUser[0].item_code = JPI$_UIC;#     JpiUser[0].buf_addr = &UicBufO;      JpiUser[0].buf_len  = 0;*     JpiUser[1].buf_size = sizeof(OldUser);)     JpiUser[1].item_code = JPI$_USERNAME; #     JpiUser[1].buf_addr = &OldUser;      JpiUser[1].buf_len  = 0;*     JpiUser[2].buf_size = sizeof(CurPriv);(     JpiUser[2].item_code = JPI$_CURPRIV;#     JpiUser[2].buf_addr = &CurPriv;      JpiUser[2].buf_len  = 0;*     JpiUser[3].buf_size = sizeof(DefPriv);)     JpiUser[3].item_code = JPI$_PROCPRIV; #     JpiUser[3].buf_addr = &DefPriv;      JpiUser[3].buf_len  = 0;)     JpiUser[4].buf_size = sizeof(OldPid); $     JpiUser[4].item_code = JPI$_PID;"     JpiUser[4].buf_addr = &OldPid;     JpiUser[4].buf_len  = 0;+     JpiUser[5].buf_size = sizeof(OldProcN); '     JpiUser[5].item_code = JPI$_PRCNAM; $     JpiUser[5].buf_addr = &OldProcN;#     JpiUser[5].buf_len  = &NameLen;*     JpiUser[6].buf_size = 0;     JpiUser[6].item_code = 0;   <     status = sys$getjpiw(0, 0, 0, &JpiUser, &JpiIosb, 0, 0);'     if(!(status & 1)) lib$stop(status);_  D         /* Verify invoking user is authorized to become target user.D            If not, display error message and exit. Should the IGNOREB            flag be set, have user enter system manager password */       if(IgnoreId) {         status = PwdChk();         if(!(status & 1)) { R             printf("%%%s-E-INVPWD, Invalid password entered for SYSTEM account\n",                     CmdVerb);%             exit(1);	         }      } 
     else {         status = CheckIdent();=         if(status == SS$_NOSUCHID || status == SS$_IVIDENT) { (             ptr1 = strchr(OldUser, ' ');             *ptr1 = '\0'; D             printf("\n\n%%%s-E-NOTAUTH, User %s not authorized to ",&                     CmdVerb, OldUser);<             printf("assume persona of %s\n\n", NewUserTrim);             exit(1);	         }1     }   ;         /* create a copy of OldUser without padding chrs */   !     strcpy(OldUserTrim, OldUser); $     ptr1 = strchr(OldUserTrim, ' ');     if(ptr1) *ptr1 = 0;m  F         /* Find the display device invoking user is utilizing. We alsoD            need to know the transport mechanism being used so we canD            properly format the display string for the new DecTerm */       status = GetDisplayInfo();*     if(status != SS$_NORMAL) exit(status);  %     if(!strcmp(TransPort, "LOCAL")) {n         status = GetNodeName(); .         sprintf(display, "%s::0.0", DispNode);     }iI     if(!strcmp(TransPort, "TCPIP")) sprintf(display, "%s:0.0", DispNode);rK     if(!strcmp(TransPort, "DECNET")) sprintf(display, "%s::0.0", DispNode);   @         /* Perform persona create and assume for new username */  <     ImpFlags = IMP$M_ASSUME_DEFPRIV | IMP$M_ASSUME_DEFCLASS;B     status = sys$persona_create(&ImpHandle, &Dsc_UserN, ImpFlags);'     if(!(status & 1)) lib$stop(status);v  =     ImpFlags = IMP$M_ASSUME_ACCOUNT | IMP$M_ASSUME_JOB_WIDE | %                IMP$M_ASSUME_SECURITY;*6     status = sys$persona_assume(&ImpHandle, ImpFlags);'     if(!(status & 1)) lib$stop(status);e  ?         /* Create the DECterm using the DECwTermPort routine */t  I     status = DECwTermPort(display, ResourceStr, 0, device_name, &DevLen);t     if(status != SS$_NORMAL) {,         printf("DECterm creation failed\n");         lib$stop(status);h     }      ptr1 = ptr2 = &device_name;k     ptr2++;R#     while(*ptr1) *ptr1++ = *ptr2++; 7     memcpy(&FtaDev, &device_name, sizeof(device_name));o     FtaDev[DevLen] = '\0';  >         /* Set of pointer and string length for descriptors */  #     Dsc_InpF.dsc$w_length = DevLen;g)     Dsc_InpF.dsc$a_pointer = device_name;r           /* output to FTAn: */S  #     Dsc_OutF.dsc$w_length = DevLen;w)     Dsc_OutF.dsc$a_pointer = device_name;p  9         /* Write the terminal name and new user to TT: */r  1     printf("\n %s session initiated\n", CmdVerb);h@     printf(" User Info: %s --> %s\n", OldUserTrim, NewUserTrim);'     printf("  Terminal: %s\n", FtaDev);h  E         /* Create the interactive process using the DecTerm terminal.d@            The created process will be INTERactive and DETACHed.>            The NOPASSWORD flag will cause the process to login=            without the 'Username:' and 'Password:' prompts */i  ;     StsFlg = PRC$M_DETACH | PRC$M_INTER | PRC$M_NOPASSWORD;a  <     status = sys$creprc(&NewPid,        /* new process id */E                         &Dsc_Img,       /* descriptor for loginout */o=                         &Dsc_InpF,      /* input - DecTerm */ >                         &Dsc_OutF,      /* output - DecTerm */D                         &Dsc_OutF,      /* error (same as output) */=                         0,              /* mask_privileges */ =                         &PqlTbl,        /* new proc quotas */oK                         0,              /* proc name of detached process */s;                         4,              /* base priority */*=                         0,              /* uic of new user */aI                         0,              /* termination mbx unit number */ F                         StsFlg,         /* process creation options */J                         0,              /* itmlst - reserved by Digital */D                         0);             /* Target node (not used) */  '     if(!(status & 1)) lib$stop(status);o  .         /* write pid of new decterm process */  +     printf("  New Proc: %08X\n\n", NewPid);d  >         /* Delete assumed persona, return to orig environment,#            our work here is done *//  F     ImpFlags = 1;       /* 0x1 says return to original user persona */  1     status = sys$persona_assume(&ImpFlags, 0, 0);c'     if(!(status & 1)) lib$stop(status);s   }(  