L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFDAT              %%   \ @  *                %% |          support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.3-2" #pragma module SUPPORT VERSION    #include <stdio.h> #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <lnmdef.h>  #include <prvdef.h>  #include <psldef.h> A #include <rms.h>                /* Include the RMS definitions */  #include <ssdef.h> #include <stdlib.h>  #include <string.h>     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;    B extern int CliStat;             /* return status from cli calls */D extern int ProcPriv[2];         /* process privs of invoking user */ extern int status;   H extern int BckBinNew[2];        /* quadword value for new Backup date */H extern int CreBinNew[2];        /* quadword value for new Create date */H extern int ExpBinNew[2];        /* quadword value for new Expire date */J extern int RevBinNew[2];        /* quadword value for new Revision date */   H extern int BckBinOld[2];        /* quadword value for old Backup date */H extern int CreBinOld[2];        /* quadword value for old Create date */H extern int ExpBinOld[2];        /* quadword value for old Expire date */J extern int RevBinOld[2];        /* quadword value for old Revision date */   J extern short ChangeFlg;         /* bit flag to indicated values changed */B extern short CliStrLen;         /* length of cli value returned */> extern short DateLen;           /* ascii date string length */F extern short KeepFlg;           /* keep orig time, just change date */: extern short RvnNum;            /* file revision number */   6 extern char Buffer[80];         /* cli value string */7 extern char CliStr[80];         /* cli string buffer */ H extern char CmdVerb[32];        /* foreign symbol invoking this image */L extern char DateStr[28];        /* date string for ascii date to bin date */K extern char LineBuf[132];       /* modified cmdline fed to cli$dcl_parse */     extern char *Ptr;     extern int lib$sig_to_ret(); extern int lib$get_input();  extern void ShowHelp();    & extern struct dsc$descriptor_s DscBuf;& extern struct dsc$descriptor_s DscCli;' extern struct dsc$descriptor_s DscDate;     globalvalue CHFDAT_CLD;     #define BACKUP 1 #define CREATE 2 #define EXPIRE 4 #define REVISE 8 #define REVNUM 16    E #define PRV$M_SYSPRV 0x10000000     /* could just include prvdef.h */ ? #define PRV$M_BYPASS 0x20000000     /* preferred over SYSPRV */       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetDateQualifiersI  * Description: read each command line qualifier, verify it's syntax, and I  *              if it correct convert the value to binary time format and F  *              place the resultant value into the respective quadwordI  *              for that time. Note that the value entered must be in VMS L  *              time string format and enclosed in double quotes. ExceptionsI  *              are the /REVDATE qualifier which if the value is omitted, F  *              will change the revision date to the creation date andF  *              /REVNUM which if the value is omitted, will change the2  *              revision number to the value of 1.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetDateQualifiers() {    "     $DESCRIPTOR(DscLbuf, LineBuf);+     DscLbuf.dsc$w_length = strlen(LineBuf);    G     CliStat = cli$dcl_parse(&DscLbuf, CHFDAT_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);        strcpy(CliStr, "BCKDATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDate, &CliStrLen); #         if(CliStat == SS$_NORMAL) { &             DateStr[CliStrLen] = '\0';3             DscDate.dsc$w_length = strlen(DateStr); 6             status = sys$bintim(&DscDate, &BckBinNew);2             if(status != SS$_NORMAL) exit(status);              ChangeFlg |= BACKUP;	         }      }         strcpy(CliStr, "CREDATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDate, &CliStrLen); #         if(CliStat == SS$_NORMAL) { &             DateStr[CliStrLen] = '\0';!             if(CliStrLen == 22) { 2                 memset(Buffer, 0, sizeof(Buffer));$                 strcat(Buffer, " ");(                 strcat(Buffer, DateStr);(                 strcpy(DateStr, Buffer);
             } 3             DscDate.dsc$w_length = strlen(DateStr); 6             status = sys$bintim(&DscDate, &CreBinNew);2             if(status != SS$_NORMAL) exit(status);              ChangeFlg |= CREATE;	         }      }         strcpy(CliStr, "EXPDATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDate, &CliStrLen); #         if(CliStat == SS$_NORMAL) { &             DateStr[CliStrLen] = '\0';3             DscDate.dsc$w_length = strlen(DateStr); 6             status = sys$bintim(&DscDate, &ExpBinNew);2             if(status != SS$_NORMAL) exit(status);              ChangeFlg |= EXPIRE;	         }      }         strcpy(CliStr, "REVDATE");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { ?         CliStat = cli$get_value(&DscCli, &DscDate, &CliStrLen); #         if(CliStat == SS$_NORMAL) { &             DateStr[CliStrLen] = '\0';!             if(CliStrLen == 22) { 2                 memset(Buffer, 0, sizeof(Buffer));$                 strcat(Buffer, " ");(                 strcat(Buffer, DateStr);(                 strcpy(DateStr, Buffer);
             } 3             DscDate.dsc$w_length = strlen(DateStr); 6             status = sys$bintim(&DscDate, &RevBinNew);2             if(status != SS$_NORMAL) exit(status);              ChangeFlg |= REVISE;	         }          else {E             if(CliStat == 0x381f0) { /* CLI-W-ABSENT, value absent */ @                 memcpy(RevBinNew, CreBinNew, sizeof(CreBinNew));$                 ChangeFlg |= REVISE;
 #ifdef ARFL                 ChangeFlg |= CREATE;    /* can't remeber why this is here */ #endif
             }              else exit(CliStat); 	         }      }         strcpy(CliStr,"REVNUM");7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; "             RvnNum = atoi(Buffer);              ChangeFlg |= REVNUM;	         }          else {O             if(CliStat == 0x381f0) RvnNum = 1; /* CLI-W-ABSENT, value absent */              else exit(CliStat); 	         }      }  }    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *D  * CheckPrv - Verify user running this image has sufficient privs toE  *            succesfully utilize SYS$PARSE and SYS$RENAME functions. E  *            If priv not available then exit with nopriv error code. E  *            SYSPRV is required, BYPASS also works, but is overkill.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckPrv() {      int enabflg = 1;     int prmflg = 0;      int PrvStat;     int PrivMask1 = 0;     int PrivMask2 = 0;     int ProcPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &ProcPriv;     JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;        PrivMask2 |= PRV$M_SYSPRV;     PrivMask1 |= PRV$M_SETPRV;   6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);B     if((ProcPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);!     if(PrivMask1 & ProcPriv[0]) { !         ProcPriv[0] |= PrivMask2; <         PrvStat = sys$setprv(enabflg, &ProcPriv, prmflg, 0);         return(PrvStat);     }      return(SS$_NOPRIV);  }          H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  ShowHelp - Display a brief combination of CHFDAT.README and the cdu H  *             CHFDAT.CLD file. It provides a command line glance at the8  *             optional implementations of CHFDAT usage.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);J     printf("\tApplication which permits a suitably privileged user to\n");E     printf("\tmodify file date, time stamps and revision number.\n"); C     printf("\tPortions of this application are inspired by the\n"); F     printf("\tintent of Joe Meadows' FILE and MODIFY utilities.\n\n");#     printf("     Parameters:\n\n"); H     printf("\t%s requires one parameter, a VMS filename which is the\n",         CmdVerb); G     printf("\tinput file. Currently, VMS wildcards are accepted.\n\n"); #     printf("     Qualifiers:\n\n"); C     printf("\t/BCKDATE - if present, %s will change backup date\n",          CmdVerb); K     printf("\t\t   and time to the specified VMS time value. The input\n"); N     printf("\t\t   string must be in standard VMS time format and MUST be\n");3     printf("\t\t   enclosed in double quotes\n\n"); E     printf("\t/CREDATE - if present, %s will change creation date\n",          CmdVerb); K     printf("\t\t   and time to the specified VMS time value. The input\n"); N     printf("\t\t   string must be in standard VMS time format and MUST be\n");3     printf("\t\t   enclosed in double quotes\n\n"); G     printf("\t/EXPDATE - if present, %s will change expiration date\n",          CmdVerb); K     printf("\t\t   and time to the specified VMS time value. The input\n"); N     printf("\t\t   string must be in standard VMS time format and MUST be\n");3     printf("\t\t   enclosed in double quotes\n\n"); E     printf("\t/REVDATE - if present, %s will change revision date\n",          CmdVerb); K     printf("\t\t   and time to the specified VMS time value. The input\n"); N     printf("\t\t   string must be in standard VMS time format and MUST be\n");P     printf("\t\t   enclosed in double quotes. If datetime value is omitted,\n");F     printf("\t\t   the datetime value from Create will be used.\n\n");G     printf("\t/REVNUM  - if present, %s will change revision number\n",          CmdVerb); M     printf("\t\t   value shown to the value specified. If value omitted,\n"); ?     printf("\t\t   the revision number will be set to 1.\n\n"); K     printf("\t/KEEPTIME - if present, %s will change the date values as\n",          CmdVerb); P     printf("\t\t   specified on the cmdline, but will use the original time\n");P     printf("\t\t   value. This qualifier is valid only for the /CREDATE and\n");2     printf("\t\t   the /REVDATE qualifiers.\n\n");/     printf("\t/HELP - Displays this text\n\n"); =     printf("\t/VERSION - %s displays version, build date,\n",          CmdVerb); E     printf("\t\t   and required privs for VMS Install utility.\n\n");      exit(1); }       N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedK  *              equivalence string. Only the current JOB logical name table D  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used to L  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ & int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */ K     int eqvattrb = 0;               /* returned attributes of eqv string */      int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;<     char acmode;                    /* requires exec mode */<     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[80];                /* logical name equivalence string */    >     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   <     acmode = PSL$C_EXEC;            /* requires exec mode */'     memset(&LnmEqv, 0, sizeof(LnmEqv));      strcpy(LnmDef, lnmstr);       strcpy(LnmTable, "LNM$JOB");   /     dsc_tabnam.dsc$w_length = strlen(LnmTable); -     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);    %     lnmitm[0].len = sizeof(eqvattrb); %     lnmitm[0].code = LNM$_ATTRIBUTES; !     lnmitm[0].bufadr = &eqvattrb;      lnmitm[0].retlen = 0; %     lnmitm[1].len = sizeof(LnmTable);       lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;       lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv); !     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;    N     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {          LnmEqv[eqv_len] = '\0'; !         LnmTable[tbl_len] = '\0'; 4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);      } 8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);  }       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.   *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */*A int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)% {%<     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0; @     short   *Lptr = 0;      /* pointer to callers length word */        int     BufSize;     int     RecallAddr = 0;*     int     ppd = 0;     int     prc = 0;!     int     retstat = SS$_NORMAL; A     int     *Iptr = 0;      /* integer pointer for indirection */   %D         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */  28     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */oA     Iptr = RecallAddr;              /* pseudo pointer register */"     RecallAddr = *Iptr;c0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */   A         /* here we use recall allocation to determine the size of*B            the recall buffer length field, changed at vms 7.3.2 */  NE     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */i?     else RecallAddr--;              /* else length is 8 bits */i     Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;   B         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */  $     if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */          else {             *length = -1; "             return(SS$_BUFFEROVF);	         }p     } 2     else *length = *Sptr;       /*  8 bit value */  kC         /* get buffer length and copy cmd line to callers buffer */t  e     Sptr -= *length;!     strncpy(Dptr, Sptr, *length);/     return(SS$_NORMAL);; }      qH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: FixupDatesnF  * Description: This routine is called when the command line specifiesD  *              the /KEEPTIME qualifier plus the /CREDATE and/or theG  *              /REVDATE qualifiers (with values provided). It uses the J  *              date value provided, but inserts the time from the current  *              value:E  *           $ chfdat BUILD.COM /keep /revd="20-AUG-2002 08:15:34.27"   *           BUILD.COM;1K  *            Revision Date: 27-FEB-2003 08:15:42 ---> 20-AUG-2002 08:15:42   *           $  *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */d void FixupDates()t {n     char OldStr[24];     char NewStr[24];=     char *ToldPtr = 0;      /* pointer to orig time string */e<     char *TnewPtr = 0;      /* pointer to new time string */         $DESCRIPTOR(DscOld, OldStr);      $DESCRIPTOR(DscNew, NewStr);  a     if(ChangeFlg & CREATE) {>         status = sys$asctim(&DateLen, &DscOld, &CreBinOld, 0);>         status = sys$asctim(&DateLen, &DscNew, &CreBinNew, 0);         ToldPtr = &OldStr + 12;g         TnewPtr = &NewStr + 12;p!         strcpy(TnewPtr, ToldPtr); 1         status = sys$bintim(&DscNew, &CreBinNew);r     }$     if(ChangeFlg & REVISE) {>         status = sys$asctim(&DateLen, &DscOld, &RevBinOld, 0);>         status = sys$asctim(&DateLen, &DscNew, &RevBinNew, 0);         ToldPtr = &OldStr + 12;          TnewPtr = &NewStr + 12; !         strcpy(TnewPtr, ToldPtr);*1         status = sys$bintim(&DscNew, &RevBinNew);d     }Y }V      