   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               CHFDAT              %%   \ @  *                %% |          chfdate.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *>  *  Copyright (C) 2003,2004 Lyle W. West, All Rights Reserved.J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *8  *  Application which permits a suitably priv'ed user toB  *  modify file dates, time stamps and revision number. Ideally, aJ  *  'perfect' editor would always maintain the original creation date of aJ  *  within a given file system. This should also be an option for the COPY<  *  command and probably others,  but alas this is not true.F  *  Portions of this application are inspired by the objectives of Joe  *  Meadows FILE utility.   *L  *  CHFDAT has been designed as a system management tool and is not intendedI  *  to be accessed by general users. As described below, certain priv are I  *  required to succesfully execute CHFDAT. Additionally, if the image is J  *  located where global access is available, it is prudent for the sysmgr   *  to have trusted users enter:  *,  *      DEFINE /JOB /EXEC SECURE_LNM ENABLED  *I  *  prior to attempting execution. Note that this information is not doc- H  *  umented elsewhere. This is a poor mans substitute for an identifier.F  *  See the source code (search for '#define SECURE'). Note also, thisH  *  must be defined as an executive mode logical. There may be some userI  *  with the ability to determine the need for this logical to be defined B  *  on the JOB table, but not be able to define it with EXEC priv.  *K  *  Online help is available only after the foreign symbol is defined; From   *  DCL simply enter:   *  *      CHFDAT /HELP  *  *  Usage Examples:   *B  *      $ chfdate CHFDAT_CLD.OBJ /revd="20-FEB-2002 20:02:20.02" -)  *      _$ /cre="20-FEB-2002 20:02:20.02"   *C  *      Target: DKA100:[LWW.SOURCE.TOOLS.LWW.CHFDAT]CHFDAT_CLD.OBJ; L  *       Creation Date: 15-MAR-2002 02:16:04      --->  20-FEB-2002 20:02:20P  *       Revision Date: 15-MAR-2002 02:16:04 (1)  --->  20-FEB-2002 20:02:20 (1)  *  *  -- or --  *9  *      $ chfdate *.obj /revd="20-feb-2002 20:02:20.02" - )  *      _$ /cre="20-feb-2002 20:02:20.02"   *?  *      Target: DKA100:[LWW.SOURCE.TOOLS.LWW.CHFDAT.WORK]*.OBJ;   *      CHFDAT.OBJ;5L  *       Creation Date: 15-MAR-2002 23:45:30      --->  20-FEB-2002 20:02:20P  *       Revision Date: 15-MAR-2002 23:45:39 (1)  --->  20-FEB-2002 20:02:20 (1)  *      CHFDAT_CLD.OBJ;4L  *       Creation Date: 20-FEB-2002 20:02:20      --->  20-FEB-2002 20:02:20P  *       Revision Date: 20-FEB-2002 20:02:20 (1)  --->  20-FEB-2002 20:02:20 (1)  *      SUPPORT.OBJ;2 L  *       Creation Date: 15-MAR-2002 13:20:27      --->  20-FEB-2002 20:02:20P  *       Revision Date: 15-MAR-2002 13:20:34 (1)  --->  20-FEB-2002 20:02:20 (1)  *	  *      $   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.3-2" #pragma module CHFDAT VERSION     #include <stdio.h> #include <atrdef.h>  #include <ctype.h> #include <climsgdef.h> #include <dvidef.h>  #include <descrip.h> #include <fibdef.h>  #include <iodef.h> #include <lib$routines.h>  #include <rms.h> #include <ssdef.h> #include <starlet.h> #include <stdlib.h>  #include <string.h>    : int CliStat;            /* return status from cli calls */@ int RmsStat;            /* status value returned by RMS calls */0 int ownuic;             /* currently not used */@ int status;             /* status value returned by SYS calls */   @ int BckBinNew[2];       /* quadword value for new Backup date */@ int CreBinNew[2];       /* quadword value for new Create date */@ int ExpBinNew[2];       /* quadword value for new Expire date */B int RevBinNew[2];       /* quadword value for new Revision date */   @ int BckBinOld[2];       /* quadword value for old Backup date */@ int CreBinOld[2];       /* quadword value for old Create date */@ int ExpBinOld[2];       /* quadword value for old Expire date */B int RevBinOld[2];       /* quadword value for old Revision date */   < int ProcPriv[2];        /* process privs of invoking user */  A int BckTmp[2];          /* quadword value for temp Backup date */ A int CreTmp[2];          /* quadword value for temp Create date */ A int ExpTmp[2];          /* quadword value for temp Expire date */ C int RevTmp[2];          /* quadword value for temp Revision date */    G short ChangeFlg;        /* bit flag to indicated date values changed */ 7 short Channel;          /* I/O channel to input file */ : short CliStrLen;        /* length of cli value returned */6 short DateLen;          /* ascii date string length */> short KeepFlg;          /* keep orig time, just change date */; short Iosb[4];          /* I/O status block for SYS$QIOW */ 5 short RvnNum;           /* new file revision value */ 5 short RvnOld;           /* old file revision value */ 6 short RvnTmp;           /* temp file revision value */   . char Buffer[80];        /* cli value string *// char CliStr[80];        /* cli string buffer */ A char CmdVerb[32];       /* foreign command inviking this image */ D char DateStr[28];       /* date string for ascii date to bin date */0 char DevName[32];       /* target disk device */J char InputFile[80];     /* input file name from dcl (may be wildcarded) */C char LineBuf[132];      /* modified cmdline fed to cli$dcl_parse */ 2 char NewDate[28];       /* modified date string */2 char OldDate[28];       /* original date string */@ char WorkFile[80];      /* resultant filename from sys$search */
 char *Ptr;    #define BACKUP 1 #define CREATE 2 #define EXPIRE 4 #define REVISE 8 #define REVNUM 16    I #define DEV$M_SWL 0x2000000         /* device is software write locked */     #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif    #ifdef ISO96602 struct { short size, type; long address; } Atr[8]; #else 2 struct { short size, type; long address; } Atr[6]; #endif    struct FAB PsFab;  struct NAM PsNam;  struct fibdef Fib;   7 struct {short len, code; int *buf, *retlen;} DviItm[2];    F $DESCRIPTOR(DscBuf, Buffer);    /* string returned by cli$get_value */C $DESCRIPTOR(DscCli, CliStr);    /* cli param or qualifier string */ ; $DESCRIPTOR(DscDate, DateStr);  /* date input descriptor */ < $DESCRIPTOR(DscDev, DevName);   /* device name descriptor */5 $DESCRIPTOR(DscWork, WorkFile); /* target filename */ : $DESCRIPTOR(DscOld, OldDate);   /* original date string */: $DESCRIPTOR(DscNew, NewDate);   /* modified date string */    globalvalue CHFDAT_CLD;     extern int CheckPrv();  extern void GetDateQualifiers(); extern void ShowVers();  extern void ShowHelp();      L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  main routineM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int main() { J     char CmdLine[132];              /* buffer reflecting input cmd line */     char *ptr;        int searchcnt = 0;     int first = TRUE;      int devchar;     int wildinfile = FALSE;         short CmdLen; @     short CvLen;                    /* Length of command verb */   N     $DESCRIPTOR(DscFib, (char *)&Fib); /* NOTE: this is not your normal dsc */"     $DESCRIPTOR(DscLbuf, LineBuf);!     $DESCRIPTOR(DscCmd, CmdLine); F     $DESCRIPTOR(DscVerb, CmdVerb);  /* foreign invoking symbol name */   @     char PsEsa[NAM$C_MAXRSS];      /* parse expanded filename */B     char PsRsa[NAM$C_MAXRSS];      /* search resultant filename */     char enable_lnm[32];        DviItm[0].len    = 4; $     DviItm[0].code   = DVI$_DEVCHAR;=     DviItm[0].buf    = &devchar;   /* disk characteristics */      DviItm[0].retlen = 0;      DviItm[1].len    = 0;      DviItm[1].code   = 0;    '     DscFib.dsc$w_length = FIB$C_LENGTH;       @         /* define the security logical name, even if not used */   %     strcpy(enable_lnm, "SECURE_LNM");    <         /* get the command line used to invoke this image */   M     status = GetCmdLine(&DscCmd, &CvLen);  /* get invoking foreign cmd str */ *     if(status != SS$_NORMAL) exit(status);     CmdLine[CvLen] = 0;    3         /* extract foreign cmd verb from CmdLine */    $     sscanf(CmdLine, "%s", &CmdVerb);     ptr = strchr(CmdVerb, '/');      if(ptr) *ptr = '\0';+     DscVerb.dsc$w_length = strlen(CmdVerb); ,     status = str$upcase(&DscVerb, &DscVerb);   G         /* get parameter and qualifier(s) from command line, prefix the L            CLD declared verb and use CLI$DCL_PARSE to build the cmd table */   5     status = lib$get_foreign(&DscCmd, 0, &CmdLen, 0); *     if(status != SS$_NORMAL) exit(status);     CmdLine[CmdLen] = '\0';      strcpy(LineBuf, "CHFDAT ");      strcat(LineBuf, CmdLine); +     DscLbuf.dsc$w_length = strlen(LineBuf); G     CliStat = cli$dcl_parse(&DscLbuf, CHFDAT_CLD, lib$get_input, 0, 0); ,     if(CliStat != CLI$_NORMAL) exit(status);   C         /* check for presence of qualifiers which are not dependant (            on additional input values */        strcpy(CliStr, "VERSION");)     DscCli.dsc$w_length = strlen(CliStr); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowVers();         strcpy(CliStr, "HELP"); 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); +     if(CliStat == CLI$_PRESENT) ShowHelp();    I         /* if we get here (we would not if either of the above qualifiers I            were entered, as they call sys$exit at the conclusion of their K            respective function calls) then check for and process input file 2            parameter if it is present and valid */   D     strcpy(CliStr, "KEEPTIME");     /* see ShowHelp() or CLD file */7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); /     if(CliStat == CLI$_PRESENT) KeepFlg = TRUE;    C     strcpy(CliStr, "INFILE");       /* get the file(s) to modify */ 7     DscCli.dsc$w_length = strlen(DscCli.dsc$a_pointer); #     CliStat = cli$present(&DscCli); !     if(CliStat == CLI$_PRESENT) { >         CliStat = cli$get_value(&DscCli, &DscBuf, &CliStrLen);#         if(CliStat == SS$_NORMAL) { %             Buffer[CliStrLen] = '\0'; D             strcpy(InputFile, Buffer);    /* input file to change */-             DscWork.dsc$w_length = CliStrLen; 	         }      } C     else                 /* INFILE not specified on command line */ >         exit(0x381F2);   /* exit with %CLI-W-ABSENT message */   H         /* Check that we are executing in somewhat secure environment */    #ifdef SECUREP     status = CheckSecure(); C     if(status != SS$_NORMAL) exit(0x2764); /* %SYSTEM-F-AUTHFAIL */  #else 
 #ifdef SECURE L     /* we call 'CheckLnm' with the address of the job logical name to check.C        If the return status is SS$_NORMAL, then the logical does in F        fact exist and the pointer address now contains the equivalenceG        string of the logical. We then verify this string is what we are K        are expecting and react appropriately. Note that if this test fails, J        the user only receives a AUTHFAIL message for security purposes. */   K         /* Some notes about error messages from the next few lines of code: J             W-AUTHFAIL - indicates logical IS defined, but the equivalenceC                          string is defined incorrectly (lowercase?) I             F-AUTHFAIL - Indicates the logical name is not defined in the E                          user's LNM$JOB table or wrong access mode */    7     status = CheckLnm(&enable_lnm, sizeof(enable_lnm)); K     if(status == SS$_NORMAL) {  /* this says logical defined to some str */ M         if(strcmp(enable_lnm, "ENABLED") != 0) { /* must match this string */ J             exit(0x2760);  /* %SYSTEM-W-AUTHFAIL, authorization failure */	         }      } J     else exit(0x2764);     /* %SYSTEM-F-AUTHFAIL, authorization failure */ #endif      /* SECURE */ #endif      /* SECUREP */    A         /* initialize ACP-QIO Attributes structure. This itemlist B            is used for get and put of datetime values without ever(            opening the target file(s) */   $     Atr[0].size = sizeof(CreBinNew);      Atr[0].type = ATR$C_CREDATE;      Atr[0].address = &CreBinNew;$     Atr[1].size = sizeof(RevBinNew);      Atr[1].type = ATR$C_REVDATE;      Atr[1].address = &RevBinNew;$     Atr[2].size = sizeof(ExpBinNew);      Atr[2].type = ATR$C_EXPDATE;      Atr[2].address = &ExpBinNew;$     Atr[3].size = sizeof(BckBinNew);      Atr[3].type = ATR$C_BAKDATE;      Atr[3].address = &BckBinNew;!     Atr[4].size = sizeof(RvnNum); !     Atr[4].type = ATR$C_ASCDATES;      Atr[4].address = &RvnNum;  #ifdef ISO9660!     Atr[5].size = sizeof(EffBin); B     Atr[5].type = ATR$C_EFFDATE;        /* ISO 9660 Backup Date */     Atr[5].address = &EffBin; D     Atr[6].size = sizeof(RcdBin);       /* ISO 9660 Recorded Date */      Atr[6].type = ATR$C_RCDDATE;     Atr[6].address = &RcdBin;      Atr[7].size = 0;     Atr[7].type = 0;     Atr[7].address = 0;  #else      Atr[5].size = 0;     Atr[5].type = 0;     Atr[5].address = 0;  #endif      /* ARF */       3         /* check for presence of SYSPRV priv bit */    0     status = CheckPrv();            /* sysprv */*     if(status != SS$_NORMAL) exit(status);   1         /* initialize PsFab & PsNam structures */         PsFab = cc$rms_fab; !     PsFab.fab$l_fna = &InputFile; (     PsFab.fab$b_fns = strlen(InputFile);K     PsFab.fab$l_nam = &PsNam;               /* FAB has an associated NAM */      PsNam = cc$rms_nam; P     PsNam.nam$l_esa = &PsEsa;               /* sys$parse Expanded string area */A     PsNam.nam$b_ess = sizeof(PsEsa);        /* esa buffer size */ R     PsNam.nam$l_rsa = &PsRsa;               /* sys$search Resultant string area */A     PsNam.nam$b_rss = sizeof(PsRsa);        /* rsa buffer size */             /* perform sys$parse */         status = sys$parse(&PsFab); +     if(status != RMS$_NORMAL) exit(status); "     PsEsa[PsNam.nam$b_esl] = '\0';   F         /* if this is a wildcard operation set a flag to change how weD            deal with certain operations already performed during the%            'first file' processing */    E     if(strrchr(PsEsa, '*') || strrchr(PsEsa, '%')) wildinfile = TRUE; J     printf("\nTarget: %s\n", PsEsa);   /* display command line filename */   I         /* Before we go any deeper, the rest of the code is irrelevant if J          * we can't change anything because this is a readonly device. GetM          * the device name. use $GETDVI to check, then exit if not writeable. E          * If DVI$M_SWL is clear, then assign a channel to the device           */    -         memset(&DevName, 0, sizeof(DevName)); ;         strncpy(DevName, PsNam.nam$l_dev, PsNam.nam$b_dev); 1         DscDev.dsc$w_length = PsNam.nam$t_dvi[0]; A         status = sys$getdviw(0, 0, &DscDev, &DviItm, 0, 0, 0, 0); .         if(status != SS$_NORMAL) exit(status);.         if(devchar & DEV$M_SWL) exit(0x182ba);             /* perform sys$search */   ?     while((status = sys$search(&PsFab, 0, 0)) == RMS$_NORMAL) { C         PsRsa[PsNam.nam$b_rsl] = '\0';       /* convert to ASCIZ */ H         Ptr = strchr(PsRsa, ']');          /* point past dev/dir info */         Ptr++;D         strcpy(WorkFile, Ptr);              /* save filename info */0         DscWork.dsc$w_length = strlen(WorkFile);)         DscWork.dsc$a_pointer = WorkFile;*         searchcnt++;  %         if(first) {%9             status = sys$assign(&DscDev, &Channel, 0, 0);_2             if(status != SS$_NORMAL) exit(status);	         }    D             /* clear the entire Fib structure so wildcard operationsD                do not relect Fib values from a previous file. We areD                in fact inside a 'while' loop, even if we are working"                on just one file */   %         memset(&Fib, 0, sizeof(Fib));    <             /* init the Fib structure, only need file id and=                directory id fields filled in from PsNam block ,                following successful $PARSE*/   4             /* copy the file ID from PsNam to Fib */   /         Fib.fib$w_fid_num = PsNam.nam$w_fid[0];_/         Fib.fib$w_fid_seq = PsNam.nam$w_fid[1];o/         Fib.fib$w_fid_rvn = PsNam.nam$w_fid[2];s  e9             /* copy the directory ID from PsNam to Fib */s  o/         Fib.fib$w_did_num = PsNam.nam$w_did[0];,/         Fib.fib$w_did_seq = PsNam.nam$w_did[1];p/         Fib.fib$w_did_rvn = PsNam.nam$w_did[2];s  h>             /* issue QIOW with IO$_ACCESS to fill the itemlist@                in the Atr structure. This does not open the fileJ                so does not change the revision info to current datetime */  s>         status = sys$qiow(0, Channel, IO$_ACCESS, &Iosb, 0, 0,8                       &DscFib, &DscWork, 0, 0, &Atr, 0);.         if(status != SS$_NORMAL) exit(status);         status = Iosb[0];b.         if(status != SS$_NORMAL) exit(status);  sB             /* save all timestamps with their respective values atG                image activation. This will be the old time(s) displayedn%                prior to image exit */c  s:         memcpy(&BckBinOld, &BckBinNew, sizeof(BckBinOld));:         memcpy(&CreBinOld, &CreBinNew, sizeof(CreBinOld));:         memcpy(&ExpBinOld, &ExpBinNew, sizeof(ExpBinOld));:         memcpy(&RevBinOld, &RevBinNew, sizeof(RevBinOld));1         memcpy(&RvnOld, &RvnNum, sizeof(RvnOld));L            GetDateQualifiers();         first = FALSE;  o         if(ChangeFlg == 0) {F             printf("\n%%CHFDAT-W-NOCHANGE, no changes made to %s\n\n",                 WorkFile);             exit(1);	         }h   !         if(KeepFlg) FixupDates();   eO         if(wildinfile) printf("%s\n", WorkFile);    /* only for wildcard ops */t   I             /* Use the IO$_MODIFY function to change info about the file.wN                Note, used this way, the file is not opened, however this wouldO                normally cause the expiration and revision dates to be modified. L                Setting FIB$M_NORECORD prevents this from occuring. Note thatJ                this bit is cleared by IO$_MODIFY before saving header infoH                and also the channel connection is severed, which negatesG                the need for a subsequent IO$_DEACCESS QIOW operation */e  5*         Fib.fib$l_acctl |= FIB$M_NORECORD;  :>         status = sys$qiow(0, Channel, IO$_MODIFY, &Iosb, 0, 0,<                           &DscFib, &DscWork, 0, 0, &Atr, 0);.         if(status != SS$_NORMAL) exit(status);         status = Iosb[0]; .         if(status != SS$_NORMAL) exit(status);  M?             /* finally, we display the changes which is usuallyo8                makes the user feel all warm and fuzzy */  (          if(ChangeFlg & CREATE) {B             status = sys$asctim(&DateLen, &DscOld, &CreBinOld, 0);B             status = sys$asctim(&DateLen, &DscNew, &CreBinNew, 0);K             printf(" Creation Date: %s      --->  %s\n", OldDate, NewDate);0	         }              if(ChangeFlg & REVISE) {B             status = sys$asctim(&DateLen, &DscOld, &RevBinOld, 0);B             status = sys$asctim(&DateLen, &DscNew, &RevBinNew, 0);>             printf(" Revision Date: %s (%d)  --->  %s (%d)\n",6                     OldDate, RvnOld, NewDate, RvnNum);	         }u  <          if(ChangeFlg & EXPIRE) {B             status = sys$asctim(&DateLen, &DscOld, &ExpBinOld, 0);B             status = sys$asctim(&DateLen, &DscNew, &ExpBinNew, 0);I             printf("   Expire Date: %s  --->  %s\n\n", OldDate, NewDate);b	         }u  <          if(ChangeFlg & BACKUP) {B             status = sys$asctim(&DateLen, &DscOld, &BckBinOld, 0);B             status = sys$asctim(&DateLen, &DscNew, &BckBinNew, 0);G             printf("   Backup Date: %s  --->  %s\n", OldDate, NewDate); 	         }/   /     }       /* while sys$parse == ss$_normal */e  a:     if(!searchcnt) printf(" Target filespec not found\n");     printf("\n"); !     status = sys$dassgn(Channel);  }u  o  eH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *B  *  ShowVers - displays current installed version, build date, andB  *             required privs for interactive usage and/or the VMS  *             install utility.*  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowVers()d { 1     printf("\n\t\t%s by Lyle W West\n", CmdVerb); F     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");   p #ifdef SECUREP7     printf("\t\tRequired Privs: SYSPRV [SecureP]\n\n");r #else*
 #ifdef SECURE26     printf("\t\tRequired Privs: SYSPRV [Secure]\n\n"); #elseh-     printf("\t\tRequired Privs: SYSPRV\n\n");d #endif      /* SECURE */ #endif      /* SECUREP */O     exit(1); } 