I {************************************************************************  *									* # *  J U M P -- JUMP_POKER.PAS						*  *									* H *  JUMP_POKER changes process characteristics by directly manipulating	*- *  privileged system process structures.				*  *									* I *-----------------------------------------------------------------------* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* / *  JUMP requires the following privileges:				* < *	CMEXEC, CMKRNL, DETACH (or IMPERSONATE), SYSNAM, SYSPRV 	* *									* G *  INSTALL JUMP with these privileges if non-privileged users will be	*  *  running JUMP.							* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *-----------------------------------------------------------------------*  *									* F *  ***	CAUTION: JUMP has dependencies on the underlying architecture	*@ *  ***		 (VAX, Alpha or IA64) and the version of OpenVMS.  Any	*; *  ***		 changes to either of these *REQUIRES* JUMP to be	*  *  ***		 re-linked.						* *									* I ************************************************************************* / *  Author and Maintainer: Jonathan Ridler.				*  *									* C *  This software is owned and maintained privately by the author,	* F *  Jonathan Ridler. It is NOT in any way produced, owned, supported,	*D *  maintained or endorsed by Hewlett Packard Pty Ltd or any of its	* *  legal entities.							* *									* ( *  Email: vmsjump@internode.on.net					*I ************************************************************************* I *************************************************************************  ***								      ***$ ***			    LICENCE NOTICE			      *** ***								      ***H ***  This software is COPYRIGHT (c) 1993-2012 Jonathan Ridler.	      ***' ***  ALL RIGHTS RESERVED.					      ***  ***								      ***G ***  Please READ the file JUMP_LICENCE.TXT which contains the	      *** C ***  complete Licence and all conditions of use for JUMP.	      ***  ***								      ***I ************************************************************************* I *************************************************************************  *									*  *  History:								*4 *	01-Feb-2012	JER	Original version for JUMP V6.0. 	*0 *	03-Feb-2012	JER	JUMP V6.1; Support for VAX.		*: *	21-Feb-2012	JER	JUMP V6.1a; Fix crud in username spec;	* *				Add build level ident.			* I ************************************************************************}     [INHERIT ('SYS$LIBRARY:STARLET',& 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES')]   MODULE Jump_Poker ;    CONST   L { The effective length of a username is 12 characters. However, the internalE   fields are 32 characters.  Use 12 characters as the maximum length.   K   ENSURE the constant is identical in the JUMP, JUMP_POKER and JUMP_PERSONA 
   modules!  }    Max_Username_Len = 12 ;    TYPE   Debug_Mask = RECORD  	       CASE INTEGER OF ? 	       1: (All_Bits : UNSIGNED ;) ;    { 32 bits - roomy! :) } C 	       2: (Info     : [BIT, POS(0)]  BOOLEAN ;	   { General Info } = 		   D1	    : [BIT, POS(1)]  BOOLEAN ;	   { Diagnostic info } = 		   D2	    : [BIT, POS(2)]  BOOLEAN ;	   { Diagnostic info } = 		   D3	    : [BIT, POS(3)]  BOOLEAN ;	   { Diagnostic info } = 		   D4	    : [BIT, POS(4)]  BOOLEAN ;	   { Diagnostic info } = 		   D5	    : [BIT, POS(5)]  BOOLEAN ;	   { Diagnostic info } = 		   D6	    : [BIT, POS(6)]  BOOLEAN ;	   { Diagnostic info } = 		   D7	    : [BIT, POS(7)]  BOOLEAN ;	   { Diagnostic info } = 		   D8	    : [BIT, POS(8)]  BOOLEAN ;	   { Diagnostic info } = 		   D9	    : [BIT, POS(9)]  BOOLEAN ;	   { Diagnostic info } > 		   X1	    : [BIT, POS(11)] BOOLEAN ;	   { Change execution }> 		   X2	    : [BIT, POS(12)] BOOLEAN ;	   { Change execution }> 		   X3	    : [BIT, POS(13)] BOOLEAN ;	   { Change execution }> 		   X4	    : [BIT, POS(14)] BOOLEAN ;	   { Change execution }> 		   X5	    : [BIT, POS(15)] BOOLEAN ;	   { Change execution }> 		   X6	    : [BIT, POS(16)] BOOLEAN ;	   { Change execution }> 		   X7	    : [BIT, POS(17)] BOOLEAN ;	   { Change execution }> 		   X8	    : [BIT, POS(18)] BOOLEAN ;	   { Change execution }? 		   X9	    : [BIT, POS(19)] BOOLEAN ;) ;  { Change execution }  	     END ;   % Unsigned_Ptr = [VOLATILE] ^UNSIGNED ;   < Username_Type = PACKED ARRAY [1..Max_Username_Len] OF CHAR ;   VAR   I {************************************************************************ I  ****  INCREMENT the BUILD LEVEL every time the module is changed!!  **** J  ************************************************************************}  5 Poker_Bl : [GLOBAL] VARYING [12] OF CHAR := '1.009' ;   ; Orig_User : [EXTERNAL] VARYING [Max_Username_Len] OF CHAR ; ! Orig_Uic  : [EXTERNAL] UIC$TYPE ; 9 New_User  : [VOLATILE] VARYING [Max_Username_Len] OF CHAR ' 			  := PAD ('',' ',Max_Username_Len) ;   H { If the PSB is implemented and the system parameter ARB_SUPPORT has theI   value ISS$C_ARB_FULL (= 3), the PSB data will be overwritten by data in L   the obsolete data cells which the PSB replaces.  In this case, also update   the obsolete cells. }   A Psb_Available , 		{ OpenVMS V7.2+ ? ==> Persona Security Block! } < Arb_Full_Support		{ Access Rights Block: ARB_SUPPORT = 3 ? } : [VOLATILE,EXTERNAL] BOOLEAN ;   + Sanity_Ctl_User ,					{ For CMKRNL checks } + Sanity_Psb_User ,					{ For CMKRNL checks } H Sanity_Jib_User : [VOLATILE] Username_Type := '' ;	{ For CMKRNL checks }   Psb_User_Ptr ,< Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  	 Psb_Ptr , 	 Jib_Ptr , 
 Psb_Uic_Ptr , 
 Jib_Uic_Ptr ,  Uic_Ptr : Unsigned_Ptr := NIL ;   0 Bugger : [EXTERNAL] Debug_Mask ;	{ Debug flags }  1 Dbgfile : [EXTERNAL] TEXT ;	{ Debug output file }   D { The values "Jump__*" are condition codes used exclusively by JUMP.<   Details can be found in the Message file (JUMP_MSG.MSG). }   Jump__Insaneuic ,  Jump__Insaneuser : [EXTERNAL,VALUE] UNSIGNED ;   A { Some system and compiler-related values not found in STARLET. }    PCB$L_JIB ,  PCB$L_UIC ,  PCB$AR_NATURAL_PSB , PSB$L_UIC ,  PSB$T_USERNAME , JIB$T_USERNAME : [EXTERNAL,VALUE] UNSIGNED ;   
 CTL$GL_PCB : [EXTERNAL] UNSIGNED ;   4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;      PROCEDURE Getmem (VAR Location ,2 		  Pointer  : [UNSAFE] Unsigned_Ptr) ; EXTERNAL ;    PROCEDURE Putmem (VAR Location ,2 		  Pointer  : [UNSAFE] Unsigned_Ptr) ; EXTERNAL ;    . [ASYNCHRONOUS,Check(None)] PROCEDURE Getuser ;  H { In EXEC MODE, peek at the Username either in the PSB or in the Control"   Region and the JIB in the PCB. }     BEGIN 	{ Getuser }   IF Psb_Available  THEN'      Sanity_Psb_User := Psb_User_Ptr^ ;   0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN(      Sanity_Ctl_User := CTL$T_USERNAME ;'      Sanity_Jib_User := Jib_User_Ptr^ ; 
      END ;   END ; 	{ of Getuser }     . [ASYNCHRONOUS,Check(None)] PROCEDURE Setuser ;  H { In KERNEL MODE, poke a new Username either into the PSB or the ControlC   Region and the JIB in the PCB. If the PSB exists, do *NOT* change C   JIB$T_USERNAME as this can cause problems in other processes in a G   multiprocess job tree. (Even though JUMP prevents itself from running 3   in a multiprocess job tree, avoid this anyway.) }      BEGIN 	{ Setuser }   IF Psb_Available  THEN&      Psb_User_Ptr^  := New_User.BODY ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN&      CTL$T_USERNAME := New_User.BODY ;&      Jib_User_Ptr^  := New_User.BODY ;
      END ;   END ; 	{ of Setuser }     J [GLOBAL] PROCEDURE Change_Username (New_Username : VARYING [Len] OF CHAR ;# 				    Faking : BOOLEAN := TRUE) ;   B { Change the username.	Do sanity checks except when reverting from   pseudo-terminal }      BEGIN 	{ Change_Username }   IF Bugger.D4	THEN ;      WRITELN (Dbgfile,'*** Entering Change_Username ...') ;   O   { Check that the username as returned by GETJPI and as peeked at in EXEC MODE )     agree -- do this as a sanity check. }      IF Psb_Available  THEN
      BEGIN;      Psb_Ptr::UNSIGNED := CTL$GL_PCB + PCB$AR_NATURAL_PSB ;       Getmem (Psb_Ptr,Psb_Ptr) ; C      Psb_User_Ptr::UNSIGNED := Psb_Ptr::UNSIGNED + PSB$T_USERNAME ; 
      END ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN2      Jib_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_JIB ;      Getmem (Jib_Ptr,Jib_Ptr) ; C      Jib_User_Ptr::UNSIGNED := Jib_Ptr::UNSIGNED + JIB$T_USERNAME ; 
      END ;     $CMEXEC (Getuser,%IMMED 0) ;     IF Faking  THEN       IF Psb_Available  THEN  	BEGIN, 	IF (Sanity_Psb_User <> Orig_User.BODY)	THEN! 	   LIB$STOP (Jump__Insaneuser,2, 6 		     %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)," 		     %STDESCR Sanity_Psb_User) ; 	END
       ELSE0      IF ((Sanity_Ctl_User <> Orig_User.BODY)  OR, 	 (Sanity_Jib_User <> Orig_User.BODY))  THEN! 	   LIB$STOP (Jump__Insaneuser,2, 6 		     %STDESCR SUBSTR (Orig_User,1,Orig_User.LENGTH)," 		     %STDESCR Sanity_Jib_User) ;  A   New_User := PAD ('',' ',Max_Username_Len) ;	{ Clear any crud! }    New_User := New_Username ;     $CMKRNL (Setuser,%IMMED 0) ;   END ; 	{ Change_Username }    3 [GLOBAL] PROCEDURE Change_Uic (New_Uic : UIC$TYPE ; & 			       Faking  : BOOLEAN := TRUE) ;  > { Change the UIC.  Do sanity checks except when reverting from   pseudo-terminal. }  0   VAR Sanity_Uic : [VOLATILE] UIC$TYPE := ZERO ;     BEGIN 	{ Change_UIC }    IF Bugger.D4	THEN 6      WRITELN (Dbgfile,'*** Entering Change_UIC ...') ;  J   { Check that the UIC as returned by GETJPI and as peeked at in EXEC MODE)     agree -- do this as a sanity check. }      IF Psb_Available  THEN
      BEGIN?      Psb_Uic_Ptr::UNSIGNED := CTL$GL_PCB + PCB$AR_NATURAL_PSB ; '      Getmem (Psb_Uic_Ptr,Psb_Uic_Ptr) ; A      Psb_Uic_Ptr::UNSIGNED := Psb_Uic_Ptr::UNSIGNED + PSB$L_UIC ; 0      Getmem (Sanity_Uic.UIC$L_UIC,Psb_Uic_Ptr) ;
      END ;  0   IF Arb_Full_Support OR NOT Psb_Available  THEN
      BEGIN6      Jib_Uic_Ptr::UNSIGNED := CTL$GL_PCB + PCB$L_UIC ;0      Getmem (Sanity_Uic.UIC$L_UIC,Jib_Uic_Ptr) ;
      END ;  B   IF Faking AND (Sanity_Uic.UIC$L_UIC <> Orig_Uic.UIC$L_UIC)  THEN!      LIB$STOP (Jump__Insaneuic,2, " 	       %IMMED Orig_Uic.UIC$L_UIC,& 	       %IMMED Sanity_Uic.UIC$L_UIC) ;     IF Psb_Available  THENM      Putmem (New_Uic.UIC$L_UIC,Psb_Uic_Ptr) ;	{ Change UIC to be target UIC }   0   IF Arb_Full_Support OR NOT Psb_Available  THENM      Putmem (New_Uic.UIC$L_UIC,Jib_Uic_Ptr) ;	{ Change UIC to be target UIC }    END ; 	{ Change_UIC }    END.	{ JUMP_Poker } 