K $!************************************************************************* K $!*                                                                       * K $!*  JUMP -- BUILD_JUMP.COM                                               * K $!*                                                                       * K $!************************************************************************* K $!*  Author and Maintainer: Jonathan Ridler.                              * K $!*                                                                       * K $!*  This software is owned and maintained privately by the author,       * K $!*  Jonathan Ridler. It is NOT in any way produced, owned, supported,    * K $!*  maintained or endorsed by Hewlett Packard Pty Ltd or any of its      * K $!*  legal entities.                                                      * K $!*                                                                       * K $!*  Email: vmsjump@internode.on.net                                      * K $!************************************************************************* K $!************************************************************************* K $!***                                                                   *** K $!***                         LICENCE NOTICE                            *** K $!***                                                                   *** K $!***  This software is COPYRIGHT (c) 1993-2012 Jonathan Ridler.        *** K $!***  ALL RIGHTS RESERVED.                                             *** K $!***                                                                   *** K $!***  Please READ the file JUMP_LICENCE.TXT which contains the         *** K $!***  complete Licence and all conditions of use for JUMP.             *** K $!***                                                                   *** K $!************************************************************************* K $!*************************************************************************  $!C $!  Build JUMP. Supports all architectures: VAX, Alpha and Itanium.  $!C $!  Parameter values may be specified to control the build process. K $!  All parameters are optional. Some parameters must be the only parameter A $!  specified, but some parameters can be specifid together. When K $!  specifying more than one parameter, use individual separate parameters, G $!  i.e. P1 P2 etc. For example, to compile and link with traceback use " $!  this command:  @BUILD_JUMP C T $!I $!    None    - Default action with no parameters: link with NO TRACEBACK F $!    B [xxx] - Create a backup saveset of all JUMP files; "xxx" is anD $!              optional string of arbitrary length representing theG $!              version ID; when specifying this option, it must be the  $!              ONLY option H $!    C       - Compile relevant Pascal sources and link with or withoutB $!              TRACEBACK as per the "L" (default) and "T" optionsK $!    D [xxx] - Create a JUMP distribution kit: compile ALL possible Pascal B $!              sources for the current architecture and link withF $!              NO TRACEBACK; "xxx" is an optional string of arbitraryH $!              length representing the version ID; when specifying this2 $!              option, it must be the ONLY option7 $!    L       - Link with NO TRACEBACK (default option) J $!    M file  - Compile a particular Pascal source file; a source filenameH $!              is required; when specifying this option, it must be the $!              ONLY option I $!    T       - Link with TRACEBACK; this option overrides the "L" option 8 $!    X       - Link with DEBUG; for Developer use only. $!K $!------------------------------------------------------------------------- ; $!  With new releases of OpenVMS, JUMP *MUST* be re-linked.  $! $!  History:6 $!      25-Sep-2001     JER     Updated for JUMP V4.0.: $!      07-May-2002     JER     Allow distribution builds.: $!      01-Apr-2004     JER     Allow build under V7.3-2+.I $!                              Also, display JUMP version at build time. 1 $!      27-May-2004     JER     Allow IA64 build. H $!      09-Oct-2011     JER     Add new options & streamline the builds.J $!      01-Feb-2012     JER     Add 'B' option; change parameter handling;I $!                              check Pascal compiler version and licence I $!                              status; add 'X' option; restructure code. 0 $!                              Not for VAX yet.% $!	03-Feb-2012	JER	Added VAX support. ) $!	21-Feb-2012	JER	Minor cosmetic change. K $!*************************************************************************  $  $ on ERROR  then  EXIT $ say    := write SYS$OUTPUT $  $ digits = "0123456789"  $ L $ arch    = f$getsyi ("ARCH_NAME")                      ! VAX, Alpha or IA64I $ version = f$edit (f$getsyi ("VERSION"),"TRIM")        ! OpenVMS version L $ VMS     = f$extract (1,5,version)                     ! = "X.X" or "X.X-X" $ pid     = f$getjpi ("","PID")  $ trace  := /notraceback $ source  = "" $ valid_options = "BCDLMTX"  $ C $ production := true                   ! Production or Development?  $ debug  = 0 $ dbg_c := /nodebug  $ dbg_l := /nodebug  $ dbg_m := /nodebug 
 $ dbg_n  = ""  $  $ VAX   = arch .eqs. "VAX" $ Alpha = arch .eqs. "Alpha" $ IA64  = arch .eqs. "IA64"  $  $ if .not. production  $ then
 $   say ""M $   say "*******************************************************************" M $   say "***           This is a DEVELOPMENT version of JUMP             ***" M $   say "*** Do NOT use this version of JUMP in production environments! ***" M $   say "*******************************************************************" 
 $   say "" $ endif  $!G $!---------------------------------------------------------------------  $ 
 $ compile = 0 C $ linking = p1 .eqs. ""         ! Default action when no parameters 
 $ poker   = 0  $ single_compile = 0
 $ licence = 0  $ 	 $ cnt = 1  $ gosub CHECK_PARAMETER  $  $ save = p1 .eqs. "B"  $ dist = p1 .eqs. "D"  $ if dist .or. save  $ then0 $   p2 = f$edit (p2,"UPCASE,UNCOMMENT,COLLAPSE")/ $   if save  then  fyl = "JUMP''p2'_BACKUP.BCK" 1 $   if dist  then  fyl = "JUMP''p2'_DIST_KIT.BCK" + $   if f$parse (fyl,"SYNTAX_ONLY") .eqs. ""  $   thenF $     say "%JUMP-F-BADFILNAM, Specified name for saveset is not valid"
 $     EXIT	 $   endif  $   cnt = 9  $ endif  $ 
 $CHECK_PARAM:  $ if p1 .eqs. "M"  $ then4 $   source = f$edit (p2,"UPCASE,UNCOMMENT,COLLAPSE") $   if source .eqs. "" $   thenQ $     say "%JUMP-F-NOSOURCE, ""M"" option requires a source file to be specified" 
 $     EXIT $   else@ $     if f$locate (".PAS",source) .eq. f$length (source)  then -!          source = source + ".PAS" # $     if f$search (source) .eqs. "" 
 $     then; $       say "%JUMP-F-NOFILE, Specified file does not exist"  $       EXIT
 $     else  $       source = source - ".PAS" $     endif 	 $   endif  $   single_compile = 1 $   cnt = 9  $ else $   if .not. (save .or. dist)  $   then $     cnt = cnt + 1 5 $     if p'cnt' .nes. ""  then  gosub CHECK_PARAMETER 	 $   endif  $ endif ( $ if cnt .lt. 8  then  goto  CHECK_PARAM $ * $ linking = linking .or. dist .or. compile $ link_status = 0  $ : $ if VAX                                ! VAX architecture $ then $   nowarning = ""8 $   poker = 1                           ! PSB not on VAX= $   licence = 1                         ! Can't use F$LICENSE  $ endif  $ < $ if Alpha                              ! Alpha architecture $ then( $   nowarning = "/warning=noinformation" $ endif  $ > $ if IA64                               ! Itanium architecture $ then( $   nowarning = "/warning=noinformation" $ endif  $ J $ if (compile .or. single_compile .or. dist)    ! Need the Pascal compiler $ thenE $   if .not. VAX  then  licence = (f$license ("pascal") .eqs. "TRUE") B $   if (f$search ("SYS$SYSTEM:PASCAL.EXE") .nes. "") .and. licence $   then  $     gosub GET_COMPILER_VERSION $   elseG $     say "%JUMP-F-NOPASCAL, Pascal is not installed or has no licence"  $     EXIT 1	 $   endif ? $ else                                          ! Not compiling C $   if linking .and. f$search ("JUMP.OBJ_''arch'''dbg_n'") .eqs. ""  $   thenB $     say "%JUMP-F-NOOBJECT, JUMP Main object file does not exist" $     EXIT 1	 $   endif  $ endif  $ B $ if (VMS .lts. "7.2") .or. poker       ! Force POKER, not PERSONA $ then% $   changer := jump_persona_non_grata  $ else $   changer := jump_persona  $ endif  $  $ gosub GET_JUMP_VERSION $  $ if single_compile  $ then! $   say "Compiling ''source' ..." F $   pascal 'source' /usage=('usage_types') /object='source'.obj_'arch' $ endif  $ 	 $ if save  $ thenS $   say "Creating backup of JUMP ''jump_version'for OpenVMS ''arch' ''version' ..."  $ else $   if .not. single_compile  $   thenK $     say "Building JUMP ''jump_version'for OpenVMS ''arch' ''version' ..." 6 $     if debug  then  say "*****  DEBUG VERSION *****"	 $   endif  $ endif  $ I $!  Not all sites will have a Pascal compiler, so only compile if needed.  $  $ if dist .or. compile $ then; $   if dist  then  say "Building JUMP distribution kit ..."  $ + $   say "Compiling JUMP Pascal sources ..."   $   say "  ... Main program ..."M $   pascal jump /usage=('usage_types') /object=jump.obj_'arch''dbg_n' 'dbg_c'  $ C $   if (.not. VAX) .and. (dist .or. (changer .eqs. "JUMP_PERSONA"))  $   then$ $     say "  ... PERSONA module ..."2 $     pascal jump_persona /usage=('usage_types') -;              /object=jump_persona.obj_'arch''dbg_n' 'dbg_c' 	 $   endif  $ 9 $   if dist .or. (changer .eqs. "JUMP_PERSONA_NON_GRATA")  $   then. $     say "  ... PERSONA_NON_GRATA module ..."< $     pascal jump_persona_non_grata /usage=('usage_types') -E              /object=jump_persona_non_grata.obj_'arch''dbg_n' 'dbg_c' 	 $   endif  $   $   say "  ... POKER module ...". $   pascal jump_poker /usage=('usage_types') -7            /object=jump_poker.obj_'arch''dbg_n' 'dbg_c'  $ " $   say "  ... FIDDLER module ..."0 $   pascal jump_fiddler /usage=('usage_types') -9            /object=jump_fiddler.obj_'arch''dbg_n' 'dbg_c'  $ 
 $   if VAX $   then# $     say "  ... ON_VAX module ..." 1 $     pascal jump_ON_VAX /usage=('usage_types') - 7              /object=jump_ON_VAX.obj_vax'dbg_n' 'dbg_c'  $   else' $     say "  ... NOT_ON_VAX module ..." 5 $     pascal jump_NOT_ON_VAX /usage=('usage_types') - >              /object=jump_NOT_ON_VAX.obj_'arch''dbg_n' 'dbg_c'	 $   endif  $ endif  $ % $ if .not. (save .or. single_compile)  $ then $ H $!  Macro, CLD and Message compilers are standard on OpenVMS, so compileC $!  each time to ensure the object is correct for the architecture.  $  $   arch_defs = ""> $   if f$search ("SYS$LIBRARY:ARCH_DEFS.MAR") .nes. ""  then -6        arch_defs = "SYS$LIBRARY:ARCH_DEFS+SYS$DISK:[]" $ ) $   say "Compiling JUMP Macro source ..." 0 $   macro 'arch_defs'jump_parse_id 'nowarning' -2           /object=jump_parse_id.obj'dbg_n' 'dbg_m' $ ' $   say "Compiling JUMP CLD source ..."   $   set command /object jump_cld $ + $   say "Compiling JUMP Message source ..."  $   message jump_msg $ endif  $  $ if linking $ then $   if trace .eqs. "/TRACEBACK"  $   then- $     say "Linking JUMP (with TRACEBACK) ..."  $   else $     say "Linking JUMP ..."	 $   endif  $ , $   common = "jump.obj_''arch'''dbg_n'," + -4              "jump_fiddler.obj_''arch'''dbg_n'," + -2              "jump_poker.obj_''arch'''dbg_n'," + -2              "''changer'.obj_''arch'''dbg_n'," + -:              "jump_parse_id.obj''dbg_n',jump_cld.obj," + -+              "jump_msg.obj,jump.opt/option"  $ 
 $   if VAX $   then1 $     link 'trace' 'dbg_l' 'common',            - 1                 jump_on_vax.obj_vax'dbg_n',     - 1                 SYS$SYSTEM:SYS.STB/select,      - 1                 SYSDEF.STB/select               - /                 /executable=JUMP.EXE_VAX'dbg_n'  $     link_status = $status 	 $   endif  $  $   if Alpha $   then9 $     link /sysexe 'trace' 'dbg_l' 'common',            - 9                 jump_not_on_vax.obj_alpha'dbg_n',       - 9                 SYS$LOADABLE_IMAGES:SYSDEF.STB/select   - 2                  /executable=JUMP.EXE_ALPHA'dbg_n' $     link_status = $status 	 $   endif  $  $   if IA64  $   then9 $     link /sysexe 'trace' 'dbg_l' 'common',            - 9                 jump_not_on_vax.obj_ia64'dbg_n',        - 9                 SYS$LOADABLE_IMAGES:SYSDEF.STB/select   - 1                  /executable=JUMP.EXE_IA64'dbg_n'  $     link_status = $status 	 $   endif  $ endif  $  $ if linking .and. link_status $ then8 $   say "*** JUMP ''jump_version'built successfully ***"4 $   if debug  then  say "*****  DEBUG VERSION *****"M $   say "EXECUTABLE filename is ",f$edit("JUMP.EXE_''arch'''dbg_n'","UPCASE") N $   say "Remember to install JUMP according to the installation instructions!" $ endif  $  $ if dist .or. save  $ then; $   if save  then  say "Creating backup saveset ''fyl' ..." = $   if dist  then  say "Building distribution kit ''fyl' ..." < $   backup /log *.txt;,*.pas;,*.cld;,*.msg;,*.mar;,*.com;, -E                 *.hlp;,*.opt;,*.dat;,*.obj_*;,*.exe*; 'fyl' /save_set  $ endif  $  $ EXIT 1N $!---------------------------------------------------------------------------- $! $! Subroutines $!N $!............................................................................D $!---  Check the supplied parameters and set options accordingly ... $  $CHECK_PARAMETER:  $ 2 $ px = f$edit (p'cnt',"UPCASE,UNCOMMENT,COLLAPSE")> $ if f$locate (px,valid_options) .eq. f$length (valid_options) $ then: $   say "%JUMP-F-INVPARAM, Invalid parameter (""",px,""")" $   STOP $ endif  $ ' $ compile = compile .or. (px .eqs. "C") ; $ linking = linking .or. (px .eqs. "L") .or. (px .eqs. "T") , $ if px .eqs. "T"  then  trace := /traceback# $ poker = poker .or. (px .eqs. "N") # $ debug = debug .or. (px .eqs. "X") 
 $ if debug $ then: $   compile = 1                         ! Force re-compile" $   dbg_c := /debug=all/nooptimize= $   dbg_m  = dbg_c                      ! Alpha and IA64 only ; $   if VAX  then  dbg_m := /debug=all   ! Different for VAX  $   dbg_l := /debug  $   dbg_n := _debug  $ endif  $  $ if (cnt .gt. 1) .and. - =      ((px .eqs. "B") .or. (px .eqs. "D") .or. (px .eqs. "M"))  $ thenD $   say "%JUMP-F-ONEOPTION, ""''px'"" option must be the only option $   EXIT $ endif  $  $ RETURN $ N $!............................................................................5 $!---  Analyze the compiler to get the version ID ...  $  $GET_COMPILER_VERSION: $ 2 $   temp1 := SYS$SCRATCH:JUMP_TEMP_FILE_'pid'1.TMP2 $   temp2 := SYS$SCRATCH:JUMP_TEMP_FILE_'pid'2.TMPA $   set message /nofacility /noidentification /noseverity /notext 8 $   analyze /image SYS$SYSTEM:PASCAL.EXE /output='temp1'9 $   set message /facility /identification /severity /text > $   search 'temp1' "image file identification" /output='temp2' $   close fyl /nolog< $   open fyl 'temp2' /read /error=FYL_ERROR1 /end=FYL_ERROR12 $   read fyl buf /error=FYL_ERROR1 /end=FYL_ERROR1; $   buf = f$edit (buf,"UPCASE,UNCOMMENT,COMPRESS,TRIM") - - 5           "IMAGE FILE IDENTIFICATION: """ - "PASCAL "  $   buf = f$extract (0,4,buf)  $FYL_ERROR1: $   close fyl /nolog? $   if f$search (temp1) .nes. ""  then  delete /nolog 'temp1';* ? $   if f$search (temp2) .nes. ""  then  delete /nolog 'temp2';* ? $   usage_types = "all"                 ! Assume Pascal <= v5.2 ! $   if (buf .gts. "V5.2")  then - 4         usage_types = usage_types + ",noperformance" $  $ RETURN $ N $!............................................................................; $!---  Use the JUMP.OPT file to get the JUMP version ID ...  $  $GET_JUMP_VERSION: $  $ jump_version = "" . $ temp := SYS$SCRATCH:JUMP_TEMP_FILE_'pid'.TMP/ $ search jump.opt identification /output='temp'  $ close fyl /nolog9 $ open fyl 'temp' /read /error=FYL_ERROR2 /end=FYL_ERROR2 9 $ read fyl jump_version /error=FYL_ERROR2 /end=FYL_ERROR2 < $ jump_version = jump_version - "IDENTIFICATION = """ - """"A $ if f$locate (f$extract (1,1,jump_version),digits) .ne. 1 then - " 	jump_version = "V" + jump_version* $ jump_version = "(" + jump_version + ") " $FYL_ERROR2: $ close fyl /nolog; $ if f$search (temp) .nes. ""  then  delete /nolog 'temp';*  $  $ RETURN $ N $!----------------------------------------------------------------------------