/*++
** IMGID.H - IMGID.C Header File
** (c) Copyright 1996, Chris Olive
** All rights reserved
**
** ENVIRONMENT
**
**    OpenVMS v5.5-2
**    DEC/VAX C Language
**    GNU C 2.3.3
**
** ABSTRACT
**
**    Header for IMGID.C.  Defines based on architecture.
**    
** AUTHOR, INSTALLATION and DATE
**
**    Chris Olive
**    Senior Programmer Analyst
**    Mellon Bank
**    Pittsburgh, PA
**    3/7/96
**
** MODIFICATION HISTORY
**
**    Date        Author        Modification(s)
**    ----------- ------------- ---------------------------------------------
*/ 

#ifndef __IMGID_H__
#define __IMGID_H__

/*--- Includes, etc. ---*/

   /* We "make" these from LIB.MLB using output from LIBRARY/EXTRACT
    * command and substituting "$EQU" in output with "#define".  Use
    * BUILD.COM to do this automagically.
    */

#ifdef __ALPHA__
#include "eihddef.h"                          /* Extended Image HeaDer defs   */
#include "eihidef.h"                          /* Extended Image Hdr Info defs */
#define  IHD_S_IHDDEF    EIHD$S_EIHDDEF       /* Alpha image head def size    */
#define  IHD_X_IMGIDOFF  EIHD$L_IMGIDOFF      /* Alpha image info offset      */
#define  IHI_Q_LINKTIME  EIHI$Q_LINKTIME      /* Alpha linktime offset        */
#define  IHI_T_IMGNAM    EIHI$T_IMGNAM        /* Alpha image name offset      */
#define  IHI_T_IMGID     EIHI$T_IMGID         /* Alpha image id offset        */
#define  IHI_T_LINKID    EIHI$T_LINKID        /* Alpha link id offset         */
#define  PLATFORM        "AXP"                /* Platform string              */
#else
#include "ihddef.h"                           /* Image HeaDer defs            */
#include "ihidef.h"                           /* Image Hdr Information defs   */
#define  IHD_S_IHDDEF    IHD$S_IHDDEF         /* VAX image head def size      */
#define  IHD_X_IMGIDOFF  IHD$W_IMGIDOFF       /* VAX image info offset        */
#define  IHI_Q_LINKTIME  IHI$Q_LINKTIME       /* VAX linktime offset          */
#define  IHI_T_IMGNAM    IHI$T_IMGNAM         /* VAX image name offset        */
#define  IHI_T_IMGID     IHI$T_IMGID          /* VAX image id offset          */
#define  IHI_T_LINKID    IHI$T_LINKID         /* VAX link id offset           */
#define  PLATFORM        "VAX"                /* Platform string              */
#endif
#include "libdef.h"                           /* LIB routines defs */

/*--- Macros ---*/

#define STRING_LEN 80                         /* Length of string buffers */

/*--- Typedefs ---*/

typedef char byte_array;                      /* Byte array type         */
typedef struct dsc$descriptor_s SDESC;        /* Class S descriptor type */
typedef                                       /* Offset type             */
#ifndef __ALPHA__
short
#endif
int offset_t;

#endif
