 #pragma module RESET "X-0" /*  *N  *****************************************************************************  *J  * Copyright <C0> Digital Equipment Corporation, 1994 All Rights Reserved.M  * Unpublished rights reserved under the copyright laws of the United States.   *J  * The software contained on this media is proprietary to and embodies theN  * confidential technology of Digital Equipment Corporation.  Possession, use,L  * duplication or dissemination of the software and media is authorized onlyJ  * pursuant to a valid written license from Digital Equipment Corporation.  *I  * RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the U.S. E  * Government is subject to restrictions as set forth in Subparagraph H  * (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.  *N  *****************************************************************************  *  * FACILITY: SCSI   *  * ABSTRACT:  *L  *      This module contains the entry point for an application which allowsF  *	a suitably privileged user to initiate a SCSI bus reset through one"  *	of the Alpha SCSI port drivers.  *  * AUTHORS:   *  *      Rick Lord 
  *	Jim Dunham   *	  * BUILD:   *;  *	$ CC RESET+RESD$:[SYSLIB]SYS$STARLET_C/LIB+SYS$LIB_C/LIB !  *	$ LINK/SYSEXE RESET+PORT_RESET   *  * REVISION HISTORY:  *#  *	X-0	RCL		Rick Lord			27-Dec-1994   *		Initial version.  *  *  */   B /* Define system and DEC C data structures, types and constants */   #include <ucbdef.h>  #include <stdio.h> #include <ssdef.h> #include <string.h>  #include <ctype.h> #include <time.h>  #include <signal.h> 4 /* Define function prototypes for system routines */  / int sys$cmkrnl(unsigned (),unsigned *arglist);     int sys$exit(unsigned status);  3 /* Define function prototypes for local routines */   % unsigned lock_code(unsigned *retadr);   * unsigned reset(UCB *ucb,unsigned *status);  5 unsigned find_port(char *port_name,unsigned *status);   ( unsigned unlock_code(unsigned *retadr);    /* Local data */  D unsigned retadr[2]; /* Actual VA range which is locked by $LCKPAG */  ' unsigned status; /* Procedure status */   / unsigned cmkrnl_status; /* SYS$CMKRNL status */   ; unsigned arglist[5]; /* SYS$CMKRNL routine argument list */   7 char port_name[8]; /* ASCIC name of port being reset */   ) char timestr[32]; /* ASCII time string */   # time_t now; /* Binary time value */     UCB *ucb; /* Port UCB address */  $ int i, j, k, eos; /* Working ints */  , int count; /* Number of resets to perform */  * int seconds; /* Interval between resets */   /*L  ;--------------------------------------------------------------------------  ; Main - program entry point   ;  ;	argv[0]	- Program name   ;  ;	argv[1] - Port name  ;&  ;      argv[2] - Number of resets (1)  ;'  ;	argv[3] - Seconds between resets (5)   ;L  ;--------------------------------------------------------------------------  */   % int main ( int argc, char * argv [] )    { if (argc<2||argc>4)   U      { printf ("usage: reset <port> [<count>=1] [<seconds-pause>=5] ! port = pkx\n");           sys$exit (SS$_NORMAL); }   0   count = ( argc > 2 ) ? atoi ( argv [2] ) : 1 ;  2   seconds = ( argc > 3 ) ? atoi ( argv [3] ) : 5 ;  ?   /* To match DDB device names, build ASCIC port name string */      i = 0;  #   port_name[i++]=k=strlen(argv[1]);      for (j=0;j<k;j++)   (      port_name[i++]=toupper(argv[1][j]);     status=lock_code(retadr);       if (!status&1)  9      { printf ("reset: cannot lock elevated-IPL code\n");           sys$exit(status); }     arglist[0] = 3; $   arglist[1] = (unsigned) port_name;   arglist[2] = (unsigned) &ucb; "   arglist[3] = (unsigned) &status;  .   cmkrnl_status=sys$cmkrnl(find_port,arglist);     if (!(cmkrnl_status&1))   K      { printf("reset: $CMKRNL(find_port(%s)) %Xh\n",argv[1],cmkrnl_status);           unlock_code(retadr);   !        sys$exit(cmkrnl_status); }      if (!(status&1))  ;      { printf("reset: find_port(%s) %Xh\n",argv[1],status);           unlock_code(retadr);           sys$exit(status); }     arglist[0] = (unsigned) 2;   arglist[1] = (unsigned) ucb;"   arglist[2] = (unsigned) &status;  
   time(&now);      strcpy(timestr,ctime(&now));     eos=strlen(timestr)-1;     printf("\n");       for ( i = 0; i < count; i ++ )  + 	{ cmkrnl_status=sys$cmkrnl(reset,arglist);     	  time(&now);   	  strcpy(timestr,ctime(&now));    	  timestr[eos]='\0';   E 	  printf("%s reset #%05d, %s, $CMKRNL status %d, reset status %d\n",   F 		port_name+1,i+1,timestr+(timestr[0]==' '?1:0),cmkrnl_status,status);  = 	  if ( ( ! ( status & 1 ) ) || ( ! ( cmkrnl_status & 1 ) ) )    		sys$exit ( SS$_NORMAL ) ;   . 	  if ( seconds > 0 && ( i < ( count - 1 ) ) )   		sleep ( seconds ) ; }      status=unlock_code(retadr);      if (!(status&1))  1      { printf("reset: unlock_code %Xh\n",status);           sys$exit(status); }     printf("\n");      sys$exit(status);    }   