// Test/demonstration of cgienv class

#include <iostream.hxx>
#include <unixlib.h>

#include "cgienv.hxx"

int main ( int argc, char ** argv )
{
    int status, plen;
    char *ep, path[256];
    //
    // Initialize CGI object and send CGI response header (via << operator).
    //
    status = CGI.init ( argc, argv );
    cout << "Status of cgi.init: " << status << "\n";

    CGI << "Content-type: text/plain\n\n";
    CGI << "CGIENV demo script (C++), variables:\n";
    //
    // Dump the CGI variable table using the special member function 'scan'.
    //
    symbol_table_scan ctx;
    char *nn, *vv;
    for ( ctx = SYMBOL_TABLE_SCAN_BEGIN; CGI.var.scan(ctx, nn, vv); ) {
	CGI << "\n   " << nn << " = ";
	if ( !vv ) CGI << "NULL";
	else CGI << "'" << vv << "'";
    }
    CGI << "\n";
    //
    // Check content-length and dump form data.  Note we can address variable value
    // using array reference by variable name.
    //
    ep = CGI.var["CONTENT_LENGTH"];
    CGI << "\nContent-length string: " << (ep ? ep : "NULL");
    if ( ep ) {
	status = CGI.parse_form();
	CGI << "\nStatus of content parse: " << status << ", symbols:\n";

	for ( ctx = SYMBOL_TABLE_SCAN_BEGIN; CGI.form.scan(ctx, nn, vv); ) {
	    CGI << "\n   " << nn << " = ";
	    if ( !vv ) CGI << "NULL";
	    else CGI << "'" << vv << "'";
	}
	CGI << "\n";
    }
    return 0;
}
