/*
 * Scan a tar volume and produce change list.
 */
#include <stdio.h>
#include <stdlib.h>
#include <stat.h>
#include <string.h>
#include <time.h>
#include "tarscan.h"

int main ( int argc, char **argv )
{
    int status, size, len;
    time_t tdate, cdate, mdate;
    void *volume;
    char errmsg[256], name[512];
    struct stat curinfo;
    /*
     * initialize and open input file.
     */
    if ( argc < 2 ) { printf("Usage: tarcompare tar-file\n"); return 0; }

    status = tar_init ( 2 );
    if ( (status&1) == 0 ) printf("error initializing tarfile scanner\n");
    volume = tar_open ( argv[1], errmsg );
    if ( !volume ) {
	printf("tar_open: %s\n", errmsg );
	return 0;
    }
    /*
     * examine every file.
     */
    printf("index loaded, comparing times...\n");
    while ( tar_read_dir ( volume, name, &size, (unsigned *) &tdate ) ) {

	len = strlen(name);
	if ( len > 0 ) if ( name[len-1] == '/' ) continue;
	status = stat ( name, &curinfo );
	if ( status == 0 ) {
	    if ( tdate != curinfo.st_mtime ) {
		printf("update to %s\n", name );
	    }
	} else {
	    printf("Error reading %s\n", name);
	}
    }
    return 1;
}
