/*
 * Define globals and prototypes for use with MST_SHARE support routines
 * for dynamically loaded (i.e. shareable image) scriptserver threads.
 *
 * Redefine mst_ symbols to call indirectly though global pointers.
 */
#ifdef NOCOMMON_MST
#define mst_read (*mst_read_cb)
#define mst_write (*mst_write_cb)
#define mst_close (*mst_close_cb)
#define mst_exit (*mst_exit_cb)
#define mst_format_error (*mst_format_error_cb)
#define mst_connect (*mst_connect_cb)
/*
 * The follow globals will only be defined in modules that include pthread_np.h
 * prior to including mst_share.h
 */
#define mst_create_service_pool (*mst_create_service_pool_cb)
#define mst_register_service (*mst_register_service_cb)
#endif
/*
 * Now use the prototypes in message_service.h to declare the function pointers
 * by virtue of the defines above.
 */
#include "message_service.h"
/*
 * Define macros to override the global ints defined in message_service.h
 * to go through our own pointers, thus referencing the globals in the main
 * image.
 */
#ifdef VAXC
#define http_base_mst_globals http_base_mst_globals_p
globalref
#endif
struct {
   int log_level;
   int (*log_callback)(int,char*,...); 
   int reentrant_c, reentrant_vms;
} *http_base_mst_globals;
#ifndef __ALPHA
/*
 *  On VAX, universals end up pointing to fixup vector, so use universal
 *  symbol http_base_mst_globals to reference them indirectly.
 */
#define http_log_level http_base_mst_globals->log_level
#define http_reentrant_c_rtl http_base_mst_globals->reentrant_c
#define http_reentrant_vms_rtl http_base_mst_globals->reentrant_vms
#define tlog_putlog (*http_base_mst_globals->log_callback)
#else
/*
 * On Alpha, globals are defined in symbol_vector as data items and are
 * can be shared directly amongst all the images.  tlog_putlog() is part of
 * main image, so must be accessed explicity through pointer.
 */
int http_log_level;
int http_reentrant_c_rtl, http_reentrant_vms_rtl;
#define tlog_putlog (*tlog_putlog_cb)
int tlog_putlog ( int, char *, ... );
#endif
/*
 * Mstshr_init is called by or as the shareable image's init routine 
 * (init keyword in config file service rule) to initalize the indirect
 * function/int pointers declared above.  Vector holds the addresses to use.
 */
int mstshr_init ( mst_linkage vector, char *info, char *errmsg );

/*
 * Define prototypes for routines contained to mst_share.c that provide
 * a CGI-like environment list to aid conversion from cgilib base programs
 * to dynamic MST's.
 */
struct mstshr_envbuf {		/* buffer for holding fake environ array */
    int count;			/* next envp index to use */
    int used;			/* Characters consumed */
    char *prolog[4];		/* Scriptserver protocol prolog */
    char *ptr[100];
    char buf[3072];		/* Storage for env strings */
};
int mstshr_cgi_symbols (
	mst_link_t cnx, 	/* I/O connection to client thread */
	char *info, 		/* MST connect() parameter passed by */
	struct mstshr_envbuf *env );	/* Structure to receive result */
char *mstshr_getenv ( char *name, struct mstshr_envbuf *env );
/*
 * mstshr_cgi_symbols2 operates just line cgi_symbols except is skips
 * reading prolog (assumes caller initialized prolog and set used to 1.
 */
int mstshr_cgi_symbols2 (
	mst_link_t cnx, 	/* I/O connection to client thread */
	char *info, 		/* MST connect() parameter passed by */
	struct mstshr_envbuf *env );	/* Structure to receive result */
