  r /*****************************************************************************************************************  9  File:		PSM_LASER.C		VMS print symbiont for HP LaserJet +   Module:	XECN.C	(the root)  Author:	Nick de Smith	May 1986 R 		Applied Telematics Group, 7 Vale Avenue, Tunbridge Wells, Kent TN1 1DJ, England.( 		+44 892 511000, PSI%234213300154::NICK  T  Copyright (c) 1987,1988,1989 by Applied Telematics Group Limited and Nick de Smith.m  This software is supplied for information only. No guarantee is supplied for this software, and no liability m  will be accepted for any action resulting from the use of this software or the information contained herein. i  Under no circumstances may this software be used for commercial gain, including its sale, lease or loan. N  This software may be copied only with the inclusion of this copyright notice.f  The author is prepared to enter into correspondance with interested parties, but will not necessarily8  maintain this software. Having said all that, enjoy it!  v  The symbiont replaces 2 or 3 of the standard VMS print symbiont module in order to prevent leading and trailing blankI  pages being printed (which wastes very expensive paper on the LaserJet).     Edit	Edit date	By	Reason d   02	10-Nov-89	NMdS	Add in optional mapping for DEC Multinational character set if DEC_MNCS defined.!   01	11-Oct-88	NMdS	First attempt   r *****************************************************************************************************************/   #module	PSM_LASER	"V01.01"  = #include	descrip							/* Define DSC$xxx - VMS descriptors	*/ ? #include	ssdef							/* Define SS$xxxx - System status codes	*/ > #include	stsdef							/* Define STS$xxxx - VMS status masks	*/  @ #include	"psmdef.h"						/* Define PSM$xxxx - PSM definitions	*/  > globalvalue	PSM$_FUNNOTSUP;						/* Function not supported		*// globalvalue	PSM$_EOF;						/* End of file				*/   F #define	PSM_STREAMS	16						/* Maximum number of streams to support	*/  3 #define	PSM_REPLACE( psm_routine, our_routine ) {	\  	long	psm_status;				\ 	long	our_routine();				\  	psm_status = PSM$REPLACE(			\ 		&psm_routine	,			\ 		our_routine	);			\- 	if ( (psm_status & STS$M_SUCCESS) == 0 ) {	\  		return psm_status;			\	 	}						\  }     r /*****************************************************************************************************************   					P S M _ L A S E R  +  Main routine for the PSM replacement code.   r *****************************************************************************************************************/   PSM_LASER()  {  #ifdef	DEC_MNCS R 	PSM_REPLACE( PSM$K_INPUT_FILTER, PSM_Input_Filter );		/* Add an input filter			*/ #endif	DEC_MNCS [ 	PSM_REPLACE( PSM$K_FILE_SETUP_2, PSM_File_Setup_2 );		/* Replace the file setup routine	*/ b 	PSM_REPLACE( PSM$K_JOB_COMPLETION, PSM_Job_Completion );	/* Replace the job completion routine	*/  : 	return PSM$PRINT(						/* Return true symbiont status		*/6 		&PSM_STREAMS	,					/* Number of streams to allow		*/0 		0		,					/* Use default maximum buffer size	*/) 		0		);					/* No work area allocated		*/  }    #ifdef	DEC_MNCS r /*****************************************************************************************************************  $ 					P S M _ I n p u t _ F i l t e r    Add an input filter routine.   Y  This routine executes prior to the symbiont formatting routine (code PSM$K_MAIN_FORMAT).   r *****************************************************************************************************************/ static long  PSM_Input_Filter( ; 	unsigned long	*	psm$al_request_id	,		/* Request ident			*/ @ 	unsigned long	*	psm$al_work_area	,		/* => work area to use			*/E 	unsigned long	*	psm$al_func		,		/* Required function (PSM$K_xxxx)	*/ N 	struct dsc$descriptor *	psm$ax_funcdesc_1	,		/* Input function descriptor		*/C 	unsigned long	*	psm$al_funcarg_1	,		/*   ''  function argument		*/ O 	struct dsc$descriptor *	psm$ax_funcdesc_2	,		/* Output function descriptor		*/ D 	unsigned long	*	psm$al_funcarg_2	)		/*   ''   function argument		*/ { c /* This table contains 256. entries, one for each character in the DEC Multinational Character Set. R    The value in each cell is the corresponding value to output for an HP LaserJet.9    DEC characters not mapped, or not mapped directly are: P 	A9 (copyright , mapped to "c"), B9, B2, B3 (superscript , mapped to 1,2,3),; 	B5 ( micro, mapped to "u"), B6 ( paragraph, not mapped), V 	B7 (  centred dot, mapped to "."), D7, F7 (OE upper  and lower  case, not mapped)  */3 	static readonly char HP_Mapping_Table[ 0x100 ] = { p /* NUL .. SI  */ 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,p /* DLE .. US  */ 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,p /*  SP .. /   */ 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,p /*   0 .. ?   */ 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,p /*   @ .. O   */ 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,p /*   P .. _   */ 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,p /*   ` .. o   */ 0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,p /*   p .. DEL */ 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,p /*     .. SS3 */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,p /* DCS .. APC */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,p /*  A0 .. AF  */ 0xFC, 0xB8, 0xBF, 0xBB, 0x00, 0xBC, 0x00, 0xBD, 0xBA, 0x63, 0xF9, 0xFB, 0x00, 0x00, 0x00, 0x00,p /*  B0 .. BF  */ 0xB3, 0xFE, 0x32, 0x33, 0x00, 0x75, 0x00, 0x2E, 0x00, 0x31, 0xFA, 0xFD, 0xF7, 0xF8, 0x00, 0xB9,p /*  C0 .. CF  */ 0xA1, 0xE0, 0xA2, 0xE1, 0xD8, 0xD0, 0xD3, 0xB4, 0xA3, 0xDC, 0xA4, 0xA5, 0xE6, 0xE5, 0xA6, 0xA7,p /*  D0 .. DF  */ 0x00, 0xB6, 0xE8, 0xE7, 0xDF, 0xE9, 0xCE, 0x00, 0xD2, 0xAD, 0xED, 0xAE, 0xDB, 0xEE, 0x00, 0xDE,p /*  E0 .. EF  */ 0xC8, 0xC4, 0xC0, 0xE2, 0xCC, 0xD4, 0xD7, 0xB5, 0xC9, 0xC5, 0xC1, 0xCD, 0xD9, 0xD5, 0xD1, 0xDD,o /*  F0 .. FF  */ 0x00, 0xB7, 0xCA, 0xC6, 0xC2, 0xEA, 0xCE, 0x00, 0xD6, 0xCB, 0xC7, 0xC3, 0xCF, 0xEF, 0x00, 0xFC  	}; \ 	static struct dsc$descriptor_s x_translation_table = {		/* Translation table descriptor		*/O 		sizeof( HP_Mapping_Table ), DSC$K_DTYPE_T, DSC$K_CLASS_S, HP_Mapping_Table }; D 	static $DESCRIPTOR( x_fill, " " );				/* Fill character (space)		*/ 	unsigned long status;  A 	switch ( *psm$al_func ) {					/* Determine function required		*/   - 		case PSM$K_FORMAT:					/* Format data				*/ , 			status = STR$COPY_DX(				/* Copy...				*/: 				psm$ax_funcdesc_2	,		/* ...to the output string...		*/9 				psm$ax_funcdesc_1	);		/* ...from the input string		*/ P 			*psm$al_funcarg_2 = *psm$al_funcarg_1;		/* Copy the carriage control bytes	*/C 			if ( !(status & STS$M_SUCCESS) ) {		/* If the copy failed...		*/ 2 				return status;				/* ...tell the symbiont			*/ 			}; 			status = LIB$MOVTC(				/* Translate the input string		*/ 4 				psm$ax_funcdesc_2	,		/* String to translate			*/1 				&x_fill			,		/* Fill character (not used)		*/ ; 				&x_translation_table	,		/* Translation table to use		*/ / 				psm$ax_funcdesc_2	);		/* Output string			*/ J 			if ( !(status & STS$M_SUCCESS) ) {		/* If the translation failed...		*/2 				return status;				/* ...tell the symbiont			*/ 			}	 			break;   , 		default:						/* Unrecognised function		*/@ 			return PSM$_FUNNOTSUP;				/* ...say function not supported	*/ 	}  8 	return SS$_NORMAL;						/* Return success to caller		*/ }  #endif	DEC_MNCS     r /*****************************************************************************************************************  $ 					P S M _ F i l e _ S e t u p _ 2  )  Replaces the PSM$K_FILE_SETUP_2 routine.   n  The normal action of the FILE_SETUP_2 module is to insert a <FF> in the output stream by returning an <FF> ino  psm$ax_funcdesc. The output formatter normally removes this <FF> because it realises that the printer has just m  received an <FF> character from one or more of the previously executed modules. When SETUP modules are used, m  the output formatter assumes that the printer is no longer at TOF for safety, and will send the FILE_SETUP_2 k  supplied <FF> character just in case. We therefore replace the FILE_SETUP_2 module with this routine which l  never returns anything, thus preventing a leading <FF>. Note that this will only work with forms that never  output printable characters.   r *****************************************************************************************************************/ static long  PSM_File_Setup_2( ; 	unsigned long	*	psm$al_request_id	,		/* Request ident			*/ @ 	unsigned char	*	psm$ab_work_area	,		/* => work area to use			*/E 	unsigned long	*	psm$al_func		,		/* Required function (PSM$K_xxxx)	*/ H 	struct dsc$descriptor *	psm$ax_funcdesc		,		/* Function descriptor			*/= 	unsigned long	*	psm$al_funcarg		)		/* Function argument			*/  { A 	switch ( *psm$al_func ) {					/* Determine function required		*/   1 		case PSM$K_OPEN:					/* Allocate resources			*/ 	 			break;   1 		case PSM$K_CLOSE:					/* Release resources			*/ 	 			break;   @ 		case PSM$K_READ:					/* Return an input record or PSM$K_EOF	*/7 			return PSM$_EOF;				/* Do not return a form feed		*/   , 		default:						/* Unrecognised function		*/@ 			return PSM$_FUNNOTSUP;				/* ...say function not supported	*/ 	}  8 	return SS$_NORMAL;						/* Return success to caller		*/ }     r /*****************************************************************************************************************  ( 					P S M _ J o b _ C o m p l e t i o n  +  Replaces the PSM$K_JOB_COMPLETION routine.   p  The normal action of the JOB_COMPLETION module is to insert a <FF> in the output stream by returning an <FF> in  psm$ax_funcdesc. o  We therefore replace the JOB_COMPLETION module with this routine which never returns anything, thus preventing   a trailing <FF>.   r *****************************************************************************************************************/ static long  PSM_Job_Completion( ; 	unsigned long	*	psm$al_request_id	,		/* Request ident			*/ @ 	unsigned char	*	psm$ab_work_area	,		/* => work area to use			*/E 	unsigned long	*	psm$al_func		,		/* Required function (PSM$K_xxxx)	*/ H 	struct dsc$descriptor *	psm$ax_funcdesc		,		/* Function descriptor			*/= 	unsigned long	*	psm$al_funcarg		)		/* Function argument			*/  { A 	switch ( *psm$al_func ) {					/* Determine function required		*/   1 		case PSM$K_OPEN:					/* Allocate resources			*/ 	 			break;   1 		case PSM$K_CLOSE:					/* Release resources			*/ 	 			break;   @ 		case PSM$K_READ:					/* Return an input record or PSM$K_EOF	*/7 			return PSM$_EOF;				/* Do not return a form feed		*/   , 		default:						/* Unrecognised function		*/@ 			return PSM$_FUNNOTSUP;				/* ...say function not supported	*/ 	}  8 	return SS$_NORMAL;						/* Return success to caller		*/ }   