/* 2006-07-03 SMS.
   VMS-specific header file associated with vms.c.
*/

#ifndef _VMS_H
#define _VMS_H

#include <stat.h>

/* GETxxI item descriptor structure. */
typedef struct
    {
    short buf_len;
    short itm_cod;
    void *buf;
    int *ret_len;
    } xxi_item_t;

/* Desperation attempts to define unknown macros.  Probably doomed.
 * If these get used, expect sys$getjpiw() to return %x00000014 =
 * %SYSTEM-F-BADPARAM, bad parameter value.
 * They keep compilers with old header files quiet, though.
 */
#ifndef JPI$_RMS_EXTEND_SIZE
#  define JPI$_RMS_EXTEND_SIZE 542
#endif /* ndef JPI$_RMS_EXTEND_SIZE */

#ifndef JPI$_RMS_DFMBC
#  define JPI$_RMS_DFMBC 535
#endif /* ndef JPI$_RMS_DFMBC */

#ifndef JPI$_RMS_DFMBFSDK
#  define JPI$_RMS_DFMBFSDK 536
#endif /* ndef JPI$_RMS_DFMBFSDK */

/* File open callback ID values. */

#  define FOPI_ID 1
#  define FOPO_ID 2

/* File open callback ID storage. */

extern int fopi_id;
extern int fopo_id;

/* Function prototypes. */

/* File open callback ID function. */

extern int acc_cb();

/* VMS-specific file open. */

extern int open_vms( const char *file_spec, int flags, mode_t mode);

/* Version (";nnn") trim. */

extern void trim_file_name_version( char *file_spec);

/* Wildcard expander. */

extern int vms_expand_args( int *old_argc, char **argv[]);

/* File spec last-dot adjustment. */

extern void vms_redot( char *file_spec);

/* Old GNU C header files may not provide a prototype for ctime(),
 * leading to an unsightly diagnostic message.
 * This may need to be disabled manually, if there's a conflict.
 */
#ifdef __GNUC__
#  include <types.h>                            /* For "time_t". */
extern char *ctime (const time_t *bintim);
#endif /* def __GNUC__ */

#endif /* ndef _VMS_H */

