 /**  ; Facility: + ;	DCL.C	Copyright (c) 1993	Bruce R'. Miller  ;					and TGV, Inc.  ;  ; Abstract: B ;	These are routines which aid in the parsing of parameters passed
 ;	via DCL. ; 	 ; Author: ! ;	Bruce R. Miller, MILLER@TGV.COM  ;	TGV, Inc.  ;	603 Mission St.  ;	Santa Cruz, CA 95060 ;	(408) 427-4366 ;  ; Date:		May 10, 1991  ; % ; Copyright (c) 1993	Bruce R'. Miller  ; All rights reserved. ; A ;	Redistribution and use in source and binary forms are permitted A ;	provided that the above copyright notice and this paragraph are : ;	duplicated in all such forms and that any documentation,< ;	advertising materials, and other materials related to suchB ;	distribution and use acknowledge that the software was developed$ ;	by Bruce R'. Miller and TGV, Inc..> ;	THIS SOFTWARE IS PROVIDED AS IS'' AND WITHOUT ANY EXPRESS OR@ ;	IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIEDE ;	WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.  ;  ; Modifications: ;  **/    #include <descrip.h> #include <climsgdef.h> #include <libdef.h>  /* #include <lnmdef.h> */  #include <prtdef.h>  #include <psldef.h>  /* #include <rmsdef.h>  #include <ssdef.h> */   #include "fts.h"   struct tabent { 
 	char *ascic;  	unsigned long value;  };   static struct {  	int count;  	struct tabent entries[16];  } Prot_Tab = { 16*2, { 	{ "_ER", PRT$C_ER },  	{ "_ERKW", PRT$C_ERKW },  	{ "_EW", PRT$C_EW },  	{ "_KR", PRT$C_KR },  	{ "_KW", PRT$C_KW },  	{ "_NA", PRT$C_NA },  	{ "_RESRV", PRT$C_RESERVED }, 	{ "_SR", PRT$C_SR },  	{ "_SREW", PRT$C_SREW },  	{ "_SRKW", PRT$C_SRKW },  	{ "_SW", PRT$C_SW },  	{ "_UR", PRT$C_UR },  	{ "_UREW", PRT$C_UREW },  	{ "_URKW", PRT$C_URKW },  	{ "_URSW", PRT$C_URSW },  	{ "_UW", PRT$C_UW }	         } 	        };    static struct {  	int count;  	struct tabent entries[4]; } Mode_Tab = { 4*2, {  	{ "_EXEC", PSL$C_EXEC },  	{ "_KERNEL", PSL$C_KERNEL },  	{ "_SUPER", PSL$C_SUPER },  	{ "_USER", PSL$C_USER }} 	        };    static struct {  	int count;  	struct tabent entries[6]; } QIO_Style_Tab = { 6*2, {! 	{ "_DEFAULT", STYLE_K_DEFAULT },  	{ "_NULL", STYLE_K_NULL },  	{ "_PSI", STYLE_K_PSI },  	{ "_TGV", STYLE_K_TGV },  	{ "_UCX", STYLE_K_UCX },  	{ "_NFS", STYLE_K_NFS }} 	        };    static struct {  	int count;  	struct tabent entries[5]; } Size_Tab = { 5*2, {  	{ "_BYTE", 1 }, 	{ "_CHAR", 1 }, 	{ "_LONG", 4 }, 	{ "_SHORT", 2 },  	{ "_WORD", 2 }}	        };    static struct {  	int count;  	struct tabent entries[2]; } Hello_Tab = { 2*2, { 	{ "_BRUCE", 1 },  	{ "_SAILOR", 2 }}	        };        /** 4 ;	Get_DCL_Switch - Read DCL param into a text string ;  ; Input:- ;	4(AP)  - pntr to string with parameter name ) ;	8(AP)  - pntr to buffer to hold results  ;	12(AP) - size of buffer  ; 	 ; Output: 
 ;	R0 - Status  **/   / unsigned long Get_DCL_Switch(param,buffer,size)       char *param;       char *buffer;      int size; {  	unsigned long rc;8 	unsigned long param_desc[2] = { strlen(param), param };3 	unsigned long result_desc[2] = { size-1, buffer };  	short retlen;   	rc = cli$present(param_desc); 	if (rc == CLI$_ABSENT) 
 		return(rc);  	if (ERROR(rc)) { ' 		lib$signal(FTS$_Arg,1,param_desc,rc); 
 		return(rc);  	}4 	rc = cli$get_value(param_desc,result_desc,&retlen); 	if (ERROR(rc)) ' 		lib$signal(FTS$_Arg,1,param_desc,rc);    	buffer[retlen] = '\0';  	return(rc); }        /** 8 ;	Check_DCL_Switch - Check for existance of a DCL switch ;  ; Input:- ;	4(AP)  - pntr to string with parameter name  ; 	 ; Output: 
 ;	R0 - Status  **/   % unsigned long Check_DCL_Switch(param)       char *param;  {  	unsigned long rc;8 	unsigned long param_desc[2] = { strlen(param), param };   	rc = cli$present(param_desc); 	if (rc == CLI$_ABSENT) 
 		return(rc);  	if (ERROR(rc)) { ' 		lib$signal(FTS$_Arg,1,param_desc,rc); 
 		return(rc);  	} 	return(rc); }      /** 9 ;	Get_DCL_hex - convert DCL param from ascii into a value  ;  ; Functional Description:  ;	 ;  ; Input:2 ;	4(AP) - pntr to ASCID string with parameter name ;	8(AP) - conversion routine ; 	 ; Output: 
 ;	R0 - Status  ;	R1 - hex value **/   3 unsigned long Get_DCL_value(param,convertion,value)       char *param; #      unsigned long (*convertion)();       unsigned long *value; {  	char buffer [512]; 0 	unsigned long result_desc[2] = { 512, buffer };8 	unsigned long param_desc[2] = { strlen(param), param }; 	unsigned long rc;   	/* ! 	 * Has the parameter been given?  	 */%        	rc = cli$present(param_desc);  	if (rc == CLI$_ABSENT) 
 		return(rc);   	if (ERROR(rc)) 	lib$signal(rc);   	/*  	 * Get text 	 */= 	rc = cli$get_value(param_desc,&result_desc,&result_desc[0]);   	if (ERROR(rc)) 	lib$signal(rc);   	/*  	 * Convert text to value  	 */( 	rc = (*convertion)(&result_desc,value); 	if (ERROR(rc)) {  		/*$ 		 * Signal an argument format error 		 */ ) 		lib$signal(FTS$_Arg,1,&result_desc,rc);  	}   	return(rc); }    /** = ;	Get_DCL_hex - convert DCL param from ascii hex into a value  ;  ; Input:2 ;	4(AP) - pntr to ASCID string with parameter name ; 	 ; Output: 
 ;	R0 - Status  ;	R1 - hex value **/    extern ots$cvt_tz_l();  & unsigned long Get_DCL_hex(param,value)      char *param;       unsigned long *value; { 1 	return(Get_DCL_value(param,ots$cvt_tz_l,value));  }    /** A ;	Get_DCL_dec - convert DCL param from ascii decimal into a value  ;  ; Input:2 ;	4(AP) - pntr to ASCID string with parameter name ; 	 ; Output: 
 ;	R0 - Status  ;	R1 - hex value ; J ; Note:  can we combine this routine with Get_DCL_hex and save some space? **/    extern ots$cvt_tu_l();  & unsigned long Get_DCL_dec(param,value)      char *param;       unsigned long *value; { 1 	return(Get_DCL_value(param,ots$cvt_tu_l,value));  }        /** : ;	procname2pid - Convert Process name (or number) to a PID ;  ; Input:! ;	4(AP) - Process name descriptor & ;	8(AP) - pntr to longword to hold PID ; 	 ; Output: 
 ;	R0 - Status  ;	@8(AP) - PID ; ! ; Notes:	We are ignoring the IOSB  **/   , unsigned long procname2pid(procnam_desc,pid))      struct dsc$descriptor *procnam_desc;       unsigned long *pid; {  	struct dsc$descriptor desc; 	unsigned long rc; 	unsigned short iosb[2]; 	unsigned long ilst = 0;   	/* + 	 * First, see if it's a hexadecimal number  	 */% 	rc = ots$cvt_tz_l(procnam_desc,pid);  	if (!ERROR(rc)) return(rc);   	/*  	 * Call GetJPI system service 	 */5 	rc = sys$getjpiw(0,pid,procnam_desc,&ilst,iosb,0,0);  	return(rc); }      /** C ;	Get_DCL_pid - convert DCL param from process name (or #) to a PID  ;  ; Input:2 ;	4(AP) - pntr to ASCID string with parameter name+ ;	8(AP) - pntr to longword to return PID in  ; 	 ; Output: 
 ;	R0 - Status 
 ;	R1 - PID **/    Get_DCL_pid(param,pid)      char *param;       unsigned long *pid; { ' 	Get_DCL_value(param,procname2pid,pid);  }    /** : ;	Get_DCL_keyword	- get a value corresponding to a keyword ;  ; Input: ;	 4(AP) - DCL parameter name  ;	 8(AP) - Keyword table. ;	12(AP) - Address of longword to put value in ; 	 ; Output: 
 ;	R0 - Status  ;	R1 - keyword value **/   0 unsigned long Get_DCL_keyword(param,table,value)      char *param; 
      struct {  	     int count; 	     struct tabent entries[];      } *table;      unsigned long *value; { 8 	unsigned long param_desc[2] = { strlen(param), param }; 	struct dsc$descriptor desc; 	unsigned long rc; 	int i;    	/*  	 * Initialize the table 	 * D 	 * Note: Here we are writing into a static string; not very cool... 	 */% 	for (i=0; i<(table->count/2); i++) { % 		char *cp = table->entries[i].ascic;  		cp[0] = strlen(&cp[1]);  	} 	/*  	 * Set-up descriptor  	 */" 	desc.dsc$b_dtype = DSC$K_DTYPE_T;" 	desc.dsc$b_class = DSC$K_CLASS_D; 	desc.dsc$a_pointer = 0; 	desc.dsc$w_length = 0;    	/*  	 * Fetch the symbol text  	 */9 	rc = cli$get_value(param_desc,&desc,&desc.dsc$w_length); # 	if (rc == CLI$_ABSENT) return(rc);  	if (ERROR(rc)) lib$signal(rc);    	/*  	 * Lookup the keyword value 	 */, 	rc = lib$lookup_key(&desc,table,value,0,0);   	/*  	 * Free up space for string 	 */ 	str$free1_dx(&desc);    	/* 
 	 * Return 	 */         return(rc);  }    Get_DCL_prot(param,value)       char *param;       unsigned long *value; { 0 	return(Get_DCL_keyword(param,&Prot_Tab,value)); }    Get_DCL_access(param,value)       char *param;       unsigned long *value; { 0 	return(Get_DCL_keyword(param,&Mode_Tab,value)); }    Get_DCL_qiostyle(param,value)       char *param;       unsigned long *value; { 5 	return(Get_DCL_keyword(param,&QIO_Style_Tab,value));  }    Get_DCL_hello(param,value)      char *param;       unsigned long *value; { 1 	return(Get_DCL_keyword(param,&Hello_Tab,value));  }    Get_DCL_size(param,value)       char *param;       unsigned long *value; {  	unsigned long rc;  - 	rc = Get_DCL_keyword(param,&Size_Tab,value);  	if (!ERROR(rc)) return(rc);  : 	/* No luck with keywords.  Check for a decimal number. */" 	return(Get_DCL_dec(param,value)); }   