F /* FIND, written by Joe Meadows, released to the world Sep. 8th, 1987.F    Note, this was originally called INDEX when posted to the internet,G    I changed the name to FIND to avoid confusion with the DECUS program 6    INDEX which is a Fortran cross referencing utility.@    This is a public domain utility. No parts of this utility are@    copyrighted in any way. It may be used in any way, by anyone.=    There are no restrictions on this code. You may include it '    in a commercial package if you wish.      Joe Meadows Jr. +   VAX/VMS System Manager / guru in training (   Fred Hutchinson Cancer Research Center   1124 Columbia St.    Seattle Wa. 98104       bitnet - JOE@FHCRCVAX1      arpa   - JOE%FHCRCVAX.BITNET@WISCVM.WISC.EDU       voice  - (206) 467-4970 */   /* Modification History     -------------------- 6    Sep.  8, 1987 JEM - Conversion from BETA to Release>    Sep. 25, 1987 JEM - modify all FID declaratiosn to unsignedJ    Dec. 16, 1987 JEM - Changed name from INDEX to FIND, to avoid confusion9                        with another popular DECUS program *    Jan. ??, 1989 JEM - Allow wildcard UICsA    Jan. 25, 1989 JEM - add a call to init_cli to allow definition =                        as a real command or a foreign command =    Oct 11,  1991 JEM - investigate/fix handling of file id's.  */  5 /* Ported to AXP by N. R. Arnot, NRA@UK.AC.KCL.PH.IPG   D    This isn't a wonderful port. A proper one would use <fh2def> etc.@    out of SYS$LIBRARY:SYS$LIB_C/LIBRARY rather than the .h filesH    supplied here, but that's a major rewrite. In the meantime, compilingE    with the right options and a bit of pagelet/page hackery SEEMS to      have done the trick.    */   #include <stdio.h> #include <ctype.h>   #include "hm2def.h"  #include "fh2def.h"  #include "fm2def.h"  #include "fi2def.h" 7 #include "FileInfo.h"  /* includes FAB, NAM, and XAB */ - #include "searchdef.h" /* includes DESCRIP */  #include "displaydef.h"    #include "tree.h"  #include "dirtree.h"   static int tree_depth;   globalvalue FIND_CLD;    main() { M   static struct dsc$descriptor device = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; N   static struct dsc$descriptor devdesc = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};%   static $DESCRIPTOR(defaultname,"");     static $DESCRIPTOR(null,"\0");4   static unsigned short int indexf_fid[3] = {1,1,0};-   static unsigned short int fid[3] = {0,0,0}; O   static struct dsc$descriptor filename = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; M   static struct dsc$descriptor dynstr = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; +   static long int pagecount=0,opagecount=0;    static long int offset=1;    static long int flag=0; 4   static unsigned long lastfid=0,currfid=0,endfid=0;"   static struct FileInfo *context;   static struct FAB *fabptr;   static struct NAM *namptr;%   static struct display_info display; #   static struct search_info search;    static struct hm2def *hm2;   static struct fh2def *fh2;   static struct fm2def *fm2;   static long int fm2offset;   static long int count,lbn;   static struct fi2def *fi2;   static long int status;    static char *block=0;    static long int blocknum; $   static short int chan=0,tmpchan=0;'   static long int i=0,j=0,k=0,volume=0;   %   int pagelets = pagelets_per_page();   J /* NRA this took a lot of finding: need to disable structure alignment! */ /*7   printf(" sizes fh2, fi2, fm2, hm2 are %d %d %d %d\n",      sizeof( struct fh2def),      sizeof( struct fi2def),      sizeof( struct fm2def),      sizeof( struct hm2def) );  */E /* disable image privilieges to start with, before user authorized */    init_priv();  %   status = init_cli(FIND_CLD,"FIND");   "   if (cli_present("OUTPUT") & 1) {L     /* we should see if they want output to go to a file or to SYS$OUTPUT */-     status = cli_get_value("OUTPUT",&dynstr);      if (status & 1) {         str$append(&dynstr,&null);B       freopen(dynstr.dsc$a_pointer,"w",stdout,"rfm=var","rat=cr");     };   };      (void) init_display(&display);    status = init_search(&search);$   if (!(status & 1)) return(status);  %   if (cli_present("FULLNAME")  & 1) { D     /* if FULLNAME specified, use lib$find_file to get the file ids,%        get the header, and display */ 3     while (cli_get_value("FULLNAME",&dynstr) & 1) { ;       i = 2; /* flag for lib$find_file, MULTIPLE bit set */ E       while (lib$find_file(&dynstr,&filename,&fabptr,0,0,0,&i) & 1) { #         namptr = fabptr->fab$l_nam; 6         /* assign a temporary channel to the device */4         devdesc.dsc$w_length = namptr->nam$t_dvi[0];8         devdesc.dsc$a_pointer = &(*namptr).nam$t_dvi[1];  ,         /* assign a channel to the device */1         status=sys$assign(&devdesc,&tmpchan,0,0); *         if (!(status & 1)) return(status);  A         fh2 = get_header((*namptr).nam$w_fid,(*namptr).nam$w_fid, ,                          context,1,tmpchan);         if (fh2);           if (search_header(&search,fh2,context,1,tmpchan))            { /             long fid24 = namptr->nam$w_fid[0] + @                          ((namptr->nam$w_fid[2] & 0xff00) << 8);D             display_header(&display, fid24, fh2, context,1,tmpchan);           } #         status=sys$dassgn(tmpchan); &       }; /* while (lib$find_file()) */.     }; /* while (cli_get_value("FULLNAME")) */?     /* if they did a /FULLNAME search, and didn't do a /FILE_ID /        search, then we could just quit now.. */ *     if ((cli_present("FILE_ID") & 1) == 0)
       return; '   }; /* if (cli_present("fullname")) */   C   /* get the name of the device which we're planning on checking */ %   status=cli_get_value("P1",&device); $   if (!(status & 1)) return(status);  9   /* re-enable image privileges if the user checks out */    check_priv( &device);   F   /* add in logic for /VOLUME for volume sets. If set, then go through0      each of the index files, one at a time.. */"   if (cli_present("VOLUME") & 1) {A     /* Oh boy, we need to loop through all of the index files! */      volume = 1; ,     status = get_root_name(&device,&device);&     if (!(status & 1)) return(status);   };  I   /* loop through all the index files, this is accomplished via a call */ M   /* to get_next_device at the end of the while loop (only if /VOLUME set) */    while (status & 1) {(     /* assign a channel to the device */)     status=sys$assign(&device,&chan,0,0); &     if (!(status & 1)) return(status);  K     /* find out the complete name of INDEXF.SYS (this is to be sure and get M        the device name right, even if you're sitting in a rooted directory */ 5     status = fid_to_name(&chan,indexf_fid,&filename); &     if (!(status & 1)) return(status);  G     /* don't ask for more pages than we can handle, in fact, lets leave         a mild safety net */        /* NRA 23/11/94 AXP PORTING K        The memory management code in here is "fragile" after the port. I am O        forcing pagecounts to be a multiple of whole AXP pages wherever possible I        to reduce the scope for boo-boos. This is a substitute for a major %        rewrite, not exemplary coding!       */   9     pagecount = freptecnt() - ((1024/pagelets)*pagelets);   A     /* if FILE_ID search, then map in a small part of the file */ #     if (cli_present("FILE_ID") & 1) 4       pagecount = ((10+pagelets)/pagelets)*pagelets;       offset = 1; %     /* map in part of the file now */ 9     status=map_section(&filename,&defaultname,&pagecount, /                        &offset,&flag,&context); &     if (!(status & 1)) return(status);  .     /* home block is usually block number 2 */6     hm2 = (struct hm2def *)(context->fi_l_begadr+512);  #     if (hm2->hm2$b_struclev != 2) { F       printf("Sorry, FIND only works for structure level 2 disks.\n");
       return;      };  8     offset = hm2->hm2$w_ibmapvbn + hm2->hm2$w_ibmapsize;I     context->fi_l_recoff = offset - 1; /* Store the indexf offset here */      opagecount = pagecount;      pagecount -= (offset - 1);     endfid = pagecount; 0     lastfid = context->fi_l_filsiz - offset + 1;0     fh2 = context->fi_l_begadr + 512*(offset-1);  #     if (cli_present("FILE_ID") & 1)      { =       /* if FILE_ID specified, get the header, and display */ 2       while (cli_get_value("FILE_ID",&dynstr) & 1)       { )         if (ots$cvt_ti_l(&dynstr,&i) & 1) 	         { $           if ((i & 0xff000000) != 0)           { <             printf("File ID's can't be as large as %d\n",i);           }            else           {               fid[0] = i & 0xffff;+             fid[2] = (i & 0x00ff0000) >> 8; 5             fh2 = get_header(fid,fid,context,1,chan);              if (fh2)
             { >                 if (search_header(&search,fh2,context,1,chan))                 { G                     display_header(&display, i, fh2, context, 1, chan);                  } 
             }            } 
         };       };     }      else4     for (currfid = 1; currfid <= lastfid; currfid++)     {        if (currfid > endfid)        { H         /* okay, that should have been the last one in this segment.. */7         /* lets read in the next section of the file */ $         offset = offset + pagecount;-         pagecount = opagecount;  /* OK AXP */ 2         status=map_section(&filename,&defaultname,>                            &pagecount,&offset,&flag,&context);*         if (!(status & 1)) return(status);$         endfid = endfid + pagecount;#         fh2 = context->fi_l_begadr;        };  4       if (search_header(&search,fh2,context,0,chan))B         (void)display_header(&display,currfid,fh2,context,0,chan);  /       /* okay, point to the next file header */        ++fh2;     };  1     /* call it a day, clean up and go home.... */ $     status=delete_section(&context);&     if (!(status & 1)) return(status);  
   if (volume) .     status = get_next_device(&device,&device);   else     status = 0;    }; /* while (status & 1) */      if (directory_tree != 0)   { ;     struct DirectoryNode *tmp = directory_tree->head->data;      extern display_node();  O     static struct dsc$descriptor dynstr = {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}; 3     if (cli_get_value("DISPLAY.TREE", &dynstr) & 1)      { )       ots$cvt_ti_l(&dynstr, &tree_depth);      };     if (tree_depth == 0)     {        tree_depth = 32767;      };0     tree$traverse(directory_tree, display_node);     }  }   # display_node(Node *node, DATA data)  { $     struct DirectoryNode *tmp, *pop;       tmp = node->data;      pop = tmp->parent;       /*K         search for all nodes that don't have a parent. Should find at least E         one ([4,4,0]), may find others (tmp files may have a backlink F         of [0,0,0], lost files may point to non-existent directories).  I         oops - [4,4,0] should point to itself, so special case that one..      */  ,     if (pop == 0)   /* I have no parent?! */     { G         char *this_dir = ((tmp->name) ? (tmp->name) : "unknown.DIR;1");   ;         /* total up the disk space used by any children..*/          total_children(tmp);         .         printf("[]%s %d/%d %d/%d\n", this_dir,0             tmp->blocks_used, tmp->blocks_alloc,=             tmp->total_blocks_used, tmp->total_blocks_alloc); B         if (tmp->child) display_children(tmp->child, 0, this_dir);     }      else     { K         if  /* seems like I should be able to check if my parent is me.. */ B         (           /* if (node == node->parent) should work... */!             (tmp->dirfid[0] == 4) $             && (tmp->dirfid[1] == 4)$             && (tmp->dirfid[2] == 0)	         ) 
         {     K             char *this_dir = ((tmp->name) ? (tmp->name) : "unknown.DIR;1");   ?             /* total up the disk space used by any children..*/ '             total_children(tmp->child);   8             printf("[000000]%s %d/%d %d/%d\n", this_dir,4                 tmp->blocks_used, tmp->blocks_alloc,A                 tmp->total_blocks_used, tmp->total_blocks_alloc);   F             if (tmp->child) display_children(tmp->child, 0, this_dir);	         }      } 
     return 1;  }     F display_children(struct DirectoryNode *this, int level, char *dirname) { K     /* okay, parent was displayed, so let's go down a level and across.. */ +     struct DirectoryNode *tmp = this, *pop;      char *dot;     char *semi;      !     semi = strrchr(dirname, ';'); !     dot  = strrchr(dirname, '.');      if (dot)     { '         if (strcmp(dot, ".DIR;1") == 0) 	         { C             *dot = '\0';                  /* truncate off .DIR;1 */ 	         }          else	         {               char *tmp = dirname;             while(*tmp) 
             { 7                if (isupper(*tmp)) *tmp = tolower(*tmp);                 ++tmp; 
             } 
         };     };          if (tmp == 0) return; $     if (level >= tree_depth) return;       pop = tmp->parent;     while(tmp)     { G         char *this_dir = ((tmp->name) ? (tmp->name) : "unknown.DIR;1"); 9         printf("[%s]%s %d/%d %d/%d\n", dirname, this_dir, 0             tmp->blocks_used, tmp->blocks_alloc,=             tmp->total_blocks_used, tmp->total_blocks_alloc);          if (tmp->child) 	         { O             char new_dirname[1000]; /* should be bigger than any legit stuff */   )             strcpy(new_dirname, dirname); %             strcat(new_dirname, "."); *             strcat(new_dirname, this_dir);A             display_children(tmp->child, level + 1, new_dirname); 	         }          tmp = tmp->right;      }  }   * total_children(struct DirectoryNode *node) {      /*O         recursively traverse tree, asking childred to add their totals to their          parents totals.      */     if (node == 0) return;  1     if (node->child) total_children(node->child); 1     if (node->right) total_children(node->right);   4     /* ... and add my totals to my parents values */     if (node->parent)      { C         node->parent->total_blocks_used += node->total_blocks_used; E         node->parent->total_blocks_alloc += node->total_blocks_alloc;      }  } 