#ifndef LIST_H
#define LIST_H

#if defined(__DECCXX)
#include "../EZSaveSource/EZSave.h"
#else
#include "..\EZSaveSource\EZSave.h"
#endif

#if !defined(_RWSTD_NO_NAMESPACE)
using namespace EZSave;
#endif

/********************
The class IntListBase is an abstract class designed to manage a list of integers.  The integers
are stored in increasing order.
********************/
class IntListBase
{
public:
  IntListBase() {}
  virtual ~IntListBase();

  // virtual function to insert an integer in the list
  virtual void vInsertInIntList(int data) = 0;

  // virtual function to delete an integer from the list
  virtual void vDeleteFromIntList(int data) = 0;

  // virtual function to print the entire list
  virtual void vPrintIntList() const = 0;
};

/********************
Prior to implementing an IntList class, we define class IntListNode that will store an integer
and a multiplicity.  This will be a persistent class
********************/
class IntListNode
{
private:
  int m_Data;         // the integer to be stored in the list
  int m_RepeatValue;  // >= 1, how many times the integer is repeated
  EZPtr<IntListNode> m_pNextIntListNode;  // like: IntListNode * m_pNextIntListNode;
public:
  IntListNode() {}
  IntListNode(int data) : m_Data(data), m_RepeatValue(1), m_pNextIntListNode(0) {}
  ~IntListNode();

  // print the data in the node
  void PrintIntListNode() const;

  friend class IntList;
};

/********************
Here is an implementation of the abstract class IntListBase.  This will be a persistent class
The class IntList is defined to be the root class.  When the destructor code is executed, the
entire list is deleted.  Note that this deletion occurs AFTER the current universe has been
saved.
********************/
class IntList : public IntListBase
{
private:
  EZPtr<IntListNode> m_pHeadNode;  // like: IntListNode *m_pHeadNode;
public:
  IntList();
  ~IntList();

  // implementation of virtual functions declared in base class
  void vInsertInIntList(int data);
  void vDeleteFromIntList(int data);
  void vPrintIntList() const;
};

#endif
