#include "tachyon_utilities:sample_dispatcher.h"
#include "tachyon_utilities:sample_priv_c_services.h"
#include <lib$routines.h>
#include <psldef.h>
#include <ssdef.h>



/************************************************************************/
/*									*/
/* This module contains functions that execute in kernel mode.  It is 	*/
/* better to separate privileged routines from unprivileged and place   */
/* them into two separate shareable images.  Unprivileged routines call */
/* system services, run-time library routines, etc.  Some of these 	*/
/* have baggage that causes problems when linked into a shareable	*/
/* image (the image must be made writeable, etc.).  Also, privileged    */
/* routines must not call unprivileged shareable images.  		*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/* Here we provide macros to access fields by their symbolic offsets.   */
/* The base parameter is the virtual address of the block, ofst is the 	*/
/* offset within that block. 						*/
/*									*/
/************************************************************************/

#define byte_field(base,ofst) *((unsigned char *)((char *)(base) + (ofst)))
#define word_field(base,ofst) *((unsigned short int *)((char *)(base) + (ofst)))
#define longword_field(base,ofst) *((unsigned long *)((char *)(base) + (ofst)))

#ifndef __DECC	/* If this is not DEC C, must be VAX C */
#pragma builtins
#endif


#ifdef __DECC	/* If this is DEC C */

   #pragma extern_model save
   #pragma extern_model globalvalue 
   extern int ccb$l_ucb;			/* offset of ucb in ccb */
   extern int pcb$l_phd;			/* offset of vcb in ucb */
   extern int ucb$l_vcb;			/* offset of ddt in ucb */
   extern int ucb$l_ddt;			/* offset of phd in pcb */
   #pragma extern_model strict_refdef 
   extern char *ctl$gl_ccbbase;			/* pointer to my ccbs */
   extern long *ctl$gl_pcb;			/* pointer to my pcb */
   extern long *ctl$gl_phd;			/* pointer to my phd */
   #pragma extern_model restore


#else		/* Must be VAX C */


   globalvalue ccb$l_ucb;			/* offset of ucb in ccb */
   globalvalue ucb$l_vcb;			/* offset of vcb in ucb */
   globalvalue ucb$l_ddt;			/* offset of ddt in ucb */
   globalvalue pcb$l_phd;			/* offset of phd in pcb */
   globalref char *ctl$gl_ccbbase;		/* pointer to my ccb's */
   globalref long *ctl$gl_pcb;			/* pointer to my pcb */
   globalref long *ctl$gl_phd;			/* pointer to my phd */
#endif



/************************************************************************/
/*									*/
/*									*/
/*    get_data_from_channel_number(channel_number,ucb, vcb, ddt, ccb)	*/
/*									*/
/*    This routine executes in kernel mode 				*/
/*									*/
/************************************************************************/

long get_data_from_channel_number(short int channel_number,long *ucb_addr,
		long *vcb_addr, long *ddt_addr, long *ccb_addr)

{
long ucb;
long vcb;
long ccb;
long ddt;

/************************************************************************/
/* If any of the output paramters are not writable, we will get an 	*/
/* access violation in kernel mode.  This is not cool, since it will    */
/* crash the entire system.  Therefore we probe the parameters before   */
/* actually using them.  PROBE is *like* a memory access, but it only   */
/* sets a condition code instead of getting an access violation.  If    */
/* the probe fails, we just exit.  Much  easier on the nerves.  	*/
/************************************************************************/

#ifndef __DECC	/* If this is not DEC C */
if (_PROBEW(PSL$C_USER,4,ucb_addr)!=1) return SS$_ACCVIO;
if (_PROBEW(PSL$C_USER,4,vcb_addr)!=1) return SS$_ACCVIO;
if (_PROBEW(PSL$C_USER,4,ccb_addr)!=1) return SS$_ACCVIO;
if (_PROBEW(PSL$C_USER,4,ddt_addr)!=1) return SS$_ACCVIO;
#endif


/************************************************************************/
/* DEC C doesn't seem to have builtins, so we can't use probe.  We	*/
/* declare a condition handler to trap the access violation and turn	*/
/* it into a mere return code.  Again, no crash.
/************************************************************************/

/* Establish condition handler to avoid system crashes.  DON'T use the one  */
/* 	in the C run-time library.  Probably won't work right in kernel.    */

lib$establish(lib$sig_to_ret); /* this will prevent a kernel access violation */

/* I should probably verify the channel number here, with a calculation	*/
/* based on max channelcount, but I didn't.  Next release.  		*/

/* calculate ccb address */
ccb = ((long)ctl$gl_ccbbase) - channel_number;		
/* get ucb from ccb */
ucb = longword_field (ccb, ccb$l_ucb);
/* get vcb from ucb */
vcb = longword_field (ucb, ucb$l_vcb);
/* get ddt from ucb */
ddt = longword_field (ucb, ucb$l_ddt);

*ucb_addr = ucb;
*vcb_addr = vcb;
*ddt_addr = ddt;
*ccb_addr = ccb;
return 1;
}



/************************************************************************/
/*									*/
/*									*/
/*    get_my_pcb_address(pcb)						*/
/*									*/
/*    This routine executes in kernel mode 				*/
/*									*/
/************************************************************************/

long get_my_pcb_address(long *pcb_address)				

{
long pcb;

#ifndef __DECC	/* If this is not DEC C */
if (_PROBEW(PSL$C_USER,4,pcb_address)!=1) return SS$_ACCVIO;
#endif

/* Establish condition handler to avoid system crashes.  DON'T use the one  */
/* 	in the C run-time library.  Probably won't work right in kernel.    */

lib$establish(lib$sig_to_ret);

/* Since the change mode dispatcher is kind enough to preload the value of  */
/* 	the pcb into register 4, we can just use _READ_GPR to grab it.      */
/*	However, this won't work in DEC C, because the builtin routines     */
/*	are no longer present.  Therefore we have to get it another way     */
/*	in DEC C.							    */

#ifdef __DECC	/* If this is DEC C, grab it from the control region */
pcb = *ctl$gl_pcb;
#else		/* Must be VAX C */
pcb = _READ_GPR(4);
#endif

*pcb_address = pcb;
return 1;
}



/************************************************************************/
/*									*/
/*									*/
/*    get_my_phd_address(phd)						*/
/*									*/
/*    This routine executes in kernel mode 				*/
/*									*/
/************************************************************************/

long get_my_phd_address(long *phd_address)				

{
long pcb;
long phd;
int sts;

#ifndef __DECC	/* If this is not DEC C */
if (_PROBEW(PSL$C_USER,4,phd_address)!=1) return SS$_ACCVIO;
#endif

lib$establish(lib$sig_to_ret);

/* get pcb address */

#ifdef __DECC	/* If this is DEC C, grab it from the control region */
pcb = *ctl$gl_pcb;
#else		/* Must be VAX C */
pcb = _READ_GPR(4);
#endif


/* get phd from pcb */
phd = longword_field (pcb, pcb$l_phd);

*phd_address = phd;
return 1;
}

