C	include file for ETHERWATCH

C	[Note: still needs to be cleaned up]

C External references

C Type declarations for parameters and PARAMETER statements

	integer*4	addr_len
	integer*4	e_adr_size
	integer*4	e_max_packet_size
	integer*4	e_max_str
	integer*4	e_num_params
	integer*4	e_num_rcv_buffers
	integer*4	e_protocol_c
	integer*4	e_pty_size
	integer*4	find_addr
	integer*4	find_name
	integer*4	max_nodeaddr
	integer*4	name_len
	character	nodefile*(*)
	integer*4	prot_len
	character	protocol_c_lat*(*)
	character	protocol_t_lat*(*)
	character	protocol_c_mop*(*)
	character	protocol_t_mop*(*)
	character	unknown_node*(*)
	integer*4	unknown_node_len

	parameter	(addr_len = 17)
	parameter	(e_adr_size = 6)
	parameter	(e_max_packet_size = 1500)
	parameter	(e_max_str = 100)
	parameter	(e_num_params = 5)
	parameter	(e_num_rcv_buffers = 12)
	parameter	(e_protocol_c = '0660'X)
	parameter	(e_pty_size = 2)
	parameter	(find_name = 1)
	parameter	(find_addr = 2)
	parameter	(max_nodeaddr = 2048)
	parameter	(name_len = 32)
	parameter	(nodefile = 'ETHERWATCHER:NODELIST.DAT')
	parameter	(prot_len = 5)
	parameter	(protocol_c_lat = '60-04')
	parameter	(protocol_t_lat = 'LAT')
	parameter	(protocol_c_mop = '60-02')
	parameter	(protocol_t_mop = 'MOP')
	parameter	(unknown_node = 'UNKNOWN')
	parameter	(unknown_node_len = 7)

	integer*4	eth_s_address
	integer*4	eth_s_header
	integer*4	eth_c_length
	integer*4	eth_s_protocol
	parameter	(eth_s_address = 6)
	parameter	(eth_s_header = 20)
	parameter	(eth_c_length = 1500)
	parameter	(eth_s_protocol = 2)

C Structures

	include 'DBSLIB:STRUCTURES.INC'

	structure /node_record/
		character	addr*(addr_len)
		integer*4	addrlen
		character	name*(name_len)
		integer*4	namelen
	end structure !node_record
	volatile /node_record/

	structure /eth_params/
		integer*2	param_id
		integer*4	param_value
	end structure !eth_params
	volatile /eth_params/

	structure /eth_param_desc/
		integer*4	length
		integer*4	parameters
	end structure !eth_param_desc
	volatile /eth_param_desc/

	structure /eth_addrdef/
	  union
	    map
		byte	header(eth_s_header)
	    end map
	    map
		byte	dst(eth_s_address)
		byte	src(eth_s_address)
		byte	prtcl(eth_s_protocol)
	    end map
	  end union
	end structure !eth_addrdef
	volatile /eth_addrdef/

	structure /eth_def/
	  union
	    map
		character		contents*(eth_c_length+eth_s_header)
	    end map
	    map
		record /eth_addrdef/	ethdr
		character		etdata*(eth_c_length)
	    end map
	  end union
	end structure !eth_def
	volatile /eth_def/

	record /eth_def/	packet

C Type declarations for variables

	integer*4	all_segment_size		/16/
	integer*4	hex_segment_size		/20/
	integer*4	text_segment_size		/64/

	integer*4	buffer_length
	character	command*256
	integer*4	command_len
	integer*4	cli_from
	integer*4	cli_to
	integer*4	cli_both
	integer*4	from_unknown
	integer*4	to_unknown
	character	src_address*(addr_len)
	integer*4	src_address_len
	character	src_node*(name_len)
	integer*4	src_node_len
	character	dest_address*(addr_len)
	integer*4	dest_address_len
	character	dest_node*(name_len)
	integer*4	dest_node_len
	character	default_device*10
	integer*4	default_device_len
	character	device*10
	integer*4	device_len
	character	display*12
	integer*4	display_len
	character	protocol*(prot_len)
	integer*4	protocol_len
	integer*4	tt_channel

	integer*4	status

	integer*2	log_channel
	character	prot_str*10
	integer*4	node_count

	record /eth_param_desc/		param_desc
	record /eth_params/		param_buffer(e_num_params)
	record /io_status_block/	iosb
	record /node_record/		node(max_nodeaddr)

C Commons (and includes)

	common /ether_watch_data/
	1		command
	1		,command_len
	1		,cli_from
	1		,cli_to
	1		,cli_both
	1		,from_unknown
	1		,to_unknown
	1		,src_address
	1		,src_address_len
	1		,src_node
	1		,src_node_len
	1		,dest_address
	1		,dest_address_len
	1		,dest_node
	1		,dest_node_len
	1		,default_device
	1		,default_device_len
	1		,device
	1		,device_len
	1		,display
	1		,display_len
	1		,protocol
	1		,protocol_len
	1		,prot_str
	1		,tt_channel
	1		,log_channel
	1		,iosb
	1		,status
	1		,param_desc
	1		,param_buffer
	1		,node_count
	1		,node
	1		,all_segment_size
	1		,hex_segment_size
	1		,text_segment_size
	1		,buffer_length
	1		,packet

C Data statements
