	program	etherwatch

C+
C Version:	X4-002
C
C Facility:	Diagnostic Utilities.
C
C Abstract:	Listen (in promiscuous mode) to all packets on the Ether
C		and printout its source, destination, protocol and
C		(optionally) the data in string or hexadecimal format.
C
C Environment:	Needs PHY_IO and LOG_IO privileges.
C
C	The following is the CLD used by ETHERWATCH:
C
C module etherwatch_cld
C
C define verb etherwatch
C	noparameters
C	qualifier from,		default, value (default = "*")
C	qualifier to,		default, value (default = "*")
C	qualifier both_ways
C	qualifier protocol,	default, value (default = "*")
C	qualifier device,	value (required)
C	qualifier display,	value (type = display_options )
C
C define type display_options
C	keyword	all,	default
C	keyword	none
C	keyword	hexadecimal
C	keyword	text
C
C History:
C
C	02-Apr-1990, DBS; Version X1-001
C 001 -	Original version.  Based on ETHUTIL by Mark Myers of the University
C	of Melbourne.
C	02-Apr-1990, DBS; Version X1-002
C 002 -	Added code to handle /both, /from and /to.
C	03-Apr-1990, DBS; Version X1-003
C 003 -	Added code for the /unkown qualifier and changed the code that matches
C	the addresses to nodenames.
C	09-Apr-1990, DBS; Version X1-004
C 004 -	Fix to pick up the value returned in the iosb when starting up the
C	device.
C	11-Apr-1990, DBS; Version X1-005
C 005 -	Use for_signal/stop to handle errors.
C	23-May-1990, DBS; Version X1-006
C 006 -	Added code to unpack LAT messages.
C	05-Jun-1990, DBS; Version X1-007
C 007 -	Modified to always do the LAT format on LAT messages.
C	06-Jun-1990, DBS; Version X1-008
C 008 -	Added more specific lat packet processing.
C
C	07-Jun-1990, DBS; Version X2-001
C 001 -	Major rehash for lat processing.
C	11-Jun-1990, DBS; Version X2-002
C 002 -	Put it back the way it was, all the lat stuff is now done in LATWATCH.
C	15-Jun-1990, DBS; Version X2-003
C 003 -	Bit of a cleanup, mainly with the displays.
C
C	27-Jun-1990, DBS; Version X3-001
C 001 -	Added wildcard matching on addresses and protocols.
C	29-Jun-1990, DBS; Version X3-002
C 002 -	Fix bug where packets of maximum size were being truncated.
C	09-Jul-1990, DBS; Version X3-003
C 003 -	Added control C trap so we can do a nice exit.
C	20-Nov-1991, DBS; Version X3-004
C 004 -	Use sys_find_ether_device to return the default device for this system.
C	17-Jan-1992, DBS; Version X3-005
C 005 -	Added software expiry check.
C
C	07-Jan-1993, DBS; Version X4-001
C 001 -	Major rehash to change the qualifiers so source and destination
C	addresses can be specified.
C	11-Oct-1993, DBS; Version X4-002
C 002 -	Fixed bug with packet header size.
C-

 	implicit none

	character	program_id*(*)
	parameter	(program_id = 'ETHERWATCH  X4-002')

C External references

	include 'ETHERWATCH_INC.INC/nolist'

	external	enable_controlc
	external	lib$stop
	external	lib$put_output
	external	parse_command
	external	read_nodelist
	external	startup_device
	integer*4	sys$assign
	external	sys$assign
	external	sys$hiber
	external	sys_check_software_expiry1

C Type declarations for variables

	integer*4	expiry_date		/-1/
	integer*4	check_date		/0/
	integer*4	assign_status

C+
C Mainline - etherwatch
C-

	call lib$put_output (program_id)

C	call sys_check_software_expiry1 (expiry_date, check_date)

	call read_nodelist

	call parse_command

	assign_status = sys$assign ('TT', tt_channel,,)
	if (.not. assign_status) call lib$stop (%val(assign_status))

	call enable_controlc

	call startup_device

	call sys$hiber

	end

	subroutine convert_header (formatted_destination
	1				,formatted_source
	1				,formatted_protocol)

C++
C Functional Description:
C	This routine will take the ethernet addresses and protocols from
C	the common area and format them into readable ascii text.
C
C Calling Sequence:
C
C	call convert_header (...)
C
C Formal Argument(s):
C	formatted_destination.wt.ds	Somewhere to store the destination.
C	formatted_source.wt.ds		Somewhere to store the source.
C	formatted_protocol.wt.ds	Somewhere to store the protocol.
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'

	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	address_format*(*)
	character	protocol_format*(*)

	parameter	(address_format = '!XB-!XB-!XB-!XB-!XB-!XB')
	parameter	(protocol_format = '!XB-!XB')

C Type declarations for variables

	character	formatted_destination*(*)
	character	formatted_source*(*)
	character	formatted_protocol*(*)

	integer*2	fao_len
	character	full_format*40

C+
C Mainline - convert_header
C-

	call sys$fao (%descr(address_format//address_format//protocol_format)
	1		,%ref(fao_len)
	1		,%descr(full_format)
	1		,%val(packet.ethdr.dst(1))
	1		,%val(packet.ethdr.dst(2))
	1		,%val(packet.ethdr.dst(3))
	1		,%val(packet.ethdr.dst(4))
	1		,%val(packet.ethdr.dst(5))
	1		,%val(packet.ethdr.dst(6))
	1		,%val(packet.ethdr.src(1))
	1		,%val(packet.ethdr.src(2))
	1		,%val(packet.ethdr.src(3))
	1		,%val(packet.ethdr.src(4))
	1		,%val(packet.ethdr.src(5))
	1		,%val(packet.ethdr.src(6))
	1		,%val(packet.ethdr.prtcl(1))
	1		,%val(packet.ethdr.prtcl(2)))

	formatted_destination	= full_format(01:17)
	formatted_source	= full_format(18:34)
	formatted_protocol	= full_format(35:39)

	return
	end

 	logical function lookupnode*4 (flag
	1				,nodeaddr
	1				,nodename
	1				,nodenamelen)

C++
C Functional Description:
C	This routine will scan the internal list of nodename and addresses
C	looking for a match on the values passed.  The choice of whether to
C	look for a name or address is determined by the flag.
C
C Calling Sequence:
C
C	node_found = lookupnode (...)
C
C Formal Argument(s):
C	flag.rl.r	Determines whether a search is made of the names or
C			addresses list.
C	nodeaddr.mt.ds	Either the address to look for or the address that
C			matches the specified name.
C	nodename.mt.ds	Either the name to look for or the name that matches
C			the specified address.
C	nodenamelen.ml.r  The length of the name returned.
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	.true. or .false. depending on whether a match was made.
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'

C Type declarations for variables

	integer*4	flag
	character	nodeaddr*(*)
	character	nodename*(*)
	integer*4	nodenamelen

	logical*4	found_it
	integer*4	item

C+
C Mainline - lookupnode
C-

	found_it = .false.
	lookupnode = .false.

	if (flag .eq. find_name) then
		item = 1

		do while ((item .le. node_count) .and. (.not. found_it))
			if (node(item).addr(1:node(item).addrlen)
	1				.eq. nodeaddr(1:node(item).addrlen))
	1			then
				nodename = node(item).name
				nodenamelen = node(item).namelen
				found_it = .true.
				lookupnode = .true.
			endif !(node(item).addr .eq. nodeaddr) then
			item = item + 1
		enddo !while ((item .le. node_count) .or. (.not. found_it))

		if (.not. found_it) then
			nodename = unknown_node
			nodenamelen = unknown_node_len
		endif !(.not. found_it) then
	else
	item = 1

	do while ((item .le. node_count) .and. (.not. found_it))
		if (node(item).name(1:node(item).namelen)
	1			.eq. nodename(1:node(item).namelen)) then
			nodeaddr = node(item).addr
			nodenamelen = node(item).namelen
			found_it = .true.
			lookupnode = .true.
		endif !(node(item).name .eq. nodename) then
		item = item + 1
	enddo !while ((item .le. node_count) .or. (.not. found_it))
	endif !(flag .eq. find_name) then

	return
	end

	subroutine parse_command

C++
C Functional Description:
C	This routine parses the users command.
C
C Calling Sequence:
C
C	call parse_command
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	ether_watch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'
	include '($CLIDEF)/nolist'

	integer*4	cli$dcl_parse
	external	cli$dcl_parse
	integer*4	cli$get_value
	external	cli$get_value
	integer*4	cli$present
	external	cli$present
	external	cli$_present
	external	cli$_negated
	external	cli$_locpres
	external	cli$_defaulted
	external	cli$_locneg
	external	cli$_absent
	external	etherwatch_cld
	external	lib$get_input
	logical*4	lookupnode
	external	lookupnode
	integer*4	str_len
	external	str_len
	external	str_uppercase
	external	sys_find_ether_device
	external	sys$exit

C Type declarations for parameters and PARAMETER statements

	character	cli_t_command*(*)
	parameter	(cli_t_command = 'ETHERWATCH')

C Type declarations for variables

	integer*4	slash_loc
	integer*4	space_loc
	character	from_where*(name_len)
	integer		from_where_len
	character	to_where*(name_len)
	integer		to_where_len

C+
C Mainline - parse_command
C-

	call sys_find_ether_device (default_device)
	default_device_len = str_len (default_device)

	device		= default_device
	display		= 'ALL'
	protocol	= '*'
	src_node	= '*'
	src_address	= '*'
	dest_node	= '*'
	dest_address	= '*'
	from_where	= '*'
	to_where	= '*'
	from_unknown	= .false.
	to_unknown	= .false.

	call cli$get_value ('$LINE', command, command_len)

	space_loc = index(command(1:command_len), ' ')
	slash_loc = index(command(1:command_len), '/')

	if ((space_loc .eq. 0) .and. (slash_loc .eq. 0)) then
		command = cli_t_command
	else
	if ((space_loc .lt. slash_loc) .and. (space_loc .gt. 0)) then
		command = cli_t_command//command(space_loc:)
	else
	if (slash_loc .gt. 0) command = cli_t_command//command(slash_loc:)
	endif !(space_loc .lt. slash_loc) then
	endif !((space_loc .eq. 0) .and. (slash_loc .eq. 0)) then

	command_len = str_len (command)

	status = cli$dcl_parse (command(1:command_len)
	1			,etherwatch_cld
	1			,lib$get_input
	1			,lib$get_input
	1			,'_EtherWatch: ')

	if (.not. status) call sys$exit (%val('10000000'X .or. status))

	cli_from    = cli$present ('FROM')
	cli_to      = cli$present ('TO')
	cli_both    = cli$present ('BOTH_WAYS')

	status = cli$present ('PROTOCOL')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('PROTOCOL', protocol, protocol_len)
	call str_uppercase (protocol)
	if (protocol(1:protocol_len) .eq. protocol_t_lat)
	1	protocol = protocol_c_lat
	if (protocol(1:protocol_len) .eq. protocol_t_mop)
	1	protocol = protocol_c_mop

	if ((cli_from .eq. %loc(cli$_present))
	1		.or. (cli_from .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('FROM', from_where, from_where_len)
		src_address = from_where
		src_node = from_where
		src_node_len = from_where_len
		if (.not. lookupnode(find_addr, src_address
	1			,src_node, src_node_len)) then
			if (from_where .eq. unknown_node) then
				src_address = '*'
				from_unknown = .true.
			else
			src_address = from_where
			endif
		endif
	endif !((cli_from .eq. %loc(cli$_present))

	if ((cli_to .eq. %loc(cli$_present))
	1		.or. (cli_to .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('TO', to_where, to_where_len)
		dest_address = to_where
		dest_node = to_where
		dest_node_len = to_where_len
		if (.not. lookupnode(find_addr, dest_address
	1			,dest_node, dest_node_len)) then
			if (to_where .eq. unknown_node) then
				dest_address = '*'
				to_unknown = .true.
			else
			dest_address = to_where
			endif
		endif
	endif !((cli_to .eq. %loc(cli$_present))

	status = cli$present ('DEVICE')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted)))
	1	call cli$get_value ('DEVICE', device, device_len)

	status = cli$present ('DISPLAY')
	if ((status .eq. %loc(cli$_present))
	1		.or. (status .eq. %loc(cli$_defaulted))) then
		call cli$get_value ('DISPLAY', display, display_len)
		if (display(1:1) .eq. 'A') display = 'ALL'
		if (display(1:1) .eq. 'H') display = 'HEXADECIMAL'
		if (display(1:1) .eq. 'N') display = 'NONE'
		if (display(1:1) .eq. 'T') display = 'TEXT'
	endif !((status .eq. %loc(cli$_present))

	call str_uppercase (src_address)
	call str_uppercase (dest_address)
	device_len	= str_len (device)
	display_len	= str_len (display)
	protocol_len	= str_len (protocol)
	src_address_len	= str_len (src_address)
	src_node_len	= str_len (src_node)
	dest_address_len= str_len (dest_address)
	dest_node_len	= str_len (dest_node)

	if (src_address_len .lt. addr_len) then
		if ((index(src_address, '*') .eq. 0) .and.
	1			(index(src_address, '%') .eq. 0)) then
			src_address = src_address(1:src_address_len)//'*'
			src_address_len = src_address_len + 1
		endif !(index(src_address, '*') .eq. 0) .and.
	endif !(src_address_len .lt. addr_len) then

	if (dest_address_len .lt. addr_len) then
		if ((index(dest_address, '*') .eq. 0) .and.
	1			(index(dest_address, '%') .eq. 0)) then
			dest_address = dest_address(1:dest_address_len)//'*'
			dest_address_len = dest_address_len + 1
		endif !(index(dest_address, '*') .eq. 0) .and.
	endif !(dest_address_len .lt. addr_len) then

	if (protocol_len .lt. prot_len) then
		if ((index(protocol, '*') .eq. 0) .and.
	1			(index(protocol, '%') .eq. 0)) then
			protocol = protocol(1:protocol_len)//'*'
			protocol_len = protocol_len + 1
		endif !(index(protocol, '*') .eq. 0) .and.
	endif !(protocol_len .lt. prot_len) then

	return
	end

	subroutine process_packet

C++
C Functional Description:
C	This routine makes the decision as to whether we see the packet or
C	not.  It checks the address and protocol fields against what we
C	want to look at and then displays the data in the format we have
C	selected.  Once we have processed the current packet we queue a read
C	request for another packet.
C
C Calling Sequence:
C
C	call process_packet
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	Display information is directed to sys$output.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'

	external	convert_header
	external	lib_output_seg_t
	external	lib_output_seg_tzb
	external	lib_output_seg_zb
	external	lib$put_output
	logical*4	lookupnode
	external	lookupnode
	external	queue_async_read
	integer*4	str_match
	external	str_match
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	header_format*(*)
	parameter	(header_format = '!72*-'
	1				//'!/From !AS [!AS] to !AS [!AS]'
	1				//'!/Protocol !AS'
	1				//', !4UL byte buffer at !%D!/')

C Type declarations for variables

	character	dest_adr*(addr_len)
	logical*4	dest_known
	character	dest_name*(name_len)
	integer*4	dest_namelen
	character	line*256
	integer*4	line_len
	character	pkt_prot*(prot_len)
	character	source_adr*(addr_len)
	logical*4	source_known
	character	source_name*(name_len)
	integer*4	source_namelen

C+
C Mainline - process_packet
C-

	call convert_header (dest_adr, source_adr, pkt_prot)

	if (str_match(pkt_prot, protocol)) then
		if ((str_match(source_adr, src_address(1:src_address_len))
	1	  .and. str_match(dest_adr, dest_address(1:dest_address_len)))
	1	  .or. (cli_both .and.
	1	  str_match(source_adr, dest_address(1:dest_address_len))
	1	  .and. str_match(dest_adr, src_address(1:src_address_len)))
	1	  .or. ((src_address .eq. dest_address) .and.
	1	  (str_match(source_adr, src_address(1:src_address_len))
	1	 .or. str_match(dest_adr, dest_address(1:dest_address_len)))))
	1		then
			source_known = lookupnode (find_name, source_adr
	1					,source_name, source_namelen)
			dest_known = lookupnode (find_name, dest_adr
	1					,dest_name, dest_namelen)

			if ((from_unknown .and. .not. source_known) .or.
	1			(to_unknown .and. .not. dest_known) .or.
	1			(.not. (from_unknown .or. to_unknown))) then
				buffer_length = iosb.count

				call sys$fao (%descr(header_format)
	1				,%ref(line_len)
	1				,%descr(line)
	1				,%descr(source_adr)
	1				,%descr(source_name(1:source_namelen))
	1				,%descr(dest_adr)
	1				,%descr(dest_name(1:dest_namelen))
	1				,%descr(pkt_prot)
	1				,%val(buffer_length)
	1				,%val(0))
				call lib$put_output (line(1:line_len))

				if (display .eq. 'ALL') then
					call lib_output_seg_tzb (packet.etdata
	1						,buffer_length
	1						,all_segment_size)
				else
				if (display .eq. 'TEXT') then
					call lib_output_seg_t (packet.etdata
	1						,buffer_length
	1						,text_segment_size)
				else
				if (display .eq. 'HEXADECIMAL') then
					call lib_output_seg_zb (packet.etdata
	1						,buffer_length
	1						,hex_segment_size)
				endif !((display .eq. 'HEXADECIMAL')
				endif !((display .eq. 'TEXT')
				endif !((display .eq. 'ALL')
			endif
		endif
	endif !(str_match(pkt_prot, protocol)) then

	packet.contents = ' '
	buffer_length = 0

	call queue_async_read

	return
	end

	subroutine queue_async_read

C++
C Functional Description:
C	Here we issue a qio to the ethernet device and setup an ast to
C	invoke the process_packet routine when we have something to read.
C
C Calling Sequence:
C
C	call queue_async_read
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	None
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$signal
	external	process_packet
	integer*4	sys$qio
	external	sys$qio

C+
C Mainline - queue_async_read
C-

	status = sys$qio (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_readvblk)
	1			,%ref(iosb)
	1			,process_packet,
	1			,%val(%loc(packet.etdata))
	1			,%val(eth_c_length+eth_s_header),,
	1			,%val(%loc(packet.ethdr.dst)),)

	if (.not. status) call lib$signal(%val(status))

	return
	end

	subroutine read_nodelist

C++
C Functional Description:
C	Here we read the node list file and set up the internal tables so
C	we can match addresses and names.
C
C Calling Sequence:
C
C	call read_nodelist
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	ether_watch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include		'ETHERWATCH_INC.INC/nolist'

	external	for_stop
	external	lib$put_output
	external	str_collapse
	external	str_uppercase
	integer*4	str_len
	external	str_len
	external	sys$fao

C Type declarations for parameters and PARAMETER statements

	character	fao_node_count*(*)
	character	file_error*(*)

	parameter	(fao_node_count = '!UL nodenames/addresses loaded')
	parameter	(file_error = '%ETHWATCH-I-FILERR, error opening '
	1					//nodefile)

C Type declarations for variables

	integer*4	delim_loc
	integer*4	iostatus
	character	line*132
	integer*4	line_len
	integer*4	list_lun		/81/

C+
C Mainline - read_nodelist
C-

01000	format (A)

	open (unit=list_lun, file=nodefile
	1	,readonly
	1	,access='SEQUENTIAL'
	1	,form='FORMATTED'
	1	,recordtype='VARIABLE'
	1	,status='OLD'
	1	,iostat=iostatus)

	if (iostatus .ne. 0) then
		call lib$put_output (file_error)
		call for_stop
	endif !(iostatus .ne. 0) then

	node(1).addr	= 'xx-xx-xx-xx-xx-xx'
	node(1).name	= 'NoName'
	node(1).namelen	= 6

	node_count = 1

	read (list_lun, 1000, iostat=iostatus) line

	do while ((node_count .le. max_nodeaddr) .and. (iostatus .eq. 0))
		call str_collapse (line, line)
		call str_uppercase (line, line)

		if (line(1:1) .ne. '!') then
			delim_loc = index(line, '=')

			if (delim_loc .eq. 0) then
				node(node_count).addr = line(1:addr_len)
				node(node_count).name = unknown_node
			else
			node(node_count).addr = line(1:delim_loc-1)
			node(node_count).name = line(delim_loc+1:)
			endif !(delim_loc .eq. 0) then

			node(node_count).addrlen
	1				= str_len (node(node_count).addr)
			node(node_count).namelen
	1				= str_len (node(node_count).name)
			node_count = node_count + 1
		endif !(node(node_count).name(1:1) .ne. '!') then

		read (list_lun, 1000, iostat=iostatus) line
	enddo !while ((node_count .le. max_nodeaddr) .and. (iostatus .eq. 0))

	node_count = node_count - 1

	close (list_lun)

	call sys$fao (%descr(fao_node_count)
	1		,%ref(line_len)
	1		,%descr(line)
	1		,%val(node_count))

	call lib$put_output (line(1:line_len))

	return
	end

	subroutine startup_device

C++
C Functional Description:
C	This routine attempts to startup the ethernet device, set it up so
C	we can see everything then queue the first read request to it.
C	It also displays some informational messages along the way.
C
C Calling Sequence:
C
C	call startup_device
C
C Formal Argument(s):
C	None
C
C Implicit Inputs:
C	ether_watch_data common area.
C
C Implicit Outputs:
C	ether_watch_data common area.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'
	include 'DBSLIB:NMADEF.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$put_output
	external	lib$signal
	external	queue_async_read
	integer*4	sys$assign
	external	sys$assign
	integer*4	sys$qiow
	external	sys$qiow

C+
C Mainline - startup_device
C-

	call lib$put_output ('Starting a watch on device '
	1			//device(1:device_len))

	status = sys$assign (%descr(device), %ref(log_channel),,)

	if (.not. status) call lib$signal (%val(status))

	param_desc.length		= e_num_params*6
	param_desc.parameters		= %loc(param_buffer)
	param_buffer(1).param_id	= nma$c_pcli_bus
	param_buffer(1).param_value	= e_max_packet_size
	param_buffer(2).param_id	= nma$c_pcli_bfn
	param_buffer(2).param_value	= e_num_rcv_buffers
	param_buffer(3).param_id	= nma$c_pcli_pad
	param_buffer(3).param_value	= nma$c_state_off
	param_buffer(4).param_id	= nma$c_pcli_pty
	param_buffer(4).param_value	= e_protocol_c
	param_buffer(5).param_id	= nma$c_pcli_prm
	param_buffer(5).param_value	= nma$c_state_on

	status = sys$qiow (%val(0)
	1			,%val(log_channel)
	1			,%val(io$_setmode .or. io$m_ctrl
	1				.or. io$m_startup)
	1			,%ref(iosb),,
	1			,,%val(%loc(param_desc)),,,,)

	if (.not. status) call lib$signal(%val(status))
	if (.not. iosb.value) call lib$signal (%val(iosb.value))

	call lib$put_output ('From '
	1			//src_address(1:src_address_len)
	1			//' ['//src_node(1:src_node_len)
	1			//'], to '
	1			//dest_address(1:dest_address_len)
	1			//' ['//dest_node(1:dest_node_len)//']')
	call lib$put_output ('Protocol '
	1			//protocol(1:protocol_len)
	1			//', display option '
	1			//display(1:display_len))

	call queue_async_read

	return
	end

	subroutine enable_controlc

C++
C Functional Description:
C	Setup a control c trap.
C
C Calling Sequence:
C
C	call enable_controlc
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	include 'ETHERWATCH_INC.INC/nolist'
	include '($IODEF)/nolist'

	external	lib$stop
	external	process_controlc
	integer*4	sys$qiow
	external	sys$qiow

C Type declarations for variables

	integer*4	qio_status

C+
C Mainline - enable_controlc
C-

	qio_status = sys$qiow (,%val(tt_channel)
	1			,%val(io$_setmode .or. io$m_ctrlcast),,,
	1			,process_controlc,
	1			,%val(3),,,)

	if (.not. qio_status) call lib$stop (%val(qio_status))

	return
	end

	subroutine process_controlc

C++
C Functional Description:
C	This is where we end up if a control c is used.  We just exit.
C
C Calling Sequence:
C
C	via an ast...
C
C Formal Argument(s):
C	None.
C
C Implicit Inputs:
C	None.
C
C Implicit Outputs:
C	None.
C
C Completion Codes:
C	None
C
C Side Effects:
C	None
C--

 	implicit none

C External references (and includes)

	external	lib$stop

C+
C Mainline - process_controlc
C-

	call lib$stop (%val('10000001'X))

	return
	end
