C	include file for FRAME_COUNTER

C	[Note: still needs to be cleaned up]

C External references

C Type declarations for parameters and PARAMETER statements

	integer*4	addr_len
	integer*4	e_adr_size
	integer*4	e_max_packet_size
	integer*4	e_max_str
	integer*4	e_num_params
	integer*4	e_num_rcv_buffers
	integer*4	e_protocol_c
	integer*4	e_pty_size
	integer*4	prot_len

	parameter	(addr_len = 17)
	parameter	(e_adr_size = 6)
	parameter	(e_max_packet_size = 1500)
	parameter	(e_max_str = 100)
	parameter	(e_num_params = 5)
	parameter	(e_num_rcv_buffers = 12)
	parameter	(e_protocol_c = '0660'X)
	parameter	(e_pty_size = 2)
	parameter	(prot_len = 5)

	integer*4	eth_s_address
	integer*4	eth_s_header
	integer*4	eth_c_length
	integer*4	eth_s_protocol
	integer*4	slh_c_length
	integer*4	slot_c_length
	integer*4	vch_c_length
	parameter	(eth_s_address = 6)
	parameter	(eth_s_header = 20)
	parameter	(eth_c_length = 1500)
	parameter	(eth_s_protocol = 2)
	parameter	(slh_c_length = 4)
	parameter	(slot_c_length = 1492)
	parameter	(vch_c_length = 8)

C Structures

	include 'DBSLIBRARY:STRUCTURES.INC'

	structure /eth_params/
		integer*2	param_id
		integer*4	param_value
	end structure !eth_params
	volatile /eth_params/

	structure /eth_param_desc/
		integer*4	length
		integer*4	parameters
	end structure !eth_param_desc
	volatile /eth_param_desc/

	structure /eth_addrdef/
	  union
	    map
		byte	header(eth_s_header)
	    end map
	    map
		byte	dst(eth_s_address)
		byte	src(eth_s_address)
		byte	prtcl(eth_s_protocol)
	    end map
	  end union
	end structure !eth_addrdef
	volatile /eth_addrdef/

	structure /eth_def/
		record /eth_addrdef/	ethdr
		character		etdata*(eth_c_length)
	end structure !eth_def
	volatile /eth_def/

	record /eth_def/	packet

C Type declarations for variables

	integer*4	buffer_length
	character	command*256
	integer*4	command_len
	character	default_device*10
	integer*4	default_device_len
	character	device*10
	integer*4	device_len
	real*8		display_thresh
	integer*4	elapsed_time_q(2)
	character	interrupt_time*23
	integer*4	interrupt_time_q(2)
	integer*4	io_channel
	integer*2	log_channel
	real*8		packets_per_second
	integer*4	packets_per_second_l
	character	protocol*(prot_len)
	integer*4	protocol_len
	character	reset_time*23
	integer*4	reset_time_q(2)
	integer*4	run_time_q(2)
	integer*4	status
	character	spy_address*(addr_len)
	integer*4	spy_address_len

	record /eth_param_desc/		param_desc
	record /eth_params/		param_buffer(e_num_params)
	record /io_status_block/	iosb

	integer*4	frame_size(0:1519)

C Commons (and includes)

	common /counter_data/
	1		command
	1		,command_len
	1		,default_device
	1		,default_device_len
	1		,device
	1		,device_len
	1		,log_channel
	1		,io_channel
	1		,iosb
	1		,status
	1		,param_desc
	1		,param_buffer
	1		,interrupt_time
	1		,reset_time
	1		,interrupt_time_q
	1		,reset_time_q
	1		,elapsed_time_q
	1		,run_time_q
	1		,packets_per_second
	1		,packets_per_second_l
	1		,buffer_length
	1		,protocol
	1		,protocol_len
	1		,packet
	1		,display_thresh
	1		,frame_size
	1		,spy_address
	1		,spy_address_len

C Data statements
