 /* **++ **  FACILITY:  CMEM  V1.0  ** ** **  MODULE DESCRIPTION:  **H **	This is the main module containing all user callable routines as wellH **	as the replacements for the C RTL dynamic memory management routines. **5 **	The following routines are defined in this module:  ** **	    cmem___putmsg **	    cmem___hash_index **	    cmem___get_block_size# **	    cmem___allocate_info_cluster ! **	    cmem___allocate_info_block   **	    cmem___display_block_info **	    cmem___lookup_address **	    cmem___condition_handler  **	    cmem___vm_allocate  **	    cmem___vm_free  ** **	    cmem_initialize **	    cmem_reset_display_flags  **	    cmem_show_blocks  **	    cmem_check_address  **	    cmem_collect_stack  **	    cmem_collect_time **	    cmem_boundary_check **	    cmem_protect_freed  **7 **	    cmem_malloc			(DECC: DECC$MALLOC;  VAXC: malloc) 7 **	    cmem_calloc			(DECC: DECC$CALLOC;  VAXC: calloc) 3 **	    cmem_free			(DECC: DECC$FREE;    VAXC: free) 8 **	    cmem_realloc		(DECC: DECC$REALLOC; VAXC: realloc) ** ** **  AUTHORS: **2 **      Brett Hunsaker (hunsaker@eisner.decus.org) ** ** **  CREATION DATE:  4 May 1995 ** ** **  DESIGN ISSUES: **C **	We needed some way of tracking who was allocating memory and not  **	releasing it. ** ** **  MODIFICATION HISTORY:  **5 **      4-May-1995	B. Hunsaker	Initial implementation  **. **	Necessity is truly the mother of invention. ** ** **-- */   /* ** **  ENVIRONMENT SETTINGS ** */   /*C 	For VAX C compatibility, we use the 'globalref' modifier to access D 	message codes.  This will generate a warning message with DEC C, soE 	disable that here.  If this module was only compiled with DEC C, you D 	could get away with using 'extern int <condition_name>' rather than" 	'globalref int <condition_name>'. */  
 #ifdef __DECC $ #pragma message disable( GLOBALEXT ) #endif     /*B 	We will access the frame pointer (R13) on a VAX to walk the stackC 	when we allocate memory.  This is done using the VAX C '_READ_GPR' C 	built-in function which requires the '#pragma builtins' statement.  */   #pragma builtins     /* ** **  GLOBAL CONSTANTS ** */   /*D 	This is where we remap our routine names to thoses used by the RTL. */  
 #ifdef __DECC ! #define		cmem_malloc		DECC$MALLOC ! #define		cmem_calloc		DECC$CALLOC # #define		cmem_realloc		DECC$REALLOC  #define		cmem_free		DECC$FREE  #else  #define		cmem_malloc		malloc #define		cmem_calloc		calloc #define		cmem_realloc		realloc #define		cmem_free		free #endif   #define		END_OF_LIST		-1   #define		BYTES_PER_PAGELET	512   #define		FILL_PATTERN		0xAA    #define		MAX_CALL_DEPTH		20  #define		HASH_LIST_HEADERS	8191 ! #define		BLOCK_INFO_ENTRIES	50000      /* ** **  INCLUDE FILES  ** */   #include <stdio.h> #include <string.h>    #include starlet #include lib$routines  #include ots$routines  #include prtdef  #include descrip #include ssdef   /*@ 	Some VAX sites might not have re-installed VAX C to pick up theC 	new $GETSYI codes which we use.  We'll define it here just to help E 	those sites, but it will only help if they are running VAX/VMS V5.4?  	or better.  */   #include syidef  #ifndef SYI$_PAGE_SIZEN #define SYI$_PAGE_SIZE 4452             /* Memory page size in bytes        */ #endif   #include varargs   #ifdef __ALPHA #include libicb  #endif     /* ** **  GLOBAL STRUCTURES  ** */  # typedef struct address_range_struct  {    unsigned long start_address;   unsigned long end_address; } address_range_type;      /*B 	We will need some information about each block of memory which is4 	allocated.  This will be kept within a linked list. */   struct block_info_struct {    unsigned int				next_block;    unsigned int				zone_id;   void *				user_address; !   unsigned int				requested_size; /   unsigned int				call_stack[ MAX_CALL_DEPTH ];     unsigned int				vms_time[ 2 ];   struct   { "     unsigned int			stack_good : 1;!     unsigned int			time_good : 1; &     unsigned int			do_not_display : 1;
   } flags; };     /*A 	We will initially allocate one 'conglomerated' structure so that B 	we aren't constandtly fighting the user for dynamic memory.  ThisD 	will be capable of holding a finite amount of information about allD 	the memory blocks which have been allocated.  If the user allocatesD 	more blocks then this structure can hold, we'll create an extensionA 	for this to hold the extra info.  If that one fills too, then we A 	will just keep appending more blocks as needed.  Once allocated, , 	they will never be released -- just reused. */   struct cluster_info_struct { 1   struct cluster_info_struct *		next_cluster_ptr; )   int					list_head[ HASH_LIST_HEADERS ];     int					available_block_count;   int					next_available_block; 6   unsigned char				block_in_use[ BLOCK_INFO_ENTRIES ];=   struct block_info_struct		block_info[ BLOCK_INFO_ENTRIES ];  };     /*A 	Just for the heck of it we will store all our global data in one  	structure.  */   struct global_values_struct  {     unsigned long int			page_size;(   unsigned long int			pagelets_per_page;%   unsigned long int			protected_zone; '   unsigned long int			unprotected_zone; 2   struct cluster_info_struct *		first_cluster_ptr;*   int					(*previous_exception_handler)();   unsigned char				dostack;    unsigned char				dotime;%   unsigned char				protect_allocated; !   unsigned char				protect_freed;    unsigned char				initialized;  };     /* ** **  GLOBAL VARIABLES ** */  1 static struct global_values_struct	cmem___globals  	= {/ 	    0,		/* Page size; set via $GETJPI			    */ = 	    0,		/* Pagelets/page: calculated via init routine	    */ = 	    0,		/* Protected zone id: from LIB$CREATE_VM_ZONE	    */ ? 	    0,		/* Unprotected zone id: from LIB$CREATE_VM_ZONE	    */ > 	    NULL,	/* Cluster info pointer: set in init routine	    */A 	    NULL,	/* Pointer to previous exception handler: not used  */   9 			/* ------------------------------------------------ */ * 			/*	       INITIAL MODE SETTINGS		    */9 			/* ------------------------------------------------ */ 2 	    TRUE,	/* Collect call stack info		    	    */. 	    TRUE,	/* Collect allocation time			    */< 	    FALSE,	/* Allocate with protected boundary pages	    */8 	    FALSE,	/* Set memory to no-access upon free		    */9 			/* ------------------------------------------------ */   A 	    FALSE	/* Global data initialized: set via init routine    */  	  };          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___putmsg: **E **	Provides a convience routine for accessing the capabilities of the  **	SYS$PUTMSG system service.  ** ** **  FORMAL PARAMETERS: **F **	The calling parameter list is the same as that used for LIB$SIGNAL. ** **      condition_value:" **	    Type:	Unsigned long integer **	    Access:	Input **	    Mechanism:	By value **> **	    Provides a VMS condition value to be converted to text. **
 **	fao_count:  **	    Type:	Signed integer  **	    Access:	Input **	    Mechanism:	By value **H **	    This is the number of FAO parameters associated with the message.6 **	    If not specified, then no FAO parameters exist. ** **	fao_param1: **	    Type:	Unspecified **	    Access:	Input **	    Mechanism:	By value **' **	    This is the first FAO parameter.  ** **	fao_param2: **	    Type:	Unspecified **	    Access:	Input **	    Mechanism:	By value **( **	    This is the second FAO parameter. ** ** **  RETURN VALUE:  **J **      The status returned by the call to SYS$PUTMSG is propagated to the **	calling routine.  ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **K **      Simply put the parameters into a structure on the heap and call the  **	SYS$PUTMSG system service.  ** ** **  PRECONDITIONS: **     **	None. ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **7 **	    cmem___putmsg( signaled_condition, 1, "burp!" );  ** ** **  EXCEPTIONS:  **     **  	CMEM__GETVMFAIL:  **    4 **	    We couldn't get the virtual memory we needed. ** ** **-- */  9 /* int cmem___putmsg( int condition_value, ... )			    */    int cmem___putmsg( va_alist )   0 va_dcl				/* Note that no ";" is needed.		    */   {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */     /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */      globalref int CMEM__GETVMFAIL;     /* ** **  LOCAL VARIABLES  ** */     int	    argument_count;    int *	    putmsg_array;    va_list   argument_pointer;    int	    loop;    int	    byte_size;   int	    status;      /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*3 	Get the count of arguments.  This is VMS specific.  */     va_count( argument_count ); J   argument_count &= 0xFF;    /* Deal with a little problem in DEC C	    */  5   byte_size = ( argument_count + 1 ) * sizeof( int ); 6   status = lib$get_vm( &byte_size, &putmsg_array, 0 );   if ( ( status & 1 ) != 1 )   { A     lib$signal( ( int ) &CMEM__GETVMFAIL, 1, "$PUTMSG", status );    }    else   { '     putmsg_array[ 0 ] = argument_count;   !     va_start( argument_pointer ); 3     for( loop = 1; loop <= argument_count; loop++ ) =       putmsg_array[ loop ] = va_arg( argument_pointer, int );      va_end( argument_pointer );   1     status = sys$putmsg( putmsg_array, 0, 0, 0 ); 0     lib$free_vm( &byte_size, &putmsg_array, 0 );   }      return( status );  }          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___hash_index: **C **	Converts a user address value into an index into the hash table.  ** ** **  FORMAL PARAMETERS: ** **	address:  **	    Type:	    Pointer **	    Access:	    Input **	    Mechanism:	    By value **F **	    The user address which was returned from 'malloc', 'calloc', or **	    'realloc'.  ** ** **  RETURN VALUE:  **> **	Index into hash table; ranges 0 to 'HASH_LIST_HEADERS' - 1. ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **F **	Basically do a mod function on the value.  We make some adjustmentsD **	assuming that a user will normally be allocating quadword aligned **	data structures.  ** ** **  PRECONDITIONS: **     **	None. ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **7 **	    block_index = cmem___hash_index( user_pointer );  ** ** **  EXCEPTIONS:  **     **	None. ** ** **-- */   unsigned int cmem___hash_index(  	void *			address )  {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */     /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */     /* ** **  LOCAL VARIABLES  ** */     /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*@ 	This is a simple hash function.  We get rid of the bottom threeB 	bits as good programmers will be allocating quadword aligned dataA 	structures, and thus our hash function would produce very poorly  	distributed indexes.  */  B   return( ( ( unsigned int ) address >> 3 ) % HASH_LIST_HEADERS ); }          /* **++ **  FUNCTIONAL DESCRIPTION:  ** **      cmem___get_block_size: **B **	Returns the size of a memory segment associated with a specific **	address.  ** ** **  FORMAL PARAMETERS: ** **	user_address: **	    Type:	    Pointer **	    Access:	    Input **	    Mechanism:	    By value **F **	    The user address which was returned from 'malloc', 'calloc', or **	    'realloc'.  ** ** **  RETURN VALUE:  **F **	The size of the associated memory segment in bytes.  If the address+ **	could not be found, then we return zero.  ** ** **  SIDE EFFECTS:  **
 **      None.  ** ** **  DESIGN:  **E **	The 'realloc' routine needs to know the size of the current block. / **	So, we wrote this routine to get that value.  **E **	Scan the appropriate hash linked list within each cluster until we F **	find the specified memory segment.  Return the size of the block or! **	zero if we can't find a match.  ** ** **  PRECONDITIONS: **    7 **	The 'cmem_initialize' routine must have been called.  ** ** **  CALLING SEQUENCE:  **) **  	Here is an example calling sequence:  **4 **	    size = cmem___get_block_size( user_pointer ); ** ** **  EXCEPTIONS:  **     **	None. ** ** **-- */  3 size_t cmem___get_block_size( void * user_address )  {    /* ** **  INCLUDE FILES  ** */     /* **
 **  CONSTANTS  ** */     /* ** **  STRUCTURES AND UNIONS  ** */     /* ** **  EXTERNAL ROUTINES  ** */     /* ** **  EXTERNAL CONSTANTS ** */     /* ** **  LOCAL VARIABLES  ** */     unsigned char			found_it; +   struct cluster_info_struct *	cluster_ptr;    int				block_index;      /* ** **  DECLARATIVE INITIALIZATION ** */     /* ** **  CODE ** */   /*E 	Scan all the information blocks in all the clusters to see if we can  	find this address.  */     found_it = FALSE; 1   cluster_ptr = cmem___globals.first_cluster_ptr;   L   block_index = cluster_ptr->list_head[ cmem___hash_index( user_address ) ];     while ( !found_it )    {    /*E 	If we're at the end of a linked list for a particular hash value, we . 	need to move on to the next cluster (if any). */  %     if ( block_index == END_OF_LIST )      { D       if ( ( cluster_ptr = cluster_ptr->next_cluster_ptr ) == NULL ) 	break; 
       else         block_index = > 		cluster_ptr->list_head[ cmem___hash_index( user_address ) ];     }      /*B 	If the address in the info block matches what the user passed us,C 	we've found the block.  Otherwise, keep on transversing the linked  	list. */       else     { P       if ( cluster_ptr->block_info[ block_index ].user_address == user_address ) 	found_it = TRUE; 
       elseA 	block_index = cluster_ptr->block_info[ block_index ].next_block;      }    }      /*C 	If we have no entry for that address, then return zero as the size 9 	of the block.  Otherwise, return what is actually there.  */     return( found_it ?> 		cluster_ptr->block_info[ block_index ].requested_size : 0 ); }         " void cmem___allocate_info_cluster(- 	struct cluster_info_struct * *	cluster_ptr )  {   "   globalref int CMEM__INFOEXPFAIL;       int				status;    A   status = lib$get_vm( &( sizeof( struct cluster_info_struct ) ),  		cluster_ptr, 0 );    if ( ( status & 1 ) != 1 )   { 6     lib$stop( ( int ) &CMEM__INFOEXPFAIL, 0, status );     return;    }   *   (*cluster_ptr)->next_cluster_ptr = NULL;=   (*cluster_ptr)->available_block_count = BLOCK_INFO_ENTRIES; +   (*cluster_ptr)->next_available_block = 0; "   ots$move5( 0, NULL, END_OF_LIST,B 	sizeof( (*cluster_ptr)->list_head ), (*cluster_ptr)->list_head );   ots$move5( 0, NULL, FALSE,H 	sizeof( (*cluster_ptr)->block_in_use ), (*cluster_ptr)->block_in_use );	   return;  }         6 struct block_info_struct * cmem___allocate_info_block( 	void *			user_address ) {         globalref int CMEM__NOFREEBLK;       int				status;+   struct cluster_info_struct *	cluster_ptr;    int				blocks_scanned;   int				block_index;    int				hash_index;   int				next_index;     /*- 	Find a cluster which has an available block.  */  1   cluster_ptr = cmem___globals.first_cluster_ptr; 2   while( cluster_ptr->available_block_count == 0 )   { 0     if ( cluster_ptr->next_cluster_ptr == NULL )E       cmem___allocate_info_cluster( &cluster_ptr->next_cluster_ptr );   0     cluster_ptr = cluster_ptr->next_cluster_ptr;   }      /*D 	Go find an available block.  Although the cluster header says thereB 	is an avilable block, we will check to make sure we don't go into- 	an infinite loop if there really is not one.  */     blocks_scanned = 0; 2   block_index = cluster_ptr->next_available_block;    4   while ( cluster_ptr->block_in_use[ block_index ] )   { 1     if ( ++blocks_scanned >= BLOCK_INFO_ENTRIES )      { +       lib$stop( ( int ) &CMEM__NOFREEBLK );        return( NULL );      }   .     if ( ++block_index >= BLOCK_INFO_ENTRIES )       block_index = 0;   }   '   --cluster_ptr->available_block_count; %   cluster_ptr->next_available_block = A 	( block_index == BLOCK_INFO_ENTRIES - 1 ? 0 : block_index + 1 );      /*C 	We've found an open slot.  Now hook us into the appropriate linked* 	list within this cluster. */  1   hash_index = cmem___hash_index( user_address );l@   if ( ( cluster_ptr->list_head[ hash_index ] ) == END_OF_LIST )   {m7     cluster_ptr->list_head[ hash_index ] = block_index;r   }i   else   {o6     next_index = cluster_ptr->list_head[ hash_index ];L     while( cluster_ptr->block_info[ next_index ].next_block != END_OF_LIST )D       next_index = cluster_ptr->block_info[ next_index ].next_block;C     cluster_ptr->block_info[ next_index ].next_block = block_index;_   }a 	c   /*A 	Set the block so that it indicates it is now the end of the listeD 	and return a pointer to the block.  We can't return just the index,B 	as the calling routine would not know what cluster is being used. */  B   cluster_ptr->block_info[ block_index ].next_block = END_OF_LIST;E   cluster_ptr->block_info[ block_index ].user_address = user_address;;  2   cluster_ptr->block_in_use[ block_index ] = TRUE;4   return( &cluster_ptr->block_info[ block_index ] ); }C        F void cmem___display_block_info( struct block_info_struct * block_ptr ) {e   /*? 	We'll display the information to the screen even if the 'don'tS? 	display this' flag is set.  It is up to the calling routine tom 	check that flag.l */     globalref int CMEM__UNEXPERR;S       extern void cmem___symbolize(s 	unsigned long int	address,  	char *			output_string,* 	unsigned long int	output_string_length );       int				status;   int				loop;+   unsigned short int		return_string_length;t-   struct dsc$descriptor_s	return_string_desc;d   char				return_string[ 200 ];      /*C 	The user can turn off our collection of the call stack and time of > 	allocation to improve performance.  In this case, we can only? 	display the address and size of the allocated block of memory.  */  #   if ( block_ptr->flags.time_good )O   {T5     return_string_desc.dsc$a_pointer = return_string;R3     return_string_desc.dsc$b_dtype = DSC$K_DTYPE_T;o3     return_string_desc.dsc$b_class = DSC$K_CLASS_S;t>     return_string_desc.dsc$w_length = sizeof( return_string );  D     status = sys$asctim( &return_string_length, &return_string_desc,! 		&block_ptr->vms_time[ 0 ], 0 );      if ( ( status & 1 ) != 1 )+       lib$stop( ( int ) &CMEM__UNEXPERR, 1,	) 				"$ASCTIM displaying block", status );L  1     return_string[ return_string_length ] = '\0';c-     printf( "%08X: %d bytes allocated at %s",l5 		block_ptr->user_address, block_ptr->requested_size,_ 		return_string );   }	   else   {r'     printf( "%08X: %d bytes allocated", 7 		block_ptr->user_address, block_ptr->requested_size );0   }      /*4 	Display the stack if we collected that information. */  $   if ( block_ptr->flags.stack_good )   {*      printf( "; call stack:\n" );2     for( loop = 0; loop < MAX_CALL_DEPTH; loop++ )     { /       if ( block_ptr->call_stack[ loop ] != 0 )i       {t1 	cmem___symbolize( block_ptr->call_stack[ loop ], - 				return_string, sizeof( return_string ) );p* 	printf( "  %2d: PC = %08X%s\n", loop + 1,2 			block_ptr->call_stack[ loop ], return_string );       }l     }h   }f   printf( "\n" );A  	   return;  }         1 struct block_info_struct * cmem___lookup_address(f 	void *			user_address ) {    /*C 	This routine scans all allocated blocks to see if an address might C 	be in one of the protected boundary pages.  We return a pointer toC3 	the info block if we find it, else we return NULL.  */    +   struct cluster_info_struct *	cluster_ptr;    int				block_index;_$   address_range_type		address_range;     /*> 	Scan all allocated blocks in the protected zone to see if theB 	address provided by the user is in one of the allocated segments. */  6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr )i   {iK     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )u     { 7       if ( ( cluster_ptr->block_in_use[ block_index ] )t8 	    && ( cluster_ptr->block_info[ block_index ].zone_id* 		    == cmem___globals.protected_zone ) )         {c   /*? 	Calculate the address range for this block.  If the address ofs: 	the access violation is within the allocated space, then $ 	return a pointer to the block info. */  3 	address_range.start_address = ( ( ( unsigned int )r5 		cluster_ptr->block_info[ block_index ].user_addressw 		/ cmem___globals.page_size ): 		* cmem___globals.page_size ) - cmem___globals.page_size;- 	address_range.end_address = ( unsigned int )e5 		cluster_ptr->block_info[ block_index ].user_addressu9 		+ cluster_ptr->block_info[ block_index ].requested_sizec! 		- 1 + cmem___globals.page_size;p  F 	if ( ( ( unsigned int ) user_address >= address_range.start_address )H 	    && ( ( unsigned int ) user_address <= address_range.end_address ) )5 	  return( &cluster_ptr->block_info[ block_index ] );l       }      }N   }T     return( NULL );  }s     h   int cmem___condition_handler(r)         int *           signal_arguments,t-         int *           mechanism_arguments )  {	   /*A 	THIS ROUTINE IS NOT FULLY IMPLEMENTED.  IT DOESN'T WORK WITH THEnC 	DEBUGGER AS IT SHOULD.  THE INITIALIZATION CODE DOES NOT CURRENTLYu% 	DECLARE THIS AS A CONDITION HANDLER._ */  !   globalref int CMEM__BNDRYRDVIO;l"   globalref int CMEM__BNDRYWRTVIO;       int				    status;+   struct block_info_struct *	    block_ptr;      /*D 	If we got an access violation, check to see if it was in one of ourA 	protected pages.  Display information about the associated blockt 	of memory.l */  ,   if ( signal_arguments[ 1 ] == SS$_ACCVIO )   {      if ( ( block_ptrI 	= cmem___lookup_address( ( void * ) signal_arguments[ 3 ] ) ) != NULL ) i     { 1       if ( ( signal_arguments[ 2 ] & 0x4 ) == 0 ) M         cmem___putmsg( ( int ) &CMEM__BNDRYRDVIO, 1, signal_arguments[ 3 ] );e
       elseN         cmem___putmsg( ( int ) &CMEM__BNDRYWRTVIO, 1, signal_arguments[ 3 ] );     }/+     cmem___display_block_info( block_ptr );-   }*     /*? 	There can only be one routine using the exception vector.  So,-? 	if someone was there before us, we need to invoke them so theyk 	can do whatever they want., */  :   if ( cmem___globals.previous_exception_handler != NULL )   {e7     status = cmem___globals.previous_exception_handler(nH                                 signal_arguments, mechanism_arguments );     return( status );L   }    else     return( SS$_RESIGNAL );  }t     *   int cmem___vm_allocate(* 	int *			number_of_bytes,I 	void * *		base_address,  	unsigned int *		user_argument ) {o     globalref int			CMEM__NORMAL;s#   globalref int			CMEM__EXPREGFAIL;e#   globalref int			CMEM__MALLOCFAIL;*$   globalref int			CMEM__PROTCHGFAIL;!   globalref int			CMEM__UNEXPERR;        int				status;   int				user_pages;   int				internal_pagelets;A$   address_range_type		address_range;%   address_range_type		address_range2;      /*C 	The VMS system service we use requires the size to be specified ineB 	pagelets.  We also need a page at the beginning and at the end ofD 	this space to try and detect reads and writes outside the allocated 	space.p */  B   user_pages = ( *number_of_bytes + cmem___globals.page_size - 1 ) 				/ cmem___globals.page_size; (   internal_pagelets = ( user_pages + 2 )' 				* cmem___globals.pagelets_per_page;o     /*B 	We allocate the number of pagelets.  VMS will round the number of= 	pagelets to properly align with the page size of the system.  */  A   status = sys$expreg( internal_pagelets, &address_range, 0, 0 );T   if ( ( status & 1 ) != 1 )   {g*     lib$signal( ( int ) &CMEM__EXPREGFAIL,7 			    2, number_of_bytes, internal_pagelets, status );p     base_address = NULL;     goto error_return;   }      /*B 	Protect the starting and ending pages so that the code will incur? 	an access violation when there is any attempt to read or writel 	them. */  =   address_range2.start_address = address_range.start_address;";   address_range2.end_address = address_range.start_address;   <   status = sys$setprt( &address_range2, 0, 0, PRT$C_NA, 0 );   if ( ( status & 1 ) != 1 )   {u8     lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );     base_address = NULL;     goto error_return;   }n  ;   address_range2.start_address = address_range.end_address; 9   address_range2.end_address = address_range.end_address;A  <   status = sys$setprt( &address_range2, 0, 0, PRT$C_NA, 0 );   if ( ( status & 1 ) != 1 )   { 8     lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );     base_address = NULL;     goto error_return;   }      /*A 	Determine the address to return to the user.  We want to make itp= 	so that the end of the space is next to the protected endingE 	page. */  8   *base_address = ( void * ) ( address_range.end_address7 			- *number_of_bytes - cmem___globals.page_size + 1 );    /*? 	We want to initialize any memory between the initial protectedtD 	page and the 'base_address' with a value which will be checked when 	we free the memory. */  #   ots$move5( 0, NULL, FILL_PATTERN,g@ 		( unsigned int ) *base_address - ( address_range.start_address  			+ cmem___globals.page_size ),; 		address_range.start_address + cmem___globals.page_size );    /*E 	That's it.  Re-enable ASTs if that was how it was configured when weo
 	were called.o */  !   status = ( int ) &CMEM__NORMAL;]    
 error_return:_     return( status );a }d     e   int cmem___vm_free(t 	int *				number_of_bytes,+ 	struct block_info_struct *	block_info_ptr,,! 	unsigned int *			user_argument )u {      globalref int CMEM__NORMAL;+"   globalref int CMEM__FREEWRTFAIL;"   globalref int CMEM__PROTCHGFAIL;!   globalref int CMEM__DELTVAFAIL;n       int				status;$   address_range_type		address_range;%   address_range_type		address_range2;i   char				single_character;t0   struct dsc$descriptor_s	single_character_desc;,   struct dsc$descriptor_s	check_string_desc;     /*C 	For the 'protected' zone, we expect the calling routine to pass ustA 	the address of the information block, rather than the address ofE 	allocated memory. */     /*@ 	Begin by calculating the address range of the blocks which were 	allocated.  */     address_range.start_addressu4 	= ( ( ( unsigned int ) block_info_ptr->user_address 		/ cmem___globals.page_size ): 		* cmem___globals.page_size ) - cmem___globals.page_size;   address_range.end_addressl0 	= ( unsigned int ) block_info_ptr->user_addressE 	    + block_info_ptr->requested_size - 1 + cmem___globals.page_size;N     /*? 	Check the memory preceding us to insure that it is the correctrA 	pattern.  If not, then somebody wrote into that space which is aO 	no-no.  */  "   single_character = FILL_PATTERN;:   single_character_desc.dsc$a_pointer = &single_character;4   single_character_desc.dsc$b_dtype = DSC$K_DTYPE_T;4   single_character_desc.dsc$b_class = DSC$K_CLASS_S;B   single_character_desc.dsc$w_length = sizeof( single_character );  !   check_string_desc.dsc$a_pointerrI 	= ( char * ) ( address_range.start_address + cmem___globals.page_size );r0   check_string_desc.dsc$b_dtype = DSC$K_DTYPE_T;0   check_string_desc.dsc$b_class = DSC$K_CLASS_S;    check_string_desc.dsc$w_length4 	    = ( unsigned int ) block_info_ptr->user_address5 		- ( unsigned int ) check_string_desc.dsc$a_pointer;   D   if ( lib$skpc( &single_character_desc, &check_string_desc ) != 0 )   {i(     status = ( int ) &CMEM__FREEWRTFAIL;     goto error_return;   }      /*A 	For this zone only, the user can tell us to actually release the F 	memory or else just protect it.  The latter can be used to detect use@ 	of released memory at the cost of continually increasing use of 	virtual memory. */  %   if ( cmem___globals.protect_freed )    {.     status = sys$setprt( 		&address_range,  		0, 0, PRT$C_NA, 0 );     if ( ( status & 1 ) != 1 )     { :       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }h   }l   else   {S   /*F 	We change the protection on the pages we accessed back to user-write.: 	Although the $DELTVA system service probably does this... */  ?     address_range2.start_address = address_range.start_address; =     address_range2.end_address = address_range.start_address;   >     status = sys$setprt( &address_range2, 0, 0, PRT$C_UW, 0 );     if ( ( status & 1 ) != 1 )     {b:       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }r  =     address_range2.start_address = address_range.end_address; ;     address_range2.end_address = address_range.end_address;*  >     status = sys$setprt( &address_range2, 0, 0, PRT$C_UW, 0 );     if ( ( status & 1 ) != 1 )     { :       lib$signal( ( int ) &CMEM__PROTCHGFAIL, 0, status );*       status = ( int ) &CMEM__PROTCHGFAIL;       goto error_return;     }*     /*@ 	Release the memory.  The $DELTVA system service will work greatA 	unless the user's program allocates static structures after some 6 	dynamic stuff has enlarged the virtual address space. */  0     status = sys$deltva( &address_range, 0, 0 );     if ( ( status & 1 ) != 1 )     {e9       lib$signal( ( int ) &CMEM__DELTVAFAIL, 0, status );d)       status = ( int ) &CMEM__DELTVAFAIL;        goto error_return;     }s   }u  !   status = ( int ) &CMEM__NORMAL;c    
 error_return:/     return( status );x }      L   void cmem_initialize( void ) {r     struct item_list_structt   {r&     unsigned short int		buffer_length;"     unsigned short int		item_code;     void *			buffer_address;/     unsigned short int *	return_length_address;    };     struct io_status_block_structa   {u"     unsigned int		condition_value;     unsigned int		reserved;l   };       globalref int CMEM__UNEXPERR;    globalref int CMEM__INIT;o    +   extern int cmem___start_debugger( void );f       int				status;   int				previous_ast_state;0   struct item_list_struct	getsyi_item_list[ 2 ];%   struct io_status_block_struct	iosb;f    ?   $DESCRIPTOR( protected_zone_desc, "C Debug Protected Heap" );wC   $DESCRIPTOR( unprotected_zone_desc, "C Debug Unprotected Heap" );l     /*D 	Most CMEM routine which calls this initialization routine will haveE 	already disabled AST delivery.  But it is possible that the user may_? 	call us directly.  So, we need to make sure ASTs are disabled.a  D 	There is a slight chance that an AST may fire after we were invokedF 	but before we can disable ASTs and that the AST may have invoked thisF 	routine.  To allow for this, we check the status of the 'initialized'& 	flag to see if we really need to run.  A 	Also, a user might call us twice, so it makes sense to see if we* 	were initialized before.e */  '   previous_ast_state = sys$setast( 0 );,$   if ( !cmem___globals.initialized )   {l     /*E 	We will have two virtual memory zones defined.  The 'protected' zone-@ 	has pages set to no-access both before and after each allocated@ 	chunk of memory.  The other is the standard heap with allocated 	chunks next to each other.   E 	Why not just use the protected memory scheme all the time?  Well, itt@ 	has a tendancy to eat up a LOT of virtual address space.  On anE 	Alpha with 8KByte pages, allocating 1 byte will require the use of 3n 	pages of memory (24 KBytes).b */  %     status = lib$create_user_vm_zone(a! 		&cmem___globals.protected_zone,u 		0, 		cmem___vm_allocate,n 		cmem___vm_free,  		0, 		0, 		&protected_zone_desc );U     if ( ( status & 1 ) != 1 )(       lib$stop( ( int ) &CMEM__UNEXPERR,. 			    1, "LIB$CREATE_USER_VM_ZONE", status );        status = lib$create_vm_zone(# 		&cmem___globals.unprotected_zone,h 		0, 		0, 		0, 		0, 		0, 		0, 		0, 		0, 		0, 		&unprotected_zone_desc,n 		0, 		0 );     if ( ( status & 1 ) != 1 )(       lib$stop( ( int ) &CMEM__UNEXPERR,) 			    1, "LIB$CREATE_VM_ZONE", status );;     /*B 	With the 'protect_allocate' flag set, we will put no-access pages> 	before and after the allocated memory.  For that we need some; 	information about the system's memory management hardware.  */  M     getsyi_item_list[ 0 ].buffer_length = sizeof( cmem___globals.page_size ); 5     getsyi_item_list[ 0 ].item_code = SYI$_PAGE_SIZE;nE     getsyi_item_list[ 0 ].buffer_address = &cmem___globals.page_size;b4     getsyi_item_list[ 0 ].return_length_address = 0;,     getsyi_item_list[ 1 ].buffer_length = 0;(     getsyi_item_list[ 1 ].item_code = 0;  D     status = sys$getsyiw( 0, 0, 0, &getsyi_item_list, &iosb, 0, 0 );     if ( ( status & 1 ) != 1 )O       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETSYIW for page size", status ); 1     else if ( ( iosb.condition_value & 1 ) != 1 )_L       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETSYIW (IOSB) for page size", 							iosb.condition_value );  $     cmem___globals.pagelets_per_page2 			= cmem___globals.page_size / BYTES_PER_PAGELET;     /*B 	We initially allocate a large chunk of memory to maintain all ourD 	information about the user's allocated memory.  Hopefully this willC 	prevent us from fragmenting memory while the user code is running,n@ 	but if need be, we can add more of these structures in a linked 	list. */  F     cmem___allocate_info_cluster( &cmem___globals.first_cluster_ptr );     /*B 	The format of the debug symbol table is undocumented.  So, ratherC 	than try to figure out the routine name associated with an address = 	on the call stack, we'll let the debugger do it for us in a o 	subprocess. */       cmem___start_debugger();     /*D 	Declare a condition handler to interpret an access violation error.> 	We'll use the primary exception vector.  But, if the user hasC 	already established one, then we'll call him after we've displayedo 	our information.c   	THIS ISN'T WORKING YET. */   /*5     status = sys$setexv( 0, cmem___condition_handler,n2 		0, &cmem___globals.previous_exception_handler );     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$SETEXV", status ); */     /*E 	Our global variables are set.  We'll never need to call this routineiB 	again so set the flag that all other routines check and return to 	the caller. */  &     cmem___globals.initialized = TRUE;)     cmem___putmsg( ( int ) &CMEM__INIT );u   }r     /*@ 	Restore the setting of the AST enabled bit and get out of here. */  )   if ( previous_ast_state == SS$_WASSET )b     sys$setast( 1 );  	   return;n }r     c  $ int cmem_reset_display_flags( void ) {   +   struct cluster_info_struct *	cluster_ptr;    int				block_index;	   int				total_block_count;)    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();     total_block_count = 0;  6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr )	   {_K     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )l     {r5       if ( cluster_ptr->block_in_use[ block_index ] )-       {rD 	cluster_ptr->block_info[ block_index ].flags.do_not_display = TRUE;         total_block_count++;       }      }b   }p  C   printf( "%d blocks currently in use and will not be displayed\n",( 							total_block_count );P     return( 1 ); }      f   void cmem_show_blocks( void )! {   +   struct cluster_info_struct *	cluster_ptr;l   int				block_index;e   int				displayed_block_count;g   int				hidden_block_count;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();     displayed_block_count = 0;   hidden_block_count = 0;   0   printf( "\nAllocated blocks of memory:\n\n" );6   for( cluster_ptr = cmem___globals.first_cluster_ptr;C 	cluster_ptr != NULL; cluster_ptr = cluster_ptr->next_cluster_ptr )o   { K     for( block_index = 0; block_index < BLOCK_INFO_ENTRIES; block_index++ )      {,5       if ( cluster_ptr->block_in_use[ block_index ] )t       {uC 	if ( cluster_ptr->block_info[ block_index ].flags.do_not_display )g 	  hidden_block_count++; 	elsel 	{H 	  cmem___display_block_info( &cluster_ptr->block_info[ block_index ] ); 	  displayed_block_count++;. 	}       }(     }r   }=  #   if ( displayed_block_count == 0 )uB     printf( "  -- All blocks were successfully released --\n\n" );  	   return;b }k     =   int cmem_check_address(O 	void *		address ) {   +   struct block_info_struct *	    block_ptr;u   /*9 	Check to see if the address is within one of our blocks.d */  B   if ( ( block_ptr = cmem___lookup_address( address ) ) != NULL )    {l/     printf( "Address %08X found:\n", address );a+     cmem___display_block_info( block_ptr );h   }o   elseI     printf( "Address %08X not found in any allocated block\n", address );t     return( SS$_NORMAL );n }r     s  - int cmem_collect_stack( unsigned char state )  {    /*F 	This routine determines whether or not we collect the call stack whenE 	allocating a segment of memory.  You can call this from the debugger-& 	using the CALL command.  For example:  & 	    DBG> CALL cmem_collect_stack( 1 ) */       globalref int CMEM__STACKENA;s   globalref int CMEM__STACKDIS;d       int			    status;d    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  !   cmem___globals.dostack = state;(   if ( cmem___globals.dostack )i%     status = ( int ) &CMEM__STACKENA;    else%     status = ( int ) &CMEM__STACKDIS;i     cmem___putmsg( status );   return( status );m }s        , int cmem_collect_time( unsigned char state ) {*   /*C 	This routine determines whether or not we collect the time a blockGC 	was allocated.  You can call this from the debugger using the CALLA 	command.  For example:N  % 	    DBG> CALL cmem_collect_time( 1 )R */       globalref int CMEM__TIMEENA;   globalref int CMEM__TIMEDIS;       int			    status;*    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();      cmem___globals.dotime = state;   if ( cmem___globals.dotime )$     status = ( int ) &CMEM__TIMEENA;   else$     status = ( int ) &CMEM__TIMEDIS;     cmem___putmsg( status );   return( status );d }s     d  . int cmem_boundary_check( unsigned char state ) {    /*A 	This routine allows the user to decide if memory at both ends of(B 	an allocated block is to be protected.  You can call this routine 	from the debugger as shown:  ' 	    DBG> CALL cmem_boundary_check( 1 )  */    "   globalref int CMEM__BNDRYPRTENA;"   globalref int CMEM__BNDRYPRTDIS;       int				status;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  +   cmem___globals.protect_allocated = state;t)   if ( cmem___globals.protect_allocated )v(     status = ( int ) &CMEM__BNDRYPRTENA;   else(     status = ( int ) &CMEM__BNDRYPRTDIS;     cmem___putmsg( status );   return( status );n }      s  - int cmem_protect_freed( unsigned char state )l {    /*D 	Memory that was allocated with boundary checking can be set so thatC 	an attempt to access it after it is freed will result in an access_ 	violation.o  & 	    DBG> CALL cmem_protect_freed( 1 ) */        globalref int CMEM__RELMEMPRT;"   globalref int CMEM__RELMEMREUSE;    globalref int CMEM__NOBNDYPRT;       int				status;    ,   if ( cmem___globals.initialized == FALSE )     cmem_initialize();  '   cmem___globals.protect_freed = state;a%   if ( cmem___globals.protect_freed )g   { +     if ( cmem___globals.protect_allocated )e(       status = ( int ) &CMEM__RELMEMPRT;     else(       status = ( int ) &CMEM__NOBNDYPRT;   }    else(     status = ( int ) &CMEM__RELMEMREUSE;     cmem___putmsg( status );   return( status );( }u     _  ! void * cmem_malloc( size_t size )) {	    #   globalref int			CMEM__MALLOCFAIL;l!   globalref int			CMEM__UNEXPERR;	       int				status;   int				previous_ast_state;   void *			base_address;,   struct block_info_struct *	block_info_ptr;   int				stack_index;t   #ifdef __ALPHA  %   struct invo_context_blk	invocation;i   #elsea     int *				frame_pointer;)   #endif     /*E 	This routine is AST reentrant.  We accomplish this by disabling ASTs @ 	while we are on the call stack.  The VAX C versions of 'malloc'1 	always seem to have some AST related problems...P */  '   previous_ast_state = sys$setast( 0 );e     /*D 	The standard "C" library doesn't provide any initialization routineC 	that the user needs to call.  So we need to make sure that we calla1 	the set-up routine in all user visible routines.s */  $   if ( !cmem___globals.initialized )     cmem_initialize();     /*C 	We can allocate from one of two zones depending upon what the user  	has selected. */  )   if ( cmem___globals.protect_allocated ) .     status = lib$get_vm( &size, &base_address,& 					&cmem___globals.protected_zone );   else.     status = lib$get_vm( &size, &base_address,( 					&cmem___globals.unprotected_zone );   if ( ( status & 1 ) != 1 )   {(=     lib$signal( ( int ) &CMEM__MALLOCFAIL, 1, size, status );C     base_address = NULL;     goto error_return;   }o     /*% 	Fill the allocated memory with 0xAA.d */  9   ots$move5( 0, NULL, FILL_PATTERN, size, base_address );d     /*> 	We need to record information about this block in our tables. */  >   block_info_ptr = cmem___allocate_info_block( base_address );  (   block_info_ptr->requested_size = size;/   block_info_ptr->flags.do_not_display = FALSE;a<   block_info_ptr->flags.stack_good = cmem___globals.dostack;:   block_info_ptr->flags.time_good = cmem___globals.dotime;@   block_info_ptr->zone_id = ( cmem___globals.protect_allocated ?C 	cmem___globals.protected_zone : cmem___globals.unprotected_zone );s     /*2 	Get the current time, if we are collecting stats. */     if ( cmem___globals.dotime )   { 5     status = sys$gettim( &block_info_ptr->vms_time );t     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETTIM", status );   }r     /*F 	Record the call stack for later display.  Unused entries in the arrayD 	are filled with zeros so that the display routine will know when to 	stop. */     if ( cmem___globals.dostack )l   {n     stack_index = 0;   #ifdef __ALPHA  -     lib$get_curr_invo_context( &invocation );_;     while ( lib$get_prev_invo_context( &invocation ) == 1 )g     { 1       block_info_ptr->call_stack[ stack_index++ ]_- 		= invocation.libicb$q_program_counter[ 0 ];o*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }t   #elsei  .     frame_pointer = ( int * ) _READ_GPR( 13 );  =     while ( _PROBER( 3, sizeof( int ), frame_pointer ) == 1 )      { G       block_info_ptr->call_stack[ stack_index++ ] = frame_pointer[ 4 ];t3       frame_pointer = ( int * ) frame_pointer[ 3 ];u*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }_   #endif  *     while ( stack_index < MAX_CALL_DEPTH )6       block_info_ptr->call_stack[ stack_index++ ] = 0;   }         /*E 	That's it.  Re-enable ASTs if that was how it was configured when weo
 	were called.N */  
 error_return:m  )   if ( previous_ast_state == SS$_WASSET )o     sys$setast( 1 );  $   return( ( void * ) base_address ); }i     O  . void * cmem_calloc( size_t nobj, size_t size ) {     #   globalref int			CMEM__MALLOCFAIL;s!   globalref int			CMEM__UNEXPERR;r       int				status;   int				previous_ast_state;   unsigned int			byte_size;L   void *			base_address;,   struct block_info_struct *	block_info_ptr;   int				stack_index;s   #ifdef __ALPHA  %   struct invo_context_blk	invocation;s   #endif   /*E 	This routine is AST reentrant.  We accomplish this by disabling ASTsh@ 	while we are on the call stack.  The VAX C versions of 'calloc'1 	always seem to have some AST related problems...r */  '   previous_ast_state = sys$setast( 0 );n     /*D 	The standard "C" library doesn't provide any initialization routineC 	that the user needs to call.  So we need to make sure that we call 1 	the set-up routine in all user visible routines.l */  $   if ( !cmem___globals.initialized )     cmem_initialize();     /*C 	We can allocate from one of two zones depending upon what the usert 	has selected. */     byte_size = size * nobj;)   if ( cmem___globals.protect_allocated )c3     status = lib$get_vm( &byte_size, &base_address,s& 					&cmem___globals.protected_zone );   else3     status = lib$get_vm( &byte_size, &base_address,C( 					&cmem___globals.unprotected_zone );   if ( ( status & 1 ) != 1 )   { B     lib$signal( ( int ) &CMEM__MALLOCFAIL, 1, byte_size, status );     base_address = NULL;     goto error_return;   }r     /*& 	Fill the allocated memory with zeros. */  3   ots$move5( 0, NULL, 0, byte_size, base_address );a     /*  B 	With the value calculated that we will return to the user, we can+ 	allocate a block in our information table.d */  >   block_info_ptr = cmem___allocate_info_block( base_address );  -   block_info_ptr->requested_size = byte_size;L/   block_info_ptr->flags.do_not_display = FALSE;T<   block_info_ptr->flags.stack_good = cmem___globals.dostack;:   block_info_ptr->flags.time_good = cmem___globals.dotime;@   block_info_ptr->zone_id = ( cmem___globals.protect_allocated ?C 	cmem___globals.protected_zone : cmem___globals.unprotected_zone );      /* 	Go get the current time.l */     if ( cmem___globals.dotime )   { 5     status = sys$gettim( &block_info_ptr->vms_time );e     if ( ( status & 1 ) != 1 )@       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "$GETTIM", status );   }      /*F 	Record the call stack for later display.  Unused entries in the arrayD 	are filled with zeros so that the display routine will know when to 	stop. */     if ( cmem___globals.dostack )=   {      stack_index = 0;   #ifdef __ALPHA  -     lib$get_curr_invo_context( &invocation ););     while ( lib$get_prev_invo_context( &invocation ) == 1 )      {t1       block_info_ptr->call_stack[ stack_index++ ] - 		= invocation.libicb$q_program_counter[ 0 ];n*       if ( stack_index >= MAX_CALL_DEPTH )         break;     }n   #elsei  ! /*	Follow the frame pointer... */t   #endif  *     while ( stack_index < MAX_CALL_DEPTH )6       block_info_ptr->call_stack[ stack_index++ ] = 0;   }    t     /*E 	That's it.  Re-enable ASTs if that was how it was configured when wee
 	were called.  */  
 error_return:M  )   if ( previous_ast_state == SS$_WASSET )      sys$setast( 1 );  $   return( ( void * ) base_address ); }a        % void cmem_free( void * base_address )_ {t  "   globalref int CMEM__FREEWRTFAIL;!   globalref int CMEM__FREEUNALLO;    globalref int CMEM__UNEXPERR;e       int				status;%   unsigned char			previous_ast_state;z   unsigned char			found_it;d+   struct cluster_info_struct *	cluster_ptr;c   int				block_index;n   int				previous_block_index;     /*E 	Scan all the information blocks in all the clusters to see if we can  	find this address.u */     found_it = FALSE;T1   cluster_ptr = cmem___globals.first_cluster_ptr;w  %   previous_block_index = END_OF_LIST;eL   block_index = cluster_ptr->list_head[ cmem___hash_index( base_address ) ];     while ( !found_it )'   {a   /*E 	If we're at the end of a linked list for a particular hash value, we . 	need to move on to the next cluster (if any). */  %     if ( block_index == END_OF_LIST )e     {sD       if ( ( cluster_ptr = cluster_ptr->next_cluster_ptr ) == NULL ) 	break; 
       else       {n$ 	previous_block_index = END_OF_LIST;         block_index =s> 		cluster_ptr->list_head[ cmem___hash_index( base_address ) ];       }h     }a   /*B 	If the address in the info block matches what the user passed us,C 	we've found the block.  Otherwise, keep on transversing the linked  	list. */       else     {eP       if ( cluster_ptr->block_info[ block_index ].user_address == base_address ) 	found_it = TRUE;e
       else       {/$ 	previous_block_index = block_index;A 	block_index = cluster_ptr->block_info[ block_index ].next_block;e       }m     }r   }      /*E 	If we didn't find an entry in the tables, then the user is trying toiE 	release memory that was never allocated.  Give him a trace back dumps 	to work with. */     if ( !found_it )   {	=     lib$signal( ( int ) &CMEM__FREEUNALLO, 1, base_address );,   },     else   {	   /*@ 	If this block is at the head of the list, we need to change the< 	list head.  Otherwise we need to unlink it from the middle. */  .     if ( previous_block_index == END_OF_LIST )     {cA       cluster_ptr->list_head[ cmem___hash_index( base_address ) ]l7 			= cluster_ptr->block_info[ block_index ].next_block;t     }s     else     {g@       cluster_ptr->block_info[ previous_block_index ].next_block7 			= cluster_ptr->block_info[ block_index ].next_block;t     }t     /*? 	Now let's release the memory.  If we are using the "protected"m@ 	model, we pass the address of the information block rather thanD 	the address of the allocated memory.  This prevents our user 'free'@ 	routine from having to scan through all the clusters and linked 	lists to find the block again.  */  7     if ( cluster_ptr->block_info[ block_index ].zone_idE' 					== cmem___globals.protected_zone )        status = lib$free_vm(o8 	&cluster_ptr->block_info[ block_index ].requested_size,) 	&cluster_ptr->block_info[ block_index ],g3 	&cluster_ptr->block_info[ block_index ].zone_id );_     else       status = lib$free_vm(_8 	&cluster_ptr->block_info[ block_index ].requested_size,6 	&cluster_ptr->block_info[ block_index ].user_address,3 	&cluster_ptr->block_info[ block_index ].zone_id );p  /     if ( status == ( int ) &CMEM__FREEWRTFAIL )r     {        lib$signal( status );bK       cmem___display_block_info( &cluster_ptr->block_info[ block_index ] );      }m#     else if ( ( status & 1 ) != 1 )bD       lib$stop( ( int ) &CMEM__UNEXPERR, 1, "LIB$FREE_VM", status );     /*$ 	Mark the block as no longer in use. */  4     if ( cluster_ptr->available_block_count++ == 0 )6       cluster_ptr->next_available_block = block_index;  5     cluster_ptr->block_in_use[ block_index ] = FALSE;    }D    
 error_return:h   /*F 	Restore the AST setting before exiting.  Any path out of this routineD 	had better get to this location or else ASTs might not be restored. */  )   if ( previous_ast_state == SS$_WASSET )n     sys$setast( 1 );  	   return;  }*     t  . void * cmem_realloc( void * ptr, size_t size ) {,       int				temp;   void *			new_pointer;;     /*E 	Go get the new space using our allocation routine.  If we are unable$A 	to allocate space, then return a NULL pointer.  The old space islA 	still valid and is still pointed to by the pointer passed as the   	first argument to this routine. */  $   new_pointer = cmem_malloc( size );   if ( new_pointer == NULL )     return( NULL );_     /*E 	If the first argument is a NULL pointer, then this routine acts just > 	like 'malloc'.  Return a pointer to the uninitialized memory. */     if ( ptr == NULL )     return( new_pointer );     /*E 	Copy the old memory to the new.  If the new block is larger than the C 	old, the 'cmem_malloc' routine will have fill the extra space with_ 	our 0xAA check pattern. */  7   if ( ( temp = cmem___get_block_size( ptr ) ) < size ) (     ots$move3( temp, ptr, new_pointer );   else(     ots$move3( size, ptr, new_pointer );     /*? 	Release the old memory.  This will generate a traceback if thee> 	pointer wasn't to a valid block.  Return a pointer to the new 	space.> */     cmem_free( ptr );    return( new_pointer ); }l