 #ifdef VAXC   #module AUDEVT "BOL-V1.0/OCT-95" #else ' #pragma module AUDEVT "BOL-V1.0/OCT-95"  #endif  , /* This routine audits login/login failures.  ;    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at) */   2 #include descrip	/* Definitions for descriptors */* #include jpidef		/* JPI$_xxx item codes */9 #include lib$routines	/* LIB$xxx() routine definitions */ B #ifdef __DECC		/* For VAXC, the following module doesn't exist: */1 #include nsadef		/* NSA$_xxx audit definitions */  #endif0 #include ssdef		/* SS$_xxx system error codes */. #include stdio		/* Standard I/O definitions */4 #include string		/* strxxx() function definitions */; #include starlet	/* SYS$xxx() system service definitions */   @ #include "chklgidef.h"  /* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"  /* LGIBUF structure field definitions */9 #include "lgimsgdef.h"  /* LGI$_xxx login status codes */ M #include "compdepnd.h"	/* Compiler dependencies (NSA$xxx symbols for VAXC) */   P typedef struct dsc$descriptor_s dsc;    /* Abbreviation for descriptor struct.*/  B int _nam_2_add (void*,int*);		/* Nodename to address conversion */   /***  ***/    /*** AUDEVT() ***/ /*** ======== ***/   /* Input arguments:   ,  lgistat:  Status of login attempt, by value  G  lgi:      Login buffer containing additional information. By reference   ,  curtim:   Login time (binary). By reference  L  lgidev:   Login device (original string, as passed by caller). By reference       Return codes:   	The given login status   , 	Any error code returned by SYS$AUDIT_EVENTW     */  C int audevt(int lgistat,struct LGIBUF* lgi,int *curtim,char *lgidev)  { G  /* Auditing is done by the new SYS$AUDIT_EVENT[W] system service. This H     service exists on OpenVMS VAX V6.1 and OpenVMS Alpha V6.2 and higherC     only. If we are running an older version, skip this section and *     return the given login status only. */   #ifdef V6_OK    char "  *ptr = NULL,				/* Aux pointer */  *ptr1,					/* Aux pointer */ 3  alarm_name[] = "SECURITY",		/* Audit/alarm name */ 6  trmbuf[128],				/* Output buffer for terminal info */3  parbuf[32];				/* Output buffer for parent name */     short.  retlen;				/* Return length for lib$getjpi */    int+  cnt = 4,				/* Init count for item list */ ,  addr = 0,				/* Node ID (DECnet address) */.  suprflgs = 0,				/* Audit supression flags */  status,				/* Return status */   audstat,				/* Audit status */   type,					/* Event type */    subtype,				/* Event subtype */8  flags = NSA$M_FLUSH|NSA$M_NOEVTCHECK;	/* Audit flags */  6  $DESCRIPTOR(nod,ptr);			/* Descriptor for nodename */4  $DESCRIPTOR(par,parbuf);		/* Parent process name */    struct itmlst itm[14] =  {(   8, NSA$_ALARM_NAME,     alarm_name, 0,#   4, NSA$_EVENT_TYPE,     &type, 0, &   4, NSA$_EVENT_SUBTYPE,  &subtype, 0,%   8, NSA$_TIME_STAMP,     curtim , 0,   };     K  /* First, complete the item list. Set login source (type). Since NSA$C_xxx E     symbols are different from CHKLGI/JPI, we must translate them. */     switch(lgi->L_LGISRC)  {;   case CHKLGI$_DETACHED: {subtype = NSA$C_DETACHED; break;} ;   case CHKLGI$_BATCH:    {subtype = NSA$C_BATCH;    break;} ;   case CHKLGI$_NETWORK:  {subtype = NSA$C_NETWORK;  break;}    case CHKLGI$_DECWINDOWS:;   case CHKLGI$_LOCAL:    {subtype = NSA$C_LOCAL;    break;} ;   case CHKLGI$_DIALUP:   {subtype = NSA$C_DIALUP;   break;} ;   case CHKLGI$_REMOTE:   {subtype = NSA$C_REMOTE;   break;}   }@  /* Include the username. This is either a valid username or oneF     of the pseudo strings "<login>", "<batch>", "<net>" or "<det>". */  '  itm[cnt].size = strlen(lgi->T_USRNAM);   itm[cnt].code = NSA$_USERNAME; !  itm[cnt++].info = lgi->T_USRNAM;   I  /* If this is a detached process, include the 'parent username' as well.      This is our username. */  '  if (lgi->L_LGISRC == CHKLGI$_DETACHED)   {O   status = lib$getjpi(&JPI$_USERNAME,0,0,0,&par,&retlen);    /* Get username */   *   if (status != SS$_NORMAL) return status;  ;   /* The username is returned with blanks filled, so we use /      strcspn to determine the actual length. */   &   itm[cnt].size = strcspn(parbuf," ");'   itm[cnt].code = NSA$_PARENT_USERNAME;    itm[cnt++].info = parbuf;   }  %  /* Include UIC if non-zero value. */     if (lgi->L_UIC)  {   itm[cnt].size = 4;%   itm[cnt].code = NSA$_SUBJECT_OWNER;     itm[cnt++].info = &lgi->L_UIC;  }  else   {?   /* If no known UIC could be obtained, tell SYS$AUDIT_EVENT to "      suppress this information. */  @   suprflgs = NSA$M_SUBJECT_OWNER;	/* Do not display UIC info. */     itm[cnt].size = 4;    itm[cnt].code = NSA$_SUPPRESS;   itm[cnt++].info = &suprflgs;  }2  /* If a login device was supplied, include it. */    if (lgidev != NULL)  {   strcpy(trmbuf,lgidev);  :   /* Include the physicl device name as well, unless it is2      the same string as the given login device. */  &   if (strcmp(lgidev,lgi->T_PHYDEVNAM))   {     strcat(trmbuf,", ");   #    strcat(trmbuf,lgi->T_PHYDEVNAM);    } -   /* Include the access port name, if any. */      if (strlen(lgi->T_ACCPORNAM))    {     strcat(trmbuf,", ");   #    strcat(trmbuf,lgi->T_ACCPORNAM);    }    /* Setup item item list. */   !   itm[cnt].size = strlen(trmbuf);     itm[cnt].code = NSA$_TERMINAL;   itm[cnt++].info = trmbuf;   },  /* If remote info was given, include it. */    if (strlen(lgi->T_REMINF))   {#   ptr = strstr(lgi->T_REMINF,"::");      ptr1 = lgi->T_REMINF;   }:  /* If the access port name of the given terminal includes9     a REMNOD::REMUSR pair, we will include it as well. */    #  else if (strlen(lgi->T_ACCPORNAM))   {&   ptr = strstr(lgi->T_ACCPORNAM,"::");     ptr1 = lgi->T_ACCPORNAM;  }1  /* If we have remote information, include it. */   	  if (ptr)   {-   itm[cnt].size = strlen(ptr1) - strlen(ptr); '   itm[cnt].code = NSA$_REMOTE_NODENAME;    itm[cnt].info = ptr1;   &   /* Setup descriptor for nodename. */  #   nod.dsc$w_length = itm[cnt].size; &   nod.dsc$a_pointer = itm[cnt++].info;  "   itm[cnt].size = strlen(ptr) - 2;'   itm[cnt].code = NSA$_REMOTE_USERNAME;     itm[cnt].info = (char*) ptr+2;  A   /* Convert the nodename to a node address. This is done a short 1      macro program. Thanks to Wolfgang J. Moeller D      (moeller@gwdvms.dnet.gwdg.de) for showing me how to do this. */       $   status = _nam_2_add (&nod, &addr);  )   /* Include this information as well. */      itm[++cnt].size = 4;&   itm[cnt].code = NSA$_REMOTE_NODE_ID;   itm[cnt++].info = &addr;  }G  /* In the case of batch, detached and network logins, we don't want to G     display a terminal name, so tell SYS$AUDIT_EVENT to suppress it. */     switch (lgi->L_LGISRC)   {   case CHKLGI$_DETACHED:   case CHKLGI$_BATCH:    case CHKLGI$_NETWORK:    { @    /* If suprflgs is non-zero, there is already an NSA$_SUPPRESS>       entry in the item list. Simply set the approbiate bit in8       'suprflgs'. Otherwise, create a new item entry. */      if (!suprflgs)     {     itm[cnt].size = 4;"     itm[cnt].code = NSA$_SUPPRESS;      itm[cnt++].info = &suprflgs;    }B    suprflgs |= NSA$M_TERMINAL;	/* Do not display terminal info. */   }   }F  /* Now setup and complete the list, depending on the given status. */     if (lgistat & 1)   {,   /* Successful login. Update event type. */     type = NSA$C_MSG_LOGIN;   C   /* If the status isn't SS$_NORMAL, it is a license-related status &      which we will include as well. */     if (lgistat != SS$_NORMAL)   {     itm[cnt].size = 4; %    itm[cnt].code = NSA$_FINAL_STATUS;     itm[cnt++].info = &lgistat;   }   }  else   {@   /* If this a login failure, set the event type and include the      reason for the failure. */      if (lgistat != LGI$_EVADE)   {     type = NSA$C_MSG_LOGFAIL;         itm[cnt].size = 4; %    itm[cnt].code = NSA$_FINAL_STATUS;     itm[cnt++].info = &lgistat;   }    else   { D    /* In the case of break-in evasion, set the type and final statusF       accordingly. We also have to include the given password here. */      type = NSA$C_MSG_BREAKIN;         itm[cnt].size = 4; %    itm[cnt].code = NSA$_FINAL_STATUS;     itm[cnt++].info = &lgistat;  )    itm[cnt].size = strlen(lgi->T_PASSWD); !    itm[cnt].code = NSA$_PASSWORD; #    itm[cnt++].info = lgi->T_PASSWD;    }   }*  /* Mark the current item entry as end. */  #  itm[cnt].size = itm[cnt].code = 0;   6  /* Generate the alarm message. It is displayed on all:     operator terminals with the SECURITY class enabled. */  :  status = sys$audit_eventw (0, flags, itm, &audstat, 0,0);    /* Return error status. */   )  if (status != SS$_NORMAL) return status;   +  if (audstat != SS$_NORMAL) return audstat;   5  /* Generate the audit message which is included into .     the audit journal file. We must change the/     NSA$_ALARM_NAME item to NSA$_AUDIT_NAME. */     itm[0].code = NSA$_AUDIT_NAME;   <  /* In addition, in audit messages, an invalid username must:     be displayed. The invalid name, if given, is stored in>     lgi->T_BADNAM, the item entry pointing to the username has+     the index 4. Just update this entry. */     if (lgi->T_BADNAM[0])  {&   itm[4].size = strlen(lgi->T_BADNAM);   itm[4].info = lgi->T_BADNAM;  }  /* Generate audit message. */  :  status = sys$audit_eventw (0, flags, itm, &audstat, 0,0);    /* Return error status. */   )  if (status != SS$_NORMAL) return status;   +  if (audstat != SS$_NORMAL) return audstat;   H  /* That's all. Pass the given login status back to the main routine. */   #endif	/* V6_OK */    return lgistat; } 