/*
    CD_PLAYER V1.0, June 1994
    Based on CD_PLAYER Version 0.3 & 0.4 by Joe Meadows

    Released to the Public Domain. Yep, this means you can do anything with it.
    I'd personally like you to keep this header intact, so that folks can track
    what's happened, who's done what, and so forth, as well as be able to find
    pointers back to where they can get the most current version.

    Requirements:

        You need a logical name "DECW$CD_PLAYER" defined to point to the CD
        drive (name borrowed from decw$examples:decw$cdplayer.c).
    
        You need a CDrom drive that supports audio. Third party drives which
        support the SCSI audio standards should work, but I've only had an
        RRD42 to test with. Hopefully I haven't built in any unnecessary
        dependencies.

        You need DIAGNOSE and PHY_IO privilege. The program could cause the
        SCSI bus to reset or hang. I haven't had any destructive problems
        yet, but it is quite possible. You can INSTALL the program with these
        privileges to make it generally available to non-privileged users.

        You need Motif, VAX C (hmm, I'll have to GNU'ize this), and of
        course, VAX/VMS (to be alphatized shortly?)

    Future directions:

        Add a balance control. Add a 'mono' control (I believe it's possible).
        Improved resource handling (and include customize menu).
	Add Help.

        General code cleanup (hey, I'm just [re]learning Motif and SCSI junk).

    Modification history:
        June 2, 1992    First release - no warranty of any sort.
        June 7, 1992    A few mods, nothing too exciting.
        Jun. 10, 92     Rename to CD_PLAYER, and general cleanup,
                        include VUE$CD_PLAYER.COM, and CD_PLAYER.DAT
        Jun. 13, 92     More cleanup, rename UIL objects, change behaviour
                        of the lock toggle, improve handling of the
                        play/resume/stop radio-box.
        Aug. 28, 92     Initial cut at DB...
        May/June 1994   IMK @ Anglia.ac.uk
		        (See CMS library for details of changes)
*/

/* Compile-time choices (booleans) */
#define display_logo 0  /* CD-ROM logo on main display? */
#define display_icon 1  /* CD-ROM logo as the icon? */

#define msg_no_vol "Sorry - no volume control available"
#define msg_repeat "Auto-repeat"
#define msg_playlist_shuffled "Playing a shuffled playlist"
#define msg_playlist "Playing a playlist"
#define msg_playlist_rpt_shuffled "Playing a repeating shuffled playlist"
#define msg_playlist_rpt "Playing a repeating playlist"
#define msg_playlist_saved "Playlist saved"
#define msg_playlist_cleared "Previous saved selection cleared"
#define msg_playlist_none "No selections to be saved"
#define msg_no_cd "No CD in drive"

/* Minimum size for main window - NOT the default size */
/* (The default is in DECW$USER_DEFAULTS:<gbl_app_name>.DAT) */
#define MinWidthPixels 80
#define MinHeightPixels 40

#include <Mrm/MrmAppl.h>
#include <Xm/Text.h>
#include <X11/Xresource.h>
#include <Xm/SelectioB.h>

#include descrip
#include ctype
#include math
#include time

#include "cdrom-data.h"

typedef struct dsc$descriptor_s string;
#define string_dynamic {0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0}
#define PPTR(x) ((x)->dsc$a_pointer)
#define PLEN(x) ((x)->dsc$w_length)
#define SPTR(x) ((x).dsc$a_pointer)
#define SLEN(x) ((x).dsc$w_length)
#ifndef NULL
#define NULL (void *)(0)
#endif
#ifndef MAX
#define MAX(a,b) (((b) > (a)) ? (b) : (a))
#endif
#ifndef MIN
#define MIN(a,b) (((b) < (a)) ? (b) : (a))
#endif

#define nFiles(x) (sizeof(x) / sizeof(char *))
#define nRegs(x) (sizeof(x) / sizeof(MrmRegisterArg))

#define mainWindow 0
#define labelAlbumTitle 1
#define labelAlbumTotalTime 2
#define labelAlbumRemaining 3
#define labelAlbumTotalTracks 4
#define labelSongTitle 5
#define labelSongTotalTime 6
#define windowTracksEdit 7
#define arrowLeft 8
#define scaleCurrentTrack 9
#define arrowRight 10
#define listTracks 11
#define buttonEditTrackSave 12
#define buttonEditTrackCancel 13
#define labelAlbumCurrentTrack 14
#define sliderTrackTime 15
#define buttonPlay 16
#define buttonResume 17
#define buttonStop 18
#define sliderLabel 19
#define buttonEject 20
#define buttonLock 21
#define sliderVolume 22
#define sliderVolumeLabel 23
#define sliderAlbumTime 24
#define sliderAlbumLabel 25
#define buttonAutoRepeat 26
#define buttonAutoEject 27
#define buttonAlbumSliderAction 28
#define buttonSongSliderAction 29
#define buttonTrackSliderAction 30
#define windowIntervalSelector 31
#define intervalSlider 32
#define intervalSliderLabel 33
#define textAlbumTitle 34
#define button_form 35
#define buttonShufflePlay 36
#define buttonAutoStart 37
#define windowTrackSelector 38
#define buttonSelectTrack 39
#define buttonSelectTrackDone 40
#define buttonSelectTrackCancel 41
#define textSongTitle 42
#define tracksList 43
#define buttonSelectTrackClear 44
#define buttonSelectTrackAll 45
#define buttonSelectTrackSave 46
#define buttonSelectTrackEdit 47
#define track_edit_text 48
#define buttonEditTrackNext 49
#define albumSelectionBox 50
#define albumEditorList 51
#define albumEditorPanedWindow 52
#define albumEditorLowerScrolledWindow 53
#define albumEditorUpperScrolledWindow 54
#define albumEditorBulletinBoard 55
#define windowMainContents 56
#define playlistWindow 57
#define messageWindow 58
#define buttonPause 59
#define buttonBack 60
#define buttonForward 61
#define playlistLabel 62
#define CD_logo 63
#define MaxWidgets 64

#define max_tracks 255
#define big_text_buffer 4096
#define medium_text_buffer 255
#define small_text_buffer 15

/* Tracks editor functions */
#define edit_setup 0
#define edit_next 1
#define edit_done 2
#define edit_curr 3
#define edit_update 4
#define edit_begin 5

static unsigned char *gbl_default_font;
static unsigned char *gbl_title = "CD Player";
static unsigned char *gbl_app_name = "Cd_player";
static MrmHierarchy Hierarchy;
static MrmCode class;
static Widget topLevel, WidgetId[MaxWidgets];
static play_list[max_tracks], play_count, pl_pending_play_count, pl_album_time;
static string null_string = {1, 0, 0, "\0"};
static unsigned exit_block[4];

void
    WidgetCreated(),
    ChangeTrack(),
    ChangeSlider(),
    PlayButtonToggled(),
    ResumeButtonToggled(),
    PauseButtonToggled(),
    StopButtonToggled(),
    EjectButtonPushed(),
    LockButtonToggled(),
    volumeDrag(),
    volumeChanged(),
    update_track_slider_label(),
    update_song_slider_label(),
    update_album_slider_label(),
    AutoStartButtonToggled(),
    AutoRepeatButtonToggled(),
    AutoEjectButtonToggled(),
    AlbumSliderActionToggled(),
    SongSliderActionToggled(),
    TrackSliderActionToggled(),
    update_interval_slider(),
    change_interval(),
    change_interval_ok(),
    change_interval_apply(),
    change_interval_cancel(),
    tracks_select_setup(),
    tracks_select_done(),
    tracks_select_cancel(),
    tracks_select_all(),
    tracks_select_clear(),
    tracks_select_save(),
    tracks_select_edit(),
    tracks_edit_save(),
    tracks_edit_cancel(),
    tracks_edit_next(),
    ShuffleButtonToggled(),
    ExitProc(),
    AlbumEditDone(),
    album_title_changed(),
    song_title_changed(),
    save_customize_settings(),
    cd_db_create_dialog(),
    albumListSelectionMade(),
    playlist_ok(),
    playlist_cancel(),
    tracks_edit_entry_begin(),
    start_watch(),
    stop_watch(),
    /* above routines are UIL callbacks, below are used locally.. */
    main_start_watch(),
    main_stop_watch(),
    tracks_start_watch(),
    tracks_stop_watch(),
    set_logo(),
    delete_unwanted_buttons(),
    set_one_play_button(),
    set_playlist_label(),
    auto_repeat_off(),
    auto_eject_off(),
    shuffle_mode_on(),
    shuffle_mode_off(),
    change_album_title(),
    change_song_title(),
    handle_disk_change(),
    handle_display_update(),
    cd_start_play(),
    cd_begin_play(),
    reset_playlist(),
    set_playlist_from_db(),
    set_track_list();

int
    cd_shuffle_play(),
    cd_selected_play();

MrmRegisterArg regvec[] =
{
    {"WidgetCreated",               (caddr_t) WidgetCreated},
    {"ChangeTrack",                 (caddr_t) ChangeTrack},
    {"update_track_slider_label",   (caddr_t) update_track_slider_label},
    {"update_song_slider_label",    (caddr_t) update_song_slider_label},
    {"update_album_slider_label",   (caddr_t) update_album_slider_label}, 
    {"PlayButtonToggled",           (caddr_t) PlayButtonToggled},
    {"ResumeButtonToggled",         (caddr_t) ResumeButtonToggled},
    {"PauseButtonToggled",          (caddr_t) PauseButtonToggled},
    {"StopButtonToggled",           (caddr_t) StopButtonToggled},
    {"LockButtonToggled",           (caddr_t) LockButtonToggled},
    {"EjectButtonPushed",           (caddr_t) EjectButtonPushed},
    {"volumeDrag",                  (caddr_t) volumeDrag},
    {"volumeChanged",               (caddr_t) volumeChanged},
    {"AutoStartButtonToggled",      (caddr_t) AutoStartButtonToggled},
    {"AutoRepeatButtonToggled",     (caddr_t) AutoRepeatButtonToggled},
    {"AutoEjectButtonToggled",      (caddr_t) AutoEjectButtonToggled},
    {"AlbumSliderActionToggled",    (caddr_t) AlbumSliderActionToggled},
    {"SongSliderActionToggled",     (caddr_t) SongSliderActionToggled},
    {"TrackSliderActionToggled",    (caddr_t) TrackSliderActionToggled},
    {"update_interval_slider",      (caddr_t) update_interval_slider}, 
    {"change_interval",             (caddr_t) change_interval},
    {"ok_change_interval",          (caddr_t) change_interval_ok},
    {"apply_change_interval",       (caddr_t) change_interval_apply},
    {"cancel_change_interval",      (caddr_t) change_interval_cancel},
    {"ShuffleButtonToggled",        (caddr_t) ShuffleButtonToggled},
    {"album_title_changed",         (caddr_t) album_title_changed},
    {"song_title_changed",          (caddr_t) song_title_changed},
    {"cd_db_create_dialog",         (caddr_t) cd_db_create_dialog},
    {"AlbumEditDone",               (caddr_t) AlbumEditDone},
    {"albumListSelectionMade",      (caddr_t) albumListSelectionMade},
    {"save_customize_settings",     (caddr_t) save_customize_settings},
    {"tracks_select_setup",         (caddr_t) tracks_select_setup},
    {"tracks_select_done",          (caddr_t) tracks_select_done},
    {"tracks_select_cancel",        (caddr_t) tracks_select_cancel},
    {"tracks_select_all",           (caddr_t) tracks_select_all},
    {"tracks_select_clear",         (caddr_t) tracks_select_clear},
    {"tracks_select_save",          (caddr_t) tracks_select_save},
    {"tracks_select_edit",          (caddr_t) tracks_select_edit},
    {"tracks_edit_save",            (caddr_t) tracks_edit_save},
    {"tracks_edit_cancel",          (caddr_t) tracks_edit_cancel},
    {"tracks_edit_next",            (caddr_t) tracks_edit_next},
    {"playlist_ok",                 (caddr_t) playlist_ok},
    {"playlist_cancel",             (caddr_t) playlist_cancel},
    {"tracks_edit_entry_begin",     (caddr_t) tracks_edit_entry_begin},
    {"ExitProc",                    (caddr_t) ExitProc}
};

static XtAppContext app_context;

static int
    gbl_interval_wannabe,
    gbl_interval_original,
    gbl_interval;

static Boolean
    gbl_db_open = 0,
    gbl_lock_cd = 0,
    gbl_auto_start = 0,
    gbl_auto_repeat = 0,
    gbl_auto_eject = 0,
    gbl_playlist_ok = 0,
    gbl_cd_was_playing = 0,
    gbl_cd_paused = 0,
    gbl_playlist_check = 0,
    gbl_setting_buttons = 0,
    gbl_shuffle_play = 0,
    gbl_selected_play = 0,
    gbl_album_slider_action = 0,
    gbl_album_slider_inuse = 0,
    gbl_song_slider_action = 0,
    gbl_song_slider_inuse = 0,
    gbl_track_slider_action = 0,
    gbl_track_slider_inuse = 0;


/* get_value convenience routine (ok, so it should be a macro) */
void get_value(Widget widget, void *resource, void *value)
{
    Arg arg;

    XtSetArg(arg, resource, value);
    XtGetValues(widget, &arg, 1);
}

/* set_value convenience routine (ok, so it should be a macro) */
void set_value(Widget widget, void *resource, void *value)
{
    Arg arg;

    XtSetArg(arg, resource, value);
    XtSetValues(widget, &arg, 1);
}

/* Pop-up message window */
void display_message (char *message)
{
    XmString tmp;

    if (WidgetId[messageWindow])
    {
	tmp = XmStringCreateLtoR(gbl_title, gbl_default_font);
	set_value(WidgetId[messageWindow],XmNdialogTitle, tmp);	
        XmStringFree(tmp);
	tmp = XmStringCreateLtoR(message, gbl_default_font);
	set_value(WidgetId[messageWindow],XmNmessageString, tmp);	
        XmStringFree(tmp);
	XtManageChild (WidgetId[messageWindow]);
    }
    else
    {
	printf (message); printf ("\n");
    }
}

void give_no_cd_msg()
{
    display_message (msg_no_cd);
}

main(int argc, char *argv[])
{
    int status;

    status = cd_allocate();
    if (!(status & 1))
    {
        printf("Unable to allocate a channel to DECW$CD_PLAYER\n");
        return status;
    }

    status = db_open_cd_databases();
    if (!(status & 1))
    {
        printf("Unable to open/create CD database\n");
        gbl_db_open = 0;
    }
    else
    {
        gbl_db_open = 1;
    }

    MrmInitialize();

    topLevel = XtAppInitialize(&app_context, gbl_app_name, NULL,
                               0, &argc, argv, NULL, NULL, 0);

    status = MrmOpenHierarchy(1, &gbl_app_name, NULL, &Hierarchy);
    if (status != MrmSUCCESS)
    {
        printf("Error accessing UID file %s\n", gbl_app_name);
        return status;
    }

    MrmRegisterNames(regvec, nRegs(regvec));
    if (status != MrmSUCCESS)
    {
        printf("Unable to  register names for UIL interface.\n");
        return status;
    }

    status = MrmFetchWidget(Hierarchy, "main_window", topLevel,
                             &WidgetId[mainWindow], &class);
    if (status != MrmSUCCESS)
    {
        printf("Error fetching main window widget from UIL interface\n");
        return status;
    }

    /* set the minimum size for the window (we get errors/mess if smaller) */
    set_value(topLevel, XmNminWidth, MinWidthPixels);
    set_value(topLevel, XmNminHeight, MinHeightPixels);

    gbl_default_font = XGetDefault
    (
        XtDisplay(topLevel),
        gbl_app_name,
        "defaultFont"
    );
    if (gbl_default_font == 0) gbl_default_font = "ISO8859-1";

    /* Set main title */
    set_title();

    /* If there's no main window logo, may still need to set the icon. */
    /* (The other route is via the WidgetCreated callback for the logo widget.) */
    /* If there's no logo widget.. */
    if (!WidgetId[CD_logo] && !display_logo && display_icon)
    {
	set_logo();
    }

    /* Set up exit handler */
    exit_block[1] = (caddr_t) ExitProc;
    exit_block[2] = 1;
    exit_block[3] = &exit_block[4];
    sys$dclexh(&exit_block);

    /* Make window visible, then wait forever */
    XtManageChild(WidgetId[mainWindow]);
    XtRealizeWidget(topLevel);

    status = MrmFetchWidget(Hierarchy, "interval_selector", topLevel,
                             &WidgetId[windowIntervalSelector], &class);
    if (status != MrmSUCCESS)
    {
        printf("Error Fetching IntervalSelector widget from UIL interface\n");
        return status;
    }

    status = MrmFetchWidget(Hierarchy, "tracks_window", topLevel,
                             &WidgetId[windowTrackSelector], &class);
    if (status != MrmSUCCESS)
    {
        printf("Error fetching tracks window widget from UIL interface\n");
    }

    status = MrmFetchWidget(Hierarchy, "tracks_edit_window", topLevel,
                             &WidgetId[windowTracksEdit], &class);
    if (status != MrmSUCCESS)
    {
        printf("Error fetching tracks edit window widget from UIL interface\n");
    }

    status = MrmFetchWidget(Hierarchy, "albumEditorPanedWindow", topLevel,
                            &WidgetId[albumEditorPanedWindow], &class);
    if (status != MrmSUCCESS)
    {
        printf("Error fetching album editor paned window from UIL interface\n");
        return status;
    }

    status = MrmFetchWidget(Hierarchy, "playlist_window", topLevel,
			     &WidgetId[playlistWindow], &class);
    if (status != MrmSUCCESS)
    {
	printf("Error fetching saved playlist window from UIL interface\n");
        return status;
    }

    status = MrmFetchWidget(Hierarchy, "message_window", topLevel,
			     &WidgetId[messageWindow], &class);
    if (status != MrmSUCCESS)
    {
	printf("Error fetching message window from UIL interface\n");
        return status;
    }

    delete_unwanted_buttons(); /* From message/question windows */

    /* Check initialised auto-repeat/auto-eject status */
    if (gbl_auto_repeat)
    {
	/* repeat/eject either/or */
	auto_eject_off();
    }

    /* Do regular functions for the first time */
    house_keeping_timer();

    XtAppMainLoop(app_context);
}

/*
    A routine that is called when a widget is created so that
    we can record its widget ID
*/
void WidgetCreated(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    char buffer[small_text_buffer];
    XmString string;
    static int volume_broken;
    int left, right, num;

    num = *tag;
    if (num > MaxWidgets)
    {
	printf("WidgetCreated: Unexpected widget number %d\n",num);
	return;
    }
    if (WidgetId[num])
    {
	printf("WidgetCreated: duplicate call for widget id %d\n",num);
	return;
    }
    WidgetId[num] = widget;
    switch (num)
    {
      case buttonAutoStart:
        get_value(WidgetId[buttonAutoStart], XmNset, &gbl_auto_start);
        break;
      case buttonAutoRepeat:
        get_value(WidgetId[buttonAutoRepeat], XmNset, &gbl_auto_repeat);
        break;
      case buttonAutoEject:
        get_value(WidgetId[buttonAutoEject], XmNset, &gbl_auto_eject);
        break;
      case buttonShufflePlay:
        get_value(WidgetId[buttonShufflePlay], XmNset, &gbl_shuffle_play);
        break;
      case buttonLock:
        get_value(WidgetId[buttonLock], XmNset, &gbl_lock_cd);
        break;
      case CD_logo:
        set_logo();
	break;
      case intervalSlider:
        get_value(WidgetId[intervalSlider], XmNvalue, &gbl_interval);
        if (gbl_interval == 0)
        {
            gbl_interval = 20;
            set_value(WidgetId[intervalSlider], XmNvalue, gbl_interval);
        }
        set_value(WidgetId[intervalSlider], XmNminimum, 1);
        break;
      case intervalSliderLabel:
        sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);
        string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);
        XmStringFree(string);
        break;
      case sliderVolume:
        /* see if volume changes work or not */
        /* only works if a disc is present though.. */
        volume_broken = 0;
        if (cd_ready())
        {
            cd_get_volume(&left, &right);
            --left; --right;
            if (cd_set_volume(left, right) & 1)
            {
                ++left; ++right;
                cd_set_volume(left, right); /* return it to normal */
            }
            else
            {
                volume_broken = 1;
            }
        }
    }
}

void PlayButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    Boolean set;

    /* (*tag) = 1 if triggered from command menu */ 
    /* (*tag) = 0 if button toggled */ 
    if (*tag)
    {
        set = 1;
    }
    else
    {
        get_value(WidgetId[buttonPlay], XmNset, &set);
    }

    if (gbl_setting_buttons) { set = 0; }

    if (set)
    {   /* the button was just pushed in */
	if (cd_ready() & 1)
	{
	    cd_start_play();
	}
	else
	{
	    give_no_cd_msg();
	}
    }
}

void ResumeButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    Boolean set;

    /* (*tag) = 1 if triggered from command menu */ 
    /* (*tag) = 0 if button toggled */ 
    if (*tag)
    {
        set = 1;
    }
    else
    {
        get_value(WidgetId[buttonResume], XmNset, &set);
    }

    if (gbl_setting_buttons) { set = 0; }

    if (set)
    {   /* the button was just pushed in */
        if (cd_ready() & 1)
	{
	    if (gbl_cd_paused)
	    {
		cd_resume();
		gbl_cd_paused = 0;
	    }
	    else
	    {
		cd_start_play();
	    }
	}
	else
	{
	    give_no_cd_msg();
	}
    }
}

void PauseButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    Boolean set;

    /* (*tag) = 1 if triggered from command menu */ 
    /* (*tag) = 0 if button toggled */ 
    if (*tag)
    {
        set = 1;
    }
    else
    {
        get_value(WidgetId[buttonPause], XmNset, &set);
    }

    if (gbl_setting_buttons) { set = 0; }

    if (set)
    {   /* the button was just pushed in */
        if (cd_is_playing() & 1)
        {
            cd_pause();
            gbl_cd_was_playing = 1;
	    gbl_cd_paused = 1;
        }
    }
}

void StopButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    Boolean set;

    /* (*tag) = 1 if triggered from command menu */ 
    /* (*tag) = 0 if button toggled */ 
    if (*tag)
    {
        set = 1;
    }
    else
    {
        get_value(WidgetId[buttonStop], XmNset, &set);
    }

    if (gbl_setting_buttons) { set = 0; }

    if (set)
    {   /* the button was just pushed in */
        cd_stop_unit();
        gbl_cd_was_playing = 0;
        gbl_cd_paused = 0;
	set_playlist_label (" ");
    }
}


void LockButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonLock], XmNset, &gbl_lock_cd);
    if (gbl_lock_cd)
    {
        cd_lock();
    }
    else
    {
        cd_unlock();
    }
}

void AutoStartButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonAutoStart], XmNset, &gbl_auto_start);
}

void AutoRepeatButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonAutoRepeat], XmNset, &gbl_auto_repeat);
    if (gbl_auto_repeat)
    {
	/* repeat/eject either/or */
	auto_eject_off();
    }
}

void AutoEjectButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonAutoEject], XmNset, &gbl_auto_eject);
    if (gbl_auto_eject)
    {
	/* repeat/eject either/or */
	auto_repeat_off();
    }
}

void ShuffleButtonToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonShufflePlay], XmNset, &gbl_shuffle_play);
}

void EjectButtonPushed(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    Boolean set;

    /* (*tag) = 1 if triggered from command menu */ 
    /* (*tag) = 0 if button toggled */ 
    if (*tag)
    {
        set = 1;
    }
    else
    {
        get_value(WidgetId[buttonEject], XmNset, &set);
    }

    if (gbl_setting_buttons) { set = 0; }

    if (set)
    {   /* the button was just pushed in */
	cd_unlock(); /* for good measure */
	cd_eject();
	handle_disk_change();
    }
}

void AlbumSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonAlbumSliderAction], XmNset,
              &gbl_album_slider_action);
}

void SongSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonSongSliderAction], XmNset,
              &gbl_song_slider_action);
}

void TrackSliderActionToggled(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    get_value(WidgetId[buttonTrackSliderAction], XmNset,
              &gbl_track_slider_action);
}

void album_title_changed(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    char *value;

    value = XmTextGetString(widget);
    normalise_asciz_string (value);
    db_modify_album_title(value);
    XtFree(value);
    set_title();
}

void song_title_changed(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    char *value;

    value = XmTextGetString(widget);
    normalise_asciz_string (value);
    db_modify_song_title(value,cd_current_track());
    XtFree(value);
}

void ChangeTrack(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    int value = *tag;
    int track, start, end;
    XmString string;
    char buffer[small_text_buffer];

    cd_pause();

    if (gbl_shuffle_play)
    {
	cd_shuffle_play(value);
    }
    else if (gbl_selected_play)
    {
	cd_selected_play(value);
    }
    else
    {
	track = cd_current_track() + value;
	start = cd_first_track();
	end = cd_last_track();

	track = MAX(track,start);
	track = MIN(track,end);

	cd_play_track_index(track, 1, end, 1);
    }

    handle_display_update();
}

void give_volume_bad_news()
{
    display_message (msg_no_vol);
}

void volumeDrag(Widget widget, char *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = 255;

    if (scale->value != last_value)
    {
        if (!(cd_set_volume(scale->value, scale->value) & 1))
        {   /* recover from error here, put up a dialog box. etc.. */
            set_value(WidgetId[sliderVolume], XmNvalue, last_value);
	    give_volume_bad_news();
        }
        else
        {   /* update label and change volume */
            char buffer[small_text_buffer];
	    XmString string;

            last_value = scale->value;
            sprintf(buffer, "%4.1f%%", (float)last_value / 255.0 * 100.0);
            string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[sliderVolumeLabel], XmNlabelString, string);
            XmStringFree(string);
        }
    }
}

void volumeChanged(Widget widget, char *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = 255;
    int value;

    get_value(WidgetId[sliderVolume], XmNvalue, &value);
    value += *tag;

    if (value != last_value)
    {
        if (cd_set_volume(value, value) & 1)
        {   /* update label and change volume */
	    XmString string;
            char buffer[small_text_buffer];

            last_value = value;
            sprintf(buffer, "%4.1f%%", (float)last_value / 255.0 * 100.0);
            string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[sliderVolumeLabel], XmNlabelString, string);
            XmStringFree(string);
        }
        else
        {   /* recover from error here, put up a dialog box. etc.. */
            set_value(WidgetId[sliderVolume], XmNvalue, last_value);
	    give_volume_bad_news();
        }
    }
}

void update_track_slider_label(Widget widget, int *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = 0;

    gbl_track_slider_inuse = !(*tag);

    if (scale->value < 1) return;

    if ((*tag == 1) || (scale->value != last_value))
    {
	XmString string;
        char buffer[small_text_buffer];

        last_value = scale->value;
        if (((*tag == 1) || gbl_track_slider_action) && (last_value != cd_current_track()))
        {
	    /* Manual selection: overrides any playlist */
	    if (gbl_selected_play)
	    {
		reset_playlist();
	    }
            cd_play_track_index(last_value, 1, cd_last_track(), 1);
        }
        /* update label */
        sprintf(buffer, "%d", last_value);
        string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, string);
        XmStringFree(string);
    }
}

void update_album_slider_label(Widget widget, int *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = 0;

    gbl_album_slider_inuse = !(*tag);

    if ((*tag ==1) || ((scale->value / 75) != (last_value / 75)))
    {
	XmString string;
        char buffer[small_text_buffer];

        if ((*tag == 1) || gbl_album_slider_action)
        {
            cd_play_frame_to_end(scale->value + cd_start_time());
        }

        /* update label */

        last_value = scale->value;
        sprintf(buffer, "%d:%02d", (last_value / 75) / 60,
                                   (last_value / 75) % 60);

        string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[sliderAlbumLabel], XmNlabelString, string);
        XmStringFree(string);
    }
}

void update_interval_slider(Widget widget, int *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = 0;

    if ((*tag ==1) || ((scale->value != last_value)))
    {
	XmString string;
        char buffer[small_text_buffer];

        if (*tag == 1)
        {
            gbl_interval_wannabe = scale->value;
        }

        /* update label */
        last_value = scale->value;
        sprintf(buffer, "%3.2f", (float)last_value / 100.0);
        string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);
        XmStringFree(string);
    }
}

void ExitProc(Widget widget, char *tag, XmAnyCallbackStruct *reason)
{
    sys$canexh(&exit_block);
    cd_stop_unit();
    cd_unlock();
    cd_deallocate();
    exit(1);
}

void update_song_slider_label(Widget widget, char *tag, XmScaleCallbackStruct *scale)
{
    static int last_value = -1;

    gbl_song_slider_inuse = !(*tag);

    if ((*tag == 1) || ((scale->value / 75) != (last_value / 75)))
    {
	XmString string;
        char buffer[small_text_buffer];

        if ((*tag == 1) || gbl_song_slider_action)
        {
            cd_play_frame_to_end(cd_song_start_time(0) + scale->value);
        }

        /* update label */
        last_value = scale->value;
        sprintf(buffer, "%d:%02d", (last_value / 75) / 60,
                                   (last_value / 75) % 60);
        string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[sliderLabel], XmNlabelString, string);
        XmStringFree(string);
    }
}

/* Highlight just the indicated play/stop/etc. button */
void set_one_play_button (int wanted_button)
{
    Arg arg;

    gbl_setting_buttons = 1; /* Disable xxxToggled callback activity */
    XtSetArg(arg, XmNset, wanted_button==buttonPlay?1:0);
    XtSetValues(WidgetId[buttonPlay], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonPause?1:0);
    XtSetValues(WidgetId[buttonPause], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonResume?1:0);
    XtSetValues(WidgetId[buttonResume], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonStop?1:0);
    XtSetValues(WidgetId[buttonStop], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonEject?1:0);
    XtSetValues(WidgetId[buttonEject], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonBack?1:0);
    XtSetValues(WidgetId[buttonBack], &arg, 1);
    XtSetArg(arg, XmNset, wanted_button==buttonForward?1:0);
    XtSetValues(WidgetId[buttonForward], &arg, 1);
    gbl_setting_buttons = 0;
}

/* Delete unwanted buttons from message/question popups */
void delete_unwanted_buttons()
{
    Widget w;

    w = XmMessageBoxGetChild(WidgetId[messageWindow], XmDIALOG_CANCEL_BUTTON);
    XtUnmanageChild(w);
    w = XmMessageBoxGetChild(WidgetId[messageWindow], XmDIALOG_HELP_BUTTON);
    XtUnmanageChild(w);

    w = XmMessageBoxGetChild(WidgetId[playlistWindow], XmDIALOG_HELP_BUTTON);
    XtUnmanageChild(w);
}

house_keeping_timer()
{
    static int was_ready = 0;

    cd_start_cache_io();

    if (cd_ready())
    {
        if (was_ready)
        {
	    /* Ready & still ready */
            handle_display_update();
            if (cd_is_playing())
            {
                if (! gbl_cd_was_playing)
                {
                    gbl_cd_was_playing = 1;
                }
            }
            else
            {
                if (gbl_cd_was_playing && (!gbl_cd_paused))
                {
		    /* Has just stopped (as opposed to paused) */
                    if (   !( gbl_shuffle_play &&  cd_shuffle_play(1))
		        && !(gbl_selected_play && cd_selected_play(1)))
                    {
                        if (gbl_auto_eject) cd_eject();
                        cd_stop_unit();
			set_one_play_button (buttonPlay);
                        gbl_cd_was_playing = 0;
			if (gbl_auto_repeat && !gbl_playlist_check)
			{
			    cd_begin_play();
			}
                    }
                }
            }
        }
        else
        {
	    /* Wasn't ready before but now is */
            was_ready = 1;
            if (gbl_lock_cd) cd_lock();
            handle_disk_change();

            if (gbl_db_open)
            {
                static string
                    short_key = string_dynamic,
                    album_title = string_dynamic;

                if (!(db_get_album_title(&album_title) & 1))
                {
                    db_add_album(&short_key);
                    XmTextSetString(WidgetId[labelAlbumTitle], "");
                    set_title();
                }
                else
                {
                    str$append(&album_title, &null_string);
                    XmTextSetString(WidgetId[labelAlbumTitle], SPTR(album_title));
                    /* position to beginning of text.. */
                    set_value(WidgetId[labelAlbumTitle], XmNcursorPosition, 0);
                    set_title();
                }
            }

	    set_one_play_button (buttonPlay);

	    /* Start play if auto-start and not playing already */
	    /* and no saved playlist being checked */
            if (gbl_auto_start && !cd_is_playing() && !gbl_playlist_check)
            {
		cd_begin_play();
            }
        }
    }
    else
    {
	/* Now not ready */
        if (was_ready)
        {
	    /* Disk has just gone */
            was_ready = 0;
            handle_disk_change();
	    set_one_play_button (buttonStop);
            XmTextSetString(WidgetId[labelAlbumTitle], "");
            XmTextSetString(WidgetId[labelSongTitle], "");
            set_title();
        }
    }
    cd_end_cache_io(); 
    setup_timer();
}

setup_timer()
{
    /* set up timer to run some interval from now. */
    XtAppAddTimeOut(app_context, gbl_interval * 10, house_keeping_timer, 0);
}

/* Start-Play function - respects current position */
void cd_start_play()
{
    gbl_cd_paused = 0;

    if (cd_ready() & 1)
    {
	int track;

	if (gbl_shuffle_play)
	{
	    cd_shuffle_play(1);
	}
	else if (gbl_selected_play)
	{
	    cd_selected_play(1);
	}
	else
	{
	    get_value(WidgetId[scaleCurrentTrack], XmNvalue, &track);
	    if (track == 0) track = cd_first_track();
	    cd_play_track_index(track, 1, cd_last_track(), 1);
	    gbl_cd_was_playing = 0;
	}
    }
}

/* Begin-Play function - start at "beginning" */
void cd_begin_play()
{
    if (gbl_shuffle_play)
    {
	cd_shuffle_play(1);
    }
    else if (gbl_selected_play)
    {
	cd_selected_play(1);
    }
    else
    {
	cd_play_track_index(cd_first_track(), 1, cd_last_track(), 1);
    }
    /* fix up all the labels and buttons eh? */
    set_one_play_button (buttonPlay);

    handle_display_update();
}

/* Check for possible disk change */
void handle_disk_change()
{
    Arg arg[3];
    char buffer[medium_text_buffer];
    XmString string;
    int min, cur, max, argc;

    gbl_cd_paused = 0;

    if (cd_ready())
    {
	min = cd_first_track();
	max = cd_last_track();
	cur = cd_current_track();
    }
    else
    {
	cur = max = min = 0;
    }
    if (max <= min) max = min + 1;
    cur = MIN(cur, max);
    cur = MAX(min, cur);
    
    argc = 0;
    XtSetArg(arg[argc], XmNminimum, min); ++argc;
    XtSetArg(arg[argc], XmNmaximum, max); ++argc;
    XtSetArg(arg[argc], XmNvalue,   cur); ++argc;
    XtSetValues(WidgetId[scaleCurrentTrack], arg, argc);

    sprintf(buffer, "%d", cur);
    string = XmStringCreateLtoR(buffer, gbl_default_font);
    set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, string);
    XmStringFree(string);

    sprintf(buffer, "%d", cd_last_track());
    string = XmStringCreateLtoR(buffer, gbl_default_font);
    set_value(WidgetId[labelAlbumTotalTracks], XmNlabelString, string);
    XmStringFree(string);

    /* Only if there's a CD... */
    if (cd_ready())
    {
	set_one_play_button (buttonPlay);

	/* Reset the list of tracks to be played */
	reset_playlist();

	/* Update the track list within the Tracks menu */
	set_playlist_from_db();
    }

    handle_display_update();
}

void handle_display_update()
{
    static int
        saved_left = -1,
        saved_right = -1,
        saved_album_total = -1,
        saved_album_current = -1,
        saved_song_total = -1,
        saved_song_current = -1,
        saved_track = -1,
        saved_first_track = -1,
        saved_last_track = -1;
    int tmp, left, right, flags;
    static string null_string = {1, 0, 0, "\0"};
    static string track_name = string_dynamic;
    XmString name_string;
    char buffer[medium_text_buffer];

    tmp = cd_album_total_time();
    if (tmp != saved_album_total)
    {
        Arg arg[3];
        int argc, cur;

	/* Different album */
	saved_track = -1;
	saved_first_track = -1;
	saved_last_track = -1;
        saved_album_total = tmp;
        if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */
        sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);
        name_string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[labelAlbumTotalTime], XmNlabelString, name_string);
        XmStringFree(name_string);
	set_playlist_label (" ");
        tmp = MAX(tmp, 1);
        cur = cd_album_current_time() - cd_start_time();
        cur = MIN(cur, tmp);
        cur = MAX(cur, 0);
	argc = 0;
	XtSetArg(arg[argc], XmNmaximum, tmp); ++argc;
	XtSetArg(arg[argc], XmNvalue, cur); ++argc;
        if (tmp > 150) /* for any album longer than two seconds! */
        {
            XtSetArg(arg[argc], XmNscaleMultiple, 150); ++argc;
        }
	XtSetValues(WidgetId[sliderAlbumTime], arg, argc);
    };

    tmp = cd_song_total_time(0);
    if (tmp != saved_song_total)
    {
        Arg arg[3];
        int cur, argc;

        saved_song_total = tmp;
        if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */
        sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);
        name_string = XmStringCreateLtoR(buffer, gbl_default_font);
        set_value(WidgetId[labelSongTotalTime], XmNlabelString, name_string);
        XmStringFree(name_string);
        tmp = MAX(tmp, 1);
        cur = cd_song_current_time();
        cur = MIN(cur, tmp);
        cur = MAX(cur, 0);
        argc = 0;
        XtSetArg(arg[argc], XmNmaximum, tmp); ++argc;
        XtSetArg(arg[argc], XmNvalue, cur); ++argc;
        if (tmp > 150) /* should be for any song longer than two seconds! */
        {
            XtSetArg(arg[argc], XmNscaleMultiple, 150); ++argc;
        }
        XtSetValues(WidgetId[sliderTrackTime], arg, argc);
    };

    if (!gbl_album_slider_inuse)
    {
        tmp = cd_album_current_time() - cd_start_time();
        if (tmp < 0) tmp = 0;
        if ((tmp / 75) != (saved_album_current / 75))
        {
            saved_album_current = tmp;
            if (tmp < 0) tmp = 0; /* weird, programming error no doubt. */
            sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);
            name_string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[sliderAlbumLabel], XmNlabelString, name_string);
            XmStringFree(name_string);
            tmp = MIN(tmp, saved_album_total);
            set_value(WidgetId[sliderAlbumTime], XmNvalue, tmp);
        };
    };

    if (!gbl_song_slider_inuse)
    {
        tmp = cd_song_current_time();
        if ((tmp / 75) != (saved_song_current / 75))
        {
            saved_song_current = tmp;
            sprintf(buffer, "%d:%02d", tmp / 75 / 60, (tmp / 75) % 60);
            name_string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[sliderLabel], XmNlabelString, name_string);
            XmStringFree(name_string);
            tmp = MIN(tmp, saved_song_total);
            set_value(WidgetId[sliderTrackTime], XmNvalue, tmp);
        };
    };

    tmp = cd_current_track();
    tmp = MIN(tmp, cd_last_track());
    tmp = MAX(tmp, 1);
    if (tmp != saved_track)
    {
        saved_track = tmp;

	if (!gbl_track_slider_inuse)
	{
            set_value(WidgetId[scaleCurrentTrack], XmNvalue, tmp);
            sprintf(buffer, "%d", tmp);
            name_string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[labelAlbumCurrentTrack], XmNlabelString, name_string);
            XmStringFree(name_string);
            set_title();
	}

	if (db_get_song_title(&track_name,tmp,&flags) & 1)
	{
	    str$append(&track_name, &null_string);
	    normalise_asciz_string (SPTR(track_name));
	    XmTextSetString(WidgetId[labelSongTitle], SPTR(track_name));
	    /* position to beginning of text.. */
	    set_value(WidgetId[labelSongTitle], XmNcursorPosition, 0);
	}
	else
	{
	    XmTextSetString(WidgetId[labelSongTitle], "");
	}
    };

    if (cd_get_volume(&left, &right) & 1)
    {
        if (left != saved_left && WidgetId[sliderVolume])
        {
            saved_left = left;  /* for now, assume left and right are same. */
            set_value(WidgetId[sliderVolume], XmNvalue, left);
            sprintf(buffer, "%4.1f%%", (float)left / 255.0 * 100.0);
            name_string = XmStringCreateLtoR(buffer, gbl_default_font);
            set_value(WidgetId[sliderVolumeLabel], XmNlabelString, name_string);
            XmStringFree(name_string);
        }
    }
}

void change_interval(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    char buffer[small_text_buffer];
    XmString string;
    
    XtManageChild(WidgetId[windowIntervalSelector]);

    set_value(WidgetId[intervalSlider], XmNvalue, gbl_interval);

    sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);
    string = XmStringCreateLtoR(buffer, gbl_default_font);
    set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);
    XmStringFree(string);

    gbl_interval_wannabe = gbl_interval;
    gbl_interval_original = gbl_interval;
}

void change_interval_ok(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    gbl_interval = gbl_interval_wannabe;
    XtUnmanageChild(WidgetId[windowIntervalSelector]);
}

void change_interval_cancel(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    char buffer[small_text_buffer];
    XmString string;
    gbl_interval = gbl_interval_original;

    sprintf(buffer, "%3.2f", (float)gbl_interval / 100.0);
    string = XmStringCreateLtoR(buffer, gbl_default_font);
    set_value(WidgetId[intervalSliderLabel], XmNlabelString, string);
    XmStringFree(string);

    XtUnmanageChild(WidgetId[windowIntervalSelector]);
}

void change_interval_apply(Widget widget, int *tag, XmAnyCallbackStruct *reason)
{
    gbl_interval = gbl_interval_wannabe;
}

void auto_repeat_off()
{
    gbl_auto_repeat = 0;
    set_value(WidgetId[buttonAutoRepeat], XmNset, 0);
}

void auto_eject_off()
{
    gbl_auto_eject = 0;
    set_value(WidgetId[buttonAutoEject], XmNset, 0);
}

void shuffle_mode_on()
{
    gbl_shuffle_play = 1;
    set_value(WidgetId[buttonShufflePlay], XmNset, 1);
}

void shuffle_mode_off()
{
    gbl_shuffle_play = 0;
    set_value(WidgetId[buttonShufflePlay], XmNset, 0);
}

int cd_shuffle_play(int flag)
{
/* Flag = 0 to just reset the play list */ 
/* Flag = 1 for normal call - play next */
/* Flag = -1 to step back along playlist */

    static int
        order[max_tracks],
        next = 0;

    if ((flag == 0) || (next == 0))
    {
	/* Generate new order */
        int i;

        srand(time(NULL));

        for (i = 1; i <= play_count; i++)
        {
            order[i] = play_list[i];
        }

        for (i = 1; i <= play_count; i++)
        {
            int tmp, swap;
            swap = rand() % play_count;
            tmp = order[i];
            order[i] = order[swap+1];
            order[swap+1] = tmp;
        }
	next = 0;
    }

    if (flag)
    {
	next += flag;
	next = MAX (next, 1);

        /* Stop when end of list reached */
	if (next <= play_count)
	{
	    cd_set_playlist_mode(1);
	    cd_play_track_index (order[next], 1, order[next], 1);
	}
	else
	{
	    next = 0;
	}
    }
    return next;
}

int cd_selected_play(int flag)
{
/* Flag = 1 for normal call - play next */
/* Flag = -1 to step back along playlist */

    static int next = 0;

    next += flag;

    next = MAX (next, 1);

    /* Stop when end of list reached */
    if (next <= play_count)
    {
	cd_set_playlist_mode(1);
        cd_play_track_index (play_list[next], 1, play_list[next], 1);
    }
    else
    {
        next = 0;
    }
    return next;
}

void set_playlist_label(char *name)
{
    XmString string;

    /* Need to check widget is known as can get called before it is */
    if (WidgetId[playlistLabel])
    {
	string = XmStringCreateLtoR(name, gbl_default_font);
	set_value(WidgetId[playlistLabel], XmNlabelString, string);
	XmStringFree(string);
    }
}

void reset_playlist()
{
/* Reset the playlist to "all-tracks" */

    int i, track_num;

    track_num = MIN(cd_tracks(),max_tracks);
    for (i = 1; i <= track_num; i++)
        {
	    play_list[i] = i;
	}
    play_count = track_num;
    pl_pending_play_count = 0;
    pl_album_time = 0;
    gbl_selected_play = 0;
    gbl_playlist_ok = 0;
    if (gbl_shuffle_play)
    {
	cd_shuffle_play(0); /* Generate new playlist order */
    }
    cd_set_playlist_mode(0);

    /* Check if question still on-screen */
    if (gbl_playlist_check)
    {
	gbl_playlist_check = 0;
	XtUnmanageChild(WidgetId[playlistWindow]);
    }

    if (gbl_auto_repeat)
    {
	set_playlist_label (msg_repeat);
    }
    else
    {
	set_playlist_label (" ");
    }
}

/* Called from tracks_select_done() and playlist_ok() to start up a playlist */
void cd_playlist_setup()
{
    gbl_playlist_ok = 1;
    gbl_selected_play = 1;

    if (gbl_shuffle_play)
    {
	cd_shuffle_play(1);
	if (gbl_auto_repeat)
	{
	    set_playlist_label (msg_playlist_rpt_shuffled);
	}
	else
	{
	    set_playlist_label (msg_playlist_shuffled);
	}
    }
    else
    {
	if (gbl_auto_repeat)
	{
	    set_playlist_label (msg_playlist_rpt);
	}
	else
	{
	    set_playlist_label (msg_playlist);
	}
    }

    if (gbl_auto_start)
    {
	cd_begin_play();
    }
}

void playlist_ok()
{
    if (gbl_playlist_check)
    {
	/* Question was on-screen but no longer */
        gbl_playlist_check = 0;

	/* Only if the album hasn't changed... */
	if (pl_album_time == cd_album_total_time())
	{
	    play_count = pl_pending_play_count;
	    cd_playlist_setup();
	}
	else
	{
	    reset_playlist();
	}
    }
    /* Else question went off-screen earlier */
}

void playlist_cancel()
{
    if (gbl_playlist_check)
    {
	/* Question was on-screen but no longer */
        gbl_playlist_check = 0;

	reset_playlist();

	/* Start play if auto-start and not playing already */
	if (cd_ready() && gbl_auto_start && !cd_is_playing())
	{
	    cd_begin_play();
	}
    }
    /* Else question went off-screen earlier */
}

/* Scan songs db for possible saved playlist */
/* Playlist currently set to "all-tracks" */
void set_playlist_from_db()
{
    static string track_name = string_dynamic;
    int i, flags, track_num, play_num;

    /* Scan for current track names */
    track_num = MIN(cd_tracks(),max_tracks);
    play_num = 0;

    for (i = 1; i <= track_num; i++)
	{
	    if (db_get_song_title(&track_name,i,&flags) & 1)
	    {
		if (flags & 1)
		{
		    play_list[++play_num] = i;
		}
	    }
	}

    /* Has CD gone? */
    if (cd_ready() == 0)
    {
	play_num = 0;
	reset_playlist();
    }

    /* Any selection? */
    if (play_num)
    {
	/* Save count for access from playlist_ok(). */
	pl_pending_play_count = play_num;
	/* and a sanity check in case CD changes under us */
	pl_album_time = cd_album_total_time();

	if (WidgetId[playlistWindow])
	{
	    /* Ask question */
	    XtManageChild (WidgetId[playlistWindow]);
	    /* Remember it's on screen */
	    gbl_playlist_check = 1;
        }
	else
	{
	    /* Assume OK */
	    playlist_ok();
	}
    }
}

/* Set up tracks selection list */
void set_track_list()
{
    XmString name_string;
    int i, flags, track_num, num_selected;
    static string null_string = {1, 0, 0, "\0"};
    static string track_name = string_dynamic;
    char list_buffer[medium_text_buffer];

    if (WidgetId[tracksList])
    {
	XmListDeleteAllItems(WidgetId[tracksList]);

	/* Scan for current track names */
	track_num = MIN(cd_tracks(),max_tracks);
	num_selected = 0;

	for (i = 1; i <= track_num; i++)
	    {
		if (db_get_song_title(&track_name,i,&flags) & 1)
		{
		    str$append (&track_name, &null_string);
		    normalise_asciz_string (SPTR(track_name));
		    name_string = XmStringCreateLtoR(SPTR(track_name), gbl_default_font);
		    XmListAddItemUnselected(WidgetId[tracksList], name_string, i);
		    XmStringFree(name_string);
		}
		else
		{
		    flags = 0;
		    sprintf (list_buffer, "Track %d ", i);
		    name_string = XmStringCreateLtoR(list_buffer, gbl_default_font);
		    XmListAddItemUnselected(WidgetId[tracksList], name_string, i);
		    XmStringFree(name_string);
		}
		if (flags & 1)
		{
		    ++num_selected;
		    XmListSelectPos(WidgetId[tracksList], i, 0);
			 /* don't invoke "selected" callback ^ */
		}
	    }

	/* If no selections were saved, check the playlist */
	if (!num_selected && gbl_selected_play)
	{
	    for (i = 1; i <= play_count; i++)
	    {
		XmListSelectPos(WidgetId[tracksList], play_list[i], 0);
	    }
	}
    }
}

/* Tracks menu invoked */
void tracks_select_setup()
{
    if (cd_ready() == 0)
    {
	give_no_cd_msg();
    }
    else
    {
	/* Check the widget for tracks exists */
	if (WidgetId[windowTrackSelector])
	{
	    main_start_watch();

	    set_track_list();

	    /* Make the subsidiary tracks window appear */ 
	    XtManageChild(WidgetId[windowTrackSelector]);

	    main_stop_watch();
	}
    }
}

void tracks_select_done()
{
    int *pos_list, pos_count, i;

    /* Check the widget for tracks exists */
    if (WidgetId[windowTrackSelector])
    {
	XtUnmanageChild(WidgetId[windowTrackSelector]);

	/* Read back any selections */
	if (XmListGetSelectedPos(WidgetId[tracksList], &pos_list, &pos_count))
	{
	    for (i = 1; i <= pos_count; i++)
	        {
		    play_list[i] = *pos_list++;
   	        }
	    play_count = pos_count;

	    cd_stop_unit();
	    cd_playlist_setup();

	    free (pos_list);
	}
    }
}

void tracks_select_cancel()
{
    /* Check the widget for tracks exists */
    if (WidgetId[windowTrackSelector])
    {
	XtUnmanageChild(WidgetId[windowTrackSelector]);
    }
}

void tracks_select_all()
{
/* Select all items */
    int i, track_num;

    /* Check the widget for tracks exists */
    if (WidgetId[windowTrackSelector])
    {
	track_num = MIN(cd_tracks(),max_tracks);
	for (i = 1; i <= track_num; i++)
	    {
		XmListSelectPos(WidgetId[tracksList], i, 0);
	    }
    }
}

void tracks_select_save()
{
/* Save selected/unselected status */
    int i, j, track_num, flags, were_saved;
    int *pos_list, pos_count;

    /* Check the widget for tracks exists */
    if (WidgetId[windowTrackSelector])
    {
	tracks_start_watch();

	track_num = MIN(cd_tracks(),max_tracks);

	/* Clear all 'preferred' flags */
	were_saved = 0;
	for (i = 1; i <= track_num; i++)
	    {
		db_song_get_flags (i, &flags);
		if (flags & 1)
		{
		    ++were_saved;
		}
		flags = 0;
		db_song_set_flags (i, &flags);
	    }

	/* Set flag for all selected ones */
	if (XmListGetSelectedPos(WidgetId[tracksList], &pos_list, &pos_count))
	{
	    for (i = 1; i <= pos_count; i++)
	        {
		    j = *pos_list++;
		    db_song_get_flags (j, &flags);
		    flags = 1;
		    db_song_set_flags (j, &flags);
   	        }
	    free (pos_list);
	    tracks_stop_watch();
	    display_message (msg_playlist_saved);
        }
	else
	{
	    tracks_stop_watch();
	    if (were_saved)
	    {
		display_message (msg_playlist_cleared);
	    }
	    else
	    {
		display_message (msg_playlist_none);
	    }
	}
    }
}

void tracks_select_clear()
{
/* Deselect all items */

    /* Check the widget for tracks exists */
    if (WidgetId[windowTrackSelector])
    {
	XmListDeselectAllItems(WidgetId[tracksList]);
    }
}

int track_edit_util (int flag)
{
/* Two modes of stepping through editing names:
   if there are selections, step through those;
   otherwise step through all tracks.           */

    static int seq_num, track_num, pos_count, *pos_list, *next_entry, col;
    int flags;
    XmString title_string;
    static string null_string = {1, 0, 0, "\0"};
    static string track_name = string_dynamic;
    char list_buffer[medium_text_buffer], *name_string;

    switch (flag)
    {
	case edit_setup:
	    if (pos_list)
	    {
		free (pos_list);
	    }
	    XmListGetSelectedPos(WidgetId[tracksList], &pos_list, &pos_count);
	    if (pos_count)
	    {
		next_entry = pos_list;
	    }
	    else
	    {
		pos_count = MIN(cd_tracks(),max_tracks);
	    }
	    seq_num = 0;
	    return pos_count;
        case edit_curr:
	    return seq_num;
	case edit_begin:
	    if (seq_num)
	    {
		set_value(WidgetId[buttonEditTrackNext], XmNshowAsDefault, 0);
		set_value(WidgetId[buttonEditTrackCancel], XmNshowAsDefault, 0);
		set_value(WidgetId[buttonEditTrackSave], XmNshowAsDefault, 1);
		name_string = XmTextGetString(WidgetId[track_edit_text]);
		col = strlen(name_string);
		if (col)
		{
		    set_value(WidgetId[track_edit_text], XmNcursorPosition, col+1);
		}
		XtFree (name_string);
	    }
	    return seq_num;
	case edit_next:
	    if (seq_num < pos_count)
	    {
		set_value(WidgetId[buttonEditTrackNext], XmNshowAsDefault, 1);
		set_value(WidgetId[buttonEditTrackCancel], XmNshowAsDefault, 0);
		set_value(WidgetId[buttonEditTrackSave], XmNshowAsDefault, 0);

		++seq_num;
		if (pos_list)
		{
		    track_num = *next_entry++;
		}
		else
		{
		    track_num = seq_num;
		}
		sprintf (list_buffer, "Track %d ", track_num);
		title_string = XmStringCreateLtoR(list_buffer, gbl_default_font);
		set_value(WidgetId[windowTracksEdit], XmNdialogTitle, title_string);
		XmStringFree (title_string);

		if (db_get_song_title(&track_name,track_num,&flags) & 1)
		{
		    str$append (&track_name, &null_string);
		    normalise_asciz_string (SPTR(track_name));
		    XmTextSetString(WidgetId[track_edit_text], SPTR(track_name));
		}
		else
		{
		    XmTextSetString(WidgetId[track_edit_text], list_buffer);
		}
                set_value(WidgetId[track_edit_text], XmNcursorPosition, 0);
	    }
	    else
	    {
		set_value(WidgetId[buttonEditTrackNext], XmNshowAsDefault, 0);
		set_value(WidgetId[buttonEditTrackCancel], XmNshowAsDefault, 1);
		set_value(WidgetId[buttonEditTrackSave], XmNshowAsDefault, 0);

		/* Set up for possible recycling through list */
		seq_num = 0;
		track_num = 0;
		next_entry = pos_list;
	    }
	    return seq_num;
	case edit_update:
	    if (seq_num)
	    {
		name_string = XmTextGetString(WidgetId[track_edit_text]);
		normalise_asciz_string (name_string);
		title_string = XmStringCreateLtoR(name_string, gbl_default_font);
	        XmListReplaceItemsPos(WidgetId[tracksList], &title_string, 1, track_num);
		XmStringFree(title_string);
	        db_modify_song_title (name_string, track_num);
		XtFree(name_string);
		set_value(WidgetId[buttonEditTrackSave], XmNshowAsDefault, 0);
		set_value(WidgetId[buttonEditTrackNext], XmNshowAsDefault, 1);
	    }
	    return seq_num;
	case edit_done:
	    pos_count = 0;
	    seq_num = 0;
	    next_entry = 0;
	    if (pos_list)
	    {
		free (pos_list);
	    }
    }

    return 0;
}

void tracks_edit_save()
{
    /* Check the widget for tracks exists */
    if (WidgetId[windowTracksEdit])
    {
	track_edit_util (edit_update);
    }
}

void tracks_edit_next()
{
    /* Check the widget for tracks exists */
    if (WidgetId[windowTracksEdit])
    {
	track_edit_util (edit_next);
    }
}

void tracks_edit_cancel()
{
    /* Check the widget for tracks exists */
    if (WidgetId[windowTracksEdit])
    {
	track_edit_util (edit_done);

	XtUnmanageChild(WidgetId[windowTracksEdit]);
    }
}

void tracks_select_edit()
{
    /* Check the widget for tracks edit exists */
    if (WidgetId[windowTracksEdit])
    {
	/* Make the subsidiary tracks window appear */ 
	XtManageChild(WidgetId[windowTracksEdit]);

	if (track_edit_util (edit_setup))
	{
	    track_edit_util (edit_next);
	}
	else
	{
	    tracks_edit_cancel();
	}
    }
}

/* Called when input focus moves to text window */
void tracks_edit_entry_begin()
{
    /* Check the widget for tracks exists */
    if (WidgetId[windowTracksEdit])
    {
	track_edit_util (edit_begin);
    }
}

set_title()
{
/* Set main window title */
    unsigned char buff[medium_text_buffer];

    if (cd_ready())
    {
        if (WidgetId[labelAlbumTitle])
        {
            unsigned char *tmp;
            int i;

            tmp = XmTextGetString(WidgetId[labelAlbumTitle]);
	    normalise_asciz_string (tmp);
            sprintf
            (
                buff,
                "%s (%d of %d)",
                strlen(tmp)?tmp:gbl_title,
                cd_current_track(),
                cd_last_track()
            );
            XtFree(tmp);
        }
        set_value(topLevel, XmNtitle, buff);
        set_value(topLevel, XmNiconName, buff);
    }
    else
    {
        sprintf(buff, "%s: insert disc", gbl_title);
        set_value(topLevel, XmNtitle, buff);
        set_value(topLevel, XmNiconName, gbl_title);
    }
}

void save_customize_settings()
{
    static XrmDatabase new_db = 0;
    char resource_db_name[medium_text_buffer];

    sprintf(resource_db_name, "decw$user_defaults:%s.dat", gbl_app_name);

    if (new_db == 0)
    {
        /* get the old database */
        new_db = XrmGetFileDatabase(resource_db_name);

        if (new_db == 0)
        {
            XrmPutFileDatabase(new_db, resource_db_name);
            new_db = XrmGetFileDatabase(resource_db_name);
        }
    }

    if (new_db == 0)
    {
        /* something weird here.. */
        printf("unable to open/create resource database?\n");
    }
    else
    {
        /* merge in any changes the user requests */
        Dimension width, height;
        Position x,y;
        int value;
        Boolean bool;
        char buffer[medium_text_buffer];

        get_value(WidgetId[intervalSlider], XmNvalue, &value);
        modify_db_value(new_db, "*interval_slider.value", value);

        get_value(WidgetId[buttonLock], XmNset, &bool);
        modify_db_value(new_db, "*lock_toggle.set", bool);

        get_value(WidgetId[buttonAutoStart], XmNset, &bool);
        modify_db_value(new_db, "*auto_start_toggle.set", bool);

        get_value(WidgetId[buttonAutoRepeat], XmNset, &bool);
        modify_db_value(new_db, "*auto_repeat_toggle.set", bool);

        get_value(WidgetId[buttonAutoEject], XmNset, &bool);
        modify_db_value(new_db, "*auto_eject_toggle.set", bool);

        get_value(WidgetId[buttonShufflePlay], XmNset, &bool);
        modify_db_value(new_db, "*shuffle_toggle.set", bool);

        get_value(topLevel, XmNx, &x);
        modify_db_value(new_db, ".x", x);

        get_value(topLevel, XmNy, &y);
        modify_db_value(new_db, ".y", y);

        get_value(topLevel, XmNwidth, &width);
        modify_db_value(new_db, ".width", width);

        get_value(topLevel, XmNheight, &height);
        modify_db_value(new_db, ".height", height);

        /* output the new database */
        XrmPutFileDatabase(new_db, resource_db_name);
    }
}

modify_db_value(XrmDatabase db, char *string, int value)
{
    XrmValue val;
    char buffer[small_text_buffer];
    char resource[medium_text_buffer];

    sprintf(resource, "%s%s", gbl_app_name, string);

    sprintf(buffer, "%d", value);
    val.addr = buffer;
    val.size = strlen(buffer) + 1;

    XrmPutResource(&db, resource, XtRString, &val);
}

/* Callback for the setup of the album editor subsystem */
void cd_db_create_dialog(Widget widget, char *tag, XmAnyCallbackStruct *reason)
{
    album_edit_setup (WidgetId[albumEditorBulletinBoard],
		      WidgetId[albumEditorList],
		      WidgetId[albumEditorPanedWindow],
		      gbl_default_font);
}

/* Update album & track titles after album editing */
void AlbumEditDone()
{
    int flags;
    static string title = string_dynamic;

    if (cd_ready() & 1)
    {
	if (db_get_album_title(&title) & 1)
	{
	    str$append(&title, &null_string);
	    normalise_asciz_string (SPTR(title));
	    XmTextSetString(WidgetId[labelAlbumTitle], SPTR(title));
	    /* position to beginning of text.. */
	    set_value(WidgetId[labelAlbumTitle], XmNcursorPosition, 0);
	    set_title();
	}

	if (db_get_song_title(&title,cd_current_track(),&flags) & 1)
	{
	    str$append (&title, &null_string);
	    normalise_asciz_string (SPTR(title));
	    XmTextSetString(WidgetId[labelSongTitle], SPTR(title));
	    /* position to beginning of text.. */
	    set_value(WidgetId[labelSongTitle], XmNcursorPosition, 0);
	}
    }
}


/* Set the logo on the main window, which is also the icon */
void set_logo()
{
#include "cd_logo.xbm"

    static Pixmap logo;

    if (display_logo || display_icon)
    {
	logo = XCreateBitmapFromData (XtDisplay(topLevel),
				      RootWindowOfScreen(XtScreen(topLevel)),
				      cd_logo_bits,
				      cd_logo_width,
				      cd_logo_height);

	if (display_logo && WidgetId[CD_logo])
	{   /* CD-ROM logo on main display? */
	    set_value (WidgetId[CD_logo], XmNlabelPixmap, logo);
	}
	if (display_icon)
	{   /* CD-ROM logo as the icon? */
	    set_value (topLevel, XtNiconPixmap, logo);
	}
    }
}

/* Set main window cursor to be the watch symbol */
void main_start_watch()   
{
    static Cursor watch = NULL;

    start_watch (WidgetId[mainWindow], &watch);
}

/* Set main window cursor back to normal */
void main_stop_watch()
{
    stop_watch (WidgetId[mainWindow]);
}


/* Set tracks window cursor to be the watch symbol */
void tracks_start_watch()   
{
    static Cursor watch = NULL;

    start_watch (WidgetId[windowTrackSelector], &watch);
}

/* Set tracks window cursor back to normal */
void tracks_stop_watch()
{
    stop_watch (WidgetId[windowTrackSelector]);
}


/* Set cursor to be the watch symbol */
void start_watch(Widget window, Cursor *watch)
{
#include <decw$cursor.h>

    if (*watch == (Cursor)NULL)
    {
	*watch = DXmCreateCursor (window, decw$c_wait_cursor);
    }
    XDefineCursor (XtDisplay(topLevel), XtWindow(window), *watch);
    XFlush (XtDisplay(topLevel));
}

/* Set cursor back to normal */
void stop_watch(Widget window)
{
	XUndefineCursor (XtDisplay(topLevel), XtWindow(window));
}


/* DEC/CMS REPLACEMENT HISTORY, Element CD_PLAYER.C*/
/* *36   19-JUN-1994 16:16:13 SYSTIMK "Clears playlist msg on eject/change"*/
/* *35   19-JUN-1994 12:22:40 SYSTIMK "?Fixed occasional slider range error"*/
/*  34C1 19-JUN-1994 11:49:48 SYSTIMK "Started adding resource for logo on/off"*/
/* *34   19-JUN-1994 10:52:40 SYSTIMK "Made logo & icon optional; fixed min. wXh; added exit handler"*/
/* *33   12-JUN-1994 17:16:59 SYSTIMK "Added Album-edit-done callback"*/
/* *32   12-JUN-1994 16:51:08 SYSTIMK "Clear playlist msg on Stop"*/
/* *31   12-JUN-1994 12:48:34 SYSTIMK "Added msg popup for no-CD"*/
/* *30   12-JUN-1994 12:31:44 SYSTIMK "Added cursor=watch support"*/
/* *29   11-JUN-1994 15:43:18 SYSTIMK "added logo/icon support"*/
/* *28   11-JUN-1994 13:26:36 SYSTIMK "Improved check in WidgetCreated"*/
/* *27   11-JUN-1994 10:56:36 SYSTIMK "Reduced min. window size to permitted min."*/
/* *26   11-JUN-1994 10:26:44 SYSTIMK "Resume does Play if not Paused"*/
/* *25    4-JUN-1994 12:41:33 SYSTIMK "Uses playlist to init. track selections"*/
/* *24    4-JUN-1994 12:27:15 SYSTIMK "Added 'repeat' status to playlist msg"*/
/* *23    4-JUN-1994 12:11:05 SYSTIMK "Fixed double-playlist? problem"*/
/* *22    4-JUN-1994 11:55:56 SYSTIMK "Added #defines for messages"*/
/* *21    4-JUN-1994 11:44:15 SYSTIMK "Added playlist indicator"*/
/* *20    4-JUN-1994 10:58:52 SYSTIMK "Deleted unwanted question/message buttons"*/
/* *19    4-JUN-1994 10:45:59 SYSTIMK "Fixed assorted playlist/state bugs"*/
/* *18   30-MAY-1994 18:22:19 SYSTIMK "Fixed problem with Eject button"*/
/* *17   30-MAY-1994 18:10:07 SYSTIMK "made #includes consistent"*/
/* *16   30-MAY-1994 17:14:01 SYSTIMK "Added pause & <> buttons & reworked others"*/
/* *15   30-MAY-1994 12:14:17 SYSTIMK "Misc. tidy-up"*/
/* *14   29-MAY-1994 19:54:27 SYSTIMK "Fixed bad handling of ejection"*/
/* *13   29-MAY-1994 18:26:01 SYSTIMK "Added general message popup"*/
/* *12   29-MAY-1994 17:38:11 SYSTIMK "Minor improvements to name entry"*/
/* *11   29-MAY-1994 17:10:13 SYSTIMK "Added consistent filtering out of control chars."*/
/* *10   29-MAY-1994 16:38:30 SYSTIMK "Track name edit input-focus handling added"*/
/* *9    29-MAY-1994 16:02:05 SYSTIMK "Added saved playlist `OK?'"*/
/* *8    29-MAY-1994 10:03:07 SYSTIMK "Merged with 1a1; album db edit split off"*/
/* *7    25-MAY-1994 14:34:40 SYSTIMK "Added Tracks list Edit; fixed string handling"*/
/*  1A1  25-MAY-1994 09:57:02 SYSTIMK "joe's version of 25-May-1994"*/
/* *6    24-MAY-1994 11:43:31 SYSTIMK "Restores playlist & executes it"*/
/* *5    24-MAY-1994 10:11:33 SYSTIMK "Added playlist save/restore"*/
/* *4    23-MAY-1994 12:53:14 SYSTIMK "Added songs db support"*/
/* *3    22-MAY-1994 20:21:23 SYSTIMK "Added Track selection menu"*/
/* *2    22-MAY-1994 09:18:20 SYSTIMK "Added autostart/autoplay"*/
/* *1    22-MAY-1994 09:13:00 SYSTIMK "CD player main program"*/
/* DEC/CMS REPLACEMENT HISTORY, Element CD_PLAYER.C*/
