 #include "ckcsym.h"  #ifndef NOLOCAL  #ifndef NODIAL/ char *dialv = "Dial Command, 5A(063) 4 Oct 94";   ; /*  C K U D I A	 --  Module for automatic modem dialing. */    /*N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.   >   Original (version 1, 1985) author: Herm Fischer, Encino, CA.K   Contributed to Columbia University in 1985 for inclusion in C-Kermit 4.0. G   Author and maintainer since 1985: Frank da Cruz, Columbia University,    fdc@columbia.edu.   N   Contributions by many others throughout the years, including: Mark Berryman,M   Fernando Cabral, John Chmielewski, Joe Doupnik, Richard Hill, Larry Jacobs, M   Eric Jones, Tom Kloos, Bob Larson, Peter Mauzey, Joe Orost, Kevin O'Gorman, J   Kai Uwe Rommel, Dan Schullman, Warren Tucker, and others too numerous to3   list here (but see acknowledgements in ckcmai.c).   E   This module calls externally defined system-dependent functions for J   communications i/o, as defined in CKCPLM.DOC, the C-Kermit Program LogicI   Manual, and thus should be portable to all systems that implement those G   functions, and where alarm() and signal() work as they do in UNIX. */    /*I   To add support for another modem, do the following, all in this module:   6   1. Define a modem-type number symbol (n_XXX) for it.  5   2. Adjust MAX_MDM to the new number of modem types.   &   3. Create a MDMINF structure for it.  C   4. Add the address of the MDMINF structure to the ptrtab[] array, ?      according to the numerical value of the modem-type number.   B   5. Add the user-visible (SET MODEM) name and corresponding modemN      number to the mdmtab[] array, in alphabetical order by modem-name string.  H   6. Read through the code and add modem-specific sections as necessary.  K   NOTE: The MINIDIAL symbol is used to build this module to include support L   for only a minimum number of standard and/or generally useful modem types,L   namely Hayes, CCITT V.25bis, "Unknown", and None.  When adding support for=   a new modem type, keep it outside of the MINIDIAL sections.  */   #include "ckcdeb.h"  #ifndef MAC  #include <signal.h>  #endif /* MAC */ #include "ckcasc.h"  #include "ckcker.h"  #include "ckucmd.h"  #include "ckcnet.h"   
 #ifndef ZILOG % #include <setjmp.h>			/* Longjumps */  #else  #include <setret.h>  #endif /* ZILOG */  
 #ifdef MAC #define signal msignal #define SIGTYP long  #define alarm malarm #define SIG_IGN 0  #define SIGALRM 1  #define SIGINT 26 SIGTYP (*msignal(int type, SIGTYP (*func)(int)))(int); #endif /* MAC */   #ifdef AMIGA #define signal asignal #define alarm aalarm #define SIGALRM (_NUMSIG+1)  #define SIGTYP void 6 SIGTYP (*asignal(int type, SIGTYP (*func)(int)))(int); unsigned aalarm(unsigned); #endif /* AMIGA */   #ifdef STRATUSN /* VOS doesn't have alarm(), but it does have some things we can work with. */N /* However, we have to catch all the signals in one place to do this, so    */N /* we intercept the signal() routine and call it from our own replacement.  */ #define signal vsignal #define alarm valarm6 SIGTYP (*vsignal(int type, SIGTYP (*func)(int)))(int); int valarm(int interval);  #ifdef putchar #undef putchar #endif /* putchar */ #define putchar(x) conoc(x)  #ifdef getchar #undef getchar #endif /* getchar */ #define getchar(x) coninc(0) #endif /* STRATUS */  ! int					/* SET DIAL parameters */ 2   dialhng = 1,				/* DIAL HANGUP, default is ON */4   dialdpy = 0,				/* DIAL DISPLAY, default is OFF */4   mdmspd  = 1,				/* DIAL SPEED-MATCHING (1 = ON) */$   dialtmo = 0,				/* DIAL TIMEOUT */2   dialksp = 0,				/* DIAL KERMIT-SPOOF, 0 = OFF */0   dialmnp = 0,				/* DIAL MNP-ENABLE, 0 = OFF */ #ifdef NOMDMHUP 2   dialmhu = 0;				/* DIAL MODEM-HANGUP, 0 = OFF */ #else )   dialmhu = 1;				/* DIAL MODEM-HANGUP */  #endif /* NOMDMHUP */   > int dialsta = DIA_UNK;			/* Detailed return code (ckuusr.h) */  : char *dialdir = NULL;			/* DIAL DIRECTORY, default none */< char *dialini = NULL;			/* DIAL INIT-STRING, default none */= char *dialcmd = NULL;			/* DIAL DIAL-COMMAND, default none */ 7 char *dialnpr = NULL;			/* DIAL NUMBER-PREFIX, ditto */ 7 /* char *hupcmd  = NULL; */		/* Modem hangup command */ ? FILE * dialfd = NULL;			/* File descriptor of dial directory */    #ifndef MINIDIAL /*   Telebit model codes:  '   ATI  Model Numbers           Examples '   ---  -------------           -------- K   123                          Telebit in "total Hayes-1200" emulation mode K   960                          Telebit in Conventional Command (Hayes) mode C   961  RA12C                   IBM PC internal original Trailblazer <   962  RA12E                   External original Trailblazer=   963  RM12C                   Rackmount original Trailblazer E   964  T18PC                   IBM PC internal Trailblazer-Plus (TB+) O   965  T18SA, T2SAA, T2SAS     External TB+, T1600, T2000, T3000, WB, and later ,   966  T18RMM                  Rackmount TB+4   967  T2MC                    IBM PS/2 internal TB+-   968  T1000                   External T1000 &   969  ?                       Qblazer+   970                          Qblazer Plus -   971  T2500                   External T2500 .   972  T2500                   Rackmount T2500 */   /* Telebit model codes */   / #define TB_UNK  0			/* Unknown Telebit model */ . #define TB_BLAZ 1			/* Original TrailBlazer */* #define TB_PLUS	2			/* TrailBlazer Plus */ #define TB_1000 3			/* T1000 */  #define TB_1500 4			/* T1500 */  #define TB_1600 5			/* T1600 */  #define TB_2000 6			/* T2000 */  #define TB_2500 7			/* T2500 */  #define TB_3000 8			/* T3000 */ ! #define TB_QBLA 9			/* Qblazer */ & #define TB_WBLA 10			/* WorldBlazer */) #define TB__MAX 10			/* Highest number */   0 char *tb_name[] = {			/* Array of model names */     "Unknown",				/* TB_UNK  */ "     "TrailBlazer",			/* TB_BLAZ */'     "TrailBlazer-Plus",			/* TB_PLUS */      "T1000",				/* TB_1000 */      "T1500",				/* TB_1500 */      "T1600",				/* TB_1600 */      "T2000",				/* TB_2000 */      "T2500",				/* TB_2500 */      "T3000",				/* TB_3000 */      "Qblazer",				/* TB_QBLA */ "     "WorldBlazer",			/* TB_WBLA */     "" }; #endif /* MINIDIAL */   H extern int flow, local, mdmtyp, quiet, backgrd, parity, seslog, network; extern int carrier, duplex;  #ifdef NETCONN extern int ttnproto; #endif /* NETCONN */ extern CHAR stchr; extern long speed; extern char ttname[], sesfil[];    /*  Failure codes  */     #define F_TIME		1		/* timeout */! #define F_INT		2		/* interrupt */ 0 #define F_MODEM		3		/* modem-detected failure */1 #define F_MINIT		4		/* cannot initialize modem */   9 static int fail_code =  0;		/* Default failure reason. */   2 #define DW_NOTHING      0		/* What we are doing */ #define DW_INIT         1  #define DW_DIAL         2   : static int dial_what = DW_NOTHING;	/* Nothing at first. */  6 static int mymdmtyp;			/* Local copy of modem type. */  % _PROTOTYP (static int ddinc, (int) ); ! _PROTOTYP (int dialhup, (void) ); ) _PROTOTYP (static int getok, (int,int) ); " _PROTOTYP (char * getdws, (int) );$ _PROTOTYP (char * ck_time, (void) );/ _PROTOTYP (static VOID ttslow, (char *, int) );  #ifdef COMMENT> _PROTOTYP (static VOID xcpy, (char *, char *, unsigned int) ); #endif /* COMMENT */+ _PROTOTYP (static VOID waitfor, (char *) ); ( _PROTOTYP (static VOID dialoc, (char) );3 _PROTOTYP (static int didweget, (char *, char *) ); ( _PROTOTYP (static VOID spdchg, (long) );' _PROTOTYP (static VOID tbati3, (int) ); ( _PROTOTYP (static int dialfail, (int) );   #define MDMINF	struct mdminf  6 MDMINF		/* structure for modem-specific information */     { >     int		dial_time;	/* time modem allows for dialing (secs) */@     char	*pause_chars;	/* character(s) to tell modem to pause */B     int		pause_time;	/* time associated with pause chars (secs) */B     char	*wake_str;	/* string to wakeup modem & put in cmd mode */C     int		wake_rate;	/* delay between wake_str characters (msecs) */ 9     char	*wake_prompt;	/* string prompt after wake_str */ >     char	*dmode_str;	/* string to put modem in dialing mode */<     char	*dmode_prompt;	/* string prompt for dialing mode */>     char	*dial_str;	/* dialing string, with "%s" for number */B     int		dial_rate;	/* delay between dialing characters (msecs) */>     int		esc_time;	/* guard time on escape sequence (msecs) */(     char	*esc_str;	/* escape sequence */&     char	*hup_str;	/* hangup string */L     _PROTOTYP( int (*ok_fn), (int,int) ); /* func to read response string */     };   /*!  * Define symbolic modem numbers.   *9  * The numbers MUST correspond to the ordering of entries 1  * within the ptrtab array, and start at one (1).   *7  * It is assumed that there are relatively few of these 7  * values, and that the high(er) bytes of the value may /  * be used for modem-specific mode information.   *9  * REMEMBER that only the first eight characters of these %  * names are guaranteed to be unique.   */   / #ifdef MINIDIAL				/* Minimum dialer support */ ) 					/* Only for CCITT, HAYES, and UNK */  #define		n_CCITT		 1 #define		n_HAYES		 2 #define		n_UNKNOWN	 3 0 #define		MAX_MDM		 3	/* Number of modem types */  ) #else					/* Full-blown dialer support */    #define		n_ATTDTDM	 1 " #define         n_ATTISN         2 #define		n_ATTMODEM	 3 #define		n_CCITT		 4 #define		n_CERMETEK	 5 #define		n_DF03		 6  #define		n_DF100		 7 #define		n_DF200		 8 #define		n_GDC		 9 #define		n_HAYES		10 #define		n_PENRIL	11 #define		n_RACAL		12 #define		n_UNKNOWN	13  #define		n_USROBOT	14  #define		n_VENTEL	15 #define		n_CONCORD	16 2 #define		n_ATTUPC	17	/* aka UNIX PC and ATT7300 */3 #define		n_ROLM          18      /* Rolm CBX DCM */  #define		n_MICROCOM	19" #define         n_HST           20C #define         n_TELEBIT       21      /* Telebits of all kinds */ F #define         n_DIGITEL       22	/* Digitel DT-22 (CCITT variant) */0 #define		MAX_MDM		22	/* Number of modem types */   #endif /* MINIDIAL */    /*G  * Declare modem "variant" numbers for any of the above for which it is E  * necessary to note various operational modes, using the second byte   * of a modem number.   *D  * It is assumed that such modem modes share the same modem-specificK  * information (see MDMINF structure) but may differ in some of the actions   * that are performed.  */   9 /*  Warning - this is starting to get kind of hokey... */    #define DIAL_NV 256 ) #define n_HAYESNV ( n_HAYES   | DIAL_NV )    #ifndef MINIDIAL #define DIAL_PEP 512 #define DIAL_V32 1024  #define DIAL_V42 2048  #define DIAL_SLO 4096 * #define n_TBPEP   ( n_TELEBIT | DIAL_PEP )* #define n_TB3     ( n_TELEBIT | DIAL_V32 )) #define n_TBNV    ( n_TELEBIT | DIAL_NV ) 4 #define n_TBPNV   ( n_TELEBIT | DIAL_NV | DIAL_PEP )4 #define n_TB3NV   ( n_TELEBIT | DIAL_NV | DIAL_V32 )* #define n_TB4     ( n_TELEBIT | DIAL_V42 )* #define n_TBS     ( n_TELEBIT | DIAL_SLO )4 #define n_TB4NV   ( n_TELEBIT | DIAL_NV | DIAL_V42 )4 #define n_TBSNV   ( n_TELEBIT | DIAL_NV | DIAL_SLO ) #endif /* MINIDIAL */    /*<  * Declare structures containing modem-specific information.  *9  * REMEMBER that only the first SEVEN characters of these %  * names are guaranteed to be unique.   */    #ifndef MINIDIAL static) MDMINF ATTISN =				/* AT&T ISN Network */      {      30,					/* Dial time */ "     "",					/* Pause characters */     0,					/* Pause time */ +     "\015\015\015\015",			/* Wake string */      900,				/* Wake rate */       "DIAL",				/* Wake prompt */     "",					/* dmode_str */      "",					/* dmode_prompt */     "%s\015",				/* dial_str */      0,					/* dial_rate */     0,					/* esc_time */      "",					/* esc_str */      "",					/* hup_str */      NULL				/* ok_fn */      };   staticD MDMINF ATTMODEM =	/* information for AT&T switched-network modems */4 			/* "Number" following "dial" can include: p's and6 			 * t's to indicate pulse or tone (default) dialing,2 			 * + for wait for dial tone, , for pause, r for5 			 * last number dialed, and, except for 2224B, some 8 			 * comma-delimited options like o12=y, before number.  &  * "Important" options for the modems:  *<  *	All:		Except for 2224B, enable option 12 for "transparent4  *			data," o12=y.  If a computer port used for both4  *			incoming and outgoing calls is connected to the7  *			modem, disable "enter interactive mode on carriage 2  *			return," EICR.  The Kermit "dial" command can,  *			function with EIA leads standard, EIAS.  *6  *	2212C:		Internal hardware switches at their default4  *			positions (four rockers down away from numbers)6  *			unless EICR is not wanted (rocker down at the 4).$  *			For EIAS, rocker down at the 1.  *>  *	2224B:		Front-panel switch position 1 must be up (at the 1,1  *			closed).  Disable EICR with position 2 down.   *			For EIAS, position 4 down. )  *			All switches on the back panel down.   *?  *	2224CEO:	All front-panel switches down except either 5 or 6. 0  *			Enable interactive flow control with o16=y.7  *			Select normal asynchronous mode with o34=0 (zero). 6  *			Disable EICR with position 3 up.  For EIAS, 1 up.-  *			Reset the modem after changing switches.   *6  *	2296A:		If option 00 (zeros) is present, use o00=0.0  *			Enable interactive flow control with o16=y.7  *			Select normal asynchronous mode with o34=0 (zero). F  *                      (available in Microcom Networking version, butC  *                      not necessarily other models of the 2296A). 7  *			Enable modem-port flow control (if available) with 7  * 			o42=y.  Enable asynchronous operation with o50=y. 6  * 			Disable EICR with o69=n.  For EIAS, o66=n, using  * 			front panel.  */      {      20,			/* dial_time */      ",",		/* pause_chars */      2,			/* pause_time */      "+",		/* wake_str */     0,			/* wake_rate */     "",			/* wake_prompt */      "",			/* dmode_str */      "",			/* dmode_prompt */     "at%s\015",		/* dial_str */      0,			/* dial_rate */     0,			/* esc_time */      "",			/* esc_str */      "",			/* hup_str */      NULL			/* ok_fn */     };   staticE MDMINF ATTDTDM =	/* information for AT&T Digital Terminal Data Module 9  *			For dialing: KYBD switch down, others usually up. */      {      20,			/* dial_time */      "",			/* pause_chars */      0,			/* pause_time */      "",			/* wake_str */     0,			/* wake_rate */     "",			/* wake_prompt */      "",			/* dmode_str */      "",			/* dmode_prompt */-     "%s\015",		/* dial_str */		/* not used */      0,			/* dial_rate */     0,			/* esc_time */      "",			/* esc_str */      "",			/* hup_str */      NULL		/* ok_fn */      }; #endif /* MINIDIAL */    static0 MDMINF CCITT =				/* CCITT V.25bis autodialer */ /*   According to V.25bis: =   . Even parity is required for giving commands to the modem. %   . Commands might or might not echo. I   . Responses ("Indications") from the modem are terminated by CR and LF. "   . Call setup is accomplished by:I     - DTE raises DTR (V.24 circuit 108)              [ttopen() does this] L     - Modem raises CTS (V.24 circuit 106)            [C-Kermit ignores this]/     - DTE issues a call request command ("CRN") 4     - Modem responds with "VAL" ("command accepted")     - If the call is completed: 5         modem responds with "CNX" ("call connected"); "         modem turns CTS (106) OFF;!         modem turns DSR (107) ON;        else: J         modem responds with "CFI <parameter>" ("call failure indication").1   . To clear a call, the DTE turns DTR (108) OFF. L   . There is no mention of the Carrier Detect circuit (109) in the standard.J   . There is no provision for "escaping back" to the modem's command mode.  I   It is not known whether there exists in real life a pure V.25bis modem. M   If there is, this code has never been tested on it.  See the Digitel entry.  */     { ,     40,			/* dial_time -- programmable -- */?     ",:",		/* pause_chars -- "," waits for programmable time */h5                         /* ":" waits for dial tone */ 2     10,			/* pause_time (seconds, just a guess) */     "",			/* wake_str (none) */9      200,		/* wake_rate (msec) */     "VAL",		/* wake_prompt */T      "",			/* dmode_str (none) */#     "",			/* dmode_prompt (none) */o&     "CRN%s\015",        /* dial_str */      200,		/* dial_rate (msec) */     0,			/* No esc_time */     "",			/* No esc_str  */i     "",			/* No hup_str  */r     NULL		/* No ok_fn    */e     };  D #ifndef MINIDIAL	/* Don't include the following if -DMINIDIAL ... */   staticH MDMINF CERMETEK =	/* Information for "Cermetek Info-Mate 212 A" modem */     {c     20,			/* dial_time */o      "BbPpTt",		/* pause_chars *//     0,			/* pause_time */	/** unknown -- DS **/i#     "  XY\016R\015",	/* wake_str */      200,		/* wake_rate */i     "",			/* wake_prompt */m     "",			/* dmode_str */u     NULL,		/* dmode_prompt */y$     "\016D '%s'\015",	/* dial_str */     200,		/* dial_rate */e     0,			/* esc_time */l     "",			/* esc_str */r     "",			/* hup_str */      NULL		/* ok_fn */B     };   static8 MDMINF DF03 =		/* information for "DEC DF03-AC" modem */     {a     27,			/* dial_time */s;     "=",		/* pause_chars */	/* wait for second dial tone */c     15,			/* pause_time */     "\001\002",		/* wake_str */e     0,			/* wake_rate */     "",			/* wake_prompt */i     "",			/* dmode_str */P     NULL,		/* dmode_prompt */s     "%s",		/* dial_str */s     0,			/* dial_rate */     0,			/* esc_time */e     "",			/* esc_str */k     "",			/* hup_str */      NULL		/* ok_fn */f     };   static> MDMINF DF100 =		/* information for "DEC DF100-series" modem */ 			/*e9 			 * The telephone "number" can include "P"s and/or "T"sn6 			 * within it to indicate that subsequent digits are4 			 * to be dialed using pulse or tone dialing.  The6 			 * modem defaults to pulse dialing.  You may modify5 			 * the dial string below to explicitly default alle5 			 * dialing to pulse or tone, but doing so prevents 7 			 * the use of phone numbers that you may have storedo 			 * in the modem's memory. 			 */     {e     30,			/* dial_time */t;     "=",		/* pause_chars */	/* wait for second dial tone */b     15,			/* pause_time */     "\001",		/* wake_str */m     0,			/* wake_rate */     "",			/* wake_prompt */,     "",			/* dmode_str */5     NULL,		/* dmode_prompt */      "%s#",		/* dial_str */     0,			/* dial_rate */     0,			/* esc_time */s     "",			/* esc_str */b     "",			/* hup_str */u     NULL		/* ok_fn *//     };   static> MDMINF DF200 =		/* information for "DEC DF200-series" modem */ 			/*n9 			 * The telephone "number" can include "P"s and/or "T"ss6 			 * within it to indicate that subsequent digits are4 			 * to be dialed using pulse or tone dialing.  The6 			 * modem defaults to pulse dialing.  You may modify5 			 * the dial string below to explicitly default all,5 			 * dialing to pulse or tone, but doing so preventsf7 			 * the use of phone numbers that you may have storedf 			 * in the modem's memory. 			 */     {      30,			/* dial_time */,<     "=W",		/* pause_chars */	/* =: second tone; W: 5 secs */+     15,			/* pause_time */	/* worst case */n<     "\002",		/* wake_str */		/* allow stored number usage */     0,			/* wake_rate */     "",			/* wake_prompt */n     "",			/* dmode_str *//     NULL,		/* dmode_prompt */r #ifdef COMMENT     "%s!",		/* dial_str */ #elsed     "   d %s\015", #endif /* COMMENT */     0,			/* dial_rate */     0,			/* esc_time */i     "",			/* esc_str */r     "",			/* hup_str */u     NULL		/* ok_fn */      };   staticH MDMINF DIGITEL =        /* Digitel DT-22 CCITT variant used in Brazil */ /*N   Attempts to adhere strictly to the V.25bis specification do not produce goodI   results in real life.  The modem for which this code was developed: (a),M   ignores parity; (b) sometimes terminates responses with LF CR instead of CRGI   LF; (c) has a Hayes-like escape sequence; (d) supports a hangup ("HUP")A9   command.  Information from Fernando Cabral in Brasilia.N */     {F,     40,			/* dial_time -- programmable -- */?     ",:",		/* pause_chars -- "," waits for programmable time */O5                         /* ":" waits for dial tone */ 2     10,			/* pause_time (seconds, just a guess) */;     "HUP\015",          /* wake_str (Not Standard CCITT) */h      200,		/* wake_rate (msec) */     "VAL",		/* wake_prompt */*      "",			/* dmode_str (none) */#     "",			/* dmode_prompt (none) */ &     "CRN%s\015",        /* dial_str */      200,		/* dial_rate (msec) */.     1100,		/* esc_time (Not Standard CCITT) *//     "+++",		/* esc_str  (Not Standard CCITT) */i3     "HUP\015",		/* hup_str  (Not Standard CCITT) */M     getok		/* ok_fn */     };   staticC MDMINF GDC =		/* information for "GeneralDataComm 212A/ED" modem */b     {t     32,			/* dial_time */m     "%",		/* pause_chars */      3,			/* pause_time */n     "\015\015",		/* wake_str */R     500,		/* wake_rate */P     "$",		/* wake_prompt */e     "D\015",		/* dmode_str */      ":",		/* dmode_prompt */     "T%s\015",		/* dial_str */     0,			/* dial_rate */     0,			/* esc_time */      "",			/* esc_str */e     "",			/* hup_str */+     NULL		/* ok_fn */,     }; #endif /* MINIDIAL */    staticA MDMINF HAYES =		/* Information for Hayes and Hayes-like modems */      {M     35,			/* dial_time *//     ",",		/* pause_chars */      2,			/* pause_time */1#     "ATQ0S2=43\015",	/* wake_str */Q /*H   Note: Other wake_str's are possible here.  For a Hayes 2400 that is toJ   be used for both in and out calls, AT&F&D3 might be best.  For out calls.   only, maybe AT&F&D2.  See Hayes 2400 manual. */     0,			/* wake_rate */     "",			/* wake_prompt */i     "",			/* dmode_str */n     "",			/* dmode_prompt */=     "ATD%s\015",	/* dial_str, note: user can supply D or T */*     0,			/* dial_rate */     1100,		/* esc_time */      "+++",		/* esc_str */d     "ATQ0H0\015",	/* hup_str */d     getok		/* ok_fn */     };   #ifndef MINIDIAL   static5 MDMINF PENRIL =		/* information for "Penril" modem */B     {0     50,			/* dial_time */ 1     "",			/* pause_chars */	/** unknown -- HF **/      0,			/* pause_time */*     "\015\015",		/* wake_str */A     300,		/* wake_rate */"     ">",		/* wake_prompt */0     "k\015",		/* dmode_str */0     ":",		/* dmode_prompt */     "%s\015",		/* dial_str */0     0,			/* dial_rate */     0,			/* esc_time */*     "",			/* esc_str */_     "",			/* hup_str */	     NULL		/* ok_fn */W     };   staticG MDMINF RACAL =		/* information for "Racal Vadic" modem, e.g. VA4492E */      { @     35,			/* dial_time (manual says modem is hardwired to 60) */     "Kk",		/* pause_chars */     5,			/* pause_time */C%     "\005\015",		/* wake_str, ^E^M */      50,			/* wake_rate */]     "*",		/* wake_prompt */o     "D\015",		/* dmode_str *//     "?",		/* dmode_prompt */     "%s\015",		/* dial_str */O     0,			/* dial_rate */     1100,		/* esc_time */	=     "\003\004",		/* esc_str, ^C^D (this actually hangs up) */;?     "\005",		/* hup_str, ^E (this goes back to command mode) */      NULL		/* ok_fn */d     }; #endif /* MINIDIAL */n   /*A   The intent of the "unknown" modem is to allow KERMIT to supportfE   unknown modems by having the user type the entire autodial sequencePF   (possibly including control characters, etc.) as the "phone number".H   The protocol and other characteristics of this modem are unknown, withJ   some "reasonable" values being chosen for some of them.  The only way to8   detect if a connection is made is to look for carrier. */ static6 MDMINF UNKNOWN =	/* information for "Unknown" modem */     {s     30,			/* dial_time */)     "",			/* pause_chars */d     0,			/* pause_time */      "",			/* wake_str */     0,			/* wake_rate */     "",			/* wake_prompt */      "",			/* dmode_str */t     NULL,		/* dmode_prompt */a     "%s\015",		/* dial_str */d     0,			/* dial_rate */     0,			/* esc_time */f     "",			/* esc_str */t     "",			/* hup_str */d     NULL		/* ok_fn */      };   #ifndef MINIDIAL   static? MDMINF USROBOT =	/* information for "US Robotics 212A" modem */	     {t     30,			/* dial_time */h     ",",		/* pause_chars */h     2,			/* pause_time */w#     "ATQ0S2=43\015",	/* wake_str */      0,			/* wake_rate */      "OK\015",		/* wake_prompt */     "",			/* dmode_str */;     NULL,		/* dmode_prompt */r     "ATD%s\015",	/* dial_str */i     0,			/* dial_rate */     1100,		/* esc_time */r     "+++",		/* esc_str */d     "ATQ0H0\015",	/* hup_str */r     getok		/* ok_fn */     };   #ifdef COMMENT+ /* Reportedly this does not work at all. */a static5 MDMINF VENTEL =		/* information for "Ventel" modem */q     {m     20,			/* dial_time */;     "%",		/* pause_chars */h     5,			/* pause_time */n"     "\015\015\015",	/* wake_str */     300,		/* wake_rate */      "$",		/* wake_prompt */      "",			/* dmode_str */m     NULL,		/* dmode_prompt */M6     "<K\015%s\015>",    /* dial_str (was "<K%s\r>") */     0,			/* dial_rate */     0,			/* esc_time */s     "",			/* esc_str */e     "",			/* hup_str */*     NULL		/* ok_fn */i     }; #else  /* and this does. */ static5 MDMINF VENTEL =		/* information for "Ventel" modem */t     {h     20,			/* dial_time */      "%",		/* pause_chars */e     5,			/* pause_time */i"     "\015\015\015",	/* wake_str */     300,		/* wake_rate */r     "$",		/* wake_prompt */d&     "K\015",		/* dmode_str (was "") */5     "Number to call: ",	/* dmode_prompt (was NULL) */r4     "%s\015",	        /* dial_str (was "<K%s\r>") */     0,			/* dial_rate */     0,			/* esc_time */      "",			/* esc_str */f     "",			/* hup_str */n     NULL		/* ok_fn */	     }; #endif /* COMMENT */   static: MDMINF CONCORD =	/* Info for Condor CDS 220 2400b modem */     {n     35,			/* dial_time */P     ",",		/* pause_chars */2     2,			/* pause_time */d     "\015\015",		/* wake_str */V     20,			/* wake_rate */D     "CDS >",		/* wake_prompt */      "",			/* dmode_str */f     NULL,		/* dmode_prompt */ !     "<D M%s\015>",	/* dial_str */O     0,			/* dial_rate */     0,			/* esc_time */      "",			/* esc_str */      "",			/* hup_str */n     NULL		/* ok_fn */      };   staticL MDMINF ATTUPC = /* dummy information for "ATT7300/Unix PC" internal modem */     {/     30,			/* dial_time */      "",			/* pause_chars */n     0,			/* pause_time */b     "",			/* wake_str */     0,			/* wake_rate */     "",			/* wake_prompt */e     "",			/* dmode_str */u     NULL,		/* dmode_prompt */a     "%s\015",		/* dial_str */m     0,			/* dial_rate */     0,			/* esc_time */u     "",			/* esc_str */e     "",			/* hup_str */      NULL		/* ok_fn */      };   static> MDMINF ROLM =		/* IBM / Siemens / Rolm 8000, 9000, 9751 CBX */     {n     60,			/* dial_time */I     "",			/* pause_chars */      0,			/* pause_time */n     "\015\015",		/* wake_str */2     5,			/* wake_rate */(     "MODIFY?",	        /* wake_prompt */     "",			/* dmode_str */      "",			/* dmode_prompt */!     "CALL %s\015",	/* dial_str */      0,			/* dial_rate */     0,			/* esc_time */P     "",			/* esc_str */_     "",			/* hup_str */V     NULL		/* ok_fn */      };   staticH MDMINF MICROCOM =	/* information for "Microcom" modems in native mode */ 			/* (long answer only) */)     {n     35,			/* dial_time */I:     ",!@",		/* pause_chars (! and @ aren't pure pauses) */     3,			/* pause_time */m     "\015",		/* wake_str */*     100,		/* wake_rate */s     "!",		/* wake_prompt */      "",			/* dmode_str */b     NULL,		/* dmode_prompt */I     "d%s\015",		/* dial_str */     0,			/* dial_rate */     0,			/* esc_time */a     "",			/* esc_str */*     "",			/* hup_str */      NULL		/* ok_fn */      };   staticD MDMINF HST =		/* information for USR Courier and Sportster modems */     {      35,			/* dial_time */	     ",",		/* pause_chars */	     2,			/* pause_time */\H     "ATQ0S2=43X4&M4\015", /* wake_str (X7 not supported on Sportster) */     0,		        /* wake_rate */       "OK\015",		/* wake_prompt */      "",		        /* dmode_str */#     "",		        /* dmode_prompt */n     "ATD%s\015",	/* dial_str */      0,			/* dial_rate */     1100,		/* esc_time */a     "+++",		/* esc_str */u     "ATQ0H0\015",	/* hup_str */	     getok		/* ok_fn */     };   static/ MDMINF TELEBIT =	/* information for Telebits */      {s     60,			/* dial_time */      ",",		/* pause_chars */m     2,			/* pause_time */o /*O   NOTE: The wake_string MUST contain the I command (model query), and otherwise M   must contain commands that work on ALL Telebit models.  Here we ensure thatgM   result codes are returned (Q0), and ask for extended result codes (X1), andiK   ensure that the escape sequence is +++ and it is enabled.  And also, makeEM   sure the final character is not a digit (whose echo might be mistaken for afH   result code).  The Ctrl-Q and multiple A's are recommended by Telebit. */7     "\021AAAAATQ0X1S12=50 S2=43 I\015", /* wake_str. */e$     100,		/* wake_rate = 100 msec */      "OK\015",		/* wake_prompt */      "",		        /* dmode_str */#     "",		        /* dmode_prompt */F0     "ATD%s\015",	/* dial_str, Note: no T or P */     80,			/* dial_rate */*&     1100,		/* esc_time (guard time) */     "+++",		/* esc_str */	     "ATQ0H0\015",	/* hup_str */w     getok		/* ok_fn */     }; #endif /* MINIDIAL */3     /*F  * Declare table for converting modem numbers to information pointers.  *F  * The entries MUST be in ascending order by modem number, without any4  * "gaps" in the numbers, and starting from one (1).  *I  * This table should NOT include entries for the "variant" modem numbers, =  * since they share the same information as the normal value.b  */* static MDMINF *ptrtab[] = { #ifdef MINIDIALe     &CCITT,6     &HAYES,a     &UNKNOWN #elseo
     &ATTDTDM,a     &ATTISN,     &ATTMODEM,     &CCITT,u     &CERMETEK,
     &DF03,     &DF100,I     &DF200,.	     &GDC,      &HAYES,      &PENRIL,     &RACAL, 
     &UNKNOWN,	
     &USROBOT,      &VENTEL,
     &CONCORD,      &ATTUPC,
     &ROLM,     &MICROCOM,	     &HST,/
     &TELEBIT,a     &DIGITEL #endif /* MINIDIAL */* }; /*B  * Declare modem names and associated numbers for command parsing,1  * and also for doing number-to-name translation.,  *;  * The entries must be in alphabetical order by modem name.r  */  struct keytab mdmtab[] = { #ifndef MINIDIAL     "attdtdm",		n_ATTDTDM,	0, *     "attisn",           n_ATTISN,       0,     "attmodem",		n_ATTMODEM,	0,s     "att7300",		n_ATTUPC,	0, #endif /* MINIDIAL */      "ccitt-v25bis",	n_CCITT,	0,  #ifndef MINIDIAL     "cermetek",		n_CERMETEK,	0,      "concord",		n_CONCORD,	0,	*     "courier",          n_HST,          0,     "df03-ac",		n_DF03,		0,p     "df100-series",	n_DF100,	0,*     "df200-series",	n_DF200,	0,i!     "digitel-dt22",	n_DIGITEL,	0,  #endif /* MINIDIAL */*1     "direct",		0,		CM_INV,	/* Synonym for NONE */  #ifndef MINIDIAL     "gdc-212a/ed",	n_GDC,		0,F8     "gendatacomm",	n_GDC,		CM_INV,	/* Synonym for GDC */ #endif /* MINIDIAL */n     "hayes",		n_HAYES,	0,i #ifndef MINIDIALI     "hst-courier",      n_HST,          CM_INV,	/* Synonym for COURIER */n     "microcom",		n_MICROCOM,	0,  #endif /* MINIDIAL */l*     "none",             0,              0, #ifndef MINIDIAL     "penril",		n_PENRIL,	0,d*     "pep-telebit",      n_TBPEP,        0,     "racalvadic",	n_RACAL,	0,i     "rolm",		n_ROLM,		0,"     "slow-telebit",     n_TBS,		0,*     "sportster",        n_HST,          0,*     "telebit",          n_TELEBIT,      0, #endif /* MINIDIAL */s     "unknown",		n_UNKNOWN,	0,  #ifndef MINIDIAL$     "usrobotics-212a",	n_USROBOT,	0,"     "v32-telebit",      n_TB3,		0,"     "v42-telebit",      n_TB4,		0,     "ventel",		n_VENTEL,	0 #endif /* MINIDIAL */c };K int nmdm = (sizeof(mdmtab) / sizeof(struct keytab)); /* Number of modems */   1 #define CONNECTED 1			/* For completion status */s #define FAILED	  2   static int tries = 0;d8 static int mdmecho = 0;	/* assume modem does not echo */I static int augmdmtyp;	/* "augmented" modem type, to handle modem modes */o  5 static char *p;		/* For command strings & messages */d   #ifdef DYNAMIC #define LBUFL 256, static char *lbuf = NULL;w #elser #define LBUFL 100* static char lbuf[LBUFL]; #endif /* DYNAMIC */   #ifdef DYNAMIC #define RBUFL 256s static char *rbuf = NULL;  #else	 #define RBUFL 63 static char rbuf[RBUFL+1]; #endif /* DYNAMIC */   #ifdef DYNAMIC #define FULLNUML 256; char *fbuf = NULL;			/* For full (prefixed) phone number */N #else, #define FULLNUML 100 char fbuf[FULLNUML]; #endif /* DYNAMIC */   #ifdef CK_POSIX_SIG  static sigjmp_buf sjbuf; #else	 static jmp_buf sjbuf;  #endif /* CK_POSIX_SIG */   : static SIGTYP (*savalrm)();	/* For saving alarm handler */= static SIGTYP (*savint)();	/* For saving interrupt handler */r   #ifndef MINIDIAL+ int tbmodel = 0;		/* Telebit modem model */i   char *= gtbmodel() {			/* Function to return name of Telebit model */n;     if (tbmodel < 0 || tbmodel > TB__MAX) tbmodel = TB_UNK;0     return(tb_name[tbmodel]);	 }w   #ifdef COMMENT static VOIDo7 xcpy(to,from,len)		/* Copy the given number of bytes */s     register char *to, *from;,      register unsigned int len; { 	while (len--) *to++ = *from++;* }  #endif /* COMMENT */ #endif /* MINIDIAL */*  
 static SIGTYPt7 dialtime(foo) int foo; {		/* Timer interrupt handler */ 8     fail_code = F_TIME;			/* Failure reason = timeout *//     debug(F100,"dialtime caught SIGALRM","",0);5 #ifdef __EMX__4     signal(SIGALRM, SIG_ACK);		/* Needed for OS/2 */ #endif /* __EMX__ */   #ifdef OSK				/* OS-9 */ /*L   We are in an intercept routine but do not perform a F$RTE (done implicitlyG   by RTS), so we have to decrement the sigmask as F$RTE does.  Warning:kM   longjump only restores the CPU registers, NOT the FPU registers.  So, don't1L   use FPU at all or at least don't use common FPU (double or float) register   variables. */     sigmask(-1); #endif /* OSK */ #ifdef CK_POSIX_SIGt     siglongjmp(sjbuf,1); #elseb     longjmp(sjbuf,1);  #endif /* CK_POSIX_SIG */o }   
 static SIGTYP : dialint(foo) int foo; {			/* Keyboard interrupt handler */     fail_code = F_INT;-     debug(F100,"dialint caught SIGINT","",0);e #ifdef __EMX__3     signal(SIGINT, SIG_ACK);		/* Needed for OS/2 */  #endif /* __EMX__ */3 #ifdef OSK				/* OS-9, see comment in dialtime() */,     sigmask(-1); #endif /* OSK */ #ifdef CK_POSIX_SIG      siglongjmp(sjbuf,1); #else"     longjmp(sjbuf,1);  #endif /* CK_POSIX_SIG */" }	   /*H   Routine to read a character from communication device, handling TELNETF   protocol negotiations in case we're connected to the modem through a   TCP/IP TELNET modem server.b */
 static int ddinc(n) int n; {L
     int c;  
 #ifdef TNCODEt     int done = 0;	%     debug(F101,"ddinc entry n","",n);o     while (!done) {  	c = ttinc(n); 	debug(F000,"ddinc","",c); 	if (c < 0) return(c);4 	if (c == IAC && network && ttnproto == NP_TELNET) {6 	    switch (tn_doop((CHAR)(c & 0xff),duplex,ttinc)) {$ 	      case 2: duplex = 0; continue; 	      case 1: duplex = 1; 	      default: continue;l 	    } 	} else done = 1;o     }      return(c & 0xff);  #elseh%     debug(F101,"ddinc entry n","",n);e     return(ttinc(n));m #endif /* TNCODE *// }    static VOID	D ttslow(s,millisec) char *s; int millisec; { /* Output s-l-o-w-l-y */ #ifdef TCPSOCKET     extern int tn_nlm; #endif /* TCPSOCKET */@     if (dialdpy && duplex)		/* Echo the command in case modem */7       printf("%s\n",s);			/* isn't echoing commands. */o     for (; *s; s++) {/
 	ttoc(*s); #ifdef TCPSOCKETF 	if (*s == CR && network && ttnproto == NP_TELNET && tn_nlm != TNL_CR)1 	  ttoc((char)((tn_nlm == TNL_CRLF) ? LF : NUL));s #endif /* TCPSOCKET */ 	msleep(millisec);     }h }s   /*#  * Wait for a string of characters.t  *G  * The characters are waited for individually, and other characters may/H  * be received "in between".  This merely guarantees that the characters,  * ARE received, and in the order specified.  */w static VOIDe waitfor(s) char *s; {      CHAR c, x;?     while ( c = *s++ ) {		/* while more characters remain... */F% 	do {				/* wait for the character */  	    x = ddinc(0) & 0177;") 	    debug(F000,"dial waitfor got","",x);a 	    if (dialdpy) {/ 		if (x != LF) conoc(x); 		if (x == CR) conoc(LF);/ 	    } 	} while ( x != c);-     }i }f  
 static intC didweget(s,r) char *s, *r; {	/* Looks in string s for response r */ G     int lr = (int)strlen(r);	/*  0 means not found, 1 means found it */ 
     int i;     debug(F110,"didweget",r,0);,     debug(F110," in",s,0);,     for (i = (int)strlen(s)-lr; i >= 0; i--); 	if ( s[i] == r[0] ) if ( !strncmp(s+i,r,lr) ) return( 1 );C     return( 0 ); }d    . /* R E S E T -- Reset alarms, etc. on exit. */   static VOIDe
 dreset() {
     alarm(0); 9     signal(SIGALRM,savalrm);		/* restore alarm handler */5;     signal(SIGINT,savint);		/* restore interrupt handler */  }    /*M   Call this routine when the modem reports that it has connected at a certainbK   speed, giving that speed as the argument.  If the connection speed is not/K   the same as Kermit's current communication speed, AND the modem interfacePK   speed is not locked (i.e. DIAL SPEED-MATCHING is not ON), then change thed    device speed to the one given. */ static VOID  #ifdef CK_ANSIC  spdchg(long s) #elsee spdchg(s) long s;e #endif /* CK_ANSIC */* /* spdchg */ {     int s2;_9     if (!mdmspd)			/* If modem interface speed locked, */Y&       return;				/*  don't do this. */,     if (speed != s) {			/* Speeds differ? */6 	s2 = s / 10L;			/* Convert to cps expressed as int */+ 	if (ttsspd(s2) < 0) {		/* Change speed. */Q; 	    printf(" Warning: speed change to %ld failed.\r\n",s);s	 	} else {i, 	    printf(" Speed changed to %ld.\r\n",s);4 	    speed = s;			/* Update global speed variable */ 	}     }a }    /*I   Display all characters received from modem dialer through this routine,	<   for consistent handling of carriage returns and linefeeds. */ static VOID  #ifdef CK_ANSICp dialoc(char c) #else	 dialoc(c) char c;  #endif /* CK_ANSIC */ - { /* dialoc */				/* Dial Output Character */	     if (dialdpy) {, 	if (c != LF) conoc(c);		/* Don't echo LF *// 	if (c == CR) conoc(LF);		/* Echo CR as CRLF */P     }m }m   #ifndef MINIDIAL /*F   tbati3() -- Routine to find out Telebit model when ATI reports "965"G   or "971". This routine sends another query, ATI3, to get further infowH   to narrow down the model number.  Argument is ATI response as integer.1   Result: sets tbmodel variable to Telebit model.i */ static VOID, tbati3(n) int n; {     int status;i)     ttflui();				/* Flush input buffer */	0     ttslow("ATI3\015",100);		/* Send ATI3<CR> */:     status = getok(5,0);		/* Get OK response, nonstrict */.     if (status < 1) {			/* ERROR or timeout */ 	tbmodel = TB_UNK;( 	debug(F111,"tbati3 fails",rbuf,status); 	return;     } %     debug(F110,"tbati3 rbuf",rbuf,0);"  / /* Got a good response, check the model info */]  3     if (n == 965) {			/* "965" - various models. */s 	if (didweget(rbuf,"T1600")) {% 	    tbmodel = TB_1600;			/* T1600 */ % 	} else if (didweget(rbuf,"T3000")) {s% 	    tbmodel = TB_3000;			/* T3000 */,% 	} else if (didweget(rbuf,"World")) { + 	    tbmodel = TB_WBLA;			/* WorldBlazer */mG 	} else if (didweget(rbuf,"Version B") || /* TrailBlazer-Plus models */  		   didweget(rbuf,"TBSA") ||n 		   didweget(rbuf,"TBRM") ||u0 		   didweget(rbuf,"DC")) { 	/* Ven-Tel EC18K */ 	    tbmodel = TB_PLUS;c0 	} else tbmodel = TB_UNK;		/* Others: Unknown */  @     } else if (n == 971) {		/* "971" could be T1500 or T1600. */ 	if (didweget(rbuf,"T1500")) 	  tbmodel = TB_1500;a 	else tbmodel = TB_2500;,     }					/* Other, don't change tbmodel. */ }i #endif /* MINIDIAL */o  
 static int dialfail(x) int x; {
     char * s;t       fail_code = x;(     debug(F101,"ckudial dialfail","",x);'     alarm(0);				/* Disable timeouts */ *     dreset();				/* Reset alarm signals */       printf("DIAL Failure: ");	.     if (dialdpy) {			/* If showing progress */) 	p = ck_time();			/* get current time; */" 	if (*p) printf("%s: ",p);     }l/     switch (fail_code) {		/* Type of failure */e#       case F_TIME: 			/* Timeout */  	if (dial_what == DW_INIT)< 	  printf ("Timed out while trying to initialize modem.\n"); 	else if (dial_what == DW_DIAL)*/ 	  printf ("DIAL TIMEOUT interval expired.\n");	 	else printf("Timeout.\n");/ 	if (mymdmtyp == n_HAYES #ifndef MINIDIAL2 	    || mymdmtyp == n_TELEBIT || mymdmtyp == n_HST #endif /* MINIDIAL */  	    )4 	  ttoc('\015');		/* Send CR to interrupt dialing */; 	/* Some Hayes modems don't fail with BUSY on busy lines */0 	dialsta = DIA_TIMO;  	debug(F110,"dial","timeout",0); 	break;	  -       case F_INT:			/* Dialing interrupted */  	printf ("Interrupted.\n"); $ 	debug(F110,"dial","interrupted",0); 	if (mymdmtyp == n_HAYES #ifndef MINIDIAL2 	    || mymdmtyp == n_TELEBIT || mymdmtyp == n_HST #endif /* MINIDIAL */* 	    )5 	  ttoc('\015');			/* Send CR to interrupt dialing */  	dialsta = DIA_INTR; 	break;   4       case F_MODEM:			/* Modem detected a failure */  	printf ("Call not completed.");
 	if (*lbuf) {1# 	    printf("  Modem message: \"");/ 	    for (s = lbuf; *s; s++) 	      if (isprint(*s)) . 		putchar(*s);		/* Display printable reason */ 	    printf ("\"");* 	} 	printf("\n"); 	debug(F110,"dial",lbuf,0); % 	if (dialsta < 0) dialsta = DIA_UNSP;n 	break;m  7       case F_MINIT:			/* Failure to initialize modem */e( 	printf ("Error initializing modem.\n");# 	debug(F110,"dial","modem init",0);  	dialsta = DIA_NOIN; 	break;,     }k   #ifdef DYNAMIC&     if (lbuf) free(lbuf); lbuf = NULL;&     if (rbuf) free(rbuf); rbuf = NULL;&     if (fbuf) free(fbuf); fbuf = NULL; #endif /* DYNAMIC */  ?     if (dialsta < 0) dialsta = DIA_UERR; /* Set failure code */*/     return(0);				/* Return zero (important) */	 }o  1 /*  C K D I A L	 --  Dial up the remote system */I  . /* Returns 1 if call completed, 0 otherwise */  ( static int waitct, mdmwait, mdmstat = 0;   int	 ckdial(telnbr) char *telnbr; {       char c, c2;  #define ERMSGL 50e8     char errmsg[ERMSGL], *erp;		/* for error messages */;     MDMINF *pmdminf;			/* pointer to modem-specific info */_     int x, m, n = F_TIME;>     char *s, *ws;   B     char *mmsg = "Sorry, DIAL memory buffer can't be allocated\n";       long conspd;     char *cptr;   <     mymdmtyp = mdmtyp;			/* Make local copy of modem type */?     dialsta = DIA_UNK;			/* Start with return code = unknown */0:     dial_what = DW_NOTHING;		/* Doing nothing at first. */   #ifndef MINIDIAL6     tbmodel = TB_UNK;			/* Initialize Telebit model */ #endif /* MINIDIAL */e       if (mymdmtyp < 1) {u
 	if (network) 9 	  printf("Please SET HOST first, and then SET MODEM\n");/ 	elser/ 	  printf("Sorry, you must SET MODEM first\n");c 	dialsta = DIA_NOMO; 	return(0);      }L     if (!local) { 8 	printf("Sorry, you must SET LINE or SET HOST first\n"); 	dialsta = DIA_NOLI; 	return(0);	     }a     if (!network &&	
 	(speed < 0L)* #ifdef UNIX/  	&& (strcmp(ttname,"/dev/null")) #endif /* UNIX */  	) {- 	printf("Sorry, you must SET SPEED first\n");e 	dialsta = DIA_NOSP; 	return(0);*     } '     debug(F110,"dial number",telnbr,0);5:     debug(F110,"dial prefix",(dialnpr ? dialnpr : ""), 0);   #ifdef DYNAMICH     if (!(lbuf = malloc(LBUFL+1))) {    /* Allocate input line buffer */ 	printf("%s", mmsg); 	dialsta = DIA_IE; 	return(0);r     }o     *lbuf = NUL;1     debug(F101,"DIAL lbuf malloc ok","",LBUFL+1);	  O     if (!rbuf) {    /* This one might already have been allocated by getok() */ E 	if (!(rbuf = malloc(RBUFL+1))) {    /* Allocate input line buffer */_ 	    printf("%s", mmsg); 	    dialsta = DIA_IE;' 	    if (lbuf) free(lbuf); lbuf = NULL;m 	    return(0);0 	} elsed0 	  debug(F101,"DIAL rbuf malloc ok","",RBUFL+1);     }eK     if (!(fbuf = malloc(FULLNUML+1))) {    /* Allocate input line buffer */* 	printf("%s", mmsg); 	dialsta = DIA_IE;# 	if (lbuf) free(lbuf); lbuf = NULL;r# 	if (rbuf) free(rbuf); rbuf = NULL;_ 	return(0);      }*4     debug(F101,"DIAL fbuf malloc ok","",FULLNUML+1); #endif /* DYNAMIC */    /* Add prefix to phone number */       if (dialnpr && *dialnpr) {@ 	if (((int)strlen(dialnpr) + (int)strlen(dialnpr)) > FULLNUML) {6 	    printf("DIAL prefix + phone number too long!\n"); #ifdef DYNAMIC' 	    if (lbuf) free(lbuf); lbuf = NULL;1' 	    if (rbuf) free(rbuf); rbuf = NULL;s' 	    if (fbuf) free(fbuf); fbuf = NULL;  #endif /* DYNAMIC */ 	    return(0);c 	}6 	sprintf(fbuf,"%s%s",(dialnpr ? dialnpr : ""),telnbr); 	telnbr = fbuf;_     } -     debug(F110,"prefixed number", telnbr, 0);s  K     if (ttopen(ttname,&local,mymdmtyp,0) < 0) { /* Open, no carrier wait */) 	erp = errmsg;) 	if ((int)strlen(ttname) < (ERMSGL - 18))T. 	  sprintf(erp,"Sorry, can't open %s",ttname); 	elsee+ 	  sprintf(erp,"Sorry, can't open device");o 	perror(errmsg); 	dialsta = DIA_OPEN; #ifdef DYNAMIC# 	if (lbuf) free(lbuf); lbuf = NULL; # 	if (rbuf) free(rbuf); rbuf = NULL;i# 	if (fbuf) free(fbuf); fbuf = NULL;  #endif /* DYNAMIC */ 	return(0);      }e  7 /* Condition console terminal and communication line */2  1     /* Place line into "clocal" dialing state, */_1     /* important mainly for System V UNIX.     *//  +     if (ttpkt(speed,FLO_DIAL,parity) < 0) { 1 	ttclos(0);			/* If ttpkt fails do all this... */s, 	if (ttopen(ttname,&local,mymdmtyp,0) < 0) { 	    erp = errmsg;- 	    if ((int)strlen(ttname) < (ERMSGL - 18))r4 	      sprintf(erp,"Sorry, can't reopen %s",ttname);	 	    else 1 	      sprintf(erp,"Sorry, can't reopen device");b 	    perror(errmsg); 	    dialsta = DIA_OPEN; #ifdef DYNAMIC' 	    if (lbuf) free(lbuf); lbuf = NULL;y' 	    if (rbuf) free(rbuf); rbuf = NULL;t' 	    if (fbuf) free(fbuf); fbuf = NULL;* #endif /* DYNAMIC */ 	    return(0);i 	}				/* And try again. */' 	if ((ttpkt(speed,FLO_DIAL,parity) < 0)f #ifdef UNIXh  	&& (strcmp(ttname,"/dev/null")) #endif /* UNIX */  	    ) {; 	    printf("Sorry, Can't condition communication line\n"); 0 	    printf("Try 'set line %s' again\n",ttname); 	    dialsta = DIA_OPEN; #ifdef DYNAMIC' 	    if (lbuf) free(lbuf); lbuf = NULL;S' 	    if (rbuf) free(rbuf); rbuf = NULL;O' 	    if (fbuf) free(fbuf); fbuf = NULL;C #endif /* DYNAMIC */ 	    return(0);  	}     }      msleep(500);  M     pmdminf = ptrtab[ (mymdmtyp & 0xff) -1 ]; /* set pointer to modem info */dB     augmdmtyp = mymdmtyp;		/* initialize "augmented" modem type */.     mymdmtyp &= 0xff;			/* major modem type */  (     /* Interdigit waits for tone dial */  5     if (dialtmo < 1) {			/* Automatic computation. */aF 	waitct = 1 * (int)strlen(telnbr) ; /* Compute worst case dial time */E 	waitct += pmdminf->dial_time;	/* dialtone + completion wait times */ ? 	for (s = telnbr; *s; s++) {	/* add in pause characters time */ * 	    for (p=pmdminf->pause_chars; *p; p++) 	      if (*s == *p) {" 		  waitct += pmdminf->pause_time;
 		  break; 	      } 	} #ifndef MINIDIAL4 	if (augmdmtyp == n_TBPEP || augmdmtyp == n_TBPNV) {9 	    waitct += 30;	/* Longer connect wait for PEP call */L 	} #endif /* MINIDIAL */_,     } else {				/* User-specified timeout */ 	waitct = dialtmo;     }	 /*   waitct is our alarm() timer.<   mdmwait is how long we tell the modem to wait for carrier.A   We set mdmwait to be 1 second less than waitct, to increase the A   chance that we get a response from the modem before timing out.O */     if (waitct < 0) waitct = 0; 1     mdmwait = (waitct > 5) ? waitct - 5 : waitct;I  :     for (m = 0; m < nmdm; m++) {	/* Look up modem type. */# 	if (mdmtab[m].kwval == mymdmtyp) {_ 	    break;  	}     }n@     if (!quiet && !backgrd) {		/* Print information messages. */! 	printf(" Number: %s\n", telnbr);b 	if (network) {E8 	    printf(" Via modem server: %s, modem-dialer: %s\n",9 		   ttname, (m >= nmdm ? "(unknown)" : mdmtab[m].kwd) );R	 	} else { , 	    printf(" Device: %s, modem-dialer: %s",9 		   ttname, (m >= nmdm ? "(unknown)" : mdmtab[m].kwd) );/ 	    if (speed > -1L) ' 	      printf(", speed: %ld\n", speed);y	 	    elseu& 	      printf(", speed: (unknown)\n"); 	}. 	printf(" Dial timeout: %d seconds\n",waitct); 	printf(
 #ifdef MAC. 	       " Type Command-. to cancel dialing.\n" #elsee #ifdef UNIXcH 	       " To cancel: type your interrupt character (normally Ctrl-C).\n" #elsea$ 	       " To cancel: type Ctrl-C.\n" #endif /* UNIX */N #endif /* MAC */
 	       );     } 4     debug(F111,"ckdial",ttname,(int) (speed / 10L));+     debug(F101,"ckdial timeout","",waitct);f  ' /* Set timer and interrupt handlers. */r       if ( #ifdef CK_POSIX_SIGF 	sigsetjmp(sjbuf,1)f #else1 	setjmp(sjbuf) #endif /* CK_POSIX_SIG */  	) {		/* Handle failures */b 	return(dialfail(fail_code));x     } else {! 	alarm(0);			/* No alarms yet. */0A 	savalrm = signal(SIGALRM,dialtime); /* Enable alarm() handler */ 
 #ifdef MACH 	savint = signal(SIGINT, dialint); /* And terminal interrupt handler. */ #else /* MAC */ 
 #ifdef OSKA 	if ((savint = signal(SIGINT,SIG_IGN)) != (SIGTYP (*)()) SIG_IGN)  	  signal(SIGINT,dialint); #elsen3 	if ((savint = signal(SIGINT,SIG_IGN)) != SIG_IGN )l 	  signal(SIGINT,dialint); #endif /* OS-9 */e #endif /* MAC */     }l  9     /* Hang up the modem (in case it wasn't "on hook") */U+     /* But only if SET DIAL HANGUP ON... */i       if (dialhup() < 0) {* 	debug(F100,"ckdial dialhup failed","",0); #ifndef MINIDIAL< 	if (mymdmtyp == n_TELEBIT)	/* Telebit might need a BREAK */ 	  ttsndb();			/*  first. */ #endif /* MINIDIAL */N% 	if (dialhng) {			/* If it failed, */S4 	    ttclos(0);			/* close and reopen the device. */0 	    if (ttopen(ttname,&local,mymdmtyp,0) < 0) {8 		printf("Sorry, Can't hang up communication device\n");- 		printf("Try 'set line %s' again\n",ttname);  		dialsta = DIA_HANG;r #ifdef DYNAMIC$ 		if (lbuf) free(lbuf); lbuf = NULL;$ 		if (rbuf) free(rbuf); rbuf = NULL;$ 		if (fbuf) free(fbuf); fbuf = NULL; #endif /* DYNAMIC */ 		dreset();o 		return(0); 	    } 	}     }o #ifndef MINIDIAL?     if (augmdmtyp == n_ROLM)		/* Don't start talking to Rolm */ &       msleep(500);			/* too soon... */ #endif /* MINIDIAL */d    /* Put modem in command mode. */       if ( #ifdef MINIDIALd 	1 #else/ 	augmdmtyp != n_ATTUPC #endif /* MINIDIAL */; 	) {1 	fail_code = F_MINIT;		/* Default failure code */*1 	dial_what = DW_INIT;		/* What I'm Doing Now   */	, 	if (dialdpy) {			/* If showing progress, *// 	    p = ck_time();		/* display timestamp.   */"0 	    if (*p) printf(" Initializing: %s...\n",p); 	}     }e;     switch (augmdmtyp) {		/* Send wakeup string, if any. */,   #ifndef MINIDIAL #ifdef ATT7300       case n_ATTUPC: { /*I   For ATT7300/Unix PC's with their special internal modem.  Whole dialinguF   process is handled right here, an exception to the normal structure.J   Timeout and user interrupts are enabled during dialing.  attdial() is in   file ckutio.c.  - jrde */9         _PROTOTYP( int attdial, (char *, long, char *) );t1 	fail_code = F_MODEM;		/* Default failure code */  	dial_what = DW_DIAL; + 	if (dialdpy) {			/* If showing progress */ , 	    p = ck_time();		/* get current time; */+ 	    if (*p) printf(" Dialing: %s...\n",p);A 	}) 	alarm(waitct);			/* do alarm properly */s> 	if (attdial(ttname,speed,telnbr)) { /* dial internal modem */) 	    dreset();			/* reset alarms, etc. */e! 	    printf(" Call failed.\r\n"); . 	    dialhup();	        	/* Hangup the call */ #ifdef DYNAMIC' 	    if (lbuf) free(lbuf); lbuf = NULL;e' 	    if (rbuf) free(rbuf); rbuf = NULL;E' 	    if (fbuf) free(fbuf); fbuf = NULL;e #endif /* DYNAMIC */ 	    dialsta = DIA_UERR;& 	    return(0);			/* return failure */ 	}% 	dreset();			/* reset alarms, etc. */l9 	ttpkt(speed,FLO_DIAX,parity);	/* cancel dialing ioctl */  	if (!quiet && !backgrd) { 	    if (dialdpy) printf("\n");;& 	    printf(" Call complete.\07\r\n"); 	} 	dialsta = DIA_OK; #ifdef DYNAMIC# 	if (lbuf) free(lbuf); lbuf = NULL; # 	if (rbuf) free(rbuf); rbuf = NULL;F# 	if (fbuf) free(fbuf); fbuf = NULL;m #endif /* DYNAMIC */A 	return(1);	 /* no conversation with modem to complete dialing */a     }r #endif /* ATT7300 */ #endif /* MINIDIAL */r   /*I   For Hayes modem command language, figure out if modem is giving verbose    or digit result codes. */       case n_HAYES:        case n_HAYESNV:) #ifndef MINIDIAL       case n_HST:l 	if (augmdmtyp == n_HST) 	  m = 255;e 	elsei #endif /* MINIDIAL */a' 	  m = 60;			/* Maximum value for S7 */0 	  1' 	if (dialini)			/* Get wakeup string */" 	  ws = dialini; 	else            ws = #ifndef MINIDIAL* 	    (augmdmtyp == n_HST) ? HST.wake_str : #endif /* MINIDIAL */  	      HAYES.wake_str;  & 	for (tries = 4; tries > 0; tries--) {# 	    ttslow(ws,pmdminf->wake_rate);l 	    mdmstat = getok(4,1); 	    if (mdmstat > 0) break; 	    if (dialdpy && tries > 1)9 	      printf(" No response from modem, retrying%s...\n",n$ 		     (tries < 4) ? " again" : "");0 	    /* sleep(1); */		/* Wait before retrying */ 	}2 	debug(F101,"ckdial wake_str mdmstat","",mdmstat);  + 	if (mdmstat < 1) { 		/* Initialized OK? */l/ 	    return(dialfail(F_MINIT));	/* No, fail. */e 	} else {			/* Yes. */ 	    char hbuf[16];; /*I   Now tell the modem about our dial timeout.  For Hayes 1200, the maximummL   is 60 seconds.  For Hayes 2400 (the manual says) it is 30 seconds, but I'mE   not sure I believe this (I don't have one handy to see for myself).rL   If you give the modem a value larger than its maximum, it sets the timeoutL   to its maximum.  The manual does not say what happens when the value is 0,H   but experimentation shows that it allows the modem to wait forever, in6   which case Kermit will time out at the desired time. */ /*   Note by Kai Uwe Rommel:fK   This is not acceptable for general use of the hayes modem type with other I   compatible modems. Most other modems allow a range of 1..255 while 0 iscH   invalid on several modems. Let it be the user's responsibility to makeH   sure a valid value is used. Higher values are desirable for users withM   rotary dialing and with high speed modems, where protocol negotiation takese   quite a long time. */ #ifdef COMMENT4 	    if (mdmwait > m)		/* If larger than maximum, */, 	      mdmwait = 0;		/* make it infinite. */ #elseg6 	    if (mdmwait > 255)		/* If larger than maximum, */- 	      mdmwait = 255;		/* make it maximum. */  #endif /* COMMENT */G 	    sprintf(hbuf,"ATS7=%d%c",mdmwait,13); /* S7 = Carrier wait time */i3 	    ttslow(hbuf,pmdminf->wake_rate); /* Set it. */ 8 	    mdmstat = getok(4,1);	/* Get response from modem */0 	    debug(F101,"ckdial S7 mdmstat","",mdmstat);. 	    break;			/* Errors here are not fatal. */ 	}   #ifndef MINIDIAL /*L   Telebit modems fall into two basic groups: old and new.  The functions andN   command sets are different between the two groups, and also vary by specificK   models within each group, and even by firmware ROM revision number.  Read	   ckcker.bwr for details.   $   Commands used by C-Kermit include:  $     Old       New            MeaningE     -------   --------       ----------------------------------------u1     Q0        Q0             Enable result codes."3     X1        X1             Extended result codes.tL     X1        X1             Extended result codes + BUSY, NO DIALTONE, etc.2     I         I              Model number inquiry.B     I3        I3             Additional model information inquiry.@     S12=50    S12=50         Escape sequence guard time (1 sec).5     S2=43     S2=43          Escape character is '+'. E     S7=xx     S7=xx          DIAL TIMEOUT, calculated or SET by user.,F     S48=0     S48=0          7-bit data (Kermit's PARITY is not NONE).B     S48=1     S48=1          8-bit data (Kermit's PARITY is NONE).F     S50=0     S50=0          Automatic speed & protocol determination./     S50=3     S50=3          2400/1200/300 bps.7-     S50=6     S50=6          V.32 (9600 bps). &     S50=255   S50=255        PEP mode.;     S110=1    S190=1 S191=7  Allow compression in PEP mode. H     S51=?     S51=?          DTE interface speed (left alone by Kermit).8     S54=3     S61=0 S63=0    Pass BREAK signal (always).N     S58=2     S58=2          RTS/CTS flow control if Kermit's FLOW is RTS/CTS.K     S58=?     S58=?          S58 unchanged if Kermit's FLOW is not RTS/CTS.fH     S68=255   S68=255        Use flow control specified by S58 (always).C     S95=0     S180=0         MNP disabled (SET DIAL MNP-ENABLE OFF))L     S95=2     S180=3         MNP, fallback to direct (also as V.42 fallback)@     S97=1     S180=2         Enable V.42 (LAPM) error correctionB     S98=3                    Enable compression in both directions7     S106=1                   V.42bis compression enable   @ For Kermit Spoof (same commands for all models that support it):  /     S111=0                   No Kermit spoofing 2     S111=10                  Kermit with no parity3     S111=11                  Kermit with odd parityo4     S111=12                  Kermit with even parity4     S111=13                  Kermit with mark parity5     S111=14                  Kermit with space parity H     S112=??                  Kermit's start-of-packet character (stchr). */'     case n_TELEBIT:			/* Telebits... */m     case n_TBPEP:f     case n_TB3:      case n_TB4:\     case n_TBS:C     case n_TBNV:     case n_TBPNV:=     case n_TB3NV:      case n_TB4NV:D     case n_TBSNV: {e0 	int S111;			/* Telebit Kermit spoof register */7 	char tbcmdbuf[64];		/* Telebit modem command buffer */ 7 	char *mnpstr = "";		/* Pointer to MNP-enable string */c: 	char *dprstr = "";		/* Pointer to dial protocol string */ /*L   If user defined a DIAL INIT-STRING, send that now, otherwise send built-inH   Telebit string.  Try up to 4 times to get OK or 0 response from modem.G   NOTE: The default init string *must* be independent of Telebit model.e */+ 	ws = dialini ? dialini : TELEBIT.wake_str; / 	debug(F110,"ckdial telebit init string",ws,0);b& 	for (tries = 4; tries > 0; tries--) {- 	    ttsndb();			/* Begin by sending BREAK */L< 	    ttslow(ws,pmdminf->wake_rate); /* Send wakeup string */5 	    mdmstat = getok(5,0);	/* Get modem's response */t4 	    if (mdmstat) break;		/* If response OK, done */ 	    if (dialdpy && tries > 1)9 	      printf(" No response from modem, retrying%s...\n",t$ 		     (tries < 4) ? " again" : "");4 	    msleep(300);		/* Otherwise, sleep 1/3 second */ 	    dialhup();			/* Hang up */s7 	    ttflui();			/* Flush input buffer and try again */m 	}5 	if (mdmstat < 1)		/* If we didn't get a response, */m) 	  return(dialfail(F_MINIT));	/* fail. */h  : 	if (!dialini) {			/* If using built-in init strings... */ /*L   Try to get the model number.  It should be in the getok() response buffer,K   rbuf[], because the Telebit init string asks for it with the "I" command.oN   If the model number is 965, we have to make another query to narrow it down. */9 	    if (didweget(rbuf,"962") ||	/* Check model number */  		didweget(rbuf,"961") ||  		didweget(rbuf,"963")) { & 		tbmodel = TB_BLAZ;	/* Trailblazer */' 	    } else if (didweget(rbuf,"972")) {   		tbmodel = TB_2500;	/* T2500 */' 	    } else if (didweget(rbuf,"968")) {r  		tbmodel = TB_1000;	/* T1000 */' 	    } else if (didweget(rbuf,"966") ||T  		       didweget(rbuf,"967") ||  		       didweget(rbuf,"964")) {+ 		tbmodel = TB_PLUS;	/* Trailblazer-Plus */ ' 	    } else if (didweget(rbuf,"969")) {/" 		tbmodel = TB_QBLA;	/* Qblazer */' 	    } else if (didweget(rbuf,"970")) {D' 		tbmodel = TB_QBLA;	/* Qblazer Plus */(= 	    } else if (didweget(rbuf,"965")) { /* Most new models */i! 		tbati3(965);		/* Go find out */f< 	    } else if (didweget(rbuf,"971")) { /* T1500 or T2500 */! 		tbati3(971);		/* Go find out */ ? 	    } else if (didweget(rbuf,"123") || didweget(rbuf,"960")) {;/ 		tbmodel = TB_UNK;	/* Telebit in Hayes mode */) 	    }: 	    debug(F111,"Telebit model",tb_name[tbmodel],tbmodel); 	    if (dialdpy) 6 	      printf("Telebit model: %s\n",tb_name[tbmodel]); 	    ttflui(); /*K   Dial timeout.  S7 is set to the DIAL TIMEOUT value, or else to 255 if the L   dial timeout is greater than 255, which is the maximum value for Telebits.8   S7 can't be set to 0 on Telebits -- it gives an error. */6 	    if (mdmwait > 255)		/* If dial timeout too big */8 	      mdmwait = 255;		/* make it as big as possible. */ /*K   Flow control.  If C-Kermit's FLOW-CONTROL is RTS/CTS, then we set this onfI   the modem too.  Unfortunately, many versions of UNIX only allow RTS/CTSoH   to be set outside of Kermit (e.g. by selecting a special device name).L   In that case, Kermit doesn't know that it should set RTS/CTS on the modem,E   in which case the user can add the appropriate Telebit command withL   SET DIAL DIAL-COMMAND. */; 	    if (flow == FLO_RTSC) {	/* RTS/CTS active in Kermit */d 		sprintf(tbcmdbuf, , 			"ATS7=%d S48=%d S50=0 S58=2 S68=255\015", 			mdmwait, parity ? 0 : 1); 	    } else_> 	      sprintf(tbcmdbuf,		/* Otherwise, don't touch modem's */> 		      "ATS7=%d S48=%d S50=0 S68=255\015", /* flow control */3 		      mdmwait, parity ? 0 : 1);		  /* setting. */( 	    s = tbcmdbuf;2 	    debug(F110,"ckdial Telebit init step 2",s,0);* 	    for (tries = 4; tries > 0; tries--) { 		ttslow(s,pmdminf->wake_rate);A 		mdmstat = getok(5,1);i 		if (mdmstat) break;u 		if (dialdpy && tries > 1)b6 		  printf(" No response from modem, retrying%s...\n",! 			 (tries < 4) ? " again" : "");  		msleep(500); 		ttflui();o 	    } 	    if (mdmstat < 1)i! 	      return(dialfail(F_MINIT));l /*0   Model-dependent items, but constant per model. */ 	    switch(tbmodel) { 	      case TB_BLAZ:- 	      case TB_PLUS: 		/* TrailBlazer-Plus */ ! 	      case TB_1000:		/* T1000 */e! 	      case TB_2000:		/* T2000 */ ! 	      case TB_2500:		/* T2500 */t #ifdef COMMENTC /* Code from edit 183 told modem to follow RS-232 wrt CD and DTR */ * 		/* DTR, CD, follow RS-232, pass BREAK */. 		sprintf(tbcmdbuf,"ATS52=1 S53=4 S54=3\015"); #else=K /* But everybody agreed we should not touch modem's CD and DTR settings. */  		/* Just pass BREAK */ " 		sprintf(tbcmdbuf,"ATS54=3\015"); #endif /* COMMENT */ 		break;! 	      case TB_1600:		/* T1600 */t! 	      case TB_3000:		/* T3000 */_' 	      case TB_WBLA:		/* WorldBlazer */r# 	      case TB_QBLA:		/* Qblazer */N #ifdef COMMENT /* Code from edit 183 */4 		/* Follow RS-232, No CONNECT suffix, pass BREAK */8 		sprintf(tbcmdbuf,"AT&C1&D2&Q0 S59=0 S61=0 S63=0\015"); #elsefG /* Everybody agrees we should not touch modem's CD and DTR settings. */bG /* Also no more &Q0, no more S59=0 (doesn't matter, so don't touch). */Y= /* So this section now deals only with treatment of BREAK. */ D /* Here we also raise the result code from X1 to X2, which allows */O /* the T1600, T3000, and WB to supply NO DIALTONE, BUSY, RRING, and DIALING. */d2 /* X2 means something else on the other models. */6 		/* Transmit BREAK in sequence, raise result code. */+ 		sprintf(tbcmdbuf,"ATX2 S61=0 S63=0\015");  #endif /* COMMENT */ 		break;* 	      default:			/* Others, do nothing */ 		tbcmdbuf[0] = NUL; 		break; 	    } 	    s = tbcmdbuf; 	    if (*s) {/ 		debug(F110,"ckdial Telebit init step 3",s,0); ' 		for (tries = 4; tries > 0; tries--) { # 		    ttslow(s,pmdminf->wake_rate);m 		    mdmstat = getok(5,1);; 		    if (mdmstat) break;I 		    if (dialdpy && tries > 1)|: 		      printf(" No response from modem, retrying%s...\n",% 			     (tries < 4) ? " again" : "");  		    msleep(500); 		    ttflui();- 		}f 		if (mdmstat < 1) 		  dialfail(F_MINIT);B 	    } else debug(F100,"ckdial Telebit init step 3 skipped","",0);  # /* Error correction, MNP or V.42 */m  6 	    if (augmdmtyp & DIAL_V42) { /* User wants V.42 */9 		switch (tbmodel) {	/* which implies fallback to MNP. */g/ 		  case TB_PLUS:		/* BC7.00 and up firmware */ 5 		  case TB_2000:		/* now really the same as TB+ ? */o3 		  case TB_2500:		/* LAPM+compress->MNP->direct */ 0 		    mnpstr = "S50=0 S95=2 S97=1 S98=3 S106=1"; 		    break; 		  case TB_1600:b 		  case TB_3000:  		  case TB_WBLA:s 		  case TB_QBLA:b #ifdef COMMENTA 		    mnpstr = "S180=2 S181=0"; /* V.42, fallback = lock speed */i #elsesK /* Better not to mess with S181, let it be used however user has it set. */ F /* S180=2 allows fallback to MNP, S180=1 disallows fallback to MNP. */# 		    mnpstr = "S180=2";	/* V.42 */  #endif /* COMMENT */ 		    break; 		  default: 		    if (dialdpy)= 		      printf("V.42 not supported by this Telebit model\n");t 		}t4 	    } else {			/* Handle DIAL MNP-ENABLE setting */ 		switch (tbmodel) {$ 		  case TB_BLAZ:		/* TrailBlazer */) 		  case TB_PLUS:		/* TrailBlazer-Plus */t 		  case TB_1000:		/* T1000 */ 		  case TB_2000:		/* T2000 */ 		  case TB_2500:		/* T2500 */9 		    mnpstr = dialmnp ? "S95=2" : "S95=0"; /* ON, OFF */k 		    break; 		  case TB_1600:		/* T1600 */ 		  case TB_3000:		/* T3000 */$ 		  case TB_WBLA:		/* WorldBlazer */  		  case TB_QBLA:		/* Qblazer */; 		    mnpstr = dialmnp ? "S180=3" : "S180=0"; /* ON, OFF */f. 		    /* (Leave S181 fallback method alone) */ 		    break; 		  default: 		    mnpstr = ""; 		}a 	    }   /* Dialing protocol */  : 	    dprstr = "";	/* Initialize dialing protocol string */& 	    p = "";		/* and message string */ 	    switch (augmdmtyp) {i< 	      case n_TELEBIT:		/* Start at highest and work down */               case n_TBNV:        		p = "standard";6 		switch (tbmodel) {	/* First group starts with PEP */$ 		  case TB_BLAZ:		/* TrailBlazer */) 		  case TB_PLUS:		/* TrailBlazer-Plus */* 		  case TB_1000:		/* T1000 */ 		  case TB_2000:		/* T2000 */ 		  case TB_2500:		/* T2500 */> 		    dprstr = "S50=0 S110=1"; /* PEP, compression allowed. */ 		    break;, 		  case TB_WBLA:		/* WorldBlazer has PEP */0 		    dprstr = "S50=0 S190=1 S191=7"; /* PEP, */- 		    break;			    /* compression allowed. */// 		  case TB_1600:		/* T1600 doesn't have PEP */ & 		  case TB_3000:		/* T3000 doesn't */' 		  case TB_QBLA:		/* Qblazer doesn't*/o 		  default:. 		    dprstr = "S50=0";	/* No PEP available */ 		    break; 		}n 		break;  1 	      case n_TBS:		/* Telebit up to 2400 Baud */	- 	      case n_TBSNV:		/* i.e. "Slow mode". */f@ 		p = "300/1200/2400 Baud"; /* Leave S90 alone assuming it is */8 		dprstr = "S50=3";	  /* already set for V.22 vs 212A */ 		break;& 	      case n_TB3:		/* Telebit V.32 */ 	      case n_TB3NV:1 		if (tbmodel == TB_3000 || tbmodel == TB_1600 || 1 		    tbmodel == TB_2500 || tbmodel == TB_WBLA) {e 		    p = "V.32";d< 		    /* Note: we don't touch S51 (interface speed) here. */= 		    /* We're already talking to the modem, and the modem */;= 		    /* SHOULD be able to make a V.32 call no matter what */a; 		    /* its interface speed is.  (In practice, however, */ % 		    /* that is not always true.) */= 		    dprstr = "S50=6";i 		} else if (dialdpy) : 		  printf("V.32 not supported by this Telebit model.\n"); 		break;. 	      case n_TBPEP:		/* Force PEP Protocol */               case n_TBPNV:3? 		if (tbmodel != TB_1600 && /* Models that don't support PEP */r 		    tbmodel != TB_3000 &&l 		    tbmodel != TB_QBLA) {l 		    p = "PEP";/ 		    if (tbmodel == TB_WBLA) /* WorldBlazer */ ) 		      dprstr = "S50=255 S190=1 S191=7"; " 		    else if (tbmodel != TB_1000): 		      dprstr = "S50=255 S110=1"; /* TrailBlazer, etc. */: 		    else dprstr = "S50=255"; /* T1000, no compression */ 		} else if (dialdpy)L9 		  printf("PEP not supported by this Telebit model.\n");c 		break; 	    }   /* Kermit Spoof */   	    if (dialksp) {n 		p = "Kermit Spoof";a6 		switch (parity) {	/* S111 value depends on parity */ 		  case 'e': S111 = 12; break;t 		  case 'm': S111 = 13; break;/ 		  case 'o': S111 = 11; break;i 		  case 's': S111 = 14; break;d 		  case 0:  		  default:  S111 = 10; break;f   		}C 		if (tbmodel != TB_QBLA);3 		  sprintf(tbcmdbuf,"AT%s %s S111=%d S112=%d\015",L! 			    mnpstr,dprstr,S111,stchr); , 		else {			/* Qblazer has no Kermit spoof */5 		    sprintf(tbcmdbuf,"AT%s %s\015", mnpstr,dprstr);  		    p = "No Kermit Spoof"; 		    if (dialdpy): 		      printf("Kermit Spoof not supported by Qblazer\n"); 		}!& 	    } else {			/* KERMIT-SPOOF OFF */ 		p = "No Kermit Spoof";$ 		sprintf(tbcmdbuf,"AT%s %s %s\015", 			mnpstr, dprstr,) 			(tbmodel == TB_QBLA) ? "" : "S111=0");  	    } 	    s = tbcmdbuf;1 	    debug(F111,"ckdial Telebit config",p,speed);/2 	    debug(F110,"ckdial Telebit init step 4",s,0); 	    if (*s) {' 		for (tries = 4; tries > 0; tries--) {/# 		    ttslow(s,pmdminf->wake_rate);  		    mdmstat = getok(5,1);  		    if (mdmstat) break;n 		    if (dialdpy && tries > 1)e: 		      printf(" No response from modem, retrying%s...\n",% 			     (tries < 4) ? " again" : "");g 		    msleep(500); 		    ttflui();i 		}d7 		debug(F101,"ckdial telebit init mdmstat","",mdmstat);* 		if (mdmstat < 1) 		  dialfail(F_MINIT); 	    } 	}? 	/* Done with Telebit protocols, remove bits from modem type */m 	/* Except nonverbal bit */r5 	augmdmtyp &= ~(DIAL_PEP|DIAL_V32|DIAL_V42|DIAL_SLO);f5 	debug(F101,"ckdial Telebit augmdmtyp","",augmdmtyp);d 	break;e     }l  ;     case n_MICROCOM:			/* Interdigit waits for tone dial */  #ifdef COMMENT 	  { 	    jmp_buf savejmp;o 	    alarm(0);A 	    savalrm = signal(SIGALRM,dialtime); /* Set alarm handler. */ : 	    xcpy((char *)savejmp, (char *)sjbuf, sizeof savejmp); 	    if (setjmp(sjbuf)) {,% 	    	/* try the autobaud sequence */*7 		xcpy((char *)sjbuf, (char *)savejmp, sizeof savejmp);N 		alarm(5); - 	        ttslow("44445", MICROCOM.wake_rate);* 		waitfor(MICROCOM.wake_str);r
 	    } else {  		alarm(2);0- 		ws = dialini ? dialini : MICROCOM.wake_str;0! 		ttslow(ws, MICROCOM.wake_rate);, 	    	waitfor(ws); /*.   Kermit spoof for Microcom modems.  Untested.J   This is reportedly the way to do it for QX/3296c, QX/4232hs, QX/4232bis,7   and QX/9624c.  The effect on other models is unknown.a */< 		ws = dialksp ? "APM1\015" : "APM0\015";	/* Kermit spoof */! 		ttslow(ws, MICROCOM.wake_rate);  	    	waitfor(ws); 		alarm(0); 3 		signal(SIGALRM,savalrm); /* Set alarm handler. */o7 		xcpy((char *)sjbuf, (char *)savejmp, sizeof savejmp);a 	    } 	} #else , 	ws = dialini ? dialini : MICROCOM.wake_str;+ 	debug(F110,"ckdial microcom ttslow",ws,0);i  	ttslow(ws, MICROCOM.wake_rate);
 	alarm(3);> 	debug(F110,"ckdial microcom waitfor",MICROCOM.wake_prompt,0); 	waitfor(MICROCOM.wake_prompt);o1 	debug(F110,"ckdial microcom waitfor done","",0);o
 	alarm(0); /*.   Kermit spoof for Microcom modems.  Untested.J   This is reportedly the way to do it for QX/3296c, QX/4232hs, QX/4232bis,7   and QX/9624c.  The effect on other models is unknown.	 */; 	ws = dialksp ? "APM1\015" : "APM0\015";	/* Kermit spoof */   	ttslow(ws, MICROCOM.wake_rate);
 	alarm(3);
 	waitfor(ws);d
 	alarm(0); #endif /* COMMENT */ 	break;*  9     case n_ATTDTDM:		/* DTDM requires BREAK to wake up */  	ttsndb();		/* Send BREAK */, 	break;			/* ttsndb() defined in ckutio.c */   #endif /* MINIDIAL */;  2     default:			/* Place modem into command mode */, 	ws = dialini ? dialini : pmdminf->wake_str;! 	if (ws && (int)strlen(ws) > 0) { G 	    debug(F111,"ckdial default, wake string", ws, pmdminf->wake_rate);a$ 	    ttslow(ws, pmdminf->wake_rate);. 	} else debug(F100,"ckdial no wake_str","",0);E 	if (pmdminf->wake_prompt && (int)strlen(pmdminf->wake_prompt) > 0) {r: 	    debug(F110,"ckdial default, waiting for wake_prompt", 		  pmdminf->wake_prompt,0); 	    alarm(10);-# 	    waitfor(pmdminf->wake_prompt); 1 	} else debug(F100,"ckdial no wake_prompt","",0);  	break;E     } %     alarm(0);				/* Turn off alarm */ .     debug(F100,"ckdial got wake prompt","",0);,     msleep(500);			/* Allow settling time */   #ifndef MINIDIAL  5 /* Enable/disable MNP (Telebit already done above) */.       switch (augmdmtyp) {       case n_HST:g. 	if (dialmnp)			/* EC & compression enabled */- 	  ttslow("AT&M4&K1\015",pmdminf->wake_rate); ( 	else				/* EC & compression disabled */- 	  ttslow("AT&M0&K0\015",pmdminf->wake_rate);t! 	getok(5,1);			/* Get response */  	break;         /* Add others here ... */         default: 	break;5     }  #endif /* MINIDIAL */c  < /* Put modem into dialing mode, if the modem requires it. */  6     if (pmdminf->dmode_str && *(pmdminf->dmode_str)) {0 	ttslow(pmdminf->dmode_str, pmdminf->dial_rate);$ 	savalrm = signal(SIGALRM,dialtime); 	alarm(10);E' 	/* Wait for prompt, if any expected */E9 	if (pmdminf->dmode_prompt && *(pmdminf->dmode_prompt)) {=$ 	    waitfor(pmdminf->dmode_prompt); 	    msleep(300);= 	}4 	alarm(0);		 /* Turn off alarm on dialing prompts */- 	signal(SIGALRM,savalrm); /* Restore alarm */i7 	ttflui();		 /* Clear out stuff from waking modem up */      }e  6 /* Dial the number.  First form the dialing string. */   #ifdef DYNAMIC:     if (!lbuf) {			/* If, for some reason, this is NULL */6 	if (!(lbuf = malloc(LBUFL+1))) { /* allocate it... */ 	    dialsta = DIA_IE; 	    return(0);A 	}     }o #endif /* DYNAMIC */A     sprintf(lbuf, dialcmd ? dialcmd : pmdminf->dial_str, telnbr); $     if ((int)strlen(lbuf) > LBUFL) {3 	printf("DIAL command + phone number too long!\n");e
 	dreset(); #ifdef DYNAMIC# 	if (lbuf) free(lbuf); lbuf = NULL;o# 	if (rbuf) free(rbuf); rbuf = NULL;K# 	if (fbuf) free(fbuf); fbuf = NULL;  #endif /* DYNAMIC */A 	return(1);	 /* No conversation with modem to complete dialing */y     }1!     debug(F110,"dialing",lbuf,0);mB     ttslow(lbuf,pmdminf->dial_rate);	/* Send the dialing string */  @     fail_code = F_MODEM;		/* New default failure code changes */3     dial_what = DW_DIAL;		/* and our state, too. */ .     if (dialdpy) {			/* If showing progress */) 	p = ck_time();			/* get current time; */ ' 	if (*p) printf(" Dialing: %s...\n",p);      }T6     x = alarm(waitct);			/* This much time allowed. */(     debug(F101,"ckdial old alarm","",x);*     debug(F101,"ckdial waitct","",waitct);   #ifndef MINIDIAL     switch (augmdmtyp) {6       case n_RACAL:			/* Acknowledge dialing string */
 	sleep(3);
 	ttflui(); 	ttoc('\015'); 	break;I       case n_VENTEL:9 	waitfor("\012\012");		/* Ignore the first two strings */t 	break;o       default: 	break;      }  #endif /* MINIDIAL */    /* Check for connection */  &     mdmstat = 0;			/* No status yet */B     strcpy(lbuf,"No Connection");	/* Default reason for failure */A     debug(F101,"dial awaiting response, augmdmtyp","",augmdmtyp);      while (mdmstat == 0) { 	switch (augmdmtyp) {r 	  default: < 	    for (n = -1; n < LBUFL-1; ) { /* Accumulate response */2 		c2 = ddinc(0);		/* Read a character, blocking */7 		if (c2 == 0 || c2 == -1) /* Ignore NULs and errors */t1 		  continue;		/* (Timeout will handle errors) */ & 		else			/* Real character, keep it */ 		  lbuf[++n] = c2 & 0177;' 		dialoc(lbuf[n]);	/* Maybe echo it  */HE                 if (augmdmtyp == n_CCITT) { /* V.25 bis dialing... */} /*J   This assumes that V.25bis indications are all at least 3 characters long,   and are terminated by either CRLF or LFCR. */ 		    if (n < 3) continue;6 		    if ((lbuf[n] == CR) && (lbuf[n-1] == LF)) break;6 		    if ((lbuf[n] == LF) && (lbuf[n-1] == CR)) break; 		}  #ifndef MINIDIAL& 		  else if (augmdmtyp == n_DIGITEL) {3 		    if (((lbuf[n] == CR) && (lbuf[n-1] == LF)) ||n* 			((lbuf[n] == LF) && (lbuf[n-1] == CR))) 		      break;
 		    else 		      continue;r 		}9 #endif /* MINIDIAL */u/ 		  else {		/* All others, break on CR or LF */ 2 		    if ( lbuf[n] == CR || lbuf[n] == LF ) break; 		}  	    }; 	    lbuf[++n] = '\0';		/* Terminate response from modem */o0 	    debug(F111,"ckdial modem response",lbuf,n);7 	    if (n) {			/* If one or more characters present */ > 		switch (augmdmtyp) {	/* check for modem response message. */ #ifndef MINIDIAL 		  case n_ATTMODEM:3 		    /* Careful - "Connected" / "Not Connected" */ # 		    if (didweget(lbuf,"Busy")) {   			mdmstat = FAILED; 			dialsta = DIA_BUSY;2 		    } else if (didweget(lbuf,"Not connected") ||, 			       didweget(lbuf,"Not Connected")) {  			mdmstat = FAILED; 			dialsta = DIA_NOCA;1 		    } else if (didweget(lbuf,"No dial tone") || + 			       didweget(lbuf,"No Dial Tone")) { t 			mdmstat = FAILED; 			dialsta = DIA_NODT;. 		    } else if (didweget(lbuf,"No answer") ||' 			       didweget(lbuf,"No Answer")) {  			mdmstat = FAILED; 			dialsta = DIA_NOAN;- 		    } else if (didweget(lbuf,"Answered") ||*' 			       didweget(lbuf,"Connected")) {T 			mdmstat = CONNECTED;2 			dialsta = DIA_OK; 		    }r 		    break;   		  case n_ATTISN:& 		    if (didweget(lbuf,"ANSWERED")) { 			mdmstat = CONNECTED;v 			dialsta = DIA_OK;* 		    } else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED; 			dialsta = DIA_BUSY;0 		    } else if (didweget(lbuf,"DISCONNECT")) {  			mdmstat = FAILED; 			dialsta = DIA_DISC;/ 		    } else if (didweget(lbuf,"NO ANSWER")) { o 			mdmstat = FAILED; 			dialsta = DIA_NOAN;2 		    } else if (didweget(lbuf,"WRONG ADDRESS")) { 			mdmstat = FAILED; 			dialsta = DIA_NOAC; 		    }u 		    break;   		  case n_ATTDTDM:i& 		    if (didweget(lbuf,"ANSWERED")) { 			mdmstat = CONNECTED; * 		    } else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED; 			dialsta = DIA_BUSY;3 		    } else if (didweget(lbuf,"CHECK OPTIONS")) { S 			mdmstat = FAILED; 			dialsta = DIA_ERR; 2 		    } else if (didweget(lbuf,"DISCONNECTED")) {  			mdmstat = FAILED; 			dialsta = DIA_DISC;+ 		    } else if (didweget(lbuf,"DENIED")) {  			mdmstat = FAILED; 			dialsta = DIA_NOAC; 		    }s #ifdef DEBUG #ifdef ATT6300- 		    else if (deblog && didweget(lbuf,"~~"))r 		      mdmstat = CONNECTED; #endif /* ATT6300 */ #endif /* DEBUG */ 		    break; #endif /* MINIDIAL */e  ' 		  case n_CCITT:			/* CCITT V.25bis */n #ifndef MINIDIAL- 		  case n_DIGITEL:		/* or Digitel variant */  #endif /* MINIDIAL */eA 		    if (didweget(lbuf,"VAL")) {	/* Dial command confirmation */r #ifndef MINIDIAL 			if (augmdmtyp == n_CCITT) #endif /* MINIDIAL */o+ 			  continue;		/* Go back and read more */  #ifndef MINIDIALC /* Digitel doesn't give an explicit connect confirmation message */0	 			else { 
 			    int n;	$ 			    for (n = -1; n < LBUFL-1; ) {% 				lbuf[++n] = c2 = ddinc(0) & 0177;m 				dialoc(lbuf[n]);1 				if (((lbuf[n] == CR) && (lbuf[n-1] == LF)) ||o/ 				    ((lbuf[n] == LF) && (lbuf[n-1] == CR)))T 				  break; 			    }8 			    mdmstat = CONNECTED; /* Assume we're connected */+ 			    if (dialdpy && carrier != CAR_OFF) {B" 				sleep(1); 	/* Wait a second */1 				n = ttgmdm();	/* Try to read modem signals */s( 				if ((n > -1) && ((n & BM_DCD) == 0))& 				  printf("Warning: No Carrier\n"); 			    }	 		      }  #endif /* MINIDIAL */*8 		    } else if (didweget(lbuf,"CNX")) { /* Connected */ 			mdmstat = CONNECTED;E7                     } else if (didweget(lbuf, "INV")) { ( 			mdmstat = FAILED;	/* Command error */ 			dialsta = DIA_ERR;o 			strcpy(lbuf,"INV");; 		    } else if (didweget(lbuf,"CFI")) { /* Call Failure */  #ifdef COMMENT /*B   V.25 bis says that the failure reason comes on the same line, so1   we don't need to read any more characters here.  */4 			for (n = 0; n < LBUFL-1; n++) { /* Read reason */( 			    lbuf[n] = c2 = (ddinc(0) & 0177);C                             if (c2 == LF) /* Modem answers LF CR */i 			      continue; 			    dialoc(lbuf[n]);	1 			    if (lbuf[n] == CR || lbuf[n] == LF) break;/ 			} #endif /* COMMENT */9 			if (didweget(lbuf,"AB")) { /* Interpret reason code */;$ 			    strcpy(lbuf,"AB: Timed out"); 			    dialsta = DIA_TIMO;$ 			} else if (didweget(lbuf,"CB")) {) 			    strcpy(lbuf,"CB: Local DCE Busy");  			    dialsta = DIA_NRDY;$ 			} else if (didweget(lbuf,"ET")) { 			    strcpy(lbuf,"ET: Busy");  			    dialsta = DIA_BUSY;% 			} else if (didweget(lbuf, "NS")) {e, 			    strcpy(lbuf,"NS: Number not stored"); 			    dialsta = DIA_ERR;p$ 			} else if (didweget(lbuf,"NT")) {$ 			    strcpy(lbuf,"NT: No answer"); 			    dialsta = DIA_NOAN;$ 			} else if (didweget(lbuf,"RT")) {$ 			    strcpy(lbuf,"RT: Ring tone"); 			    dialsta = DIA_RING;$ 			} else if (didweget(lbuf,"PV")) {0 			    strcpy(lbuf,"PV: Parameter value error"); 			    dialsta = DIA_ERR; $ 			} else if (didweget(lbuf,"PS")) {1 			    strcpy(lbuf,"PS: Parameter syntax error");a 			    dialsta = DIA_ERR;s$ 			} else if (didweget(lbuf,"MS")) {/ 			    strcpy(lbuf,"MS: Message syntax error");  			    dialsta = DIA_ERR;_$ 			} else if (didweget(lbuf,"CU")) {* 			    strcpy(lbuf,"CU: Command unknown"); 			    dialsta = DIA_ERR;b$ 			} else if (didweget(lbuf,"FC")) {) 			    strcpy(lbuf,"FC: Forbidden call");e 			    dialsta = DIA_NOAC; 			} 			mdmstat = FAILED;< 		    } else if (didweget(lbuf,"INC")) { /* Incoming Call */% 			strcpy(lbuf,"INC: Incoming call");  			dialsta = DIA_RING; 			mdmstat = FAILED;; 		    } else if (didweget(lbuf,"DLC")) { /* Delayed Call */)$ 			strcpy(lbuf,"DLC: Delayed call"); 			dialsta = DIA_NOAN; 			mdmstat = FAILED;2 		    } else		/* Response was probably an echo. */ #ifndef MINIDIAL! 		      if (augmdmtyp == n_CCITT)  #endif /* MINIDIAL */0 			continue; #ifndef MINIDIAL6 		      else	/* Digitel: If no error, then connect. */ 			mdmstat = CONNECTED;  #endif /* MINIDIAL */6 		    break;   #ifndef MINIDIAL 		  case n_CERMETEK:# 		    if (didweget(lbuf,"\016A")) {a 			mdmstat = CONNECTED;/3 			ttslow("\016U 1\015",200); /* Make transparent*/, 		    }  		    break;  ; 		  case n_DF100:	     /* DF100 has short response codes */	" 		    if (strcmp(lbuf,"A") == 0) {& 			mdmstat = CONNECTED; /* Attached */ 			dialsta = DIA_OK;) 		    } else if (strcmp(lbuf,"N") == 0) {m 			mdmstat = FAILED;5 			dialsta = DIA_NOAN; /* No answer or no dialtone */t5 		    } else if (strcmp(lbuf,"E") == 0 ||	/* Error */:4 			       strcmp(lbuf,"R") == 0) { /* "Ready" (?) */ 			mdmstat = FAILED;) 			dialsta = DIA_ERR; /* Command error *// 		    }e" 		    /* otherwise fall thru... */   		  case n_DF200: & 		    if (didweget(lbuf,"Attached")) { 			mdmstat = CONNECTED;2 			dialsta = DIA_OK; 		    /*; 		     * The DF100 will respond with "Attached" even if DTRe: 		     * and/or carrier are not present.	Another reason to! 		     * (also) wait for carrier?r	 		     *//) 		    } else if (didweget(lbuf,"Busy")) {0 			mdmstat = FAILED; 			dialsta = DIA_BUSY;1 		    } else if (didweget(lbuf,"Disconnected")) {b 			mdmstat = FAILED; 			dialsta = DIA_DISC;* 		    } else if (didweget(lbuf,"Error")) { 			mdmstat = FAILED; 			dialsta = DIA_ERR;T. 		    } else if (didweget(lbuf,"No answer")) { 			mdmstat = FAILED; 			dialsta = DIA_NOAN;1 		    } else if (didweget(lbuf,"No dial tone")) {p 			mdmstat = FAILED; 			dialsta = DIA_NODT;, 		    } else if (didweget(lbuf,"Speed:)")) { 			mdmstat = FAILED; 			dialsta = DIA_ERR;e 		    }0 		    /*@ 		     * It appears that the "Speed:..." response comes after an> 		     * "Attached" response, so this is never seen.  HOWEVER,> 		     * it would be very handy to detect this and temporarily: 		     * reset the speed, since it's a nuisance otherwise.> 		     * If we wait for some more input from the modem, how do; 		     * we know if it's from the remote host or the modem?*; 		     * Carrier reportedly doesn't get set until after then? 		     * "Speed:..." response (if any) is sent.  Another reason $ 		     * to (also) wait for carrier.	 		     */  		    break;   		  case n_GDC:o# 		    if (didweget(lbuf,"ON LINE"))t 			mdmstat = CONNECTED;b+ 		    else if (didweget(lbuf,"NO CONNECT"))A 			mdmstat = FAILED; 		    break;   		  case n_USROBOT:r 		  case n_HST:  		  case n_TELEBIT:  #endif /* MINIDIAL */  		  case n_HAYES:  		    if (mdmspd && !network) {5 			s = lbuf;' 			while (*s != '\0' && *s != 'C') s++; ! 			cptr = (*s == 'C') ? s : NULL;  			conspd = 0L;d7 			if ((cptr != NULL) && !strncmp(cptr,"CONNECT ",8)) {o7 			    if ((int)strlen(cptr) < 9)   /* Just CONNECT, */ + 			      conspd = 300L;		 /* use 300 bps */w: 			    else if (isdigit(*(cptr+8))) /* not CONNECT FAST */6 			      conspd = atol(cptr + 8);   /* CONNECT nnnn */ 			    if (conspd != speed) {e 				if ((conspd / 10L) > 0) {b/ 				    if (ttsspd((int) (conspd / 10L)) < 0) {e3 				       printf(" Can't change speed to %ld\r\n",( 					       conspd); 				    } else { 					speed = conspd; 					mdmstat = CONNECTED;/ 					if ( !quiet && !backgrd )* 					  printf(" Speed changed to %ld\r\n", 						 conspd); 	 				    }e 				}o7 			    } /* Expanded to handle any conceivable speed */t 			} 		    }b #ifndef MINIDIAL" 		    if (mymdmtyp == n_TELEBIT) {, 			if (didweget(lbuf,"CONNECT FAST/KERM")) { 			    mdmstat = CONNECTED;t4 			    if (!quiet && !backgrd) printf("FAST/KERM ");
 			    break;s 			}  		    } #endif /* MINIDIAL */e%   		    if (didweget(lbuf,"RRING") ||1 			didweget(lbuf,"RINGING") || 			didweget(lbuf,"DIALING")) { 			mdmstat = 0;;, 		    } else if (didweget(lbuf,"CONNECT")) { 			mdmstat = CONNECTED;o/ 		    } else if (didweget(lbuf,"NO CARRIER")) {i 			mdmstat = FAILED; 			dialsta = DIA_NOCA;0 		    } else if (didweget(lbuf,"NO DIALTONE")) { 			mdmstat = FAILED; 			dialsta = DIA_NODT;1 		    } else if (didweget(lbuf,"NO DIAL TONE")) {t 			mdmstat = FAILED; 			dialsta = DIA_NODT;) 		    } else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED; 			dialsta = DIA_BUSY;. 		    } else if (didweget(lbuf,"NO ANSWER")) { 			mdmstat = FAILED; 			dialsta = DIA_NOAN;* 		    } else if (didweget(lbuf,"VOICE")) { 			mdmstat = FAILED; 			dialsta = DIA_VOIC;) 		    } else if (didweget(lbuf,"RING")) {n 			mdmstat = FAILED; 			dialsta = DIA_RING;			v* 		    } else if (didweget(lbuf,"ERROR")) { 			mdmstat = FAILED; 			dialsta = DIA_ERR;  		    }p 		    break; #ifndef MINIDIAL 		  case n_PENRIL:  		    if (didweget(lbuf,"OK")) { 			mdmstat = CONNECTED;n* 		    } else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED; 			dialsta = DIA_BUSY;, 		    } else if (didweget(lbuf,"NO RING")) { 			mdmstat = FAILED; 			dialsta = DIA_NOCA; 		    }	 		    break; 		  case n_RACAL:.# 		    if (didweget(lbuf,"ON LINE"))e 		      mdmstat = CONNECTED;, 		    else if (didweget(lbuf,"FAILED CALL")) 		      mdmstat = FAILED;t 		    break; 		  case n_ROLM:# 		    if (didweget(lbuf,"CALLING"))  			mdmstat = 0;h) 		    else if (didweget(lbuf,"COMPLETE"))? 			mdmstat = CONNECTED;	) 		    else if (didweget(lbuf,"FAILED") ||a& 			     didweget(lbuf,"ABANDONDED")) { 			mdmstat = FAILED; 			dialsta = DIA_NOCA;2 		    } else if (didweget(lbuf,"NOT AVAILABLE") ||. 			       didweget(lbuf,"LACKS PERMISSION") ||, 			       didweget(lbuf,"NOT A DATALINE") ||6 			       didweget(lbuf,"INVALID DATA LINE NUMBER") ||0 			       didweget(lbuf,"INVALID GROUP NAME")) { 			mdmstat = FAILED; 			dialsta = DIA_NOAC;) 		    } else if (didweget(lbuf,"BUSY")) {c 			mdmstat = FAILED; 			dialsta = DIA_BUSY;5 		    } else if (didweget(lbuf,"DOES NOT ANSWER")) {   			mdmstat = FAILED; 			dialsta = DIA_NOAN; 		    }4 		    break; 		  case n_VENTEL:% 		    if (didweget(lbuf,"ONLINE!") ||n 			didweget(lbuf,"Online!")) { 			mdmstat = CONNECTED;t) 		    } else if (didweget(lbuf,"BUSY") ||;" 			       didweget(lbuf,"Busy")) { 			mdmstat = FAILED; 			dialsta = DIA_BUSY;/ 		    } else if (didweget(lbuf,"DEAD PHONE")) {* 			mdmstat = FAILED; 			dialsta = DIA_DISC; 		    }  		    break; 		  case n_CONCORD: & 		    if (didweget(lbuf,"INITIATING")) 			mdmstat = CONNECTED;/( 		    else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED;			l 			dialsta = DIA_BUSY;0 		    } else if (didweget(lbuf,"CALL FAILED")) { 			mdmstat = FAILED; 			dialsta = DIA_NOCA; 		    }} 		    break; 		  case n_MICROCOM:9 		    /* "RINGBACK" means phone line ringing, continue */>) 		    if (didweget(lbuf,"NO CONNECT")) { a 			mdmstat = FAILED; 			dialsta = DIA_NOCA;* 		    } else if (didweget(lbuf,"BUSY")) {  			mdmstat = FAILED; 			dialsta = DIA_BUSY;1 		    } else if (didweget(lbuf,"NO DIALTONE")) {   			mdmstat = FAILED; 			dialsta = DIA_NODT;3 		    } else if (didweget(lbuf,"COMMAND ERROR")) { s 			mdmstat = FAILED; 			dialsta = DIA_ERR;n+ 		    } else if (didweget(lbuf,"IN USE")) {t 			mdmstat = FAILED; 			dialsta = DIA_NOAC;, 		    } else if (didweget(lbuf,"CONNECT")) { 			mdmstat = CONNECTED;  			/* trailing speed ignored */i 		    }r 		    break; #endif /* MINIDIAL */d 		}e 	    } 	    break;0   #ifndef MINIDIAL5 	case n_DF03:			/* because response lacks CR or NL */  	    c = ddinc(0) & 0177;  	    dialoc(c);e& 	    debug(F000,"dial df03 got","",c);) 	    if ( c == 'A' ) mdmstat = CONNECTED; & 	    if ( c == 'B' ) mdmstat = FAILED; 	    break;e  / 	case n_TBNV:			/* Hayeslike modems in digit */d' 	case n_TB3NV			/* response mode... */:= 	case n_TBPNV: 	case n_TB4NV: 	case n_TBSNV: #endif /* MINIDIAL */x 	case n_HAYESNV:   /*D   The method for reading Hayes numeric result codes has been totallyI   redone as of 5A(174) to account for all of the following.  Not all havei4   been tested, and others probably need to be added.  5   Hayes numeric result codes (Hayes 1200 and higher):o      0 = OK K      1 = CONNECT at 300 bps (or 1200 bps on Hayes 1200 with basic code set)M
      2 = RINGu      3 = NO CARRIERe       4 = ERROR (in command line))      5 = CONNECT 1200 (extended code set)    Hayes 2400 and higher:      6 = NO DIALTONE
      7 = BUSYf      8 = NO ANSWER      9 = (there is no 9)     10 = CONNECT 2400t2   Reportedly, the codes for Hayes V.32 modems are:     1x = CONNECT <suffix>n     5x = CONNECT 1200 <suffix>     9x = CONNECT 2400 <suffix>    11x = CONNECT 4800 <suffix>    12x = CONNECT 9600 <suffix>   Where:     x:   suffix:     R  = RELIABLE/     RC = RELIABLE COMPRESSED
     L  = LAPM      LC = LAPM COMPRESSEDJ   And for Telebits, all the above, except no suffix in numeric mode, plus:     11 = CONNECT 4800t     12 = CONNECT 9600      13 = CONNECT 14400     14 = CONNECT 19200     15 = CONNECT 38400     16 = CONNECT 57600!     20 = CONNECT 300/REL  (= MNP)l!     22 = CONNECT 1200/REL (= MNP) !     23 = CONNECT 2400/REL (= MNP)m%     46 = CONNECT 7512  (i.e. 75/1200).%     47 = CONNECT 1275  (i.e. 1200/75);     48 = CONNECT 7200l     49 = CONNECT 12000)     50 = CONNECT FAST (not on T1600/3000)"     52 = RRING     53 = DIALING     54 = NO PROMPTTONE)     61 = CONNECT FAST/KERM (Kermit spoof)k.     70 = CONNECT FAST/COMP (PEP + compression)B     71 = CONNECT FAST/KERM/COMP (PEP + compression + Kermit spoof) */ #define NBUFL 8f/ 	    {				/* Nonverbal response code handler */b/ 	    char nbuf[NBUFL+1];		/* Response buffer */k& 	    int i, j;			/* Buffer pointers *// 	    debug(F101,"RESPONSE mdmecho","",mdmecho);i9 	    if (mdmecho) {		/* Sponge up dialing string echo. */l
 		while (1) {n 		    c = ddinc(0) & 0x7f;  		    debug(F000,"SPONGE","",c); 		    dialoc(c); 		    if (c == CR) break;( 		}1 	    }/ 	    while (mdmstat == 0) {	/* Read response */c4 		for (i = 0; i < NBUFL; i++) /* Clear the buffer */ 		  nbuf[i] = '\0';e* 		i = 0;			/* Reset the buffer pointer. */9 		c = ddinc(0) & 0177;	/* Get first digit of response. */e+ 					/* using an untimed, blocking read. */c  		debug(F000,"RESPONSE-A","",c);) 		dialoc(c);		/* Echo it if requested. */ 6 		if (!isdigit(c))	/* If not a digit, keep looking. */
 		  continue; 1 		nbuf[i++] = c;		/* Got first digit, save it. */n? 		while (c != CR && i < 8) { /* Now read characters up to CR */ 1 		    x = ddinc(0) & 0177; /* Get a character. */ $ 		    c = (char) x;	/* Got it OK. */$ 		    debug(F000,"RESPONSE-C","",c);7 		    if (c != CR)	/* If it's not a carriage return, */b& 		      nbuf[i++] = c;	/*  save it. */  		    dialoc(c);		/* Echo it. */ 		})4 		nbuf[i] = '\0';		/* Done, terminate the buffer. */) 		debug(F111,"dial hayesnv lbuf",lbuf,n);A( 		debug(F111,"dial hayesnv got",nbuf,i); 		/*@ 		  Separate any non-numeric suffix from the numeric result code 		  with a null. 		*/3 		for (j = i-1; (j > -1) && !isdigit(nbuf[j]); j--)  		  nbuf[j+1] = nbuf[j]; 		j++; 		nbuf[j++] = '\0';h, 		debug(F110,"dial hayesnv numeric",nbuf,0);. 		debug(F111,"dial hayesnv suffix ",nbuf+j,j);A 		if ((int)strlen(nbuf) > 3) /* Probably phone number echoing. */o
 		  continue;  		/*) 		  Now read and interpret the results...t 		*/+ 		i = atoi(nbuf);		/* Convert to integer */  		switch (i) { 		  case 1:		/* CONNECT */3 		    mdmstat = CONNECTED; /* Could be any speed */I 		    break; 		  case 2:		/* RING */l> 		    if (dialdpy) printf("\r\n Local phone is ringing!\r\n"); 		    mdmstat = FAILED;	 		    dialsta = DIA_RING;s 		    break; 		  case 3:		/* NO CARRIER */f2 		    if (dialdpy) printf("\r\n No Carrier.\r\n"); 		    mdmstat = FAILED;E 		    dialsta = DIA_NOCA;  		    break; 		  case 4:		/* ERROR */; 		    if (dialdpy) printf("\r\n Modem Command Error.\r\n");= 		    mdmstat = FAILED;= 		    dialsta = DIA_ERR; 		    break; 		  case 5:		/* CONNECT 1200 */t5 		    spdchg(1200L);	/* Change speed if necessary. */s 		    mdmstat = CONNECTED; 		    break; 		  case 6:		/* NO DIALTONE */3 		    if (dialdpy) printf("\r\n No Dialtone.\r\n");e 		    mdmstat = FAILED;  		    dialsta = DIA_NODT;a 		    break; 		  case 7:		/* BUSY */e, 		    if (dialdpy) printf("\r\n Busy.\r\n"); 		    mdmstat = FAILED;; 		    dialsta = DIA_BUSY;( 		    break; 		  case 8:		/* NO ANSWER */1 		    if (dialdpy) printf("\r\n No Answer.\r\n");  		    mdmstat = FAILED;	 		    dialsta = DIA_NOAN;E 		    break; 		  case 9:		/* CONNECT 2400 */e 		  case 10:5 		    spdchg(2400L);	/* Change speed if necessary. */A 		    mdmstat = CONNECTED; 		    break;  		  case 11:		/* CONNECT 4800 */ 		    spdchg(4800L); 		    mdmstat = CONNECTED; 		    break;  		  case 12:		/* CONNECT 9600 */ 		    spdchg(9600L); 		    mdmstat = CONNECTED; 		    break;! 		  case 13:		/* CONNECT 14400 */  		    spdchg(14400L);  		    mdmstat = CONNECTED; 		    break; 		  case 14:) 		    spdchg(19200L);	/* CONNECT 19200 */s 		    mdmstat = CONNECTED; 		    break;! 		  case 15:		/* CONNECT 34800 */d 		    spdchg(38400L);	 		    mdmstat = CONNECTED; 		    break;! 		  case 16:		/* CONNECT 57600 */	 		    spdchg(57600L);* 		    mdmstat = CONNECTED; 		    break;# 		  case 20:		/* CONNECT 300/REL */o 		    spdchg(300L);e 		    mdmstat = CONNECTED; 		    break;$ 		  case 22:		/* CONNECT 1200/REL */ 		    spdchg(1200L); 		    mdmstat = CONNECTED; 		    break;$ 		  case 23:		/* CONNECT 2400/REL */ 		    spdchg(2400L); 		    mdmstat = CONNECTED; 		    break;  		  case 46:		/* CONNECT 7512 */. 		    spdchg(8880L);	/* 75/1200 split speed */8 		    mdmstat = CONNECTED; /* (special C-Kermit code) */ 		    break;# 		  case 47:		/* CONNECT 1200/75 */r> 		    mdmstat = CONNECTED; /* Speed not supported by Kermit */> 		    printf("CONNECT 1200/75 - Not support by C-Kermit\r\n"); 		    break;  		  case 48:		/* CONNECT 7200 */ 		    spdchg(7200L); 		    mdmstat = CONNECTED; 		    break;! 		  case 49:		/* CONNECT 12000 */  		    spdchg(12000L);  		    mdmstat = CONNECTED; 		    break; #ifndef MINIDIAL  		  case 50:		/* CONNECT FAST */8 		    if (mymdmtyp == n_TELEBIT) /* Early models only */ 		      mdmstat = CONNECTED; 		    break; 		  case 52:		/* RRING */d  		    if (mymdmtyp == n_TELEBIT)/ 		      if (dialdpy) printf(" Ringing...\r\n");{ 		    break; 		  case 53:		/* DIALING */   		    if (mymdmtyp == n_TELEBIT)/ 		      if (dialdpy) printf(" Dialing...\r\n");o 		    break;! 		  case 54:		/* NO PROMPTTONE */ " 		    if (mymdmtyp == n_TELEBIT) {2 			if (dialdpy) printf("\r\n No Prompttone.\r\n"); 			mdmstat = FAILED; 			dialsta = DIA_NODT; 		    }L 		    break;- 		  case 61:		/* Various Telebit PEP modes */  		  case 62: 		  case 63: 		  case 70: 		  case 71: 		  case 72: 		  case 73:8 		    if (mymdmtyp == n_TELEBIT) /* Early models only */ 		      mdmstat = CONNECTED; 		    break; #endif /* MINIDIAL */  		  default: 		    break; 		}  	    }3 	    if (mdmstat == CONNECTED && nbuf[j] != '\0') {D 		if (dialdpy) { 		    printf("\r\n"); - 		    if (nbuf[j] == 'R') printf("RELIABLE");a) 		    if (nbuf[j] == 'L') printf("LAPM");"2 		    if (nbuf[j+1] == 'C') printf(" COMPRESSED"); 		    printf("\r\n");A 		}p 	    } 	}         break;   	case n_UNKNOWN: { 	        int x, y = waitct;	) 		mdmstat = FAILED;	/* Assume failure. */w 		while (y-- > -1) { 		    x = ttchk(); 		    if (x > 0) { 			if (x > LBUFL) x = LBUFL; 			x = ttxin(x,(CHAR *)lbuf); ' 			if ((x > 0) && dialdpy) conol(lbuf);r 		    }	3 		    x = ttgmdm();	/* Try to read modem signals */,* 		    if (x < 0) break;	/* Can't, fail. */? 		    if (x & BM_DCD) {	/* Got signals OK.  Carrier present? */g( 			mdmstat = CONNECTED; /* Yes, done. */	 			break;t! 		    }			/* No, keep waiting. */E 		    sleep(1);f 		}w 	        break;{   	    } 	}				/* switch (augmdmtyp) */$     }					/* while (mdmstat == 0) */)     x = alarm(0);			/* Turn off alarm. */p(     debug(F101,"ckdial alarm off","",x);A     if ( mdmstat != CONNECTED )		/* Failure detected by modem  */e        return(dialfail(F_MODEM));  -     msleep(1000);			/* In case DTR blinks  */d&     debug(F100,"dial succeeded","",0);     if ( #ifndef MINIDIAL: 	augmdmtyp != n_ROLM		/* Rolm has weird modem signaling */ #elsel 	1 #endif /* MINIDIAL */; 	) {0 	alarm(3);			/* In case ttpkt() gets stuck... */? 	ttpkt(speed,FLO_DIAX,parity);	/* Cancel dialing state ioctl */C     } 0     dreset();				/* Reset alarms and signals. */     if (!quiet && !backgrd):.     if (dialdpy) {			/* If DIAL DISPLAY ON, */+ 	p = ck_time();			/* include timestamp.  */;. 	if (*p) printf(" Call complete: %s.\07\n",p);
     } else&       printf (" Call complete.\07\n"); #ifdef DYNAMIC&     if (lbuf) free(lbuf); lbuf = NULL;&     if (rbuf) free(rbuf); rbuf = NULL;&     if (fbuf) free(fbuf); fbuf = NULL; #endif /* DYNAMIC */     dialsta = DIA_OK;)+     return(1);				/* Return successfully */	 }a   /*M   getok() - wait up to n seconds for OK (0) or ERROR (4) response from modem.dJ   Use with Hayeslike or CCITT modems for reading the reply to a nondialing
   command.  L   Second argument says whether to be strict about numeric result codes, i.e.I   to require they be preceded by CR or else be the first character in the G   response, e.g. to prevent the ATH0<CR> echo from looking like a validuK   response.  Strict == 0 is needed for ATI on Telebit, which can return the	G   model number concatenated with the numeric response code, e.g. "9620"oJ   ("962" is the model number, "0" is the response code).  getok() Returns:      0 if it timed out,     1 if it succeeded,"+   -1 on modem command, i/o, or other error.= */1 #ifdef CK_POSIX_SIG			/* Jump-buf for getok(). */d static sigjmp_buf okbuf; #elsed static jmp_buf okbuf;  #endif /* CK_POSIX_SIG */"  
 static SIGTYPm9 oktimo(foo) int foo; {			/* Alarm handler for getok(). */d4 #ifdef OSK				/* OS-9, see comment in dialtime(). */     sigmask(-1); #endif /* OSK */ #ifdef CK_POSIX_SIGa     siglongjmp(okbuf,1); #else;     longjmp(okbuf,1);; #endif /* CK_POSIX_SIG */( }f  
 static int! getok(n, strict) int n, strict; {=     CHAR c;	     int i, x, status, oldalarm;e?     SIGTYP (*saval)();			/* For saving alarm handler locally */h  %     debug(F101,"getok entry n","",n);E   #ifdef DYNAMIC     if (!rbuf) {B 	if (!(rbuf = malloc(RBUFL+1))) { /* Allocate input line buffer */ 	    dialsta = DIA_IE; 	    return(-1); 	}/ 	debug(F101,"GETOK rbuf malloc ok","",RBUFL+1);      }n #endif /* DYNAMIC */  6     mdmecho = 0;			/* Assume no echoing of commands */=     saval = signal(SIGALRM,oktimo);	/* Set response timer, */ /     oldalarm = alarm(n);		/* saving old one. */)-     debug(F101,"getok alarm ok","",oldalarm);      if ( #ifdef CK_POSIX_SIGw 	sigsetjmp(okbuf,1)t #elsem 	setjmp(okbuf) #endif /* CK_POSIX_SIG */( 	) {		/* Timed out. */* 	alarm(oldalarm);		/* Restore old alarm */;  	if (saval) signal(SIGALRM,saval); /* and alarm handler *//" 	debug(F100,"getok timeout","",0);% 	ttflui();			/* Flush input buffer */=1 	return(0);			/* and return timeout indication */	  8     } else if (augmdmtyp == n_CCITT	/* CCITT, easy... */ #ifndef MINIDIAL7 	       || augmdmtyp == n_DIGITEL /* Digitel, ditto. */t #endif /* MINIDIAL */C 	       ) {  	waitfor("VAL");         return(1);  4     } else {				/* Hayes & friends, start here... */# 	status = 0;			/* No status yet. */)= 	for (x = 0; x < RBUFL; x++)	/* Initialize response buffer */(' 	  rbuf[x] = SP;			/*  to all spaces */d2 	rbuf[RBUFL] = NUL;		/* and terminate with NUL. */' 	debug(F100,"getok rbuf init ok","",0); 0 	while (status == 0) {		/* While no status... */* 	    x = ddinc(n);		/* Read a character */" 	    if (x < 0) {		/* I/O error */' 		alarm(oldalarm);	/* Turn off alarm */)> 		if (saval) signal(SIGALRM,saval); /* and restore handler. */' 		return(-1);		/* Return error code. */  	    }; 	    debug(F101,"getok ddinc","",x); /* Got a character. */O. 	    c = x & 0x7f;		/* Get low order 7 bits */' 	    if (!c)			/* Don't deposit NULs */(6 	      continue;			/* or else didweget() won't work */< 	    if (dialdpy) conoc((char)c); /* Echo it if requested */6 	    for (i = 0; i < RBUFL-1; i++) /* Rotate buffer */ 	      rbuf[i] = rbuf[i+1];l7 	    rbuf[RBUFL-1] = c;		/* Deposit character at end */D4 	    debug(F000,"getok:",rbuf,(int) c); /* Log it */& 	    switch (c) {		/* Interpret it. */. 	      case CR:			/* Got a carriage return. */< 		switch(rbuf[RBUFL-2]) {	/* Look at character before it. */, 		  case '0':		/* 0 = OK numeric response */ 		    if (!strict ||0 			rbuf[RBUFL-3] == CR || rbuf[RBUFL-3] == SP) {9 			augmdmtyp |= DIAL_NV; /* OR in the "nonverbal" bit. */;" 			status = 1;	/* Good response */ 		    }) 		    break;/ 		  case '4':		/* 4 = ERROR numeric response */i #ifndef MINIDIAL( 		    /* Or Telebit model number 964! */" 		    if (mymdmtyp == n_TELEBIT && 			isdigit(rbuf[RBUFL-3]) && 			isdigit(rbuf[RBUFL-4])) 		      break;
 		    else #endif /* MINIDIAL */O 		      if (!strict ||0 			rbuf[RBUFL-3] == CR || rbuf[RBUFL-3] == SP) {7 			augmdmtyp |= DIAL_NV; /* OR in the nonverbal bit. */g! 			status = -1;	/* Bad command */E 		    }	 		    break; 		}eA 		if (dialdpy && (augmdmtyp & DIAL_NV)) /* If numeric results, */ , 		  conoc(LF);		  /* echo a linefeed too. */ 		break;' 	      case LF:			/* Got a linefeed. */  		/*6 		  Note use of explicit octal codes in the string for9 		  CR and LF.  We want real CR and LF here, not whateverd5 		  the compiler happens to replace \r and \n with...t 		*/= 		if (!strcmp(rbuf+RBUFL-4,"OK\015\012")) /* Good response */  		  status = 1;h= 		else if (!strcmp(rbuf+RBUFL-7,"ERROR\015\012"))	/* Error */E 		  status = -1;; 		augmdmtyp &= ~(DIAL_NV); /* Turn off the nonverbal bit */D 		break;7 	      /* Check whether modem echoes its commands... */l% 	      case 't':			/* Got little t */|> 		if (!strcmp(rbuf+RBUFL-3,"\015at") || /* See if it's "at" */" 		    !strcmp(rbuf+RBUFL-3," at")) 		    mdmecho = 1;/ 		debug(F111,"MDMECHO-t",rbuf+RBUFL-2,mdmecho);t 		break;" 	      case 'T':			/* Got Big T */> 		if (!strcmp(rbuf+RBUFL-3,"\015AT") ||	/* See if it's "AT" */" 		    !strcmp(rbuf+RBUFL-3," AT")) 		    mdmecho = 1;/ 		debug(F111,"MDMECHO-T",rbuf+RBUFL-3,mdmecho);" 		break;5 	      default:			/* Other characters, accumulate. */	
 		status = 0;  		break; 	    } 	}' 	debug(F101,"getok returns","",status);e/ 	alarm(oldalarm);		/* Restore previous alarm */ 4 	if (saval) signal(SIGALRM,saval); /* and handler */% 	ttflui();			/* Flush input buffer */F& 	return(status);			/* Return status */     }  }d  H /* Maybe hang up the phone, depending on various SET DIAL parameters. */   int  dialhup() {;     int x = 0;*     if (dialhng) {			/* DIAL HANGUP ON? */6 	x = mdmhup();			/* Try modem-specific method first */# 	debug(F101,"dialhup mdmhup","",x);	# 	if (x > 0) {			/* If it worked, */l 	    if (dialdpy)f2 	      printf(" Modem hangup OK\r\n"); /* fine. */3 	} else if (network) {		/* If we're telnetted to */O9 	    if (dialdpy)		/* a modem server, just print a msg */eG 	      printf(" Warning: modem hangup failed\r\n"); /* don't hangup! */	 	    return(0);C 	} else {			/* Otherwise */(6 	    x = tthang();		/* Tell the OS to turn off DTR. */+ 	    if (dialdpy) {		/* DIAL DISPLAY ON? */A3 		if (x > 0)		/* Yes, tell results from tthang() */N 		  printf(" Hangup OK\r\n");( 		else if (x == 0)" 		  printf(" Hangup skipped\r\n"); 		else 		  perror(" Hangup error"); 	    } 	}L     } else if (dialdpy) printf(" Hangup skipped\r\n"); /* DIAL HANGUP OFF */     return(x); }C   /*   M D M H U P  --E  J   Sends escape sequence to modem, then sends its hangup command.  Returns:4    0: If modem type is 0 (direct serial connection),3       or if modem type is < 0 (network connection), =       or if no action taken because DIAL MODEM-HANGUP is OFF)g;         or because no hangup string for current modem type,C$       or C-Kermit is in remote mode,G       or if action taken but there was no positive response from modem;tM    1: Success: modem is in command state and acknowledged the hangup command;    -1: On modem command error.I */ intc
 mdmhup() {
 #ifdef MDMHUP 4     MDMINF *p;				/* Modem info structure pointer */     int m, x = 0;a     int xparity;  F     if (dialmhu == 0 || local == 0)	/* If DIAL MODEM-HANGUP is OFF, */5       return(0);			/*  or not in local mode, fail. */d  
 #ifdef OS2 /*H   In OS/2, if CARRIER is OFF, and there is indeed no carrier signal, anyK   attempt to do i/o at this point can hang the program.  This might be trueE"   for other operating systems too. */4     if (!network) {			/* Not a network connection */( 	m = ttgmdm();			/* Get modem signals */; 	if ((m > -1) && (m & BM_DCD == 0)) /* Check for carrier */0/ 	  return(0);			/* No carrier, skip the rest */      }  #endif /* OS2 */  ?     m = mdmtyp & 0xff;			/* Get basic modem type (no bits!). */iC     if ((m < 1) || (m > MAX_MDM))	/* If modem type not in range, */        return(0);			/*  fail. */=3     p = ptrtab[m-1];			/* Get modem info pointer */PB     if (!(p->hup_str) || !*(p->hup_str)) { /* No hangup string? */0 	debug(F100,"mdmhup no hup_str","",0); /* No, */ 	return(0);			/*  fail. */     } else {6 	debug(F110,"mdmhup hup_str",p->hup_str,0); /* Yes. */? 	if (p->esc_str && *(p->esc_str)) { /* Have escape sequence? */P/ 	    debug(F110,"mdmhup esc_str",p->esc_str,0);C2 	    debug(F101,"mdmhup esc_time","",p->esc_time);< 	    xparity = parity;		/* Set PARITY to NONE temporarily */ 	    parity = 0;A 	    if (ttpkt(speed,FLO_DIAL,parity) < 0) { /* Condition line */  		parity = xparity;=" 		return(-1);		/*  for dialing. */ 	    }4 	    if (p->esc_time)		/* If we have a guard time */6 	      msleep(p->esc_time);	/* Pause for guard time */* 	    debug(F100,"mdmhup pause 1 OK","",0); #ifdef NETCONN' 	    /* Send modem's escape sequence */n2 	    if (network) {		/* Must catch errors here. */? 		if (ttol((CHAR *)(p->esc_str),(int)strlen(p->esc_str)) < 0) {R 		    parity = xparity;h 		    return(-1);c 		}	
 	    } else {i= 		ttslow(p->esc_str,p->wake_rate); /* Send escape sequence */7. 		debug(F110,"mdmhup ttslow ok",p->esc_str,0); 	    } #elsef@ 	    ttslow(p->esc_str,p->wake_rate); /* Send escape sequence */1 	    debug(F110,"mdmhup ttslow ok",p->esc_str,0);C #endif /* NETCONN */7 	    if (p->esc_time)		/* Pause for guard time again */r 	      msleep(p->esc_time);/4 	    msleep(500);		/* Wait half a sec for echoes. */* 	    debug(F100,"mdmhup pause 1 OK","",0);5 	    ttflui();			/* Flush response or echo, if any */.) 	    debug(F100,"mdmhup ttflui OK","",0);  	}> 	ttslow(p->hup_str,p->wake_rate); /* Now Send hangup string */- 	debug(F110,"mdmhup ttslow ok",p->hup_str,0);/- 	if (p->ok_fn) {			/* Look for OK response */d9 	    debug(F100,"mdmhup calling response function","",0);	@ 	    x = (*(p->ok_fn))(3,1);	/* Give it 3 seconds, be strict. *// 	    debug(F101,"mdmhup hangup response","",x);	! 	} else {			/* No OK function, *//' 	    x = 1;			/* so assume it worked */ ( 	    debug(F101,"mdmhup no ok_fn","",x); 	}3 	parity = xparity;		/* Restore prevailing parity */	5 	return(x);			/* Return OK function's return code. */a     }n# #else					/* MDMHUP not defined. */s$     return(0);				/* Always fail. */ #endif /* MDMHUP */& }i  * char *					/* Let external routines ask */; getdws(mdmtyp) int mdmtyp; {		/* about dial init-string. */n     MDMINF * p; !     if (dialini) return(dialini);,9     if ((mdmtyp & 0xff) < 1 || (mdmtyp & 0xff) > MAX_MDM)n       return(""); #     p = ptrtab[(mdmtyp & 0xff) -1];d     return(p->wake_str); }	   char *> getdcs(mdmtyp) int mdmtyp; {		/* Same deal for dial-command */     MDMINF * p;/!     if (dialcmd) return(dialcmd);l9     if ((mdmtyp & 0xff) < 1 || (mdmtyp & 0xff) > MAX_MDM)        return("");p#     p = ptrtab[(mdmtyp & 0xff) -1];\     return(p->dial_str); }	   #else /* NODIAL */  & char *dialv = "Dial Command Disabled";  ) int					/* To allow NODIAL versions to */o/ mdmhup() {				/* call mdmhup(), so calls to  */ 3     return(0);				/* mdmhup() need not be within */R' }					/* #ifndef NODIAL conditionals */o   #endif /* NODIAL */) #endif /* NOLOCAL */