. #include "ckcsym.h"			/* Symbol definitions */
 #ifndef NOICP   @ /*  C K U U S 3 --  "User Interface" for Unix Kermit, part 3  */    /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   H /*  SET command (but much material has been split off into ckuus7.c). */    /*   Kermit-specific includes. =   Definitions here supersede those from system include files.  */7 #include "ckcdeb.h"			/* Debugging & compiler things */ 3 #include "ckcasc.h"			/* ASCII character symbols */ : #include "ckcker.h"			/* Kermit application definitions */5 #include "ckcxla.h"			/* Character set translation */ + #include "ckcnet.h"			/* Network symbols */ 2 #include "ckuusr.h"			/* User interface symbols */
 #ifdef OS2 #ifdef CK_NETBIOS  #include <os2.h>) #ifdef COMMENT				/* Would you believe */ . #undef COMMENT				/* <os2.h> defines this ? */ #endif /* COMMENT */ #include "ckonbi.h"  extern UCHAR NetBiosAdapter ;  #endif /* CK_NETBIOS */  #endif /* OS2 */   /* Variables */    extern xx_strp xxstring;  / extern int size, spsiz, spmax, urpsiz, srvtim,     local, server, success, 4   flow, binary, delay, parity, escape, what, srvdis,   turn, duplex, backgrd,5   turnch, bctr, mdmtyp, keep, maxtry, unkcs, network, !   ebqflg, quiet, swcapr, nettype,    wslotr, lscapr, lscapu,    carrier, debses,0   cdtimo, nlangs, bgset, pflag, msgflg, dblchar,%   cmdmsk, spsizr, wildxpand, suspend,    techo, rptena, rptmin,2   xfrcan, xfrchr, xfrnum, pacing, xitwarn, xitsta,   cmd_cols, cmd_rows, ckxech;    #ifndef NOKVERBS extern int nkverbs;  extern struct keytab kverbs[]; #endif /* NOKVERBS */    #ifdef CM_RETRY  extern int cm_retry; #endif /* CM_RETRY */   
 #ifdef TNCODE    extern int ttnproto; #endif /* TNCODE */   5 extern char *ccntab[];			/* Names of control chars */  #ifdef CK_SPEED 1 extern short ctlp[];			/* Control-prefix table */  #endif /* CK_SPEED */    #ifndef NOSCRIPT8 extern int secho;			/* Whether SCRIPT cmd should echo */ #endif /* NOSCRIPT */    #ifdef DCMDBUF extern char *atmbuf, *atxbuf;  #else  extern char atmbuf[], atxbuf[];  #endif /* DCMDBUF */   extern char psave[];  
 #ifndef NOSPL  #ifdef DCMDBUF- extern int *count, *takerr, *merror, *inpcas;  #else 1 extern int count[], takerr[], merror[], inpcas[];  #endif /* DCMDBUF */$ extern int mecho;			/* Macro echo */ #else  extern int takerr[]; #endif /* NOSPL */  4 extern int bigsbsiz, bigrbsiz;		/* Packet buffers */  ) extern long speed;			/* Terminal speed */   0 extern CHAR sstate;			/* Protocol start state */4 extern CHAR myctlq;			/* Control-character prefix *// extern CHAR myrptq;			/* Repeat-count prefix */ ; extern CHAR mystch, seol;		/* Packet start and end chars */ 7 extern char ttname[];			/* Communication device name */  extern char myhost[] ;   #ifndef NOSETKEY< extern KEY *keymap;			/* Character map for SET KEY (1:1)  */@ extern MACRO *macrotab;			/* Macro map for SET KEY (1:string) */
 #ifdef OS2D int wideresult;              /* for SET KEY, wide OS/2 scan codes */> char * printfile = NULL;		/* NULL if printer not redirected */ #endif /* OS2 */ #endif /* NOSETKEY */   
 #ifdef OS2< extern int tcp_avail;			/* Nonzero if TCP/IP is available *// extern int dnet_avail;			/* Ditto for DECnet */  #endif /* OS2 */   #ifndef NOCSETS ? /* system-independent character sets, defined in ckcxla.[ch] */  extern struct csinfo tcsinfo[];  extern struct langinfo langs[];   + /* Other character-set related variables */ ' extern int tcharset, tslevel, language;  #endif /* NOCSETS */    # /* Declarations from cmd package */     #ifdef DCMDBUF+ extern char *cmdbuf;			/* Command buffer */  extern char *line; extern char *tmpbuf; #else , extern char cmdbuf[];			/* Command buffer */9 extern char line[];			/* Character buffer for anything */  extern char tmpbuf[];  #endif /* DCMDBUF */    /* From main ckuser module... */   . extern char *tp, *lp;			/* Temporary buffer */  2 extern int tlevel;			/* Take Command file level */  
 #ifndef NOSPL 0 extern int cmdlvl;			/* Overall command level */ #endif /* NOSPL */   #ifndef NOLOCAL  #ifdef UNIX 0 extern int sessft;			/* Session-log file type */ #endif /* UNIX */  #endif /* NOLOCAL */  
 #ifdef VMS& int vms_msgs = 1;			/* SET MESSAGES */ #endif /* VMS */  % /* Keyword tables for SET commands */     #ifdef CK_SPEED  struct keytab ctltab[] = {?     "prefixed",   1, 0,			/* Note, the values are important. */      "unprefixed", 0, 0 }; #endif /* CK_SPEED */   
 #ifndef NOSPL 8 struct keytab outptab[] = {		/* SET OUTPUT parameters */-     "pacing", 0, 0			/* only one so far... */  }; #endif /* NOSPL */  3 struct keytab chktab[] = {		/* Block check types */ +     "1", 1, 0,				/* 1 =  6-bit checksum */ +     "2", 2, 0,				/* 2 = 12-bit checksum */ &     "3", 3, 0,				/* 3 = 16-bit CRC */>     "blank-free-2", 4, 0		/* B = 12-bit checksum, no blanks */ };  , struct keytab rpttab[] = {		/* SET REPEAT */(     "counts",    0, 0,			/* On or Off */ #ifdef COMMENT)     "minimum",   1, 0,			/* Threshhold */  #endif /* COMMENT */<     "prefix",    2, 0			/* Repeate-prefix character value */ };   #ifndef NOLOCAL  /* For SET CARRIER */    struct keytab crrtab[] = {     "auto", CAR_AUT, 0,      "off",  CAR_OFF, 0,      "on",   CAR_ON, 0  };
 int ncrr = 3;  #endif /* NOLOCAL */   /* For SET DEBUG */    struct keytab dbgtab[] = {     "off",     0,  0,      "on",      1,  0,      "session", 2,  0 };
 int ndbg = 3;    #ifndef NOLOCAL  /* Transmission speeds */    /*N   Note, the values are encoded in cps rather than bps because 19200 and higherL   are too big for some ints.  All but 75bps are multiples of ten.  Result ofK   lookup in this table must be multiplied by 10 to get actual speed in bps. K   If this number is 70, it must be changed to 75.  If it is 888, this means    75/1200 split speed.  J   The values are generic, rather than specific to UNIX.  We can't use B75,C   B1200, B9600, etc, because non-UNIX versions of C-Kermit will not B   necessarily have these symbols defined.  The BPS_xxx symbols areI   Kermit-specific, and are defined in ckcdeb.h or on the CC command line.   C   Like all other keytabs, this one must be in "alphabetical" order,    rather than numeric order. */ struct keytab spdtab[] = {     "0",      0,  CM_INV,      "110",   11,  0, #ifdef BPS_115K   "115200",11520,  0, #endif /* BPS_115K */    "1200",   120,  0, #ifdef BPS_134   "134.5",  134,  0, #endif /* BPS_134 */ #ifdef BPS_14K   "14400", 1440,  0, #endif /* BPS_14K */ #ifdef BPS_150   "150",     15,  0, #endif /* BPS_150 */ #ifdef BPS_19K   "19200", 1920,  0, #endif /* BPS_19K */ #ifdef BPS_200   "200",     20,  0, #endif /* BPS_200 */   "2400",   240,  0, #ifdef BPS_28K   "28800", 2880,  0, #endif /* BPS_28K */ #ifdef BPS_230K    "230400", 2304, 0, #endif /* BPS_230K */    "300",     30,  0, #ifdef BPS_3600    "3600",   360,  0, #endif /* BPS_3600 */  #ifdef BPS_38K   "38400", 3840,  0, #endif /* BPS_38K */   "4800",   480,  0,
 #ifdef BPS_50    "50",       5,  0, #endif /* BPS_50 */  #ifdef BPS_57K   "57600", 5760,  0, #endif /* BPS_57K */   "600",     60,  0, #ifdef BPS_7200    "7200",   720,  0, #endif /* BPS_7200 */ 
 #ifdef BPS_75    "75",       7,  0, #endif /* BPS_75 */  #ifdef BPS_7512 >   "75/1200",888,  0,		/* Special code "888" for split speed */ #endif /* BPS_7512 */  #ifdef BPS_76K   "76800", 7680,  0, #endif /* BPS_76K */   "9600",   960,  0  };J int nspd = (sizeof(spdtab) / sizeof(struct keytab)); /* How many speeds */ #endif /* NOLOCAL */   #ifndef NOCSETS @ extern struct keytab lngtab[];		/* Languages for SET LANGUAGE */ extern int nlng; #endif /* NOCSETS */   #ifndef NOLOCAL  /* Duplex keyword table */    struct keytab dpxtab[] = {     "full", 	 0, 0,      "half",      1, 0  }; #endif /* NOLOCAL */    /* SET FILE parameters */    struct keytab filtab[] = {"     "bytesize",         XYFILS, 0, #ifndef NOCSETS "     "character-set",    XYFILC, 0, #endif /* NOCSETS */"     "collision",        XYFILX, 0,"     "display",          XYFILD, 0,"     "incomplete",       XYFILI, 0, #ifdef CK_LABELED "     "label",            XYFILL, 0, #endif /* CK_LABELED */ "     "names",            XYFILN, 0,
 #ifdef VMS"     "record-length",    XYFILR, 0, #endif /* VMS */"     "type",             XYFILT, 0,&     "warning",          XYFILW, CM_INV };5 int nfilp = (sizeof(filtab) / sizeof(struct keytab));    /* Flow Control */  @ struct keytab flotab[] = {		/* SET FLOW-CONTROL keyword table */ #ifdef CK_DTRCD      "dtr/cd",   FLO_DTRC, 0, #endif /* CK_DTRCD */  #ifdef CK_DTRCTS     "dtr/cts",FLO_DTRT, 0, #endif /* CK_DTRCTS */     "keep",     FLO_KEEP, 0,     "none",     FLO_NONE, 0, #ifdef CK_RTSCTS     "rts/cts",  FLO_RTSC, 0, #endif /* CK_RTSCTS */     "xon/xoff", FLO_XONX, 0  };4 int nflo = (sizeof(flotab) / sizeof(struct keytab));   /*  Handshake characters  */    struct keytab hshtab[] = {     "bell", 007, 0,      "code", 998, 0,      "cr",   015, 0,      "esc",  033, 0,      "lf",   012, 0, 8     "none", 999, 0,			/* (can't use negative numbers) */     "xoff", 023, 0,      "xon",  021, 0 };4 int nhsh = (sizeof(hshtab) / sizeof(struct keytab));    #ifndef NOLOCAL F static struct keytab sfttab[] = {	/* File types for SET SESSION-LOG */      "ascii",     XYFT_B, CM_INV,     "binary",    XYFT_B, 0,      "text",      XYFT_T, 0 };> static int nsfttab = (sizeof(sfttab) / sizeof(struct keytab)); #endif /* NOLOCAL */   #ifndef NODIALG extern struct keytab mdmtab[] ;		/* Modem types (in module ckudia.c) */ ' extern int nmdm;			/* Number of them */  #ifndef MINIDIAL, extern int tbmodel;			/* Telebit model ID */ #endif /* MINIDIAL */  #endif /* NODIAL */     #ifndef NOPUSH #ifdef UNIX 9 struct keytab wildtab[] = {		/* SET WILDCARD-EXPANSION */      "kermit",  0, 0,     "shell",   1, 0  }; #endif /* UNIX */  #endif /* NOPUSH */    #ifdef NETCONN extern struct keytab netcmd[]; extern int nnets;  #ifdef NPIPE char pipename[PIPENAML+1]; #endif /* NPIPE */ #ifdef CK_NETBIOS $ extern unsigned char NetBiosName[] ; #endif /* CK_NETBIOS */  #endif /* NETCONN */  
 #ifdef ANYX25  struct keytab x25tab[] = {#     "call-user-data",    XYUDAT, 0, #     "closed-user-group", XYCLOS, 0, $     "reverse-charge",    XYREVC, 0   };4 int nx25 = (sizeof(x25tab) / sizeof(struct keytab));   struct keytab padx3tab[] = {:     "break-action",         PAD_BREAK_ACTION,           0,:     "break-character",      PAD_BREAK_CHARACTER,        0,:     "character-delete",     PAD_CHAR_DELETE_CHAR,       0,:     "cr-padding",           PAD_PADDING_AFTER_CR,       0,:     "discard-output",       PAD_SUPPRESSION_OF_DATA,    0,:     "echo",                 PAD_ECHO,                   0,:     "editing",              PAD_EDITING,                0,:     "escape",               PAD_ESCAPE,                 0,:     "forward",              PAD_DATA_FORWARD_CHAR,      0,:     "lf-padding",           PAD_PADDING_AFTER_LF,       0,:     "lf-insert",            PAD_LF_AFTER_CR,            0,:     "line-delete",          PAD_BUFFER_DELETE_CHAR,     0,:     "line-display",         PAD_BUFFER_DISPLAY_CHAR,    0,:     "line-fold",            PAD_LINE_FOLDING,           0,:     "pad-flow-control",     PAD_FLOW_CONTROL_BY_PAD,    0,:     "service-signals",      PAD_SUPPRESSION_OF_SIGNALS, 0,:     "timeout",              PAD_DATA_FORWARD_TIMEOUT,   0, /* Speed is read-only */:     "transmission-rate",    PAD_LINE_SPEED,             0,9     "user-flow-control",    PAD_FLOW_CONTROL_BY_USER,   0  };8 int npadx3 = (sizeof(padx3tab) / sizeof(struct keytab)); #endif /* ANYX25 */    /* Parity keyword table */    struct keytab partbl[] = {     "even",    'e', 0,     "mark",    'm', 0,     "none",     0 , 0,     "odd",     'o', 0,     "space",   's', 0  };4 int npar = (sizeof(partbl) / sizeof(struct keytab));    /* On/Off table */    struct keytab onoff[] = {      "off",       0, 0,     "on",        1, 0  };    static* struct keytab xittab[] = {		/* SET EXIT */(     "status",    0, 0,			/* ...STATUS */(     "warning",   1, 0			/* ...WARNING */ };5 int nexit = (sizeof(xittab) / sizeof(struct keytab));    struct keytab rltab[] = {      "local",     1, 0,     "off",       0, CM_INV,      "on",        1, CM_INV,      "remote",    0, 0  };3 int nrlt = (sizeof(rltab) / sizeof(struct keytab));   ' /* Incomplete File Disposition table */  static struct keytab ifdtab[] = {     "discard",   0, 0,     "keep",      1, 0  };   /* SET TAKE parameters table */  static struct keytab taktab[] = {     "echo",  0, 0,     "error", 1, 0,1     "off",   2, CM_INV,			/* For compatibility */ 4     "on",    3, CM_INV			/* with MS-DOS Kermit... */ };  
 #ifndef NOSPL   /* SET MACRO parameters table */ static struct keytab smactab[] = {      "echo",  0, 0,     "error", 1, 0  }; #endif /* NOSPL */   #ifndef NOSCRIPT static struct keytab scrtab[] = {     "echo",  0, 0  }; #endif /* NOSCRIPT */   , #define SCMD_BSZ 0			/* SET COMMAND items */ #define SCMD_RCL 1 #define SCMD_RTR 2 #define SCMD_QUO 3   /* SET COMMAND table */  struct keytab scmdtab[] = {      "bytesize",  SCMD_BSZ, 0,      "quoting",   SCMD_QUO, 0 #ifdef CK_RECALL% ,   "recall-buffer-size", SCMD_RCL, 0  #endif /* CK_RECALL */ #ifdef CM_RETRY  ,   "retry", SCMD_RTR, 0 #endif /* CM_RETRY */  };6 int nbytt = (sizeof(scmdtab) / sizeof(struct keytab));   #ifndef NOSERVER /* Server parameters table */  struct keytab srvtab[] = {     "display", XYSERD, 0,      "timeout", XYSERT, 0 }; #endif /* NOSERVER */    /* SET TRANSFER/XFER table */    struct keytab tstab[] = { 
 #ifdef XFRCAN  /*.   This should be propogated to all versions... */     "cancellation",   0,   0,  #endif /* XFRCAN */  #ifndef NOCSETS      "character-set", 1,   0, #endif /* NOCSETS */     "locking-shift", 2,   0  };2 int nts = (sizeof(tstab) / sizeof(struct keytab));   #ifndef NOCSETS & /* SET TRANSFER CHARACTER-SET table */   extern struct keytab tcstab[]; extern int ntcs; #endif /* NOCSETS */  & /* SET TRANSFER LOCKING-SHIFT table */ struct keytab lstab[] = {      "forced", 2,   0,      "off",    0,   0,      "on",     1,   0 };2 int nls = (sizeof(lstab) / sizeof(struct keytab));   /* SET TELNET tables */ 
 #ifdef TNCODE  extern int tn_duplex, tn_nlm;  extern char *tn_term;   ; static struct keytab tnlmtab[] = {	/* NEWLINE-MODE table */ 7     "off",    TNL_CRNUL, 0,		/* CR-NUL (TELNET spec) */ 5     "on",     TNL_CRLF, 0,		/* CR-LF (TELNET spec) */ 5     "raw",    TNL_CR, 0			/* CR only (out of spec) */  };= static int ntnlm = (sizeof(tnlmtab) / sizeof(struct keytab));    struct keytab tntab[] = { #     "echo",          CK_TN_EC,   0, #     "newline-mode",  CK_TN_NL,   0, "     "terminal-type", CK_TN_TT,   0 };2 int ntn = (sizeof(tntab) / sizeof(struct keytab)); #endif /* TNCODE */   / struct keytab ftrtab[] = {		/* Feature table */ 5 #ifndef NOCSETS				/* 0 = we have it, 1 = we don't */  "character-sets",	0, 0,  #else  "character-sets",	1, 0,  #endif /* NOCSETS */ #ifndef NOCYRIL  "cyrillic",		0, 0, #else  "cyrillic",		1, 0, #endif /* NOCYRIL */   #ifndef NODEBUG  "debug",		0, 0,  #else  "debug",		1, 0,  #endif /* NODEBUG */   #ifndef NODIAL "dial",			0, 0,  #else  "dial",			1, 0,  #endif /* NODIAL */    #ifdef DYNAMIC "dynamic-memory",       0, 0,  #else  "dynamic-memory",       1, 0,  #endif /* DYNAMIC */   #ifdef XXFWD "forward",              0, 0,  #else  "forward",              1, 0,  #endif /* XXFWD */   #ifdef CK_CURSES "fullscreen-display",	0, 0,  #else  "fullscreen-display",	1, 0,  #endif /* CK_CURSES */
 #ifdef HEBREW  "hebrew",               0, 0,e #elsem "hebrew",               1, 0,  #endif /* HEBREW */  #ifndef NOHELP "help",			0, 0,f #else  "help",			1, 0,/ #endif /* NOHELP */r
 #ifndef NOSPLc "if-command",		0, 0, #elseT "if-command",		1, 0, #endif /* NOSPL */ #ifndef NOJC #ifdef UNIXC "job-control",		0, 0,  #else9 "job-control",		1, 0,a #endif /* UNIX */C #elseN "job-control",		1, 0,i #endif /* NOJC */b #ifdef KANJI "kanji",		0, 0,d #else  "kanji",		1, 0,s #endif /* KANJI */ #ifndef NOCSETSt "latin1",		0, 0, #elset "latin1",		1, 0, #endif /* NOCSETS */
 #ifdef LATIN2e "latin2",		0, 0, #elser "latin2",		1, 0, #endif /* LATIN2 */t #ifdef NETCONN "network",		0, 0,e #elsem "network",		1, 0,D #endif /* NETCONN */ #ifndef NOPUSH "push",			0, 0,o #elses "push",			1, 0,  #endif /* PUSH */d #ifdef CK_RTSCTS "rts/cts",		0, 0,  #elsel "rts/cts",		1, 0,  #endif /* RTS/CTS */   #ifdef CK_REDIRi "redirect",             0, 0,e #elser "redirect",             1, 0,f #endif /* CK_REDIR */k   #ifndef NOSCRIPT "script-command",	0, 0,  #elsee "script-command",	1, 0,a #endif /* NOSCRIPT */c #ifndef NOSERVER "server-mode",		0, 0,e #elsen "server-mode",		1, 0,h #endif /* NOSERVER */a #ifndef NOSHOW "show-command",		0, 0, #elses "show-command",		1, 0, #endif /* NOSHOW */e #ifndef NOXMIT "transmit",		0, 0, #elseB "transmit",		1, 0. #endif /* NOXMIT */	 };4 int nftr = (sizeof(ftrtab) / sizeof(struct keytab));  N #ifndef NOSPL /* Present this is used only with script programming items... */  L /*  K W D H E L P  --  Given a keyword table, print keywords in columns.  */ /*   Call with:     s     - keyword tablez     n     - number of entrieso#     pre   - prefix for each keywordy#     post  - suffix for each keyword,J     off   - offset on first screenful, allowing room for introductory text  C   Arranges keywords in columns with width based on longest keyword. ,   Does "more?" prompting at end of screen.  4   Uses global cmd_rows and cmd_cols for screen size. */ VOIDL kwdhelp(s,n,pre,post,off) struct keytab s[]; int n, off; char *pre, *post; {     int width = 0;*     int cols, height, i, j, k, lc, n2 = 0;     char *b, *p, *q;     char *pa, *px;     char **s2;     )     if (!s) return;			/* Nothing to do */ $     if (n < 1) return;			/* Ditto */6     if (off < 0) off = 0;		/* Offset for first page */;     if (!pre) pre = "";			/* Handle null string pointers */_     if (!post) post = "";;*     lc = off;				/* Screen-line counter */  4     if (s2 = (char **) malloc(n * sizeof(char *))) {5 	for (i = 0; i < n; i++) {	/* Find longest keyword */ 6 	    if (s[i].flgs & CM_INV)	/* Skip invisible ones */ 	      continue;= 	    s2[n2++] = s[i].kwd;	/* Copy pointers to visible ones */; 	    j = strlen(s[i].kwd); 	    if (j > width) width = j; 	} 	/* Column width */e 	n = n2;     }cO     if (s2 && (b = (char *) malloc(cmd_cols + 1))) { /* Make a line buffer   */	4 	width += (int)strlen(pre) + (int)strlen(post) + 2; 2 	cols = cmd_cols / width;		/* How many columns? */3 	height = n / cols;		/* How long is each column? */s= 	if (n % cols) height++;		/* Add one for remainder, if any */x  ; 	for (i = 0; i < height; i++) {	    /* Loop for each row */ E 	    for (j = 0; j < cmd_cols; j++)  /* First fill row with blanks */k 	      b[j] = SP;aF 	    for (j = 0; j < cols; j++) {    /* Loop for each column in row */9 		k = i + (j * height);       /* Index of next keyword */	# 		if (k < n) {		    /* In range? *// 		    pa = pre; px = post;. 		    p = s2[k];		    /* Point to verb name */8 		    q = b + (j * width) + 1; /* Where to copy it to *// 		    while (*q++ = *pa++) ;  /* Copy prefix */ & 		    q--;		    /* Back up over NUL */4 		    while (*q++ = *p++) ;   /* Copy the keyword */& 		    q--;		    /* Back up over NUL *// 		    while (*q++ = *px++) ;  /* Copy suffix */o
 		    q--;' 		    *q = SP;		/* Replace the space */* 		}e 	    } 	    p = b + cmd_cols - 1; 	    while (*p-- == SP) ;n 	    *(p+2) = NUL;, 	    printf("%s\n",b);		/* Print the line */4 	    if (++lc > (cmd_rows - 3)) { /* Screen full? */. 		if (!askmore()) {	/* Do more-prompting... */ 		    free(b);
 		    return;c 		} else 		  lc = 0;d 	    } 	} x2 	printf("\n");			/* Blank line at end of report */" 	free(s2);			/* Free array copy */" 	free(b);			/* Free line buffer */ 	return;0     } else {				/* Malloc failure, no columns */ 	for (i = 0; i < n; i++) {= 	    if (s[i].flgs & CM_INV)	/* Use original keyword table */.3 	      continue;			/* skipping invisible entries */ * 	    printf("%s%s%s\n",pre,s[i].kwd,post);4 	    if (++lc > (cmd_rows - 3)) { /* Screen full? *// 		if (!askmore()) {	 /* Do more-prompting... */ 
 		    return;  		} else lc = 0; 	    }	    f 	}1 	if (s2) free(s2);		/* Free array copy, if any */e 	return;     }/ }  #endif /* NOSPL */   int					/* CHECK command */ 	 dochk() {M
     int x, y;y4     if ((y = cmkey(ftrtab,nftr,"","",xxstring)) < 0)       return(y);     strcpy(line,atmbuf);     if ((y = cmcfm()) < 0)       return(y);=     y = lookup(ftrtab,line,nftr,&x);	/* This will succeed. */n+     if (msgflg)				/* If at top level... */EB       printf(" %s%s available\n", ftrtab[x].kwd, y ? " not" : "");     else if (y && !backgrd) :       printf(" CHECK: %s not available\n", ftrtab[x].kwd);     return(success = 1 - y); }m   #ifndef NOSETKEY int* set_key() {				/* SET KEY */
     int x, y;*     int flag = 0;      int kc;				/* Key code */=!     char *s;				/* Key binding */      char *p;				/* Worker */  :     if ((y = cmnum("numeric key code, or the word CLEAR,",  		   "",10,&kc,xxstring)) < 0) {  	debug(F111,"SET KEY",atmbuf,y);* 	if (y == -2) {			/* Not a valid number */@ 	    if ((y = strlen(atmbuf)) < 0) /* Check for SET KEY CLEAR */ 	      return(-2);$ 	    if (xxstrcmp(atmbuf,"clear",y)) 	      return(-2);# 	    for (y = 0; y < KMSIZE; y++) {  		keymap[y] = y; 		macrotab[y] = NULL;/ 	    }
 #ifdef OS26 	    keymapinit();		/* Special OS/2 initializations */ #endif /* OS2 */ 	    return(1);s. 	} else if (y == -3) {		/* SET KEY <Return> */G 	    printf(" Press key to be defined: "); /* Prompt for a keystroke */  #ifdef UNIXa #ifdef NOSETBUF0 	    fflush(stdout); #endif /* NOSETBUF */l #endif /* UNIX */t< 	    conbin((char)escape);	/* Put terminal in binary mode */6 	    kc = congks(0);		/* Get character or scan code */? 	    concb((char)escape);	/* Restore terminal to cbreak mode */ ) 	    if (kc < 0) {		/* Check for error */n! 		printf("?Error reading key\n");  		return(0); 	    }3 	    shokeycode(kc);		/* Show current definition */m8 	    flag = 1;			/* Remember it's a multiline command */ 	} else				/* Error */
 	  return(y);i     }a  6     /* Normal SET KEY <scancode> <value> command... */  !     if (kc < 0 || kc >= KMSIZE) {e< 	printf("?key code must be between 0 and %d\n", KMSIZE - 1); 	return(-9);     }]     if (kc == escape) {M? 	printf("Sorry, %d is the CONNECT-mode escape character\n",kc);  	return(-9);     }K
 #ifdef OS2     wideresult = -1; #endif /* OS2 */     if (flag) {d 	cmsavp(psave,PROMPTL);B# 	cmsetp(" Enter new definition: ");/ 	cmini(ckxech);d     }1   def_again:     if (flag) prompt(NULL); &     if ((y = cmtxt("key definition,\n\$ or Ctrl-C to cancel this command,\n\( or Enter to restore default definition", 		   "",&s,NULL)) < 0) {& 	if (flag)			/* Handle parse errors */ 	  goto def_again; 	elseB
 	  return(y);0     }3     s = brstrip(s);_#     p = s;				/* Save this place */f /*K   If the definition included any \Kverbs, quote the backslash so the \Kverb0L   will still be in the definition when the key is pressed.  We don't do thisK   in zzstring(), because \Kverbs are valid only in this context and nowhere    else.   M   We use this code active for all versions that support SET KEY, even if they/J   don't support \Kverbs, because otherwise \K would behave differently for   different versions./ */@     for (x = 0, y = 0; s[x]; x++, y++) { /* Convert \K to \\K */ 	if ((x > 0) &&f! 	    (s[x] == 'K' || s[x] == 'k')d 	    ) {				/* Have K */   & 	    if ((x == 1 && s[x-1] == CMDQ) ||0 		(x > 1 && s[x-1] == CMDQ && s[x-2] != CMDQ)) {% 		line[y++] = CMDQ;	/* Make it \\K */  	    }4 	    if (x > 1 && s[x-1] == '{' && s[x-2] == CMDQ) {$   		line[y-1] = CMDQ;	/* Have \{K */'   		line[y++] = '{';	/* Make it \\{K */w 	    } 	} 	line[y] = s[x];     }b&     line[y++] = NUL;			/* Terminate *//     s = line + y + 1;			/* Point to after it */TK     x = LINBUFSIZ - (int) strlen(line) - 1; /* Calculate remaining space */Y      if ((x < (LINBUFSIZ / 2)) ||= 	(zzstring(line, &s, &x) < 0)) { /* Expand variables, etc. */i& 	printf("?Key definition too long\n"); 	if (flag) cmsetp(psave);c 	return(-9);     }I.     s = line + y + 1;			/* Point to result. */   #ifndef NOKVERBS /*;   Special case: see if the definition starts with a \Kverb.S:   If it does, point to it with p, otherwise set p to NULL. */
     p = s;     if (*p++ == CMDQ) {i 	if (*p == '{') p++;. 	p = (*p == 'k' || *p == 'K') ? p + 1 : NULL;      }  #else)
     p = NULL;o #endif /* NOKVERBS */a  A     if (macrotab[kc]) {			/* Possibly free old macro from key. */  	free(macrotab[kc]); 	macrotab[kc] = NULL;D     } 8     switch (strlen(s)) {		/* Action depends on length *//       case 0:				/* Reset to default binding */n 	keymap[kc] = kc;  	break;f'       case 1:				/* Single character */    	keymap[kc] = (CHAR) *s;	   	break; (       default:				/* Character string */ #ifndef NOKVERBS	 	if (p) { 7 	    y = xlookup(kverbs,p,nkverbs,&x); /* Look it up */]G 	    debug(F101,"set key kverb lookup",0,y); /* exact match required */  	    if (y > -1) { 		keymap[kc] = F_KVERB | y;n 		break; 	    } 	} #endif /* NOKVERBS */  	keymap[kc] = kc;,, 	macrotab[kc] = (MACRO) malloc(strlen(s)+1); 	if (macrotab[kc])$ 	  strcpy((char *) macrotab[kc], s); 	break;s     }e     if (flag) cmsetp(psave);     return(1); }O #endif /* NOSETKEY */X _' /*  D O P R M  --  Set a parameter.  */  /*	  Returns:    -2: illegal inputc   -1: reparse needed
    0: successo */ intk" doprm(xx,rmsflg) int xx, rmsflg; {     int i, x, y = 0, z;c     long zz;     char *s;  y
 #ifdef OS2+     if (xx == XYPRTR) {			/* SET PRINTER */r7 	if ((x = cmofi("printer file","PRN",&s,xxstring)) < 0)T
 	  return(x); 
 	if (x > 1) {I. 	    printf("?Directory names not allowed\n"); 	    return(-9); 	}3 	strcpy(line,s);			/* Make a temporary safe copy */*2 	if ((x = cmcfm()) < 0)		/* Confirm the command */
 	  return(x);*1 	if (printfile) {		/* Had a print file before? */s, 	    free(printfile);		/* Remove its name */ 	    printfile = NULL; 	}: 	x = strlen(line);		/* Length of name of new print file */1 	if ((x != 3) || (xxstrcmp(line,"PRN",3) != 0)) {*D 	    printfile = (char *) malloc(x + 1);	/* Allocate space for it */ 	    if (!printfile) {*  		printf("?Memory allocation failure\n");
 		return(-9);r 	    }= 	    strcpy(printfile,line);	/* Copy new name to new space */(. 	    debug(F110,"printfile name",printfile,0); 	} elsee2 	    debug(F101,"printfile is NULL","",printfile);> 	/* Return with printfile pointing to a file or device name *// 	/* or NULL to indicate the default printer. */  	return(success = 1);      }  #endif /* OS2 */  
 switch (xx) {   d" #ifdef ANYX25				/* SET X25 ... */ case XYX25:      return(setx25());     case XYPAD:				/* SET PAD ... */     return(setpadp()); #endif /* ANYX25 */   B case XYEOL:	/* These have all been moved to set send/receive... */0 case XYLEN: 	/* Let the user know what to do. */ case XYMARK: case XYNPAD: case XYPADC: case XYTIMO:8     printf("...Use SET SEND or SET RECEIVE instead.\n");F     printf("Type HELP SET SEND or HELP SET RECEIVE for more info.\n");     return(success = 0);  , case XYATTR:				/* File Attribute packets */     return(setat(rmsflg));  0 case XYIFD:				/* Incomplete file disposition */C     if ((y = cmkey(ifdtab,2,"","discard",xxstring)) < 0) return(y);_%     if ((x = cmcfm()) < 0) return(x);t     if (rmsflg) {_0 	sstate = setgen('S', "310", y ? "1" : "0", ""); 	return((int) sstate);     } else {
 	keep = y; 	return(success = 1);-     }n  l
 #ifndef NOSPLC case XYINPU:				/* SET INPUT */d     return(setinp());/ #endif /* NOSPL */   #ifdef NETCONN  case XYNET:				/* SET NETWORK */  J #ifdef OS2     /* Hide network-type keywords for networks not installed */!     for (z = 0; z < nnets; z++) { 3 	if (netcmd[z].kwval == NET_TCPB && tcp_avail == 0)p 	  netcmd[z].flgs =  CM_INV;
 #ifdef DECNET;9 	else if (netcmd[z].kwval == NET_DEC  && dnet_avail == 0)  	  netcmd[z].flgs =  CM_INV; #endif /* DECNET */  #ifdef CK_NETBIOSy; 	else if (netcmd[z].kwval == NET_BIOS && netbiosAvail == 0)  	  netcmd[z].flgs =  CM_INV; #endif /* CK_NETBIOS */      } /     if (tcp_avail)			/* Default network type */        strcpy(tmpbuf,"tcp/ip");
 #ifdef DECNET      else if (dnet_avail)       strcpy(tmpbuf,"decnet"); #endif /* DECNET */" #ifdef CK_NETBIOS      else if (netbiosAvail)       strcpy(tmpbuf,"netbios");l #endif /* CK_NETBIOS */e%     else strcpy(tmpbuf,"named-pipe");{ #elsed #ifdef TCPSOCKET     strcpy(tmpbuf,"tcp/ip"); #elseT
 #ifdef ANYX25t     strcpy(tmpbuf,"x.25"); #elset     strcpy(tmpbuf,"");     #endif /* ANYX25 */  #endif /* TCPSOCKET */ #endif /* OS2 */  9     if ((z = cmkey(netcmd,nnets,"",tmpbuf,xxstring)) < 0)/       return(z);  
 #ifdef OS2*     if (z == NET_TCPB && tcp_avail == 0) {> 	printf("?Sorry, TCP/IP is not available on this system.\n") ; 	return(-9); #ifdef CK_NETBIOSC4     } else if (z == NET_BIOS && netbiosAvail == 0) {? 	printf("?Sorry, NETBIOS is not available on this system.\n") ;  	return(-9); #endif /* CK_NETBIOS */d
 #ifdef DECNET21     } else if (z == NET_DEC && dnet_avail == 0) {t> 	printf("?Sorry, DECnet is not available on this system.\n") ; 	return(-9); #endif /* DECNET */_     }  #endif /* OS2 */   #ifdef NPIPEORBIOS@     if (z == NET_PIPE || 		/* Named pipe -- also get pipename */7 	z == NET_BIOS) {		/* NETBIOS -- also get local name */) 	char *defnam; #ifdef CK_NETBIOSe# 	char tmpnbnam[NETBIOS_NAME_LEN+1];e #endif /* CK_NETBIOS */b 	/* Construct default name  */' 	if (z == NET_PIPE) {		/* Named pipe *//> 	    defnam = "kermit";		/* Default name is always "kermit" */ 	} else {			/* NetBIOS */AB 	    if (NetBiosName[0] != SP) {	/* If there is already a name, *// 		char *p; int n;		/* use it as the default. */n 		strcpy(tmpnbnam,NetBiosName);,$ 		p=tmpnbnam + NETBIOS_NAME_LEN - 1; 		while ( *p == SP ) { 		    *p = NUL ; 		    p-- ;s 		}( 		defnam = tmpnbnam;A 	    } else if (*myhost)		/* Otherwise use this PC's host name */r  	      defnam = (char *) myhost;( 	    else			/* Otherwise use "kermit" */ 	      defnam = "kermit";  	}E 	if ((y = cmtxt((z == NET_PIPE) ? "pipe name" : "local NETBIOS name", $ 		       defnam, &s, xxstring)) < 0)
 	  return(y);s #ifdef NPIPE 	pipename[0] = NUL;L #endif /* NPIPE */! 	if ((y = (int) strlen(s)) < 1) {n1 	    printf("?You must also specify a %s name\n",t2 		   (z == NET_PIPE) ? "pipe" : "local NETBIOS" );  	    return(-9);	 	} #ifdef CK_NETBIOS) 	if (z == NET_BIOS) {_ 	    if ( !netbiosAvail ) {eA 		printf("?NETBIOS support is not available on this system.\n") ;  		return(-9) ; 	    }% 	    if ( y - NETBIOS_NAME_LEN > 0) { 1 		printf("?NETBIOS name too long, %ld maximum\n",C 		       NETBIOS_NAME_LEN);m
 		return(-9);,( 	    } else if ( !strcmp(s,tmpnbnam) ) {:       		nettype = z;		/* Returning to old connection... */! 		return(success = 1);	/* Done */ 9 	    } else if (strcmp("                ",NetBiosName)) { ? 		   printf("?Local NETBIOS name already assigned to \"%s\"\n",  		       NetBiosName); 		   return(-9) ;  	   } else { 		NCB ncb ;l
 		APIRET rc ;e 		strcpy(NetBiosName,s);( 		for (x = y; x < NETBIOS_NAME_LEN; x++) 		  NetBiosName[x] = SP;& 		NetBiosName[NETBIOS_NAME_LEN] = NUL;@ 		printf("Verifying \"%s\" is a unique NetBIOS node name ...\n", 		       NetBiosName) ;f 		rc = NCBAddName( NetbeuiAPI,) 				&ncb, NetBiosAdapter, NetBiosName ) ;,
 		if ( rc ) { 
 		    printf(i@ 		"?Sorry, \"%s\" is already in use by another NetBIOS node.\n", 			   NetBiosName);d+ 		    for ( x=0; x < NETBIOS_NAME_LEN; x++)e 		      NetBiosName[x] = SP ;l 		    return(-9) ; 		}  	    } 	} #endif /* CK_NETBIOS */  #ifdef NET_PIPE  	if (z == NET_PIPE)m  	  strncpy(pipename,s,PIPENAML); #endif /* NET_PIPE */i
     } else #endif /* NPIPEORBIOS */'       if ((x = cmcfm()) < 0) return(x);      nettype = z;     if ( 	(nettype != NET_DEC)  &&n #ifdef NPIPE 	(nettype != NET_PIPE) &&O #endif /* NPIPE */ #ifdef CK_NETBIOS  	(nettype != NET_BIOS) &&, #endif /* CK_NETBIOS */  	(nettype != NET_SX25) &&0 	(nettype != NET_VX25) &&d          (nettype != NET_TCPB)) {) 	printf("?Network type not supported\n");n 	return(success = 0);	     } else { 	return(success = 1);d     }O #endif /* NETCONN */  * case XYHOST:				/* SET HOST or SET LINE */ case XYLINE:     return(setlin(xx,1));n  o #ifndef NOSETKEY case XYKEY:				/* SET KEY */     return(set_key()); #endif /* NOSETKEY */o   #ifndef NOCSETS	 case XYLANG: 				/* Language */fL     if ((y = cmkey(lngtab,nlng,"","none",xxstring)) < 0) /* language code */       return(y);G     if ((x = cmcfm()) < 0) return(x);	/* And confirmation of command */0  <     /* Look up language and get associated character sets */:     for (i = 0; (i < nlangs) && (langs[i].id != y); i++) ;     if (i >= nlangs) {$ 	printf("?internal error, sorry\n"); 	return(success = 0);d     }O5     language = i;			/* All good, set the language, */s     return(success = 1); #endif /* NOCSETS */   #ifndef MACT  case XYBACK:				/* BACKGROUND */;     if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z);f%     if ((y = cmcfm()) < 0) return(y);n     bgset = z;     success = 1;     bgchk();     return(success); #endif /* MAC */   case XYQUIE:				/* QUIET */b$     return(success = seton(&quiet));   case XYBUF: {				/* BUFFERS */ #ifdef DYNAMIC     int sb, rb;n     char sbs[10]; A     if ((y = cmnum("Send buffer size","",10,&sb,xxstring)) < 0) { 0 	if (y == -3) printf("?Buffer size required\n"); 	return(y);r     }      if (sb < 0) {dF 	if (*atmbuf == '-') printf("?Negative numbers can't be used here\n");A 	else printf("?Integer overflow, use a smaller number please\n");c 	return(-9);     } else if (sb < 80) {t 	printf("?Too small\n"); 	return(-9);     } =     sprintf(sbs,"%d",sb);		/* Default second size == first */,C     if ((y = cmnum("Receive buffer size",sbs,10,&rb,xxstring)) < 0)        return(y);     if (rb < 0) {tF 	if (*atmbuf == '-') printf("?Negative numbers can't be used here\n");A 	else printf("?Integer overflow, use a smaller number please\n");  	return(-9);     } else if (rb < 80) {p 	printf("?Too small\n"); 	return(-9);     }n%     if ((y = cmcfm()) < 0) return(y);(,     if ((y = inibufs(sb,rb)) < 0) return(y);G     y = adjpkl(urpsiz,wslotr,bigrbsiz); /* Maybe adjust packet sizes */v      if (y != urpsiz) urpsiz = y;&     y = adjpkl(spsiz,wslotr,bigsbsiz);/     if (y != spsiz) spsiz = spmax = spsizr = y;;     return(success = 1); #else &     printf("?Sorry, not available\n");     return(success = 0); #endif /* DYNAMIC */ })  ! case XYCHKT:				/* BLOCK-CHECK */d=     if ((x = cmkey(chktab,4,"","1",xxstring)) < 0) return(x);o%     if ((y = cmcfm()) < 0) return(y);h>     bctr = x;			     /* Set locally too, even if REMOTE SET */     if (rmsflg) {d 	if (x == 4) { 	    tmpbuf[0] = 'B';( 	    tmpbuf[1] = '\0'; 	} else sprintf(tmpbuf,"%d",x); ) 	sstate = setgen('S', "400", tmpbuf, "");  	return((int) sstate);     } else { 	return(success = 1);;     }l  j #ifndef NOLOCALf #ifndef MACn /*   The Mac has no carrier...) */ case XYCARR:				/* CARRIER */	C     if ((y = cmkey(crrtab,ncrr,"","auto",xxstring)) < 0) return(y);	     if (y == CAR_ON) {? 	x = cmnum("Carrier wait timeout, seconds","0",10,&z,xxstring);c 	if (x < 0) return(z);     } %     if ((x = cmcfm()) < 0) return(x);-     carrier = ttscarr(y);      cdtimo = z;*     return(success = 1); #endif /* MAC */ #endif /* NOLOCAL */
 #ifdef TNCODE	 case XYTEL:				/* TELNET */*E     if ((z = cmkey(tntab,ntn,"parameter for TELNET negotiations", "",  		   xxstring)) < 0) return(z);l     switch (z) {!       case CK_TN_EC:			/* ECHO */; 	if ((x = cmkey(rltab,nrlt,P? 		       "initial TELNET echoing state","local",xxstring)) < 0)l
 	  return(x);k" 	if ((y = cmcfm()) < 0) return(y); 	tn_duplex = x;  	return(success = 1);e  *       case CK_TN_TT:			/* TERMINAL TYPE */: 	if ((y = cmtxt("terminal type for TELNET connections","", 		       &s,xxstring)) < 0)e
 	  return(y);/< 	if (tn_term) free(tn_term);	/* Free any previous storage */2 	if (s == NULL || *s == NUL) {	/* If none given */6 	    tn_term = NULL;		/* remove the override string */ 	    return(success = 1);tG 	} else if (tn_term = malloc(strlen(s)+1)) { /* Make storage for new */d; 	    strcpy(tn_term,s);		/* Copy string into new storage */m 	    return(success = 1);  	} else return(success = 0);  )       case CK_TN_NL:			/* NEWLINE-MODE */r<         if ((x = cmkey(tnlmtab,ntnlm,"","on",xxstring)) < 0)
 	  return(x);C 	if ((y = cmcfm()) < 0) 
 	  return(y);y 	tn_nlm = x; 	return(success = 1);,         default: 	return(-2);     }  #endif /* TNCODE */;   default:
     break; })  
 switch (xx) {;
 #ifndef NOSPLp case XYCOUN:				/* SET COUNT */l4     x = cmnum("Positive number","0",10,&z,xxstring);     if (x < 0) return(x); %     if ((x = cmcfm()) < 0) return(x);      if (z < 0) {( 	printf("?A positive number, please\n"); 	return(0);b     }f!     debug(F101,"XYCOUN: z","",z);=7     return(success = setnum(&count[cmdlvl],z,0,10000));  #endif /* NOSPL */  
 #ifndef NOSPLl case XYCASE:-     return(success = seton(&inpcas[cmdlvl]));K #endif /* NOSPL */    case XYCMD:				/* COMMAND ... */A     if ((y = cmkey(scmdtab,nbytt,"","",xxstring)) < 0) return(y);x     switch(y) {        case SCMD_BSZ:D 	if ((y = cmnum("bytesize for command characters, 7 or 8","7",10,&x, 		       xxstring)) < 0)
 	  return(y);  	if (x != 7 && x != 8) {, 	    printf("\n?The choices are 7 and 8\n"); 	    return(success = 0);  	}" 	if ((y = cmcfm()) < 0) return(y); 	if (x == 7) cmdmsk = 0177;   	else if (x == 8) cmdmsk = 0377; 	return(success = 1);t #ifdef CK_RECALL       case SCMD_RCL:C 	if ((y = cmnum("maximum number of commands in recall buffer","10",t 		       10,&x,xxstring)) < 0)
 	  return(y);a" 	if ((y = cmcfm()) < 0) return(y); 	return(success = cmrini(x));; #endif /* CK_RECALL */ #ifdef CM_RETRY*       case SCMD_RTR:$ 	return(success = seton(&cm_retry)); #endif /* CM_RETRY */0       case SCMD_QUO:$ 	if ((x = seton(&y)) < 0) return(x); 	cmdsquo(y);% 	/* Set string-processing function */k #ifdef datageneral* 	xxstring = y ? zzstring : (xx_strp) NULL; #else	  	xxstring = y ? zzstring : NULL; #endif /* datageneral */ 	return(success = 1);        default: 	return(-2);     }o     & case XYDFLT:				/* SET DEFAULT = CD */     return(success = docd());   4 case XYDEBU:				/* SET DEBUG { on, off, session } */?     if ((y = cmkey(dbgtab,ndbg,"","",xxstring)) < 0) return(y);"%     if ((x = cmcfm()) < 0) return(x);      switch (y) {-       case 0:				/* 0 = all debugging off. */c 	debses = 0; #ifdef DEBUG 	if (deblog) doclslog(LOGD); #endif /* DEBUG */         return(success = 1);  5       case 1:				/* 1 = log debugging to debug.log */i #ifdef DEBUG! 	deblog = debopn("debug.log", 0);i" 	return(success = deblog ? 1 : 0); #elsey3 	printf("?Sorry, debug log feature not enabled\n");s 	return(success = 0);t #endif /* DEBUG */  #       case 2:				/* 2 = session. */i 	return(success = debses = 1);     }    case XYDELA:				/* SET DELAY */(N     y = cmnum("Number of seconds before starting to send","5",10,&x,xxstring);     if (x < 0) x = 0;d-     return(success = setnum(&delay,x,y,999));r   default:
     break; }d  
 switch (xx) {e  y #ifndef NODIAL case XYDIAL:				/* SET DIAL */     return(setdial()); #endif /* NODIAL */x  ) #ifdef COMMENT				/* Unused at present */e case XYDOUB:D     if ((x = cmfld("Character to double","none",&s,xxstring)) < 0) { 	if (x == -3) {i 	    dblchar = -1;* 	    if (msgflg) printf("Doubling Off\n"); 	    return(success = 1);; 	} else return(x);     }t     strcpy(line,s);)     lp = line;%     if ((x = cmcfm()) < 0) return(x);*!     if (!xxstrcmp(lp,"none",4)) {  	dblchar = -1;& 	if (msgflg) printf("Doubling Off\n"); 	return(success = 1);+     }Q)     if ((int)strlen(lp) != 1) return(-2);1     dblchar = *lp & 0xFF; 0     if (msgflg) printf("Doubled: %d\n",dblchar);     return(success = 1); #endif /* COMMENT */   #ifndef NOLOCALx  case XYDUPL:				/* SET DUPLEX */@     if ((y = cmkey(dpxtab,2,"","full",xxstring)) < 0) return(y);%     if ((x = cmcfm()) < 0) return(x);)     duplex = y;e     return(success = 1);  (+ case XYLCLE:				/* LOCAL-ECHO (= DUPLEX) */,%     return(success = seton(&duplex));*   case XYESC:				/* SET ESCAPE */n     sprintf(tmpbuf,"%d",DFESC);cE     y = cmnum("Decimal ASCII code for CONNECT-mode escape character",  	      tmpbuf, 10,&x,xxstring); !     success = setcc(&escape,x,y);w #ifdef COMMENT& /* This is what SHOW ESCAPE is for. */     if (success && msgflg)B       printf(" CONNECT-mode escape character: %d (Ctrl-%c, %s)\n",C 	     escape,ctl(escape),(escape == 127 ? "DEL" : ccntab[escape]));e #endif /* COMMENT */     return(success); #endif /* NOLOCAL */   case XYEXIT:				/* SET EXIT */5     if ((z = cmkey(xittab,nexit,"","",xxstring)) < 0)h       return(z);     switch (z) {       case 0:				/* STATUS */ 1 	y = cmnum("EXIT status code","",10,&x,xxstring);b* 	return(success = setnum(&xitsta,x,y,-1));       case 1:				/* WARNING */8 	if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z);" 	if ((y = cmcfm()) < 0) return(y);
 	xitwarn = z;, 	return(success = 1);i       default: 	return(-2);$     } /* End of SET EXIT switch() */   default:
     break; }>  
 switch (xx) {k case XYFILE:				/* SET FILE */     return(setfil(rmsflg));*  " case XYFLOW:				/* FLOW-CONTROL */ /*G   Note: flotab[] keyword table (defined above) only includes the legal aE   flow-control options for each implementation, controlled by symbols1   defined in ckcdeb.h. */G     if ((y = cmkey(flotab,nflo,"","xon/xoff",xxstring)) < 0) return(y);l%     if ((x = cmcfm()) < 0) return(x);0
     flow = y;  #ifdef CK_SPEEDs:     if (flow == FLO_XONX)		/* Xon/Xoff forces prefixing */B       ctlp[XON] = ctlp[XOFF] = ctlp[XON+128] = ctlp[XOFF+128] = 1; #endif /* CK_SPEED */m#     debug(F101,"set flow","",flow);)     return(success = 1);  x case XYHAND:				/* HANDSHAKE */ C     if ((y = cmkey(hshtab,nhsh,"","none",xxstring)) < 0) return(y);a     if (y == 998) {o6 	if ((x = cmnum("ASCII value","",10,&y,xxstring)) < 0)
 	  return(x);)+ 	if ((y < 1) || ((y > 31) && (y != 127))) {f; 	    printf("?Character must be in ASCII control range\n");p 	    return(-9); 	}     }r%     if ((x = cmcfm()) < 0) return(x);i     turn = (y > 0127) ? 0 : 1 ;t     turnch = y;)     return(success = 1);  (
 #ifndef NOSPLx case XYMACR:				/* SET MACRO *//=     if ((y = cmkey(smactab,2,"","",xxstring)) < 0) return(y);\     switch (y) {.       case 0: return(success = seton(&mecho));7       case 1: return(success = seton(&merror[cmdlvl]));m       default: return(-2);     }b #endif /* NOSPL */   #ifndef NODIAL case XYMODM:				/* SET MODEM */oF     if ((x = cmkey(mdmtab,nmdm,"type of modem","none", xxstring)) < 0) 	return(x); %     if ((z = cmcfm()) < 0) return(z);/     mdmtyp = x;h #ifndef MINIDIALN     tbmodel = 0;          /* If it's a Telebit, we don't know the model yet */ #endif /* MINIDIAL *//     return(success = 1); #endif /* NODIAL */      case XYMSGS:
 #ifdef VMS;     if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z);h%     if ((y = cmcfm()) < 0) return(y);:     vms_msgs = z;e8     printf("Sorry, SET MESSAGES not implemented yet\n");     return(success = 0); #endif /* VMS */ default:
     break; }C  
 switch (xx) {o 	" case XYPARI:				/* PARITY */C     if ((y = cmkey(partbl,npar,"","none",xxstring)) < 0) return(y);l%     if ((x = cmcfm()) < 0) return(x);l  i= /* If parity not none, then we also want 8th-bit prefixing */)   0     if (parity = y) ebqflg = 1; else ebqflg = 0;     return(success = 1);  t #ifndef NOFRILLS  case XYPROM:				/* SET PROMPT */ /*I   Note: xxstring not invoked here.  Instead, it is invoked every time the G   prompt is issued.  This allows the prompt string to contain variables /   that can change, like \v(dir), \v(time), etc.	 */
 #ifdef MACJ     if ((x = cmtxt("Program's command prompt","Mac-Kermit>",&s,NULL)) < 0) #else H     if ((x = cmtxt("Program's command prompt","C-Kermit>",&s,NULL)) < 0) #endif /* MAC */       return(x);;     s = brstrip(s);			/* Remove enclosing braces, if any */C #ifdef COMMENT /*=   Let's not do this any more -- we don't do it anywhere else.C */>     else if (*s == '"') {		/* For compatibility with pre-5A */ 	x = (int)strlen(s); 	if (s[x-1] == '"') {  	    s[x-1] = NUL;	 	    s++;( 	}     }	 #endif /* COMMENT */&     cmsetp(s);				/* Set the prompt */     return(success = 1); #endif /* NOFRILLS */t  y3 case XYRETR:				/* RETRY: per-packet retry limit */E@     y = cmnum("Maximum retries per packet","10",10,&x,xxstring);     if (x < 0) x = 0;S5     if ((x = setnum(&maxtry,x,y,999)) < 0) return(x);i     if (maxtry <= wslotr) {p; 	printf("?Retry limit must be greater than window size\n");2 	return(success = 0);y     },      sprintf(tmpbuf,"%d",maxtry);     if (rmsflg) {/) 	sstate = setgen('S', "403", tmpbuf, "");t 	return((int) sstate);     } else return(success = x);   d #ifndef NOSERVER& case XYSERV:				/* SET SERVER items */<     if ((y = cmkey(srvtab,2,"","",xxstring)) < 0) return(y);     switch (y) {       case XYSERT:
 	tp = tmpbuf;_!         sprintf(tp,"%d",DSRVTIM);t> 	if ((y = cmnum("interval for server NAKs, 0 = none",tp,10,&x, 		       xxstring)) < 0)
 	  return(y);f
 	if (x < 0) { G 	    printf("\n?Specify a positive number, or 0 for no server NAKs\n");n 	    return(0);h 	}" 	if ((y = cmcfm()) < 0) return(y); 	sprintf(tp,"%d",x); 	if (rmsflg) {) 	    sstate = setgen('S', "404", tp, "");P 	    return((int) sstate);	 	} else {m8 	    srvtim = x;			/* Set the server timeout variable */ 	    return(success = 1);f 	})       case XYSERD:			/* SERVER DISPLAY */]5 	return(success = seton(&srvdis)); /* ON or OFF... */e       default: 	return(-2);     }  #endif /* NOSERVER */    #ifdef UNIXe #ifndef NOJC! case XYSUSP:				/* SET SUSPEND */N)     seton(&suspend);			/* on or off... */{     return(success = 1); #endif /* NOJC */; #endif /* UNIX */a   case XYTAKE:				/* SET TAKE */<     if ((y = cmkey(taktab,4,"","",xxstring)) < 0) return(y);     switch (y) {.       case 0: return(success = seton(&techo));
 #ifndef NOSPL 7       case 1: return(success = seton(&takerr[cmdlvl]));a #else 7       case 1: return(success = seton(&takerr[tlevel]));e #endif /* NOSPL */J       case 2: techo = 0; return(success = 1); /* For compatibility with */A       case 3: techo = 1; return(success = 1); /* MS-DOS Kermit */r       default: return(-2);     }[   #ifndef NOSCRIPT  case XYSCRI:				/* SET SCRIPT */@     if ((y = cmkey(scrtab,1,"","echo",xxstring)) < 0) return(y);     switch (y) {.       case 0: return(success = seton(&secho));       default: return(-2);     }z #endif /* NOSCRIPT */i   default:
     break; }r   #ifndef NOLOCALo
 switch (xx) {a" case XYTERM:				/* SET TERMINAL */     x = settrm();      success = (x > 0) ? 1 : 0;       return(x);   default:
     break; }i #endif /* NOLOCAL */  
 switch (xx) {   + /* SET SEND/RECEIVE protocol parameters. */b  ) case XYRECV: case XYSEND:     return(setsr(xx,rmsflg));.  / #ifndef NOLOCALs #ifdef UNIXe! case XYSESS:				/* SESSION-LOG */ G     if ((x = cmkey(sfttab,nsfttab,"type of file","text",xxstring)) < 0)s       return(x);%     if ((y = cmcfm()) < 0) return(y);(     sessft = x;e     return(success = 1); #endif /* UNIX */t   case XYSPEE:				/* SET SPEED */B     if (network) {< 	printf("\n?Speed cannot be set for network connections\n"); 	return(success = 0);      }i     lp = line;E     sprintf(lp,"Transmission rate for %s in bits per second",ttname);e  8     if ((x = cmkey(spdtab,nspd,line,"",xxstring)) < 0) {* 	if (x == -3) printf("?value required\n"); 	return(x);s     }o%     if ((y = cmcfm()) < 0) return(y);m     if (!local) {=- 	printf("?Sorry, you must SET LINE first\n");N 	return(success = 0);e     })     zz = (long) x * 10L;;     if (zz == 70) zz = 75;		/* (see spdtab[] definition) */ ?     if (ttsspd(x) < 0)  {		/* Call ttsspd with cps, not bps! */l. 	printf("?Unsupported line speed - %ld\n",zz); 	return(success = 0);      } else {& 	speed = ttgspd();		/* Read it back */: 	if (speed != zz)  {		/* Call ttsspd with cps, not bps! */6 	    printf("?SET SPEED fails, speed is %ld\n",speed); 	    return(success = 0);t 	}
 	if (pflag &&0
 #ifndef NOSPLN 	    cmdlvl == 0 #elset 	    tlevel < 0) #endif /* NOSPL */ 	    ) { 	    if (speed == 8880)(* 	      printf("%s, 75/1200 bps\n",ttname);	 	    else , 	      printf("%s, %ld bps\n",ttname,speed); 	} 	return(success = 1);      }L #endif /* NOLOCAL */  x$   case XYXFER:				/* SET TRANSFER */J     if ((y = cmkey(tstab,nts,"","character-set",xxstring)) < 0) return(y);
 #ifdef XFRCANa&     if (y == 0) {			/* CANCELLATION */8 	if ((z = cmkey(onoff,2,"","",xxstring)) < 0) return(z); 	if (z == 0) {			/* OFF */& 	    if ((y = cmcfm()) < 0) return(y); 	    xfrcan = 0;	 	} else {dF 	    if ((y = cmnum("ASCII code for cancellation character","3",10,&x, 			   xxstring)) < 0)g 	      return(y);! 	    if (x > 31 && x != 127) {> 		printf("Cancel character must be in ASCII control range\n");
 		return(-9);  	    }> 	    if ((y = cmnum("How many required to cause cancellation",  			   "2",10,&z, xxstring)) < 0) 	      return(y);C 	    if (z < 2) { * 		printf("Number must be 2 or greater\n");
 		return(-9);( 	    }& 	    if ((y = cmcfm()) < 0) return(y);( 	    xfrcan = 1;			/* CANCELLATION ON */- 	    xfrchr = x;			/* Using this character */a2 	    xfrnum = z;			/* Needing this many of them */ 	} 	return(success = 1); 
     } else #endif /* XFERCAN */ #ifndef NOCSETSn)       if (y == 1) {			/* CHARACTER-SET */eG 	if ((y = cmkey(tcstab,ntcs,"","transparent",xxstring)) < 0) return(y);e" 	if ((x = cmcfm()) < 0) return(x); 	if (rmsflg) {< 	    sstate = setgen('S', "405", tcsinfo[y].designator, ""); 	    return((int) sstate);	 	} else {tD 	    tslevel = (y == TC_TRANSP) ? 0 : 1; /* transfer syntax level */0 	    tcharset = y;		/* transfer character set */ 	    return(success = 1);i 	}
     } else #endif /* NOCSETS */)       if (y == 2) {			/* LOCKING-SHIFT */v3 	  if ((y = cmkey(lstab,nls,"","on",xxstring)) < 0)u 	    return(y);b$ 	  if ((x = cmcfm()) < 0) return(x);5 	  lscapr = (y == 1) ? 1 : 0;	/* ON: requested = 1 */f5 	  lscapu = (y == 2) ? 2 : 0;	/* FORCED:  used = 1 */  	  return(success = 1);i       } else return(-2);   #ifndef NOXMIT$   case XYXMIT:				/* SET TRANSMIT */     return(setxmit()); #endif /* NOXMIT */,   #ifndef NOCSETS;-   case XYUNCS:				/* UNKNOWN-CHARACTER-SET */yC     if ((y = cmkey(ifdtab,2,"","discard",xxstring)) < 0) return(y); %     if ((x = cmcfm()) < 0) return(x);(     unkcs = y;     return(success = 1); #endif /* NOCSETS */   #ifndef NOPUSH #ifdef UNIX *   case XYWILD:				/* WILDCARD-EXPANSION */M     if ((y = cmkey(wildtab,2,"who expands wildcards","kermit",xxstring)) < 0)c       return(y);%     if ((x = cmcfm()) < 0) return(x);(     wildxpand = y;     return(success = 1); #endif /* UNIX */l #endif /* NOPUSH */   $   case XYWIND:				/* WINDOW-SLOTS */L     y = cmnum("Number of sliding-window slots, 1 to 32","1",10,&x,xxstring);     y = setnum(&z,x,y,MAXWS);4     if (y < 0) return(y);(     if (z < 1) z = 1;l #ifdef COMMENTI     /* This is taken care of automatically now in protocol negotiation */      if (maxtry < z) {e9 	printf("?Window slots must be less than retry limit\n");" 	return(success = 0);)     }( #endif /* COMMENT */0     if (rmsflg) {			/* Set remote window size */. 	wslotr = z;			/* Set local window size too */
 	tp = tmpbuf;( 	sprintf(tp,"%d",z);% 	sstate = setgen('S', "406", tp, "");  	return((int) sstate);     }e.     wslotr = z;				/* Set local window size */F     swcapr = (wslotr > 1) ? 1 : 0;	/* Set window bit in capas word? */.     if (wslotr > 1) {			/* Window size > 1? */C 	y = adjpkl(urpsiz,wslotr,bigrbsiz); /* Maybe adjust packet size */E) 	if (y != urpsiz) {		/* Did it change? */t 	    urpsiz = y; 	    if (msgflg) 	    printf(? " Adjusting receive packet-length to %d for %d window slots\n",n 		   urpsiz, wslotr);  	}     }c     return(success = 1);  
 #ifndef NOSPLM1   case XYOUTP:				/* OUTPUT command parameters */LA     if ((y = cmkey(outptab,1,"OUTPUT command parameter","pacing",  		   xxstring)) < 0)       return(y);(     switch(y) {				/* Which parameter */       case 0:				/* PACING */ G 	y = cmnum("Milliseconds to pause between each OUTPUT character","100",s 		  10,&x,xxstring);< 	y = setnum(&z,x,y,16383);	/* Verify and get confirmation */ 	if (y < 0) return(y);+ 	if (z < 0) z = 0;		/* (save some space) */t 	pacing = z; 	return(success = 1);    s*       default:				/* (shouldn't happen) */ 	return(-2);     }( #endif /* NOSPL */   #ifdef CK_SPEEDn   case XYQCTL: {
     short *p;      int zz;0D     if ((z = cmkey(ctltab,2, "control-character prefixing option","" 		   ,xxstring)) < 0)          return(z);  @     /* Make space for a temporary copy of the prefixing table */  -     p = (short *)malloc(256 * sizeof(short));P
     if (!p) {,. 	printf("?Internal error - malloc failure\n"); 	return(-9);     })F     for (i = 0; i < 256; i++) p[i] = ctlp[i]; /* Copy current table */       switch(z) {b3       case 0:				/* UNPREFIXED control character */u1       case 1:				/* PREFIXED control character */e- 	while (1) {		/* Collect a list of numbers */: 	    if ((x = cmnum((z == 0) ?E "\n Numeric ASCII value of control character that needs NO prefix,\n\/@  or the word \"all\", or carriage return to complete the list" :F "\n Numeric ASCII value of control character that MUST BE prefixed,\n\?  or the word \"all\", or carriage return to complete the list",) 			   "",10,&y,xxstring! 			   )) < 0) {  		if (x == -3)
 		  break; 		if (x == -2) { 		    if (p) free(p);)0 		    debug(F110,"SET CONTROL atmbuf",atmbuf,0);& 		    if (!xxstrcmp(atmbuf,"all",3) || 			!xxstrcmp(atmbuf,"al",2) || 			!xxstrcmp(atmbuf,"a",1)) { 0 			if ((x = cmcfm()) < 0) /* Get confirmation */ 			  return(x);c* 			/* Set all values, but don't touch 0 */( 			for (y = 1; y < 32; y++) ctlp[y] = z;+ 			for (y = 127; y < 160; y++) ctlp[y] = z;) 			ctlp[255] = z;C# 			/* Watch out for XON and XOFF */S$ 			if (flow == FLO_XONX && z == 0) { 			    if (msgflg) { 				printf( 9 " XON/XOFF characters 17, 19, 145, 147 not affected.\n");c 				printf(/ #ifdef CK_RTSCTSF " SET FLOW NONE or RTS/CTS to transmit these characters unprefixed.\n" #elseL; " SET FLOW NONE to transmit these characters unprefixed.\n"e #endif /* CK_RTSCTS */
 				       );  			    } 			    ctlp[XON] = 			      ctlp[XOFF] =	 				ctlp[XON+128] =/ 				  ctlp[XOFF+128] = 1;( 			}
 #ifdef TNCODE	! 			/* Watch out for TELNET IAC */ 6 			if (network && (ttnproto == NP_TELNET) && z == 0) { 			    ctlp[255] = 1;x9 			    if (parity == 'e' || parity == 'm') ctlp[127] = 1;0 			    ctlp[13] = 1; 			    if (msgflg) 			      printf(9 			       " TELNET IAC = 255, CR = 13, not affected.\n");  			} #endif /* TNCODE */  			return(success = 1);  		    } else {8 			printf("?Please specify a number or the word ALL\n"); 			return(-9); 		    }l
 		} else { 		    if (p) free(p);r 		    return(x); 		}t 	    } 	    zz = 1 - z;? 	    if ((y >  31 && y < 127) ||	/* A specific numeric value */o8 		(y > 159 && y < 255) ||	/* Check that it is a valid */" 		(y < zz) ||		/* control code. */ 		(y > 255)) {: 		printf("?Values allowed are: %d-31, 127-159, 255\n",zz); 		if (p) free(p); 
 		return(-9);s 	    }( 	    x = y & 127;		/* Get 7-bit value */< 	    if ((z == 0) &&		/* If they are saying it is safe... */1 		(y == 0	||		/* NUL = string terminator isn't */O; 		 ((flow == FLO_XONX) &&	/* If flow control is Xon/Xoff */X= 		  (x == XON || x == XOFF)) /* XON & XOFF chars not safe. */r 		 )) {)
 		if (msgflg)38 		  printf("Sorry, not while Xon/Xoff is in effect.\n"); 		if (p) free(p);t
 		return(-9);) 	    }' 	    p[y] = z;			/* All OK, set flag */) 	}				/* End of while loop */= /*L   Get here only if they have made no mistakes.  Copy temporary table back toC   permanent one, then free temporary table and return successfully.  */* 	for (i = 0; i < 256; i++) ctlp[i] = p[i]; 	if (p) free(p); 	return(success = 1);r       default: 	return(-2);     }e }n #endif /* CK_SPEED *//     case XYREPT:N     if ((y = cmkey(rpttab,2,"repeat-count compression parameter","",xxstring)) 	< 0),       return(y);     switch(y) {(
       case 0: @ 	return(success = seton(&rptena)); /* REPEAT COUNTS = ON, OFF */,       case 1:				/* REPEAT MININUM number */4 	printf("(not implemented yet, nothing happens)\n"); 	return(-9);)       case 2:				/* REPEAT PREFIX char */ 6 	if ((x = cmnum("ASCII value","",10,&z,xxstring)) < 0)
 	  return(x); " 	if ((x = cmcfm()) < 0) return(x);1 	if ((z > 32 && z < 63) || (z > 95 && z < 127)) {i; 	    if (y == 1) rptmin = (CHAR) z; else myrptq = (CHAR) z;  	    return(success = 1); 	 	} else {a5 	    printf("?Illegal value for prefix character\n");s 	    return(-9); 	}     }e   default:%     if ((x = cmcfm()) < 0) return(x);s,     printf("Not working yet - %s\n",cmdbuf);     return(success = 0);     }x }a   #ifdef CK_TTYFDi extern int ttyfd;e #endif /* CK_TTYFD */    extern struct keytab yesno[];  extern int nyesno;   into6 hupok(x) int x; {			/* Returns 1 if OK, 0 if not OK */     int y, z = 1; 8     if (local && xitwarn) {		/* Is a connection open? */ 	int needwarn = 0; 	if (i #ifdef NETCONN 	    network #elset 	    0 #endif /* NETCONN */ 	    ) {		/* Network? */ #ifdef CK_TTYFD* 	    if (ttyfd > -1) #endif /* CK_TTYFD */  	      needwarn = 1; 	    if (needwarn) 	      printf(7 " A network connection to %s might still be active.\n",O
 		     ttname*	 		     );l# 	} else {			/* Serial connection */o2 	    if (carrier == CAR_OFF)	/* SET CARRIER OFF */; 	      needwarn = 0;		/* so we don't care about carrier. */cD 	    else if ((y = ttgmdm()) > 0) /* Otherwise, get modem signals */7 	      needwarn = (y & BM_DCD);	/* Check for carrier */ 2 	    else			/* If we can't get modem signals... */ 	      needwarn =f #ifdef CK_TTYFD / 		(ttyfd > -1)		/* check tty file descriptor */c #elseF- 		  1			/* or can't check ttyfd, then warn */1 #endif /* CK_TTYFD */  		    ;u 	    if (needwarn) 	      printf(6 " A serial connection might still be active on %s.\n",
 		     ttname 	 		     );( 	}  = /* If a warning was issued, get user's permission to EXIT. */s   	if (needwarn) {
 #ifdef VMS /*B   In VMS, whenever a TAKE file or macro is active, we restore the @   original console modes so Ctrl-C/Ctrl-Y can work.  But here we@   go interactive again, so we have to temporarily put them back. */ 	    if (cmdlvl > 0) 	      concb((char)escape);i #endif /* VMS */       1 	    cmsavp(psave,PROMPTL);	/* Save old prompt */"H 	    cmsetp(x ? "OK to close? " : "OK to exit? "); /* Make new prompt */, 	    z = 0;			/* Initialize answer to No. */- 	    cmini(ckxech);		/* Initialize parser. */a	 	    do {($ 		prompt(NULL);		/* Issue prompt. */9 		y = cmkey(yesno,nyesno,"","",NULL); /* Get Yes or No */= 		if (y < 0) {$ 		    if (y == -3) 	/* No answer? */. 		      printf(" Please respond Yes or No\n"); 		    cmini(ckxech);
 		} else { 		    z = y;		/* Save answer */ ) 		    y = cmcfm();	/* Get confirmation */h 		}e/ 	    } while (y < 0);		/* Continue till done */e. 	    cmsetp(psave);		/* Restore real prompt */
 #ifdef VMS8 	    if (cmdlvl > 0)		/* In VMS and not at top level, */0 	      conres();			/*  restore console again. */ #endif /* VMS */ 	}     }o     return(z); }o   VOID* shoctl() {				/* SHOW CONTROL-PREFIXING */ #ifdef CK_SPEEDe
     int i;     printf( G "\ncontrol quote = %d, applied to (0 = unprefixed, 1 = prefixed):\n\n",b 	   myctlq);     for (i = 0; i < 16; i++) {< 	printf("  %3d: %d   %3d: %d ",i,ctlp[i], i+16, ctlp[i+16]);
 	if (i == 15)s! 	  printf("  127: %d",ctlp[127]);  	elsea 	  printf("        ");F 	printf("  %3d: %d   %3d: %d ",i+128,ctlp[i+128], i+144, ctlp[i+144]);- 	if (i == 15)  printf("  255: %d",ctlp[255]);n 	printf("\n");     }a     printf("\n");e #endif /* CK_SPEED */i }s   #ifndef NOPUSH #ifdef CK_REXX /*H   Rexx command.  Note, this is not OS/2-specific, because Rexx also runs<   on other systems where C-Kermit also runs, like the Amiga. */5 #define REXBUFL 100			/* Change this if neccessary */gD char rexxbuf[REXBUFL] = { '\0' };	/* Rexx's return value (string) */   intu
 dorexx() {
     int x, y;	     char *rexxcmd;  > 	if ((x = cmtxt("Rexx command","",&rexxcmd,xxstring)) < 0)    
 	  return(x);t 	strcpy(line,rexxcmd); 	rexxcmd = line;
 #ifdef OS2* 	return(os2rexx(rexxcmd,rexxbuf,REXBUFL)); #else /* !OS2 */% 	printf("Sorry, nothing happens.\n");; 	return(success = 0);	 #endif /* OS2 */ }/ #endif /* CK_REXX */ #endif /* NOPUSH */  #endif /* NOICP */