O /*  C K U U S 2  --  User interface strings & help text module for C-Kermit  */     /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */    /*N  This module separates long strings from the body of the other ckuus* modules. */   #include "ckcsym.h"  #include "ckcdeb.h"  #include "ckcnet.h"  #include "ckcasc.h"  #include "ckcker.h"  #include "ckuusr.h"  #include "ckcxla.h"     extern xx_strp xxstring; extern char *ccntab[];  
 #ifndef NOICP  #ifdef DCMDBUF extern char *cmdbuf; #else  extern char cmdbuf[];  #endif /* DCMDBUF */ #endif /* NOICP */   #ifdef DEBUG extern char debfil[];  #endif /* DEBUG */ #ifdef TLOG  extern char trafil[];  #endif   extern char *xarg0; 4 extern int nrmt, nprm, dfloc, local, parity, escape; extern int turn, flow;% extern int binary, warn, quiet, keep;  extern int success; 0 extern int tt_rows, tt_cols, cmd_rows, cmd_cols;   extern long speed;% extern char *dftty, *versio, *ckxsys;  extern struct keytab prmtab[]; extern struct keytab remcmd[];   5 /* Command-Line help (Unix command-line arguments) */    #ifndef NOCMDL static char *hlp1[] = {
 #ifndef NOICP 9 " [cmdfile] [-x arg [-x arg]...[-yyy]..] [ = text ] ]\n",  #else ! "[-x arg [-x arg]...[-yyy]..]\n",  #endif /* NOICP */L "  -x is an option requiring an argument, -y an option with no argument.\n",. #ifdef COMMENT /* No room for this any more */
 #ifndef NOICP 
 #ifndef NOSPL I "     = means ignore following words, but place them in array \\&@[].\n",  #else , "     = means ignore following material.\n", #endif /* NOSPL */ #else , "     = means ignore following material.\n", #endif /* NOICP */ #endif /* COMMENT */
 "actions:\n", @ "  -s files  send files                    -r  receive files\n",J "  -s -      send from stdin               -k  receive files to stdout\n", #ifndef NOSERVERG "  -x        enter server mode             -f  finish remote server\n",  #else % "  -f        finish remote server\n",  #endif /* NOSERVER */ ? "  -g files  get remote files from server (quote wildcards)\n", : "  -a name   alternate file name, used with -s, -r, -g\n", #ifndef NOLOCAL D "  -c        connect (before file transfer), used with -l and -b\n",C "  -n        connect (after file transfer), used with -l and -b\n",  #endif /* NOLOCAL */ "settings:\n", #ifndef NOLOCAL M "  -l dev    communication line device     -q  quiet during file transfer\n",  #ifdef NETCONNG "  -j host   network host name             -i  binary file transfer\n",  #else % "  -i        binary file transfer\n",  #endif /* NETCONN */M "  -b bps    line speed, e.g. 19200        -t  half duplex, xon handshake\n",  #else % "  -i        binary file transfer\n",  #endif /* NOLOCAL */ #ifdef DEBUGN "  -p x      parity, x = e,o,m,s, or n     -d  log debug info to debug.log\n", #else * "  -p x      parity, x = e,o,m,s, or n\n", #endif /* DEBUG */
 #ifndef NOICP ? "  -y name   alternate init file name      -Y  no init file\n",  #else  #endif /* NOICP */C "  -e n      receive packet length         -w  write over files\n",  #ifdef UNIX C "  -v n      sliding window slots          -z  force foreground\n",  #else % "  -v n      sliding window slots\n",  #endif /* UNIX */  #ifndef NODIALG "  -m name   modem type                    -R  remote-only advisory\n",  #endif /* NODIAL */  /*8   If all this stuff is defined, we run off the screen... */ #ifdef CK_NETBIOS ' "  -N n      NetBIOS adapter number\n",  #endif /* CK_NETBIOS */ 
 #ifdef ANYX25 ? " -o index   X.25 closed user group call   -X  X.25 address\n", K " -U string  X.25 call user data           -u  X.25 reverse charge call\n", 5 " -Z n       X.25 connection open file descriptor\n",  #endif /* ANYX25 */ 
 #ifndef NOSPL  "other:\n", K "  -C \"command, command, ...\"  (interactive-mode commands to execute)\n", H "   =  means ignore following words, but place them in array \\&@[].\n", #else ' "   =  means ignore following text.\n",  #endif /* NOSPL */ #ifdef NOICP, "Operation by command-line options only.\n", #else J "If no action command is included, or -S is, enter interactive dialog.\n", #endif /* NOICP */ "" };    /*  U S A G E */    VOID	 usage() { 
 #ifndef MINIX      conol("Usage: ");      conol(xarg0);      conola(hlp1);  #else      conol("Usage: ");      conol(xarg0); /     conol(" [-x arg [-x arg]...[-yyy]..] ]\n");  #endif /* MINIX */ }  #endif /* NOCMDL */   
 #ifndef NOICP     /*  Interactive help strings  */    static char *tophlp[] = { = "Trustees of Columbia University in the City of New York.\n",    #ifndef NOHELP7 "  Type INTRO   for a brief introduction to C-Kermit.", 8 "  Type VERSION for version and copyright information.",O "  Type HELP    followed by a command name for help about a specific command.", . "  Type NEWS    for news about new features.",. "  Type BUG     to learn how to report bugs.",N "  Press ?      (question mark) at the prompt, or anywhere within a command,",F "               for a menu (context-sensitive help, menu on demand).", #else O "Press ? for a list of commands; see documentation for detailed descriptions.",  #endif /* NOHELP */    #ifndef NOCMDL
 #ifdef OS2 "\n\O   From system level, type \"ckermit -h\" for help about command-line options.",  #else  "\n\N   From system level, type \"kermit -h\" for help about command-line options.", #endif /* OS2 */ #endif /* NOCMDL */  " ",
 #ifdef MACL "Documentation for Command Window: \"Using C-Kermit\" by Frank da Cruz and",M "Christine M. Gianone, Digital Press, 1993, ISBN: 1-55558-108-0.  To order,", + "call +1 212 854-3703 or +1 800 366-2665.",  #else O "DOCUMENTATION: \"Using C-Kermit\" by Frank da Cruz and Christine M. Gianone,", N "Digital Press / Butterworth-Heinemann, 1993, ISBN 1-55558-108-0.  To order,",O "call +1 212 854-3703 or +1 800 366-2665.  Please purchase the documentation.", M "It teaches you how to use C-Kermit and answers your questions; sales are a", 3 "primary source of funding for the Kermit effort.",  #endif /* MAC */ " ",
 #ifdef OS2D "Also view the CKERMIT.INF file for updates on the new features in",I "versions 5A(189) and 5A(190).  Use the OS/2 VIEW program for this, or",  ( "type UPDATES at the C-Kermit> prompt.", #else 
 #ifdef MACJ "Also see the Mac Kermit Doc and Bwr files on the Mac Kermit diskette.\n", #else 
 #ifdef HPUX10 O "See /usr/share/lib/kermit/ckcker.upd for new features in edits 189 and 190.",   #else F "Also see the file CKCKER.UPD for new features in edits 189 and 190.", #endif /* HPUX10 */  #endif /* MAC */ #endif /* OS2 */ "" };   #ifndef NOHELP   char *newstxt[] = { 
 #ifdef OS2N "Numerous features have been added to OS/2 C-Kermit since \"Using C-Kermit\"",# "was published.  These include:\n",  #ifdef CK_NETBIOS > " . New networking support: TCP/IP, NETBIOS, and Named Pipes", #else 4 " . New networking support: TCP/IP and Named Pipes", #endif /* CK_NETBIOS */ ' " . VT220 and ANSI terminal emulation", > " . A completely new and more flexible method of key mapping",4 " . A compose key for entering accented characters", #ifdef OS2MOUSE H " . Mouse actions in the terminal screeen: cursor motion, copy & paste", #endif /* OS2MOUSE */  " . Hebrew terminal emulation", > " . Binary-mode file transfer recovery from point of failure",) " . Auto download and upload capability", < " . Control-character unprefixing for faster file transfer",2 " . OS/2 Extended Attribute and Longname support", " . REXX programming support", " . Command retry and recall",6 " . New functions and variables, new IF conditions\n",O "and much more.  All the changes and new features are fully documented in the", G "CKERMIT.INF file which you can click on or browse with the OS/2 VIEW \ 
 command.", #else  #ifdef HPUX M "Numerous features have been added to C-Kermit since \"Using C-Kermit\" was", F "published.  These include file transfer recovery, control-character",K "unprefixing for faster file transfer, HP-Roman8 and Hebrew character-set", M "support, new functions and variables, new IF conditions, command retry and", I "recall, a new interface to external protocols, and much more.  All the", M "changes and new features are fully documented in the C-Kermit Update file,", 
 #ifdef HPUX10 $ "/usr/share/lib/kermit/ckcker.upd.", #else 1 "ckcker.upd, that is distributed with C-Kermit.",  #endif /* HPUX10 */  #else M "Numerous features have been added to C-Kermit since \"Using C-Kermit\" was", F "published.  These include file transfer recovery, control-character",J "unprefixing for faster file transfer, Hebrew character-set support, new",N "functions and variables, new IF conditions, command retry and recall, a new",K "interface to external protocols, and much more.  All the changes and new", N "features are fully documented in the file CKCKER.UPD (C-Kermit Update) that",& "is distributed along with C-Kermit.", #endif /* HPUX */  #endif /* OS2 */ "" }; #endif /* NOHELP */    #ifndef NOHELP char *introtxt[] = {
 #ifdef OS28 "Welcome to OS/2 C-Kermit communications software for:", #else  #ifdef UNIX  #ifdef HPUX 9 "Welcome to HP-UX C-Kermit communications software for:",  #else 8 "Welcome to UNIX C-Kermit communications software for:", #endif /* HPUX */  #else 
 #ifdef VMS7 "Welcome to VMS C-Kermit communications software for:",  #else 
 #ifdef VOS7 "Welcome to VOS C-Kermit communications software for:",  #else 
 #ifdef MAC5 "Welcome to Mac Kermit communications software for:",  #else 3 "Welcome to C-Kermit communications software for:",  #endif /* MAC */ #endif /* VOS */ #endif /* VMS */ #endif /* UNIX */  #endif /* OS2 */, " . Error-free and efficient file transfer",
 #ifdef OS2< " . VT220, VT102, VT100, VT52, and ANSI terminal emulation", #else 
 #ifdef MAC " . VT220 terminal emulation", #else  " . Terminal connection",  #endif /* MAC */ #endif /* OS2 */
 #ifndef NOSPL  " . Script programming", #endif /* NOSPL */
 #ifndef NOICS , " . International character set conversion", #endif /* NOICS */ #ifndef NOLOCAL  "\nSupporting:",+ " . Serial connections, direct or dialed.",  #ifndef NODIAL " . Automatic modem dialing",  #endif /* NODIAL */  #ifdef TCPSOCKET  " . TCP/IP network connections", #endif /* TCPSOCKET */
 #ifdef ANYX25  " . X.25 network connections", #endif /* ANYX25 */ 
 #ifdef OS2
 #ifdef DECNET / " . DECnet/PATHWORKS LAT Ethernet connections",  #endif /* DECNET */  #ifdef NPIPE0 " . LAN Manager named-pipe network connections", #endif /* NPIPE */ #ifdef CK_NETBIOS  " . NETBIOS connections",  #endif /* CK_NETBIOS */  #endif /* OS2 */ #endif /* NOLOCAL */  I "\nWhile typing commands, you may use the following special characters:", M " . DEL, RUBOUT, BACKSPACE, CTRL-H: Delete the most recent character typed.", 1 " . CTRL-W:  Delete the most recent word typed.", ' " . CTRL-U:  Delete the current line.", * " . CTRL-R:  Redisplay the current line.", #ifdef CK_RECALL
 #ifdef OS2M " . \030 or CTRL-B: Command recall - go backwards in command recall buffer.", K " . \031 or CTRL-N: Command recall - go forward in command recall buffer.",  #else F " . CTRL-P:  Command recall - go backwards in command recall buffer.",/ " . CTRL-B:  Command recall - same as Ctrl-P.", D " . CTRL-N:  Command recall - go forward in command recall buffer.", #endif /* OS2 */ #endif /* CK_RECALL */L " . ?        (question mark) Display a menu for the current command field.",> " . ESC      (or TAB) Attempt to complete the current field.",E " . \\        (backslash) include the following character literally", 
 #ifndef NOSPL D "            or introduce a backslash code, variable, or function.", #else 5 "            or introduce a numeric backslash code.",  #endif /* NOSPL */L "  Command words other than filenames can be abbreviated in most contexts.",   "\nBasic C-Kermit commands:", % "  EXIT          exit from C-Kermit", ' "  HELP          request general help", 7 "  HELP command  request help about the given command", / "  TAKE          execute commands from a file",     "\nCommands for file transfer:", "  SEND          send files",  #ifdef CK_RESEND7 "  RESEND        recover an interrupted file transfer",  #endif /* CK_RESEND */  "  RECEIVE       receive files", #ifndef NOSERVER, "  SERVER        be a file transfer server", #endif /* NOSERVER */    "\nImportant settings:",( "  SET PARITY    communications parity", #ifdef CK_RTSCTS? "  SET FLOW      communications flow control, such as RTS/CTS",  #else @ "  SET FLOW      communications flow control, such as XON/XOFF", #endif /* CK_RTSCTS */F "  SET FILE      file settings, for example TYPE TEXT or TYPE BINARY",   #ifndef NOLOCAL ( "\nTo make a direct serial connection:",
 #ifdef OS2= "  SET PORT      select serial communication port or server",  #else 5 "  SET LINE      select serial communication device",  #endif /* OS2 */- "  SET SPEED     select communication speed", , "  CONNECT       begin terminal connection",   #ifndef NODIAL "\nTo dial out with a modem:",$ "  SET MODEM     select modem type",
 #ifdef OS2= "  SET PORT      select serial communication port or server",  #else 5 "  SET LINE      select serial communication device",  #endif /* OS2 */- "  SET SPEED     select communication speed", ( "  DIAL          dial the phone number",, "  CONNECT       begin terminal connection", #endif /* NODIAL */    #ifdef NETCONN" "\nTo make a network connection:",& "  SET NETWORK   select network type",& "  SET HOST      select network host",, "  CONNECT       begin terminal connection",
 #ifdef TNCODE 9 "  TELNET        select a TCP/IP host and CONNECT to it",  #endif /* TNCODE */  #endif /* NETCONN */  A "\nTo return from a terminal connection to the C-Kermit prompt:", 
 #ifdef OS2 "  \M Press the key or key-combination shown after \"Prompt:\" in the status line", L "  (such as Alt-x) or type your escape character followed by the letter C.", #else 9 "  Type your escape character followed by the letter C.",  #endif /* OS2 */  & "\nTo display your escape character:", "  SHOW ESCAPE", "\nTo display other settings:", G "  SHOW COMMUNICATIONS, SHOW TERMINAL, SHOW FILE, SHOW PROTOCOL, etc.",  #else  /* !NOLOCAL */  "\nTo display settings:", G "  SHOW COMMUNICATIONS, SHOW TERMINAL, SHOW FILE, SHOW PROTOCOL, etc.",  #endif /* NOLOCAL */  "\nTo speed up file transfers:",4 "  SET RECEIVE PACKET-LENGTH  (use bigger packets)",5 "  SET WINDOW                 (use sliding windows)", ; "  SET CONTROL UNPREFIX       (reduce prefixing overhead)",   G "\nFor further information about a particular command, type HELP xxx,", H "where xxx is the name of the command.  For documentation, news of new",D "releases, and information about other Kermit software, contact:\n",' "  Kermit Distribution        E-mail:", > "  Columbia University        kermit@columbia.edu (Internet)",? "  612 West 115th Street      KERMIT@CUVMA (BITNET/EARN/CREN)",  "  New York, NY  10025  USA", 4 "  Phone: +1 212 854-3703     Fax: +1 212 663-8202", "" };  & static char *hmxxbye = "Syntax: BYE\n\. Shut down and log out a remote Kermit server";    static char *hmxxclo[] = { "Syntax:  CLOSE name", "Example: CLOSE PACKET\n",, "Close one of the following logs or files:", #ifndef NOLOCAL  "  SESSION", #endif /* NOLOCAL */ #ifdef TLOG  "  TRANSACTION", #endif /* TLOG */  "  PACKET",  #ifdef DEBUG "  DEBUGGING", #endif /* DEBUG */
 #ifndef NOSPL 	 "  READ", 
 "  WRITE", #endif /* NOSPL */6 "Type HELP LOG and HELP OPEN for further info.", "" };    #ifdef CK_MINPUT static char *hmxxminp[] = { 4 "Syntax:  MINPUT n [ string1 [ string2 [ ... ] ] ]",A "Example: MINPUT 5 Login: {Username: } {NO CARRIER} BUSY RING\n", H "For use in script programs.  Waits up to n seconds for any one of the",O "strings to arrive on the communication device.  If no strings are given, the",rN "command waits for any character at all to arrive.  Strings are separated by",M "spaces; use { braces } for grouping.  If any of the strings is encountered", H "within the timeout interval, the command succeeds and the \\v(minput)",N "variable is set to the number of the string that was matched: 1, 2, 3, etc.",D "If none of the strings arrives, the command times out, fails, and", "\\v(minput) is set to 0.\n",c' "Also see: INPUT, REINPUT, SET INPUT.",e "" };m #endif /* CK_MINPUT */   #ifndef NOLOCALsA static char *hmxxcon[] = { "Syntax: CONNECT (or C) [/QUIETLY]\n",pM "Connect to a remote computer via the serial communications device given in", M "the most recent SET LINE command, or to the network host named in the most",iK "recent SET HOST command.  Type the escape character followed by C to get",iK "back to the C-Kermit prompt, or followed by ? for a list of CONNECT-mode",k
 #ifdef OS2K "escape commands.  In OS/2 C-Kermit, you can also assign the \\Kexit verb",cJ "to the key or key-combination of your choice; by default it is assigned", "to Alt-x.", #elsef "escape commands.",UK "\nInclude the /QUIETLY switch to suppress the informational message that",E% "tells you how to escape back, etc.",l #endif /* OS2 */ "" };a #endif /* NOLOCAL */  m/ static char *hmxxget = "Syntax: GET filespec\n\tA Tell the remote Kermit server to send the named file or files.\n\cG If the filespec is omitted, then you are prompted for the remote and\n\p local filenames separately.";i  H static char *hmxxlg[] = { "Syntax: LOG (or L) name [ { NEW, APPEND } ]",& "Record information in a log file:\n", #ifdef DEBUGO "DEBUGGING     Debugging information, to help track down bugs in the C-Kermit",-; "              program (default log name is debug.log).\n",g #endif /* DEBUG */L "PACKETS       Kermit packets, to help with protocol problems (packet.log)", #ifndef NOLOCALmG "SESSION       Terminal session, during CONNECT command (session.log)",  #endif /* NOLOCAL */ #ifdef TLOGeN "TRANSACTIONS  Names and statistics about files transferred (transact.log)\n", #endif /* TLOG */rO "If you include the APPEND keyword after the filename, the existing log file,",,; "if any, is appended to; otherwise a new file is created.",  "" } ;  s #ifndef NOSCRIPT static char *hmxxlogi[] = { "\ Syntax: SCRIPT text\n",sF "Login to a remote system using the text provided.  The login script",> "is intended to operate similarly to uucp \"L.sys\" entries.",. "A login script is a sequence of the form:\n",& "  expect send [expect send] . . .\n",M "where 'expect' is a prompt or message to be issued by the remote site, and",eJ "'send' is the names, numbers, etc, to return.  The send may also be the",O "keyword EOT, to send control-d, or BREAK (or \\\\b), to send a break signal.",eO "Letters in send may be prefixed by ~ to send special characters.  These are:",eD "~b backspace, ~s space, ~q '?', ~n linefeed, ~r return, ~c don\'t",H "append a return, and ~o[o[o]] for octal of a character.  As with some",K "uucp systems, sent strings are followed by ~r unless they end with ~c.\n",eI "Only the last 7 characters in each expect are matched.  A null expect,", G "e.g. ~0 or two adjacent dashes, causes a short delay.  If you expect",eH "that a sequence might not arrive, as with uucp, conditional sequences"," "may be expressed in the form:\n",& "  -send-expect[-send-expect[...]]\n",H "where dashed sequences are followed as long as previous expects fail.", "" };a #endif  e@ static char *hmxxrc[] = { "Syntax: RECEIVE (or R) [filespec]\n",I "Wait for a file to arrive from the other Kermit, which must be given a",II "SEND command.  If the optional filespec is given, the (first) incoming",eI "file will be stored under that name, otherwise it will be stored under",O #ifndef CK_TMPDIRm "the name it arrives with.", #elset
 #ifdef OS2N "the name it arrives with.  If the filespec denotes a disk and/or directory,",3 "the incoming file or files will be stored there.",t #elseaF "the name it arrives with.  If the filespec denotes a directory, the",; "incoming file or files will be placed in that directory.",r #endif /* OS2 */ #endif /* CK_TMPDIR */ "" } ;  h static char *hmxxsen = "\ ( Syntax: SEND (or S) filespec [name]\n\n\0 Send the file or files specified by filespec.\n\I filespec may contain wildcard characters '*' or '?'.  If no wildcards,\n\\K then 'name' may be used to specify the name 'filespec' is sent under; if\n\,9 'name' is omitted, the file is sent under its own name.";/  O #ifndef NORESEND static char *hmxxrsen = "\# Syntax: RESEND filespec [name]\n\n\aE Resend the file or files, whose previous transfer was interrupted.\n\dK Picks up from where previous transfer left off, IF the receiver was told\n\IF to SET FILE INCOMPLETE KEEP.  Only works for binary-mode transfers.\n\6 Requires the other Kermit to have RESEND capability.";   static char *hmxxpsen = "\+ Syntax: PSEND filespec position [name]\n\n\/L Just like SEND, except sends the file starting at the given byte position."; #endif /* NORESEND */    #ifndef NOMSENDi static char *hmssmse = "\ 0 Syntax: MSEND filespec [ filespec [ ... ] ]\n\n\K Send the files specified by the filespecs.  One or more filespecs may be\n\yK listed, separated by spaces.  Any or all filespecs may contain wildcards\n\uO and they may be in different directories.  An alternate name cannot be given.";  #endif /* NOMSEND */   #ifndef NOSERVER+ static char *hmxxser = "Syntax: SERVER\n\n\oJ Enter server mode on the currently selected line.  All further commands\n\J will be taken in packet form from the other Kermit program.  Use FINISH\n\, or BYE to get C-Kermit out of server mode."; #endif /* NOSERVER */n    static char *hmhset[] = { "\D The SET command is used to establish various communication or file",E "parameters.  The SHOW command can be used to display the values of",aD "SET parameters.  Help is available for each individual parameter;",+ "type HELP SET ? to see what's available.",W "" } ;  i #ifndef NOSETKEY static char *hmhskey[] = { "Syntax: SET KEY k text",s "Or:     SET KEY CLEAR\n",I "Configure the key whose \"scan code\" is k to send the given text when",MG "pressed during CONNECT mode.  SET KEY CLEAR restores all the default", N "key mappings.  If there is no text, the default key binding is restored for", #ifndef NOCSETS4H "the key k.  SET KEY mappings take place before terminal character-set", "translation.",e #elsei
 "the key k.",o #endif /* NOCSETS */
 #ifdef OS2J "\nThe text may contain \"\\Kverbs\" to denote actions, to stand for DEC",L "keypad, function, or editing keys, etc.  For a list of available keyboard", "verbs, type SHOW KVERBS.",0 #endif /* OS2 */H "\nTo find out the scan code and mapping for a particular key, use the", "SHOW KEY command.", ""}; #endif /* NOSETKEY */B  = static char *hmxychkt[] = { "Syntax: SET BLOCK-CHECK type\n", I "Type of packet block check to be used for error detection, 1, 2, 3, or",.M "BLANK-FREE-2.  Type 1 is standard, and catches most errors.  Types 2 and 3",9F "specify more rigorous checking at the cost of higher overhead.  The",K "BLANK-FREE-2 type is the same as Type 2, but is guaranteed to contain no", 
 "blanks.", "" } ;  r #ifdef CK_SPEED  static char *hmxyqctl[] = { N "Syntax: SET CONTROL-CHARACTER { PREFIXED, UNPREFIXED } { <code>..., ALL }\n",O "<code> is the numeric ASCII code for a control character 1-31, 127-159, 255.",pN "The word \"ALL\" means the command applies to all characters in this range.",M "\nPREFIXED <code> means the given control character must be converted to a", M " printable character and prefixed, the default for all control characters.",iK "\nUNPREFIXED <code> means you think it is safe to send the given control",wI " character as-is, without a prefix.  USE THIS OPTION AT YOUR OWN RISK!",fG "\nSHOW CONTROL to see current settings.  SET CONTROL PREFIXED ALL is",cI "recommended for safety.  You can include multiple <code> values in one",   "command, separated by spaces.", "" };s #endif /* CK_SPEED */e   #ifndef NODIAL static char *hmxydial[] = {e! "SET DIAL DIAL-COMMAND [ text ]", J "The 'text' replaces C-Kermit's built-in modem dialing command.  It must",G "include '%s' (percent s) as a place-holder for the telephone numbers",mL "given in your DIAL commands.  If the 'text' is omitted, C-Kermit uses its",- "built-in modem-specific dialing command.\n",e "SET DIAL DIRECTORY filename",F "Name of dialing directory file.  Type HELP DIAL for further info.\n", "SET DIAL DISPLAY {ON, OFF}",s7 "Whether to display dialing progress on the screen.\n",o "SET DIAL HANGUP {ON, OFF}",F "Whether the DIAL command should hang up the phone before dialing.\n",  "SET DIAL INIT-STRING [ text ]",M "The 'text' is a replacement for C-Kermit's built-in initialization command",cL "for the modem.  If 'text' omitted, use built-in initialization command.\n"," "SET DIAL KERMIT-SPOOF {ON, OFF}",D "If the selected modem type supports the Kermit protocol directly,",E "use this command to turn its Kermit protocol function on or off.\n", " "SET DIAL MODEM-HANGUP {ON, OFF}",L "Governs how the HANGUP, <esc>H, and similar operations work when you have",I "a dialed connection (in local mode, and a specific modem type is set).", B "ON means to use modem commands to hang up the phone, e.g. ATH0.",A "OFF means to hang up by attempting to turn off the DTR signal.",u9 "ON is not necessarily supported for all modem types.\n",S  "SET DIAL MNP-ENABLE {ON, OFF}",4 "Enable or disable MNP negotiation by the modem.\n", "SET DIAL PREFIX [ text ]",mJ "Establish a prefix to be applied to the phone numbers given in the DIAL",0 "command or read from the dialing directory.\n",$ "SET DIAL SPEED-MATCHING {ON, OFF}",M "ON (the default) means that C-Kermit changes its serial interface speed to",MM "agree with the speed reported by the modem's CONNECT message, if any.  OFF", ? "means that C-Kermit should not change its interface speed.\n",l "SET DIAL TIMEOUT number",L "How many seconds to wait for a dialed call to complete.  Use this command",I "to override the DIAL command's automatic timeout calculation.  A value",XE "of 0 turns off this feature and returns to Kermit's automatic dial",i "timeout calculation.\n", F "Also see DIAL and SET MODEM.  Use SHOW DIAL to display dial-related", "settings.\n", "" } ; #endif /* NODIAL */c  6 static char *hmxyflo[] = { "Syntax: SET FLOW value\n", #ifndef NOLOCALtE "Type of flow control to use during file transfer and CONNECT mode.",h #else 4 "Type of flow control to use during file transfer.", #endif /* NOLOCAL */L "Choices: KEEP (don't change device's current setting), XON/XOFF (software",J "flow control, the default), NONE (no flow control at all), and possibly",L "others including RTS/CTS (hardware) depending on the capabilities of your",> "computer and operating system.  Type SET FLOW ? for a list.", ""};  < static char *hmxyf[] = { "Syntax: SET FILE parameter value", "Parameters:\n",  I "BYTESIZE { 7, 8 }: normally 8.  If 7, truncate the 8th bit of all file \ 
 bytes.\n",   #ifndef NOCSETSeI "CHARACTER-SET: tells the encoding of the local file, ASCII by default.",tH "The names ITALIAN, PORTUGUESE, NORWEGIAN, etc, refer to 7-bit ISO-646",L "national character sets.  LATIN1 is the 8-bit ISO 8859-1 Latin Alphabet 1"," "for Western European languages.",; "NEXT is the 8-bit character set of the NeXT workstation.",RI "The CPnnn sets are for IBM PCs.  MACINTOSH-LATIN is for the Macintosh.",  #ifndef NOLATIN2L "LATIN2 is ISO 8859-2 for Eastern European languages that are written with", "Roman letters.",  #endif /* NOLATIN2 */r #ifdef CYRILLIC K "KOI-CYRILLIC, CYRILLIC-ISO, and CP866 are 8-bit Cyrillic character sets.",B2 "SHORT-KOI is a 7-bit ASCII coding for Cyrillic.", #endif /* CYRILLIC */r
 #ifdef HEBREW N "HEBREW-ISO is ISO 8859-8 Latin/Cyrillic.  CP862 is the Hebrew PC code page.",H "HEBREW-7 is like ASCII with the lowercase letters replaced by Hebrew.", #endif /* HEBREW */l #ifdef KANJIH "JAPANESE-EUC, JIS7-KANJI, DEC-KANJI, and SHIFT-JIS-KANJI are Japanese", "Kanji character sets.", #endif /* KANJI */E "Type SET FILE CHAR ? for a complete list of file character sets.\n",o #endif /* NOCSETS */  K "COLLISION tells what to do when a file arrives that has the same name as",a& "an existing file.  The options are:",K "  BACKUP (default) - Rename the old file to a new, unique name and store",L9 "    the incoming file under the name it was sent with.",t7 "  OVERWRITE - Overwrite (replace) the existing file.",eG "  APPEND - Append the incoming file to the end of the existing file.", 7 "  DISCARD - Refuse and/or discard the incoming file.",c3 "  RENAME - Give the incoming file a unique name.",SL "  UPDATE - Accept the incoming file only if it is newer than the existing", "    file.",' "Example: SET FILE COLLISION UPDATE\n",\  G "SET FILE DISPLAY selects the format of the file transfer display for",_. "local-mode file transfer.  The choices are:",M "  SERIAL (the default).  One dot is printed for every K bytes transferred.", B "    This format works on any kind of terminal, even a hardcopy.",J "  CRT.  Numbers are continuously updated on a single screen line.  This",8 "    format can be used on any video display terminal.", #ifdef CK_CURSESM "  FULLSCREEN.  A fully formatted 24x80 screen showing lots of information.",iI "    This requires a video display terminal whose control sequences are",p "    understood by Kermit.", #endif /* CK_CURSES */. "  NONE.  No file transfer display at all.\n",  F "INCOMPLETE - what to do with an incompletely received file: DISCARD", "(default), or KEEP.\n",  
 #ifdef VMSJ "LABEL { ACL, BACKUP-DATE, NAME, OWNER, PATH } { ON, OFF } - Tells which",C "items to include (ON) or exclude (OFF) in labeled file transfer.",  #else 
 #ifdef OS2E "LABEL { ARCHIVE, READ-ONLY, HIDDEN, SYSTEM, EXTENDED } { ON, OFF }",*O "Tells which items to include (ON) or exclude (OFF) in labeled file transfer.",  #endif /* OS2 */ #endif /* VMS */  M "NAMES are normally CONVERTED to 'common form' during transmission; LITERAL", I "means use filenames literally (useful between like systems).  Also see",E2 "SET SEND PATHNAMES and SET RECEIVE PATHNAMES.\n",  
 #ifdef VMSN "RECORD-LENGTH sets the record length for received files of type BINARY. Use",O "this to receive VMS BACKUP savesets or other fixed-format files. The default", 9 "of 512 is suitable for executable (.EXE) files, etc.\n",p "Example: SET FILE REC 8192\n",b #endif /* VMS */  B "TYPE: How file contents are to be treated during file transfer.",M "TYPE is normally TEXT, with conversion of record format and character set.",AK "BINARY means to do no conversion.  Use BINARY for executable programs or",e1 "binary data.  Example: SET FILE TYPE BINARY.\n",S  
 #ifdef VMSD "For VMS, you may include an optional record-format after the word",9 "BINARY.  This may be FIXED (the default) or UNDEFINED.", N "Two additional VMS file types are also supported: IMAGE and LABELED.  IMAGE",O "means raw block i/o, no interference from RMS, and applies to file transmis-",uO "sion only.  LABELED means to send or interpret RMS attributes with the file.",e "\n",, #endif /* VMS */  J "WARNING.  SET FILE WARNING is superseded by the newer command, SET FILE",M "COLLISION.  SET FILE WARNING ON is equivalent to SET FILE COLLISION RENAME",dL "and SET FILE WARNING OFF is equivalent to SET FILE COLLISION OVERWRITE.\n",   "" };w  r; static char *hmxyhsh[] = { "Syntax: SET HANDSHAKE value\n",1I "Character to use for half duplex line turnaround handshake during file",nN "transfer.  C-Kermit waits for this character from the other computer before",L "sending its next packet.  Default is NONE, others are XON, LF, BELL, ESC,",O "etc.  SET HANDSHAKE CODE <n> lets you specify the numeric ASCII value of the",A6 "handshake character.  Type SET HANDSH ? for a list.", "" };D   #ifndef NOSERVER static char *hsetsrv[] = {"\ SET SERVER DISPLAY {ON,OFF}", H "Tell whether local-mode C-Kermit during server operation should put a",: "file transfer display on the screen.  Default is OFF.\n", "SET SERVER TIMEOUT n",.M "Server command wait timeout interval, how often the C-Kermit server issues", K "a NAK while waiting for a command packet.  Specify 0 for no NAKs at all.",r "Default is 0.", "" };m #endif /* NOSERVER */o   static char *hmhrmt[] = { "\F The REMOTE command is used to send file management instructions to a",L "remote Kermit server.  There should already be a Kermit running in server",J "mode on the other end of the currently selected line.  Type REMOTE ? to",F "see a list of available remote commands.  Type HELP REMOTE x to get",= "further information about a particular remote command 'x'.",o "" } ;  
 #ifndef NOSPLn@ static char *ifhlp[] = { "Syntax: IF [NOT] condition command\n",K "If the condition is (is not) true, do the command.  Only one command may",{N "be given, and it must appear on the same line as the IF.  Conditions are:\n",1 "  SUCCESS     - the previous command succeeded", . "  FAILURE     - the previous command failed",8 "  BACKGROUND  - C-Kermit is running in the background", #ifdef CK_IFRO8 "  FOREGROUND  - C-Kermit is running in the foreground",I "  REMOTE-ONLY - C-Kermit was started with the -R command-line option\n",  #else2: "  FOREGROUND  - C-Kermit is running in the foreground\n", #endif /* CK_IFRO */O "  DEFINED variablename or macroname - The named variable or macro is defined",n #ifdef CK_TMPDIRN "  DIRECTORY string                  - The string is the name of a directory", #endif /* CK_TMPDIR */
 #ifdef ZFCDATSO "  NEWER file1 file2                 - The 1st file is newer than the 2nd one",p #endif /* ZFCDAT */tL "  NUMERIC variable or constant      - The variable or constant is numeric",@ "  EXIST filename                    - The named file exists\n",L "  COUNT   - subtract one from COUNT, execute the command if the result is",2 "            greater than zero (see SET COUNT)\n",G "  EQUAL s1 s2 - s1 and s2 (character strings or variables) are equal",b@ "  LLT s1 s2   - s1 is lexically (alphabetically) less than s2",E "  LGT s1 s1   - s1 is lexically (alphabetically) greater than s2\n",tL "  = n1 n1 - n1 and n2 (numbers or variables containing numbers) are equal",0 "  < n1 n2 - n1 is arithmetically less than n2",5 "  > n1 n2 - n1 is arithmetically greater than n2\n",IO "The IF command may be followed on the next line by an ELSE command. Example:",L  "  IF < \\%x 10 ECHO It's less", "  ELSE echo It's not less\n", "See also XIF.", "" };i  ; static char *hmxxeval[] = {"Syntax: EVALUATE expression\n",}F "Evaluate an integer arithmetic expression and print its value.  The",O "expression can contain numbers and/or numeric-valued variables or functions.",,D "Operators include +-/*(), etc.  Example: EVAL (1+1) * (\\%a / 3).", "" };r #endif /* NOSPL */  
 #ifndef NOSPL  static char *ifxhlp[] = { "\B Syntax: XIF condition { commandlist } [ ELSE { commandlist } ]\n",M "Extended IF command.  The conditions are the same as for IF (type HELP IF)",yN "but multiple comma-separated commands may be grouped within braces in both", M "the IF and ELSE parts.  The ELSE part, if any, must be on the same line as",e; "the XIF (or use dash for line continuation).  Example:\n",eJ "  XIF equal \\%a YES { echo OK, goto begin } ELSE { echo Not OK, stop }", "" };. #endif /* NOSPL */  
 #ifndef NOSPL  static char *forhlp[] = { "\N Syntax: FOR variablename initial-value final-value increment { commandlist }",K "\nFOR loop.  Execute the comma-separated commands in the commandlist the",.I "number of times given by the initial value, final value and increment.",i: "Example:  FOR \\%i 10 1 -1 { pause 1, echo \\%i }", "" };   static char *whihlp[] = { "\) Syntax: WHILE condition { commandlist }",oG "\nWHILE loop.  Execute the comma-separated commands in the bracketed", K "commandlist while the condition is true.  Conditions are the same as for",h "IF commands.",h "" };t #endif /* NOSPL */  
 #ifndef NOSPLe static char *openhlp[] = {  "Syntax:  OPEN mode filename\n",N "For use with READ and WRITE commands.  Open the local file in the specified",M "mode: READ, WRITE, or APPEND.  !READ and !WRITE mean to read from or write",w7 "to a system command rather than a file.  Examples:\n",  "  OPEN READ oofa.txt",e "  OPEN !READ sort foo.bar", "" };t #endif /* NOSPL */  
 #ifndef NOSPLs static char *hxxaskq[] = {( "Syntax:  ASKQ variablename [ prompt ]",$ "Example: ASKQ \\%p { Password:}\n",I "Issues the prompt and defines the variable to be whatever you type in.", : "The characters that you type do not echo on the screen.",G "Use braces to preserve leading and/or trailing spaces in the prompt.",?> "To include a question mark, precede it by backslash (\\).","" };   static char *hxxask[] = {f' "Syntax:  ASK variablename [ prompt ]", / "Example: ASK \\%n { What is your name\\? }\n",tI "Issues the prompt and defines the variable to be whatever you type in.",lG "Use braces to preserve leading and/or trailing spaces in the prompt.",h> "To include a question mark, precede it by backslash (\\).","" };   static char *hxxgetc[] = {( "Syntax:  GETC variablename [ prompt ]",< "Example: GETC \\%c { Type any character to continue...}\n",K "Issues the prompt and sets the variable to the first character you type.",DJ "Use braces to preserve leading and/or trailing spaces in the prompt.", "" }; #endif /* NOSPL */  
 #ifndef NOSPLa static char *hxxdef[] = {S' "Syntax: DEFINE name [ definition ]\n",eN "Defines a macro or variable.  Its value is the definition, taken literally.",F "No expansion or evaluation of the definition is done.  Thus if the", K "definition includes any variable or function references, their names are",nO "included, rather than their values (compare with ASSIGN).  If the definition",E? "is omitted, then the named variable or macro is undefined.\n",l0 "A typical macro definition looks like this:\n",1 "  DEFINE name command, command, command, ...\n",B "for example:\n",oE "  DEFINE vax set parity even, set duplex full, set flow xon/xoff\n", J "which defines a Kermit command macro called 'vax'.  The definition is a",J "comma-separated list of Kermit commands.  Use the DO command to execute",H "the macro, or just type its name, followed optionally by arguments.\n",F "The definition of a variable can be anything at all, for example:\n", "  DEFINE \\%a Monday",  "  DEFINE \\%b 3\n",> "These variables can be used almost anywhere, for example:\n", "  ECHO Today is \\%a",  "  SET BLOCK-CHECK \\%b",d "" };  #endif /* NOSPL */  
 #ifndef NOSPL  static char *hxxass[] = {p' "Syntax:  ASSIGN variablename string.",k* "Example: ASSIGN \\%a My name is \\%b.\n",F "Assigns the current value of the string to the variable (or macro).",J "The definition string is fully evaluated before it is assigned, so that",H "the values of any variables are contained are used, rather than their",J "names.  Compare with DEFINE.  To illustrate the difference, try this:\n", "  DEFINE \\%a hello", "  DEFINE \\%x \\%a",/ "  ASSIGN \\%y \\%a",t "  DEFINE \\%a goodbye", "  ECHO \\%x \\%y\n",u) "This will print 'goodbye hello'.", "" };f #endif /* NOSPL */  
 #ifndef NOSPLc static char *hxxdec[] = {K. "Syntax: DECREMENT variablename [ number ]\n",M "Decrement (subtract one from) the value of a variable if the current value",dN "is numeric.  If the number argument is given, subtract that number instead.",; "\nExamples: DECR \\%a, DECR \\%a 7, DECR \\%a \\%n", "" };h #endif /* NOSPL */  
 #ifndef NOSPLo static char *hxxinc[] = { . "Syntax: INCREMENT variablename [ number ]\n",I "Increment (add one to) the value of a variable if the current value is",>H "numeric.  If the number argument is given, add that number instead.\n",9 "Examples: INCR \\%a, INCR \\%a 7, INCR \\%a \\%n", "" };  #endif /* NOSPL */  
 #ifdef ANYX25g static char *hxxpad[] = {a "Syntax: PAD command", "X.25 PAD commands:\n",t- "    PAD CLEAR     - Clear the virtual call", 8 "    PAD STATUS    - Return the status of virtual call",* "    PAD RESET     - Send a reset packet",/ "    PAD INTERRUPT - Send an interrupt packet",i ""};   static char *hxyx25[] = {K1 "Syntax: SET X.25 option { ON [ data ], OFF }\n",  "X.25 call options:","( "  CLOSED-USER-GROUP { ON index, OFF }",I "    Enable or disable closed user group call, where index is the group",} "    index, 0 to 99.", "  REVERSE-CHARGE { ON, OFF }", A "    Tell whether you want to reverse the charges for the call.",e& "  CALL-USER-DATA { ON string, OFF }",0 "    Specify call user-data for the X.25 call.", ""}; #endif /* ANYX25 */e  
 #ifdef OS2 static char *hxyprtr[] = {! "Syntax: SET PRINTER filename\n",KK "Where to send transparent-print and screen-dump material during CONNECT.",IL "Default is PRN.  You can also specify a disk file name, in which case the",N "given file is created if it does not exist, or is appended to if it already",L "exists.  Use SET PRINTER NUL to discard transparent print and screen-dump",K "material.  SHOW PRINTER displays the current setting.  Note: SET PRINTER",]% "does not affect the PRINT command.",K ""}; #endif /* OS2 */   static char *hxyexit[] = {! "Syntax: SET EXIT STATUS number",- #ifdef NOSPL< "  Set C-Kermit's program return code to the given number.", #elsedK "  Set C-Kermit's program return code to the given number, which can be a",r4 "  constant, variable, or an \\feval() expression.", #endif /* NOSPL */* "\nSyntax: SET EXIT WARNING { ON, OFF }", N "  When EXIT WARNING is ON, issue a warning message and ask for confirmation",L "  before EXITing if a connection to another computer might still be open.", "  Default is OFF.", "" };   
 #ifndef NOSPLg static char *hxxpau[] = {f "Syntax:  PAUSE [ number ]", "Example: PAUSE 3\n",dJ "Do nothing for the specified number of seconds; if no number given, one",M "second.  If interrupted from the keyboard, set FAILURE, otherwise SUCCESS.",h "" };i   static char *hxxmsl[] = {n "Syntax:  MSLEEP [ number ]",m "Example: MSLEEP 500\n",K "Do nothing for the specified number of milliseconds; if no number given,",e "100 milliseconds.","" };t #endif /* NOSPL */   #ifndef NOPUSH static char *hxxshe[] = { A "Syntax: ! [ command ] or RUN [ command ] or PUSH [ command ]\n",sH "Give a command to the local operating system's command processor, and",' "display the results on the screen.\n", F "If the command is omitted, enter interactive mode; return to Kermit",G "by exiting from the system's command parser.  The command is usually",t! "EXIT or QUIT or LOGOUT.",  "" };  #endif /* NOPUSH */\   #ifndef NOXMIT static char *hxxxmit[] = { "Syntax: TRANSMIT file\n",K "The TRANSMIT command is used for sending single files to other computers",{N "that don't have Kermit.  Text files are sent a line at a time; binary files",H "are sent a character at a time.  There is no guarantee that the other",M "computer will receive the file correctly and completely.  Before you start",dK "the TRANSMIT command, you must put the other computer in data collection",NO "mode, for example by starting a text editor.  TRANSMIT may be interrupted by",) "Ctrl-C.  Synonym: XMIT.", "" };o #endif /* NOXMIT */p   #ifndef NOCSETSp static char *hxxxla[] = { . "Syntax: TRANSLATE file1 cs1 cs2 [ file2 ]\n",I "Translates file1 from the character set cs1 into the character set cs2",ID "and stores the result in file2.  The character sets can be any of",H "C-Kermit's file character sets.  If file2 is omitted, the translation",I "is displayed on the screen.  An appropriate intermediate character-set",6) "is chosen automatically, if necessary.",e "Synonym: XLATE.  Example:\n",3 "TRANSLATE lasagna.lat latin1 italian lasagna.nrc",e "" };c #endif /* NOCSETS */  
 #ifndef NOSPLR static char *hxxwai[] = {B) "Syntax:  WAIT number [modem-signal(s)]",h "Example: WAIT 5 \\cd\\cts\n",L "Waits up to the given number of seconds for all of the specified signals.",K "Sets FAILURE if signals do not appear in given time or if interrupted by",-? "typing anything at the keyboard during the waiting period.\n",iO "Signals: \\cd = Carrier Detect, \\dsr = Dataset Ready, \\cts = Clear To Send",H "" };S #endif /* NOSPL */   static char *hxxwri[] = {r "Syntax: WRITE name text\n",M "Writes the given text to the named log or file.  The text text may include",WM "backslash codes, and is not terminated by a newline unless you include the",rG "appropriate code.  The name parameter can be any of the following:\n",E "  DEBUG-LOG", "  ERROR (standard error)", 
 #ifndef NOSPLdK "  FILE (the OPEN WRITE, OPEN !WRITE, or OPEN APPEND file, see HELP OPEN)",t #endif /* NOSPL */ "  PACKET-LOG",. "  SCREEN (compare with ECHO)",d #ifndef NOLOCALt "  SESSION-LOG", #endif /* NOLOCAL */ "  TRANSACTION-LOG", "" };   #ifndef NODIAL7 static char *hxxdial[] = { "Syntax:  DIAL phonenumber",t "Example: DIAL 7654321\n",I "Dial a number using an autodial modem.  First you must SET MODEM, then",AM "SET LINE, then SET SPEED.  Then give the DIAL command, including the phone",  "number, for example:\n",U "  DIAL 7654321\n",c #ifdef NETCONNM "If the modem is on a network modem server, SET HOST first, then SET MODEM,",UK "then DIAL.  See also SET DIAL, SET MODEM, SET LINE, SET HOST, SET SPEED,",a "and REDIAL.\n", #elsee? "See also SET DIAL, SET MODEM, SET LINE, SET SPEED, REDIAL.\n",  #endif /* NETCONN */O "The 'phonenumber' can also the name of an entry from your dialing directory,",r4 "which is a plain text file, one entry per line:\n",3 "  name  phonenumber  speed   parity   comments\n",e "for example:\n",l@ "  e-mail  765-4321   2400    even     My electronic mailbox\n",M "The fields are separated by spaces, and all fields after the 'phonenumber'",lO "are optional.  If the speed or parity are present, they replace your current",/O "SET SPEED and SET PARITY settings.  Specify your dialing directory file with",h" "the SET DIAL DIRECTORY command.",  "" }; #endif /* NODIAL */)   #endif /* NOHELP */f  * /*  D O H L P  --  Give a help message  */  H _PROTOTYP( int dohset, (int) );i   int  dohlp(xx) int xx; {d     int x,y;  d"     debug(F101,"DOHELP xx","",xx);     if (xx < 0) return(xx);L       switch (xx) {T  E
 #ifdef NOHELP"   case XXHLP:h     if ((x = cmcfm()) < 0)       return(x);5     printf("\n%s, Copyright (C) 1985, 1994,",versio);      return(hmsga(tophlp));   #else /* help is available */r  
 #ifndef NOSPLA case XXASS:				/* assign */t     return(hmsga(hxxass));   case XXASK:				/* ask */     return(hmsga(hxxask));   case XXASKQ:     return(hmsga(hxxaskq));G #endif /* NOSPL */   case XXAPC:v$     return(hmsg("Syntax: APC text\n\N Echoes the text in the form of a VT220/320/420 Application Program Command.\n\H Use the APC command to send commands to MS-DOS Kermit 3.13 or later."));   #ifndef NOFRILLS case XXBUG: ;     return(hmsg("Describes how to report C-Kermit bugs."));s #endif /* NOFRILLS */l   case XXBYE:				/* bye */     return(hmsg(hmxxbye));  " case XXCHK:				/* check */     return(hmsg("\ Syntax: CHECK name\n\aN Checks to see if the named feature is included in this version of C-Kermit.\n\9 To list the features you can check, type \"check ?\"."));o   #ifndef NOFRILLS case XXCLE:				/* clear */     return(hmsg("\, Syntax: CLEAR [ { DEVICE, INPUT, BOTH } ]\n\K Clears the communications device input buffer, the INPUT command buffer,\n\S" or both.  The default is BOTH.")); #endif /* NOFRILLS */a   case XXCLO:				/* close */     return(hmsga(hmxxclo));\  , case XXCOM:				/* comment */= #ifndef STRATUS /* Can't use # for comments in Stratus VOS */E     return(hmsg("\ Syntax: COMMENT text\n\a* Example: COMMENT - this is a comment.\n\n\L Introduces a comment.  Beginning of command line only.  Commands may also\n\1 have trailing comments, introduced by ; or #."));D #elsea     return(hmsg("\ Syntax: COMMENT text\n\i* Example: COMMENT - this is a comment.\n\n\L Introduces a comment.  Beginning of command line only.  Commands may also\n\8 have trailing comments, introduced by ; (semicolon).")); #endif /* STRATUS */   #ifndef NOLOCALD case XXCON:				/* connect */     hmsga(hmxxcon);hA     printf("Your escape character is Ctrl-%c (ASCII %d, %s)\r\n",DC 	   ctl(escape), escape, (escape == 127 ? "DEL" : ccntab[escape]));Y     return(0); #endif /* NOLOCAL */  K case XXCWD:				/* cd / cwd */h
 #ifdef vms@     return(hmsg("Syntax: CD [ directory or device:directory ]\n\C Change Working Directory, equivalent to VMS SET DEFAULT command"));n #elseK #ifdef datageneralM     return(hmsg("Change Working Directory, equivalent to DG 'dir' command"));r #elseu
 #ifdef OS2O   return(hmsg("Change Working Directory, equivalent to OS/2 'chdir' command"));d #elsed2     return(hmsg("Syntax: CD [ directoryname ]\n\n\< Change Working Directory, equivalent to UNIX cd command.")); #endif /* OS2 */ #endif /* datageneral */ #endif /* vms */   
 #ifndef NOSPLo case XXDCL:s4     return(hmsg("Syntax:  DECLARE arrayname[size]\n\ Example: DECLARE \\&a[20]\n\n\M Declares an array of the given size.  Array elements can be used just like\n\i any other variables."));   case XXDEF:				/* define */h     return(hmsga(hxxdef)); #endif /* NOSPL */   #ifndef NOFRILLS case XXDEL:				/* delete */p-     return(hmsg("Syntax: DELETE filespec\n\n\:> Delete a local file or files.  RM is a synonym for DELETE.")); #endif /* NOFRILLS */   m #ifndef NODIAL case XXDIAL:				/* dial */     return(hmsga(hxxdial));i #endif  O case XXDIR:				/* directory */2     return(hmsg("Syntax: DIRECTORY [ filespec ]\n\/ Display a directory listing of local files."));   e #ifndef NOSERVER #ifndef NOFRILLS case XXDIS: -     return(hmsg("Syntax: DISABLE command\n\n\DL Security for the C-Kermit server.  Prevent the client Kermit program from\n\I executing the named REMOTE command, such as CD, DELETE, RECEIVE, etc."));f #endif /* NOFRILLS *// #endif /* NOSERVER */Z  
 #ifndef NOSPLf case XXDO:				/* do */<     return(hmsg("Syntax: [ DO ] macroname [ arguments ]\n\n\G Execute a macro that was defined by the DEFINE command.  The word DO\n\sF can be omitted.  Trailing argument words, if any, are automatically\n\= assigned to the macro argument variables \\%1, \\%2, etc."));  #endif /* NOSPL */  
 #ifndef NOSPLt case XXDEC:(     return(hmsga(hxxdec)); #endif /* NOSPL */   case XXECH:				/* echo */s%     return(hmsg("Syntax: ECHO text\n\lL Display the text on the screen, followed by a newline.  The ECHO text may\n\; contain backslash codes.  Example: ECHO \\7Wake up!\\7")); u  r #ifndef NOSERVER #ifndef NOFRILLS case XXENA: /     return(hmsg("Syntax: ENABLE capability\n\n\ K For use with server mode.  Allow the client Kermit program access to the\n\fM named capability, such as CD, DELETE, RECEIVE, etc.  Opposite of DISABLE."));I #endif /* NOFRILLS */o #endif /* NOSERVER */e  
 #ifndef NOSPL} case XXEND:				/* end */6     return(hmsg("Syntax: END [ number [ message ] ]\n\K Exit from the current macro or TAKE file, back to wherever invoked from.\n\t: Number is return code.  Message, if given, is printed."));   case XXEVAL:				/* evaluate */     return(hmsga(hmxxeval)); #endif /* NOSPL */   #ifndef NOFRILLS case XXERR:				/* error */!     return(hmsg("Syntax: ERROR\n\oJ Send an Error packet to the other Kermit to get it out of packet mode.")); #endif /* NOFRILLS */a   case XXEXI:				/* exit */b case XXQUI:o*     return(hmsg("Syntax: QUIT (or EXIT)\n\E Exit from the Kermit program, closing all open files and devices."));t    case XXFIN:i"     return(hmsg("Syntax: FINISH\n\C Tell the remote Kermit server to shut down without logging out."));g   
 #ifndef NOSPLe case XXFOR:t     return(hmsga(forhlp)); #endif /* NOSPL */   case XXGET:a     return(hmsg(hmxxget));   
 #ifndef NOSPLi #ifndef NOFRILLS
   case XXGOK:{(     return(hmsg("Syntax: GETOK prompt\n\L Print the prompt, make user type 'yes', 'no', or 'ok', and set SUCCESS or\n\ FAILURE accordingly.")); #endif /* NOFRILLS */i #endif /* NOSPL */  
 #ifndef NOSPL  case XXGOTO:&     return(hmsg("Syntax: GOTO label\n\L In a TAKE file or macro, go to the given label.  A label is a word on the\n\8 left margin that starts with a colon (:).  Example:\n\n\ :oofa\n\ echo Hello!\n\
 goto oofa"));  #endif /* NOSPL */   case XXHAN:h"     return(hmsg("Syntax: HANGUP\n\0 Hang up the phone or network connection."));       case XXHLP:a /*M   We get confirmation here, even though we do it again in hmsga(), to preventdL   the Copyright message from being printed prematurely.  This doesn't do anyM   harm, because the first call to cmcfm() sets cmflgs to 1, making the secondf   call return immediately. */     if ((x = cmcfm()) < 0)       return(x);5     printf("\n%s, Copyright (C) 1985, 1994,",versio);a     return(hmsga(tophlp));   case XXINT: <     return(hmsg("Give a brief introduction to C-Kermit."));	  
 #ifndef NOSPLt
 case XXIF:     return(hmsga(ifhlp));p   case XXINC:n     return(hmsga(hxxinc));   case XXINP:d    return(hmsg("\  Syntax:  INPUT n [ text ]\n\ Example: INPUT 5 Login:\n\n\O Wait up to n seconds for the given text to arrive on the communication line.\n\iH If no text, waits for any character.  For use in script programs with\n\D IF FAILURE and IF SUCCESS.  Also see MINPUT, REINPUT, SET INPUT.")); #endif /* NOSPL */   #ifdef CK_MINPUT case XXMINP:     return(hmsga(hmxxminp)); #endif /* CK_MINPUT */   #ifndef NODIAL case XXRED:,L     return(hmsg("Redial the number given in the most recent DIAL commnd.")); #endif /* NODIAL */   
 #ifndef NOSPLt case XXREI:e.     return(hmsg("Syntax: REINPUT n string\n\n\L Look for the string in the text that has recently been INPUT, set SUCCESS\n\J or FAILURE accordingly.  Timeout, n, must be specified but is ignored.")); #endif /* NOSPL */   #ifndef NOFRILLS case XXREN:[4     return(hmsg("Syntax: RENAME oldname newname\n\n\3 Change the name of file 'oldname' to 'newname'."));a #endif /* NOFRILLS */t  
 #ifndef NOSPLd case XXLBL:      return(hmsg("\L Introduce a label, like :loop, for use with GOTO in TAKE files or macros.\n\
 See GOTO."));r #endif /* NOSPL */   case XXLOG:t     return(hmsga(hmxxlg));  t #ifndef NOSCRIPT case XXLOGI:     return(hmsga(hmxxlogi)); #endif  n #ifndef NOFRILLS case XXMAI:D3     return(hmsg("Syntax: MAIL filename address\n\n\eO Send the file to the remote Kermit, which must be in RECEIVE or SERVER mode,\n\"N and request that the remote host deliver the file as electronic mail to the\n\6 given address.  Example: MAIL BUG.TXT KERMIT@CUVMA")); #endif /* NOFRILLS */e   #ifndef NOMSENDe case XXMSE:l     return(hmsg(hmssmse)); #endif /* NOMSEND */  
 #ifndef NOSPLa case XXOPE:      return(hmsga(openhlp));D #endif /* NOSPL */   case XXNEW:b     return(hmsg(I " Print news of new features since publication of \"Using C-Kermit\"."));"  
 #ifndef NOSPLC case XXOUT: )     return(hmsg("Syntax: OUTPUT text\n\n\ H Send the text out the currently selected line, as if you had typed it\n\J during CONNECT mode.  The text may contain backslash codes.  Example:\n\n\   OUTPUT help\\13"));( #endif /* NOSPL */  
 #ifdef ANYX25i case XXPAD:a     return(hmsga(hxxpad)); #endif /* ANYX25 */   
 #ifndef NOSPLa case XXPAU:a     return(hmsga(hxxpau));   case XXMSL:a     return(hmsga(hxxmsl)); #endif /* NOSPL */   #ifdef TCPSOCKET case XXPNG:o<     return(hmsg("Syntax: PING [ IP-hostname-or-number ]\n\n\G Check if given IP network host is reachable.  Default host from most\n\"I recent SET HOST or TELNET command.  Runs system PING program, if any."));  #endif /* TCPSOCKET */   #ifndef NOFRILLS case XXPRI:t4     return(hmsg("Syntax: PRINT file [ options ]\n\n\C Print the local file on a local printer with the given options."));c #endif /* NOFRILLS */,   case XXPWD:D     return(hmsg("Syntax: PWD\n\\4 Print the name of the current working directory."));  
 #ifndef NOSPL[ case XXREA:a-     return(hmsg("Syntax: READ variablename\n\eK Read a line from the currently open READ or !READ file into the variable\n\c (see OPEN)."));a #endif /* NOSPL */   case XXREC:n     return(hmsga(hmxxrc));  a case XXREM:,8     y = cmkey(remcmd,nrmt,"Remote command","",xxstring);     return(dohrmt(y));   
 #ifndef NOSPLP case XXRET: ,     return(hmsg("Syntax: RETURN [ value ]\n\K Return from a macro.  An optional return value can be given for use with\n\ J with \\fexecute(macro), which allows macros to be used like functions.")); #endif /* NOSPL */ case XXSEN:      return(hmsg(hmxxsen)); #ifndef NORESEND case XXRSEN:     return(hmsg(hmxxrsen));l case XXPSEN:     return(hmsg(hmxxpsen));e #endif /* NORESEND */   d #ifndef NOSERVER case XXSER:w     return(hmsg(hmxxser)); #endif /* NOSERVER */   R #ifndef NOJC case XXSUS: (     return(hmsg("Syntax: SUSPEND or Z\n\H Suspend Kermit.  Continue Kermit with the appropriate system command,\n\ such as fg."));d #endif /* NOJC */l   case XXSET:d3     y = cmkey(prmtab,nprm,"Parameter","",xxstring);]"     debug(F101,"HELP SET y","",y);     return(dohset(y));  a #ifndef NOPUSH case XXSHE:t     return(hmsga(hxxshe)); #ifdef CK_REDIRo case XXFUN:e,     return(hmsg("Syntax: REDIRECT command\n\L Run the given local command with its standard input and output redirected\n\; to the current SET LINE or SET HOST communications path.\n\d$ Synonym: < (Left angle bracket).")); #endif /* CK_REDIR */    #ifdef CK_REXX case XXREXX:%     return(hmsg("Syntax: REXX text\n\ N The text is a Rexx command to be executed. The \\v(rexx) variable is set to\n\# the Rexx command's return value.\n\i= To execute a rexx program file, use:  REXX call <filename>\n\CO Rexx programs may call C-Kermit functions by placing the C-Kermit command in\n\,5 single quotes.  For instance:  'set parity none'."));P #endif /* CK_REXX */ #endif /* NOPUSH */     #ifndef NOSHOW case XXSHO:      return(hmsg("\L Display current values of various items (SET parameters, variables, etc).\n\) Type SHOW ? for a list of categories."));i #endif /* NOSHOW */i  e case XXSPA:t #ifdef datageneral     return(hmsg("\3 Display disk usage in current device, directory,\n\ 6 or return space for a specified device, directory.")); #elsec!     return(hmsg("Syntax: SPACE\n\a9 Display disk usage in current device and/or directory"));a #endif    case XXSTA::&     return(hmsg("Syntax: STATISTICS\n\6 Display statistics about most recent file transfer"));  n
 #ifndef NOSPLr case XXSTO:17     return(hmsg("Syntax: STOP [ number [ message ] ]\n\OJ Stop executing the current macro or TAKE file and return immediately to\n\M the C-Kermit prompt.  Number is a return code.  Message printed if given."));n #endif /* NOSPL */   case XXTAK:s)     return(hmsg("Syntax: TAKE filename\n\sF Take Kermit commands from the named file.  Kermit command files may\n\J themselves contain TAKE commands, up to a reasonable depth of nesting."));  . #ifdef TCPSOCKET case XXTEL:\7     return(hmsg("Syntax: TELNET [ host [ service ] ]\n\TK Equivalent to SET NETWORK TCP/IP, SET HOST host [ service ], followed by\n\tJ CONNECT.  If host is omitted, previous connection (if any) is resumed.")); #endif /* TCPSOCKET */   #ifndef NOXMIT case XXTRA:      return(hmsga(hxxxmit));e #endif /* NOXMIT */i   #ifndef NOFRILLS case XXTYP: %     return(hmsg("Syntax: TYPE file\n\TK Display a file on the screen.  Pauses if you type Ctrl-S, resumes if you\n\,H type Ctrl-Q, returns immediately to C-Kermit prompt if you type Ctrl-C." ));r #endif /* NOFRILLS */   
 #ifndef NOSPL  case XXWHI:      return(hmsga(whihlp)); #endif /* NOSPL */   #ifndef NOCSETSl case XXXLA:f     return(hmsga(hxxxla)); #endif /* NOCSETS */   case XXVER: J     return(hmsg("Syntax: VERSION\nDisplays the program version number."));  
 #ifndef NOSPLC case XXWAI:e     return(hmsga(hxxwai)); #endif /* NOSPL */   #ifndef NOFRILLS case XXWHO:rH     return(hmsg("Syntax: WHO [ user ]\nDisplays info about the user."));   case XXWRI:y     return(hmsga(hxxwri));   case XXWRL:S     return(hmsg(K "WRITE-LINE (WRITELN) is just like WRITE, but includes a line terminator\n\ # at the end of text.  See WRITE."));  #endif /* NOFRILLS */a  
 #ifndef NOSPLe case XXIFX:\     return(hmsga(ifxhlp));   case XXGETC:				/* GETC */     return(hmsga(hxxgetc));    case XXFWD:				/* FORWARD */     return(hmsg(C "Like GOTO, but searches only forward for the label.  See GOTO."));h #endif /* NOSPL */   #endif /* NOHELP */r   default:%     if ((x = cmcfm()) < 0) return(x);o<     printf("Sorry, help not available for \"%s\"\n",cmdbuf);
     break;     }E     return(success = 0); }i   #ifdef NOHELP   & int					/* Print an array of lines, */, hmsga(s) char *s[]; {			/* cheap version. */
     int i;%     if ((i = cmcfm()) < 0) return(i);e5     printf("\n");			/* Start off with a blank line */\5     for (i = 0; *s[i]; i++) {		/* Print each line. */n 	printf("%s\n",s[i]);e     }R     printf("\n");r     return(0); }s  ! #else /* NOHELP not defined... */   & int					/* Print an array of lines, */< hmsga(s) char *s[]; {			/* pausing at end of each screen. */     int x, y, i, j, k, n;"%     if ((x = cmcfm()) < 0) return(x);x   #ifdef CK_NAWS    +     /* Check whether window size changed */,     if (ttgwsiz() > 0) {)         if (tt_rows > 0 && tt_cols > 0) {t             cmd_rows = tt_rows;.             cmd_cols = tt_rows;l	         }h     }  #endif /* CK_NAWS */    5     printf("\n");			/* Start off with a blank line */s      n = 1;				/* Line counter */     for (i = 0; *s[i]; i++) {t* 	printf("%s\n",s[i]);		/* Print a line. */         y = (int)strlen(s[i]);         k = 1;A         for (j = 0; j < y; j++)		/* See how many newlines were */L:           if (s[i][j] == '\n') k++;	/* in the string... */         n += k;yF 	if (n > (cmd_rows - 3) && *s[i+1]) /* After a screenful, give them */<           if (!askmore()) return(0);	/* a "more?" prompt. */           else n = 0;"     }e     printf("\n");4     return(0); }l  C /*  H M S G  --  Get confirmation, then print the given message  */d  f inth hmsg(s) char *s; {
     int x;%     if ((x = cmcfm()) < 0) return(x);      printf("\n%s\n\n",s);/     return(0); }T  R #ifndef NOXMIT static char *hsetxmit[] = { ) "Syntax: SET TRANSMIT parameter value\n",nJ "Controls the behavior of the TRANSMIT command, used for uploading files",C "to computers that don't have Kermit programs.  Parameters are:\n", D "ECHO ON/OFF:     Whether to echo text as it is being transmitted.",> "EOF text:        Text to send after end of file is reached.",H "FILL number:     ASCII value of character to insert into blank lines.",F "LINEFEED ON/OFF: Transmit LF as well as CR at the end of each line.",. "                 Normally, only CR is sent.",I "LOCKING-SHIFT ON/OFF: Whether to use SO/SI for transmitting 8-bit data",s, "                 when PARITY is not NONE.",O "PAUSE number:    How many milliseconds to pause after transmitting each line", A "                 (text mode), or each character (binary mode).",xI "PROMPT number:   ASCII value of character to look for from host before",P8 "                 sending next line, normally LF (10).", "Synonym: SET XMIT.",S "" };X #endif /* NOXMIT */s   static char *hsetbkg[] = {' "Syntax: SET BACKGROUND { OFF, ON }\n", J "SET BACKGROUND OFF forces prompts and messages to appear on your screen",C "even though Kermit thinks it is running in the background.", "" };    #ifdef DYNAMIC static char *hsetbuf[] = {" "Syntax: SET BUFFERS n1 [ n2 ]\n",L "Change the overall amount of memory allocated for SEND and RECEIVE packet",N "buffers, respectively.  Bigger numbers let you have longer packets and more",A "window slots.  If n2 is omitted, the same value as n1 is used.",f "" };S #endif /* DYNAMIC */   static char *hsetcmd[] = {( "Syntax: SET COMMAND parameter value\n",  "SET COMMAND BYTESIZE { 7, 8 }",N "  Informs C-Kermit of the bytesize of the communication path between itself",N "  and your keyboard and screen.  7 is assumed.  SET COMMAND BYTE 8 to allow",+ "  entry and display of 8-bit characters.",B #ifdef CK_RECALL* "\nSET COMMAND RECALL-BUFFER-SIZE number",M "  How big you want C-Kermit's command recall buffer to be.  By default, it", M "  holds 10 commands.  You can make it any size you like, subject to memory",eG "  constraints of the computer.  A size of 0 disables command recall.", F "  Whenever you give this command, previous command history is lost.", #endif /* CK_RECALL */$ "\nSET COMMAND QUOTING { ON, OFF }",M "  Whether to treat backslash and question mark as special characters (ON),",(F "  or as ordinary data characters (OFF) in commands.  ON by default.", #ifdef CM_RETRYO" "\nSET COMMAND RETRY { ON, OFF }",I "  Whether to reprompt you with the correct but incomplete portion of a",e5 "  syntactically incorrect command.  ON by default.",  #endif /* CM_RETRY */n "" };K   #ifndef NOLOCALl static char *hsetcar[] = {) "Syntax: SET CARRIER ON, AUTO, or OFF\n",mH "Attempts to control treatment of carrier on the communication device.",H "ON means that carrier is required at all times except during the DIAL",J "command.  OFF means that carrier is never required.  AUTO (the default)",< "means that carrier is required only during CONNECT.", "" }; #endif /* NOLOCAL */   static char *hsetat[] = {u* "Syntax: SET ATTRIBUTES name ON or OFF\n",G "Use this command to enable (ON) or disable (OFF) the transmission of",rI "selected file attributes along with each file, and to handle or ignore",D2 "selected incoming file attributes, including:\n", #ifndef NOCSETS > "  CHARACTER-SET:  The transfer character set for text files", #endif /* NOCSETS */- "  DATE:           The file's creation date",sK "  DISPOSITION:    Unusual things to do with the file, like MAIL or PRINT",X& "  LENGTH:         The file's length",7 "  SYSTEM-ID:      Machine/Operating system of origin", 7 "  TYPE:           The file's type (text or binary)\n", ? "You can also specify ALL to select all of them.  Examples:\n",iC "  SET ATTR DATE OFF\n  SET ATTR LENGTH ON\n  SET ATTR ALL OFF", ""d };  
 #ifndef NOSPLt static char *hxxinp[] = {t& "Syntax: SET INPUT parameter value\n",F "The SET INPUT command controls the behavior of the INPUT command:\n",% "SET INPUT CASE { IGNORE, OBSERVE }",VL "Tells whether alphabetic case is to be significant in string comparisons.",O "This setting is local to the current macro or command file, and is inherited",c* "by subordinate macros and take files.\n", "SET INPUT ECHO { ON, OFF }", N "Tells whether to display arriving characters read by INPUT on the screen.\n", "SET INPUT SILENCE <number>",nN "The maximum number to seconds of silence (no input at all) before the INPUT",) "command times out, 0 for no maximum.\n",n- "SET INPUT TIMEOUT-ACTION { PROCEED, QUIT }",eM "Tells whether to proceed or quit from a script program if an INPUT command",mN "fails.  PROCEED (default) allows use of IF SUCCESS and IF FAILURE commands.",O "This setting is local to the current macro or command file, and is inherited", ( "by subordinate macros and take files.", "" };f #endif /* NOSPL */   static char *hxytak[] = {e% "Syntax: SET TAKE parameter value\n",/' "Controls behavior of TAKE command.\n", I "SET TAKE ECHO { ON, OFF } tells whether commands read from a TAKE file",m' "should be displayed on the screen.\n",nI "SET TAKE ERROR { ON, OFF } tells whether a TAKE command file should be",cK "automatically terminated when a command fails.  This setting is local to", H "the current command file, and inherited by subordinate command files.",  "" };   #ifndef NOLOCALe static char *hxyterm[] = {) "Syntax: SET TERMINAL parameter value\n",t
 #ifdef OS2O "SET TERMINAL TYPE { ANSI, VT52, VT100, VT102, VT220 } to select emulation.\n",X& "SET TERMINAL ANSWERBACK { OFF, ON }",L "disables/enables the ENQ/Answerback sequence (\"OS/2 C-Kermit version type\ \").\n", #endif /* OS2 */
 #ifdef CK_APCn* "SET TERMINAL APC { ON, OFF, UNCHECKED }",L "controls execution of Application Program Commands sent by the host while",M "C-Kermit is in CONNECT mode.  ON allows execution of \"safe\" commands and",mO "disallows potentially dangerous commands such as DELETE, RENAME, OUTPUT, and",SK "RUN.  OFF prevents execution of APCs.  UNCHECKED allows execution of all",, "APCs.  OFF is the default.\n",c #endif /* CK_APC */f
 #ifdef OS22 "SET TERMINAL ARROW-KEYS { APPLICATION, CURSOR }",D "sets the mode for the arrow keys during VT terminal emulation.\n", / "SET TERMINAL BELL { AUDIBLE, VISIBLE, NONE }",\H "specifies how Control-G (bell) characters are handled.  AUDIBLE means",H "a beep is sounded; VISIBLE means the screen is flashed momentarily.\n", #endif /* OS2 */G "SET TERMINAL BYTESIZE 7 or 8, to use 7- or 8-bit terminal characters",aH "between C-Kermit and the remote computer or service during CONNECT.\n",
 #ifdef OS2N "SET TERMINAL CODE-PAGE lets you change the PC code page.  Use SHOW TERMINAL",C "to display the current code page and the available code pages.\n",s #endif /* OS2 */ #ifndef NOCSETS G "SET TERMINAL CHARACTER-SET <remote-cs> [ <local-cs> ] to specify the",iH "character set used by the remote host, <remote-cs>, and the character",F "set used by C-Kermit locally, <local-cs>.  If you don't specify the",I "local character set, the current FILE CHARACTER-SET is used.  When you",nI "specify two different character sets, C-Kermit translates between them",xF "during CONNECT.  By default, both character sets are TRANSPARENT.\n", #endif /* NOCSETS */
 #ifdef OS2D "SET TERMINAL COLOR <screenpart> <foreground> <background>, to set",L "the colors of the terminal emulation screen.  <screenpart> may be one of:",M "TERMINAL-SCREEN, UNDERLINED-TEXT, STATUS-LINE and HELP-TEXT.  <foreground>",aJ "and <background> may be one of: BLACK, BLUE, GREEN, CYAN, RED, MAGENTA,",O "BROWN, LGRAY, DGRAY, LBLUE, LGREEN, LCYAN, LRED, LMAGENTA, YELLOW, or WHITE.", 2 "The L prefix for the color names means Light.\n", #endif /* OS2 */C "SET TERMINAL CR-DISPLAY { CRLF, NORMAL } to specify how incoming",lC "carriage return characters are to be displayed on your screen.\n",s
 #ifdef OS2H "SET TERMINAL CURSOR { FULL, HALF, UNDERLINE } selects cursor style.\n", #endif /* OS2 */H "SET TERMINAL DEBUG { ON, OFF } controls terminal session debugging.\n",L "SET TERMINAL ECHO { LOCAL, REMOTE } specifies which side does the echoing",  "during terminal connection.\n",
 #ifdef OS2L "SET TERMINAL HIDE-CURSOR { ON, OFF } to tell whether cursor-hiding can be",L "used to make screen updates faster, in which case the cursor might vanish",3 "momentarily from time to time.  ON by default.\n",iJ "SET TERMINAL KEYPAD-MODE { APPLICATION, NUMERIC } to specify the keypad",$ "mode for VT terminal emulation.\n", #endif /* OS2 */G "SET TERMINAL LOCKING-SHIFT { OFF, ON } tells C-Kermit whether to use",rK "Shift-In/Shift-Out (Ctrl-O and Ctrl-N) to switch between 7-bit and 8-bit", 0 "characters during CONNECT.  OFF by default.\n", #ifdef OS2MOUSEXL "SET TERMINAL MOUSE { OFF, ON } enables/disables the mouse during CONNECT.",> "OFF by default.  When ON, the mouse can be used as follows:",O " Left button: double click sends arrow keys to move cursor to mouse position", 2 " Right button: drag and release to select text.",= " Right button: double click to send selected text to host.", O " To select and send in one move, hold down left button, drag, click right.\n",  #endif /* OS2MOUSE */cL "SET TERMINAL NEWLINE-MODE { OFF, ON } tells whether to send CRLF when you",! "type CR during CONNECT mode.\n",u
 #ifdef OS2L "SET TERMINAL OUTPUT-PACING <milliseconds> tells how long to pause between",O "sending each character to the host during CONNECT mode.  Normally not needed",dM "but sometimes required to work around TRANSMISSION BLOCKED conditions when",e& "pasting into the terminal window.\n",D "SET TERMINAL ROLL {ON,OFF} tells whether typing is allowed during \
 rollback.\n",sL "SET TERMINAL SCROLLBACK <lines> sets size of CONNECT scrollback buffer.\n",O "SET TERMINAL TRANSMIT-TIMEOUT <seconds> specifies the maximum amount of time",aL "C-Kermit waits before returning to the prompt if your keystrokes can't be",B "transmitted for some reason, such as a flow-control deadlock.\n",M "SET TERMINAL WRAP { OFF, ON } to tell whether the terminal emulator should",n2 "automatically wrap long lines on your screen.\n", #endif /* OS2 */7 "Type SHOW TERMINAL to see current terminal settings."," "" };e #endif /* NOLOCAL */   #ifdef NETCONN static char *hxyhost[] = {6 "Syntax:  SET HOST hostname-or-address [ service ]\n",H "Establish a connection to the specified network host on the currently",I "selected network type.  For TCP/IP connections, the default service is",aJ "TELNET; specify a different TCP port number or service name to choose a",) "different service.  TCP/IP Examples:\n",;! "  SET HOST kermit.columbia.edu",  "  SET HOST 128.59.39.2", * "  SET HOST madlab.sprl.umich.edu 3000\n",  "Also see SET NETWORK, TELNET.", "" };n  
 #ifdef TNCODEe static char *hxytel[] = {d' "Syntax: SET TELNET parameter value\n",u0 "For TCP/IP SET HOST and TELNET connections:\n",$ "SET TELNET ECHO { LOCAL, REMOTE }",O "  C-Kermit's initial echoing state for TELNET connections, LOCAL by default.",tL "  After the connection is made, TELNET negotiations determine the echoing", "  state.",r+ "SET TELNET NEWLINE-MODE { OFF, ON, RAW }",u9 "  ON (the default) means send CRLF when user types CR.",n "  OFF means send CR and NUL.",u "  RAW means send CR alone.",E  "SET TELNET TERMINAL-TYPE name",L "  The terminal type to send to the remote TELNET host.  If none is given,",( "  your local terminal type is sent.\n",C "Type SHOW NETWORK to see the current values of these parameters.",a "" };a #endif /* TNCODE */    static char *hxynet[] = {X% "Syntax: SET NETWORK network-type\n",:E "Select the type of network to be used with SET HOST connections:\n",) #ifdef TCPSOCKET "  SET NETWORK TCP/IP",r #endif /* TCPSOCKET */
 #ifdef ANYX25g "  SET NETWORK X.25",l #endif /* ANYX25 */x
 #ifdef DECNETa "  SET NETWORK DECNET",p #endif /* DECNET */o #ifdef NPIPE& "  SET NETWORK NAMED-PIPE <pipename>", #endif /* NPIPE */ #ifdef CK_NETBIOSe "  SET NETWORK NETBIOS", #endif /* CK_NETBIOS */ H "\nIf only one network type is listed, that is the default network for",1 "SET HOST commands.  Also see SET HOST, TELNET.",  ""}; #endif /* NETCONN */  H
 #ifndef NOSPLe static char *hxymacr[] = {& "Syntax: SET MACRO parameter value\n",% "Controls the behavior of macros.\n",rJ "SET MACRO ECHO { ON, OFF } tells whether commands executed from a macro",2 "definition should be displayed on the screen.\n",L "SET MACRO ERROR { ON, OFF } tells whether a macro should be automatically",I "terminated upon a command error.  This setting is local to the current", . "macro, and inherited by subordinate macros.", "" };S #endif /* NOSPL */   #ifndef NODIAL static char *hxymodm[] = {" "Syntax: SET MODEM-DIALER name\n",O "Type of modem for dialing remote connections.  Selects the dialing protocol,",) #ifdef MINIDIALPL "such as HAYES, to be used by the DIAL command.  Several dialing protocols", #elsesO "such as HAYES, to be used by the DIAL command.  Many modem dialing protocols",n #endif /* MINIDIAL */dM "are supported; type SET MODEM ? for a list.  DIRECT or NONE means a direct",aK "connection, with no modem at all.  Also see HELP DIAL, HELP SET CARRIER.",T "" };  #endif /* NODIAL */y   static char *hmxyprm[] = {  "Syntax: SET PROMPT [ text ]\n",
 #ifdef MACO "Prompt text for this program, normally 'Mac-Kermit>'.  May contain backslash",x #elseeM "Prompt text for this program, normally 'C-Kermit>'.  May contain backslash",a #endif /* MAC */N "codes for special effects.  Surround by { } to preserve leading or trailing",
 #ifdef MACO "spaces.  If text omitted, prompt reverts to Mac-Kermit>.  Prompt can include",L #else M "spaces.  If text omitted, prompt reverts to C-Kermit>.  Prompt can include",  #endif /* MAC */J "variables like \\v(dir) or \\v(time) to show current directory or time.", "" };    static char *hxywind[] = {# "Syntax: SET WINDOW-SIZE number\n",.L "Specify number of window slots for sliding windows, the number of packets",K "that can be transmitted before pausing for acknowledgement.  The default", J "is one, the maximum is 31.  Increased window size may result in reduced",I "maximum packet length.  Use sliding windows for improved efficiency on",WG "connections with long delays.  A full duplex connection is required."," "" };e   static char *hxyrpt[] = {e= "Syntax: SET REPEAT { COUNTS { ON, OFF }, PREFIX <code> }\n",TM "SET REPEAT COUNTS turns the repeat-count compression mechanism ON and OFF.",  " The default is ON.",I "SET REPEAT PREFIX <code> sets the repeat-count prefix character to the",O, " given code.  The default is 126 (tilde).", "" };x   static char *hxyrcv[] = { ( "Syntax: SET RECEIVE parameter value\n",, "Specify parameters for inbound packets:\n", "CONTROL-PREFIX number",J " ASCII value of prefix character used for quoting control characters in",L " packets that C-Kermit receives, normally 35 (number sign).  Don't change",A " this unless something is wrong with the other Kermit program.",i "END-OF-PACKET number",rF " ASCII value of control character that terminates incoming packets,"," " normally 13 (carriage return).", "PACKET-LENGTH number",n7 " Maximum length packet the other Kermit should send.",  "PADDING number",nC " Number of prepacket padding characters to ask for (normally 0).",) "PAD-CHARACTER number",dE " ASCII value of control character to use for padding (normally 0).",t "PATHNAMES ON or OFF",L " If a recognizable path (directory, device, etc) specification appears in",O " an incoming filename, leave it ON and try to use it, or strip it OFF before",f #ifdef CK_MKDIRtL " trying to create the output file.  When ON (the default), then if any of",K " the directories in the path don't exist, C-Kermit tries to create them.",s #else[E " trying to create the output file.  The default is to leave it ON.",n #endif /* CK_MKDIR */  "PAUSE number",=9 " Milliseconds to pause in between packets, normally 0.",n "START-OF-PACKET number",]@ " ASCII value of character that marks start of inbound packet.", "TIMEOUT number",?J " Number of seconds other Kermit should wait for a packet before sending", " NAK or retransmitting.", "" };n   static char *hxysnd[] = {e% "Syntax: SET SEND parameter value\n",*M "Specify parameters for outbound packets.  This command should be used only",,G "to override the normal negotiated parameters and is rarely needed:\n",  "CONTROL-PREFIX number",J " ASCII value of prefix character used for quoting control characters in",; " packets that C-Kermit sends, normally 35 (number sign).",r "END-OF-PACKET number", E " ASCII value of control character to terminate an outbound packet,", " " normally 13 (carriage return).", "PACKET-LENGTH number",,M " Maximum length packet to send, even if other Kermit asks for longer ones.",N "PADDING number",m3 " Number of prepacket padding characters to send.",  "PAD-CHARACTER number",y8 " ASCII value of control character to use for padding.", "PATHNAMES ON or OFF",N " When FILE NAMES is set to LITERAL, leave the path (device, directory, etc)",K " portion ON or OFF the file name when sending it.  Applies to the actual",t6 " filename, not the \"as-name\".  The default is ON.", "PAUSE number",a9 " Milliseconds to pause in between packets, normally 0.",  "START-OF-PACKET number",n> " ASCII value of character to mark start of outbound packet.", "TIMEOUT number",c@ " Number of seconds to wait for a packet before sending NAK or", " retransmitting.",s "" };s   static char *hxyxfer[] = { "Synonym: SET XFER\n",
 #ifdef XFRCANiH "Syntax: SET TRANSFER CANCELLATION { OFF, ON [ <code> [ <number> ] ]\n",G "OFF disables remote-mode packet-mode cancellation from the keyboard.",uJ "ON enables it.  The optional <code> is the control character to use for",J "cancellation; the optional <number> is how many consecutive occurrences",@ "of the given control character are required for cancellation.", #endif /* XFRCAN */c #ifndef NOCSETS=. "\nSyntax: SET TRANSFER CHARACTER-SET name\n",M "Select the character set used to represent textual data in Kermit packets.",uM "Text characters are translated to/from the FILE CHARACTER-SET.  Choices:\n", - " TRANSPARENT (no translation, the default)",s	 " ASCII",i( " LATIN1 (ISO 8859-1 Latin Alphabet 1)", #ifndef NOLATIN2( " LATIN2 (ISO 8859-2 Latin Alphabet 2)", #endif /* NOLATIN2 */  #ifdef CYRILLIC , " CYRILLIC-ISO (ISO 8859-5 Latin/Cyrillic)", #endif /* CYRILLIC */i
 #ifdef HEBREWm( " HEBREW-ISO (ISO 8859-8 Latin/Hebrew)", #endif /* HEBREW */  #ifdef KANJI: " JAPANESE-EUC (JIS X 0208 Kanji + Roman and Katakana)\n", #endif /* KANJI */ #endif /* NOCSETS */= "\nSyntax: SET TRANSFER LOCKING-SHIFT { OFF, ON, FORCED }\n",lJ "Tell whether locking-shift protocol should be used during file transfer",L "to achieve 8-bit transparency on a 7-bit connection.  ON means to request",J "its use if PARITY is not NONE and to use it if the other Kermit agrees,",K "OFF means not to use it, FORCED means to use it even if the other Kermit"," "does not agree.", "" };   2 /*  D O H S E T  --  Give help for SET command  */  S int: dohset(xx) int xx; {
     int x;  (     if (xx == -3) return(hmsga(hmhset));     if (xx < 0) return(xx);,%     if ((x = cmcfm()) < 0) return(x);      switch (xx) {r    case XYATTR:     return(hmsga(hsetat));   case XYBACK:     return(hmsga(hsetbkg));    #ifdef DYNAMIC case XYBUF:      return(hmsga(hsetbuf));  #endif /* DYNAMIC */   #ifndef NOLOCALa case XYCARR:     return(hmsga(hsetcar));r #endif /* NOLOCAL */  
 #ifndef NOSPLO case XYCASE:0     return(hmsg("Syntax: SET CASE { ON, OFF }\n\E Tells whether alphabetic case is significant in string comparisons\n\iG done by INPUT, IF, and other commands.  This setting is local to the\n\TA current macro or command file, and inherited by subordinates."));    #endif /* NOSPL */   case XYCMD:d     return(hmsga(hsetcmd));u   case XYIFD:d<     return(hmsg("Syntax: SET INCOMPLETE { DISCARD, KEEP }\n\D Discard or Keep incompletely received files, default is DISCARD."));  
 #ifndef NOSPL  case XYINPU:     return(hmsga(hxxinp)); #endif /* NOSPL */   case XYCHKT:     return(hmsga(hmxychkt));   
 #ifndef NOSPLE case XYCOUN:-     return(hmsg("Syntax:  SET COUNT number\n\i Example: SET COUNT 5\n\ H Set up a loop counter, for use with IF COUNT.  Local to current macro\n\G or command file, inherited by subordinate macros and command files."));G #endif /* NOSPL */   #ifndef NOLOCALa case XYDEBU: #ifdef DEBUG    :     return(hmsg("Syntax: SET DEBUG { SESSION, ON, OFF }\n\I SESSION means display control and 8-bit characters symbolically during\n\tH CONNECT mode.  ON means log debugging information to file debug.log.")); #elseg6     return(hmsg("Syntax: SET DEBUG { SESSION, OFF }\n\I SESSION means display control and 8-bit characters symbolically during\n\t CONNECT mode."));P #endif /* DEBUG */ #else  #ifdef DEBUG case XYDEBU:1     return(hmsg("Syntax: SET DEBUG { ON, OFF }\n\e9 ON means log debugging information to file debug.log."));o #endif /* DEBUG */ #endif /* NOLOCAL */   case XYDFLT:1     return(hmsg("Syntax: SET DEFAULT directory\n\c0 Change directory.  Equivalent to CD command."));  
 case XYDELA: u,     return(hmsg("Syntax: SET DELAY number\n\M Number of seconds to wait before sending first packet after SEND command."));u  " #ifndef NODIAL case XYDIAL:     return(hmsga(hmxydial)); #endif /* NODIAL */e   #ifdef UNIXe case XYSUSP:5     return(hmsg("Syntax: SET SUSPEND { OFF, ON }\n\n\TN Disables SUSPEND command, suspend signals, and <esc-char>Z during CONNECT.")); #endif   #ifndef NOSCRIPT case XYSCRI:9     return(hmsg("Syntax: SET SCRIPT ECHO { OFF, ON }\n\n\i9 Disables/Enables echoing of SCRIPT command operation."));  #endif /* NOSCRIPT */h   case XYTAKE:     return(hmsga(hxytak));   #ifndef NOLOCALf case XYTERM:     return(hmsga(hxyterm));0   case XYDUPL:7     return(hmsg("Syntax: SET DUPLEX { FULL, HALF }\n\n\FE During CONNECT: FULL means remote host echoes, HALF means C-Kermit\n\t does its own echoing."));e   case XYLCLE:8     return(hmsg("Syntax: SET LOCAL-ECHO { OFF, ON }\n\n\B During CONNECT: OFF means remote host echoes, ON means C-Kermit\n\A does its own echoing.  Synonym for SET DUPLEX { FULL, HALF }."));"   case XYESC: /     return(hmsg("Syntax: SET ESCAPE number\n\n\ G Decimal ASCII value for escape character during CONNECT, normally 28\n\AL (Control-\\).  Type the escape character followed by C to get back to the\n\ C-Kermit prompt.")); #endif /* NOLOCAL */   
 #ifdef OS2 case XYPRTR:     return(hmsga(hxyprtr));r #endif /* OS2 */   case XYEXIT:     return(hmsga(hxyexit));A  E case XYFILE:     return(hmsga(hmxyf));i  h case XYFLOW:     return(hmsga(hmxyflo));   D case XYHAND:    return(hmsga(hmxyhsh));   #ifdef NETCONN case XYHOST: return(hmsga(hxyhost));S case XYNET:R return(hmsga(hxynet));  
 #ifdef ANYX25  case XYX25:a     return(hmsga(hxyx25));   case XYPAD:c.     return(hmsg("Syntax: SET PAD name value\n\1 Set a PAD X.3 parameter with a desired value."));c #endif /* ANYX25 */  #endif /* NETCONN */  
 #ifndef NOSPLp case XYOUTP:6     return(hmsg("Syntax: SET OUTPUT PACING <number>\n\G How many milliseconds to pause after sending each OUTPUT character."));h #endif /* NOSPL */   #ifndef NOSETKEY case XYKEY:				/* SET KEY */     return(hmsga(hmhskey));i #endif /* NOSETKEY */    #ifndef NOCSETSy case XYLANG:-     return(hmsg("Syntax: SET LANGUAGE name\n\iL Selects language-specific translation rules for text-mode file transfers.\n\K Used with SET FILE CHARACTER-SET and SET TRANSFER CHARACTER-SET when one\n\N of these is ASCII.")); #endif /* NOCSETS */   case XYLINE:,     printf("\nSyntax: SET LINE devicename\n\  or:     SET PORT devicename\n\n\< Select communication device to use.  Normally %s.\n",dftty);     if (!dfloc) {D
 	printf("\8 If you SET LINE to other than %s, then Kermit\n",dftty);
 	printf("\L will be in 'local' mode; SET LINE alone will reset Kermit to remote mode.\n\N To use the modem to dial out, first SET MODEM-DIALER (e.g., to HAYES), then");
 	printf("\H \nSET LINE xxx, next issue the DIAL command, and finally CONNECT.\n\n");     }h     return(0);  r
 #ifndef NOSPLa case XYMACR:     return(hmsga(hxymacr));\ #endif /* NOSPL */   #ifndef NODIAL case XYMODM:     return(hmsga(hxymodm));t #endif /* NODIAL */S  / case XYPARI:-     return(hmsg("Syntax: SET PARITY name\n\n\eO Parity to use during terminal connection and file transfer: EVEN, ODD, MARK,\n\e# SPACE, or NONE.  Normally NONE."));.  , case XYPROM:     return(hmsga(hmxyprm));N  F case XYQUIE:1     return(hmsg("Syntax: SET QUIET {ON, OFF}\n\n\uJ Normally OFF.  ON disables most information messages during interactive\n\ operation."));   #ifdef CK_SPEEDS case XYQCTL:     return(hmsga(hmxyqctl)); #endif /* CK_SPEED */p   case XYRETR:.     return(hmsg("Syntax: SET RETRY number\n\n\F How many times to retransmit a particular packet before giving up."));   #ifndef NOLOCAL  #ifdef UNIXt case XYSESS:>     return(hmsg("Syntax: SET SESSION-LOG { BINARY, TEXT }\n\n\K If BINARY, record all CONNECT characters in session log.  If TEXT, strip\n\a out carriage returns."));C #endif /* UNIX */l   case XYSPEE:.     return(hmsg("Syntax: SET SPEED number\n\n\J Communication line speed for external tty line specified in most recent\n\H SET LINE command, in bits per second.  Type SET SPEED ? for a list of\n\ possible speeds.")); #endif /* NOLOCAL */   case XYRECV:     return(hmsga(hxyrcv)); case XYSEND:     return(hmsga(hxysnd)); case XYREPT:     return(hmsga(hxyrpt));   #ifndef NOSERVER case XYSERV:     return(hmsga(hsetsrv));O #endif /* NOSERVER */f  
 #ifdef TNCODEA case XYTEL:N     return(hmsga(hxytel)); #endif /* TNCODE */,   #ifndef NOXMIT case XYXMIT:     return(hmsga(hsetxmit)); #endif /* NOXMIT */    #ifndef NOCSETSi case XYUNCS:9     return(hmsg("Syntax: SET UNKNOWN-CHAR-SET action\n\n\ G DISCARD (default) means reject any arriving files encoded in unknown\n\g6 character sets.  KEEP means to accept them anyway.")); #endif /* NOCSETS */   #ifdef UNIXc case XYWILD:F     return(hmsg("Syntax: SET WILDCARD-EXPANSION { KERMIT, SHELL }\n\n\I KERMIT (the default) means C-Kermit expands filename wildcards in SEND\n\yL and MSEND commands and incoming GET commands.  SHELL means your shell does \ it."));  #endif /* UNIX */{   case XYWIND:     return(hmsga(hxywind));t   case XYXFER:     return(hmsga(hxyxfer));o   default:.     printf("Not available yet - %s\n",cmdbuf);     return(0);     }e }n "   7 /*  D O H R M T  --  Give help about REMOTE command  */a  h static char *hrset[] = {& "Syntax:  REMOTE SET parameter value",) "Example: REMOTE SET FILE TYPE BINARY\n",dN "Ask the remote Kermit server to set the named parameter to the given value.",K "Equivalent to typing the corresponding SET command directly to the other", / "Kermit if it were in interactive mode.", "" };T   intx dohrmt(xx) int xx; {
     int x;(     if (xx == -3) return(hmsga(hmhrmt));     if (xx < 0) return(xx);c%     if ((x = cmcfm()) < 0) return(x);T     switch (xx) {   d case XZCWD:t0     return(hmsg("Syntax: REMOTE CD [ name ]\n\n\F Ask remote Kermit server to change its working directory or device.\n\D If the device or directory name is omitted, restore the default."));    case XZDEL:t4     return(hmsg("Syntax: REMOTE DELETE filespec\n\n\= Ask the remote Kermit server to delete the named file(s)."));r  S case XZDIR:L;     return(hmsg("Syntax: REMOTE DIRECTORY [ filespec ]\n\n\CK Ask the remote Kermit server to provide a directory listing of the named\n\nL file(s) or if no file specification is given, of all files in the current\n\ directory."));  E case XZHLP:o)     return(hmsg("Syntax: REMOTE HELP\n\n\ B Ask the remote Kermit server to list the services it provides."));  a case XZHOS:"1     return(hmsg("Syntax: REMOTE HOST command\n\n\ I Send a command to the remote host computer in its own command language\n\o% through the remote Kermit server."));)  i #ifndef NOFRILLS case XZKER:T3     return(hmsg("Syntax: REMOTE KERMIT command\n\n\SK Send a command to the remote Kermit server in its own command language."));E   case XZLGI: D     return(hmsg("Syntax: REMOTE LOGIN user password [ account ]\n\n\= Log in to a remote Kermit server that requires you login."));e   case XZLGO:I+     return(hmsg("Syntax: REMOTE LOGOUT\n\n\,O Log out from a remote Kermit server to which you have previously logged in."));T   case XZPRI:d?     return(hmsg("Syntax: REMOTE PRINT filespec [ options ]\n\n\ I Send the specified file(s) to the remote Kermit and ask it to have the\n\"M file printed on the remote system's printer, using any specified options."));  #endif /* NOFRILLS */i   case XZSET:s     return(hmsga(hrset));R   case XZSPA:l3     return(hmsg("Syntax: REMOTE SPACE [ name ]\n\n\aO Ask the remote Kermit server to tell you about its disk space on the current\n\n3 disk or directory, or in the one that you name."));O    #ifndef NOFRILLS case XZTYP:a.     return(hmsg("Syntax: REMOTE TYPE file\n\n\J Ask the remote Kermit server to type the named file(s) on your screen."));  c case XZWHO:f1     return(hmsg("Syntax: REMOTE WHO [ name ]\n\n\cO Ask the remote Kermit server to list who's logged in, or to give information\n\I about the named user."));l #endif /* NOFRILLS */f  
 #ifndef NOSPL  case XZQUE:d     return(hmsg(A "Syntax: REMOTE QUERY { KERMIT, SYSTEM, USER } variable-name\n\n\oN Ask the remote Kermit server to send the value of the named variable of the\n\A given type, and make it available in the \\v(query) variable."));n   case XZASG:      return(hmsg(3 "Syntax: REMOTE ASSIGN variable-name [ value ]\n\n\kF Assign the given value to the named global variable on the server."));   #endif /* NOSPL */ default:%     if ((x = cmcfm()) < 0) return(x); ,     printf("not working yet - %s\n",cmdbuf);     return(-2);      }. }f #endif /* NOHELP */  #endif /* NOICP */