 #include "ckcsym.h"   C int cmdmsk = 127; /* Command-terminal-to-C-Kermit character mask */   G #include "ckcdeb.h"                     /* Formats for debug(), etc. */ 8 #include "ckucmd.h"			/* Needed for xx_strp prototype */ _PROTOTYP( int unhex, (char) );  static int quoting = 1;   M #ifndef NOICP     /* The rest only if interactive command parsing selected */   1 char *cmdv = "Command package 5A(067), 2 Oct 94";    = /*  C K U C M D  --  Interactive command package for Unix  */    /*?   Author: Frank da Cruz (fdc@columbia.edu, FDCCU@CUVMA.BITNET), B   Columbia University Academic Information Systems, New York City.  N   Copyright (C) 1985, 1994, Trustees of Columbia University in the City of NewK   York.  The C-Kermit software may not be, in whole or in part, licensed or L   sold for profit as a software product itself, nor may it be included in orM   distributed with commercial products or otherwise distributed by commercial J   concerns to their clients or customers without written permission of theK   Office of Kermit Development and Distribution, Columbia University.  This =   copyright notice must not be removed, altered, or obscured.  */   /*N Modeled after the DECSYSTEM-20 command parser (the COMND JSYS), RIP. Features:  L . parses and verifies keywords, filenames, text strings, numbers, other data? . displays appropriate menu or help message when user types "?" A . does keyword and filename completion when user types ESC or TAB " . does partial filename completion/ . accepts any unique abbreviation for a keyword I . allows keywords to have attributes, like "invisible" and "abbreviation" 0 . can supply defaults for fields omitted by user# . provides command retry and recall D . provides command line editing (character, word, and line deletion)I . accepts input from keyboard, command files, macros, or redirected stdin C . allows for full or half duplex operation, character or line input . . allows \-escapes for hard-to-type characters? . allows specification of a user exit to expand variables, etc. O . settable prompt, protected from deletion, dynamically re-evaluated each time.   
 Functions:.  cmsetp - Set prompt (cmprom is prompt string)  cmsavp - Save current prompt   prompt - Issue prompt@  cmini - Clear the command buffer (before parsing a new command)9  cmres - Reset command buffer pointers (before reparsing) !  cmkey - Parse a keyword or token   cmnum - Parse a number !  cmifi - Parse an input file name "  cmofi - Parse an output file name  cmdir - Parse a directory name !  cmfld - Parse an arbitrary field   cmtxt - Parse a text string1  cmcfm - Parse command confirmation (end of line)   
 Return codes: $  -3: no input provided when requiredE  -2: input was invalid (e.g. not a number when a number was required) ;  -1: reparse required (user deleted into a preceding field)    0 or greater: success , See individual functions for greater detail.  M Before using these routines, the caller should #include ckucmd.h, and set the K program's prompt by calling cmsetp().  If the file parsing functions cmifi, M cmofi, or cmdir are to be used, this module must be linked with a ck?fio file K system support module for the appropriate system, e.g. ckufio for Unix.  If N the caller puts the terminal in character wakeup ("cbreak") mode with no echo,K then these functions will provide line editing -- character, word, and line F deletion, as well as keyword and filename completion upon ESC and helpJ strings, keyword, or file menus upon '?'.  If the caller puts the terminalL into character wakeup/noecho mode, care should be taken to restore it beforeN exit from or interruption of the program.  If the character wakeup mode is not. set, the system's own line editor may be used.  M NOTE: Contrary to expectations, many #ifdef's have been added to this module. H Any operation requiring an #ifdef (like clear screen, get character fromN keyboard, erase character from screen, etc) should eventually be turned into aI call to a function that is defined in ck?tio.c, but then all the ck?tio.c # modules would have to be changed...  */   /* Includes */   #include "ckcker.h" 3 #include "ckcasc.h"			/* ASCII character symbols */ I #include "ckucmd.h"                     /* Command parsing definitions */ / #include <errno.h>			/* Error number symbols */   
 #ifdef OSK/ #define cc ccount			/* OS-9/68K compiler bug */  #endif /* OSK */   #ifdef GEMDOS				/* Atari ST */  #ifdef putchar #undef putchar #endif /* putchar */@ #define putchar(x) conoc(x)		/* Why doesn't everyone do this? */ #endif /* GEMDOS */    /* Local variables */    staticK int psetf = 0,                          /* Flag that prompt has been set */ =     cc = 0,                             /* Character count */ ?     dpx = 0,                            /* Duplex (0 = full) */ 8     inword = 0;				/* In the middle of getting a word */   static= int hw = HLPLW,                         /* Help line width */ D     hc = HLPCW,                         /* Help line column width */H     hh,                                 /* Current help column number */H     hx;                                 /* Current help line position */  G #define PROML 160                       /* Maximum length for prompt */   < char *dfprom = "Command? ";             /* Default prompt */  ; int cmflgs;                             /* Command flags */ , int cmfsav;				/* A saved version of them */   #ifdef DCMDBUF% char *cmdbuf;				/* Command buffer */ 5 char *savbuf;				/* Buffer to save copy of command */ 6 char *atmbuf;				/* Atom buffer - for current field */4 char *atxbuf;				/* For expanding the atom buffer *// static char *hlpbuf;			/* Help string buffer */ 4 static char *atybuf;			/* For copying atom buffer */- static char *filbuf;			/* File name buffer */ - static char *cmprom;			/* Program's prompt */ : static char *cmprxx;			/* Program's prompt, unevaluated */   #ifdef CK_RECALL /*M   Command recall is available only if we can make profligate use of malloc().  */7 #define R_MAX 10			/* Max number of commands to save */ < int cm_recall = R_MAX;			/* Size of command recall buffer *// int on_recall = 1;			/* Recall feature is ON */ 
 static int3   current = -1,				/* Pointer to current command */ 6   rlast = -1;				/* Index of last command in buffer */C static char **recall = NULL;		/* Array of recall buffer pointers */  #endif /* CK_RECALL */ #else < char cmdbuf[CMDBL+4];                   /* Command buffer */L char savbuf[CMDBL+4];                   /* Buffer to save copy of command */9 char atmbuf[ATMBL+4];                   /* Atom buffer */ K char atxbuf[CMDBL+4];                   /* For expanding the atom buffer */ 6 static char hlpbuf[HLPBL+4];		/* Help string buffer */; static char atybuf[ATMBL+4];		/* For copying atom buffer */ 4 static char filbuf[ATMBL+4];		/* File name buffer */4 static char cmprom[PROML+1];		/* Program's prompt */A static char cmprxx[PROML+1];		/* Program's prompt, unevaluated */  #endif /* DCMDBUF */   /* Command buffer pointers */   M static char *bp,                        /* Current command buffer position */ D     *pp,                                /* Start of current field */A     *np;                                /* Start of next field */   , static int ungw,			/* For ungetting words */3     atxn;				/* Expansion buffer (atxbuf) length */   
 #ifdef OS2     extern int wideresult; #endif /* OS2 */  * _PROTOTYP( static VOID addhlp, (char *) );( _PROTOTYP( static VOID clrhlp, (void) );( _PROTOTYP( static VOID dmphlp, (void) );' _PROTOTYP( static int gtword, (void) ); ) _PROTOTYP( static int addbuf, (char *) ); . _PROTOTYP( static int setatm, (char *, int) );( _PROTOTYP( static int cmdgetc, (void) );) _PROTOTYP( static VOID cmdnewl, (char) ); , _PROTOTYP( static VOID cmdchardel, (void) );. _PROTOTYP( static VOID cmdecho, (char, int) );) _PROTOTYP( static int test, (int, int) ); 
 #ifdef GEMDOS 0 _PROTOTYP( extern char *strchr, (char *, int) ); #endif /* GEMDOS */    /*  T E S T  --  Bit test  */   
 static intN test(x,m) int x, m; { /*  Returns 1 if any bits from m are on in x, else 0  */     return((x & m) ? 1 : 0); }   1 /*  C M S E T U P  --  Set up command buffers  */    #ifdef DCMDBUF int  cmsetup() { 2     if (!(cmdbuf = malloc(CMDBL + 4))) return(-1);2     if (!(savbuf = malloc(CMDBL + 4))) return(-1);     savbuf[0] = '\0'; 2     if (!(hlpbuf = malloc(HLPBL + 4))) return(-1);2     if (!(atmbuf = malloc(ATMBL + 4))) return(-1);2     if (!(atxbuf = malloc(CMDBL + 4))) return(-1);2     if (!(atybuf = malloc(ATMBL + 4))) return(-1);2     if (!(filbuf = malloc(ATMBL + 4))) return(-1);2     if (!(cmprom = malloc(PROML + 4))) return(-1);2     if (!(cmprxx = malloc(PROML + 4))) return(-1); #ifdef CK_RECALL     cmrini(cm_recall); #endif /* CK_RECALL */     return(0); }    #ifdef CK_RECALL8 /* Initialize or change size of command recall buffer */ int  cmrini(n) int n; {
     int i;2     if (recall) {			/* Free old storage, if any */  	for (i = 0; i < cm_recall; i++) 	  if (recall[i])  	    free(recall[i]);  	free(recall); 	recall = NULL;      } '     cm_recall = n;			/* Set new size */ 4     rlast = current = -1;		/* Initialize pointers */     if (n > 0) {< 	recall = (char **)malloc((cm_recall + 1) * sizeof(char *));
 	if (!recall) 
 	  return(1);   	for (i = 0; i < cm_recall; i++) 	  recall[i] = NULL;     }      return(0); }  #endif /* CK_RECALL */ #endif /* DCMDBUF */  0 /*  C M S E T P  --  Set the program prompt.  */   VOID cmsetp(s) char *s; {      strncpy(cmprxx,s,PROML - 1);     cmprxx[PROML] = NUL;L     psetf = 1;                          /* Flag that prompt has been set. */ } ; /*  C M S A V P  --  Save a copy of the current prompt.  */    VOID #ifdef CK_ANSIC  cmsavp(char s[], int n)  #else  cmsavp(s,n) char s[]; int n; #endif /* CK_ANSIC */  /* cmsavp */ {     strncpy(s,cmprxx,n-1);     s[n-1] = NUL;  }   2 /*  P R O M P T  --  Issue the program prompt.  */   VOID prompt(f) xx_strp f; {     char *sx, *sy; int n;   L     if (psetf == 0) cmsetp(dfprom);     /* If no prompt set, set default. */  )     sx = cmprxx;			/* Unevaluated copy */ 2     if (f) {				/* If conversion function given */! 	sy = cmprom;			/* Evaluate it */  	debug(F101,"PROMPT sx","",sx);  	debug(F101,"PROMPT sy","",sy);  	n = PROML; 4 	if ((*f)(sx,&sy,&n) < 0)	/* If evaluation failed */2 	  sx = cmprxx;			/* revert to unevaluated copy */ 	else  	  sx = cmprom;      } else strcpy(cmprom,sx); 
 #ifdef OSK     fputs(sx, stdout); #else 
 #ifdef MAC     printf("%s", sx);  #else 0     printf("\r%s",sx);			/* Print the prompt. */      fflush(stdout);			/* Now! */ #endif /* MAC */ #endif /* OSK */ }   
 #ifndef NOSPL  VOID- pushcmd() {				/* For use with IF command. */ @     strncpy(savbuf,np,CMDBL);		/* Save the dependent clause,  */3     cmres();				/* and clear the command buffer. */ /     debug(F110, "pushcmd: savbuf:", savbuf, 0);  }  #endif /* NOSPL */   #ifdef COMMENT /* no longer used... */  VOID
 popcmd() {C     strncpy(cmdbuf,savbuf,CMDBL);	/* Put back the saved material */ 5     *savbuf = '\0';			/* and clear the save buffer */      cmres(); }  #endif /* COMMENT */  E /*  C M R E S  --  Reset pointers to beginning of command buffer.  */    VOID	 cmres() { 5     inword = cc = 0;			/* Reset character counter. */ F     pp = np = bp = cmdbuf;              /* Point to command buffer. */D     cmflgs = -5;                        /* Parse not yet started. */2     ungw = 0;				/* Don't need to unget a word. */ }   J /*  C M I N I  --  Clear the command and atom buffers, reset pointers.  */   /*: The argument specifies who is to echo the user's typein --    1 means the cmd package echoes6   0 somebody else (system, front end, terminal) echoes */ VOID cmini(d) int d; { 9     for (bp = cmdbuf; bp < cmdbuf+CMDBL; bp++) *bp = NUL; D     *atmbuf = *savbuf = *atxbuf = *atybuf = *hlpbuf = *filbuf = NUL;     dpx = d;     cmres(); }   
 #ifndef NOSPL H /* The following bits are to allow the command package to call itself */I /* in the middle of a parse.  To do this, begin by calling cmpush, and */  /* end by calling cmpop. */    #ifdef DCMDBUF struct cmp {)     int i[5];				/* stack for integers */ +     char *c[3];				/* stack for pointers */ 2     char *b[8];				/* stack for buffer contents */ }; struct cmp *cmp = 0; #else 2 int cmp_i[CMDDEP+1][5];			/* Stack for integers */2 char *cmp_c[CMDDEP+1][5];		/* for misc pointers */= char *cmp_b[CMDDEP+1][7];		/* for buffer contents pointers */  #endif /* DCMDBUF */  , int cmddep = -1;			/* Current stack depth */   int 0 cmpush() {				/* Save the command environment */(     char *cp;				/* Character pointer */  :     if (cmddep >= CMDDEP)		/* Enter a new command depth */       return(-1); 
     cmddep++; $     debug(F101,"&cmpush","",cmddep);   #ifdef DCMDBUF5     /* allocate memory for cmp if not already done */ N     if (!cmp && !(cmp = (struct cmp *) malloc(sizeof(struct cmp)*(CMDDEP+1)))))       fatal("cmpush: no memory for cmp"); >     cmp[cmddep].i[0] = cmflgs;		/* First do the global ints */     cmp[cmddep].i[1] = cmfsav;     cmp[cmddep].i[2] = atxn;     cmp[cmddep].i[3] = ungw;  :     cmp[cmddep].c[0] = bp;		/* Then the global pointers */     cmp[cmddep].c[1] = pp;     cmp[cmddep].c[2] = np; #else >     cmp_i[cmddep][0] = cmflgs;		/* First do the global ints */     cmp_i[cmddep][1] = cmfsav;     cmp_i[cmddep][2] = atxn;     cmp_i[cmddep][3] = ungw;  :     cmp_c[cmddep][0] = bp;		/* Then the global pointers */     cmp_c[cmddep][1] = pp;     cmp_c[cmddep][2] = np; #endif /* DCMDBUF */  C     /* Now the buffers themselves.  A lot of repititious code... */    #ifdef DCMDBUF?     cp = malloc((int)strlen(cmdbuf)+1);	/* 0: Command buffer */      if (cp) strcpy(cp,cmdbuf);     cmp[cmddep].b[0] = cp;     if (cp == NULL) return(-1);   <     cp = malloc((int)strlen(savbuf)+1);	/* 1: Save buffer */     if (cp) strcpy(cp,savbuf);     cmp[cmddep].b[1] = cp;     if (cp == NULL) return(-1);   C     cp = malloc((int)strlen(hlpbuf)+1);	/* 2: Help string buffer */      if (cp) strcpy(cp,hlpbuf);     cmp[cmddep].b[2] = cp;     if (cp == NULL) return(-1);   <     cp = malloc((int)strlen(atmbuf)+1);	/* 3: Atom buffer */     if (cp) strcpy(cp,atmbuf);     cmp[cmddep].b[3] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(atxbuf)+1);	/* 4: Expansion buffer */      if (cp) strcpy(cp,atxbuf);     cmp[cmddep].b[4] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(atybuf)+1);	/* 5: Atom buffer copy */      if (cp) strcpy(cp,atybuf);     cmp[cmddep].b[5] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(filbuf)+1);	/* 6: File name buffer */      if (cp) strcpy(cp,filbuf);     cmp[cmddep].b[6] = cp;     if (cp == NULL) return(-1);  #else ?     cp = malloc((int)strlen(cmdbuf)+1);	/* 0: Command buffer */      if (cp) strcpy(cp,cmdbuf);     cmp_b[cmddep][0] = cp;     if (cp == NULL) return(-1);   <     cp = malloc((int)strlen(savbuf)+1);	/* 1: Save buffer */     if (cp) strcpy(cp,savbuf);     cmp_b[cmddep][1] = cp;     if (cp == NULL) return(-1);   C     cp = malloc((int)strlen(hlpbuf)+1);	/* 2: Help string buffer */      if (cp) strcpy(cp,hlpbuf);     cmp_b[cmddep][2] = cp;     if (cp == NULL) return(-1);   <     cp = malloc((int)strlen(atmbuf)+1);	/* 3: Atom buffer */     if (cp) strcpy(cp,atmbuf);     cmp_b[cmddep][3] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(atxbuf)+1);	/* 4: Expansion buffer */      if (cp) strcpy(cp,atxbuf);     cmp_b[cmddep][4] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(atybuf)+1);	/* 5: Atom buffer copy */      if (cp) strcpy(cp,atybuf);     cmp_b[cmddep][5] = cp;     if (cp == NULL) return(-1);   A     cp = malloc((int)strlen(filbuf)+1);	/* 6: File name buffer */      if (cp) strcpy(cp,filbuf);     cmp_b[cmddep][6] = cp;     if (cp == NULL) return(-1);  #endif /* DCMDBUF */  3     cmini(dpx);				/* Initize the command parser */      return(0); }    int 2 cmpop() {				/* Restore the command environment */#     debug(F101,"&cmpop","",cmddep); :     if (cmddep < 0) return(-1);		/* Don't pop too much! */   #ifdef DCMDBUF>     cmflgs = cmp[cmddep].i[0];		/* First do the global ints */     cmfsav = cmp[cmddep].i[1];     atxn = cmp[cmddep].i[2];     ungw = cmp[cmddep].i[3];  :     bp = cmp[cmddep].c[0];		/* Then the global pointers */     pp = cmp[cmddep].c[1];     np = cmp[cmddep].c[2]; #elsec>     cmflgs = cmp_i[cmddep][0];		/* First do the global ints */     cmfsav = cmp_i[cmddep][1];     atxn = cmp_i[cmddep][2];     ungw = cmp_i[cmddep][3];  :     bp = cmp_c[cmddep][0];		/* Then the global pointers */     pp = cmp_c[cmddep][1];     np = cmp_c[cmddep][2]; #endif /* DCMDBUF */  %     /* Now the buffers themselves. */    #ifdef DCMDBUF     if (cmp[cmddep].b[0]) {u@ 	strncpy(cmdbuf,cmp[cmddep].b[0],CMDBL); /* 0: Command buffer */ 	free(cmp[cmddep].b[0]); 	cmp[cmddep].b[0] = NULL;s     }t     if (cmp[cmddep].b[1]) {C= 	strncpy(savbuf,cmp[cmddep].b[1],CMDBL); /* 1: Save buffer */  	free(cmp[cmddep].b[1]); 	cmp[cmddep].b[1] = NULL;a     }      if (cmp[cmddep].b[2]) { = 	strncpy(hlpbuf,cmp[cmddep].b[2],HLPBL); /* 2: Help buffer */  	free(cmp[cmddep].b[2]); 	cmp[cmddep].b[2] = NULL;i     }r     if (cmp[cmddep].b[3]) {e@ 	strncpy(atmbuf,cmp[cmddep].b[3],ATMBL); /* 3: Atomic buffer! */ 	free(cmp[cmddep].b[3]); 	cmp[cmddep].b[3] = NULL;c     }      if (cmp[cmddep].b[4]) {EB 	strncpy(atxbuf,cmp[cmddep].b[4],ATMBL); /* 4: eXpansion buffer */ 	free(cmp[cmddep].b[4]); 	cmp[cmddep].b[4] = NULL;m     }t     if (cmp[cmddep].b[5]) {aB 	strncpy(atybuf,cmp[cmddep].b[5],ATMBL); /* 5: Atom buffer copY */ 	free(cmp[cmddep].b[5]); 	cmp[cmddep].b[5] = NULL;p     }f     if (cmp[cmddep].b[6]) { A 	strncpy(filbuf,cmp[cmddep].b[6],ATMBL); /* 6: Filename buffer */t 	free(cmp[cmddep].b[6]); 	cmp[cmddep].b[6] = NULL;      }d #else      if (cmp_b[cmddep][0]) { @ 	strncpy(cmdbuf,cmp_b[cmddep][0],CMDBL); /* 0: Command buffer */ 	free(cmp_b[cmddep][0]); 	cmp_b[cmddep][0] = NULL;u     }k     if (cmp_b[cmddep][1]) {s= 	strncpy(savbuf,cmp_b[cmddep][1],CMDBL); /* 1: Save buffer */i 	free(cmp_b[cmddep][1]); 	cmp_b[cmddep][1] = NULL;h     }t     if (cmp_b[cmddep][2]) {i= 	strncpy(hlpbuf,cmp_b[cmddep][2],HLPBL); /* 2: Help buffer */p 	free(cmp_b[cmddep][2]); 	cmp_b[cmddep][2] = NULL;t     }      if (cmp_b[cmddep][3]) { @ 	strncpy(atmbuf,cmp_b[cmddep][3],ATMBL); /* 3: Atomic buffer! */ 	free(cmp_b[cmddep][3]); 	cmp_b[cmddep][3] = NULL;a     }e     if (cmp_b[cmddep][4]) {nB 	strncpy(atxbuf,cmp_b[cmddep][4],ATMBL); /* 4: eXpansion buffer */ 	free(cmp_b[cmddep][4]); 	cmp_b[cmddep][4] = NULL;e     }i     if (cmp_b[cmddep][5]) { B 	strncpy(atybuf,cmp_b[cmddep][5],ATMBL); /* 5: Atom buffer copY */ 	free(cmp_b[cmddep][5]); 	cmp_b[cmddep][5] = NULL;e     }      if (cmp_b[cmddep][6]) {dA 	strncpy(filbuf,cmp_b[cmddep][6],ATMBL); /* 6: Filename buffer */d 	free(cmp_b[cmddep][6]); 	cmp_b[cmddep][6] = NULL;n     }h #endif /* DCMDBUF */  !     cmddep--;				/* Rise, rise */e#     debug(F101,"&cmpop","",cmddep);g     return(cmddep);  }i #endif /* NOSPL */   #ifdef COMMENT VOIDJ stripq(s) char *s; {                    /* Function to strip '\' quotes */     char *t;     while (*s) {         if (*s == CMDQ) {f5             for (t = s; *t != '\0'; t++) *t = *(t+1);m	         }b         s++;     }o }l #endif /* COMMENT */  ) /* Convert tabs to spaces, one for one */o VOID untab(s) char *s; {t     while (*s) { 	if (*s == HT) *s = SP;" 	s++;w     }e }, h< /*  C M N U M  --  Parse a number in the indicated radix  */   /*2  The only radix allowed in unquoted numbers is 10.,  Parses unquoted numeric strings in base 10.E  Parses backslash-quoted numbers in the radix indicated by the quote:r=    \nnn = \dnnn = decimal, \onnn = octal, \xnn = Hexadecimal. M  If these fail, then if a preprocessing function is supplied, that is applied G  and then a second attempt is made to parse an unquoted decimal string.t  	  Returns:#(    -3 if no input present when required,&    -2 if user typed an illegal number,    -1 if reparse needed,B     0 otherwise, with argument n set to the number that was parsed */ inteI cmnum(xhlp,xdef,radix,n,f) char *xhlp, *xdef; int radix, *n; xx_strp f; {c     int x; char *s, *zp, *zq;   =     if (radix != 10) {                  /* Just do base 10 */i4         printf("cmnum: illegal radix - %d\n",radix);         return(-1);      } '     x = cmfld(xhlp,xdef,&s,(xx_strp)0); $     debug(F101,"cmnum: cmfld","",x);.     if (x < 0) return(x);		/* Parse a field */     zp = atmbuf;  6     if (chknum(zp)) {			/* Check for decimal number */3         *n = atoi(zp);			/* Got one, we're done. */c) 	debug(F101,"cmnum 1st chknum ok","",*n);          return(0);H     } else if ((x = xxesc(&zp)) > -1) {	/* Check for backslash escape */   #ifndef OS2  	*n = x; #else  	*n = wideresult;  #endif /* OS2 */  $ 	debug(F101,"cmnum xxesc ok","",*n); 	return(*zp ? -2 : 0);8     } else if (f) {			/* If conversion function given */%         zp = atmbuf;			/* Try that */d
 	zq = atxbuf;a 	atxn = CMDBL;# 	(*f)(zp,&zq,&atxn);		/* Convert */ 
 	zp = atxbuf;i     }h      debug(F110,"cmnum zp",zp,0);<     if (chknum(zp)) {			/* Check again for decimal number */3         *n = atoi(zp);			/* Got one, we're done. */ ) 	debug(F101,"cmnum 2nd chknum ok","",*n);C         return(0);!     } else {				/* Not numeric */  	return(-2);     }x }m n7 /*  C M O F I  --  Parse the name of an output file  */    /*H  Depends on the external function zchko(); if zchko() not available, use$  cmfld() to parse output file names.  	  Returns: .    -9 like -2, except message already printed,(    -3 if no input present when required,7    -2 if permission would be denied to create the file,e    -1 if reparse needed,<     0 or 1 if file can be created, with xp pointing to name.1     2 if given the name of an existing directory.a */ int;; cmofi(xhlp,xdef,xp,f) char *xhlp, *xdef, **xp; xx_strp f; {i     int x; char *s, *zq;
 #ifdef OS2     int tries; #endif /* OS2 */
 #ifdef DTILDE;/     _PROTOTYP( char * tilde_expand, (char *) );C     char *dirp;o #endif /* DTILDE */a  +     if (*xhlp == NUL) xhlp = "Output file";c
     *xp = "";n  <     if ((x = cmfld(xhlp,xdef,&s,(xx_strp)0)) < 0) return(x);     debug(F111,"cmofi 1",s,x);  3     if (*s == '{') {			/* Strip enclosing braces */e 	int n;  	n = strlen(s);u 	if (s[n-1] == '}') {e 	    s[n-1] = NUL;	 	    s++;s 	}     }/      debug(F110,"cmofi 1.5",s,0);  
 #ifdef OS2     tries = 0;     {A 	char *p = s, q;     /*I       This is really ugly.  If we skip conversion the first time through, K       then variable names like \%a will be used as filenames (e.g. creating K       a file called %A in the root directory).  If we DON'T skip conversionuG       the first time through, then single backslashes used as directoryoJ       separators in filenames will be misinterpreted as variable lead-ins.G       So we prescan to see if it has any variable references.  But thisfI       module is not supposed to know anything about variables, functions,mI       etc, so this code does not really belong here, but rather it shouldd)       be at the same level as zzstring().f     */1 	while ( (tries == 0) && (p = strchr(p,CMDQ)) ) { - 	    q = *(p+1);			/* Char after backslash */, 	    if (!q)			/* None, quit */*
 	      break;n; 	    if (isupper(q))		/* If letter, convert to lowercase */o 	      q = tolower(q);. 	    if (isdigit(q)) {		/* If it's a digit, */1 		tries = 1;		/* assume it's a backslash code  */i 		break; 	    } 	    switch (q) { ) 	      case CMDQ:		/* Double backslash */a3 		tries = 1;		/* so call the conversion function */o 		break;4 	      case '%':			/* Variable or array reference */3 	      case '&':			/* must be followed by letter */b 		if (isalpha(*(p+2))) 		  tries = 1; 		break;; 	      case 'm': case 'v': case '$': /* \m(), \v(), \$() */O 		if (*(p+2) == '(') 		  if (strchr(p+2,')')) 		    tries = 1; 		break;! 	      case 'f':			/* \Fname() */d 		if (strchr(p+2,'(')) 		  if (strchr(p+2,')')) 		      tries = 1; 		break; 	      case '{':			/* \{...} */  		if (strchr(p+2,'}')) 		  tries = 1; 		break;8 	      case 'd': case 'o':	/* Decimal or Octal number */ 	        if (isdigit(*(p+2)))m 		  tries = 1; 		break;# 	      case 'x':			/* Hex number */  		if (isdigit(*(p+2)) ||* 		    ((*(p+2) >= 'a' && *(p+2) <= 'f') ||+ 		     ((*(p+2) >= 'A' && *(p+2) <= 'F'))))o 		  tries = 1; 	      default:f 		break; 	    }	 	    p++;) 	}     }1 o_again:     if (tries == 1)  #endif /* OS2 */7     if (f) {				/* If a conversion function is given */T( 	zq = atxbuf;			/* do the conversion. */ 	atxn = CMDBL;! 	if ((x = (*f)(s,&zq,&atxn)) < 0)= 	  return(-2); 	s = atxbuf;     }      debug(F111,"cmofi 2",s,x);  
 #ifdef DTILDE 8     dirp = tilde_expand(s);		/* Expand tilde, if any, */F     if (*dirp != '\0') setatm(dirp,1);	/* right in the atom buffer. */     s = atmbuf;d     debug(F110,"cmofi 3",s,0); #endif /* DTILDE */E       if (iswild(s)) {2         printf("?Wildcards not allowed - %s\n",s);         return(-2);      }      debug(F110,"cmofi 4",s,0);   #ifdef CK_TMPDIR-     /* isdir() function required for this! */      if (isdir(s)) {)) 	debug(F110,"cmofi 5: is directory",s,0);          *xp = s; 	return(2);e     }* #endif /* CK_TMPDIR */  J     if (strcmp(s,CTTNAM) && (zchko(s) < 0)) { /* OK to write to console */ #ifdef COMMENT
 #ifdef OS2 /*G   We don't try again because we already prescanned the string to see ifr9   if contained anything that could be used by zzstring().R */ 	if (tries++ < 1)D 	  goto o_again; #endif /* OS2 */ #endif /* COMMENT */$ 	debug(F110,"cmofi 6: failure",s,0);4         printf("?Write permission denied - %s\n",s);         return(-9);      } else { 	debug(F110,"cmofi 7: ok",s,0);s         *xp = s;         return(x);     }o }h u9 /*  C M I F I  --  Parse the name of an existing file  */[   /*1  This function depends on the external functions:/9    zchki()  - Check if input file exists and is readable. ;    zxpand() - Expand a wild file specification into a list.r.    znext()  - Return next file name from list.J  If these functions aren't available, then use cmfld() to parse filenames. */ /*  Returns	    -4 EOF/(    -3 if no input present when required,0    -2 if file does not exist or is not readable,    -1 if reparse needed,     0 or 1 otherwise, with:,         xp pointing to name,:         wild = 1 if name contains '*' or '?', 0 otherwise. */ intIK cmifi(xhlp,xdef,xp,wild,f) char *xhlp, *xdef, **xp; int *wild; xx_strp f; {e*     return(cmifi2(xhlp,xdef,xp,wild,0,f)); }m /*G   cmifi2() is for use when you also want to parse a directory or devices5   name as an input file, as in the DIRECTORY command.  */ int/O cmifi2(xhlp,xdef,xp,wild,d,f) char *xhlp,*xdef,**xp; int *wild, d; xx_strp f; {n(     int i, x, xc; long y; char *sp, *zq;     char *sv = NULL;
 #ifdef DTILDEa      char *tilde_expand(), *dirp; #endif /* DTILDE */ 
 #ifdef OS2     int tries; #endif /* OS2 */   #ifndef NOPARTIALp     extern char *mtchs[];) #endif /* NOPARTIAL */  =     inword = cc = xc = 0;		/* Initialize counts & pointers */ 
     *xp = "";b@     if ((x = cmflgs) != 1) {            /* Already confirmed? */<         x = gtword();                   /* No, get a word */     } else {;         setatm(xdef,0);			/* If so, use default, if any. */o     }u  >     *xp = atmbuf;                       /* Point to result. */       while (1) { C         xc += cc;                       /* Count the characters. */ -         debug(F111,"cmifi gtword",atmbuf,xc);P         switch (x) {1             case -4:                    /* EOF */ ;             case -2:                    /* Out of space. */r<             case -1:                    /* Reparse needed */                 return(x);6             case 0:                     /* SP or NL */             case 1:nO                 if (xc == 0) *xp = xdef;     /* If no input, return default. */;M                 if (**xp == NUL) return(-3); /* If field empty, return -3. */u  7 		if (**xp == '{') {	/* Strip enclosing braces first */  		    char *s = *xp; 		    int n; 		    n = strlen(s); 		    if (s[n-1] == '}') { 			s[n-1] = NUL; 			s++;s 			*xp = s;l 		    }s 		}d
 #ifdef OS2# 		if (d && ((int)strlen(*xp) == 2))B+ 		  if (isalpha(**xp) && *(*xp + 1) == ':')o 		    return(x); 		tries = 0; i_again: 		if (tries > 0) #endif /* OS2 */3 		if (f) {		/* If a conversion function is given */m 		    zq = atxbuf;	/* ... */ 		    atxn = CMDBL;f4 		    if ((y = (*f)(*xp,&zq,&atxn)) < 0) return(-2); 		    *xp = atxbuf;m 		}M& 		debug(F110,"cmifi atxbuf",atxbuf,0); 		if (sv) free(sv);C9 		sv = malloc((int)strlen(*xp)+1); /* Make a safe copy */  		if (!sv) {* 		    printf("?malloc error 73, cmifi\n"); 		    return(-9);h 		}e 		strcpy(sv,*xp);  		debug(F110,"cmifi sv",sv,0); 		y = zxpand(*xp); 		*wild = (y > 1);' 		debug(F111,"cmifi sv wild",sv,*wild);s 		if (y == 0) { 
 #ifdef OS2 		    if (tries++ < 1) 		      goto i_again;d #endif /* OS2 */ 		    if (sv) free(sv);  		    if (d) { 			return(-2); 		    } else {( 			printf("?No files match - %s\n",*xp); 			return(-9); 		    }c 		} else if (y < 0) { 1 		    printf("?Too many files match - %s\n",*xp);  		    if (sv) free(sv);  		    return(-9);] 		} else if (y > 1) return(x);  D                 /* If not wild, see if it exists and is readable. */  [+ 		debug(F111,"cmifi sv not wild",sv,*wild);[  4 		znext(*xp);		/* Get first (only?) matching file */>                 y = zchki(*xp);		/* Check its accessibility */4 		zxpand(sv);		/* Rewind so next znext() gets 1st */! 		free(sv);		/* done with this */[ 		sv = NULL;                 if (y == -3) {A                     printf("?Read permission denied - %s\n",*xp);f                     return(-9);f%                 } else if (y == -2) {m 		    if (d) return(0);u<                     printf("?File not readable - %s\n",*xp);                     return(-9);n#                 } else if (y < 0) {(9                     printf("?File not found - %s\n",*xp);b                     return(-9);                  }                  return(x);   #ifndef MAC(1             case 2:                     /* ESC */p$ 		debug(F101,"cmifi esc, xc","",xc);
 #ifdef OS2 		tries = 0; #endif /* OS2 */                 if (xc == 0) {(                     if (*xdef != '\0') {K                         printf("%s ",xdef); /* If at beginning of field, */n
 #ifdef GEMDOSp 			fflush(stdout); #endif /* GEMDOS */x 			inword = cmflgs = 0;f=                         addbuf(xdef);   /* supply default. */p'                         setatm(xdef,0);(8                     } else {            /* No default */%                         putchar(BEL);p                     }p                     break;                 }s
 #ifdef OS2 e_again: 		if (tries > 0) #endif /* OS2 */3 		if (f) {		/* If a conversion function is given */f 		    zq = atxbuf;	/* ... */ 		    atxn = CMDBL;(4 		    if ((x = (*f)(*xp,&zq,&atxn)) < 0) return(-2);J                     /* reduce cc by number of \\ consumed by conversion */A 		    /* function (needed for OS/2, where \ is path separator) */b9                     cc -= (strlen(*xp) - strlen(atxbuf));[ 		    *xp = atxbuf;= 		}L
 #ifdef DTILDE : 		dirp = tilde_expand(*xp);    /* Expand tilde, if any, */> 		if (*dirp != '\0') setatm(dirp,0); /* in the atom buffer. */                 *xp = atmbuf;u #endif /* DTILDE */m                 sp = *xp + cc; #ifdef datageneral=                 *sp++ = '+';		/* Data General AOS wildcard */  #else=*                 *sp++ = '*';		/* Others */ #endif /* datageneral */                 *sp-- = '\0';p
 #ifdef GEMDOSb2 		if (! strchr(*xp, '.'))	/* abde.e -> abcde.e* */* 		  strcat(*xp, ".*");	/* abc -> abc*.* */ #endif /* GEMDOS */tD                 y = zxpand(*xp);	/* Add wildcard and expand list. */% 		if (y > 0) strcpy(filbuf,mtchs[0]);) 		else *filbuf = '\0';>                 *sp = '\0';             /* Remove wildcard. */ 		*wild = (y > 1);                 if (y == 0) {f
 #ifdef OS2 		    if (tries++ < 1) 		      goto e_again;n
 		    else #endif /* OS2 */0 		      printf("?No files match - %s\n",atmbuf);                     return(-9);i#                 } else if (y < 0) {"B                     printf("?Too many files match - %s\n",atmbuf);                     return(-9);=9                 } else if (y > 1) {     /* Not unique. */s #ifndef NOPARTIAL1! /* Partial filename completion */  		    int i, j, k; char c; 		    k = 0;, 		    debug(F111,"cmifi partial",filbuf,cc);* 		    for (i = cc; (c = filbuf[i]); i++) { 			for (j = 1; j < y; j++)! 			  if (mtchs[j][i] != c) break;d 			if (j == y) k++; & 			else filbuf[i] = filbuf[i+1] = NUL; 		    }c- 		    debug(F111,"cmifi partial k",filbuf,k); , 		    if (k > 0) {	/* Got more characters */, 			sp = filbuf + cc; /* Point to new ones */
 #ifdef VMS 			for (i = 0; i < cc; i++) { 8 			    cmdchardel(); /* Back up over old partial spec */ 			    bp--; 			}- 			sp = filbuf;	/* Point to new word start */L) 			debug(F100,"cmifi vms erase ok","",0);p #endif /* VMS *// 			cc = k;		/* How many new ones we just got */[+ 			printf("%s",sp);        /* Print them */L7 			while (*bp++ = *sp++) ;	/* Copy to command buffer */c, 			bp--;	    	        /* Back up over NUL *// 			debug(F110,"cmifi partial cmdbuf",cmdbuf,0);P 			setatm(filbuf,0);0 			debug(F111,"cmifi partial atmbuf",atmbuf,cc); 			*xp = atmbuf; 		    }m #endif /* NOPARTIAL */2 		    putchar(BEL);	/* Beep because not unique. */C                 } else {                /* Unique, complete it.  */  #ifndef VMS[ #ifdef CK_TMPDIR    / 		    /* isdir() function required for this! */i 		    if (isdir(filbuf)) { #ifdef UNIXc 			strcat(filbuf,"/"); #endif
 #ifdef OS2 			strcat(filbuf,"/"); #endif #ifdef AMIGA 			strcat(filbuf,"/"); #endif
 #ifdef OSK 			strcat(filbuf,"/"); #endif #ifdef datageneral 			strcat(filbuf,":"); #endif
 #ifdef MAC 			strcat(filbuf,":"); #endif #ifdef STRATUS 			strcat(filbuf,">"); #endif
 #ifdef GEMDOSd 			strcat(filbuf,"\\");d #endif 			sp = filbuf + cc; 			printf("%s%c",sp,BEL);m 			cc++; 			while (*bp++ = *sp++) ; 			bp--; 			setatm(filbuf,0);2 			debug(F111,"cmifi directory atmbuf",atmbuf,cc); 			*xp = atmbuf;' 		    } else { /* Not a directory... *// #endif /* CK_TMPDIR */ #endif /* VMS */6 			sp = filbuf + cc; /* Point past what user typed. */
 #ifdef VMS 			for (i = 0; i < cc; i++) {p8 			    cmdchardel(); /* Back up over old partial spec */ 			    bp--; 			}- 			sp = filbuf;	/* Point to new word start */  #endif /* VMS */- 			printf("%s ",sp); /* Complete the name. *//
 #ifdef GEMDOSm 			fflush(stdout); #endif /* GEMDOS */ 2 			addbuf(sp);	/* Add the characters to cmdbuf. */) 			setatm(filbuf,0); /* And to atmbuf. */f 			inword = cmflgs = 0;p0 			*xp = atmbuf;	/* Return pointer to atmbuf. */
 			return(0);[ #ifndef VMSc #ifdef CK_TMPDIR 		    }A #endif /* CK_TMPDIR */ #endif /* VMS */                 }c                 break;   ;             case 3:                     /* Question mark */d
 #ifdef OS2 		tries = 0; #endif /* OS2 */!                 if (*xhlp == NUL)e( 		  printf(" Input file specification");                 else 		  printf(" %s",xhlp);e
 #ifdef GEMDOSp 		fflush(stdout);  #endif /* GEMDOS */                  if (xc > 0) {M
 #ifdef OS2 q_again: 		    if (tries > 0) #endif /* OS2 */7 		    if (f) {		/* If a conversion function is given */  			zq = atxbuf;	/* ... */  			atxn = CMDBL;1 			if ((x = (*f)(*xp,&zq,&atxn)) < 0) return(-2);  			*xp = atxbuf; 		    }d
 #ifdef DTILDE/= 		    dirp = tilde_expand(*xp);    /* Expand tilde, if any */c( 		    if (*dirp != '\0') setatm(dirp,0); 		    *xp = atmbuf;  #endif /* DTILDE */ + 		    debug(F111,"cmifi ? *xp, cc",*xp,cc);r:                     sp = *xp + cc;	/* Insert "*" at end */ #ifdef datageneralH                     *sp++ = '+';        /* Insert +, the DG wild card */ #elsen                      *sp++ = '*'; #endif /* datageneral */!                     *sp-- = '\0';s
 #ifdef GEMDOS 6 		    if (! strchr(*xp, '.'))	/* abde.e -> abcde.e* */. 		      strcat(*xp, ".*");	/* abc -> abc*.* */ #endif /* GEMDOS */g' 		    debug(F110,"cmifi ? wild",*xp,0);n$                     y = zxpand(*xp);                     *sp = '\0';r!                     if (y == 0) {r
 #ifdef OS2 			if (tries++ < 1)a 			  goto q_again; 			elsep #endif /* OS2 */- 			  printf("?No files match - %s\n",atmbuf); #                         return(-9); '                     } else if (y < 0) {sF                         printf("?Too many files match - %s\n",atmbuf);#                         return(-9);                      } else {<                         printf(", one of the following:\n");!                         clrhlp();=1                         for (i = 0; i < y; i++) {c*                             znext(filbuf);
 #ifdef VMS: 			    printf(" %s\n",filbuf); /* VMS names can be long */ #elsee+                             addhlp(filbuf);1 #endif /* VMS */                         }e!                         dmphlp();e                     } $                 } else printf("\n");-                 printf("%s%s",cmprom,cmdbuf);  		fflush(stdout);n                 break; #endif /* MAC */	         }t     x = gtword();a     *xp = atmbuf;(     }& }& n6 /*  C M D I R  --  Parse a directory specification  */   /*1  This function depends on the external functions:a9    zchki()  - Check if input file exists and is readable.nJ  If these functions aren't available, then use cmfld() to parse dir names.I  Note: this function quickly cobbled together, mainly by deleting lots of*I  lines from cmifi().  It seems to work, but various services are missing,h<  like completion, lists of matching directories on "?", etc. */ /*  Returns	    -4 EOFa(    -3 if no input present when required,.    -2 if out of space or other internal error,    -1 if reparse needed,=     0 or 1, with xp pointing to name, if directory specified,p!     2 if a wildcard was included.n */ inte; cmdir(xhlp,xdef,xp,f) char *xhlp, *xdef, **xp; xx_strp f; {x     int x, xc; char *zq;
 #ifdef DTILDEx      char *tilde_expand(), *dirp; #endif /* DTILDE */n  =     inword = cc = xc = 0;		/* Initialize counts & pointers */ 
     *xp = ""; @     if ((x = cmflgs) != 1) {            /* Already confirmed? */<         x = gtword();                   /* No, get a word */     } else {;         setatm(xdef,0);			/* If so, use default, if any. */0     }n>     *xp = atmbuf;                       /* Point to result. */     while (1) { C         xc += cc;                       /* Count the characters. */s-         debug(F111,"cmdir gtword",atmbuf,xc);(         switch (x) {1             case -4:                    /* EOF */s;             case -2:                    /* Out of space. */o<             case -1:                    /* Reparse needed */                 return(x);6             case 0:                     /* SP or NL */             case 1:kO                 if (xc == 0) *xp = xdef;     /* If no input, return default. */e 		else *xp = atmbuf;M                 if (**xp == NUL) return(-3); /* If field empty, return -3. */a  7 		if (**xp == '{') {	/* Strip enclosing braces first */  		    char *s = *xp; 		    int n; 		    n = strlen(s); 		    if (s[n-1] == '}') { 			s[n-1] = NUL; 			s++;e 			*xp = s;t 		    }t 		}l #ifndef OS2a3 		if (f) {		/* If a conversion function is given */r 		    zq = atxbuf;	/* ... */ 		    atxn = CMDBL;p4 		    if ((x = (*f)(*xp,&zq,&atxn)) < 0) return(-2); 		    *xp = atxbuf;  		    cc = (int)strlen(atxbuf);* 		}e
 #ifdef DTILDEo7 		dirp = tilde_expand(*xp); /* Expand tilde, if any, */q4 		if (*dirp == '~') {	/* Still starts with tilde? */0 		    char *tp;		/* Yes, convert to lowercase */% 		    tp = *xp;		/* and try again. */o 		    while (*tp) {	( 			if (isupper(*tp)) *tp = tolower(*tp); 			tp++; 		    }  		} 7 		dirp = tilde_expand(*xp); /* Expand tilde, if any, */s #ifdef COMMENT> 		if (*dirp != '\0') setatm(dirp,0); /* in the atom buffer. */ #elser< 		/* This allows for directory names that contain spaces. */ 		if (*dirp != '\0') 		  strcpy(atmbuf,dirp); 		*xp = atmbuf;  #endif /* COMMENT */ #endif /* DTILDE */e #else  /* OS2 */8 		if (isdir(*xp)) {	/* OS/2 version has this function */ 		    return(x);
 		} else {7 		    if (f) {		/* If a conversion function is given */	 			zq = atxbuf;	/* ... */s 			atxn = CMDBL;1 			if ((x = (*f)(*xp,&zq,&atxn)) < 0) return(-2);  			*xp = atxbuf; 			cc = (int)strlen(atxbuf); 		    }r 		}  #endif /* OS2 */ 		if (iswild(*xp)) return(2);& 		else return(x);   1             case 2:                     /* ESC */e 		putchar(BEL);f 		break;  ;             case 3:                     /* Question mark */ !                 if (*xhlp == NUL)) 		  printf(" Directory name");                 else 		  printf(" %s",xhlp);r/                 printf("\n%s%s",cmprom,cmdbuf);t 		fflush(stdout);r                 break;	         }e     x = gtword();s /*  *xp = atmbuf;  */      }p }t  / /*  C M F L D  --  Parse an arbitrary field  */f /*  Returns(    -3 if no input present when required,"    -2 if field too big for buffer,    -1 if reparse needed,.     0 otherwise, xp pointing to string result. */ intf; cmfld(xhlp,xdef,xp,f) char *xhlp, *xdef, **xp; xx_strp f; {      int x, xc;
     char *zq;s  =     inword = cc = xc = 0;		/* Initialize counts & pointers */i
     *xp = "";(@     if ((x = cmflgs) != 1) {            /* Already confirmed? */<         x = gtword();                   /* No, get a word */     } else {;         setatm(xdef,0);			/* If so, use default, if any. */d     }E>     *xp = atmbuf;                       /* Point to result. */       while (1) {oC         xc += cc;                       /* Count the characters. */ .         debug(F111,"cmfld: gtword",atmbuf,xc);#         debug(F101,"cmfld x","",x);b         switch (x) {1             case -4:                    /* EOF */d;             case -2:                    /* Out of space. */,<             case -1:                    /* Reparse needed */                 return(x);6             case 0:                     /* SP or NL */             case 1: A                 if (xc == 0) 		/* If no input, return default. */a 		  setatm(xdef,0);z 		*xp = atmbuf;a3 		if (f) {		/* If a conversion function is given */ " 		    int n;		/* employ it now. */ 		    zq = atxbuf; 		    atxn = CMDBL;u" 		    if ((*f)(*xp,&zq,&atxn) < 0) 		      return(-2);O 		    setatm(atxbuf,0);s 		    *xp = atmbuf;  		}fF                 if (**xp == NUL) {	/* If variable evaluates to null */7 		    setatm(xdef,0);	/* Stick in the default again. */ ? 		    if (**xp == NUL) x = -3; /* If still empty, return -3. */I 		}f #ifdef COMMENT0 /* The following is apparently not necessary. */K /* Remove it if nothing is broken, esp. TAKE file with trailing comments */  		xx = *xp;a( 		debug(F111,"cmfld before trim",*xp,x);+ 		for (i = (int)strlen(xx) - 1; i > 0; i--)c/ 		  if (xx[i] != SP)	/* Trim trailing blanks */  		    break; 		  else 		    xx[i] = NUL; #endif /* COMMENT */$ 		debug(F111,"cmfld returns",*xp,x);                 return(x);1             case 2:                     /* ESC */*.                 if (xc == 0 && *xdef != NUL) {G                     printf("%s ",xdef); /* If at beginning of field, *//
 #ifdef GEMDOS= 		    fflush(stdout);a #endif /* GEMDOS */s=                     addbuf(xdef);       /* supply default. */* 		    inword = cmflgs = 0;B                     setatm(xdef,0);	/* Return as if whole field */G                     return(0);          /* typed, followed by space. */                  } else {I                     putchar(BEL);       /* Beep if already into field. */c                 }                  break;;             case 3:                     /* Question mark */ !                 if (*xhlp == NUL)-:                     printf(" Please complete this field");                 else'                     printf(" %s",xhlp); /                 printf("\n%s%s",cmprom,cmdbuf);  		fflush(stdout);                  break;	         }S     x = gtword();  /*  *xp = atmbuf; */     }  }(    @ /*  C M T X T  --  Get a text string, including confirmation  */   /*E   Print help message 'xhlp' if ? typed, supply default 'xdef' if nullf   string typed.  Returns  ,    -1 if reparse needed or buffer overflows.     1 otherwise.  C   with cmflgs set to return code, and xp pointing to result string.+ */ intpE cmtxt(xhlp,xdef,xp,f) char *xhlp; char *xdef; char **xp; xx_strp f; {B  
     int x, i;(     char *xx, *zq;     static int xc;  *     debug(F101,"cmtxt, cmflgs","",cmflgs);:     inword = cc = 0;			/* Start atmbuf counter off at 0 */;     if (cmflgs == -1) {                 /* If reparsing, */DE         xc = (int)strlen(*xp);		/* get back the total text length, */ 8     } else {                            /* otherwise, */:         *xp = "";                       /* start fresh. */         xc = 0;      }(H     *atmbuf = NUL;                      /* And empty the atom buffer. */     if ((x = cmflgs) != 1) {=         x = gtword();                   /* Get first word. */;A         *xp = pp;                       /* Save pointer to it. */f     }	#     debug(F101,"cmtxt (*f)","", f);a4     while (1) {				/* Loop for each word in text. */G         xc += cc;                       /* Char count for all words. */-.         debug(F111,"cmtxt: gtword",atmbuf,xc);         debug(F101," x","",x);         switch (x) {# 	  case -9:			/* Buffer overflow */  	  case -4:			/* EOF */ 
 #ifdef MAC  	  case -3:			/* Quit/Timeout */ #endif /* MAC */ 	  case -2:			/* Overflow */ 	  case -1:			/* Deletion */ 	    return(x);w 	  case 0:			/* Space */  	    xc++;			/* Just count it */ 	    break;  	  case 1:			/* CR or LF */c 	    if (xc == 0) *xp = xdef;d7 	    if (f) {			/* If a conversion function is given */	3 		zq = atxbuf;		/* Point to the expansion buffer */ ) 		atxn = CMDBL;		/* specify its length */") 		debug(F110,"cmtxt calling (*f)",*xp,0); 0 		if ((x = (*f)(*xp,&zq,&atxn)) < 0) return(-2); 		cc = (int)strlen(atxbuf);(0 		*xp = atxbuf;		/* and return pointer to it. */* 		debug(F111,"cmtxt (*f) returns",*xp,cc); 	    } 	    xx = *xp;. 	    for (i = (int)strlen(xx) - 1; i > 0; i--)3 	      if (xx[i] != SP)		/* Trim trailing blanks */  		break; 	      else  		xx[i] = NUL; 	    return(x);  	  case 2:			/* ESC */ 	    if (xc == 0) {e 		printf("%s ",xdef);  		inword = cmflgs = 0;
 #ifdef GEMDOS" 		fflush(stdout);2 #endif /* GEMDOS */f 		cc = addbuf(xdef);
 	    } else {  		putchar(BEL);  	    } 	    break;'  	  case 3:			/* Question Mark */ 	    if (*xhlp == NUL) 	      printf(" Text string");	 	    else  	      printf(" %s",xhlp);$ 	    printf("\n%s%s",cmprom,cmdbuf); 	    fflush(stdout); 	    break;e 	  default:l> 	    printf("?Unexpected return code from gtword() - %d\n",x); 	    return(-2);	         }          x = gtword();      }  }   & /*  C M K E Y  --  Parse a keyword  */   /*  Call with: 9    table    --  keyword table, in 'struct keytab' format;	+    n        --  number of entries in table;	'    xhlp     --  pointer to help string; +    xdef     --  pointer to default keyword;D  	  Returns:f:    -3       --  no input supplied and no default availableC    -2       --  input doesn't uniquely match a keyword in the table*?    -1       --  user deleted too much, command reparse required -     n >= 0  --  value associated with keywordf */ int  cmkey(table,n,xhlp,xdef,f)J /* cmkey */  struct keytab table[]; int n; char *xhlp, *xdef; xx_strp f; {+     return(cmkey2(table,n,xhlp,xdef,"",f));o }u int  cmkey2(table,n,xhlp,xdef,tok,f)uL     struct keytab table[]; int n; char *xhlp, *xdef; char *tok; xx_strp f; {       int i, tl, y, z, zz, xc;     char *xp, *zq;       tl = (int)strlen(tok);:     inword = xc = cc = 0;		/* Clear character counters. */  F     if ((zz = cmflgs) == 1)             /* Command already entered? */=       setatm(xdef,0);			/* Yes, copy default into atom buf */ <     else zz = gtword();			/* Otherwise get a command word */   ' debug(F101,"cmkey: table length","",n);)  debug(F101," cmflgs","",cmflgs); debug(F101," zz","",zz); while (1) { 
     xc += cc; *     debug(F111,"cmkey: gtword",atmbuf,xc);       switch(zz) {1         case -4:                        /* EOF */	
 #ifdef MAC 	case -3:			/* Quit/Timeout */ #endif /* MAC */=         case -2:                        /* Buffer overflow */uH         case -1:                        /* Or user did some deleting. */              return(cmflgs = zz);  M         case 0:                         /* User terminated word with space */ 8         case 1:                         /* or newline */O             if (cc == 0) setatm(xdef,0); /* Supply default if we got nothing */f7 	    if (f) {			/* If a conversion function is given */) 		zq = atxbuf;		/* apply it */ 		atxn = CMDBL;c- 		if ((*f)(atmbuf,&zq,&atxn) < 0) return(-2);	/ 		debug(F110,"cmkey atxbuf after *f",atxbuf,0);	 		setatm(atxbuf,0);  	    }N             y = lookup(table,atmbuf,n,&z); /* Look up the word in the table */             switch (y) {)                 case -2:		/* Ambiguous */ 7                     printf("?Ambiguous - %s\n",atmbuf);/ 		    cmflgs = -2;                     return(-9); 0                 case -1:		/* Not found at all */ 		    if (tl) {/1 			for (i = 0; i < tl; i++) /* Check for token */g+ 			  if (tok[i] == *atmbuf) { /* Got one */h6 			      ungword();  /* Put back the following word */8 			      return(-5); /* Special return code for token */ 			  } 		    }i/ 		    /* Kludge alert... only print error if */;6 		    /* we were called as cmkey2, but not cmkey... */- 		    /* This doesn't seem to always work. */  		    if (tl == 0) {: 			printf("?No keywords match - %s\n",atmbuf); /* cmkey */ 			return(cmflgs = -9);l 		    } else {5 			if (cmflgs == 1) return(cmflgs = -6); /* cmkey2 */t 			else return(cmflgs = -2);7 			/* The -6 code is to let caller try another table */" 		    }d                 default:                     break; 		}A             return(y);  K         case 2:                         /* User terminated word with ESC */r             if (cc == 0) {?                 if (*xdef != NUL) {     /* Nothing in atmbuf */aC                     printf("%s ",xdef); /* Supply default if any */d
 #ifdef GEMDOSb 		    fflush(stdout);% #endif /* GEMDOS */;!                     addbuf(xdef);-#                     setatm(xdef,0);1 		    inword = cmflgs = 0;;                     debug(F111,"cmkey: default",atmbuf,cc);r                 } else {C                     putchar(BEL);       /* No default, just beep */r                     break;                 }i
             }c7 	    if (f) {			/* If a conversion function is given */b 		zq = atxbuf;		/* apply it */ 		atxn = CMDBL;s- 		if ((*f)(atmbuf,&zq,&atxn) < 0) return(-2);; 		setatm(atxbuf,0);. 	    }D             y = lookup(table,atmbuf,n,&z); /* Something in atmbuf */.             debug(F111,"cmkey: esc",atmbuf,y);+             if (y == -2) {		/* Ambiguous */                  putchar(BEL);/                 break;
             }r+             if (y == -1) {		/* Not found */ N                 /* if (tl == 0) */ printf("?No keywords match - %s\n",atmbuf); 		cmflgs = -2;                 return(-9); 
             }t /*M   See if the keyword just found has the CM_ABR bit set in its flgs field, and K   if so, search forwards in the table for a keyword that has the same kwval K   but does not have CM_ABR (or CM_INV?) set, and then expand using the full N   keyword.  WARNING: This assumes that (a) keywords are in alphabetical order,M   and (b) the CM_ABR bit is set only if the the abbreviated keyword is a true 4   abbreviation (left substring) of the full keyword. */& 	    if (test(table[z].flgs,CM_ABR)) {	 		int zz;  		for (zz = z+1; zz < n; zz++). 		  if ((table[zz].kwval == table[z].kwval) &&) 		      (!test(table[zz].flgs,CM_ABR))) {i 		      z = zz;  		      break; 		  }T
             } #             xp = table[z].kwd + cc;r             printf("%s ",xp);+
 #ifdef GEMDOS" 	    fflush(stdout); #endif /* GEMDOS */              addbuf(xp);  	    inword = cmflgs = 0;d1             debug(F110,"cmkey: addbuf",cmdbuf,0);              return(y);  <         case 3:                         /* User typed "?" */7 	    if (f) {			/* If a conversion function is given */c, 		zq = atxbuf;		/* do the conversion now. */ 		atxn = CMDBL; - 		if ((*f)(atmbuf,&zq,&atxn) < 0) return(-2);  		setatm(atxbuf,0);p 	    }M             y = lookup(table,atmbuf,n,&z); /* Look up what we have so far. */	   	    if (y == -1) { B                 /* if (tl == 0) */ printf(" No keywords match\n"); 		cmflgs = -2;                 return(-9); 
             }              if (*xhlp == NUL)y3                 printf(" One of the following:\n");i             else<                 printf(" %s, one of the following:\n",xhlp);   	    if ((y > -1) &&  		!test(table[z].flgs,CM_ABR) &&9 		((z >= n-1) || strncmp(table[z].kwd,table[z+1].kwd,cc))  		 ) { 		printf(" %s\n",table[z].kwd);+
 	    } else {  		clrhlp();  		for (i = 0; i < n; i++) {S* 		    if (!strncmp(table[i].kwd,atmbuf,cc)! 			&& !test(table[i].flgs,CM_INV)  			) 		      addhlp(table[i].kwd);e 		}/ 		dmphlp();  	    } 	    if (*atmbuf == NUL) { 		if (tl == 1)% 		  printf("or the token %c\n",*tok); < 		else if (tl > 1) printf("or one of the tokens: %s\n",tok); 	    }+             printf("%s%s", cmprom, cmdbuf);r 	    fflush(stdout);             break;           default:E             printf("\n%d - Unexpected return code from gtword\n",zz);i              return(cmflgs = -2);	         }          zz = gtword();     }h }) inth chktok(tlist) char *tlist; {     char *p;     p = tlist;+     while (*p != NUL && *p != *atmbuf) p++;s      return((*p) ? (int) *p : 0); }i  ? /*  C M C F M  --  Parse command confirmation (end of line)  */f   /*  Returns4    -2: User typed anything but whitespace or newline    -1: Reparse neededn      0: Confirmation was received */ ints	 cmcfm() {a     int x, xc;  *     debug(F101,"cmcfm: cmflgs","",cmflgs);)     debug(F110,"cmcfm: atmbuf",atmbuf,0);r     inword = xc = cc = 0;h     if (cmflgs == 1) return(0);y  0     setatm("",0);			/* (Probably unnecessary) */       while (1) {x         x = gtword();x         xc += cc;f         switch (x) {1             case -4:                    /* EOF */              case -2:             case -1:                 return(x);  9             case 1:                     /* End of line */!                 if (xc > 0) {n;                     printf("?Not confirmed - %s\n",atmbuf);t                     return(-9); !                 } else return(0);a             case 2:			/* ESC */  		if (xc == 0) {) 		    putchar(BEL);	/* beep & continue */h$ 		    continue;		/* or fall thru. */ 		} 3             case 0:                     /* Space */12 		if (xc == 0)		/* If no chars typed, continue, */$ 		  continue;		/* else fall thru. */)             case 3:			/* Question mark */                  if (xc > 0) {o;                     printf("?Not confirmed - %s\n",atmbuf);/                     return(-9);                  } M                 printf("\n Type a carriage return to confirm the command\n"); -                 printf("%s%s",cmprom,cmdbuf);l 		fflush(stdout);=                 continue;f	         }U     }r }3 / /* Keyword help routines */*    < /*  C L R H L P -- Initialize/Clear the help line buffer  */   static VOIDxC clrhlp() {                              /* Clear the help buffer */	     hlpbuf[0] = NUL;     hh = hx = 0; }     = /*  A D D H L P  --  Add a string to the help line buffer  */s   static VOID K addhlp(s) char *s; {                    /* Add a word to the help buffer */a
     int j;  ?     hh++;                               /* Count this column */   E     for (j = 0; (j < hc) && (*s != NUL); j++) { /* Fill the column */,         hlpbuf[hx++] = *s++;     }sN     if (*s != NUL)                      /* Still some chars left in string? */J         hlpbuf[hx-1] = '+';             /* Mark as too long for column. */  N     if (hh < (hw / hc)) {               /* Pad col with spaces if necessary */         for (; j < hc; j++) {M             hlpbuf[hx++] = SP;	         }/=     } else {                            /* If last column, */y8         hlpbuf[hx++] = NUL;             /* no spaces. */7         dmphlp();                       /* Print it. */          return;L     }  }s    2 /*  D M P H L P  --  Dump the help line buffer  */   static VOID C dmphlp() {                              /* Print the help buffer */t     hlpbuf[hx++] = NUL;      printf(" %s\n",hlpbuf); 
     clrhlp();( }  )  D /*  G T W O R D  --  Gets a "word" from the command input stream  */   /* Usage: retcode = gtword();   Returns:%  -4 if end of file (e.g. pipe broken)r  -2 if command buffer overflows   -1 if user did some deleting %   0 if word terminates with SP or tab 
   1 if ... CR    2 if ... ESC   3 if ... ? (question mark)   With:(,   pp pointing to beginning of word in buffer'   bp pointing to after current positionx&   atmbuf containing a copy of the wordE   cc containing the number of characters in the word copied to atmbufe */   intt! ungword() {				/* unget a word */      if (ungw) return(0);     cmfsav = cmflgs;+     debug(F101,"ungword cmflgs","",cmflgs); 
     ungw = 1;q     cmflgs = 0;f     return(0); }f  
 static int
 gtword() {:     int c;                              /* Current char */F     int quote = 0;                      /* Flag for quote character */F     int echof = 0;                      /* Flag for whether to echo */7     int chsrc = 0;			/* Source of character, 1 = tty */!0     int comment = 0;			/* Flag for in comment */,     char *cp = NULL;			/* Comment pointer */     int eintr = 0;?     int	brack_knt = 0;			/* nested bracket counter [jrs]	    */   
 #ifdef RTU     extern int rtu_bug;  #endif /* RTU */   #ifdef datageneralC     extern int termtype;                /* DG terminal type flag */aK     extern int con_reads_mt;            /* Console read asynch is active */1N     if (con_reads_mt) connoi_mt();      /* Task would interfere w/cons read */ #endif /* datageneral */  +     if (ungw) {				/* Have a word saved? */,- 	debug(F110,"gtword ungetting from pp",pp,0);p 	while (*pp++ == SP) ; 	setatm(pp,0); 	strcpy(atmbuf,pp);0
 	ungw = 0; 	cmflgs = cmfsav;N5 	debug(F111,"gtword returning atmbuf",atmbuf,cmflgs);) 	return(cmflgs);     } D     pp = np;                            /* Start of current field */  /     debug(F111,"gtword: cmdbuf",cmdbuf,cmdbuf);	     debug(F111," bp",bp,bp);     debug(F111," pp",pp,pp);  F     while (bp < cmdbuf+CMDBL) {         /* Big get-a-character loop */0 	echof = 0;			/* Assume we don't echo because */4 	chsrc = 0;			/* character came from reparse buf. */  O         if ((c = *bp) == NUL) {         /* If no char waiting in reparse buf */=O             if (dpx) echof = 1;         /* must get from tty, set echo flag. */l9 	    c = cmdgetc();		/* Read a character from the tty. */h9 	    chsrc = 1;			/* Remember character source is tty. */	
 #ifdef MAC+ 	    if (c == -3)		/* If null command... */o 	      return(-3); #endif /* MAC */D             if (c == EOF) {		/* This can happen if stdin not tty. */ #ifdef EINTR /*J   Some operating and/or C runtime systems return EINTR for no good reason,J   when the end of the standard input "file" is encountered.  In cases likeM   this, we get into an infinite loop; hence the eintr counter, which is resetx&   to 0 upon each call to this routine. */$ 		debug(F101,"gtword EOF","",errno);? 		if (errno == EINTR && ++eintr < 4) /* When bg'd process is */p  		  continue;		/* fg'd again. */ #endif /* EINTR */
 		return(-4);a 	    }- 	    c &= cmdmsk;		/* Strip any parity bit */  	}				/* if desired. */   $ /* Now we have the next character */  B         if (quote == 0) {		/* If this is not a quoted character */B             if (c == CMDQ) {		/* Got the quote character itself */ 		if (!comment && quoting)1 		  quote = 1;		/* Flag it if not in a comment */ 
             }N$ 	    if (c == FF) {		/* Formfeed. */B                 c = NL;                 /* Replace with newline */ #ifdef COMMENT  /* No more screen clearing... */& 		cmdclrscn();		/* Clear the screen */ #endif /* COMMENT */
             }S 	    if (c == HT) {		/* Tab */$ 		if (comment)		/* If in comment, */# 		  c = SP;		/* substitute space */  		else			/* otherwise */3 		  c = ESC;		/* substitute ESC (for completion) */' 	    }7 	    if (c == ';' || c == '#') { /* Trailing comment */e6 		if (inword == 0 && quoting) { /* If not in a word */) 		    comment = 1;	/* start a comment. */s/ 		    cp = bp;		/* remember where it starts. */r 		}p 	    }+ 	    if (!comment && c == SP) {	/* Space */iB                 *bp++ = c;		/* deposit in buffer if not already */6                 if (echof) putchar(c);  /* echo it. */D                 if (inword == 0) {      /* If leading, gobble it. */                     pp++;c                     continue;cE                 } else {                /* If terminating, return. */* #ifdef COMMENT                     np = bp;!                     setatm(pp,0); (                     inword = cmflgs = 0; 		    return(0); #elsee" /* This allows { ... } grouping */- 		    if ((*pp != '{') || (brack_knt == 0)) {  			np = bp;* 			setatm(pp,0); 			inword = cmflgs = 0; 
 			return(0);  		    }                      continue;  #endif /* COMMENT */                 }l
             }o) 	    if (c == '{') brack_knt++;	/* jrs */ ) 	    if (c == '}') brack_knt--;	/* jrs */   7             if (c == NL || c == CR) {   /* CR or LF. */c- 		if (echof) cmdnewl((char)c); /* Echo it. */t@ 		while (bp > pp && (*(bp-1) == SP || *(bp-1) == HT)) /* Trim */ 		  bp--;			/* trailing */ 		*bp = NUL;		/* whitespace. *//A 		if ((bp > pp) && (*(bp-1) == '-')) { /* This line continued? *//- 		    if (chsrc) {	/* If reading from tty, */  #ifdef COMMENT0 			bp--, pp--;	/* back up the buffer pointer, */ #elsec 			bp--; #endif /* COMMENT */# 			*bp = NUL;	/* erase the dash, */f1 			continue;	/* and go back for next char now. */h 		    }o1 		} else {		/* No, a command has been entered. */h5 		    *bp = NUL;		/* Terminate the command string. */(1 		    if (comment) {	/* If we're in a comment, */(- 			comment = 0;	/* Say we're not any more, */e 			*cp = NUL;	/* cut it off. */1 		    } 0 		    np = bp;		/* Where to start next field. */9 		    setatm(pp,0);	/* Copy this field to atom buffer. */[0 		    inword = 0;		/* Not in a word any more. */ #ifdef CK_RECALL8 		    if (chsrc &&	/* Reading commands from keyboard? */3 			(on_recall) &&	       /* Recall is turned on? */c0 			(cm_recall > 0) &&     /* Saving commands? */1 			(int)strlen(cmdbuf)) { /* Non-null command? */s8 			if (rlast >= cm_recall - 1) { /* Yes, buffer full? */ 			    int i;	   /* Yes. */ 2 			    if (recall[0]) /* Discard oldest command */ 			      free(recall[0]);,3 			    for (i = 0; i < current; i++) /* The rest */l1 			      recall[i] = recall[i+1]; /* move back */t+ 			    rlast--;	 /* Now we have one less */\ 			}2 			rlast++;	 /* Index of last command in buffer */6 			current = rlast; /* Also now the current command */3 			recall[current] = malloc((int)strlen(cmdbuf)+1);i 			if (recall[current])	$ 			  strcpy(recall[current],cmdbuf); 		    }  #endif /* CK_RECALL */ 		    return(cmflgs = 1);  		} 
             }u 	    /* Question mark */=             if (!comment && quoting && echof && (c == '?')) {                  putchar(c);n                 *bp = NUL;                 setatm(pp,0);d#                 return(cmflgs = 3);i
             }0&             if (c == ESC) {		/* ESC */ 		if (!comment) {, 		    *bp = NUL; 		    setatm(pp,0);t 		    return(cmflgs = 2);l
 		} else { 		    putchar(BEL);n 		    continue;h 		}e
             } @             if (c == BS || c == RUB) {  /* Character deletion */C                 if (bp > cmdbuf) {      /* If still in buffer... */y# 		    cmdchardel();	/* erase it. */ >                     bp--;               /* point behind it, */O                     if (*bp == SP) inword = 0; /* Flag if current field gone */yJ                     *bp = NUL;          /* Erase character from buffer. */8                 } else {                /* Otherwise, */3                     putchar(BEL);       /* beep, */eN                     cmres();            /* and start parsing a new command. */ 		    *bp = *atmbuf = NUL;                 }c&                 if (pp < bp) continue;)                 else return(cmflgs = -1);M
             }	?             if (c == LDEL) {            /* ^U, line deletion */ )                 while ((bp--) > cmdbuf) { !                     cmdchardel();O                     *bp = NUL;                 }fB                 cmres();                /* Restart the command. */ 		*bp = *atmbuf = NUL;                 inword = 0; $                 return(cmflgs = -1);
             })?             if (c == WDEL) {            /* ^W, word deletion */ G                 if (bp <= cmdbuf) {     /* Beep if nothing to delete */y!                     putchar(BEL);)                     cmres(); 		    *bp = *atmbuf = NUL;(                     return(cmflgs = -1);                 }                  bp--;b?                 for ( ; (bp >= cmdbuf) && (*bp == SP) ; bp--) { !                     cmdchardel();-                     *bp = NUL;                 }A?                 for ( ; (bp >= cmdbuf) && (*bp != SP) ; bp--) { !                     cmdchardel();e                     *bp = NUL;                 }f                 bp++;                  inword = 0;i$                 return(cmflgs = -1);
             }o;             if (c == RDIS) {            /* ^R, redisplay */; #ifdef COMMENT                 *bp = NUL;/                 printf("\n%s%s",cmprom,cmdbuf);r #else* 		char *cpx; char cx;l                 *bp = NUL;&                 printf("\n%s",cmprom); 		cpx = cmdbuf;	 		while (cx = *cpx++) {i #ifdef isprint& 		    putchar(isprint(cx) ? cx : '^'); #else(1 		    putchar((cx >= SP && cx < DEL) ? cx : '^');  #endif /* isprint */ 		}e #endif /* COMMENT */ 		fflush(stdout);/                 continue;l
             }t #ifdef CK_RECALL8 	    if (chsrc &&		/* Reading commands from keyboard? */+ 		(cm_recall > 0) &&	/* Saving commands? */ . 		(c == C_UP || c == C_UP2)) { /* Go up one */) 		if (current < 0) {	/* Nowhere to go, */ $ 		    putchar(BEL);	/* just beep. */ 		    continue;b 		}	 		if (recall[current]) {, 		    if (!strcmp(recall[current],cmdbuf)) { 			if (current > 0) {f 			    current--;			   			} else {  			    putchar(BEL); 			    continue; 			} 		    }  		}m9 		if (recall[current]) { /* We have a previous command */ 8 		    while ((bp--) > cmdbuf) { /* Erase current line */ 			cmdchardel();
 			*bp = NUL;c 		    } % 		    strcpy(cmdbuf,recall[current]); % 		    printf("\r%s%s",cmprom,cmdbuf);  		    current--; 		} , 		return(cmflgs = -1);	/* Force a reparse */ 	    }8 	    if (chsrc &&		/* Reading commands from keyboard? */+ 		(cm_recall > 0) &&	/* Saving commands? */a  		(c == C_DN)) {		/* Down one */? 		if (current + 1 > rlast) { /* Already at bottom, just beep */  		    putchar(BEL);e 		    continue;; 		} ! 		current++;		/* OK to go down */s 		if (recall[current])( 		  if (!strcmp(recall[current],cmdbuf)) 		    current++; 		if (recall[current]) {8 		    while ((bp--) > cmdbuf) { /* Erase current line */ 			cmdchardel();
 			*bp = NUL;; 		    }s% 		    strcpy(cmdbuf,recall[current]); % 		    printf("\r%s%s",cmprom,cmdbuf);j. 		    return(cmflgs = -1); /* Force reparse */ 		}n 	    } #endif /* CK_RECALL */F 	    if (c < SP && quote == 0) { /* Any other unquoted control char */4 		if (!chsrc) bp++;	/* If cmd file, point past it */2 		else putchar(BEL);	/* otherwise just beep and */0 		continue;		/* continue, don't put in buffer */ 	    }@ 	    if (echof) cmdecho((char) c, 0); /* Echo what was typed. */3         } else {			/* This character was quoted. */t 	    int qf = 1;- 	    quote = 0;			/* Unset the quote flag. */;H 	    /* Quote character at this level is only for SP, ?, and controls */F             /* If anything else was quoted, leave quote in, and let */E 	    /* the command-specific parsing routines handle it, e.g. \007 */s8 	    if (c > 32 && c != '?' && c != RUB && chsrc != 0) {4 		*bp++ = CMDQ;		/* Deposit \ if it came from tty */0 		qf = 0;			/* and don't erase it from screen */ 	    }F 	    if (echof) cmdecho((char) c, qf); /* Now echo quoted character */) 	    debug(F111,"gtword quote",cmdbuf,c);  	} #ifdef COMMENTF         if (echof) cmdecho((char) c,quote); /* Echo what was typed. */ #endif /* COMMENT */=         if (!comment) inword = 1;	/* Flag we're in a word. */ ; 	if (quote) continue;		/* Don't deposit quote character. */ A         if (c != NL) *bp++ = c;		/* Deposit command character. */ >     }                                   /* End of big while */<     putchar(BEL);                       /* Get here if... */=     printf("?Command too long, maximum length: %d.\n",CMDBL);      cmflgs = -2;     return(-9);r }f   /* Utility functions */:  L /* A D D B U F  -- Add the string pointed to by cp to the command buffer  */  
 static int addbuf(cp) char *cp; {     int len = 0;1     while ((*cp != NUL) && (bp < cmdbuf+CMDBL)) { 6         *bp++ = *cp++;                  /* Copy and */C         len++;                          /* count the characters. */	     } D     *bp++ = SP;                         /* Put a space at the end */C     *bp = NUL;                          /* Terminate with a null */ K     np = bp;                            /* Update the next-field pointer */ ?     return(len);                        /* Return the length */  }   < /*  S E T A T M  --  Deposit a token in the atom buffer.  */ /*3   Break on space, newline, carriage return, or NUL.cE   Except flag != 0 means to allow imbedded spaces in selected fields.t   Null-terminate the result.>   If the source pointer is the atom buffer itself, do nothing.B   Return length of token, and also set global "cc" to this length. */
 static int% setatm(cp,flag) char *cp; int flag; {t     char *ap, *xp;     int  brack_knt, n;  &     cc = 0;				/* Character counter *//     ap = atmbuf;			/* Address of atom buffer */   9     if (cp == ap) {			/* In case source is atom buffer */s! 	xp = atybuf;			/* make a copy */a7 	strcpy(xp,ap);			/* so we can copy it back, edited. */ 	 	cp = xp;)     } ,     *ap = NUL;				/* Zero the atom buffer */-     if (flag) {				/* Trim trailing blanks */  	n = strlen(cp); 	while (--n >= 0){ 	  if (cp[n] != SP) break; 	cp[n+1] = NUL;E     } 6     while (*cp == SP) cp++;		/* Trim leading spaces */ #ifdef COMMENT@ /* This one doesn't work for items like "input 20 {\13\10$ }" */(     brack_knt = (*cp == '{');		/* jrs */N     while ( /* (*cp != SP) && */ (*cp != NL) && (*cp != NUL) && (*cp != CR)) {L         if ((*cp == SP) && (flag == 0) && (brack_knt == 0)) break; /* jrs */<         *ap++ = *cp++;			/* Copy up to SP, NL, CR, or end */.         if (*cp == '{') brack_knt++;	/* jrs */.         if (*cp == '}') brack_knt--;	/* jrs */          cc++;				/* and count */     }e #else	     brack_knt = 0;     while (*cp) { $         if (*cp == '{') brack_knt++;$         if (*cp == '}') brack_knt--; 	if (brack_knt == 0) {8 	    if ((*cp == SP || *cp == HT) && (flag == 0)) break;' 	    if (*cp == LF || *cp == CR) break;  	}         *ap++ = *cp++;
         cc++;n     }e #endif /* COMMENT */-     *ap = NUL;				/* Terminate the string. */u<     return(cc);                         /* Return length. */ }   K /*  R D I G I T S  -- Verify that all the characters in line ARE DIGITS  */e   int  rdigits(s) char *s; {I     while (*s) {$         if (!isdigit(*s)) return(0);         s++;     }      return(1); }  hK /* These functions attempt to hide system dependencies from the mainline */ K /* code in gtword().  Ultimately they should be moved to ck?tio.c, where */o6 /* ? = each and every system supported by C-Kermit. */  
 static int2 cmdgetc() {				/* Get a character from the tty. */
     int c;   #ifdef datageneral     { 	 	char ch; , 	c = dgncinb(0,&ch,1);		/* -1 is EOF, -2 TO,@                                          * -c is AOS/VS error */, 	if (c == -2) {			/* timeout was enabled? */- 	    resto(channel(0));		/* reset timeouts */h0 	    c = dgncinb(0,&ch,1);	/* retry this now! */ 	}0 	if (c < 0) return(-4);		/* EOF or some error */8 	else c = (int) ch & 0177;	/* Get char without parity */ /*	echof = 1; */     }* #else /* Not datageneral */ 
 #ifdef GEMDOSN*     c = isatty(0) ? coninc(0) : getchar(); #else 
 #ifdef OS2*     c = isatty(0) ? coninc(0) : getchar();     if (c < 0) return(-4); #else /* Not OS2 */e'     c = getchar();			/* or from tty. */p
 #ifdef RTU     if (rtu_bug) {2 	c = getchar();			/* RTU doesn't discard the ^Z */
 	rtu_bug = 0;f     }" #endif /* RTU */ #endif /* OS2 */ #endif /* GEMDOS */  #endif /* datageneral */*     return(c);				/* Return what we got */ }g     #ifdef COMMENT /*I   No more screen clearing.  If you wanna clear the screen, define a macro 8   to do it, like "define cls write screen \27[;H\27[2J". */' cmdclrscn() {				/* Clear the screen */    #ifdef aegis     putchar(FF); #elsep #ifdef AMIGA     putchar(FF); #else 
 #ifdef OSK     putchar(FF); #elseo #ifdef datageneral     putchar(FF); #else 
 #ifdef OS2     zsystem("cls");c #else      zsystem("clear");u #endif /* OS2 */ #endif /* datageneral */ #endif /* OSK */ #endif /* AMIGA */ #endif /* aegis */ }e #endif /* COMMENT */  3 static VOID				/* What to echo at end of command */  #ifdef CK_ANSIC  cmdnewl(char c)d #else  cmdnewl(c) char c; #endif /* CK_ANSIC */r /* cmdnewl */ { 7     putchar(c);				/* c is the terminating character */r
 #ifdef WINTCPn     if (c == CR) putchar(NL);  #endif /* WINTCP */ 
 #ifdef OS2     if (c == CR) putchar(NL);o #endif /* OS2 */ #ifdef aegis     if (c == CR) putchar(NL);  #endif /* aegis */ #ifdef AMIGA     if (c == CR) putchar(NL);  #endif /* AMIGA */ #ifdef datageneral     if (c == CR) putchar(NL);  #endif /* datageneral */
 #ifdef GEMDOSg     if (c == CR) putchar(NL);d #endif /* GEMDOS */n #ifdef STRATUS     if (c == CR) putchar(NL);p #endif /* STRATUS */ }t   static VOID 9 cmdchardel() {				/* Erase a character from the screen */_     if (!dpx) return;  #ifdef datageneral$     /* DG '\b' is EM (^y or \031) */     if (termtype == 1)1       /* Erase a character from non-DG screen, */w       dgncoub(1,"\010 \010",3);w     else #endif       printf("\b \b");
 #ifdef GEMDOS0     fflush(stdout);  #endif /* GEMDOS */1 }g   static VOID  #ifdef CK_ANSICf cmdecho(char c, int quote) #else # cmdecho(c,quote) char c; int quote;  #endif /* CK_ANSIC */l { /* cmdecho */(     if (!dpx) return;m$     /* Echo tty input character c */     if (quote) {' 	putchar(BS); putchar(SP); putchar(BS);b #ifdef isprint! 	putchar( isprint(c) ? c : '^' );  #else=) 	putchar((c >= SP && c < DEL) ? c : '^');c #endif /* isprint */     } else putchar(c);
 #ifdef OS2'     if (quote==1 && c==CR) putchar(NL);  #endif /* OS2 */ }p   #endif /* NOICP */   #ifdef NOICP #include "ckcdeb.h"s #include "ckucmd.h"c #include "ckcasc.h"== /*** #include <ctype.h> (ckcdeb.h already includes this) ***/= #endif /* NOICP */  1 /*  X X E S C  --  Interprets backslash codes  */ J /*  Returns the int value of the backslash code if it is > -1 and < 256 */N /*  and updates the string pointer to first character after backslash code. */K /*  If the argument is invalid, leaves pointer unchanged and returns -1. */    intt5 xxesc(s) char **s; {			/* Expand backslash escapes */ 8     int x, y, brace, radix;		/* Returns the int value */1     char hd = '9';			/* Highest digit in radix */c     char *p;  )     p = *s;				/* pointer to beginning */o:     if (!p) return(-1);			/* watch out for null pointer */-     x = *p++;				/* character at beginning */dE     if (x != CMDQ) return(-1);		/* make sure it's a backslash code */   2     x = *p;				/* it is, get the next character *//     if (x == '{') {			/* bracketed quantity? */=! 	p++;				/* begin past bracket */h 	x = *p; 	brace = 1;      } else brace = 0;t+     switch (x) {			/* Start interpreting */t0       case 'd':				/* Decimal radix indicator */       case 'D': / 	p++;				/* Just point past it and fall thru *//*       case '0':				/* Starts with digit */       case '1':l0       case '2':  case '3':  case '4':  case '5':0       case '6':  case '7':  case '8':  case '9': 	radix = 10;			/* Decimal */& 	hd = '9';			/* highest valid digit */ 	break;n+       case 'o':				/* Starts with o or O */s       case 'O':  	radix = 8;			/* Octal */	& 	hd = '7';			/* highest valid digit */) 	p++;				/* point past radix indicator */= 	break;/+       case 'x':				/* Starts with x or X */q       case 'X':o  	radix = 16;			/* Hexadecimal */) 	p++;				/* point past radix indicator */* 	break; "       default:				/* All others */ #ifdef COMMENT. 	*s = p+1;			/* Treat as quote of next char */ 	return(*p); #elsei 	return(-1); #endif /* COMMENT */     } F     /* For OS/2, there are "wide" characters required for the keyboardB      * binding, i.e \644 and similar codes larger than 255 (byte).E      * For this purpose, give up checking for < 256. If someone means*G      * \266 should result in \26 followed by a "6" character, he should;F      * always write \{26}6 anyway.  Now, return only the lower byte ofB      * the result, i.e. 10, but eat up the whole \266 sequence andG      * put the wide result 266 into a global variable.  Yes, that's not(B      * the most beautiful programming style but requires the least+      * amount of changes to other routines.       */ 6     if (radix <= 10) {			/* Number in radix 8 or 10 */ 	for ( x = y = 0;i)  	      (*p) && (*p >= '0') && (*p <= hd) 
 #ifdef OS21                    && (y < 4) && (x*radix < 768);oM               /* the maximum needed value \767 is still only 3 digits long */pC               /* while as octal it requires \1377, i.e. 4 digits */w #elsec1                    && (y < 3) && (x*radix < 256);h #endif /* OS2 */ 	      p++,y++) {r# 	    x = x * radix + (int) *p - 48;d 	}
 #ifdef OS24         wideresult = x;			/* Remember wide result */         x &= 255;  #endif /* OS2 */0 	if (y == 0 || x > 255) {	/* No valid digits? */# 	    *s = p;			/* point after it */ ( 	    return(-1);			/* return failure. */ 	}9     } else if (radix == 16) {		/* Special case for hex */n7 	if ((x = unhex(*p++)) < 0) { *s = p - 1; return(-1); }(7 	if ((y = unhex(*p++)) < 0) { *s = p - 2; return(-1); }=$ 	x = ((x << 4) & 0xF0) | (y & 0x0F);
 #ifdef OS2         wideresult = x;f#         if ((y = unhex(*p)) >= 0) {             p++;m1 	   wideresult = ((x << 4) & 0xFF0) | (y & 0x0F);n             x = wideresult & 255;	         }  #endif /* OS2 */     } else x = -1;L     if (brace && *p == '}' && x > -1)	/* Point past closing brace, if any */
       p++;6     *s = p;				/* Point to next char after sequence */0     return(x);				/* Return value of sequence */ },  ' int					/* Convert hex string to int */* #ifdef CK_ANSICc
 unhex(char x)a #elses unhex(x) char x; #endif /* CK_ANSIC */ 
 /* unhex */ {   <     if (x >= '0' && x <= '9')		/* 0-9 is offset by hex 30 */       return(x - 0x30); =     else if (x >= 'A' && x <= 'F')	/* A-F offset by hex 37 */	       return(x - 0x37); =     else if (x >= 'a' && x <= 'f')	/* a-f offset by hex 57 */n;       return(x - 0x57);			/* (obviously ASCII dependent) */	     else return(-1); }	  ' /* See if argument string is numeric */ % /* Returns 1 if OK, zero if not OK */c2 /* If OK, string should be acceptable to atoi() */  /* Allows leading space, sign */   intt1 chknum(s) char *s; {			/* Check Numeric String */c3     int x = 0;				/* Flag for past leading space */ +     int y = 0;				/* Flag for digit seen */      char c;      debug(F110,"chknum",s,0);E?     while (c = *s++) {			/* For each character in the string */a
 	switch (c) { ( 	  case SP:			/* Allow leading spaces */ 	  case HT:n 	    if (x == 0) continue; 	    else return(0);' 	  case '+':			/* Allow leading sign */t 	  case '-': 	    if (x == 0) x = 1;> 	    else return(0); 	    break;e3 	  default:			/* After that, only decimal digits */   	    if (c >= '0' && c <= '9') { 		x = y = 1; 		continue;  	    } else return(0); 	}     }r     return(y); }u  ) /*  L O W E R  --  Lowercase a string  */    int  lower(s) char *s; {a     int n = 0;     while (*s) {*         if (isupper(*s)) *s = tolower(*s);         s++, n++;      }a     return(n); }e  H /*  L O O K U P  --  Lookup the string in the given array of strings  */   /*-  Call this way:  v = lookup(table,word,n,&x);   #    table - a 'struct keytab' table.i5    word  - the target string to look up in the table. /    n     - the number of elements in the table. E    x     - address of an integer for returning the table array index.   H  The keyword table must be arranged in ascending alphabetical order, and  all letters must be lowercase.;  E  Returns the keyword's associated value ( zero or greater ) if found, 0  with the variable x set to the array index, or:  -   -3 if nothing to look up (target was null),W   -2 if ambiguous,   -1 if not found.  E  A match is successful if the target matches a keyword exactly, or if*G  the target is a prefix of exactly one keyword.  It is ambiguous if the 4  target matches two or more keywords from the table. */   int D lookup(table,cmd,n,x) char *cmd; struct keytab table[]; int n, *x; {       int i, v, cmdlen;P  D /* Lowercase & get length of target, if it's null return code -3. */  >     if ((((cmdlen = lower(cmd))) == 0) || (n < 1)) return(-3);   /* Not null, look it up */       for (i = 0; i < n-1; i++) { (         if (!strcmp(table[i].kwd,cmd) ||6            ((v = !strncmp(table[i].kwd,cmd,cmdlen)) &&3              strncmp(table[i+1].kwd,cmd,cmdlen))) {                  *x = i; '                 return(table[i].kwval);;              }         if (v) return(-2);     }    /* Last (or only) element */  .     if (!strncmp(table[n-1].kwd,cmd,cmdlen)) {         *x = n-1;;!         return(table[n-1].kwval);r     } else return(-1); }h  . /* Like lookup, but requires an exact match */   intnE xlookup(table,cmd,n,x) struct keytab table[]; char *cmd; int n, *x; {      int i, cmdlen;     char *p;     cmdlen = (int) strlen(cmd);s$     p = (char *) malloc(cmdlen + 1);5     if (p) {				/* Make a copy that can be changed */  	strcpy(p,cmd);f	 	cmd = p;d; 	if ((((cmdlen = lower(cmd))) == 0) || (n < 1)) return(-3);_ 	for (i = 0; i < n; i++)/ 	  if (((int)strlen(table[i].kwd) == cmdlen) &&,- 	      (!strncmp(table[i].kwd,cmd,cmdlen))) {  	      free(p);	 	      return(table[i].kwval); 	  }	 	free(p);a     }e     return(-1);	 }    intt cmdsquo(x) int x; {e     quoting = x;     return(1); }h   int; cmdgquo() {i     return(quoting); }m