#!/bin/sh

##################################################################
# Function to process the user's response with help if needed    #
##################################################################
YesOrNo()
{
   [ -z "$2" ] && _prompt="$1 [ ? ]: "
   [ -n "$2" ] && _prompt="$1 [ $2 ] [ ? ]: "
   [ -n "$3" -a -z "$2" ] && _prompt="$1 [ ? ](default= $3): "
   [ -n "$3" -a -n "$2" ] && _prompt="$1 [ $2 ] [ ? ](default= $3): "
   case $_prompt in
      ??????????????????????????????????????????????????????????????????*)
         [ -z "$2" ] && _prompt="$1${newline} [ ? ]: "
         [ -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ]: "
         [ -n "$3" -a -z "$2" ] && _prompt="$1${newline} [ ? ](default= $3): "
         [ -n "$3" -a -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ](default= $3): "
      ;;
   esac
   while true
   do
      echo "$_prompt\c"
      read input
      newinput="`echo ${input} | tr '[:upper:]' '[:lower:]'`"
      case $newinput in
         "")
            input=$3; return 0
            ;;
         '?'|h|help)
            help_input "$4"; continue
            ;;
         y|yes)
            input="yes"; return 0
            ;;
         n|no)
            input="no"; return 0
            ;;
         c|client)
            input="client"; return 0
            ;;
         s|server)
            input="server"; return 0
            ;;
         *)
            ;;
      esac
   done
}

help_input()
{
  case "$1" in
   REMOVECMDSCR)  cat<<EOF

   Command Scripter can be automatically removed by ${ScriptName}. If you answer yes to
   this question then Command Scripter ${CMDSCRINST} will be removed. If you answer no to
   this question then ${ScriptName} will exit.

EOF
   ;;
   STOPCMDSCR)  cat<<EOF

   If the Command Scripter daemon is currently running, then the daemon
   must be stopped before continuing with ${ScriptName}. Please stop the
   daemon and then continue with ${ScriptName}.

EOF
   ;;
   esac
}

##################################################################
# Determine if the cmdscr script is running                         #
##################################################################
CheckCMDSCRPid()
{
  ${CLEAR}
  cmdscrcount=0
  while [  -n "`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`" ]; do
    echo "Stopping the Command Scripter daemon"
    cmdscrpid=`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`
    case ${OS} in
      SunOS) if [ -f /etc/rc3.d/S31cmdscr ]; then
               /etc/rc3.d/S31cmdscr stop
               sleep 2
             fi
             ;;
      OSF1) if [ -f /sbin/rc3.d/S*cmdscr ]; then
                 /sbin/rc3.d/S*cmdscr stop
             fi
             ;;
    esac
  done
}

###############################################################################
#  previous install of cmdscr, cliwin, swcc for tru64                            #
###############################################################################
Tru64PreInstallCheck()
{
  if [ ! -f /var/opt/CPQcmdscr/bin/install_info ]; then
    echo "Command Scripter V1.0 must be installed for this update. Exiting $0"
    exit 1
  else
    cat <<EOF

Command Scripter V1.0 must be removed before installing
Command Scripter V1.0A. If you want to install Command Scripter
V1.0A then two options exist:
- Select no to exit this installation script and remove Command Scripter V1.0
  version using documentation that came with Command Scripter and then execute
   this installation script again.
- Select yes to continue this installation script and allow this script to remove
  the Command Scripter V1.0.

EOF
    YesOrNo "Allow this script to remove Command Scripter V1.0?" "y|n" "yes" "REMOVECMDSCR"
    if [ "${input}" = "yes" ]; then
      CheckCMDSCRPid
      rm -rf /var/opt/CPQcmdscr
      if [ $? -ne 0 ]; then
        echo "Error removing Command Scripter V1.0. Exiting ${ScriptName}"
        exit 3
      fi
    else
      exit 99
    fi
  fi
  ## An Command Scripter less than this Command Scripter is installed
  ## An Command Scripter greater than this Command Scripter exists
  CMDSCRINST=`ls /usr/.smdb./CPQCMDSCR*.lk 2> /dev/null | cut -c13- | cut -f 1 -d. | cut -c10-`
  CMDSCRINSTDOTVER=`ls /usr/.smdb./CPQCMDSCR*.lk 2> /dev/null | cut -c13- | cut -f 1 -d. | cut -c10- | sed -n 's/\([0-9]\)\([0-9]\)\([0-9]\)/\1.\2/p'`;export CMDSCRINSTDOTVER
  if [ "${CMDSCRINSTDOTVER}" = "1.0" ]; then
    CMDSCRINSTDOTVER=1.0A
  fi
  if [ -n "${CMDSCRINST}" ]; then
    if [ ${CMDSCRINST} -lt ${CMDSCRVER} ]; then
      cat <<EOF

Command Scripter ${PREFIX}${CMDSCRINSTDOTVER} must be removed before installing
Command Scripter ${PREFIX}${CMDSCRDOTVER}. If you want to install Command Scripter
${PREFIX}#{CMDSCRDOTVER} then two options exist:
- Select no to exit this installation script and remove the older Command Scripter
  version using documentation that came with this Command Scripter version. Rerun
  this installation script again.
- Select yes to continue this installation script and allow this script to remove
  the older Command Scripter version.

EOF
      YesOrNo "Allow this script to continue and remove Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}?" "y|n" "yes" "REMOVECMDSCR"
      if [ "${input}" = "yes" ]; then
        CheckCMDSCRPid
        setld -d CPQCMDSCR${CMDSCRINST}
        if [ $? -ne 0 ]; then
          echo "Error removing CMDSCR ${PREFIX}${CMDSCRINSTDOTVER}. Exiting ${ScriptName}"
          exit 3
        fi
      else
        exit 99
      fi
    fi
  
    if [ ${CMDSCRINST} -eq ${CMDSCRVER} ]; then
      cat <<EOF

Command Scripter ${PREFIX}${CMDSCRINSTDOTVER} is already installed. To reinstall
Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}, two options exist:
- Select no to exit this installation script and remove Command Scripter using
  documentation that came with this Command Scripter version, then execute this
  installation script again
- Select yes to continue this installation script and allow this script to remove
  Command Scripter

EOF
      YesOrNo "Allow this script to remove CMDSCR ${PREFIX}${CMDSCRINSTDOTVER}?" "y|n" "yes" "REMOVECMDSCR"
      if [ "${input}" = "yes" ]; then
        CheckCMDSCRPid
        setld -d CPQCMDSCR${CMDSCRINST}
        if [ $? -ne 0 ]; then
          echo "Error removing CMDSCR ${PREFIX}${CMDSCRINSTDOTVER}. Exiting ${ScriptName}"
          exit 3
        fi
      else
        exit 99
      fi
    fi
  fi
}

###############################################################################
# Miscellaneous                                                               #
###############################################################################
if [ -f /usr/bin/uname ]; then
  OS=`/usr/bin/uname -s`;export OS
elif [ -f /bin/uname ]; then
  OS=`/bin/uname -s`;export OS
else
  OS=`uname -s > /dev/null`;export OS
fi

###############################################################################
# Call this script CheckInstall.sh instead of ./CheckInstall.sh               #
###############################################################################
if [ -f /usr/bin/basename ]; then
   ScriptName=`/usr/bin/basename $0`;export ScriptName
elif [ -f /bin/basename ]; then
   ScriptName=`/bin/basename $0`;export ScriptName
else
   ScriptName=`basename $0 > /dev/null`;export ScriptName
fi

###############################################################################
# OS specific variables                                                       # 
###############################################################################
PREFIX=V;export PREFIX
CMDSCRVER=101;export CMDSCRVER
CMDSCRDOTVER=1.0A;export CMDSCRDOTVER
StartDir=`pwd`;export StartDir
CMDSCRHome=/var/opt/CPQcmdscr; export CMDSCRHome
CLEAR="/bin/clear"

###############################################################################
# Call the correct preinstall check                                           #
###############################################################################
if [ "${OS}" = "OSF1" ]; then
  Tru64PreInstallCheck
else
  echo "${ScriptName} can only be used on a Compaq Tru64 host. Exiting ${ScriptName}"
fi

echo "Returning to install.sh"
