#!/bin/sh

##################################################################
# Function to process the user's response with help if needed    #
##################################################################
YesOrNo()
{
   [ -z "$2" ] && _prompt="$1 [ ? ]: "
   [ -n "$2" ] && _prompt="$1 [ $2 ] [ ? ]: "
   [ -n "$3" -a -z "$2" ] && _prompt="$1 [ ? ](default= $3): "
   [ -n "$3" -a -n "$2" ] && _prompt="$1 [ $2 ] [ ? ](default= $3): "
   case $_prompt in
      ??????????????????????????????????????????????????????????????????*)
         [ -z "$2" ] && _prompt="$1${newline} [ ? ]: "
         [ -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ]: "
         [ -n "$3" -a -z "$2" ] && _prompt="$1${newline} [ ? ](default= $3): "
         [ -n "$3" -a -n "$2" ] && _prompt="$1${newline} [ $2 ] [ ? ](default= $3): "
      ;;
   esac
   while true
   do
      echo "$_prompt\c"
      read input
      newinput="`echo ${input} | tr '[:upper:]' '[:lower:]'`"
      case $newinput in
         "")
            input=$3; return 0
            ;;
         '?'|h|help)
            help_input "$4"; continue
            ;;
         y|yes)
            input="yes"; return 0
            ;;
         n|no)
            input="no"; return 0
            ;;
         c|client)
            input="client"; return 0
            ;;
         s|server)
            input="server"; return 0
            ;;
         *)
            ;;
      esac
   done
}

help_input()
{
  case "$1" in
   REMOVECMDSCR)  cat<<EOF

   Command Scripter can be automatically removed by ${ScriptName}. If you answer yes to
   this question then Command Scripter ${CMDSCRINST} will be removed. If you answer no to
   this question then ${ScriptName} will exit.

EOF
   ;;
   STOPCMDSCR)  cat<<EOF

   If the Command Scripter daemon is currently running, then the daemon
   must be stopped before continuing with ${ScriptName}. Please stop the
   daemon and then continue with ${ScriptName}.

EOF
   ;;
   REMOVEELM)  cat<<EOF

   ELM can be automatically removed by ${ScriptName}. Before answering yes
   to this question, ensure that ELM is not being used by any other product.
   If you answer yes to this question then ELM ${ELMINST} will be removed.
   If you answer no to this question then ${ScriptName} will exit.

EOF
   ;;
  esac
}

##################################################################
# Determine if the cmdscr script is running                         #
##################################################################
CheckCMDSCRPid()
{
  ${CLEAR}
  cmdscrcount=0
  while [  -n "`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`" ]; do
    cmdscrpid=`ps -e | grep cmdscrip | grep -v grep | awk '{print $1}'`
    echo "Stopping the Command Scripter daemon"
    if [ -f /sbin/rc3.d/S*cmdscr ]; then
      /sbin/rc3.d/S*cmdscr stop
    fi
  done
}

###############################################################################
#  previous install of cmdscr, cliwin, swcc for tru64                         #
###############################################################################
Tru64PreDeleteCheck()
{
  if [ -f /var/opt/CPQcmdscr/bin/install_info ]; then
    cat <<EOF

Command Scripter V1.0 is installed. If you want to delete
Command Scripter V1.0 then two options exist:
- Select no to exit this delete script and remove Command Scripter
  using documentation that came with this Command Scripter version.
  Rerun this delete script again.
- Select yes to continue this delete script and allow this script to remove
   Command Scripter

EOF
    YesOrNo "Allow this script to continue and remove Command Scripter V1.0?" "y|n" "yes" "REMOVECMDSCR"
    if [ "${input}" = "yes" ]; then
      CheckCMDSCRPid
      echo "rm -rf /var/opt/CPQcmdscr" > /tmp/delete.sh
      echo "if [ $? -ne 0 ]; then" >> /tmp/delete.sh
      echo "  echo "Error removing CMDSCR ${PREFIX}${CMDSCRINSTDOTVER}. Exiting ${ScriptName}"" >> /tmp/delete.sh
      echo "  exit 1" >> /tmp/delete.sh
      echo "fi" >> /tmp/delete.sh
      cd /tmp
      /tmp/delete.sh
    else
      exit 1
    fi
  fi  
  ## An Command Scripter less than this Command Scripter is delete
  ## An Command Scripter greater than this Command Scripter exists
  CMDSCRINST=`ls /usr/.smdb./CPQCMDSCR*.lk 2> /dev/null | cut -c13- | cut -f 1 -d. | cut -c10-`
  CMDSCRINSTDOTVER=`ls /usr/.smdb./CPQCMDSCR*.lk 2> /dev/null | cut -c13- | cut -f 1 -d. | cut -c10- | sed -n 's/\([0-9]\)\([0-9]\)\([0-9]\)/\1.\2/p'`;export CMDSCRINSTDOTVER
  if [ "${CMDSCRINSTDOTVER}" = "1.0" ]; then
    CMDSCRINSTDOTVER=1.0A
  fi
  if [ -n "${CMDSCRINST}" ]; then
    if [ ${CMDSCRINST} -lt ${CMDSCRVER} ]; then
      cat <<EOF

Command Scripter ${PREFIX}${CMDSCRINSTDOTVER} is installed. If you want to delete
Command Scripter ${PREFIX}#{CMDSCRDOTVER} then two options exist:
- Select no to exit this delete script and remove the older Command Scripter version
  using documentation that came with this Command Scripter version. Rerun this delete
  script again.
- Select yes to continue this delete script and allow this script to remove the older
   Command Scripter version.

EOF
      YesOrNo "Allow this script to continue and remove Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}?" "y|n" "yes" "REMOVECMDSCR"
      if [ "${input}" = "yes" ]; then
        CheckCMDSCRPid
        setld -d CPQCMDSCR${CMDSCRINST}
        if [ $? -ne 0 ]; then
          echo "Error removing CMDSCR ${PREFIX}${CMDSCRINSTDOTVER}. Exiting ${ScriptName}"
          exit 1
        fi
      else
        exit 1
      fi
    fi
  
if [ ${CMDSCRINST} -eq ${CMDSCRVER} ]; then
      cat <<EOF

Command Scripter ${PREFIX}${CMDSCRINSTDOTVER} is installed. To delete Command Scripter
${PREFIX}${CMDSCRINSTDOTVER}, two options exist:
- Select no to exit this delete script and remove Command Scripter using documentation
  that came with this Command Scripter version
- Select yes to continue this delete script and allow this script to remove Command Scripter

EOF
      YesOrNo "Allow this script to remove Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}?" "y|n" "yes" "REMOVECMDSCR"
      if [ "${input}" = "yes" ]; then
        CheckCMDSCRPid
        setld -d CPQCMDSCR${CMDSCRINST}
        if [ $? -ne 0 ]; then
          echo "Error removing Command Scripter ${PREFIX}${CMDSCRINSTDOTVER}. Exiting ${ScriptName}"
          exit 1
        fi
      else
        exit 1
      fi
    fi
  fi
}

###############################################################################
# Determine the type of host, be it Solaris, AIX, or Tru64                    #
###############################################################################
if [ -f /usr/bin/uname ]; then
  OS=`/usr/bin/uname -s`;export OS
elif [ -f /bin/uname ]; then
  OS=`/bin/uname -s`;export OS
else
  OS=`uname -s > /dev/null`;export OS
fi

###############################################################################
# Call this script CheckInstall.sh instead of ./CheckInstall.sh               #
###############################################################################
if [ -f /usr/bin/basename ]; then
   ScriptName=`/usr/bin/basename $0`;export ScriptName
elif [ -f /bin/basename ]; then
   ScriptName=`/bin/basename $0`;export ScriptName
else
   ScriptName=`basename $0 > /dev/null`;export ScriptName
fi

###############################################################################
# OS specific variables                                                       # 
###############################################################################
PREFIX=V;export PREFIX
CMDSCRVER=101;export CMDSCRVER
CMDSCRDOTVER=1.0A;export CMDSCRDOTVER
StartDir=`pwd`;export StartDir
if [ "${OS}" = "OSF1" ]; then
  CMDSCRHome=/var/opt/CPQcmdscr; export CMDSCRHome
  CLEAR="/bin/clear"
else
  echo "${ScriptName} can only be used on a Compaq Tru64 host. Exiting ${ScriptName}"
fi

###############################################################################
# Call the correct predelete check                                           #
###############################################################################
if [ "${OS}" = "OSF1" ]; then
  Tru64PreDeleteCheck
else
  echo "${ScriptName} can only be used on a Compaq Tru64 host. Exiting ${ScriptName}"
fi
