@@owmr922.plb
update wmsys.wm$env_vars set value = '9.2.0.1.0' where name = 'OWM_VERSION';
commit;
/*
 * Re-insert sentinel rows and de-populate ltlock columns
 * ======================================================
 */
create or replace function wm$getNullInsStr wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
39
2 :e:
1FUNCTION:
1WM$GETNULLINSSTR:
1SCHEMA:
1VARCHAR2:
1TAB_NAME:
1RETURN:
1L_COLUMN_NAME:
140:
1NULL_STR:
132000:
1FOUND:
1INTEGER:
1DEFAULTVALUE:
1LONG:
1CURSOR:
1COL_INFO_CUR:
1COLUMN_NAME:
1ALL_TAB_COLUMNS:
1OWNER:
1=:
1TABLE_NAME:
1||:
1_LT:
1WMSYS:
1WM$NESTED_COLUMNS_TABLE:
1VERSION:
1CREATETIME:
1RETIRETIME:
1NEXTVER:
1DELSTATUS:
1LTLOCK:
1NOT_LIKE:
1WM$%:
1COLUMN_ID:
1OPEN:
1LOOP:
11:
1DUAL:
1ALL_CONS_COLUMNS:
1INSTR:
1":
1>:
10:
1EXISTS:
1DATA_DEFAULT:
1DBA_TAB_COLUMNS:
1UPPER:
1NO_DATA_FOUND:
1COUNT:
1DBA_PART_KEY_COLUMNS:
1NAME:
1OBJECT_TYPE:
1TABLE:
1null:
1EXIT:
1NOTFOUND:
1,:
0

0
0
189
2
0 a0 8d 8f a0 b0 3d 8f
a0 b0 3d b4 :2 a0 2c 6a a3
a0 51 a5 1c 81 b0 a3 a0
51 a5 1c 81 b0 a3 a0 1c
81 b0 a3 a0 1c 81 b0 a0
f4 b4 bf c8 a0 ac a0 b2
ee :2 a0 7e b4 2e :2 a0 :2 7e 6e
b4 2e b4 2e a 10 a0 4c
a0 ac :2 a0 6b b2 ee :2 a0 7e
b4 2e :2 a0 7e b4 2e a 10
ac d0 eb 48 a 10 a0 4c
:6 6e 5 48 a 10 a0 7e 6e
b4 2e a 10 ac d0 a0 de
ac e5 e9 bd b7 11 a4 b1
:2 a0 e9 dd b3 :2 a0 e9 d3 a0
51 ac :2 a0 b2 ee 51 ac a0
b2 ee :2 a0 7e b4 2e :2 a0 :2 7e
6e b4 2e b4 2e a 10 a0
6e 7e a0 b4 2e 7e 6e b4
2e 6e 7e a0 b4 2e 7e 6e
b4 2e a5 b 7e 51 b4 2e
a 10 ac d0 eb 7e b4 2e
ac e5 d0 b2 e9 a0 ac :2 a0
b2 ee :2 a0 7e b4 2e :2 a0 :2 7e
6e b4 2e b4 2e a 10 :2 a0
7e a0 a5 b b4 2e a 10
ac e5 d0 b2 e9 :2 a0 7e a0
b4 2e d b7 :2 a0 d2 9f ac
:2 a0 b2 ee :2 a0 7e b4 2e :2 a0
:2 7e 6e b4 2e b4 2e a 10
:2 a0 6e a5 b 7e 51 b4 2e
a 10 :2 a0 7e b4 2e a 10
ac e5 d0 b2 e9 a0 7e 51
b4 2e 5a a0 ac :2 a0 b2 ee
:2 a0 7e b4 2e :2 a0 :2 7e 6e b4
2e b4 2e a 10 :2 a0 7e a0
a5 b b4 2e a 10 ac e5
d0 b2 e9 :2 a0 7e a0 b4 2e
d b7 :2 a0 7e 6e b4 2e d
b7 :2 19 3c b7 a6 9 a4 b1
11 4f :2 a0 e9 d3 :3 a0 f 2b
:2 a0 7e 6e b4 2e d b7 a0
47 :2 a0 5a 65 b7 a4 b1 11
68 4f 1d 17 b5 
189
2
0 3 7 23 1f 1e 2b 38
34 1b 40 33 45 49 4d 51
6b 59 30 5d 5e 66 58 88
76 55 7a 7b 83 75 a4 93
97 9f 72 bc ab af b7 92
c3 c7 8f d8 db df e3 e4
e8 e9 f0 f4 f8 fb fc 101
105 109 10c 10f 114 115 11a 11b
1 120 125 1 129 12d 12e 132
136 139 13a 141 145 149 14c 14d
152 156 15a 15d 15e 1 163 168
169 16d 171 1 174 179 1 17d
182 187 18c 191 196 19b 19f 1
1a2 1a7 1ab 1ae 1b3 1b4 1 1b9
1be 1bf 1c3 1c7 1c9 1ca 1d0 1d5
1da 1dc 1e8 1ec 1ee 1f2 1f6 1fb
1ff 200 204 208 20d 212 216 219
21a 21e 222 223 22a 22d 22e 232
233 23a 23e 242 245 246 24b 24f
253 256 259 25e 25f 264 265 1
26a 26f 273 278 27b 27f 280 285
288 28d 28e 293 298 29b 29f 2a0
2a5 2a8 2ad 2ae 2b3 2b4 2b6 2b9
2bc 2bd 1 2c2 2c7 2c8 2cc 2d0
2d3 2d4 2d9 2da 2e0 2e4 2e5 2ea
2ee 2ef 2f3 2f7 2f8 2ff 303 307
30a 30b 310 314 318 31b 31e 323
324 329 32a 1 32f 334 338 33c
33f 343 344 346 347 1 34c 351
352 358 35c 35d 362 366 36a 36d
371 372 377 37b 37d 381 385 389
38c 38d 391 395 396 39d 3a1 3a5
3a8 3a9 3ae 3b2 3b6 3b9 3bc 3c1
3c2 3c7 3c8 1 3cd 3d2 3d6 3da
3df 3e0 3e2 3e5 3e8 3e9 1 3ee
3f3 3f7 3fb 3fe 3ff 1 404 409
40a 410 414 415 41a 41e 421 424
425 42a 42d 431 432 436 43a 43b
442 446 44a 44d 44e 453 457 45b
45e 461 466 467 46c 46d 1 472
477 47b 47f 482 486 487 489 48a
1 48f 494 495 49b 49f 4a0 4a5
4a9 4ad 4b0 4b4 4b5 4ba 4be 4c0
4c4 4c8 4cb 4d0 4d1 4d6 4da 4dc
4e0 4e4 4e7 4e9 4ea 4ef 4f3 4f5
501 503 507 50b 510 515 519 51d
521 526 52c 530 534 537 53c 53d
542 546 548 54c 553 557 55b 55e
562 564 568 56a 576 57a 57c 57d
586 
189
2
0 1 a 1c 23 :2 1c 2d 36
:2 2d 1a 41 48 :2 1 3 12 1b
1a :2 12 :2 3 12 1b 1a :2 12 :2 3
:3 12 :2 3 :3 12 :2 3 a 0 :2 3 :3 c
5 :2 c 14 :3 12 c 19 17 22
25 :2 19 :2 17 :3 c 18 :2 26 24 2a
24 1f 24 25 2d :3 2b 1f 2c
:3 2a :2 25 :2 1f 1e :4 c 18 20 2a
37 44 4e 5a :5 c 18 21 :4 c
:2 5 :2 e :3 5 :5 3 5 a :3 5 b
1d :3 5 :2 10 17 22 1d 22 :2 12
19 14 19 30 38 :3 36 b 18
16 21 24 :2 18 :2 16 :2 30 b 11
14 16 :2 11 21 23 :2 11 27 2a
2c :2 27 39 3b :2 27 :2 b 40 42
:2 40 :2 30 14 b 34 :3 2d 1d :4 9
:2 12 24 12 b :2 12 1a :3 18 11
1e 1c 27 2a :2 1e :2 1c :2 12 15
23 21 29 :2 23 :2 21 :2 12 :6 b 17
21 24 :2 17 b 7 16 :4 10 1e
10 9 :2 10 18 :3 16 10 17 15
20 23 :2 17 :2 15 :3 10 16 23 :2 10
2c 2e :2 2c :3 10 1e :3 1c :2 10 :5 9
e 14 16 :2 14 c :2 15 27 15
e :2 15 1d :3 1b 14 21 1f 2a
2d :2 21 :2 1f :2 15 18 26 24 2c
:2 26 :2 24 :2 15 :6 e 1a 23 26 :2 1a
e 1a c 18 21 24 :2 18 c
:4 9 24 :2 11 7 :3 5 d 1f :3 7
11 1e 11 :2 7 13 1c 1f :2 13
7 5 9 1 5 d b 5
:9 1 
189
4
0 :f 1 :7 3 :7 4
:5 5 :5 6 :2 8 0
:2 8 :2 9 :3 a :5 b
:9 c :2 b :4 d :5 e
:5 f :5 10 :2 f e
:3 d :2 b :a 11 :2 b
:5 12 :2 b a 9
:3 13 :2 9 :5 8 :5 15
:4 16 17 :6 19 :a 1a
:9 1b :2 1a :19 1c :4 1a
:9 19 :3 1f :3 20 :5 21
:9 22 :2 21 :8 23 :2 21
20 :4 1f :7 25 18
27 :5 28 :3 29 :5 2a
:9 2b :2 2a :9 2c :2 2a
:5 2d :2 2a 29 :4 28
:6 2f :3 31 :3 32 :5 33
:9 34 :2 33 :8 35 :2 33
32 :4 31 :7 37 2f
:7 39 38 :3 2f :4 27
:3 17 :4 3d :5 3e :7 40
17 41 14 :4 43
:2 14 :7 1 
588
4
:3 0 1 :3 0 2
:a 0 184 1 :7 0
5 30 0 3
4 :3 0 3 :7 0
5 4 :3 0 8
:2 0 7 4 :3 0
5 :7 0 9 8
:3 0 6 :3 0 4
:3 0 b d 0
184 2 e :2 0
a :2 0 c 4
:3 0 a 11 13
:6 0 16 14 0
182 0 7 :6 0
12 8f 0 10
4 :3 0 e 18
1a :6 0 1d 1b
0 182 0 9
:9 0 14 c :3 0
1f :7 0 22 20
0 182 0 b
:6 0 e :3 0 24
:7 0 27 25 0
182 0 d :6 0
f :3 0 10 :a 0
2 77 :4 0 29
2c 0 2a :3 0
11 :3 0 16 12
:3 0 18 30 6f
0 70 :3 0 13
:3 0 3 :3 0 14
:2 0 1c 34 35
:3 0 15 :3 0 5
:3 0 14 :2 0 16
:2 0 17 :4 0 1f
3a 3c :3 0 24
39 3e :3 0 36
40 3f :2 0 11
:3 0 11 :3 0 27
18 :3 0 19 :2 0
4 46 47 0
29 49 56 0
57 :3 0 13 :3 0
3 :3 0 14 :2 0
2d 4d 4e :3 0
15 :3 0 5 :3 0
14 :2 0 32 52
53 :3 0 4f 55
54 :4 0 45 4a
0 58 :3 0 42
43 59 41 5b
5a :2 0 11 :3 0
1a :4 0 1b :4 0
1c :4 0 1d :4 0
1e :4 0 1f :4 0
35 :3 0 5d 5e
65 5c 67 66
:2 0 11 :3 0 20
:2 0 21 :4 0 3c
6a 6c :3 0 68
6e 6d :4 0 2e
31 0 22 :3 0
1 72 3f 71
0 74 :4 0 75
:2 0 78 29 2c
79 0 182 41
79 7b 78 7a
:6 0 77 :7 0 79
23 :3 0 10 :4 0
7f :2 0 180 7d
80 :3 0 10 :3 0
7 :4 0 84 :2 0
180 81 82 :3 0
24 :3 0 25 :2 0
43 b :3 0 26
:3 0 45 8a c1
0 c2 :3 0 25
:2 0 47 27 :3 0
49 8f bb 0
bc :3 0 13 :3 0
3 :3 0 14 :2 0
4d 93 94 :3 0
15 :3 0 5 :3 0
14 :2 0 16 :2 0
17 :4 0 50 99
9b :3 0 55 98
9d :3 0 95 9f
9e :2 0 28 :3 0
29 :4 0 16 :2 0
11 :3 0 58 a3
a5 :3 0 16 :2 0
29 :4 0 5b a7
a9 :3 0 29 :4 0
16 :2 0 7 :3 0
5e ac ae :3 0
16 :2 0 29 :4 0
61 b0 b2 :3 0
64 a1 b4 2a
:2 0 2b :2 0 69
b6 b8 :3 0 a0
ba b9 :4 0 8d
90 0 bd :3 0
2c :2 0 6c bf
c0 :4 0 c4 c5
:5 0 87 8b 0
6e 0 c3 :2 0
f3 2d :3 0 70
d :3 0 2e :3 0
72 cb e6 0
e7 :3 0 13 :3 0
3 :3 0 14 :2 0
76 cf d0 :3 0
15 :3 0 5 :3 0
14 :2 0 16 :2 0
17 :4 0 79 d5
d7 :3 0 7e d4
d9 :3 0 d1 db
da :2 0 11 :3 0
2f :3 0 14 :2 0
7 :3 0 81 de
e1 85 df e3
:3 0 dc e5 e4
:3 0 e9 ea :5 0
c8 cc 0 88
0 e8 :2 0 f3
9 :3 0 9 :3 0
16 :2 0 7 :3 0
8a ee f0 :3 0
ec f1 0 f3
8d 167 30 :3 0
31 :3 0 f7 :3 0
31 :2 0 91 b
:3 0 32 :3 0 93
fb 11e 0 11f
:3 0 13 :3 0 3
:3 0 14 :2 0 97
ff 100 :3 0 33
:3 0 5 :3 0 14
:2 0 16 :2 0 17
:4 0 9a 105 107
:3 0 9f 104 109
:3 0 101 10b 10a
:2 0 28 :3 0 34
:3 0 35 :4 0 a2
10d 110 2a :2 0
2b :2 0 a7 112
114 :3 0 10c 116
115 :2 0 11 :3 0
7 :3 0 14 :2 0
ac 11a 11b :3 0
117 11d 11c :3 0
121 122 :5 0 f8
fc 0 af 0
120 :2 0 162 b
:3 0 2a :2 0 2b
:2 0 b3 125 127
:3 0 128 :2 0 2d
:3 0 b6 d :3 0
2e :3 0 b8 12e
149 0 14a :3 0
13 :3 0 3 :3 0
14 :2 0 bc 132
133 :3 0 15 :3 0
5 :3 0 14 :2 0
16 :2 0 17 :4 0
bf 138 13a :3 0
c4 137 13c :3 0
134 13e 13d :2 0
11 :3 0 2f :3 0
14 :2 0 7 :3 0
c7 141 144 cb
142 146 :3 0 13f
148 147 :3 0 14c
14d :5 0 12b 12f
0 ce 0 14b
:2 0 156 9 :3 0
9 :3 0 16 :2 0
7 :3 0 d0 151
153 :3 0 14f 154
0 156 d3 15f
9 :3 0 9 :3 0
16 :2 0 36 :4 0
d6 159 15b :3 0
157 15c 0 15e
d9 160 129 156
0 161 0 15e
0 161 db 0
162 de 164 e1
163 162 :2 0 165
e3 :2 0 167 0
167 166 f3 165
:6 0 179 3 :3 0
10 :3 0 7 :4 0
16c :2 0 179 169
16a :3 0 37 :3 0
10 :3 0 38 :3 0
16e 16f :4 0 170
:3 0 179 9 :3 0
9 :3 0 16 :2 0
39 :4 0 e5 174
176 :3 0 172 177
0 179 e8 17b
24 :4 0 179 :4 0
180 6 :3 0 9
:3 0 17d :2 0 17e
:2 0 180 ed 183
:3 0 183 f2 183
182 180 181 :6 0
184 :2 0 2 e
183 187 :3 0 186
184 188 :8 0 
f8
4
:3 0 1 3 1
7 2 6 a
1 12 1 10
1 19 1 17
1 1e 1 23
1 2d 1 2f
1 33 2 32
33 2 38 3b
1 3d 2 37
3d 1 44 1
48 1 4c 2
4b 4c 1 51
2 50 51 6
5f 60 61 62
63 64 2 69
6b 1 73 1
76 1 86 1
89 1 8c 1
8e 1 92 2
91 92 2 97
9a 1 9c 2
96 9c 2 a2
a4 2 a6 a8
2 ab ad 2
af b1 2 aa
b3 1 b7 2
b5 b7 1 be
1 88 1 c7
1 ca 1 ce
2 cd ce 2
d3 d6 1 d8
2 d2 d8 1
e0 1 e2 2
dd e2 1 c9
2 ed ef 3
c6 eb f2 1
f6 1 fa 1
fe 2 fd fe
2 103 106 1
108 2 102 108
2 10e 10f 1
113 2 111 113
1 119 2 118
119 1 f9 1
126 2 124 126
1 12a 1 12d
1 131 2 130
131 2 136 139
1 13b 2 135
13b 1 143 1
145 2 140 145
1 12c 2 150
152 2 14e 155
2 158 15a 1
15d 2 15f 160
2 123 161 1
f4 1 164 2
173 175 4 167
16b 171 178 4
7e 83 17b 17f
5 15 1c 21
26 77 
1
4
0 
187
0
1
14
4
8
0 1 1 3 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
17 1 0
1e 1 0
7 1 0
2 0 1
29 1 2
23 1 0
10 1 0
3 1 0
0

/
create or replace function wm$getWhereClauseStr wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
8
9200000
1
4
0 
1c
2 :e:
1FUNCTION:
1WM$GETWHERECLAUSESTR:
1STR:
1VARCHAR2:
1PRFX1:
1PRFX2:
1RETURN:
1RETVAL:
132000:
1:
1COMMA_POS:
1INTEGER:
1COL_WIDTH:
1COLNAME:
150:
11:
10:
1INSTR:
1,:
1LOOP:
1-:
1SUBSTR:
1||:
1 = :
1+:
1EXIT:
1=:
1 AND :
0

0
0
95
2
0 a0 8d 8f a0 b0 3d 8f
a0 b0 3d 8f a0 b0 3d b4
:2 a0 2c 6a a3 a0 51 a5 1c
6e 81 b0 a3 a0 1c 81 b0
a3 a0 1c 81 b0 a3 a0 51
a5 1c 81 b0 a0 51 d a0
51 d :3 a0 6e a0 51 a5 b
d :3 a0 7e a0 b4 2e d :5 a0
a5 b d :2 a0 7e a0 b4 2e
7e a0 b4 2e 7e 6e b4 2e
7e a0 b4 2e 7e a0 b4 2e
d :2 a0 7e a0 b4 2e 7e 51
b4 2e d :3 a0 6e a0 51 a5
b d :2 a0 7e 51 b4 2e 2b
:2 a0 7e 6e b4 2e d b7 a0
47 :2 a0 5a 65 b7 a4 b1 11
68 4f 1d 17 b5 
95
2
0 3 7 23 1f 1e 2b 38
34 1b 40 49 45 33 51 30
56 5a 5e 62 84 6a 6e 71
72 7a 7f 69 a0 8f 93 9b
66 b8 a7 ab b3 8e d5 c3
8b c7 c8 d0 c2 dc bf e0
e4 e8 eb ef f3 f7 fb 100
104 107 108 10a 10e 112 116 11a
11d 121 122 127 12b 12f 133 137
13b 13f 140 142 146 14a 14e 151
155 156 15b 15e 162 163 168 16b
170 171 176 179 17d 17e 183 186
18a 18b 190 194 198 19c 19f 1a3
1a4 1a9 1ac 1af 1b0 1b5 1b9 1bd
1c1 1c5 1ca 1ce 1d1 1d2 1d4 1d8
1dc 1e0 1e3 1e6 1e7 1ec 1f2 1f6
1fa 1fd 202 203 208 20c 20e 212
219 21d 221 224 228 22a 22e 230
23c 240 242 243 24c 
95
2
0 1 a 20 24 :2 20 2e 34
:2 2e 3e 44 :2 3e 1e 4f 56 :2 1
5 11 1a 19 11 24 11 :2 5
:3 11 :2 5 :3 11 :2 5 11 1a 19 :2 11
5 4 19 :2 4 19 :2 4 16 1d
22 27 32 :2 16 :2 4 6 13 1d
1f :2 13 :2 6 13 1b 20 2b :2 13
:2 6 10 17 1a :2 10 20 23 :2 10
2b 2e :2 10 34 38 :2 10 3e 41
:2 10 :2 6 13 1d 1f :2 13 29 2a
:2 13 :2 6 14 1b 20 25 30 :2 14
:2 6 10 1a 1c :2 1a :2 6 10 17
1a :2 10 6 4 8 1 4 b
a 4 :9 1 
95
4
0 :13 1 :8 3 :5 4
:5 5 :7 6 :3 a :3 b
:9 d f :7 10 :8 11
:17 13 :b 15 :9 16 :7 17
:7 19 f 1a 8
:4 1c :2 8 :7 1 
24e
4
:3 0 1 :3 0 2
:a 0 90 1 :7 0
5 30 0 3
4 :3 0 3 :7 0
5 4 :3 0 9
:2 0 7 4 :3 0
5 :7 0 9 8
:3 0 4 :3 0 6
:7 0 d c :3 0
7 :3 0 4 :3 0
f 11 0 90
2 12 :2 0 11
8b 0 f 4
:3 0 9 :2 0 d
15 17 :6 0 a
:4 0 1b 18 19
8e 0 8 :6 0
f :2 0 13 c
:3 0 1d :7 0 20
1e 0 8e 0
b :6 0 c :3 0
22 :7 0 25 23
0 8e 0 d
:6 0 10 :2 0 17
4 :3 0 15 27
29 :6 0 2c 2a
0 8e 0 e
:6 0 b :3 0 2d
2e 0 8c d
:3 0 11 :2 0 30
31 0 8c d
:3 0 12 :3 0 3
:3 0 13 :4 0 b
:3 0 10 :2 0 19
34 39 33 3a
0 8c 14 :3 0
d :3 0 d :3 0
15 :2 0 b :3 0
1e 3f 41 :3 0
3d 42 0 85
e :3 0 16 :3 0
3 :3 0 b :3 0
d :3 0 21 45
49 44 4a 0
85 8 :3 0 8
:3 0 17 :2 0 5
:3 0 25 4e 50
:3 0 17 :2 0 e
:3 0 28 52 54
:3 0 17 :2 0 18
:4 0 2b 56 58
:3 0 17 :2 0 6
:3 0 2e 5a 5c
:3 0 17 :2 0 e
:3 0 31 5e 60
:3 0 4c 61 0
85 b :3 0 b
:3 0 19 :2 0 d
:3 0 34 65 67
:3 0 19 :2 0 10
:2 0 37 69 6b
:3 0 63 6c 0
85 d :3 0 12
:3 0 3 :3 0 13
:4 0 b :3 0 10
:2 0 3a 6f 74
6e 75 0 85
1a :3 0 d :3 0
1b :2 0 11 :2 0
41 79 7b :4 0
7c :3 0 85 8
:3 0 8 :3 0 17
:2 0 1c :4 0 44
80 82 :3 0 7e
83 0 85 47
87 14 :4 0 85
:4 0 8c 7 :3 0
8 :3 0 89 :2 0
8a :2 0 8c 4f
8f :3 0 8f 55
8f 8e 8c 8d
:6 0 90 :2 0 2
12 8f 93 :3 0
92 90 94 :8 0

5a
4
:3 0 1 3 1
7 1 b 3
6 a e 1
16 1 14 1
1c 1 21 1
28 1 26 4
35 36 37 38
2 3e 40 3
46 47 48 2
4d 4f 2 51
53 2 55 57
2 59 5b 2
5d 5f 2 64
66 2 68 6a
4 70 71 72
73 1 7a 2
78 7a 2 7f
81 7 43 4b
62 6d 76 7d
84 5 2f 32
3b 87 8b 4
1a 1f 24 2b

1
4
0 
93
0
1
14
2
8
0 1 0 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1c 1 0
26 1 0
7 1 0
b 1 0
14 1 0
21 1 0
3 1 0
2 0 1
0

/
create or replace procedure wm$Fixsentinelandltlock wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
7
9200000
1
4
0 
52
2 :e:
1WM$FIXSENTINELANDLTLOCK:
1SCHEMA:
1VARCHAR2:
1TAB_NAME:
1SQL_STRING1:
18000:
1SQL_STRING2:
1NEXT_VER:
150:
1VERSION_VAR:
1INTEGER:
1LTLOCK_VAR:
1100:
1ROWID_VAR:
1ROWID:
1TYPE:
1CURSOR_TYPE:
1REF:
1CURSOR:
1C1:
1C2:
1KEYCOLS:
14000:
1MD_STR:
1HIST_VAR:
1WHERE_CLAUSE_STR:
1PKEY_COLS:
1HIST:
1WMSYS:
1WM$VERSIONED_TABLES:
1OWNER:
1=:
1TABLE_NAME:
1WM$GETWHERECLAUSESTR:
1||:
1,:
1t1.:
1t2.:
1:n    select min(rowid) from :
1.:
1_LT  :n      where version > 0:n      and ((:
1) not in :n           (select :
1 from :
1_LT :n            where version = 0 or version = -1):n          ):n    group +
1by :
1OPEN:
1LOOP:
1EXIT:
1NOTFOUND:
1:n       select t1.version, t1.ltlock from :
1_LT t1, :
1_LT t2:n          where substr(t1.ltlock, :n                       (instr(t1.+
1ltlock, ',',:n                            instr(t1.ltlock, '*',1,1) ,:n      +
1                      2) + 1), :n                       (instr(t1.ltlock,'*',+
11,2) - :n                        instr(t1.ltlock, ',', :n                    +
1         instr(t1.ltlock, '*',:n                             1,1) ,2) - 1):n +
1                   ) = '-1':n       and t2.rowid = ':
1':n       and :
1CLOSE:
1RAISE_APPLICATION_ERROR:
1-:
120000:
1Internal error while populating sentinel rows:
1IS NOT NULL:
1INSTR:
1*:
1>:
10:
1SUBSTR:
11:
1@:
12:
1+:
1NONE:
1,-1,':
1',-9,':
1':
1,-1,null,null,':
1EXECUTE:
1IMMEDIATE:
1insert into :
1_LT :n       select :
1WM$GETNULLINSSTR:
1:n       from :
1_LT where rowid = ':
1update :
1_LT :n                      set ltlock = substr(ltlock,1,instr(ltlock,'@',1,2+
1)) || substr(ltlock,instr(ltlock,'*',1,2)+1):n                      where (lt+
1lock is not null and instr(ltlock,'*',1,1) > 0) :n                      and v+
1ersion >= 0:
1COMMIT:
0

0
0
1fd
2
0 9a 8f a0 b0 3d 8f a0
b0 3d b4 55 6a a3 a0 51
a5 1c 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 51 a5 1c
81 b0 a3 a0 1c 81 b0 a3
a0 51 a5 1c 81 b0 a3 a0
1c 81 b0 a0 9d :2 a0 c8 77
a3 a0 1c 81 b0 a3 a0 1c
81 b0 a3 a0 51 a5 1c 81
b0 a3 a0 51 a5 1c 81 b0
a3 a0 51 a5 1c 81 b0 a3
a0 51 a5 1c 81 b0 :2 a0 ac
:4 a0 6b b2 ee :2 a0 7e b4 2e
:2 a0 7e b4 2e a 10 ac e5
d0 b2 e9 :3 a0 7e 6e b4 2e
:2 6e a5 b d a0 6e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e d :3 a0 11c 11d :3 a0 e9
d3 :3 a0 f 2b a0 6e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e 7e 6e b4 2e 7e a0
b4 2e d a0 6e d :3 a0 11c
11d :4 a0 e9 d3 5 :3 a0 f 2b
:2 a0 7e a0 b4 2e 7e 6e b4
2e d b7 a0 47 :2 a0 e9 c1
a0 7e 6e b4 2e 5a a0 7e
51 b4 2e 6e a5 57 b7 19
3c a0 7e b4 2e :2 a0 6e a5
b 7e 51 b4 2e a 10 5a
:3 a0 51 :2 a0 6e :2 51 a5 b a5
b 7e :4 a0 6e :2 51 a5 b 7e
51 b4 2e a5 b b4 2e d
b7 19 3c a0 7e 6e b4 2e
5a a0 6e 7e a0 b4 2e 7e
6e b4 2e 7e a0 b4 2e 7e
6e b4 2e d b7 a0 6e 7e
a0 b4 2e 7e 6e b4 2e 7e
a0 b4 2e 7e 6e b4 2e d
b7 :2 19 3c :2 a0 6e 7e a0 b4
2e 7e 6e b4 2e 7e a0 b4
2e 7e 6e b4 2e 7e :3 a0 a5
b b4 2e 7e a0 b4 2e 7e
6e b4 2e 7e a0 b4 2e 7e
6e b4 2e 7e a0 b4 2e 7e
6e b4 2e 7e a0 b4 2e 7e
6e b4 2e 11e 11d b7 a0 47
:2 a0 e9 c1 :2 a0 6e 7e a0 b4
2e 7e 6e b4 2e 7e a0 b4
2e 7e 6e b4 2e 11e 11d a0
57 a0 b4 e9 b7 a4 b1 11
68 4f 1d 17 b5 
1fd
2
0 3 1f 1b 1a 27 34 30
17 3c 2f 41 45 5f 4d 2c
51 52 5a 4c 7c 6a 49 6e
6f 77 69 99 87 66 8b 8c
94 86 b5 a4 a8 b0 83 d1
bc c0 c3 c4 cc a3 ed dc
e0 e8 a0 d8 104 f8 fc 100
f4 120 10f 113 11b 10e 13c 12b
12f 137 10b 158 143 147 14a 14b
153 12a 175 163 127 167 168 170
162 192 180 15f 184 185 18d 17f
1af 19d 17c 1a1 1a2 1aa 19c 1b6
1ba 199 1be 1c2 1c6 1ca 1ce 1d1
1d2 1d9 1dd 1e1 1e4 1e5 1ea 1ee
1f2 1f5 1f6 1 1fb 200 201 207
20b 20c 211 215 219 21d 220 225
226 22b 230 235 236 238 23c 240
245 248 24c 24d 252 255 25a 25b
260 263 267 268 26d 270 275 276
27b 27e 282 283 288 28b 290 291
296 299 29d 29e 2a3 2a6 2ab 2ac
2b1 2b4 2b8 2b9 2be 2c1 2c6 2c7
2cc 2cf 2d3 2d4 2d9 2dc 2e1 2e2
2e7 2ea 2ee 2ef 2f4 2f8 2fc 300
304 307 30b 30f 313 317 31c 321
325 329 32d 332 338 33c 341 344
348 349 34e 351 356 357 35c 35f
363 364 369 36c 371 372 377 37a
37e 37f 384 387 38c 38d 392 395
399 39a 39f 3a2 3a7 3a8 3ad 3b0
3b4 3b5 3ba 3bd 3c2 3c3 3c8 3cb
3cf 3d0 3d5 3d9 3dd 3e2 3e6 3ea
3ee 3f2 3f5 3f9 3fd 401 405 409
40e 413 417 41b 41f 423 428 42e
432 436 439 43d 43e 443 446 44b
44c 451 455 457 45b 462 466 46a
46f 471 475 478 47d 47e 483 486
48a 48d 490 491 496 49b 49c 4a1
4a3 4a7 4aa 4ae 4b1 4b2 4b7 4bb
4bf 4c4 4c5 4c7 4ca 4cd 4ce 1
4d3 4d8 4db 4df 4e3 4e7 4ea 4ee
4f2 4f7 4fa 4fd 4fe 500 501 503
506 50a 50e 512 516 51b 51e 521
522 524 527 52a 52b 530 531 533
534 539 53d 53f 543 546 54a 54d
552 553 558 55b 55f 564 567 56b
56c 571 574 579 57a 57f 582 586
587 58c 58f 594 595 59a 59e 5a0
5a4 5a9 5ac 5b0 5b1 5b6 5b9 5be
5bf 5c4 5c7 5cb 5cc 5d1 5d4 5d9
5da 5df 5e3 5e5 5e9 5ed 5f0 5f4
5f8 5fd 600 604 605 60a 60d 612
613 618 61b 61f 620 625 628 62d
62e 633 636 63a 63e 642 643 645
646 64b 64e 652 653 658 65b 660
661 666 669 66d 66e 673 676 67b
67c 681 684 688 689 68e 691 696
697 69c 69f 6a3 6a4 6a9 6ac 6b1
6b2 6b7 6bc 6c0 6c2 6c6 6cd 6d1
6d5 6da 6dc 6e0 6e4 6e9 6ec 6f0
6f1 6f6 6f9 6fe 6ff 704 707 70b
70c 711 714 719 71a 71f 724 728
72c 731 735 736 73b 73d 741 743
74f 753 755 756 75f 
1fd
2
0 b 24 2b :2 24 35 3e :2 35
22 :2 1 2 e 17 16 :2 e :2 2
e 17 16 :2 e :2 2 b 14 13
:2 b :2 2 :3 e :2 2 e 17 16 :2 e
:2 2 :3 e :2 2 7 16 1a 16 :2 2
:3 5 :2 2 :3 5 :2 2 a 13 12 :2 a
:2 2 a 13 12 :2 a :2 2 b 14
13 :2 b :2 2 13 1c 1b :2 13 2
9 14 9 1e 27 7 d 7
2 7 8 10 :3 e 1b 28 :3 26
:2 8 :6 2 16 2b 33 36 :2 2b 3b
42 :2 16 :2 2 11 1e 21 :2 11 28
2b :2 11 2f 32 :2 11 3b 3e :2 11
f 12 :2 11 1a 1d :2 11 16 19
:2 11 21 24 :2 11 2d 30 :2 11 37
3a :2 11 3e 41 :2 11 4a 4d :2 11
10 13 :2 11 2 4 9 :2 10 :2 4
c 14 :3 6 10 13 10 :2 6 15
2c 2f :2 15 36 39 :2 15 3d 40
:2 15 49 4c :2 15 57 5a :2 15 61
64 :2 15 68 6b :2 15 74 77 :2 15
1b 1e :2 15 28 2b :2 15 e 11
:2 15 :2 6 12 :2 6 b :2 12 :2 6 e
16 23 :4 8 12 15 12 :2 8 14
1d 20 :2 14 2c 2f :2 14 8 6
a 4 6 c :2 6 9 12 14
:2 12 :2 8 20 21 :2 20 28 :2 8 19
:2 6 :4 9 24 2a 35 :2 24 3a 3c
:2 3a :2 9 :2 8 16 1d 28 2a 30
3b 3f 41 :2 2a :2 16 45 48 4f
5a 60 6b 6f 71 :2 5a 73 74
:2 5a :2 48 :2 16 8 3f :2 6 9 12
14 :2 12 :2 8 12 1b 1e :2 12 27
2a :2 12 35 38 :2 12 43 46 :2 12
8 1c 8 12 25 28 :2 12 31
34 :2 12 3f 42 :2 12 4d 50 :2 12
8 :5 6 e 18 27 2a :2 18 31
34 :2 18 38 3b :2 18 44 47 :2 18
11 14 25 2d :2 14 :2 18 37 3a
:2 18 41 44 :2 18 f 12 :2 18 19
1c :2 18 20 23 :2 18 2c 2f :2 18
46 49 :2 18 53 56 :2 18 :2 6 4
8 1 4 a :3 4 c 16 20
23 :2 16 2a 2d :2 16 31 34 :2 16
3d 40 :2 16 :7 4 :9 1 
1fd
4
0 :c 1 :7 3 :7 4
:7 6 :5 7 :7 8 :5 9
:6 b :5 c :5 d :7 f
:7 11 :7 13 :7 14 :5 18
:5 19 :c 1a 19 :4 18
:c 1c :2 1e :2 1f :2 1e
:2 1f :2 1e :2 1f :2 1e
:2 1f :2 1e :2 21 :2 1e
:2 21 :2 1e :2 22 :2 1e
:2 22 :2 1e :2 22 :2 1e
:2 22 :2 1e :2 22 :2 1e
:2 22 :2 1e :2 25 :3 1e
:5 28 29 :4 2a :5 2b
:2 2d :2 2e :2 2d :2 2e
:2 2d :2 2e :2 2d :2 2e
:2 2d :2 2e :2 2d :2 2e
:2 2d :2 2e :2 2d :2 2e
:2 2d :2 38 :2 2d :2 38
:2 2d :2 39 :3 2d :3 3b
:5 3c 3d :6 3e :5 3f
:b 40 3d 41 29
:4 42 :6 44 :8 45 :3 44
:10 48 :20 49 :3 48 :6 4c
:13 4d 4c :13 4f 4e
:3 4c :13 54 :6 55 :2 54
:2 55 :2 54 :2 55 :2 54
:2 56 :2 54 :2 56 :2 54
:2 56 :2 54 :2 56 :2 54
:2 56 :2 54 :2 56 :4 54
29 58 16 :4 59
:15 5e :5 63 :2 16 :7 1

761
4
:3 0 1 :a 0 1f8
1 :7 0 5 2c
0 :2 3 :3 0 2
:7 0 4 3 :3 0
6 :2 0 7 3
:3 0 4 :7 0 8
7 :3 0 a :2 0
1f8 1 b :2 0
6 :2 0 c 3
:3 0 a e 10
:6 0 13 11 0
1f6 0 5 :6 0
9 :2 0 10 3
:3 0 e 15 17
:6 0 1a 18 0
1f6 0 7 :6 0
16 a0 0 14
3 :3 0 12 1c
1e :6 0 21 1f
0 1f6 0 8
:6 0 1c d8 0
1a b :3 0 23
:7 0 26 24 0
1f6 0 a :6 0
3 :3 0 d :2 0
18 28 2a :6 0
2d 2b 0 1f6
0 c :6 0 10
:3 0 f :3 0 2f
:7 0 32 30 0
1f6 0 e :6 0
34 0 37 1f6
12 :3 0 13 :7 0
11 37 34 :4 0
20 127 0 1e
11 :3 0 3a :7 0
3d 3b 0 1f6
0 14 :6 0 17
:2 0 24 11 :3 0
3f :7 0 42 40
0 1f6 0 15
:6 0 3 :3 0 17
:2 0 22 44 46
:6 0 49 47 0
1f6 0 16 :6 0
d :2 0 28 3
:3 0 26 4b 4d
:6 0 50 4e 0
1f6 0 18 :6 0
17 :2 0 2c 3
:3 0 2a 52 54
:6 0 57 55 0
1f6 0 19 :6 0
32 :2 0 30 3
:3 0 2e 59 5b
:6 0 5e 5c 0
1f6 0 1a :6 0
1b :3 0 1c :3 0
16 :3 0 19 :3 0
1d :3 0 1e :2 0
4 64 65 0
35 67 74 0
75 :3 0 1f :3 0
2 :3 0 20 :2 0
39 6b 6c :3 0
21 :3 0 4 :3 0
20 :2 0 3e 70
71 :3 0 6d 73
72 :3 0 77 78
:5 0 61 68 0
41 0 76 :2 0
1f4 1a :3 0 22
:3 0 16 :3 0 23
:2 0 24 :4 0 44
7d 7f :3 0 25
:4 0 26 :4 0 47
7b 83 7a 84
0 1f4 5 :3 0
27 :4 0 23 :2 0
2 :3 0 4b 88
8a :3 0 23 :2 0
28 :4 0 4e 8c
8e :3 0 23 :2 0
4 :3 0 51 90
92 :3 0 23 :2 0
29 :4 0 54 94
96 :3 0 23 :2 0
16 :3 0 57 98
9a :3 0 23 :2 0
2a :4 0 5a 9c
9e :3 0 23 :2 0
16 :3 0 5d a0
a2 :3 0 23 :2 0
2b :4 0 60 a4
a6 :3 0 23 :2 0
2 :3 0 63 a8
aa :3 0 23 :2 0
28 :4 0 66 ac
ae :3 0 23 :2 0
4 :3 0 69 b0
b2 :3 0 23 :2 0
2c :4 0 6c b4
b6 :3 0 23 :2 0
16 :3 0 6f b8
ba :3 0 86 bb
0 1f4 2d :3 0
14 :3 0 5 :3 0
be bf 0 c0
:2 0 1f4 2e :3 0
14 :3 0 e :4 0
c6 :2 0 1d3 c3
c4 :3 0 2f :3 0
14 :3 0 30 :3 0
c8 c9 :4 0 ca
:3 0 1d3 7 :3 0
31 :4 0 23 :2 0
2 :3 0 72 ce
d0 :3 0 23 :2 0
28 :4 0 75 d2
d4 :3 0 23 :2 0
4 :3 0 78 d6
d8 :3 0 23 :2 0
32 :4 0 7b da
dc :3 0 23 :2 0
2 :3 0 7e de
e0 :3 0 23 :2 0
28 :4 0 81 e2
e4 :3 0 23 :2 0
4 :3 0 84 e6
e8 :3 0 23 :2 0
33 :4 0 87 ea
ec :3 0 23 :2 0
e :3 0 8a ee
f0 :3 0 23 :2 0
34 :4 0 8d f2
f4 :3 0 23 :2 0
1a :3 0 90 f6
f8 :3 0 cc f9
0 1d3 8 :3 0
24 :4 0 fb fc
0 1d3 2d :3 0
15 :3 0 7 :3 0
ff 100 0 101
:2 0 1d3 2e :3 0
15 :3 0 a :3 0
c :4 0 108 :2 0
11a 104 109 :3 0
93 :3 0 2f :3 0
15 :3 0 30 :3 0
10b 10c :4 0 10d
:3 0 11a 8 :3 0
8 :3 0 23 :2 0
a :3 0 96 111
113 :3 0 23 :2 0
24 :4 0 99 115
117 :3 0 10f 118
0 11a 9c 11c
2e :4 0 11a :4 0
1d3 35 :3 0 15
:4 0 120 :2 0 1d3
11e 0 8 :3 0
20 :2 0 24 :4 0
a2 122 124 :3 0
125 :2 0 36 :3 0
37 :2 0 38 :2 0
a5 128 12a :3 0
39 :4 0 a7 127
12d :2 0 12f aa
130 126 12f 0
131 ac 0 1d3
c :3 0 3a :2 0
ae 133 134 :3 0
3b :3 0 c :3 0
3c :4 0 b0 136
139 3d :2 0 3e
:2 0 b5 13b 13d
:3 0 135 13f 13e
:2 0 140 :2 0 c
:3 0 3f :3 0 c
:3 0 40 :2 0 3b
:3 0 c :3 0 41
:4 0 40 :2 0 42
:2 0 b8 146 14b
bd 143 14d 23
:2 0 3f :3 0 c
:3 0 3b :3 0 c
:3 0 3c :4 0 40
:2 0 42 :2 0 c1
152 157 43 :2 0
40 :2 0 c6 159
15b :3 0 c9 150
15d cc 14f 15f
:3 0 142 160 0
162 cf 163 141
162 0 164 d1
0 1d3 19 :3 0
20 :2 0 44 :4 0
d5 166 168 :3 0
169 :2 0 18 :3 0
45 :4 0 23 :2 0
8 :3 0 d8 16d
16f :3 0 23 :2 0
46 :4 0 db 171
173 :3 0 23 :2 0
c :3 0 de 175
177 :3 0 23 :2 0
47 :4 0 e1 179
17b :3 0 16b 17c
0 17e e4 193
18 :3 0 48 :4 0
23 :2 0 8 :3 0
e6 181 183 :3 0
23 :2 0 46 :4 0
e9 185 187 :3 0
23 :2 0 c :3 0
ec 189 18b :3 0
23 :2 0 47 :4 0
ef 18d 18f :3 0
17f 190 0 192
f2 194 16a 17e
0 195 0 192
0 195 f4 0
1d3 49 :3 0 4a
:3 0 4b :4 0 23
:2 0 2 :3 0 f7
199 19b :3 0 23
:2 0 28 :4 0 fa
19d 19f :3 0 23
:2 0 4 :3 0 fd
1a1 1a3 :3 0 23
:2 0 4c :4 0 100
1a5 1a7 :3 0 23
:2 0 4d :3 0 2
:3 0 4 :3 0 103
1aa 1ad 106 1a9
1af :3 0 23 :2 0
18 :3 0 109 1b1
1b3 :3 0 23 :2 0
4e :4 0 10c 1b5
1b7 :3 0 23 :2 0
2 :3 0 10f 1b9
1bb :3 0 23 :2 0
28 :4 0 112 1bd
1bf :3 0 23 :2 0
4 :3 0 115 1c1
1c3 :3 0 23 :2 0
4f :4 0 118 1c5
1c7 :3 0 23 :2 0
e :3 0 11b 1c9
1cb :3 0 23 :2 0
47 :4 0 11e 1cd
1cf :3 0 1d0 :4 0
1d1 :2 0 1d3 121
1d5 2e :4 0 1d3
:4 0 1f4 35 :3 0
14 :4 0 1d9 :2 0
1f4 1d7 0 49
:3 0 4a :3 0 50
:4 0 23 :2 0 2
:3 0 12d 1dd 1df
:3 0 23 :2 0 28
:4 0 130 1e1 1e3
:3 0 23 :2 0 4
:3 0 133 1e5 1e7
:3 0 23 :2 0 51
:4 0 136 1e9 1eb
:3 0 1ec :4 0 1ed
:2 0 1f4 52 :3 0
1f1 1f2 :2 0 1f3
52 :5 0 1f0 :2 0
1f4 139 1f7 :3 0
1f7 142 1f7 1f6
1f4 1f5 :6 0 1f8
:2 0 1 b 1f7
1fb :3 0 1fa 1f8
1fc :8 0 
150
4
:3 0 1 2 1
6 2 5 9
1 f 1 d
1 16 1 14
1 1d 1 1b
1 22 1 29
1 27 1 2e
1 39 1 3e
1 45 1 43
1 4c 1 4a
1 53 1 51
1 5a 1 58
2 5f 60 1
66 1 6a 2
69 6a 1 6f
2 6e 6f 2
62 63 2 7c
7e 3 80 81
82 2 87 89
2 8b 8d 2
8f 91 2 93
95 2 97 99
2 9b 9d 2
9f a1 2 a3
a5 2 a7 a9
2 ab ad 2
af b1 2 b3
b5 2 b7 b9
2 cd cf 2
d1 d3 2 d5
d7 2 d9 db
2 dd df 2
e1 e3 2 e5
e7 2 e9 eb
2 ed ef 2
f1 f3 2 f5
f7 2 105 106
2 110 112 2
114 116 3 107
10e 119 1 123
2 121 123 1
129 2 12b 12c
1 12e 1 130
1 132 2 137
138 1 13c 2
13a 13c 4 147
148 149 14a 3
144 145 14c 4
153 154 155 156
2 158 15a 2
151 15c 2 14e
15e 1 161 1
163 1 167 2
165 167 2 16c
16e 2 170 172
2 174 176 2
178 17a 1 17d
2 180 182 2
184 186 2 188
18a 2 18c 18e
1 191 2 193
194 2 198 19a
2 19c 19e 2
1a0 1a2 2 1a4
1a6 2 1ab 1ac
2 1a8 1ae 2
1b0 1b2 2 1b4
1b6 2 1b8 1ba
2 1bc 1be 2
1c0 1c2 2 1c4
1c6 2 1c8 1ca
2 1cc 1ce b
c5 cb fa fd
102 11c 11f 131
164 195 1d2 2
1dc 1de 2 1e0
1e2 2 1e4 1e6
2 1e8 1ea 8
79 85 bc c1
1d5 1d8 1ee 1f3
d 12 19 20
25 2c 31 38
3c 41 48 4f
56 5d 
1
4
0 
1fb
0
1
14
3
10
0 1 2 0 0 0 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
34 1 0
51 1 0
2e 1 0
43 1 0
6 1 0
27 1 0
1 0 1
22 1 0
d 1 0
14 1 0
39 1 0
3e 1 0
1b 1 0
4a 1 0
58 1 0
2 1 0
0

/
declare
 owner_var varchar2(30) ;
 table_name_var varchar2(30) ;
 cursor c1 is
  select owner, table_name from wmsys.wm$versioned_tables ;
begin
  open c1;
  loop
    fetch c1 into owner_var, table_name_var ;
    exit when c1%NOTFOUND ;
    wm$Fixsentinelandltlock(owner_var, table_name_var) ;
  end loop;
  close c1;
end;
/
drop function wm$getNullInsStr ;
drop function wm$getWhereClauseStr ;
drop procedure wm$Fixsentinelandltlock ;
drop public synonym user_wm_constraints ;
drop public synonym all_wm_constraints ;
drop public synonym all_wm_cons_columns ;
drop public synonym user_wm_cons_columns ;
drop public synonym all_wm_ind_columns ;
drop public synonym user_wm_ind_columns ;
drop public synonym all_wm_ind_expressions ;
drop public synonym user_wm_ind_expressions ;
drop public synonym wm$conf1_hierarchy_view ;
drop public synonym wm$conf2_hierarchy_view ;
drop public synonym wm$conf_base_hierarchy_view ;
drop public synonym wm$conf1_nextver_view ;
drop public synonym wm$conf2_nextver_view ;
drop public synonym wm$conf_base_nextver_view ;
drop public synonym wm$all_nextver_view ;
drop public synonym wm$base_version_view ;
drop package owm_bulk_load_pkg ;
drop package owm_mp_pkg ;
create sequence wmsys.wm$nested_columns_seq nocache ;
drop view wmsys.user_wm_constraints;
drop view wmsys.all_wm_constraints;
drop view wmsys.all_wm_cons_columns ;
drop view wmsys.user_wm_cons_columns ;
drop view wmsys.all_wm_ind_columns ;
drop view wmsys.user_wm_ind_columns ;
drop view wmsys.all_wm_ind_expressions ;
drop view wmsys.user_wm_ind_expressions ;
drop view wmsys.wm$conf1_hierarchy_view ;
drop view wmsys.wm$conf2_hierarchy_view ;
drop view wmsys.wm$conf_base_hierarchy_view ;
drop view wmsys.wm$conf1_nextver_view ;
drop view wmsys.wm$conf2_nextver_view ;
drop view wmsys.wm$conf_base_nextver_view ;
drop view wmsys.wm$all_nextver_view ;
drop view wmsys.wm$base_version_view ;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$constraints_table' || purgeOption ;
end;
/
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$cons_columns' || purgeOption ;
end;
/
drop trigger no_vm_alter;
drop procedure no_vm_alter_proc;
alter table wmsys.wm$versioned_tables drop (bl_workspace, bl_version);
drop view wmsys.wm$current_child_versions_view ;
drop public synonym wm$current_child_versions_view ;
drop index wmsys.wm$vt_anc_idx ;
drop view wmsys.wm$current_child_nextvers_view ;
drop public synonym wm$current_child_nextvers_view ;
drop view wmsys.wm$current_cons_versions_view ;
drop public synonym wm$current_cons_versions_view ;
drop view wmsys.wm$current_cons_nextvers_view ;
drop public synonym wm$current_cons_nextvers_view ;
/* Insert 0 version entry in nextver_table */
delete from wmsys.wm$nextver_table where version = 0;
commit;
drop index wmsys.wm$nextver_table_nv_indx;
create index wmsys.wm$nextver_table_nv_indx on wmsys.wm$nextver_table(next_vers);
alter table wmsys.wm$workspaces_table drop ( cr_status );
alter table wmsys.wm$workspaces_table drop ( sync_parver );
alter table wmsys.wm$workspaces_table drop ( last_change );
alter table wmsys.wm$workspaces_table drop (depth) ;
alter table wmsys.wm$version_table drop (anc_depth) ;
create or replace view wmsys.wm$base_hierarchy_view as
  select -1 version from dual union
  select version from wmsys.wm$version_hierarchy_table 
  start with version = sys_context('lt_ctx', 'diffbasever')
  connect by prior parent_version  = version
WITH READ ONLY;
delete from wmsys.wm$env_vars where name = 'CR_WORKSPACE_MODE';
commit ;
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
drop public synonym wm$mw_versions_view;
drop view wmsys.wm$mw_versions_view;
create or replace view wmsys.wm$mw_nextvers_view as 
select next_vers from wmsys.wm$nextver_table where version in 
        (select parent_vers from wmsys.wm$mw_parvers_view);
create or replace view wmsys.wm$curConflict_parvers_view (parent_vers) as 
 (select version 
  from wmsys.wm$version_hierarchy_table  
  where workspace = SYS_CONTEXT('lt_ctx','conflict_state') and
        version   <= 
         (select current_version from wmsys.wm$workspaces_table 
          where workspace = SYS_CONTEXT('lt_ctx','conflict_state'))
 )
WITH READ ONLY;
create or replace view wmsys.wm$curConflict_nextvers_view as 
select version, next_vers, workspace, split
from wmsys.wm$nextver_table  
where version in
  (select parent_vers FROM wmsys.wm$curConflict_parvers_view)
WITH READ ONLY;
create or replace view wmsys.wm$parConflict_parvers_view (parent_vers) as 
 (select version 
  from wmsys.wm$version_hierarchy_table  
  where workspace = SYS_CONTEXT('lt_ctx','parent_conflict_state') and
        version   <= 
           (select current_version from wmsys.wm$workspaces_table 
            where workspace = SYS_CONTEXT('lt_ctx','parent_conflict_state')) and 
        version > SYS_CONTEXT('lt_ctx','parent_ver')
 )
WITH READ ONLY;
create or replace view wmsys.wm$parConflict_nextvers_view as 
select version, next_vers, workspace, split
from wmsys.wm$nextver_table  
where version in
  (select parent_vers FROM wmsys.wm$parConflict_parvers_view)
WITH READ ONLY;
declare
 curTrigStatus varchar2(10) := null;
 verTabName varchar2(61);
 cursor verTabsCur is 
   select owner || '.' || table_name from wmsys.wm$versioned_tables;
 badtab_exception EXCEPTION;
 PRAGMA EXCEPTION_INIT(badtab_exception, -00942);
 column_exists_exception EXCEPTION;
 PRAGMA EXCEPTION_INIT(column_exists_exception, -01430);
begin
  BEGIN
   select substr(status,1,length(status)-1) into curTrigStatus
   from all_triggers 
   where owner = 'SYS' and trigger_name = 'NO_VM_DROP';
   execute immediate 'alter trigger sys.no_vm_drop disable';
  EXCEPTION WHEN NO_DATA_FOUND THEN
    NULL;
  END;
  BEGIN
    open verTabsCur;
    loop
      fetch verTabsCur into verTabName;
      EXIT when verTabsCur%NOTFOUND;
      BEGIN
        execute immediate 'drop view ' || verTabName || '_BPKB';
      EXCEPTION WHEN badtab_exception THEN
        NULL;
      END;
    end loop;
    close verTabsCur;
  EXCEPTION WHEN OTHERS THEN
    if (curTrigStatus is not null) then
      execute immediate 'alter trigger sys.no_vm_drop ' || curTrigStatus;
    end if;
    RAISE;
  END;
  if (curTrigStatus is not null) then
    execute immediate 'alter trigger sys.no_vm_drop ' || curTrigStatus;
  end if;
end;
/
 /* Cannot use the same function from the ltric packages because the packages is
  * not valid anymore. This happens because a tables have been altered and views
  * been dropped by 'r' scripts. So create independent procedure that will do the
  * same thing.
  */
create or replace procedure wm$cleanupRicProcs wrapped 
0
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
3
7
9200000
1
4
0 
45
2 :e:
1WM$CLEANUPRICPROCS:
1TABLE_OWNER_VAR:
1VARCHAR2:
1TABLE_NAME_VAR:
1SQL_STRING:
132767:
1DISPATCHER_NAME_VAR:
1100:
1USERDEFINEDTRIGCOUNT:
1INTEGER:
1BIR_FLAG_VAR:
130:
1BUR_FLAG_VAR:
1AIR_CNT:
1AUR_CNT:
1BDR_CNT:
1ADR_CNT:
1CURSOR:
1RIC_TRIG_PROC_CUR:
1TRIG_OWNER_NAME:
1TRIG_PROCEDURE:
1WMSYS:
1WM$UDTRIG_INFO:
1TABLE_OWNER_NAME:
1=:
1TABLE_NAME:
1INTERNAL_TYPE:
1RIC_CHECK:
1DROP_PROC_EXCP:
1PRAGMA:
1EXCEPTION_INIT:
1-:
104043:
1RIC_TRIG_PROC_CUR_REC:
1LOOP:
1drop procedure :
1||:
1.:
1EXECUTE:
1IMMEDIATE:
1COMMIT:
1COUNT:
1USER_DEFINED:
1IS NOT NULL:
1TRIG_TYPE:
1AIR:
1AUR:
1BDR:
1ADR:
10:
1DISPATCHER_NAME:
1BIR_FLAG:
1BUR_FLAG:
1WM$UDTRIG_DISPATCH_PROCS:
1AIR_FLAG:
1AUR_FLAG:
1BDR_FLAG:
1ADR_FLAG:
1NVL:
1null:
1!=:
1BIR:
1BUR:
1delete from wmsys.wm$udtrig_dispatch_procs:n                             wher+
1e  table_owner_name =  ':
1' and:n                                    table_name       =  ':
1':
1DECODE:
1:
1NO_DATA_FOUND:
0

0
0
2aa
2
0 9a 8f a0 b0 3d 8f a0
b0 3d b4 55 6a a3 a0 51
a5 1c 81 b0 a3 a0 51 a5
1c 81 b0 a3 a0 1c 81 b0
a3 a0 51 a5 1c 81 b0 a3
a0 51 a5 1c 81 b0 a3 a0
1c 81 b0 a3 a0 1c 81 b0
a3 a0 1c 81 b0 a3 a0 1c
81 b0 a0 f4 b4 bf c8 :2 a0
ac :2 a0 6b b2 ee :2 a0 7e b4
2e :2 a0 7e b4 2e a 10 a0
7e 6e b4 2e a 10 ac d0
e5 e9 bd b7 11 a4 b1 8b
b0 2a :3 a0 7e 51 b4 2e b4
5d 91 :2 a0 37 a0 6e 7e :2 a0
6b b4 2e 7e 6e b4 2e 7e
:2 a0 6b b4 2e d :3 a0 11e 11d
:2 a0 6b :2 a0 7e a0 6b b4 2e
:2 a0 7e a0 6b b4 2e a 10
cd e9 a0 57 a0 b4 e9 b7
a0 4f b7 a6 9 a4 b1 11
4f b7 a0 47 a0 d2 9f ac
:3 a0 6b b2 ee :2 a0 7e b4 2e
:2 a0 7e b4 2e a 10 a0 7e
6e b4 2e a 10 a0 7e b4
2e a 10 a0 7e 6e b4 2e
a 10 ac e5 d0 b2 e9 a0
d2 9f ac :3 a0 6b b2 ee :2 a0
7e b4 2e :2 a0 7e b4 2e a
10 a0 7e 6e b4 2e a 10
a0 7e b4 2e a 10 a0 7e
6e b4 2e a 10 ac e5 d0
b2 e9 a0 d2 9f ac :3 a0 6b
b2 ee :2 a0 7e b4 2e :2 a0 7e
b4 2e a 10 a0 7e 6e b4
2e a 10 a0 7e b4 2e a
10 a0 7e 6e b4 2e a 10
ac e5 d0 b2 e9 a0 d2 9f
ac :3 a0 6b b2 ee :2 a0 7e b4
2e :2 a0 7e b4 2e a 10 a0
7e 6e b4 2e a 10 a0 7e
b4 2e a 10 a0 7e 6e b4
2e a 10 ac e5 d0 b2 e9
a0 7e 51 b4 2e a0 7e 51
b4 2e 52 10 a0 7e 51 b4
2e 52 10 a0 7e 51 b4 2e
52 10 5a :3 a0 ac :5 a0 6b b2
ee :2 a0 7e b4 2e :2 a0 7e b4
2e a 10 a0 7e 6e b4 2e
a0 7e 6e b4 2e 52 10 a0
7e 6e b4 2e 52 10 a0 7e
6e b4 2e 52 10 5a a 10
ac e5 d0 b2 e9 a0 7e 51
b4 2e a0 7e 51 b4 2e a
10 a0 7e 51 b4 2e a 10
a0 7e 51 b4 2e a 10 5a
a0 6e 7e a0 b4 2e d :3 a0
11e 11d b7 a0 4f b7 a6 9
a4 b1 11 4f b7 19 3c a0
7e 51 b4 2e a0 7e 51 b4
2e a 10 a0 7e 51 b4 2e
a 10 a0 7e 51 b4 2e a
10 :2 a0 6e a5 b 7e 6e b4
2e a 10 :2 a0 6e a5 b 7e
6e b4 2e a 10 5a a0 6e
7e a0 b4 2e 7e 6e b4 2e
7e a0 b4 2e 7e 6e b4 2e
d :2 a0 6b :2 a0 7e b4 2e :2 a0
7e b4 2e a 10 cd e9 b7
:2 a0 6b :3 a0 51 :2 6e a5 b e7
:3 a0 51 :2 6e a5 b e7 :3 a0 51
:2 6e a5 b e7 :3 a0 51 :2 6e a5
b e7 :2 a0 7e b4 2e :2 a0 7e
b4 2e a 10 ef f9 e9 b7
:2 19 3c b7 a0 4f b7 a6 9
a4 b1 11 4f b7 19 3c a0
57 a0 b4 e9 b7 a4 b1 11
68 4f 1d 17 b5 
2aa
2
0 3 1f 1b 1a 27 34 30
17 3c 2f 41 45 5f 4d 2c
51 52 5a 4c 7c 6a 49 6e
6f 77 69 98 87 8b 93 66
b4 9f a3 a6 a7 af 86 d1
bf 83 c3 c4 cc be ed dc
e0 e8 bb 105 f4 f8 100 db
121 110 114 11c d8 139 128 12c
134 10f 140 144 10c 155 158 15c
160 164 165 169 16d 170 171 178
17c 180 183 184 189 18d 191 194
195 1 19a 19f 1a3 1a6 1ab 1ac
1 1b1 1b6 1b7 1bb 1c1 1c6 1cb
1cd 1d9 1dd 1df 1e6 1e7 1ea 1ee
1f2 1f6 1f9 1fc 1fd 202 203 206
20a 20e 212 214 218 21d 220 224
228 22b 22c 231 234 239 23a 23f
242 246 24a 24d 24e 253 257 25b
25f 263 268 26c 270 274 277 27b
27f 282 286 289 28a 28f 293 297
29a 29e 2a1 2a2 1 2a7 2ac 2b1
2b6 2ba 2bf 2c3 2c4 2c9 2cb 2cf
2d1 2d3 2d4 2d9 2dd 2df 2eb 2ed
2ef 2f3 2fa 2fe 302 305 306 30a
30e 312 315 316 31d 321 325 328
329 32e 332 336 339 33a 1 33f
344 348 34b 350 351 1 356 35b
35f 362 363 1 368 36d 371 374
379 37a 1 37f 384 385 38b 38f
390 395 399 39d 3a0 3a1 3a5 3a9
3ad 3b0 3b1 3b8 3bc 3c0 3c3 3c4
3c9 3cd 3d1 3d4 3d5 1 3da 3df
3e3 3e6 3eb 3ec 1 3f1 3f6 3fa
3fd 3fe 1 403 408 40c 40f 414
415 1 41a 41f 420 426 42a 42b
430 434 438 43b 43c 440 444 448
44b 44c 453 457 45b 45e 45f 464
468 46c 46f 470 1 475 47a 47e
481 486 487 1 48c 491 495 498
499 1 49e 4a3 4a7 4aa 4af 4b0
1 4b5 4ba 4bb 4c1 4c5 4c6 4cb
4cf 4d3 4d6 4d7 4db 4df 4e3 4e6
4e7 4ee 4f2 4f6 4f9 4fa 4ff 503
507 50a 50b 1 510 515 519 51c
521 522 1 527 52c 530 533 534
1 539 53e 542 545 54a 54b 1
550 555 556 55c 560 561 566 56a
56d 570 571 576 57a 57d 580 581
1 586 58b 58f 592 595 596 1
59b 5a0 5a4 5a7 5aa 5ab 1 5b0
5b5 5b8 5bc 5c0 5c4 5c5 5c9 5cd
5d1 5d5 5d9 5dc 5dd 5e4 5e8 5ec
5ef 5f0 5f5 5f9 5fd 600 601 1
606 60b 60f 612 617 618 61d 621
624 629 62a 1 62f 634 638 63b
640 641 1 646 64b 64f 652 657
658 1 65d 662 1 665 66a 66b
671 675 676 67b 67f 682 685 686
68b 68f 692 695 696 1 69b 6a0
6a4 6a7 6aa 6ab 1 6b0 6b5 6b9
6bc 6bf 6c0 1 6c5 6ca 6cd 6d1
6d6 6d9 6dd 6de 6e3 6e7 6eb 6ef
6f3 6f8 6fc 6fe 702 704 706 707
70c 710 712 71e 720 722 726 729
72d 730 733 734 739 73d 740 743
744 1 749 74e 752 755 758 759
1 75e 763 767 76a 76d 76e 1
773 778 77c 780 785 786 788 78b
790 791 1 796 79b 79f 7a3 7a8
7a9 7ab 7ae 7b3 7b4 1 7b9 7be
7c1 7c5 7ca 7cd 7d1 7d2 7d7 7da
7df 7e0 7e5 7e8 7ec 7ed 7f2 7f5
7fa 7fb 800 804 808 80c 80f 813
817 81a 81b 820 824 828 82b 82c
1 831 836 83b 840 842 846 84a
84d 851 855 859 85c 861 866 867
869 86b 86f 873 877 87a 87f 884
885 887 889 88d 891 895 898 89d
8a2 8a3 8a5 8a7 8ab 8af 8b3 8b6
8bb 8c0 8c1 8c3 8c5 8c9 8cd 8d0
8d1 8d6 8da 8de 8e1 8e2 1 8e7
8ec 8f2 8f3 8f8 8fa 8fe 902 905
907 90b 90d 90f 910 915 919 91b
927 929 92b 92f 932 936 93b 93f
940 945 947 94b 94d 959 95d 95f
960 969 
2aa
2
0 b 1f 2f :2 1f 39 48 :2 39
1d :2 1 6 1c 25 24 :2 1c :2 6
1c 25 24 :2 1c :2 6 :3 1c :2 6 1c
25 24 :2 1c :2 6 1c 25 24 :2 1c
:2 6 :3 1c :2 6 :3 1c :2 6 :3 1c :2 6 :3 1c
:2 6 d 0 :2 6 d 1e :2 d 13
d 6 :2 d 20 :3 1e d 20 :3 1e
:3 d 1e 20 :2 1e :2 d :9 6 :4 5 c
1b :4 2b :2 5 a 23 35 6 9
17 29 2c :2 42 :3 17 1a :2 17 1e
21 :2 37 :2 17 9 d 15 1f :2 d
19 1f 19 14 26 24 :2 3c :2 24
14 26 24 :2 3c :2 24 :2 14 :7 d 9
14 12 23 :2 f d :4 35 a 6
:4 d 1b d 13 d 6 :2 d 20
:3 1e d 20 :3 1e :3 d 1e 20 :2 1e
:9 d 17 19 :2 17 :2 d :5 6 :4 d 1b
d 13 d 6 :2 d 20 :3 1e d
20 :3 1e :3 d 1e 20 :2 1e :9 d 17
19 :2 17 :2 d :5 6 :4 d 1b d 13
d 6 :2 d 20 :3 1e d 20 :3 1e
:3 d 1e 20 :2 1e :9 d 17 19 :2 17
:2 d :5 6 :4 d 1b d 13 d 6
:2 d 20 :3 1e d 20 :3 1e :3 d 1e
20 :2 1e :9 d 17 19 :2 17 :2 d :5 6
b 13 15 :2 13 1a 22 24 :2 22
:2 b 29 31 33 :2 31 :2 b 38 40
42 :2 40 :2 b 9 13 24 2e 13
17 2c 3a 13 19 13 c :2 13
26 :3 24 13 26 :3 24 :2 13 14 1d
1f :2 1d 28 31 33 :2 31 :3 14 1d
1f :2 1d :2 14 28 31 33 :2 31 :2 14
:3 13 :5 c 11 19 1b :2 19 21 29
2b :2 29 :2 11 31 39 3b :2 39 :2 11
41 49 4b :2 49 :2 11 f 12 20
32 35 :2 20 :2 12 1a 24 :2 12 f
19 17 28 :2 14 12 :4 4f :2 c 11
19 1b :2 19 21 29 2b :2 29 :2 11
31 39 3b :2 39 :2 11 41 49 4b
:2 49 :3 11 15 23 :2 11 2b 2e :2 2b
:2 11 38 3c 4a :2 38 52 55 :2 52
:2 11 :2 f 1d 3d 40 :2 1d 50 53
:2 1d 3d 40 :2 1d 4f 52 :2 1d f
1b 21 1b 16 2a :3 27 16 2a
:3 27 :2 16 :2 f 5d 16 1c :2 16 21
28 31 34 38 :2 21 :2 16 21 28
31 34 38 :2 21 :2 16 21 28 31
34 38 :2 21 :2 16 21 28 31 34
38 :2 21 :2 16 2a :3 27 16 2a :3 27
:2 16 :3 f :4 c 9 15 13 23 :2 10
c :4 46 :7 6 :2 2 :7 1 
2aa
4
0 :c 1 :7 3 :7 4
:5 5 :7 6 :7 7 :5 8
:5 9 :5 a :5 b :2 d
0 :2 d :3 e :5 f
:5 10 :5 11 :2 10 :5 12
:2 10 f :3 e :5 d
:3 14 :9 15 :4 18 :8 19
:2 1a :2 19 :4 1a :3 19
:5 1d :3 1e :7 1f :7 20
:2 1f :2 1e :5 21 1c
23 24 :3 23 22
:4 18 26 18 :5 28
:5 29 :5 2a :5 2b :2 2a
:5 2c :2 2a :4 2d :2 2a
:5 2e :2 2a 29 :4 28
:5 30 :5 31 :5 32 :5 33
:2 32 :5 34 :2 32 :4 35
:2 32 :5 36 :2 32 31
:4 30 :5 38 :5 39 :5 3a
:5 3b :2 3a :5 3c :2 3a
:4 3d :2 3a :5 3e :2 3a
39 :4 38 :5 40 :5 41
:5 42 :5 43 :2 42 :5 44
:2 42 :4 45 :2 42 :5 46
:2 42 41 :4 40 :1b 4a
:4 4c :3 4d :5 4e :5 4f
:5 50 :2 4f :c 51 :5 52
:2 51 :5 52 :3 51 :2 4f
4e :4 4c :1b 54 :7 56
:5 57 55 5a 5b
:3 5a 59 :6 54 :1a 5f
:9 60 :2 5f :9 60 :3 5f
:2 62 :2 63 :2 62 :2 63
:2 62 :2 64 :2 62 :2 64
:3 62 :3 65 :5 66 :5 67
:2 66 :2 65 60 :3 6a
:9 6b :9 6c :9 6d :9 6e
:5 6f :5 70 :2 6f :3 6a
69 :3 5f 4b 74
75 :3 74 73 :6 4a
:5 78 :2 16 :7 1 
96b
4
:3 0 1 :a 0 2a5
1 :7 0 5 2c
0 :2 3 :3 0 2
:7 0 4 3 :3 0
6 :2 0 7 3
:3 0 4 :7 0 8
7 :3 0 a :2 0
2a5 1 b :2 0
8 :2 0 c 3
:3 0 a e 10
:6 0 13 11 0
2a3 0 5 :6 0
12 83 0 10
3 :3 0 e 15
17 :6 0 1a 18
0 2a3 0 7
:6 0 c :2 0 16
a :3 0 1c :7 0
1f 1d 0 2a3
0 9 :6 0 3
:3 0 c :2 0 14
21 23 :6 0 26
24 0 2a3 0
b :6 0 1c d8
0 1a 3 :3 0
18 28 2a :6 0
2d 2b 0 2a3
0 d :6 0 20
10c 0 1e a
:3 0 2f :7 0 32
30 0 2a3 0
e :6 0 a :3 0
34 :7 0 37 35
0 2a3 0 f
:9 0 22 a :3 0
39 :7 0 3c 3a
0 2a3 0 10
:6 0 a :3 0 3e
:7 0 41 3f 0
2a3 0 11 :6 0
12 :3 0 13 :a 0
2 66 :4 0 43
46 0 44 :3 0
14 :3 0 15 :3 0
24 16 :3 0 17
:2 0 4 4a 4b
0 27 4d 61
0 62 :3 0 18
:3 0 2 :3 0 19
:2 0 2b 51 52
:3 0 1a :3 0 4
:3 0 19 :2 0 30
56 57 :3 0 53
59 58 :2 0 1b
:3 0 19 :2 0 1c
:4 0 35 5c 5e
:3 0 5a 60 5f
:4 0 49 4e 0
63 :6 0 64 :2 0
67 43 46 68
0 2a3 38 68
6a 67 69 :6 0
66 :7 0 68 1d
:6 0 3a 6c 0
2a3 1e :3 0 1f
:3 0 1d 6b :2 0
20 :2 0 21 :2 0
3c 71 73 :3 0
3e 6f 75 2a3
22 :3 0 13 :3 0
23 :3 0 77 78
5 :3 0 24 :4 0
25 :2 0 22 :3 0
14 :3 0 7e 7f
0 41 7d 81
:3 0 25 :2 0 26
:4 0 44 83 85
:3 0 25 :2 0 22
:3 0 15 :3 0 88
89 0 47 87
8b :3 0 7b 8c
0 b7 27 :3 0
28 :3 0 5 :3 0
90 :4 0 91 :2 0
ad 16 :3 0 17
:2 0 4 93 94
0 14 :3 0 22
:3 0 19 :2 0 14
:3 0 97 99 0
4c 98 9b :3 0
15 :3 0 22 :3 0
19 :2 0 15 :3 0
9e a0 0 51
9f a2 :3 0 9c
a4 a3 :2 0 95
a5 0 a7 :2 0
a6 :2 0 ad 29
:3 0 aa ab :2 0
ac 29 :5 0 a9
:2 0 ad 54 b5
1d :4 0 b0 58
b2 5a b1 b0
:2 0 b3 5c :2 0
b5 0 b5 b4
ad b3 :6 0 b7
3 :3 0 5e b9
23 :3 0 7a b7
:4 0 2a1 2a :3 0
bc :3 0 2a :2 0
61 e :3 0 16
:3 0 17 :2 0 4
bf c0 0 63
c2 e3 0 e4
:3 0 18 :3 0 2
:3 0 19 :2 0 67
c6 c7 :3 0 1a
:3 0 4 :3 0 19
:2 0 6c cb cc
:3 0 c8 ce cd
:2 0 1b :3 0 19
:2 0 2b :4 0 71
d1 d3 :3 0 cf
d5 d4 :2 0 15
:3 0 2c :2 0 74
d8 d9 :3 0 d6
db da :2 0 2d
:3 0 19 :2 0 2e
:4 0 78 de e0
:3 0 dc e2 e1
:3 0 e6 e7 :5 0
bd c3 0 7b
0 e5 :2 0 2a1
2a :3 0 eb :3 0
2a :2 0 7d f
:3 0 16 :3 0 17
:2 0 4 ee ef
0 7f f1 112
0 113 :3 0 18
:3 0 2 :3 0 19
:2 0 83 f5 f6
:3 0 1a :3 0 4
:3 0 19 :2 0 88
fa fb :3 0 f7
fd fc :2 0 1b
:3 0 19 :2 0 2b
:4 0 8d 100 102
:3 0 fe 104 103
:2 0 15 :3 0 2c
:2 0 90 107 108
:3 0 105 10a 109
:2 0 2d :3 0 19
:2 0 2f :4 0 94
10d 10f :3 0 10b
111 110 :3 0 115
116 :5 0 ec f2
0 97 0 114
:2 0 2a1 2a :3 0
11a :3 0 2a :2 0
99 10 :3 0 16
:3 0 17 :2 0 4
11d 11e 0 9b
120 141 0 142
:3 0 18 :3 0 2
:3 0 19 :2 0 9f
124 125 :3 0 1a
:3 0 4 :3 0 19
:2 0 a4 129 12a
:3 0 126 12c 12b
:2 0 1b :3 0 19
:2 0 2b :4 0 a9
12f 131 :3 0 12d
133 132 :2 0 15
:3 0 2c :2 0 ac
136 137 :3 0 134
139 138 :2 0 2d
:3 0 19 :2 0 30
:4 0 b0 13c 13e
:3 0 13a 140 13f
:3 0 144 145 :5 0
11b 121 0 b3
0 143 :2 0 2a1
2a :3 0 149 :3 0
2a :2 0 b5 11
:3 0 16 :3 0 17
:2 0 4 14c 14d
0 b7 14f 170
0 171 :3 0 18
:3 0 2 :3 0 19
:2 0 bb 153 154
:3 0 1a :3 0 4
:3 0 19 :2 0 c0
158 159 :3 0 155
15b 15a :2 0 1b
:3 0 19 :2 0 2b
:4 0 c5 15e 160
:3 0 15c 162 161
:2 0 15 :3 0 2c
:2 0 c8 165 166
:3 0 163 168 167
:2 0 2d :3 0 19
:2 0 31 :4 0 cc
16b 16d :3 0 169
16f 16e :3 0 173
174 :5 0 14a 150
0 cf 0 172
:2 0 2a1 e :3 0
19 :2 0 32 :2 0
d3 177 179 :3 0
f :3 0 19 :2 0
32 :2 0 d8 17c
17e :3 0 17a 180
17f :2 0 10 :3 0
19 :2 0 32 :2 0
dd 183 185 :3 0
181 187 186 :2 0
11 :3 0 19 :2 0
32 :2 0 e2 18a
18c :3 0 188 18e
18d :2 0 18f :2 0
33 :3 0 34 :3 0
35 :3 0 e5 7
:3 0 b :3 0 d
:3 0 16 :3 0 36
:2 0 4 198 199
0 e9 19b 1c5
0 1c6 :3 0 18
:3 0 2 :3 0 19
:2 0 ed 19f 1a0
:3 0 1a :3 0 4
:3 0 19 :2 0 f2
1a4 1a5 :3 0 1a1
1a7 1a6 :2 0 37
:3 0 19 :2 0 2e
:4 0 f7 1aa 1ac
:3 0 38 :3 0 19
:2 0 2f :4 0 fc
1af 1b1 :3 0 1ad
1b3 1b2 :2 0 39
:3 0 19 :2 0 30
:4 0 101 1b6 1b8
:3 0 1b4 1ba 1b9
:2 0 3a :3 0 19
:2 0 31 :4 0 106
1bd 1bf :3 0 1bb
1c1 1c0 :2 0 1c2
:2 0 1a8 1c4 1c3
:3 0 1c8 1c9 :5 0
194 19c 0 109
0 1c7 :2 0 28f
e :3 0 19 :2 0
32 :2 0 10f 1cc
1ce :3 0 f :3 0
19 :2 0 32 :2 0
114 1d1 1d3 :3 0
1cf 1d5 1d4 :2 0
10 :3 0 19 :2 0
32 :2 0 119 1d8
1da :3 0 1d6 1dc
1db :2 0 11 :3 0
19 :2 0 32 :2 0
11e 1df 1e1 :3 0
1dd 1e3 1e2 :2 0
1e4 :2 0 5 :3 0
24 :4 0 25 :2 0
7 :3 0 121 1e8
1ea :3 0 1e6 1eb
0 1f2 27 :3 0
28 :3 0 5 :3 0
1ef :4 0 1f0 :2 0
1f2 124 1fa 1d
:4 0 1f5 127 1f7
129 1f6 1f5 :2 0
1f8 12b :2 0 1fa
0 1fa 1f9 1f2
1f8 :6 0 1fc 5
:3 0 12d 1fd 1e5
1fc 0 1fe 12f
0 28f e :3 0
19 :2 0 32 :2 0
133 200 202 :3 0
f :3 0 19 :2 0
32 :2 0 138 205
207 :3 0 203 209
208 :2 0 10 :3 0
19 :2 0 32 :2 0
13d 20c 20e :3 0
20a 210 20f :2 0
11 :3 0 19 :2 0
32 :2 0 142 213
215 :3 0 211 217
216 :2 0 3b :3 0
b :3 0 3c :4 0
145 219 21c 3d
:2 0 3e :4 0 14a
21e 220 :3 0 218
222 221 :2 0 3b
:3 0 d :3 0 3c
:4 0 14d 224 227
3d :2 0 3f :4 0
152 229 22b :3 0
223 22d 22c :2 0
22e :2 0 5 :3 0
40 :4 0 25 :2 0
2 :3 0 155 232
234 :3 0 25 :2 0
41 :4 0 158 236
238 :3 0 25 :2 0
4 :3 0 15b 23a
23c :3 0 25 :2 0
42 :4 0 15e 23e
240 :3 0 230 241
0 254 16 :3 0
36 :2 0 4 243
244 0 18 :3 0
2 :3 0 19 :2 0
163 248 249 :3 0
1a :3 0 4 :3 0
19 :2 0 168 24d
24e :3 0 24a 250
24f :2 0 245 251
0 253 :2 0 252
:2 0 254 16b 28c
16 :3 0 36 :2 0
4 255 256 0
37 :3 0 43 :3 0
e :3 0 32 :2 0
44 :4 0 2e :4 0
16e 259 25e 258
25f 38 :3 0 43
:3 0 f :3 0 32
:2 0 44 :4 0 2f
:4 0 173 262 267
261 268 39 :3 0
43 :3 0 10 :3 0
32 :2 0 44 :4 0
30 :4 0 178 26b
270 26a 271 3a
:3 0 43 :3 0 11
:3 0 32 :2 0 44
:4 0 31 :4 0 17d
274 279 273 27a
18 :3 0 2 :3 0
19 :2 0 184 27e
27f :3 0 1a :3 0
4 :3 0 19 :2 0
189 283 284 :3 0
280 286 285 :2 0
257 289 287 0
28a 0 18c 0
288 :2 0 28b 191
28d 22f 254 0
28e 0 28b 0
28e 193 0 28f
196 297 45 :4 0
292 19a 294 19c
293 292 :2 0 295
19e :2 0 297 0
297 296 28f 295
:6 0 299 1 :3 0
1a0 29a 190 299
0 29b 1a2 0
2a1 29 :3 0 29e
29f :2 0 2a0 29
:5 0 29d :2 0 2a1
1a4 2a4 :3 0 2a4
1ac 2a4 2a3 2a1
2a2 :6 0 2a5 :2 0
1 b 2a4 2a8
:3 0 2a7 2a5 2a9
:8 0 
1b9
4
:3 0 1 2 1
6 2 5 9
1 f 1 d
1 16 1 14
1 1b 1 22
1 20 1 29
1 27 1 2e
1 33 1 38
1 3d 2 47
48 1 4c 1
50 2 4f 50
1 55 2 54
55 1 5d 2
5b 5d 1 65
1 6b 1 72
2 70 74 2
7c 80 2 82
84 2 86 8a
1 9a 2 96
9a 1 a1 2
9d a1 3 92
a7 ac 1 af
1 ae 1 b2
2 8d b5 1
bb 1 c1 1
c5 2 c4 c5
1 ca 2 c9
ca 1 d2 2
d0 d2 1 d7
1 df 2 dd
df 1 be 1
ea 1 f0 1
f4 2 f3 f4
1 f9 2 f8
f9 1 101 2
ff 101 1 106
1 10e 2 10c
10e 1 ed 1
119 1 11f 1
123 2 122 123
1 128 2 127
128 1 130 2
12e 130 1 135
1 13d 2 13b
13d 1 11c 1
148 1 14e 1
152 2 151 152
1 157 2 156
157 1 15f 2
15d 15f 1 164
1 16c 2 16a
16c 1 14b 1
178 2 176 178
1 17d 2 17b
17d 1 184 2
182 184 1 18b
2 189 18b 3
191 192 193 1
19a 1 19e 2
19d 19e 1 1a3
2 1a2 1a3 1
1ab 2 1a9 1ab
1 1b0 2 1ae
1b0 1 1b7 2
1b5 1b7 1 1be
2 1bc 1be 3
195 196 197 1
1cd 2 1cb 1cd
1 1d2 2 1d0
1d2 1 1d9 2
1d7 1d9 1 1e0
2 1de 1e0 2
1e7 1e9 2 1ec
1f1 1 1f4 1
1f3 1 1f7 1
1fa 1 1fd 1
201 2 1ff 201
1 206 2 204
206 1 20d 2
20b 20d 1 214
2 212 214 2
21a 21b 1 21f
2 21d 21f 2
225 226 1 22a
2 228 22a 2
231 233 2 235
237 2 239 23b
2 23d 23f 1
247 2 246 247
1 24c 2 24b
24c 2 242 253
4 25a 25b 25c
25d 4 263 264
265 266 4 26c
26d 26e 26f 4
275 276 277 278
1 27d 2 27c
27d 1 282 2
281 282 4 260
269 272 27b 1
28a 2 28c 28d
3 1ca 1fe 28e
1 291 1 290
1 294 1 297
1 29a 7 b9
e8 117 146 175
29b 2a0 c 12
19 1e 25 2c
31 36 3b 40
66 6d 76 
1
4
0 
2a8
0
1
14
6
f
0 1 1 3 1 5 0 0
0 0 0 0 0 0 0 0
0 0 0 0 
1 0 1
2 1 0
77 3 0
d 1 0
3d 1 0
6 1 0
14 1 0
33 1 0
1b 1 0
27 1 0
43 1 2
2e 1 0
38 1 0
20 1 0
6b 1 0
0

/
declare
  cursor veTableCur is 
  select owner, table_name 
  from   wmsys.wm$versioned_tables;
begin
  for veTableCurRec in veTableCur loop
     wm$cleanupRicProcs( veTableCurRec.owner, veTableCurRec.table_name ); 
  end loop;
  commit;
end;
/
drop procedure wm$cleanupRicProcs ;
alter table wmsys.wm$udtrig_info drop (
  internal_type,
  TAB_MERGE_WO_REMOVE_COL,
  TAB_MERGE_W_REMOVE_COL,
  WSPC_MERGE_WO_REMOVE_COL,
  WSPC_MERGE_W_REMOVE_COL,
  DML_COL,               
  WORKSPACE_REFRESH_COL,
  TABLE_REFRESH_COL,   
  TABLE_ROLLBACK_COL, 
  WORKSPACE_ROLLBACK_COL,
  WORKSPACE_REMOVE_COL
); 
drop index wmsys.wm$workspaces_mp_idx ;
alter table wmsys.wm$workspaces_table drop (mp_root) ;
alter table wmsys.wm$version_table drop (refCount) ;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$mp_parent_workspaces_table' || purgeOption ;
end;
/
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$mp_graph_workspaces_table' || purgeOption ;
end;
/
drop view wmsys.wm$mp_graph_new_versions ;
drop view wmsys.wm$mp_graph_other_versions ;
drop view wmsys.wm$mp_graph_cons_versions ;
create or replace view wmsys.user_wm_tab_triggers 
(
  trigger_name,
  table_owner,
  table_name,
  trigger_type,
  status,
  when_clause,
  description,
  trigger_body
)
as 
select trig_name,
       table_owner_name,
       table_name,
       trig_type,
       status,
       when_clause,
       description,
       trig_code       
from   wmsys.wm$udtrig_info
where  trig_owner_name = USER
with READ ONLY;
create or replace view wmsys.all_wm_tab_triggers 
(
  trigger_owner,
  trigger_name,
  table_owner,
  table_name,
  trigger_type,
  status,
  when_clause,
  description,
  trigger_body  
)
as 
(select trig_owner_name, 
        trig_name,
        table_owner_name,
        table_name,
        trig_type,
        status,
        when_clause,
        description,
        trig_code       
 from   wmsys.wm$udtrig_info
 where  trig_owner_name = USER or
        table_owner_name = USER or
        EXISTS  
        ( select * 
          from   user_sys_privs
          where  privilege = 'CREATE ANY TRIGGER' ) )
with READ ONLY;
execute wmsys.wm$execSQL('grant select on wmsys.user_wm_tab_triggers to public with grant option');
drop public synonym user_wm_tab_triggers;
create public synonym user_wm_tab_triggers for wmsys.user_wm_tab_triggers; 
execute wmsys.wm$execSQL('grant select on wmsys.all_wm_tab_triggers to public with grant option');
drop public synonym all_wm_tab_triggers;
create public synonym all_wm_tab_triggers for wmsys.all_wm_tab_triggers; 
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$ric_locking_table' || purgeOption ;
end;
/
alter table wmsys.wm$workspaces_table drop constraint workspace_lock_id_unq;
drop view wmsys.wm$anc_version_view;
declare
  purgeOption        varchar2(30) := null ;
  version_str        varchar2(50);
  compatibility_str  varchar2(50);
begin
  dbms_utility.db_version(version_str,compatibility_str);
  version_str := sys.wm$convertDbVersion(version_str);
  if (version_str >= 'A.0.0.0.0') then
    purgeOption := ' PURGE' ;
  end if ;
  execute immediate 'drop table wmsys.wm$sysparam_all_values' || purgeOption ;
end;
/
create or replace view wmsys.wm$current_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = nvl(SYS_CONTEXT('lt_ctx','state'),'LIVE')
WITH READ ONLY;
create or replace view wmsys.wm$parent_workspace_view as 
  select * from wmsys.wm$workspaces_table  
  where workspace = SYS_CONTEXT('lt_ctx','parent_state')
WITH READ ONLY;
drop public synonym wm$mw_nextvers_view ;
update wmsys.wm$ric_triggers_table
set pt_name = pt_name || '_LT'
where pt_owner = ct_owner
  and pt_name = ct_name  ; 
commit ;
