 /*A  * parserInternals.h : internals routines exported by the parser.   *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */   " #ifndef __XML_PARSER_INTERNALS_H__" #define __XML_PARSER_INTERNALS_H__   #include <libxml/parser.h>   #ifdef __cplusplus extern "C" { #endif    /* ;   * Identifiers can be longer, but this will be more costly    * at runtime.    */ #define XML_MAX_NAMELEN 100    /*=  * The parser tries to always have that amount of input ready >  * one of the point is providing context when reporting errors  */  #define INPUT_CHUNK	250   I /************************************************************************   *									*-  * UNICODE version of the macros.      					*   *									*J  ************************************************************************/ /*A  * [2] Char ::= #x9 | #xA | #xD | [#x20-#xD7FF] | [#xE000-#xFFFD] (  *                  | [#x10000-#x10FFFF]I  * any Unicode character, excluding the surrogate blocks, FFFE, and FFFF.   */  #define IS_CHAR(c)							\;     (((c) == 0x09) || ((c) == 0x0A) || ((c) == 0x0D) ||			\ /      (((c) >= 0x20) && ((c) <= 0xD7FF)) ||				\ 1      (((c) >= 0xE000) && ((c) <= 0xFFFD)) ||				\ -      (((c) >= 0x10000) && ((c) <= 0x10FFFF)))    /*&  * [3] S ::= (#x20 | #x9 | #xD | #xA)+  */ H #define IS_BLANK(c) (((c) == 0x20) || ((c) == 0x09) || ((c) == 0xA) ||	\#                      ((c) == 0x0D))    /*.  * [85] BaseChar ::= ... long list see REC ...  */ ' #define IS_BASECHAR(c) xmlIsBaseChar(c)    /*+  * [88] Digit ::= ... long list see REC ...   */ ! #define IS_DIGIT(c) xmlIsDigit(c)    /*3  * [87] CombiningChar ::= ... long list see REC ...   */ ) #define IS_COMBINING(c) xmlIsCombining(c)    /*A  * [89] Extender ::= #x00B7 | #x02D0 | #x02D1 | #x0387 | #x0640 | A  *                   #x0E46 | #x0EC6 | #x3005 | [#x3031-#x3035] | 6  *                   [#x309D-#x309E] | [#x30FC-#x30FE]  */ ' #define IS_EXTENDER(c) xmlIsExtender(c)    /*B  * [86] Ideographic ::= [#x4E00-#x9FA5] | #x3007 | [#x3021-#x3029]  */ - #define IS_IDEOGRAPHIC(c) xmlIsIdeographic(c)    /**  * [84] Letter ::= BaseChar | Ideographic   */ : #define IS_LETTER(c) (IS_BASECHAR(c) || IS_IDEOGRAPHIC(c))     /*L  * [13] PubidChar ::= #x20 | #xD | #xA | [a-zA-Z0-9] | [-'()+,./:=?;!*#@$_%]  */ ) #define IS_PUBIDCHAR(c)	xmlIsPubidChar(c)    #define SKIP_EOL(p) 							\:     if (*(p) == 0x13) { p++ ; if (*(p) == 0x10) p++; }			\6     if (*(p) == 0x10) { p++ ; if (*(p) == 0x13) p++; }   #define MOVETO_ENDTAG(p)						\ '     while ((*p) && (*(p) != '>')) (p)++   ! #define MOVETO_STARTTAG(p)						\ '     while ((*p) && (*(p) != '<')) (p)++    /** :  * Global vaiables affecting the default parser behaviour.  */   " extern int xmlParserDebugEntities;& extern int xmlGetWarningsDefaultValue;" extern int xmlParserDebugEntities;- extern int xmlSubstituteEntitiesDefaultValue; - extern int xmlDoValidityCheckingDefaultValue; ) extern int xmlPedanticParserDefaultValue; % extern int xmlKeepBlanksDefaultValue;    /*9  * Function to finish teh work of the macros where needed   */  int			xmlIsBaseChar	(int c); int			xmlIsBlank	(int c);  int			xmlIsPubidChar	(int c);  int			xmlIsLetter	(int c); int			xmlIsDigit	(int c);  int			xmlIsIdeographic(int c); int			xmlIsCombining	(int c);  int			xmlIsExtender	(int c); int			xmlIsCombining	(int c);  int			xmlIsChar	(int c);   /**   * Parser context   */ 7 xmlParserCtxtPtr	xmlCreateDocParserCtxt	(xmlChar *cur); @ xmlParserCtxtPtr	xmlCreateFileParserCtxt	(const char *filename);8 xmlParserCtxtPtr	xmlCreateMemoryParserCtxt(char *buffer, 						 int size); ) xmlParserCtxtPtr	xmlNewParserCtxt	(void); > xmlParserCtxtPtr	xmlCreateEntityParserCtxt(const xmlChar *URL, 						 const xmlChar *ID,  						 const xmlChar *base);/ int			xmlSwitchEncoding	(xmlParserCtxtPtr ctxt,  						 xmlCharEncoding enc);1 int			xmlSwitchToEncoding	(xmlParserCtxtPtr ctxt, - 					     xmlCharEncodingHandlerPtr handler); 1 void			xmlFreeParserCtxt	(xmlParserCtxtPtr ctxt);    /**   * Entities   */ / void			xmlHandleEntity		(xmlParserCtxtPtr ctxt,  						 xmlEntityPtr entity);   /**   * Input Streams  */ A xmlParserInputPtr	xmlNewEntityInputStream	(xmlParserCtxtPtr ctxt,  						 xmlEntityPtr entity);, void			xmlPushInput		(xmlParserCtxtPtr ctxt,  						 xmlParserInputPtr input);/ xmlChar			xmlPopInput		(xmlParserCtxtPtr ctxt); 4 void			xmlFreeInputStream	(xmlParserInputPtr input);= xmlParserInputPtr	xmlNewInputFromFile	(xmlParserCtxtPtr ctxt,  						 const char *filename); < xmlParserInputPtr	xmlNewInputStream	(xmlParserCtxtPtr ctxt);   /**   * Namespaces.  */ 1 xmlChar *		xmlSplitQName		(xmlParserCtxtPtr ctxt,  						 const xmlChar *name,  						 xmlChar **prefix); ; xmlChar *		xmlNamespaceParseNCName	(xmlParserCtxtPtr ctxt); 9 xmlChar *		xmlNamespaceParseQName	(xmlParserCtxtPtr ctxt,  						 xmlChar **prefix); : xmlChar *		xmlNamespaceParseNSDef	(xmlParserCtxtPtr ctxt);8 xmlChar *		xmlParseQuotedString	(xmlParserCtxtPtr ctxt);1 void			xmlParseNamespace	(xmlParserCtxtPtr ctxt);    /**   * Generic production rules   */ 0 xmlChar *		xmlScanName		(xmlParserCtxtPtr ctxt);1 xmlChar *		xmlParseName		(xmlParserCtxtPtr ctxt); 4 xmlChar *		xmlParseNmtoken		(xmlParserCtxtPtr ctxt);6 xmlChar *		xmlParseEntityValue	(xmlParserCtxtPtr ctxt, 						 xmlChar **orig); 4 xmlChar *		xmlParseAttValue	(xmlParserCtxtPtr ctxt);9 xmlChar *		xmlParseSystemLiteral	(xmlParserCtxtPtr ctxt); 8 xmlChar *		xmlParsePubidLiteral	(xmlParserCtxtPtr ctxt);/ void			xmlParseCharData	(xmlParserCtxtPtr ctxt,  						 int cdata);5 xmlChar *		xmlParseExternalID	(xmlParserCtxtPtr ctxt,  						 xmlChar **publicID, 						 int strict); 0 void			xmlParseComment		(xmlParserCtxtPtr ctxt);4 xmlChar *		xmlParsePITarget	(xmlParserCtxtPtr ctxt);+ void			xmlParsePI		(xmlParserCtxtPtr ctxt); 4 void			xmlParseNotationDecl	(xmlParserCtxtPtr ctxt);2 void			xmlParseEntityDecl	(xmlParserCtxtPtr ctxt);1 int			xmlParseDefaultDecl	(xmlParserCtxtPtr ctxt,  						 xmlChar **value);? xmlEnumerationPtr	xmlParseNotationType	(xmlParserCtxtPtr ctxt); B xmlEnumerationPtr	xmlParseEnumerationType	(xmlParserCtxtPtr ctxt);4 int			xmlParseEnumeratedType	(xmlParserCtxtPtr ctxt,  						 xmlEnumerationPtr *tree);3 int			xmlParseAttributeType	(xmlParserCtxtPtr ctxt,   						 xmlEnumerationPtr *tree);8 void			xmlParseAttributeListDecl(xmlParserCtxtPtr ctxt);4 xmlElementContentPtr	xmlParseElementMixedContentDecl 						(xmlParserCtxtPtr ctxt);7 xmlElementContentPtr	xmlParseElementChildrenContentDecl  						(xmlParserCtxtPtr ctxt);7 int			xmlParseElementContentDecl(xmlParserCtxtPtr ctxt,  						 xmlChar *name, % 						 xmlElementContentPtr *result); 2 int			xmlParseElementDecl	(xmlParserCtxtPtr ctxt);2 void			xmlParseMarkupDecl	(xmlParserCtxtPtr ctxt);/ int			xmlParseCharRef		(xmlParserCtxtPtr ctxt); 8 xmlEntityPtr		xmlParseEntityRef	(xmlParserCtxtPtr ctxt);1 void			xmlParseReference	(xmlParserCtxtPtr ctxt); 3 void			xmlParsePEReference	(xmlParserCtxtPtr ctxt); 3 void			xmlParseDocTypeDecl	(xmlParserCtxtPtr ctxt); 4 xmlChar *		xmlParseAttribute	(xmlParserCtxtPtr ctxt, 						 xmlChar **value);4 xmlChar *		xmlParseStartTag	(xmlParserCtxtPtr ctxt);/ void			xmlParseEndTag		(xmlParserCtxtPtr ctxt); / void			xmlParseCDSect		(xmlParserCtxtPtr ctxt); 0 void			xmlParseContent		(xmlParserCtxtPtr ctxt);0 void			xmlParseElement		(xmlParserCtxtPtr ctxt);6 xmlChar *		xmlParseVersionNum	(xmlParserCtxtPtr ctxt);7 xmlChar *		xmlParseVersionInfo	(xmlParserCtxtPtr ctxt); 4 xmlChar *		xmlParseEncName		(xmlParserCtxtPtr ctxt);8 xmlChar *		xmlParseEncodingDecl	(xmlParserCtxtPtr ctxt);. int			xmlParseSDDecl		(xmlParserCtxtPtr ctxt);0 void			xmlParseXMLDecl		(xmlParserCtxtPtr ctxt);0 void			xmlParseTextDecl	(xmlParserCtxtPtr ctxt);- void			xmlParseMisc		(xmlParserCtxtPtr ctxt); 5 void			xmlParseExternalSubset	(xmlParserCtxtPtr ctxt, ! 						 const xmlChar *ExternalID, ! 						 const xmlChar *SystemID);   /*  * Entities substitution  */  #define XML_SUBSTITUTE_NONE	0  #define XML_SUBSTITUTE_REF	1 #define XML_SUBSTITUTE_PEREF	2 #define XML_SUBSTITUTE_BOTH 	3  4 xmlChar *		xmlDecodeEntities	(xmlParserCtxtPtr ctxt, 						 int len,  						 int what, 						 xmlChar end,  						 xmlChar  end2,  						 xmlChar end3); : xmlChar *		xmlStringDecodeEntities	(xmlParserCtxtPtr ctxt, 						 const xmlChar *str, 						 int what, 						 xmlChar end,  						 xmlChar  end2,  						 xmlChar end3);    /*;  * Generated by MACROS on top of parser.c c.f. PUSH_AND_POP   */ ' int			nodePush		(xmlParserCtxtPtr ctxt,  						 xmlNodePtr value); . xmlNodePtr		nodePop			(xmlParserCtxtPtr ctxt);( int			inputPush		(xmlParserCtxtPtr ctxt,  						 xmlParserInputPtr value);4 xmlParserInputPtr	inputPop		(xmlParserCtxtPtr ctxt);   /*?  * other comodities shared between parser.c and parserInternals   */ 0 int			xmlSkipBlankChars	(xmlParserCtxtPtr ctxt);2 int			xmlStringCurrentChar	(xmlParserCtxtPtr ctxt, 						 const xmlChar *cur, 						 int *len); 9 void			xmlParserHandlePEReference(xmlParserCtxtPtr ctxt); 7 void			xmlParserHandleReference(xmlParserCtxtPtr ctxt); : xmlChar                *namePop			(xmlParserCtxtPtr ctxt);/ int			xmlCheckLanguageID	(const xmlChar *lang);    /*/  * Really core function shared with HTML parser   */ - int			xmlCurrentChar		(xmlParserCtxtPtr ctxt,  						 int *len);  int			xmlCopyChar		(int len, 						 xmlChar *out, 						 int val);, void			xmlNextChar		(xmlParserCtxtPtr ctxt);3 void			xmlParserInputShrink	(xmlParserInputPtr in);    #ifdef LIBXML_HTML_ENABLED /*G  * Actually comes from the HTML parser but launched from the init stuff   */   void			htmlInitAutoClose	(void); #endif #ifdef __cplusplus }  #endif' #endif /* __XML_PARSER_INTERNALS_H__ */ 