 /*=  * tree.c : implemetation of access function for an XML tree.   *1  * See Copyright for the status of this software.   *  * Daniel.Veillard@w3.org   */    #ifdef WIN32 #include "win32config.h" #else  #include "config.h"  #endif   #include <stdio.h>- #include <string.h> /* for memset() only ! */    #ifdef HAVE_CTYPE_H  #include <ctype.h> #endif #ifdef HAVE_STDLIB_H #include <stdlib.h>  #endif #ifdef HAVE_ZLIB_H #include <zlib.h>  #endif   #include <libxml/xmlmemory.h>  #include <libxml/tree.h> #include <libxml/parser.h> #include <libxml/entities.h> #include <libxml/valid.h>   ; static xmlChar xmlStringText[] = { 't', 'e', 'x', 't', 0 }; M static xmlChar xmlStringComment[] = { 'c', 'o', 'm', 'm', 'e', 'n', 't', 0 };  int oldXMLWDcompatibility = 0; int xmlIndentTreeOutput = 0;H xmlBufferAllocationScheme xmlBufferAllocScheme = XML_BUFFER_ALLOC_EXACT;   static int xmlCompressMode = 0;  static int xmlCheckDTD = 1;  int xmlSaveNoEmptyTags = 0;    #define IS_BLANK(c)							\ C   (((c) == '\n') || ((c) == '\r') || ((c) == '\t') || ((c) == ' '))   4 #define UPDATE_LAST_CHILD(n) if ((n) != NULL) {				\,     xmlNodePtr ulccur = (n)->children;					\      if (ulccur == NULL) {						\          (n)->last = NULL;						\     } else {								\ >         while (ulccur->next != NULL) ulccur = ulccur->next;		\ 	(n)->last = ulccur;						\  }}   /* #define DEBUG_BUFFER */ /* #define DEBUG_TREE */  I /************************************************************************   *									*6  *		Allocation and deallocation of basic structures		*  *									*J  ************************************************************************/    /**    * xmlSetBufferAllocationScheme:%  * @scheme:  allocation method to use   *  /  * Set the buffer allocation method.  Types are D  * XML_BUFFER_ALLOC_EXACT - use exact sizes, keeps memory usage down@  * XML_BUFFER_ALLOC_DOUBLEIT - double buffer when extra needed, 3  *                             improves performance   */  void@ xmlSetBufferAllocationScheme(xmlBufferAllocationScheme scheme) {"     xmlBufferAllocScheme = scheme; }    /**    * xmlGetBufferAllocationScheme:  *  * Types areD  * XML_BUFFER_ALLOC_EXACT - use exact sizes, keeps memory usage down@  * XML_BUFFER_ALLOC_DOUBLEIT - double buffer when extra needed, 3  *                             improves performance   *  (  * Returns the current allocation scheme  */  xmlBufferAllocationScheme   xmlGetBufferAllocationScheme() {      return xmlBufferAllocScheme; }    /**   * xmlUpgradeOldNs:   * @doc:  a document pointer  *  O  * Upgrade old style Namespaces (PI) and move them to the root of the document.   */  void  xmlUpgradeOldNs(xmlDocPtr doc) {     xmlNsPtr cur;   6     if ((doc == NULL) || (doc->oldNs == NULL)) return;      if (doc->children == NULL) { #ifdef DEBUG_TREE ?         fprintf(stderr, "xmlUpgradeOldNs: failed no root !\n");  #endif 	return;     }        cur = doc->oldNs;      while (cur->next != NULL) { ! 	cur->type = XML_LOCAL_NAMESPACE;          cur = cur->next;     } $     cur->type = XML_LOCAL_NAMESPACE;%     cur->next = doc->children->nsDef; &     doc->children->nsDef = doc->oldNs;     doc->oldNs = NULL; }    /**   * xmlNewNs:-  * @node:  the element carrying the namespace   * @href:  the URI associated )  * @prefix:  the prefix for the namespace   *C  * Creation of a new Namespace. This function will refuse to create I  * a namespace with a similar prefix than an existing one present on this   * node.K  * We use href==NULL in the case of an element creation where the namespace   * was not defined. 2  * Returns returns a new namespace pointer or NULL  */  xmlNsPtrG xmlNewNs(xmlNodePtr node, const xmlChar *href, const xmlChar *prefix) {      xmlNsPtr cur;        /*4      * Allocate a new Namespace and fill the fields.      */ .     cur = (xmlNsPtr) xmlMalloc(sizeof(xmlNs));     if (cur == NULL) {6         fprintf(stderr, "xmlNewNs : malloc failed\n"); 	return(NULL);     } "     memset(cur, 0, sizeof(xmlNs));$     cur->type = XML_LOCAL_NAMESPACE;       if (href != NULL)  	cur->href = xmlStrdup(href);      if (prefix != NULL) " 	cur->prefix = xmlStrdup(prefix);        /*6      * Add it at the end to preserve parsing order ...0      * and checks for existing use of the prefix      */      if (node != NULL) {  	if (node->nsDef == NULL) {  	    node->nsDef = cur; 	 	} else { ! 	    xmlNsPtr prev = node->nsDef;   = 	    if (((prev->prefix == NULL) && (cur->prefix == NULL)) || - 		(xmlStrEqual(prev->prefix, cur->prefix))) {  		xmlFreeNs(cur);  		return(NULL); 
 	    }    ! 	    while (prev->next != NULL) {  	        prev = prev->next; : 		if (((prev->prefix == NULL) && (cur->prefix == NULL)) ||1 		    (xmlStrEqual(prev->prefix, cur->prefix))) {  		    xmlFreeNs(cur);  		    return(NULL);  		}      	    } 	    prev->next = cur; 	}     }      return(cur); }    /**   * xmlNewGlobalNs:-  * @doc:  the document carrying the namespace   * @href:  the URI associated )  * @prefix:  the prefix for the namespace   *D  * Creation of a Namespace, the old way using PI and without scoping  *   DEPRECATED !!! J  * It now create a namespace on the root element of the document if found.4  * Returns NULL this functionnality had been removed  */  xmlNsPtrK xmlNewGlobalNs(xmlDocPtr doc, const xmlChar *href, const xmlChar *prefix) {      xmlNodePtr root;       xmlNsPtr cur;    %     root = xmlDocGetRootElement(doc);      if (root != NULL) & 	return(xmlNewNs(root, href, prefix)); 	      /*D      * if there is no root element yet, create an old Namespace type5      * and it will be moved to the root at save time.       */ .     cur = (xmlNsPtr) xmlMalloc(sizeof(xmlNs));     if (cur == NULL) {<         fprintf(stderr, "xmlNewGlobalNs : malloc failed\n"); 	return(NULL);     } "     memset(cur, 0, sizeof(xmlNs));%     cur->type = XML_GLOBAL_NAMESPACE;        if (href != NULL)  	cur->href = xmlStrdup(href);      if (prefix != NULL) " 	cur->prefix = xmlStrdup(prefix);        /*6      * Add it at the end to preserve parsing order ...      */      if (doc != NULL) { 	if (doc->oldNs == NULL) { 	    doc->oldNs = cur;	 	} else {   	    xmlNsPtr prev = doc->oldNs;  2 	    while (prev->next != NULL) prev = prev->next; 	    prev->next = cur; 	}     }      return(NULL);  }    /**   * xmlSetNs:!  * @node:  a node in the document   * @ns:  a namespace pointer  *1  * Associate a namespace to a node, a posteriori.   */  void( xmlSetNs(xmlNodePtr node, xmlNsPtr ns) {     if (node == NULL) {  #ifdef DEBUG_TREE 4         fprintf(stderr, "xmlSetNs: node == NULL\n"); #endif 	return;     }      node->ns = ns; }    /** 
  * xmlFreeNs:   * @cur:  the namespace pointer   *3  * Free up the structures associated to a namespace   */  void xmlFreeNs(xmlNsPtr cur) {      if (cur == NULL) { #ifdef DEBUG_TREE 4         fprintf(stderr, "xmlFreeNs : ns == NULL\n"); #endif 	return;     } 7     if (cur->href != NULL) xmlFree((char *) cur->href); ;     if (cur->prefix != NULL) xmlFree((char *) cur->prefix); #     memset(cur, -1, sizeof(xmlNs));      xmlFree(cur);  }    /**   * xmlFreeNsList: %  * @cur:  the first namespace pointer   *C  * Free up all the structures associated to the chained namespaces.   */  void xmlFreeNsList(xmlNsPtr cur) {      xmlNsPtr next;     if (cur == NULL) { #ifdef DEBUG_TREE 8         fprintf(stderr, "xmlFreeNsList : ns == NULL\n"); #endif 	return;     }      while (cur != NULL) {          next = cur->next;          xmlFreeNs(cur);  	cur = next;     }  }    /** 
  * xmlNewDtd:   * @doc:  the document pointer  * @name:  the DTD name    * @ExternalID:  the external ID  * @SystemID:  the system ID  *>  * Creation of a new DTD for the external subset. To create an-  * internal subset, use xmlCreateIntSubset().   *-  * Returns a pointer to the new DTD structure   */ 	 xmlDtdPtr - xmlNewDtd(xmlDocPtr doc, const xmlChar *name, I                     const xmlChar *ExternalID, const xmlChar *SystemID) {      xmlDtdPtr cur;  4     if ((doc != NULL) && (doc->extSubset != NULL)) { #ifdef DEBUG_TREE M         fprintf(stderr, "xmlNewDtd(%s): document %s already have a DTD %s\n", ( 	    /* !!! */ (char *) name, doc->name,- 	    /* !!! */ (char *)doc->extSubset->name);  #endif 	return(NULL);     }        /*.      * Allocate a new DTD and fill the fields.      */ 0     cur = (xmlDtdPtr) xmlMalloc(sizeof(xmlDtd));     if (cur == NULL) {7         fprintf(stderr, "xmlNewDtd : malloc failed\n");  	return(NULL);     } $     memset(cur, 0 , sizeof(xmlDtd));     cur->type = XML_DTD_NODE;        if (name != NULL)  	cur->name = xmlStrdup(name);      if (ExternalID != NULL) * 	cur->ExternalID = xmlStrdup(ExternalID);      if (SystemID != NULL) & 	cur->SystemID = xmlStrdup(SystemID);      if (doc != NULL) 	doc->extSubset = cur;     cur->doc = doc;        return(cur); }    /**   * xmlGetIntSubset:   * @doc:  the document pointer  *(  * Get the internal subset of a document>  * Returns a pointer to the DTD structure or NULL if not found  */   	 xmlDtdPtr   xmlGetIntSubset(xmlDocPtr doc) {     xmlNodePtr cur;        if (doc == NULL) 	return(NULL);     cur = doc->children;     while (cur != NULL) {  	if (cur->type == XML_DTD_NODE)  	    return((xmlDtdPtr) cur);  	cur = cur->next;      } '     return((xmlDtdPtr) doc->intSubset);  }    /**   * xmlCreateIntSubset:  * @doc:  the document pointer  * @name:  the DTD name    * @ExternalID:  the external ID  * @SystemID:  the system ID  *+  * Create the internal subset of a document -  * Returns a pointer to the new DTD structure   */ 	 xmlDtdPtr 6 xmlCreateIntSubset(xmlDocPtr doc, const xmlChar *name,H                    const xmlChar *ExternalID, const xmlChar *SystemID) {     xmlDtdPtr cur;  :     if ((doc != NULL) && (xmlGetIntSubset(doc) != NULL)) { #ifdef DEBUG_TREE          fprintf(stderr, K      "xmlCreateIntSubset(): document %s already have an internal subset\n",  	    doc->name); #endif 	return(NULL);     }        /*.      * Allocate a new DTD and fill the fields.      */ 0     cur = (xmlDtdPtr) xmlMalloc(sizeof(xmlDtd));     if (cur == NULL) {7         fprintf(stderr, "xmlNewDtd : malloc failed\n");  	return(NULL);     } #     memset(cur, 0, sizeof(xmlDtd));      cur->type = XML_DTD_NODE;        if (name != NULL)  	cur->name = xmlStrdup(name);      if (ExternalID != NULL) * 	cur->ExternalID = xmlStrdup(ExternalID);      if (SystemID != NULL) & 	cur->SystemID = xmlStrdup(SystemID);      if (doc != NULL) { 	doc->intSubset = cur; 	cur->parent = doc;  	cur->doc = doc; 	if (doc->children == NULL) { & 	    doc->children = (xmlNodePtr) cur;" 	    doc->last = (xmlNodePtr) cur;	 	} else {  	    xmlNodePtr prev;   / 	    if (doc->type == XML_HTML_DOCUMENT_NODE) {  		prev = doc->children;   		prev->prev = (xmlNodePtr) cur; 		cur->next = prev; # 		doc->children = (xmlNodePtr) cur; 
 	    } else {  		prev = doc->last;   		prev->next = (xmlNodePtr) cur; 		cur->prev = prev;  		doc->last = (xmlNodePtr) cur;  	    } 	}     }      return(cur); }    /**   * xmlFreeDtd:&  * @cur:  the DTD structure to free up  *  * Free a DTD structure.  */  void xmlFreeDtd(xmlDtdPtr cur) {      if (cur == NULL) { #ifdef DEBUG_TREE 6         fprintf(stderr, "xmlFreeDtd : DTD == NULL\n"); #endif 	return;     }       if (cur->children != NULL) {$ 	xmlNodePtr next, c = cur->children;   	/* 8 	 * Cleanup all the DTD comments they are not in the Dtd 	 * indexes. 	 */         while (c != NULL) {  	    next = c->next;' 	    if (c->type == XML_COMMENT_NODE) {  		xmlUnlinkNode(c);  		xmlFreeNode(c);  	    } 	    c = next; 	}     } 7     if (cur->name != NULL) xmlFree((char *) cur->name); ?     if (cur->SystemID != NULL) xmlFree((char *) cur->SystemID); C     if (cur->ExternalID != NULL) xmlFree((char *) cur->ExternalID);      /* TODO !!! */     if (cur->notations != NULL) C         xmlFreeNotationTable((xmlNotationTablePtr) cur->notations);           if (cur->elements != NULL)@         xmlFreeElementTable((xmlElementTablePtr) cur->elements);      if (cur->attributes != NULL)F         xmlFreeAttributeTable((xmlAttributeTablePtr) cur->attributes);     if (cur->entities != NULL)B         xmlFreeEntitiesTable((xmlEntitiesTablePtr) cur->entities);  $     memset(cur, -1, sizeof(xmlDtd));     xmlFree(cur);  }    /** 
  * xmlNewDoc: <  * @version:  xmlChar string giving the version of XML "1.0"  *  * Returns a new document   */ 	 xmlDocPtr # xmlNewDoc(const xmlChar *version) {      xmlDocPtr cur;       if (version == NULL) { #ifdef DEBUG_TREE 9         fprintf(stderr, "xmlNewDoc : version == NULL\n");  #endif 	return(NULL);     }        /*3      * Allocate a new document and fill the fields.       */ 0     cur = (xmlDocPtr) xmlMalloc(sizeof(xmlDoc));     if (cur == NULL) {7         fprintf(stderr, "xmlNewDoc : malloc failed\n");  	return(NULL);     } #     memset(cur, 0, sizeof(xmlDoc)); "     cur->type = XML_DOCUMENT_NODE;  '     cur->version = xmlStrdup(version);       cur->standalone = -1; 0     cur->compression = -1; /* not initialized */     cur->doc = cur;      return(cur); }    /**   * xmlFreeDoc:!  * @cur:  pointer to the document   * @:     *@  * Free up all the structures used by a document, tree included.  */  void xmlFreeDoc(xmlDocPtr cur) {      if (cur == NULL) { #ifdef DEBUG_TREE ;         fprintf(stderr, "xmlFreeDoc : document == NULL\n");  #endif 	return;     } =     if (cur->version != NULL) xmlFree((char *) cur->version); 7     if (cur->name != NULL) xmlFree((char *) cur->name); ?     if (cur->encoding != NULL) xmlFree((char *) cur->encoding); >     if (cur->children != NULL) xmlFreeNodeList(cur->children);;     if (cur->intSubset != NULL) xmlFreeDtd(cur->intSubset); ;     if (cur->extSubset != NULL) xmlFreeDtd(cur->extSubset); 6     if (cur->oldNs != NULL) xmlFreeNsList(cur->oldNs);C     if (cur->ids != NULL) xmlFreeIDTable((xmlIDTablePtr) cur->ids); G     if (cur->refs != NULL) xmlFreeRefTable((xmlRefTablePtr) cur->refs); 5     if (cur->URL != NULL) xmlFree((char *) cur->URL); $     memset(cur, -1, sizeof(xmlDoc));     xmlFree(cur);  }    /**   * xmlStringLenGetNodeList:   * @doc:  the document!  * @value:  the value of the text (  * @len:  the length of the string value  *D  * Parse the value string and build the node list associated. Should7  * produce a flat tree with only TEXTs and ENTITY_REFs. '  * Returns a pointer to the first child   */ 
 xmlNodePtrG xmlStringLenGetNodeList(xmlDocPtr doc, const xmlChar *value, int len) { '     xmlNodePtr ret = NULL, last = NULL;      xmlNodePtr node;     xmlChar *val;      const xmlChar *cur = value;      const xmlChar *q;      xmlEntityPtr ent;   $     if (value == NULL) return(NULL);       q = cur;0     while ((*cur != 0) && (cur - value < len)) { 	if (*cur == '&') {  	    /*  	     * Save the current text. 	     */             if (cur != q) { 8 		if ((last != NULL) && (last->type == XML_TEXT_NODE)) {- 		    xmlNodeAddContentLen(last, q, cur - q); 
 		} else {/ 		    node = xmlNewDocTextLen(doc, q, cur - q); $ 		    if (node == NULL) return(ret); 		    if (last == NULL)  			last = ret = node;  		    else { 			last->next = node;  			node->prev = last;  			last = node;  		    }  		}  	    } 	    /*  	     * Read the entity string 	     */ 	    cur++; 
 	    q = cur; G 	    while ((*cur != 0) && (cur - value < len) && (*cur != ';')) cur++; / 	    if ((*cur == 0) || (cur - value >= len)) {  #ifdef DEBUG_TREE  	        fprintf(stderr,@ 		    "xmlStringLenGetNodeList: unterminated entity %30s\n", q); #endif 	        return(ret);  	    }             if (cur != q) {  		/*- 		 * Predefined entities don't generate nodes  		 */  		val = xmlStrndup(q, cur - q); " 		ent = xmlGetDocEntity(doc, val); 		if ((ent != NULL) &&7 		    (ent->etype == XML_INTERNAL_PREDEFINED_ENTITY)) {  		    if (last == NULL) { 2 		        node = xmlNewDocText(doc, ent->content); 			last = ret = node;  		    } else0 		        xmlNodeAddContent(last, ent->content);
 		        
 		} else { 		    /*( 		     * Create a new REFERENCE_REF node	 		     */ ' 		    node = xmlNewReference(doc, val);  		    if (node == NULL) { ! 			if (val != NULL) xmlFree(val);  		        return(ret); 		    }  		    if (last == NULL)u 			last = ret = node;  		    else { 			last->next = node;  			node->prev = last;  			last = node;d 		    }  		}  		xmlFree(val);i 	    } 	    cur++;"
 	    q = cur;u 	} else  	    cur++;      }u     if (cur != q) {e
         /*" 	 * Handle the last piece of text. 	 */7 	if ((last != NULL) && (last->type == XML_TEXT_NODE)) {H, 	    xmlNodeAddContentLen(last, q, cur - q);	 	} else {u. 	    node = xmlNewDocTextLen(doc, q, cur - q);# 	    if (node == NULL) return(ret);c 	    if (last == NULL) 		last = ret = node; 	    else {u 		last->next = node; 		node->prev = last; 		last = node; 	    } 	}     }0     return(ret); }x   /**g  * xmlStringGetNodeList:  * @doc:  the document&  * @value:  the value of the attribute  *D  * Parse the value string and build the node list associated. Should7  * produce a flat tree with only TEXTs and ENTITY_REFs.='  * Returns a pointer to the first childm  */N
 xmlNodePtr; xmlStringGetNodeList(xmlDocPtr doc, const xmlChar *value) {)'     xmlNodePtr ret = NULL, last = NULL;)     xmlNodePtr node;     xmlChar *val;)     const xmlChar *cur = value;u     const xmlChar *q;	     xmlEntityPtr ent;   $     if (value == NULL) return(NULL);       q = cur;     while (*cur != 0) {  	if (*cur == '&') {= 	    /*c 	     * Save the current text. 	     */             if (cur != q) {D8 		if ((last != NULL) && (last->type == XML_TEXT_NODE)) {- 		    xmlNodeAddContentLen(last, q, cur - q);*
 		} else {/ 		    node = xmlNewDocTextLen(doc, q, cur - q);f$ 		    if (node == NULL) return(ret); 		    if (last == NULL)* 			last = ret = node;* 		    else { 			last->next = node;x 			node->prev = last;h 			last = node;  		    }o 		}h 	    } 	    /*  	     * Read the entity string 	     */ 	    cur++;L
 	    q = cur;X0 	    while ((*cur != 0) && (*cur != ';')) cur++; 	    if (*cur == 0) {E #ifdef DEBUG_TREEw 	        fprintf(stderr,A 		        "xmlStringGetNodeList: unterminated entity %30s\n", q);u #endif 	        return(ret);l 	    }             if (cur != q) {e 		/*- 		 * Predefined entities don't generate nodesl 		 */S 		val = xmlStrndup(q, cur - q);B" 		ent = xmlGetDocEntity(doc, val); 		if ((ent != NULL) &&7 		    (ent->etype == XML_INTERNAL_PREDEFINED_ENTITY)) {  		    if (last == NULL) { 2 		        node = xmlNewDocText(doc, ent->content); 			last = ret = node;  		    } else0 		        xmlNodeAddContent(last, ent->content);
 		        
 		} else { 		    /*( 		     * Create a new REFERENCE_REF node	 		     */:' 		    node = xmlNewReference(doc, val);d 		    if (node == NULL) {m! 			if (val != NULL) xmlFree(val);t 		        return(ret); 		    }m 		    if (last == NULL)P 			last = ret = node;c 		    else { 			last->next = node;t 			node->prev = last;d 			last = node;i 		    }G 		}  		xmlFree(val);( 	    } 	    cur++;d
 	    q = cur;o 	} else  	    cur++;t     }      if (cur != q) {-
         /*" 	 * Handle the last piece of text. 	 */7 	if ((last != NULL) && (last->type == XML_TEXT_NODE)) { , 	    xmlNodeAddContentLen(last, q, cur - q);	 	} else {o. 	    node = xmlNewDocTextLen(doc, q, cur - q);# 	    if (node == NULL) return(ret);  	    if (last == NULL) 		last = ret = node; 	    else {h 		last->next = node; 		node->prev = last; 		last = node; 	    } 	}     }a     return(ret); }t   /**a  * xmlNodeListGetString:  * @doc:  the document  * @list:  a Node listJ  * @inLine:  should we replace entity contents or show their external form  *G  * Returns the string equivalent to the text contained in the Node listt   * made of TEXTs and ENTITY_REFsB  * Returns a pointer to the string copy, the calller must free it.  */o	 xmlChar * B xmlNodeListGetString(xmlDocPtr doc, xmlNodePtr list, int inLine) {     xmlNodePtr node = list;n     xmlChar *ret = NULL;     xmlEntityPtr ent;)  #     if (list == NULL) return(NULL);        while (node != NULL) {,         if ((node->type == XML_TEXT_NODE) ||. 	    (node->type == XML_CDATA_SECTION_NODE)) { 	    if (inLine) { #ifndef XML_USE_BUFFER_CONTENT& 		ret = xmlStrcat(ret, node->content); #else 8 		ret = xmlStrcat(ret, xmlBufferContent(node->content)); #endif
 	    } else {d 	        xmlChar *buffer;p   #ifndef XML_USE_BUFFER_CONTENT: 		buffer = xmlEncodeEntitiesReentrant(doc, node->content); #else * 		buffer = xmlEncodeEntitiesReentrant(doc,* 					    xmlBufferContent(node->content)); #endif 		if (buffer != NULL) {e# 		    ret = xmlStrcat(ret, buffer);  		    xmlFree(buffer); 		}e
             }>0 	} else if (node->type == XML_ENTITY_REF_NODE) { 	    if (inLine) {) 		ent = xmlGetDocEntity(doc, node->name);  		if (ent != NULL)) 		    ret = xmlStrcat(ret, ent->content);= 		else { #ifndef XML_USE_BUFFER_CONTENT* 		    ret = xmlStrcat(ret, node->content); #else < 		    ret = xmlStrcat(ret, xmlBufferContent(node->content)); #endif 		}    n             } else { 	        xmlChar buf[2]; 		buf[0] = '&'; buf[1] = 0;a  		ret = xmlStrncat(ret, buf, 1);# 		ret = xmlStrcat(ret, node->name);h 		buf[0] = ';'; buf[1] = 0;   		ret = xmlStrncat(ret, buf, 1); 	    } 	} #if 0i 	else {DF 	    fprintf(stderr, "xmlGetNodeListString : invalide node type %d\n", 	            node->type);r 	} #endif 	node = node->next;e     }v     return(ret); }m   /**b  * xmlNodeListGetRawString:C  * @doc:  the document  * @list:  a Node listJ  * @inLine:  should we replace entity contents or show their external form  *G  * Returns the string equivalent to the text contained in the Node list D  * made of TEXTs and ENTITY_REFs, contrary to xmlNodeListGetString()<  * this function doesn't do any character encoding handling.  *B  * Returns a pointer to the string copy, the calller must free it.  */ 	 xmlChar *tE xmlNodeListGetRawString(xmlDocPtr doc, xmlNodePtr list, int inLine) {      xmlNodePtr node = list;N     xmlChar *ret = NULL;     xmlEntityPtr ent;   #     if (list == NULL) return(NULL);t       while (node != NULL) {*         if (node->type == XML_TEXT_NODE) { 	    if (inLine) { #ifndef XML_USE_BUFFER_CONTENT& 		ret = xmlStrcat(ret, node->content); #else{8 		ret = xmlStrcat(ret, xmlBufferContent(node->content)); #endif
 	    } else {r 	        xmlChar *buffer;i   #ifndef XML_USE_BUFFER_CONTENT5 		buffer = xmlEncodeSpecialChars(doc, node->content);n #else % 		buffer = xmlEncodeSpecialChars(doc,a* 					    xmlBufferContent(node->content)); #endif 		if (buffer != NULL) {s# 		    ret = xmlStrcat(ret, buffer);  		    xmlFree(buffer); 		}e
             }{0 	} else if (node->type == XML_ENTITY_REF_NODE) { 	    if (inLine) {) 		ent = xmlGetDocEntity(doc, node->name);t 		if (ent != NULL)) 		    ret = xmlStrcat(ret, ent->content);* 		else { #ifndef XML_USE_BUFFER_CONTENT* 		    ret = xmlStrcat(ret, node->content); #else < 		    ret = xmlStrcat(ret, xmlBufferContent(node->content)); #endif 		}                  } else { 	        xmlChar buf[2]; 		buf[0] = '&'; buf[1] = 0;   		ret = xmlStrncat(ret, buf, 1);# 		ret = xmlStrcat(ret, node->name);- 		buf[0] = ';'; buf[1] = 0;r  		ret = xmlStrncat(ret, buf, 1); 	    } 	} #if 0) 	else {mF 	    fprintf(stderr, "xmlGetNodeListString : invalide node type %d\n", 	            node->type);p 	} #endif 	node = node->next;      }i     return(ret); }    /**   * xmlNewProp:  * @node:  the holding noden$  * @name:  the name of the attribute&  * @value:  the value of the attribute  *+  * Create a new property carried by a node. %  * Returns a pointer to the attribute   */t
 xmlAttrPtrH xmlNewProp(xmlNodePtr node, const xmlChar *name, const xmlChar *value) {     xmlAttrPtr cur;o       if (name == NULL) {t #ifdef DEBUG_TREEx7         fprintf(stderr, "xmlNewProp : name == NULL\n");  #endif 	return(NULL);     }r       /*3      * Allocate a new property and fill the fields.C      */u2     cur = (xmlAttrPtr) xmlMalloc(sizeof(xmlAttr));     if (cur == NULL) {8         fprintf(stderr, "xmlNewProp : malloc failed\n"); 	return(NULL);     }C$     memset(cur, 0, sizeof(xmlAttr));#     cur->type = XML_ATTRIBUTE_NODE;(       cur->parent = node;       cur->name = xmlStrdup(name);     if (value != NULL) { 	xmlChar *buffer;o 	xmlNodePtr tmp;  7 	buffer = xmlEncodeEntitiesReentrant(node->doc, value);,9 	cur->children = xmlStringGetNodeList(node->doc, buffer);r 	tmp = cur->children;  	while (tmp != NULL) {$ 	    tmp->parent = (xmlNodePtr) cur; 	    if (tmp->next == NULL)M 		cur->last = tmp; 	    tmp = tmp->next;) 	} 	xmlFree(buffer);e     }	       /*6      * Add it at the end to preserve parsing order ...      */i     if (node != NULL) {t  	if (node->properties == NULL) { 	    node->properties = cur;	 	} else {)( 	    xmlAttrPtr prev = node->properties;  2 	    while (prev->next != NULL) prev = prev->next; 	    prev->next = cur; 	    cur->prev = prev; 	}     }o     return(cur); }S   /**   * xmlNewNsProp:  * @node:  the holding node   * @ns:  the namespace$  * @name:  the name of the attribute&  * @value:  the value of the attribute  *G  * Create a new property tagged with a namespace and carried by a node. %  * Returns a pointer to the attributet  */)
 xmlAttrPtr? xmlNewNsProp(xmlNodePtr node, xmlNsPtr ns, const xmlChar *name,o"            const xmlChar *value) {     xmlAttrPtr cur;=       if (name == NULL) {r #ifdef DEBUG_TREE 7         fprintf(stderr, "xmlNewProp : name == NULL\n");> #endif 	return(NULL);     }l       /*3      * Allocate a new property and fill the fields.e      */ 2     cur = (xmlAttrPtr) xmlMalloc(sizeof(xmlAttr));     if (cur == NULL) {8         fprintf(stderr, "xmlNewProp : malloc failed\n"); 	return(NULL);     }t$     memset(cur, 0, sizeof(xmlAttr));#     cur->type = XML_ATTRIBUTE_NODE;m       cur->parent = node;      if (node != NULL)o 	cur->doc = node->doc;       cur->ns = ns;       cur->name = xmlStrdup(name);     if (value != NULL) { 	xmlChar *buffer;  	xmlNodePtr tmp;  7 	buffer = xmlEncodeEntitiesReentrant(node->doc, value);a9 	cur->children = xmlStringGetNodeList(node->doc, buffer);r 	tmp = cur->children;  	while (tmp != NULL) {$ 	    tmp->parent = (xmlNodePtr) cur; 	    if (tmp->next == NULL)o 		cur->last = tmp; 	    tmp = tmp->next;  	} 	xmlFree(buffer);      }D       /*6      * Add it at the end to preserve parsing order ...      */(     if (node != NULL) {   	if (node->properties == NULL) { 	    node->properties = cur;	 	} else { ( 	    xmlAttrPtr prev = node->properties;  2 	    while (prev->next != NULL) prev = prev->next; 	    prev->next = cur; 	    cur->prev = prev; 	}     }=     return(cur); }b   /**u  * xmlNewDocProp:d  * @doc:  the document$  * @name:  the name of the attribute&  * @value:  the value of the attribute  */  * Create a new property carried by a document.e%  * Returns a pointer to the attribute_  */D
 xmlAttrPtrI xmlNewDocProp(xmlDocPtr doc, const xmlChar *name, const xmlChar *value) {x     xmlAttrPtr cur;i       if (name == NULL) {  #ifdef DEBUG_TREEr7         fprintf(stderr, "xmlNewProp : name == NULL\n");- #endif 	return(NULL);     }x       /*3      * Allocate a new property and fill the fields.*      */l2     cur = (xmlAttrPtr) xmlMalloc(sizeof(xmlAttr));     if (cur == NULL) {8         fprintf(stderr, "xmlNewProp : malloc failed\n"); 	return(NULL);     }G$     memset(cur, 0, sizeof(xmlAttr));#     cur->type = XML_ATTRIBUTE_NODE;t        cur->name = xmlStrdup(name);     cur->doc = doc;      if (value != NULL)2 	cur->children = xmlStringGetNodeList(doc, value);     return(cur); }    /**.  * xmlFreePropList: (  * @cur:  the first property in the list  *H  * Free a property and all its siblings, all the children are freed too.  */  void! xmlFreePropList(xmlAttrPtr cur) {u     xmlAttrPtr next;     if (cur == NULL) { #ifdef DEBUG_TREEe@         fprintf(stderr, "xmlFreePropList : property == NULL\n"); #endif 	return;     }h     while (cur != NULL) {          next = cur->next;u         xmlFreeProp(cur);  	cur = next;     }b }(   /**t  * xmlFreeProp:>  * @cur:  an attribute  *3  * Free one attribute, all the content is freed toox  */m void xmlFreeProp(xmlAttrPtr cur) {(     if (cur == NULL) { #ifdef DEBUG_TREEt<         fprintf(stderr, "xmlFreeProp : property == NULL\n"); #endif 	return;     } A     /* Check for ID removal -> leading to invalid references ! */ !     if ((cur->parent != NULL) && ;6         (xmlIsID(cur->parent->doc, cur->parent, cur)))+         xmlRemoveID(cur->parent->doc, cur);X7     if (cur->name != NULL) xmlFree((char *) cur->name); >     if (cur->children != NULL) xmlFreeNodeList(cur->children);%     memset(cur, -1, sizeof(xmlAttr));T     xmlFree(cur);t }t   /**x  * xmlRemoveProp:=  * @cur:  an attribute  *>  * Unlink and free one attribute, all the content is freed too=  * Note this doesn't work for namespace definition attributese  *0  * Returns 0 if success and -1 in case of error.  */r intl xmlRemoveProp(xmlAttrPtr cur) {t     xmlAttrPtr tmp;      if (cur == NULL) { #ifdef DEBUG_TREE-9         fprintf(stderr, "xmlRemoveProp : cur == NULL\n");v #endif 	return(-1);     }n     if (cur->parent == NULL) { #ifdef DEBUG_TREEiA         fprintf(stderr, "xmlRemoveProp : cur->parent == NULL\n");r #endif 	return(-1);     }t"     tmp = cur->parent->properties;     if (tmp == cur) {s,         cur->parent->properties = cur->next; 	xmlFreeProp(cur); 	return(0);      }      while (tmp != NULL) {E 	if (tmp->next == cur) { 	    tmp->next = cur->next;U 	    if (tmp->next != NULL)  		tmp->next->prev = tmp; 	    xmlFreeProp(cur); 	    return(0);  	}         tmp = tmp->next;     }( #ifdef DEBUG_TREE I     fprintf(stderr, "xmlRemoveProp : attribute not owned by its node\n");( #endif     return(-1);l }e   /**t  * xmlNewPI:*  * @name:  the processing instruction name  * @content:  the PI content  *0  * Creation of a processing instruction element.,  * Returns a pointer to the new node object.  */s
 xmlNodePtr7 xmlNewPI(const xmlChar *name, const xmlChar *content) {)     xmlNodePtr cur;        if (name == NULL) {m #ifdef DEBUG_TREEr5         fprintf(stderr, "xmlNewPI : name == NULL\n");> #endif 	return(NULL);     }e       /*/      * Allocate a new node and fill the fields.e      */i2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {6         fprintf(stderr, "xmlNewPI : malloc failed\n"); 	return(NULL);     }e$     memset(cur, 0, sizeof(xmlNode));     cur->type = XML_PI_NODE;        cur->name = xmlStrdup(name);     if (content != NULL) { #ifndef XML_USE_BUFFER_CONTENT# 	cur->content = xmlStrdup(content);u #elsel' 	cur->content = xmlBufferCreateSize(0); + 	xmlBufferSetAllocationScheme(cur->content,l7 		                     xmlGetBufferAllocationScheme());q) 	xmlBufferAdd(cur->content, content, -1);  #endif     }(     return(cur); };   /**h  * xmlNewNode:  * @ns:  namespace if any   * @name:  the node name  *;  * Creation of a new node element. @ns is optionnal (NULL).u  *,  * Returns a pointer to the new node object.  */T
 xmlNodePtr. xmlNewNode(xmlNsPtr ns, const xmlChar *name) {     xmlNodePtr cur;o       if (name == NULL) {q #ifdef DEBUG_TREE 7         fprintf(stderr, "xmlNewNode : name == NULL\n");  #endif 	return(NULL);     }l       /*/      * Allocate a new node and fill the fields.s      */ 2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {8         fprintf(stderr, "xmlNewNode : malloc failed\n"); 	return(NULL);     } $     memset(cur, 0, sizeof(xmlNode));!     cur->type = XML_ELEMENT_NODE;            cur->name = xmlStrdup(name);     cur->ns = ns;i     return(cur); }e   /**d  * xmlNewDocNode:;  * @doc:  the document  * @ns:  namespace if any   * @name:  the node name)  * @content:  the XML text content if anye  *E  * Creation of a new node element within a document. @ns and @contentv  * are optionnal (NULL).N  * NOTE: @content is supposed to be a piece of XML CDATA, so it allow entitiesL  *       references, but XML special chars need to be escaped first by usingJ  *       xmlEncodeEntitiesReentrant(). Use xmlNewDocRawNode() if you don't  *       need entities support.   *,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr) xmlNewDocNode(xmlDocPtr doc, xmlNsPtr ns,U<               const xmlChar *name, const xmlChar *content) {     xmlNodePtr cur;        cur = xmlNewNode(ns, name);      if (cur != NULL) {         cur->doc = doc;n 	if (content != NULL) {s8 	    cur->children = xmlStringGetNodeList(doc, content); 	    UPDATE_LAST_CHILD(cur)e 	}     }c     return(cur); }f     /**q  * xmlNewDocRawNode:  * @doc:  the document  * @ns:  namespace if any   * @name:  the node name%  * @content:  the text content if anyt  *E  * Creation of a new node element within a document. @ns and @contentr  * are optionnal (NULL).  *,  * Returns a pointer to the new node object.  */t
 xmlNodePtr, xmlNewDocRawNode(xmlDocPtr doc, xmlNsPtr ns,?                  const xmlChar *name, const xmlChar *content) {x     xmlNodePtr cur;g       cur = xmlNewNode(ns, name);t     if (cur != NULL) {         cur->doc = doc;P 	if (content != NULL) { 1 	    cur->children = xmlNewDocText(doc, content);a 	    UPDATE_LAST_CHILD(cur)d 	}     }s     return(cur); }t   /**h  * xmlNewDocFragment:m*  * @doc:  the document owning the fragment  *#  * Creation of a new Fragment node.r,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr" xmlNewDocFragment(xmlDocPtr doc) {     xmlNodePtr cur;        /*@      * Allocate a new DocumentFragment node and fill the fields.      */ 2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {?         fprintf(stderr, "xmlNewDocFragment : malloc failed\n");  	return(NULL);     } $     memset(cur, 0, sizeof(xmlNode));'     cur->type = XML_DOCUMENT_FRAG_NODE;{       cur->doc = doc;c     return(cur); }    /**	  * xmlNewText:  * @content:  the text content  *  * Creation of a new text node. ,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr$ xmlNewText(const xmlChar *content) {     xmlNodePtr cur;e       /*/      * Allocate a new node and fill the fields.X      */i2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {8         fprintf(stderr, "xmlNewText : malloc failed\n"); 	return(NULL);     } $     memset(cur, 0, sizeof(xmlNode));     cur->type = XML_TEXT_NODE;  )     cur->name = xmlStrdup(xmlStringText);n     if (content != NULL) { #ifndef XML_USE_BUFFER_CONTENT# 	cur->content = xmlStrdup(content);o #else;' 	cur->content = xmlBufferCreateSize(0);p+ 	xmlBufferSetAllocationScheme(cur->content, 7 		                     xmlGetBufferAllocationScheme());c) 	xmlBufferAdd(cur->content, content, -1);	 #endif     }      return(cur); }n   /**   * xmlNewTextChild:   * @parent:  the parent node  * @ns:  a namespace if any_   * @name:  the name of the child3  * @content:  the text content of the child if any.   *N  * Creation of a new child element, added at the end of @parent children list.L  * @ns and @content parameters are optionnal (NULL). If content is non NULL,C  * a child TEXT node will be created containing the string content.a  *,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr/ xmlNewTextChild(xmlNodePtr parent, xmlNsPtr ns,d:             const xmlChar *name, const xmlChar *content) {     xmlNodePtr cur, prev;        if (parent == NULL) {( #ifdef DEBUG_TREE >         fprintf(stderr, "xmlNewTextChild : parent == NULL\n"); #endif 	return(NULL);     }        if (name == NULL) {	 #ifdef DEBUG_TREE <         fprintf(stderr, "xmlNewTextChild : name == NULL\n"); #endif 	return(NULL);     }        /*      * Allocate a new node      */S     if (ns == NULL) @ 	cur = xmlNewDocRawNode(parent->doc, parent->ns, name, content);     else8 	cur = xmlNewDocRawNode(parent->doc, ns, name, content);"     if (cur == NULL) return(NULL);       /*;      * add the new element at the end of the children list.r      */t!     cur->type = XML_ELEMENT_NODE;.     cur->parent = parent;L     cur->doc = parent->doc;m#     if (parent->children == NULL) {N         parent->children = cur;  	parent->last = cur;     } else {         prev = parent->last; 	prev->next = cur; 	cur->prev = prev; 	parent->last = cur;     }X       return(cur); }(   /**y  * xmlNewCharRef:T  * @doc: the documenti=  * @name:  the char ref string, starting with # or "&# ... ;",  *.  * Creation of a new character reference node.,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr3 xmlNewCharRef(xmlDocPtr doc, const xmlChar *name) {      xmlNodePtr cur;n       /*/      * Allocate a new node and fill the fields.l      */i2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {8         fprintf(stderr, "xmlNewText : malloc failed\n"); 	return(NULL);     };$     memset(cur, 0, sizeof(xmlNode));$     cur->type = XML_ENTITY_REF_NODE;       cur->doc = doc;      if (name[0] == '&') {-         int len;         name++;  	len = xmlStrlen(name);> 	if (name[len - 1] == ';')+ 	    cur->name = xmlStrndup(name, len - 1);a 	elsen' 	    cur->name = xmlStrndup(name, len);r
     } else 	cur->name = xmlStrdup(name);      return(cur); }    /**   * xmlNewReference:l  * @doc: the document=C  * @name:  the reference name, or the reference string with & and ;a  *$  * Creation of a new reference node.,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr5 xmlNewReference(xmlDocPtr doc, const xmlChar *name) {i     xmlNodePtr cur;n     xmlEntityPtr ent;t       /*/      * Allocate a new node and fill the fields.n      */m2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {8         fprintf(stderr, "xmlNewText : malloc failed\n"); 	return(NULL);     } $     memset(cur, 0, sizeof(xmlNode));$     cur->type = XML_ENTITY_REF_NODE;       cur->doc = doc;s     if (name[0] == '&') {t         int len;         name++;u 	len = xmlStrlen(name);r 	if (name[len - 1] == ';')+ 	    cur->name = xmlStrndup(name, len - 1);e 	elser' 	    cur->name = xmlStrndup(name, len);L
     } else 	cur->name = xmlStrdup(name);i  *     ent = xmlGetDocEntity(doc, cur->name);     if (ent != NULL) { #ifndef XML_USE_BUFFER_CONTENT 	cur->content = ent->content;L #else  	/*hB 	 * CJN 11.18.99 this might be a problem, since the xmlBuffer gets> 	 * a copy of this pointer.  Let's hope we don't manipulate it
 	 * later  	 */' 	cur->content = xmlBufferCreateSize(0);l+ 	xmlBufferSetAllocationScheme(cur->content,}7 		                     xmlGetBufferAllocationScheme());U 	if (ent->content != NULL)2 	    xmlBufferAdd(cur->content, ent->content, -1); #endif" 	cur->children = (xmlNodePtr) ent;     }u     return(cur); }t   /**   * xmlNewDocText:r  * @doc: the document   * @content:  the text content  *1  * Creation of a new text node within a document.o,  * Returns a pointer to the new node object.  */)
 xmlNodePtr6 xmlNewDocText(xmlDocPtr doc, const xmlChar *content) {     xmlNodePtr cur;(       cur = xmlNewText(content);$     if (cur != NULL) cur->doc = doc;     return(cur); }d   /**e  * xmlNewTextLen:   * @content:  the text content  * @len:  the text len.e  *O  * Creation of a new text node with an extra parameter for the content's lenght],  * Returns a pointer to the new node object.  */m
 xmlNodePtr0 xmlNewTextLen(const xmlChar *content, int len) {     xmlNodePtr cur;u       /*/      * Allocate a new node and fill the fields."      */e2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {8         fprintf(stderr, "xmlNewText : malloc failed\n"); 	return(NULL);     }*$     memset(cur, 0, sizeof(xmlNode));     cur->type = XML_TEXT_NODE;  )     cur->name = xmlStrdup(xmlStringText);e     if (content != NULL) { #ifndef XML_USE_BUFFER_CONTENT) 	cur->content = xmlStrndup(content, len);w #elsel) 	cur->content = xmlBufferCreateSize(len);l+ 	xmlBufferSetAllocationScheme(cur->content,f7 		                     xmlGetBufferAllocationScheme());t* 	xmlBufferAdd(cur->content, content, len); #endif     }L     return(cur); }    /**A  * xmlNewDocTextLen:  * @doc: the document   * @content:  the text content  * @len:  the text len.)  *J  * Creation of a new text node with an extra content lenght parameter. The)  * text node pertain to a given document.r,  * Returns a pointer to the new node object.  */T
 xmlNodePtrB xmlNewDocTextLen(xmlDocPtr doc, const xmlChar *content, int len) {     xmlNodePtr cur;l  &     cur = xmlNewTextLen(content, len);$     if (cur != NULL) cur->doc = doc;     return(cur); }h   /**=  * xmlNewComment:s!  * @content:  the comment content>  */  * Creation of a new node containing a comment.=,  * Returns a pointer to the new node object.  */	
 xmlNodePtr' xmlNewComment(const xmlChar *content) {e     xmlNodePtr cur;        /*/      * Allocate a new node and fill the fields..      */*2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {;         fprintf(stderr, "xmlNewComment : malloc failed\n");o 	return(NULL);     }($     memset(cur, 0, sizeof(xmlNode));!     cur->type = XML_COMMENT_NODE;>  ,     cur->name = xmlStrdup(xmlStringComment);     if (content != NULL) { #ifndef XML_USE_BUFFER_CONTENT# 	cur->content = xmlStrdup(content);m #elsee' 	cur->content = xmlBufferCreateSize(0);a+ 	xmlBufferSetAllocationScheme(cur->content, 7 		                     xmlGetBufferAllocationScheme());i) 	xmlBufferAdd(cur->content, content, -1);m #endif     }o     return(cur); }n   /**t  * xmlNewCDataBlock:  * @doc:  the document-  * @content:  the CData block content content !  * @len:  the length of the block   *3  * Creation of a new node containing a CData block.f,  * Returns a pointer to the new node object.  */ 
 xmlNodePtrB xmlNewCDataBlock(xmlDocPtr doc, const xmlChar *content, int len) {     xmlNodePtr cur;        /*/      * Allocate a new node and fill the fields.       */i2     cur = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (cur == NULL) {>         fprintf(stderr, "xmlNewCDataBlock : malloc failed\n"); 	return(NULL);     }c$     memset(cur, 0, sizeof(xmlNode));'     cur->type = XML_CDATA_SECTION_NODE;        if (content != NULL) { #ifndef XML_USE_BUFFER_CONTENT) 	cur->content = xmlStrndup(content, len);- #elsea) 	cur->content = xmlBufferCreateSize(len);s+ 	xmlBufferSetAllocationScheme(cur->content, 7 		                     xmlGetBufferAllocationScheme()); * 	xmlBufferAdd(cur->content, content, len); #endif     }      return(cur); }}   /**r  * xmlNewDocComment:  * @doc:  the document!  * @content:  the comment contentr  *@  * Creation of a new node containing a commentwithin a document.,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr9 xmlNewDocComment(xmlDocPtr doc, const xmlChar *content) {      xmlNodePtr cur;   !     cur = xmlNewComment(content);=$     if (cur != NULL) cur->doc = doc;     return(cur); }D     /**   * xmlNewChild:u  * @parent:  the parent node  * @ns:  a namespace if any    * @name:  the name of the child2  * @content:  the XML content of the child if any.  *N  * Creation of a new child element, added at the end of @parent children list.L  * @ns and @content parameters are optionnal (NULL). If content is non NULL,J  * a child list containing the TEXTs and ENTITY_REFs node will be created.N  * NOTE: @content is supposed to be a piece of XML CDATA, so it allow entitiesL  *       references, but XML special chars need to be escaped first by usingH  *       xmlEncodeEntitiesReentrant(). Use xmlNewTextChild() if entities  *       support is not needed.U  *,  * Returns a pointer to the new node object.  */ 
 xmlNodePtr+ xmlNewChild(xmlNodePtr parent, xmlNsPtr ns,r:             const xmlChar *name, const xmlChar *content) {     xmlNodePtr cur, prev;N       if (parent == NULL) {u #ifdef DEBUG_TREE.:         fprintf(stderr, "xmlNewChild : parent == NULL\n"); #endif 	return(NULL);     }d       if (name == NULL) {c #ifdef DEBUG_TREEo8         fprintf(stderr, "xmlNewChild : name == NULL\n"); #endif 	return(NULL);     }N       /*      * Allocate a new node      */e     if (ns == NULL):= 	cur = xmlNewDocNode(parent->doc, parent->ns, name, content);r     else5 	cur = xmlNewDocNode(parent->doc, ns, name, content);)"     if (cur == NULL) return(NULL);       /*;      * add the new element at the end of the children list.a      */n!     cur->type = XML_ELEMENT_NODE;F     cur->parent = parent;      cur->doc = parent->doc;f#     if (parent->children == NULL) {          parent->children = cur;" 	parent->last = cur;     } else {         prev = parent->last; 	prev->next = cur; 	cur->prev = prev; 	parent->last = cur;     }        return(cur); }e   /**,  * xmlAddNextSibling:   * @cur:  the child node  * @elem:  the new node(  *7  * Add a new element @elem as the next siblings of @cur->  * If the new element was already inserted in a document it is,  * first unlinked from its existing context.  *4  * Returns the new element or NULL in case of error.  */*
 xmlNodePtr4 xmlAddNextSibling(xmlNodePtr cur, xmlNodePtr elem) {     if (cur == NULL) { #ifdef DEBUG_TREEi=         fprintf(stderr, "xmlAddNextSibling : cur == NULL\n");r #endif 	return(NULL);     }(     if (elem == NULL) {m #ifdef DEBUG_TREE >         fprintf(stderr, "xmlAddNextSibling : elem == NULL\n"); #endif 	return(NULL);     })       xmlUnlinkNode(elem);     elem->doc = cur->doc;=     elem->parent = cur->parent;      elem->prev = cur;l     elem->next = cur->next;U     cur->next = elem;r     if (elem->next != NULL)- 	elem->next->prev = elem;f>     if ((elem->parent != NULL) && (elem->parent->last == cur)) 	elem->parent->last = elem;)     return(elem);l }t   /**U  * xmlAddPrevSibling:=  * @cur:  the child node  * @elem:  the new nodep  *;  * Add a new element @elem as the previous siblings of @cur;>  * If the new element was already inserted in a document it is,  * first unlinked from its existing context.  *4  * Returns the new element or NULL in case of error.  */-
 xmlNodePtr4 xmlAddPrevSibling(xmlNodePtr cur, xmlNodePtr elem) {     if (cur == NULL) { #ifdef DEBUG_TREE =         fprintf(stderr, "xmlAddPrevSibling : cur == NULL\n");p #endif 	return(NULL);     }      if (elem == NULL) {I #ifdef DEBUG_TREEe>         fprintf(stderr, "xmlAddPrevSibling : elem == NULL\n"); #endif 	return(NULL);     }E       xmlUnlinkNode(elem);     elem->doc = cur->doc;)     elem->parent = cur->parent;e     elem->next = cur;c     elem->prev = cur->prev;i     cur->prev = elem;u     if (elem->prev != NULL)z 	elem->prev->next = elem; B     if ((elem->parent != NULL) && (elem->parent->children == cur)) 	elem->parent->children = elem;t     return(elem);N })   /**   * xmlAddSibling:N  * @cur:  the child node  * @elem:  the new nodeo  *:  * Add a new element @elem to the list of siblings of @cur>  * If the new element was already inserted in a document it is,  * first unlinked from its existing context.  *4  * Returns the new element or NULL in case of error.  */)
 xmlNodePtr0 xmlAddSibling(xmlNodePtr cur, xmlNodePtr elem) {     xmlNodePtr parent;       if (cur == NULL) { #ifdef DEBUG_TREE 9         fprintf(stderr, "xmlAddSibling : cur == NULL\n");d #endif 	return(NULL);     }L       if (elem == NULL) {t #ifdef DEBUG_TREEo:         fprintf(stderr, "xmlAddSibling : elem == NULL\n"); #endif 	return(NULL);     }r       /*A      * Constant time is we can rely on the ->parent->last to findx      * the last sibling.      */d!     if ((cur->parent != NULL) && *# 	(cur->parent->children != NULL) &&  	(cur->parent->last != NULL) && % 	(cur->parent->last->next == NULL)) {; 	cur = cur->parent->last;      } else {+ 	while (cur->next != NULL) cur = cur->next;t     }L       xmlUnlinkNode(elem);     if (elem->doc == NULL)D 	elem->doc = cur->doc; /* the parent may not be linked to a doc ! */       parent = cur->parent;n     elem->prev = cur;x     elem->next = NULL;     elem->parent = parent;     cur->next = elem;e     if (parent != NULL)t 	parent->last = elem;e       return(elem);e }o   /**n  * xmlAddChildList:n  * @parent:  the parent node$  * @cur:  the first node in the list  *@  * Add a list of node at the end of the child list of the parent  *3  * Returns the last child or NULL in case of error.a  */i
 xmlNodePtr4 xmlAddChildList(xmlNodePtr parent, xmlNodePtr cur) {     xmlNodePtr prev;       if (parent == NULL) {o #ifdef DEBUG_TREEs:         fprintf(stderr, "xmlAddChild : parent == NULL\n"); #endif 	return(NULL);     }        if (cur == NULL) { #ifdef DEBUG_TREEt9         fprintf(stderr, "xmlAddChild : child == NULL\n");N #endif 	return(NULL);     }   6     if ((cur->doc != NULL) && (parent->doc != NULL) &&$         (cur->doc != parent->doc)) { #ifdef DEBUG_TREEe= 	fprintf(stderr, "Elements moved to a different document\n");; #endif     }        /*=      * add the first element at the end of the children list.       */ #     if (parent->children == NULL) {t         parent->children = cur;      } else {         prev = parent->last; 	prev->next = cur; 	cur->prev = prev;     }*     while (cur->next != NULL) {e 	cur->parent = parent;F 	cur->doc = parent->doc; /* the parent may not be linked to a doc ! */         cur = cur->next;     }n     cur->parent = parent;rI     cur->doc = parent->doc; /* the parent may not be linked to a doc ! */-     parent->last = cur;t       return(cur); }>   /**n  * xmlAddChild:d  * @parent:  the parent node  * @cur:  the child node  *E  * Add a new child element, to @parent, at the end of the child list.e.  * Returns the child or NULL in case of error.  */m
 xmlNodePtr0 xmlAddChild(xmlNodePtr parent, xmlNodePtr cur) {     xmlNodePtr prev;       if (parent == NULL) {  #ifdef DEBUG_TREE :         fprintf(stderr, "xmlAddChild : parent == NULL\n"); #endif 	return(NULL);     }u       if (cur == NULL) { #ifdef DEBUG_TREE 9         fprintf(stderr, "xmlAddChild : child == NULL\n");r #endif 	return(NULL);     }r  6     if ((cur->doc != NULL) && (parent->doc != NULL) &&$         (cur->doc != parent->doc)) { #ifdef DEBUG_TREEc= 	fprintf(stderr, "Elements moved to a different document\n");t #endif     }c       /*;      * add the new element at the end of the children list.h      */e     cur->parent = parent; I     cur->doc = parent->doc; /* the parent may not be linked to a doc ! */*       /*J      * Handle the case where parent->content != NULL, in that case it will'      * create a intermediate TEXT node.{      */ R     if (((parent->type == XML_ELEMENT_NODE) || (parent->type == XML_TEXT_NODE)) && 	(parent->content != NULL)) {          xmlNodePtr text; 	  #ifndef XML_USE_BUFFER_CONTENT4 	text = xmlNewDocText(parent->doc, parent->content); #elseRF 	text = xmlNewDocText(parent->doc, xmlBufferContent(parent->content)); #endif 	if (text != NULL) {# 	    text->next = parent->children;t 	    if (text->next != NULL) 		text->next->prev = text; 	    parent->children = text;  	    UPDATE_LAST_CHILD(parent) #ifndef XML_USE_BUFFER_CONTENT 	    xmlFree(parent->content); #elser$ 	    xmlBufferFree(parent->content); #endif 	    parent->content = NULL; 	}     } #     if (parent->children == NULL) {          parent->children = cur;e 	parent->last = cur;     } else {         prev = parent->last; 	prev->next = cur; 	cur->prev = prev; 	parent->last = cur;     }c       return(cur); }c   /**c  * xmlGetLastChild:c  * @parent:  the parent node  *#  * Search the last child of a node.d*  * Returns the last child or NULL if none.  */ 
 xmlNodePtr$ xmlGetLastChild(xmlNodePtr parent) {     if (parent == NULL) {P #ifdef DEBUG_TREE >         fprintf(stderr, "xmlGetLastChild : parent == NULL\n"); #endif 	return(NULL);     }      return(parent->last);r }U   /**   * xmlFreeNodeList:=$  * @cur:  the first node in the list  *G  * Free a node and all its siblings, this is a recursive behaviour, all;  * the children are freed too.  */  void! xmlFreeNodeList(xmlNodePtr cur) {      xmlNodePtr next;     if (cur == NULL) { #ifdef DEBUG_TREE <         fprintf(stderr, "xmlFreeNodeList : node == NULL\n"); #endif 	return;     })     while (cur != NULL) {          next = cur->next;          xmlFreeNode(cur);t 	cur = next;     }- }p   /**_  * xmlFreeNode:   * @cur:  the node  *N  * Free a node, this is a recursive behaviour, all the children are freed too.J  * This doesn't unlink the child from the list, use xmlUnlinkNode() first.  */- void xmlFreeNode(xmlNodePtr cur) {v     if (cur == NULL) { #ifdef DEBUG_TREE 8         fprintf(stderr, "xmlFreeNode : node == NULL\n"); #endif 	return;     }t"     if (cur->type == XML_DTD_NODE) 	return;     cur->doc = NULL;     cur->parent = NULL;n     cur->next = NULL;p     cur->prev = NULL;o"     if ((cur->children != NULL) &&$ 	(cur->type != XML_ENTITY_REF_NODE))  	xmlFreeNodeList(cur->children);B     if (cur->properties != NULL) xmlFreePropList(cur->properties);)     if (cur->type != XML_ENTITY_REF_NODE)) #ifndef XML_USE_BUFFER_CONTENT1 	if (cur->content != NULL) xmlFree(cur->content);; #elser;     	if (cur->content != NULL) xmlBufferFree(cur->content);u #endif7     if (cur->name != NULL) xmlFree((char *) cur->name);a6     if (cur->nsDef != NULL) xmlFreeNsList(cur->nsDef);%     memset(cur, -1, sizeof(xmlNode));      xmlFree(cur);r }a   /**l  * xmlUnlinkNode:   * @cur:  the node  *A  * Unlink a node from it's current context, the node is not freedn  */  void xmlUnlinkNode(xmlNodePtr cur) {e     if (cur == NULL) { #ifdef DEBUG_TREEa:         fprintf(stderr, "xmlUnlinkNode : node == NULL\n"); #endif 	return;     }n@     if ((cur->parent != NULL) && (cur->parent->children == cur))*         cur->parent->children = cur->next;<     if ((cur->parent != NULL) && (cur->parent->last == cur))&         cur->parent->last = cur->prev;     if (cur->next != NULL)$         cur->next->prev = cur->prev;     if (cur->prev != NULL)$         cur->prev->next = cur->next;!     cur->next = cur->prev = NULL;i     cur->parent = NULL;  }    /**   * xmlReplaceNode:  * @old:  the old node  * @cur:  the node  *C  * Unlink the old node from it's current context, prune the new oneeE  * at the same place. If cur was already inserted in a document it is;,  * first unlinked from its existing context.  *  * Returns the old nodex  */n
 xmlNodePtr0 xmlReplaceNode(xmlNodePtr old, xmlNodePtr cur) {     if (old == NULL) { #ifdef DEBUG_TREE;:         fprintf(stderr, "xmlReplaceNode : old == NULL\n"); #endif 	return(NULL);     }e     if (cur == NULL) { 	xmlUnlinkNode(old);
 	return(old);h     }f     xmlUnlinkNode(cur);h     cur->doc = old->doc;     cur->parent = old->parent;     cur->next = old->next;     if (cur->next != NULL) 	cur->next->prev = cur;u     cur->prev = old->prev;     if (cur->prev != NULL) 	cur->prev->next = cur;>     if (cur->parent != NULL) {" 	if (cur->parent->children == old)! 	    cur->parent->children = cur;P 	if (cur->parent->last == old) 	    cur->parent->last = cur;t     }@!     old->next = old->prev = NULL;h     old->parent = NULL;e     return(old); }o  I /************************************************************************m  *									*  *		Copy operations						*  *									*J  ************************************************************************/  = /**)  * xmlCopyNamespace:  * @cur:  the namespace   *  * Do a copy of the namespace.  *5  * Returns: a new xmlNsPtr, or NULL in case of error.f  */w xmlNsPtr  xmlCopyNamespace(xmlNsPtr cur) {     xmlNsPtr ret;*  "     if (cur == NULL) return(NULL);     switch (cur->type) {"         case XML_GLOBAL_NAMESPACE:8 	    ret = xmlNewGlobalNs(NULL, cur->href, cur->prefix); 	    break;a 	case XML_LOCAL_NAMESPACE:2 	    ret = xmlNewNs(NULL, cur->href, cur->prefix); 	    break;u	 	default:{ #ifdef DEBUG_TREEtG 	    fprintf(stderr, "xmlCopyNamespace: unknown type %d\n", cur->type);t #endif 	    return(NULL);     }-     return(ret); };   /**   * xmlCopyNamespaceList:  * @cur:  the first namespace=  *"  * Do a copy of an namespace list.  *5  * Returns: a new xmlNsPtr, or NULL in case of error.>  */n xmlNsPtr$ xmlCopyNamespaceList(xmlNsPtr cur) {     xmlNsPtr ret = NULL;     xmlNsPtr p = NULL,q;       while (cur != NULL) {("         q = xmlCopyNamespace(cur); 	if (p == NULL) {f 	    ret = p = q;n	 	} else {  	    p->next = q;c 	    p = q;@ 	} 	cur = cur->next;@     }:     return(ret); }*   /**   * xmlCopyProp:*<  * @target:  the element where the attribute will be grafted  * @cur:  the attributeo  *  * Do a copy of the attribute.  *7  * Returns: a new xmlAttrPtr, or NULL in case of error.   */w
 xmlAttrPtr0 xmlCopyProp(xmlNodePtr target, xmlAttrPtr cur) {     xmlAttrPtr ret;   "     if (cur == NULL) return(NULL);     if (cur->parent != NULL)8 	ret = xmlNewDocProp(cur->parent->doc, cur->name, NULL);#     else if (cur->children != NULL)>: 	ret = xmlNewDocProp(cur->children->doc, cur->name, NULL);     else, 	ret = xmlNewDocProp(NULL, cur->name, NULL);"     if (ret == NULL) return(NULL);     ret->parent = target;r     0     if ((cur->ns != NULL) && (target != NULL)) {         xmlNsPtr ns;  8 	ns = xmlSearchNs(target->doc, target, cur->ns->prefix); 	ret->ns = ns;
     } else         ret->ns = NULL;m       if (cur->children != NULL)0 	ret->children = xmlCopyNodeList(cur->children);     return(ret); }M   /**E  * xmlCopyPropList: =  * @target:  the element where the attributes will be graftede  * @cur:  the first attribute>  *"  * Do a copy of an attribute list.  *7  * Returns: a new xmlAttrPtr, or NULL in case of error.t  */h
 xmlAttrPtr4 xmlCopyPropList(xmlNodePtr target, xmlAttrPtr cur) {     xmlAttrPtr ret = NULL;     xmlAttrPtr p = NULL,q;       while (cur != NULL) {r%         q = xmlCopyProp(target, cur);* 	if (p == NULL) {t 	    ret = p = q; 	 	} else {  	    p->next = q;* 	    q->prev = p;o 	    p = q;  	} 	cur = cur->next;w     }o     return(ret); }k   /*'  * NOTE abeut the CopyNode operations !.  *=  * They are splitted into external and internal parts for onec;  * tricky reason: namespaces. Doing a direct copy of a nodel>  * say RPM:Copyright without changing the namespace pointer to>  * something else can produce stale links. One way to do it is<  * to keep a reference counter but this doesn't work as soon=  * as one move the element or the subtree out of the scope of ;  * the existing namespace. The actual solution seems to addN;  * a copy of the namespace at the top of the copied tree ifr   * not available in the subtree.@  * Hence two functions, the public front-end call the inner ones  */u   static xmlNodePtr I xmlStaticCopyNodeList(xmlNodePtr node, xmlDocPtr doc, xmlNodePtr parent);t   static xmlNodePtrdD xmlStaticCopyNode(xmlNodePtr node, xmlDocPtr doc, xmlNodePtr parent,"                   int recursive) {     xmlNodePtr ret;   #     if (node == NULL) return(NULL);c     /*/      * Allocate a new node and fill the fields.       */c2     ret = (xmlNodePtr) xmlMalloc(sizeof(xmlNode));     if (ret == NULL) {?         fprintf(stderr, "xmlStaticCopyNode : malloc failed\n");  	return(NULL);     }r$     memset(ret, 0, sizeof(xmlNode));     ret->type = node->type;@       ret->doc = doc;e     ret->parent = parent;      if (node->name != NULL)e# 	ret->name = xmlStrdup(node->name); I     if ((node->content != NULL) && (node->type != XML_ENTITY_REF_NODE)) {e #ifndef XML_USE_BUFFER_CONTENT) 	ret->content = xmlStrdup(node->content);( #elseID 	ret->content = xmlBufferCreateSize(xmlBufferLength(node->content));+ 	xmlBufferSetAllocationScheme(ret->content,n7 		                     xmlGetBufferAllocationScheme());i 	xmlBufferAdd(ret->content,t' 		     xmlBufferContent(node->content),s' 		     xmlBufferLength(node->content));n #endif     }l     if (parent != NULL)s!         xmlAddChild(parent, ret);            if (!recursive) return(ret);     if (node->nsDef != NULL)7         ret->nsDef = xmlCopyNamespaceList(node->nsDef);o       if (node->ns != NULL) {r         xmlNsPtr ns;  . 	ns = xmlSearchNs(doc, ret, node->ns->prefix); 	if (ns == NULL) { 	    /*pB 	     * Humm, we are copying an element whose namespace is definedA 	     * out of the new tree scope. Search it in the original tree - 	     * and add it at the top of the new tree" 	     */9 	    ns = xmlSearchNs(node->doc, node, node->ns->prefix);o 	    if (ns != NULL) { 	        xmlNodePtr root = ret;p  3 		while (root->parent != NULL) root = root->parent;r' 		xmlNewNs(root, ns->href, ns->prefix);o 	    }	 	} else {u 	    /*)D 	     * reference the existing namespace definition in our own tree. 	     */ 	    ret->ns = ns; 	}     } !     if (node->properties != NULL)nA         ret->properties = xmlCopyPropList(ret, node->properties);n     if (node->children != NULL)lH         ret->children = xmlStaticCopyNodeList(node->children, doc, ret);     UPDATE_LAST_CHILD(ret)     return(ret); }r   static xmlNodePtr J xmlStaticCopyNodeList(xmlNodePtr node, xmlDocPtr doc, xmlNodePtr parent) {     xmlNodePtr ret = NULL;     xmlNodePtr p = NULL,q;       while (node != NULL) {4         q = xmlStaticCopyNode(node, doc, parent, 1); 	if (ret == NULL) {  	    q->prev = NULL; 	    ret = p = q;x	 	} else {R 	    p->next = q;e 	    q->prev = p;o 	    p = q;* 	} 	node = node->next;i     }m     return(ret); }P   /**)  * xmlCopyNode:=  * @node:  the nodeG)  * @recursive:  if 1 do a recursive copy.S  *  * Do a copy of the node.d  *7  * Returns: a new xmlNodePtr, or NULL in case of error.D  */T
 xmlNodePtr- xmlCopyNode(xmlNodePtr node, int recursive) {N     xmlNodePtr ret;t  9     ret = xmlStaticCopyNode(node, NULL, NULL, recursive);      return(ret); }m   /**t  * xmlCopyNodeList: &  * @node:  the first node in the list.  *(  * Do a recursive copy of the node list.  *7  * Returns: a new xmlNodePtr, or NULL in case of error.p  */ - xmlNodePtr xmlCopyNodeList(xmlNodePtr node) {-=     xmlNodePtr ret = xmlStaticCopyNodeList(node, NULL, NULL);d     return(ret); }u   /**   * xmlCopyElement:  * @elem:  the element  *'  * Do a copy of the element definition.i  *:  * Returns: a new xmlElementPtr, or NULL in case of error.
 xmlElementPtr*$ xmlCopyElement(xmlElementPtr elem) {     xmlElementPtr ret;  #     if (elem == NULL) return(NULL); K     ret = xmlNewDocElement(elem->doc, elem->ns, elem->name, elem->content);f"     if (ret == NULL) return(NULL);      if (!recursive) return(ret);!     if (elem->properties != NULL)d<         ret->properties = xmlCopyPropList(elem->properties);          if (elem->nsDef != NULL)7         ret->nsDef = xmlCopyNamespaceList(elem->nsDef);U     if (elem->children != NULL)(;         ret->children = xmlCopyElementList(elem->children);a     return(ret); }t  */r   /**   * xmlCopyDtd:  * @dtd:  the dtdp  *  * Do a copy of the dtd.  *6  * Returns: a new xmlDtdPtr, or NULL in case of error.  */=	 xmlDtdPtre xmlCopyDtd(xmlDtdPtr dtd) {)     xmlDtdPtr ret;  "     if (dtd == NULL) return(NULL);E     ret = xmlNewDtd(NULL, dtd->name, dtd->ExternalID, dtd->SystemID);n"     if (ret == NULL) return(NULL);     if (dtd->entities != NULL)6         ret->entities = (void *) xmlCopyEntitiesTable(: 	                    (xmlEntitiesTablePtr) dtd->entities);     if (dtd->notations != NULL) 7         ret->notations = (void *) xmlCopyNotationTable(m; 	                    (xmlNotationTablePtr) dtd->notations);      if (dtd->elements != NULL)5         ret->elements = (void *) xmlCopyElementTable(=9 	                    (xmlElementTablePtr) dtd->elements);m      if (dtd->attributes != NULL)9         ret->attributes = (void *) xmlCopyAttributeTable( = 	                    (xmlAttributeTablePtr) dtd->attributes);i     return(ret); }-   /**-  * xmlCopyDoc:  * @doc:  the document)  * @recursive:  if 1 do a recursive copy.&  *F  * Do a copy of the document info. If recursive, the content tree will9  * be copied too as well as Dtd, namespaces and entities.>  *6  * Returns: a new xmlDocPtr, or NULL in case of error.  */t	 xmlDocPtr * xmlCopyDoc(xmlDocPtr doc, int recursive) {     xmlDocPtr ret;  "     if (doc == NULL) return(NULL);"     ret = xmlNewDoc(doc->version);"     if (ret == NULL) return(NULL);     if (doc->name != NULL),         ret->name = xmlMemStrdup(doc->name);     if (doc->encoding != NULL)1         ret->encoding = xmlStrdup(doc->encoding); (     ret->compression = doc->compression;&     ret->standalone = doc->standalone;      if (!recursive) return(ret);       if (doc->intSubset != NULL)o4         ret->intSubset = xmlCopyDtd(doc->intSubset);     if (doc->oldNs != NULL)d6         ret->oldNs = xmlCopyNamespaceList(doc->oldNs);     if (doc->children != NULL)A         ret->children = xmlStaticCopyNodeList(doc->children, ret, 1 		                              (xmlNodePtr)ret);(     return(ret); }   I /************************************************************************:  *									*!  *		Content access functions				*   *									*J  ************************************************************************/  c /**   * xmlDocGetRootElement:  * @doc:  the document  *@  * Get the root element of the document (doc->children is a list/  * containing possibly comments, PIs, etc ...).t  *.  * Returns the xmlNodePtr for the root or NULL  */ 
 xmlNodePtr% xmlDocGetRootElement(xmlDocPtr doc) {r     xmlNodePtr ret;p  "     if (doc == NULL) return(NULL);     ret = doc->children;     while (ret != NULL) {t# 	if (ret->type == XML_ELEMENT_NODE)/ 	    return(ret);t         ret = ret->next;     }      return(ret); }     /**u  * xmlDocSetRootElement:  * @doc:  the document(  * @root:  the new document root element  *@  * Set the root element of the document (doc->children is a list/  * containing possibly comments, PIs, etc ...).:  *0  * Returns the old root element if any was found  */t
 xmlNodePtr6 xmlDocSetRootElement(xmlDocPtr doc, xmlNodePtr root) {     xmlNodePtr old = NULL;  "     if (doc == NULL) return(NULL);     old = doc->children;     while (old != NULL) {t# 	if (old->type == XML_ELEMENT_NODE)  	    break;t         old = old->next;     }L     if (old == NULL) { 	if (doc->children == NULL) {= 	    doc->children = root;	 	} else {p( 	    xmlAddSibling(doc->children, root); 	}     } else { 	xmlReplaceNode(old, root);f     }>     return(old); }n  d /**   * xmlNodeSetLang:   * @cur:  the node being changed"  * @lang:  the langage description  *>  * Set the language of a node, i.e. the values of the xml:lang
  * attribute.n  */e void5 xmlNodeSetLang(xmlNodePtr cur, const xmlChar *lang) {r     if (cur == NULL) return;     switch(cur->type) {n         case XML_TEXT_NODE:!$         case XML_CDATA_SECTION_NODE:         case XML_COMMENT_NODE:         case XML_DOCUMENT_NODE:t$         case XML_DOCUMENT_TYPE_NODE:$         case XML_DOCUMENT_FRAG_NODE:         case XML_NOTATION_NODE:E$         case XML_HTML_DOCUMENT_NODE:         case XML_DTD_NODE:         case XML_ELEMENT_DECL:          case XML_ATTRIBUTE_DECL:         case XML_ENTITY_DECL:e         case XML_PI_NODE:(!         case XML_ENTITY_REF_NODE:t         case XML_ENTITY_NODE:  #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:t #endif 	    return;         case XML_ELEMENT_NODE:          case XML_ATTRIBUTE_NODE: 	    break;D     })/     xmlSetProp(cur, BAD_CAST "xml:lang", lang);r }-  n /**;  * xmlNodeGetLang:   * @cur:  the node being checked  *C  * Searches the language of a node, i.e. the values of the xml:langU8  * attribute or the one carried by the nearest ancestor.  *<  * Returns a pointer to the lang value, or NULL if not found0  *     It's up to the caller to free the memory.  */ 	 xmlChar *c  xmlNodeGetLang(xmlNodePtr cur) {     xmlChar *lang;       while (cur != NULL) { 4         lang = xmlGetProp(cur, BAD_CAST "xml:lang"); 	if (lang != NULL) 	    return(lang); 	cur = cur->parent;r     })     return(NULL);= }U    /**i  * xmlNodeGetSpacePreserve:i   * @cur:  the node being checked  *D  * Searches the language of a node, i.e. the values of the xml:space8  * attribute or the one carried by the nearest ancestor.  *K  * Returns -1 if xml:space is not inheried, 0 if "default", 1 if "preserve"h  */r int;) xmlNodeGetSpacePreserve(xmlNodePtr cur) {d     xmlChar *space;N       while (cur != NULL) {r6         space = xmlGetProp(cur, BAD_CAST "xml:space"); 	if (space != NULL) {l3 	    if (xmlStrEqual(space, BAD_CAST "preserve")) {  		xmlFree(space);r 		return(1); 	    }2 	    if (xmlStrEqual(space, BAD_CAST "default")) { 		xmlFree(space);p 		return(0); 	    } 	    xmlFree(space); 	} 	cur = cur->parent;h     }      return(-1);u }a  t /**i  * xmlNodeSetName:   * @cur:  the node being changed  * @name:  the new tag nameN  *C  * Searches the language of a node, i.e. the values of the xml:langN8  * attribute or the one carried by the nearest ancestor.  */e void5 xmlNodeSetName(xmlNodePtr cur, const xmlChar *name) {t     if (cur == NULL) return;     if (name == NULL) return;-     switch(cur->type) {-         case XML_TEXT_NODE: $         case XML_CDATA_SECTION_NODE:         case XML_COMMENT_NODE:$         case XML_DOCUMENT_TYPE_NODE:$         case XML_DOCUMENT_FRAG_NODE:         case XML_NOTATION_NODE:i$         case XML_HTML_DOCUMENT_NODE: #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:n #endif 	    return;         case XML_ELEMENT_NODE:          case XML_ATTRIBUTE_NODE:         case XML_PI_NODE: !         case XML_ENTITY_REF_NODE:h         case XML_ENTITY_NODE:-         case XML_DTD_NODE:         case XML_DOCUMENT_NODE:1         case XML_ELEMENT_DECL:          case XML_ATTRIBUTE_DECL:         case XML_ENTITY_DECL:  	    break;o     } :     if (cur->name != NULL) xmlFree((xmlChar *) cur->name);      cur->name = xmlStrdup(name); }f  u /**N  * xmlNodeGetBase:+  * @doc:  the document the node pertains toe   * @cur:  the node being checked  *>  * Searches for the BASE URL. The code should work on both XMLF  * and HTML document even if base mechanisms are completely different.  *:  * Returns a pointer to the base URL, or NULL if not found0  *     It's up to the caller to free the memory.  */ 	 xmlChar *-/ xmlNodeGetBase(xmlDocPtr doc, xmlNodePtr cur) {      xmlChar *base;  (     if ((cur == NULL) && (doc == NULL))          return(NULL); %     if (doc == NULL) doc = cur->doc;	:A     if ((doc != NULL) && (doc->type == XML_HTML_DOCUMENT_NODE)) {          cur = doc->children;/ 	while ((cur != NULL) && (cur->name != NULL)) {r( 	    if (cur->type == XML_ENTITY_DECL) {/ 		/* TODO: we are crossing entity boundaries */* 	    }) 	    if (cur->type != XML_ELEMENT_NODE) {p 	        cur = cur->next;l 		continue;{ 	    }6 	    if (!xmlStrcasecmp(cur->name, BAD_CAST "html")) { 	        cur = cur->children;N 		continue;d 	    }6 	    if (!xmlStrcasecmp(cur->name, BAD_CAST "head")) { 	        cur = cur->children;f 		continue;n 	    }6 	    if (!xmlStrcasecmp(cur->name, BAD_CAST "base")) {9                 return(xmlGetProp(cur, BAD_CAST "href"));L 	    } 	    cur = cur->next;  	}) 	if ((doc != NULL) && (doc->URL != NULL))N! 	    return(xmlStrdup(doc->URL));  	return(NULL);     })     while (cur != NULL) {r4         base = xmlGetProp(cur, BAD_CAST "xml:base"); 	if (base != NULL) 	    return(base); 	cur = cur->parent;      } ,     if ((doc != NULL) && (doc->URL != NULL)) 	return(xmlStrdup(doc->URL));o     return(NULL);* }*  * /***  * xmlNodeGetContent:*  * @cur:  the node being read	  *@  * Read the value of a node, this can be either the text carriedD  * directly by this node if it's a TEXT node or the aggregate stringD  * of the values carried by this node child's (TEXT and ENTITY_REF).$  * Entity references are substitued.>  * Returns a new xmlChar * or NULL if no content is available.0  *     It's up to the caller to free the memory.  */)	 xmlChar *L# xmlNodeGetContent(xmlNodePtr cur) { "     if (cur == NULL) return(NULL);     switch (cur->type) {$         case XML_DOCUMENT_FRAG_NODE:         case XML_ELEMENT_NODE:E             return(xmlNodeListGetString(cur->doc, cur->children, 1));{ 	    break;G"         case XML_ATTRIBUTE_NODE: {( 	    xmlAttrPtr attr = (xmlAttrPtr) cur; 	    if (attr->parent != NULL)E 		return(xmlNodeListGetString(attr->parent->doc, attr->children, 1));:	 	    else 8 		return(xmlNodeListGetString(NULL, attr->children, 1)); 	    break;e 	}         case XML_COMMENT_NODE:         case XML_PI_NODE:N 	    if (cur->content != NULL) #ifndef XML_USE_BUFFER_CONTENT) 	        return(xmlStrdup(cur->content));  #else ; 	        return(xmlStrdup(xmlBufferContent(cur->content)));= #endif 	    return(NULL);!         case XML_ENTITY_REF_NODE:r 	    /*e/ 	     * Locate the entity, and get it's contentl 	     * @@@* 	     */             return(NULL);i         case XML_ENTITY_NODE:          case XML_DOCUMENT_NODE:o$         case XML_HTML_DOCUMENT_NODE:$         case XML_DOCUMENT_TYPE_NODE:         case XML_NOTATION_NODE:(         case XML_DTD_NODE: #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:r #endif 	    return(NULL);         case XML_ELEMENT_DECL: 	    /* TODO !!! */r 	    return(NULL);          case XML_ATTRIBUTE_DECL: 	    /* TODO !!! */c 	    return(NULL);         case XML_ENTITY_DECL:t 	    /* TODO !!! */, 	    return(NULL);$         case XML_CDATA_SECTION_NODE:         case XML_TEXT_NODE:  	    if (cur->content != NULL) #ifndef XML_USE_BUFFER_CONTENT" 		return(xmlStrdup(cur->content)); #elset; 	        return(xmlStrdup(xmlBufferContent(cur->content)));  #endif             return(NULL);i     }=     return(NULL);r }=  l /**o  * xmlNodeSetContent: !  * @cur:  the node being modifiedl*  * @content:  the new value of the content  *!  * Replace the content of a node.@  */  void; xmlNodeSetContent(xmlNodePtr cur, const xmlChar *content) {*     if (cur == NULL) { #ifdef DEBUG_TREE >         fprintf(stderr, "xmlNodeSetContent : node == NULL\n"); #endif 	return;     }m     switch (cur->type) {$         case XML_DOCUMENT_FRAG_NODE:         case XML_ELEMENT_NODE:  	    if (cur->content != NULL) { #ifndef XML_USE_BUFFER_CONTENT 	        xmlFree(cur->content);  #elsev 		xmlBufferFree(cur->content); #endif 		cur->content = NULL; 	    }? 	    if (cur->children != NULL) xmlFreeNodeList(cur->children);r= 	    cur->children = xmlStringGetNodeList(cur->doc, content);  	    UPDATE_LAST_CHILD(cur)i 	    break;a          case XML_ATTRIBUTE_NODE: 	    break;h         case XML_TEXT_NODE:m$         case XML_CDATA_SECTION_NODE:!         case XML_ENTITY_REF_NODE:f         case XML_ENTITY_NODE:          case XML_PI_NODE:e         case XML_COMMENT_NODE:  	    if (cur->content != NULL) { #ifndef XML_USE_BUFFER_CONTENT 		xmlFree(cur->content); #elsem% 	        xmlBufferFree(cur->content);r #endif 	    }	e? 	    if (cur->children != NULL) xmlFreeNodeList(cur->children);l& 	    cur->last = cur->children = NULL; 	    if (content != NULL) {m #ifndef XML_USE_BUFFER_CONTENT$ 		cur->content = xmlStrdup(content); #elseS( 		cur->content = xmlBufferCreateSize(0);, 		xmlBufferSetAllocationScheme(cur->content,8 			                     xmlGetBufferAllocationScheme());* 		xmlBufferAdd(cur->content, content, -1); #endif 	    } else  		cur->content = NULL; 	    break;e         case XML_DOCUMENT_NODE: $         case XML_HTML_DOCUMENT_NODE:$         case XML_DOCUMENT_TYPE_NODE: #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:z #endif 	    break;e         case XML_NOTATION_NODE:- 	    break;          case XML_DTD_NODE: 	    break;>         case XML_ELEMENT_DECL: 	    /* TODO !!! */  	    break;-          case XML_ATTRIBUTE_DECL: 	    /* TODO !!! */) 	    break;          case XML_ENTITY_DECL:o 	    /* TODO !!! */e 	    break;      }  }t   /**n  * xmlNodeSetContentLen:!  * @cur:  the node being modifiedl*  * @content:  the new value of the content  * @len:  the size of @content  *!  * Replace the content of a node.e  */n voidG xmlNodeSetContentLen(xmlNodePtr cur, const xmlChar *content, int len) {c     if (cur == NULL) { #ifdef DEBUG_TREE!A         fprintf(stderr, "xmlNodeSetContentLen : node == NULL\n");i #endif 	return;     }(     switch (cur->type) {$         case XML_DOCUMENT_FRAG_NODE:         case XML_ELEMENT_NODE:  	    if (cur->content != NULL) { #ifndef XML_USE_BUFFER_CONTENT 	        xmlFree(cur->content);N #else  		xmlBufferFree(cur->content); #endif 		cur->content = NULL; 	    }? 	    if (cur->children != NULL) xmlFreeNodeList(cur->children);lE 	    cur->children = xmlStringLenGetNodeList(cur->doc, content, len);n 	    UPDATE_LAST_CHILD(cur)d 	    break;p          case XML_ATTRIBUTE_NODE: 	    break;o         case XML_TEXT_NODE: $         case XML_CDATA_SECTION_NODE:!         case XML_ENTITY_REF_NODE:n         case XML_ENTITY_NODE:u         case XML_PI_NODE:c         case XML_COMMENT_NODE:         case XML_NOTATION_NODE:   	    if (cur->content != NULL) { #ifndef XML_USE_BUFFER_CONTENT 		xmlFree(cur->content); #elseP% 	        xmlBufferFree(cur->content);f #endif 	    }	!? 	    if (cur->children != NULL) xmlFreeNodeList(cur->children);l& 	    cur->children = cur->last = NULL; 	    if (content != NULL) {  #ifndef XML_USE_BUFFER_CONTENT* 		cur->content = xmlStrndup(content, len); #elser* 		cur->content = xmlBufferCreateSize(len);, 		xmlBufferSetAllocationScheme(cur->content,8 			                     xmlGetBufferAllocationScheme());+ 		xmlBufferAdd(cur->content, content, len);; #endif 	    } else  		cur->content = NULL; 	    break;q         case XML_DOCUMENT_NODE:n         case XML_DTD_NODE:$         case XML_HTML_DOCUMENT_NODE:$         case XML_DOCUMENT_TYPE_NODE: #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:h #endif 	    break;r         case XML_ELEMENT_DECL: 	    /* TODO !!! */T 	    break;           case XML_ATTRIBUTE_DECL: 	    /* TODO !!! */N 	    break;          case XML_ENTITY_DECL:o 	    /* TODO !!! */s 	    break;e     }t }    /***  * xmlNodeAddContentLen:!  * @cur:  the node being modifieds  * @content:  extra contenty  * @len:  the size of @content  *  2  * Append the extra substring to the node content.  */P voidG xmlNodeAddContentLen(xmlNodePtr cur, const xmlChar *content, int len) {i     if (cur == NULL) { #ifdef DEBUG_TREEuA         fprintf(stderr, "xmlNodeAddContentLen : node == NULL\n");o #endif 	return;     }i     if (len <= 0) return;      switch (cur->type) {$         case XML_DOCUMENT_FRAG_NODE:          case XML_ELEMENT_NODE: {% 	    xmlNodePtr last = NULL, newNode;   ! 	    if (cur->children != NULL) {w 		last = cur->last; 
 	    } else {>$ 	        if (cur->content != NULL) { #ifndef XML_USE_BUFFER_CONTENTC 		    cur->children = xmlStringGetNodeList(cur->doc, cur->content);e #elsee4 		    cur->children = xmlStringGetNodeList(cur->doc,: 			                       xmlBufferContent(cur->content)); #endif 		    UPDATE_LAST_CHILD(cur) #ifndef XML_USE_BUFFER_CONTENT 		    xmlFree(cur->content); #elsec" 		    xmlBufferFree(cur->content); #endif 		    cur->content = NULL; 		    last = cur->last;o 		}  	    }+ 	    newNode = xmlNewTextLen(content, len);  	    if (newNode != NULL) {t 		xmlAddChild(cur, newNode);9 	        if ((last != NULL) && (last->next == newNode)) {;" 		    xmlTextMerge(last, newNode); 		}d 	    } 	    break;s 	}          case XML_ATTRIBUTE_NODE: 	    break;f         case XML_TEXT_NODE: $         case XML_CDATA_SECTION_NODE:!         case XML_ENTITY_REF_NODE:(         case XML_ENTITY_NODE:i         case XML_PI_NODE:s         case XML_COMMENT_NODE:         case XML_NOTATION_NODE:e 	    if (content != NULL) {N #ifndef XML_USE_BUFFER_CONTENT8 		cur->content = xmlStrncat(cur->content, content, len); #else + 		xmlBufferAdd(cur->content, content, len);  #endif
             }t         case XML_DOCUMENT_NODE:i         case XML_DTD_NODE:$         case XML_HTML_DOCUMENT_NODE:$         case XML_DOCUMENT_TYPE_NODE: #ifdef LIBXML_SGML_ENABLED 	case XML_SGML_DOCUMENT_NODE:  #endif 	    break;          case XML_ELEMENT_DECL:          case XML_ATTRIBUTE_DECL:         case XML_ENTITY_DECL:e 	    break;e     }, }e   /**t  * xmlNodeAddContent:d!  * @cur:  the node being modified   * @content:  extra content   * m2  * Append the extra substring to the node content.  */C void; xmlNodeAddContent(xmlNodePtr cur, const xmlChar *content) {f     int len;       if (cur == NULL) { #ifdef DEBUG_TREEi>         fprintf(stderr, "xmlNodeAddContent : node == NULL\n"); #endif 	return;     }       if (content == NULL) return;     len = xmlStrlen(content); ,     xmlNodeAddContentLen(cur, content, len); }e   /**r  * xmlTextMerge:  * @first:  the first text nodeo.  * @second:  the second text node being merged  *     * Merge two text nodes into one(  * Returns the first text node augmented  */t
 xmlNodePtr3 xmlTextMerge(xmlNodePtr first, xmlNodePtr second) {e&     if (first == NULL) return(second);&     if (second == NULL) return(first);4     if (first->type != XML_TEXT_NODE) return(first);5     if (second->type != XML_TEXT_NODE) return(first);t #ifndef XML_USE_BUFFER_CONTENT.     xmlNodeAddContent(first, second->content); #else*@     xmlNodeAddContent(first, xmlBufferContent(second->content)); #endif     xmlUnlinkNode(second);     xmlFreeNode(second);     return(first); }x   /**t  * xmlGetNsList:  * @doc:  the document  * @node:  the current nodee  *8  * Search all the namespace applying to a given element.=  * Returns an NULL terminated array of all the xmlNsPtr foundo<  *         that need to be freed by the caller or NULL if no  *         namespace if defined   */(
 xmlNsPtr *. xmlGetNsList(xmlDocPtr doc, xmlNodePtr node) {     xmlNsPtr cur;t     xmlNsPtr *ret = NULL;M     int nbns = 0;t     int maxns = 10;e
     int i;       while (node != NULL) { 	cur = node->nsDef;o 	while (cur != NULL) { 	    if (ret == NULL) {tF 	        ret = (xmlNsPtr *) xmlMalloc((maxns + 1) * sizeof(xmlNsPtr)); 		if (ret == NULL) {9 		    fprintf(stderr, "xmlGetNsList : out of memory!\n");  		    return(NULL);d 		}  		ret[nbns] = NULL;u 	    } 	    for (i = 0;i < nbns;i++) {t/ 	        if ((cur->prefix == ret[i]->prefix) ||r8 		    (xmlStrEqual(cur->prefix, ret[i]->prefix))) break; 	    } 	    if (i >= nbns) {o 	        if (nbns >= maxns) {= 		    maxns *= 2; ( 		    ret = (xmlNsPtr *) xmlRealloc(ret,; 		                         (maxns + 1) * sizeof(xmlNsPtr));= 		    if (ret == NULL) {7 			fprintf(stderr, "xmlGetNsList : realloc failed!\n");  			return(NULL); 		    }c 		}( 		ret[nbns++] = cur; 		ret[nbns] = NULL;  	    }   	    cur = cur->next;@ 	} 	node = node->parent;d     }a     return(ret); }r   /**   * xmlSearchNs:n  * @doc:  the document  * @node:  the current nodea$  * @nameSpace:  the namespace string  *B  * Search a Ns registered under a given name space for a document.>  * recurse on the parents until it finds the defined namespace  * or return NULL otherwise.F  * @nameSpace can be NULL, this is a search for the default namespace.D  * We don't allow to cross entities boundaries. If you don't declareC  * the namespace within those you will be in troubles !!! A warning:#  * is generated to cover this case.   *)  * Returns the namespace pointer or NULL.U  */C xmlNsPtrG xmlSearchNs(xmlDocPtr doc, xmlNodePtr node, const xmlChar *nameSpace) {T     xmlNsPtr cur;   #     if (node == NULL) return(NULL);M     while (node != NULL) {+ 	if ((node->type == XML_ENTITY_REF_NODE) || ' 	    (node->type == XML_ENTITY_NODE) ||X% 	    (node->type == XML_ENTITY_DECL))) 	    return(NULL);& 	if (node->type == XML_ELEMENT_NODE) { 	    cur = node->nsDef;  	    while (cur != NULL) {5 		if ((cur->prefix == NULL) && (nameSpace == NULL) &&v 		    (cur->href != NULL)) 		    return(cur);5 		if ((cur->prefix != NULL) && (nameSpace != NULL) &&t 		    (cur->href != NULL) &&, 		    (xmlStrEqual(cur->prefix, nameSpace))) 		    return(cur); 		cur = cur->next; 	    } 	} 	node = node->parent;m     }l     return(NULL);c }!   /**   * xmlSearchNsByHref:e  * @doc:  the document  * @node:  the current node   * @href:  the namespace value  *J  * Search a Ns aliasing a given URI. Recurse on the parents until it finds2  * the defined namespace or return NULL otherwise.)  * Returns the namespace pointer or NULL.t  */l xmlNsPtrH xmlSearchNsByHref(xmlDocPtr doc, xmlNodePtr node, const xmlChar *href) {     xmlNsPtr cur;      xmlNodePtr orig = node;f  7     if ((node == NULL) || (href == NULL)) return(NULL);r     while (node != NULL) { 	cur = node->nsDef;! 	while (cur != NULL) {1 	    if ((cur->href != NULL) && (href != NULL) &&a* 	        (xmlStrEqual(cur->href, href))) { 		/*@ 		 * Check that the prefix is not shadowed between orig and node 		 */l 		xmlNodePtr check = orig; 		xmlNsPtr tst;F   		while (check != node) {  		    tst = check->nsDef;  		    while (tst != NULL) { 6 			if ((tst->prefix == NULL) && (cur->prefix == NULL))# 	                    goto shadowed;@8 			if ((tst->prefix != NULL) && (cur->prefix != NULL) &&/ 			    (xmlStrEqual(tst->prefix, cur->prefix)))i# 	                    goto shadowed;t 		        tst = tst->next; 		    }e 		}o 		return(cur); 	    } shadowed:		    f 	    cur = cur->next;  	} 	node = node->parent;n     }      return(NULL);- }    /**a  * xmlNewReconciliedNs  * @doc:  the document4  * @tree:  a node expected to hold the new namespace  * @ns:  the original namespace   *A  * This function tries to locate a namespace definition in a tree B  * ancestors, or create a new namespace definition node similar toF  * @ns trying to reuse the same prefix. However if the given prefix isC  * null (default namespace) or reused within the subtree defined by C  * @tree or on one of its ancestors then a new prefix is generated. B  * Returns the (new) namespace definition or NULL in case of error  */E xmlNsPtrB xmlNewReconciliedNs(xmlDocPtr doc, xmlNodePtr tree, xmlNsPtr ns) {     xmlNsPtr def;      xmlChar prefix[50];N     int counter = 1;       if (tree == NULL) {m #ifdef DEBUG_TREE;@         fprintf(stderr, "xmlNewReconciliedNs : tree == NULL\n"); #endif 	return(NULL);     }o     if (ns == NULL) {* #ifdef DEBUG_TREEA>         fprintf(stderr, "xmlNewReconciliedNs : ns == NULL\n"); #endif 	return(NULL);     }l     /*9      * Search an existing namespace definition inherited.       */u1     def = xmlSearchNsByHref(doc, tree, ns->href);.     if (def != NULL)         return(def);       /*7      * Find a close prefix which is not already in use.L<      * Let's strip namespace prefixes longer than 20 chars !      */=2     sprintf((char *) prefix, "%.20s", ns->prefix);)     def = xmlSearchNs(doc, tree, prefix);      while (def != NULL) {r)         if (counter > 1000) return(NULL);iC         sprintf((char *) prefix, "%.20s%d", ns->prefix, counter++); & 	def = xmlSearchNs(doc, tree, prefix);     }M       /*0      * Ok, now we are ready to create a new one.      */ +     def = xmlNewNs(tree, ns->href, prefix);h     return(def); }r   /**>  * xmlReconciliateNs  * @doc:  the document6  * @tree:  a node defining the subtree to reconciliate  *I  * This function checks that all the namespaces declared within the givenDK  * tree are properly declared. This is needed for example after Copy or Cut D  * and then paste operations. The subtree may still hold pointers toH  * namespace declarations outside the subtree or invalid/masked. As muchI  * as possible the function try tu reuse the existing namespaces found in;I  * the new environment. If not possible the new namespaces are redeclared ,  * on @tree at the top of the given subtree.O  * Returns the number of namespace declarations created or -1 in case of error.t  */* int:3 xmlReconciliateNs(xmlDocPtr doc, xmlNodePtr tree) {d     xmlNsPtr *oldNs = NULL;t     xmlNsPtr *newNs = NULL;      int sizeCache = 0;     int nbCache = 0;       xmlNsPtr n;s     xmlNodePtr node = tree;      xmlAttrPtr attr;     int ret = 0, i;s       while (node != NULL) {
         /*# 	 * Reconciliate the node namespace. 	 */ 	if (node->ns != NULL) { 	    /*e& 	     * initialize the cache if needed 	     */ 	    if (sizeCache == 0) { 		sizeCache = 10;L, 		oldNs = (xmlNsPtr *) xmlMalloc(sizeCache * 					       sizeof(xmlNsPtr)); 		if (oldNs == NULL) {: 		    fprintf(stderr, "xmlReconciliateNs : memory pbm\n"); 		    return(-1);k 		} , 		newNs = (xmlNsPtr *) xmlMalloc(sizeCache * 					       sizeof(xmlNsPtr)); 		if (newNs == NULL) {: 		    fprintf(stderr, "xmlReconciliateNs : memory pbm\n"); 		    xmlFree(oldNs);e 		    return(-1);o 		}t 	    }" 	    for (i = 0;i < nbCache;i++) {$ 	        if (oldNs[i] == node->ns) { 		    node->ns = newNs[i]; 		    break; 		}> 	    } 	    if (i == nbCache) { 	        /*T6 		 * Ok we need to recreate a new namespace definition 		 */r/ 		n = xmlNewReconciliedNs(doc, tree, node->ns);=- 		if (n != NULL) { /* :-( what if else ??? */E 		    /*4 		     * check if we need to grow the cache buffers.	 		     */l! 		    if (sizeCache <= nbCache) {  		        sizeCache *= 2;a5 			oldNs = (xmlNsPtr *) xmlRealloc(oldNs, sizeCache * 4 			                               sizeof(xmlNsPtr)); 		        if (oldNs == NULL) {; 			    fprintf(stderr, "xmlReconciliateNs : memory pbm\n");B 			    xmlFree(newNs); 			    return(-1); 			}5 			newNs = (xmlNsPtr *) xmlRealloc(newNs, sizeCache *C4 			                               sizeof(xmlNsPtr)); 		        if (newNs == NULL) {; 			    fprintf(stderr, "xmlReconciliateNs : memory pbm\n");E 			    xmlFree(oldNs); 			    return(-1); 			} 		    }e 		    newNs[nbCache] = n; " 		    oldNs[nbCache++] = node->ns; 		    node->ns = n;)                 }U 	    } 	} 	/*e; 	 * now check for namespace hold by attributes on the node.r 	 */ 	attr = node->properties;) 	while (attr != NULL) {  	    if (attr->ns != NULL) { 		/*# 		 * initialize the cache if neededn 		 */  		if (sizeCache == 0) {m 		    sizeCache = 10; 0 		    oldNs = (xmlNsPtr *) xmlMalloc(sizeCache * 						   sizeof(xmlNsPtr));d 		    if (oldNs == NULL) {7 			fprintf(stderr, "xmlReconciliateNs : memory pbm\n");{ 			return(-1); 		    } 0 		    newNs = (xmlNsPtr *) xmlMalloc(sizeCache * 						   sizeof(xmlNsPtr));  		    if (newNs == NULL) {7 			fprintf(stderr, "xmlReconciliateNs : memory pbm\n");L 			xmlFree(oldNs); 			return(-1); 		    }) 		}i 		for (i = 0;i < nbCache;i++) { ! 		    if (oldNs[i] == attr->ns) {v 			node->ns = newNs[i];n	 			break;d 		    }- 		}e 		if (i == nbCache) {  		    /*: 		     * Ok we need to recreate a new namespace definition	 		     */=3 		    n = xmlNewReconciliedNs(doc, tree, attr->ns);T1 		    if (n != NULL) { /* :-( what if else ??? */A 			/*E1 			 * check if we need to grow the cache buffers.  			 */ 			if (sizeCache <= nbCache) { 			    sizeCache *= 2;9 			    oldNs = (xmlNsPtr *) xmlRealloc(oldNs, sizeCache *P 							   sizeof(xmlNsPtr)); 			    if (oldNs == NULL) {t 				fprintf(stderr,e0 				        "xmlReconciliateNs : memory pbm\n"); 				xmlFree(newNs);l 				return(-1);o 			    }9 			    newNs = (xmlNsPtr *) xmlRealloc(newNs, sizeCache *d 							   sizeof(xmlNsPtr)); 			    if (newNs == NULL) {L 				fprintf(stderr,!0 				        "xmlReconciliateNs : memory pbm\n"); 				xmlFree(oldNs);c 				return(-1);  			    } 			} 			newNs[nbCache] = n; 			oldNs[nbCache++] = attr->ns;c 			attr->ns = n; 		    }  		}  	    } 	    attr = attr->next;) 	}   	/*f' 	 * Browse the full subtree, deep firstf 	 */%         if (node->children != NULL) {b 	    /* deep first */L 	    node = node->children;e5 	} else if ((node != tree) && (node->next != NULL)) {E 	    /* then siblings */ 	    node = node->next;D 	} else if (node != tree) {b+ 	    /* go up to parents->next if needed */  	    while (node != tree) {D" 	        if (node->parent != NULL) 		    node = node->parent;/ 		if ((node != tree) && (node->next != NULL)) {U 		    node = node->next; 		    break; 		}  		if (node->parent == NULL) {  		    node = NULL; 		    break; 		}  	    } 	    /* exit condition */t 	    if (node == tree) b 	        node = NULL;t 	}     }e     return(ret); }t   /**e  * xmlHasProp:  * @node:  the nodea  * @name:  the attribute namen  *+  * Search an attribute associated to a nodetF  * This function also looks in DTD attribute declaration for #FIXED orA  * default declaration values unless DTD use has been turned off.)  *A  * Returns the attribute or the attribute declaration or NULL if L  *         neither was found.a  */L
 xmlAttrPtr2 xmlHasProp(xmlNodePtr node, const xmlChar *name) {     xmlAttrPtr prop;     xmlDocPtr doc;  7     if ((node == NULL) || (name == NULL)) return(NULL);	     /*3      * Check on the properties attached to the node       */d     prop = node->properties;     while (prop != NULL) {-         if (xmlStrEqual(prop->name, name))  {T 	    return(prop);	         }p 	prop = prop->next;T     }N#     if (!xmlCheckDTD) return(NULL);T       /*>      * Check if there is a default declaration in the internal      * or external subsets      */O     doc =  node->doc;P     if (doc != NULL) {!         xmlAttributePtr attrDecl;N%         if (doc->intSubset != NULL) {=D 	    attrDecl = xmlGetDtdAttrDesc(doc->intSubset, node->name, name);8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL))A 		attrDecl = xmlGetDtdAttrDesc(doc->extSubset, node->name, name);) 	    if (attrDecl != NULL)  		return((xmlAttrPtr) attrDecl); 	}     }      return(NULL);F }C   /**   * xmlGetProp:  * @node:  the nodel  * @name:  the attribute namex  *@  * Search and get the value of an attribute associated to a node%  * This does the entity substitution.lA  * This function looks in DTD attribute declaration for #FIXED oreA  * default declaration values unless DTD use has been turned off.a  *4  * Returns the attribute value or NULL if not found.0  *     It's up to the caller to free the memory.  */N	 xmlChar *:2 xmlGetProp(xmlNodePtr node, const xmlChar *name) {     xmlAttrPtr prop;     xmlDocPtr doc;  7     if ((node == NULL) || (name == NULL)) return(NULL);      /*3      * Check on the properties attached to the nodee      */      prop = node->properties;     while (prop != NULL) {-         if (xmlStrEqual(prop->name, name))  {e 	    xmlChar *ret;  > 	    ret = xmlNodeListGetString(node->doc, prop->children, 1);7 	    if (ret == NULL) return(xmlStrdup((xmlChar *)""));e 	    return(ret);P	         }N 	prop = prop->next;o     }u#     if (!xmlCheckDTD) return(NULL);i       /*>      * Check if there is a default declaration in the internal      * or external subsets      */o     doc =  node->doc;      if (doc != NULL) {!         xmlAttributePtr attrDecl; %         if (doc->intSubset != NULL) { D 	    attrDecl = xmlGetDtdAttrDesc(doc->intSubset, node->name, name);8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL))A 		attrDecl = xmlGetDtdAttrDesc(doc->extSubset, node->name, name);_ 	    if (attrDecl != NULL), 		return(xmlStrdup(attrDecl->defaultValue)); 	}     })     return(NULL);u }c   /**   * xmlGetNsProp:  * @node:  the node   * @name:  the attribute namen(  * @namespace:  the URI of the namespace  *@  * Search and get the value of an attribute associated to a node@  * This attribute has to be anchored in the namespace specified.%  * This does the entity substitution.rA  * This function looks in DTD attribute declaration for #FIXED or A  * default declaration values unless DTD use has been turned off.   *4  * Returns the attribute value or NULL if not found.0  *     It's up to the caller to free the memory.  */k	 xmlChar * N xmlGetNsProp(xmlNodePtr node, const xmlChar *name, const xmlChar *namespace) {'     xmlAttrPtr prop = node->properties;a     xmlDocPtr doc;     xmlNsPtr ns;       if (namespace == NULL)  	return(xmlGetProp(node, name));     while (prop != NULL) { 	/*N 	 * One need to have 	 *   - same attribute names1 	 *   - and the attribute carrying that namespacea 	 *         orE 	 *         no namespace on the attribute and the element carrying ite 	 */.         if ((xmlStrEqual(prop->name, name)) &&2 	    (((prop->ns == NULL) && (node->ns != NULL) &&3 	      (xmlStrEqual(node->ns->href, namespace))) || J 	     ((prop->ns != NULL) && (xmlStrEqual(prop->ns->href, namespace))))) { 	    xmlChar *ret;  > 	    ret = xmlNodeListGetString(node->doc, prop->children, 1);7 	    if (ret == NULL) return(xmlStrdup((xmlChar *)""));l 	    return(ret);*	         }  	prop = prop->next;      }t#     if (!xmlCheckDTD) return(NULL);        /*>      * Check if there is a default declaration in the internal      * or external subsets      */      doc =  node->doc;      if (doc != NULL) {!         xmlAttributePtr attrDecl;e%         if (doc->intSubset != NULL) {"D 	    attrDecl = xmlGetDtdAttrDesc(doc->intSubset, node->name, name);8 	    if ((attrDecl == NULL) && (doc->extSubset != NULL))A 		attrDecl = xmlGetDtdAttrDesc(doc->extSubset, node->name, name);e 		$ 	    if (attrDecl->prefix != NULL) { 	        /*d4 		 * The DTD declaration only allows a prefix search 		 */t0 		ns = xmlSearchNs(doc, node, attrDecl->prefix);9 		if ((ns != NULL) && (xmlStrEqual(ns->href, namespace)))=0 		    return(xmlStrdup(attrDecl->defaultValue)); 	    } 	}     }f     return(NULL);L }X   /**   * xmlSetProp:  * @node:  the node!  * @name:  the attribute namet  * @value:  the attribute value   *1  * Set (or reset) an attribute carried by a node. !  * Returns the attribute pointer.f  */t
 xmlAttrPtrH xmlSetProp(xmlNodePtr node, const xmlChar *name, const xmlChar *value) {'     xmlAttrPtr prop = node->properties;N       while (prop != NULL) {,         if (xmlStrEqual(prop->name, name)) {! 	    if (prop->children != NULL) e) 	        xmlFreeNodeList(prop->children);r 	    prop->children = NULL;o 	    if (value != NULL) {e 	        xmlChar *buffer;L 		xmlNodePtr tmp;n  8 		buffer = xmlEncodeEntitiesReentrant(node->doc, value);; 		prop->children = xmlStringGetNodeList(node->doc, buffer);* 		tmp = prop->children;s 		while (tmp != NULL) {0& 		    tmp->parent = (xmlNodePtr) prop; 		    if (tmp->next == NULL) 			prop->last = tmp; 		    tmp = tmp->next; 		}  		xmlFree(buffer); 	    }	l 	    return(prop); 	} 	prop = prop->next;e     }L)     prop = xmlNewProp(node, name, value);      return(prop);  }	   /**u  * xmlNodeIsText:	  * @node:  the node   *    * Is this node a Text node ?t  * Returns 1 yes, 0 no  */= inti  xmlNodeIsText(xmlNodePtr node) {      if (node == NULL) return(0);  /     if (node->type == XML_TEXT_NODE) return(1);n     return(0); }	   /**n  * xmlIsBlankNode:  * @node:  the nodel  * e:  * Checks whether this node is an empty or whitespace only&  * (and possibly ignorable) text-node.  *  * Returns 1 yes, 0 no  */c inte! xmlIsBlankNode(xmlNodePtr node) {c     xmlChar *cur;+      if (node == NULL) return(0);  /     if (node->type != XML_TEXT_NODE) return(0);a)     if (node->content == NULL) return(0);      cur = node->content;     while (*cur != 0) {e  	if (!IS_BLANK(*cur)) return(0); 	cur++;a     }        return(1); }    /**g  * xmlTextConcat:e  * @node:  the nodec  * @content:  the contenta  * @len:  @content lenghtf  * nB  * Concat the given string at the end of the existing node content  */s   voidA xmlTextConcat(xmlNodePtr node, const xmlChar *content, int len) {o     if (node == NULL) return;   (     if ((node->type != XML_TEXT_NODE) &&1         (node->type != XML_CDATA_SECTION_NODE)) {t #ifdef DEBUG_TREER@ 	fprintf(stderr, "xmlTextConcat: node is not text nor cdata\n"); #endif         return;t     }  #ifndef XML_USE_BUFFER_CONTENT<     node->content = xmlStrncat(node->content, content, len); #elsen.     xmlBufferAdd(node->content, content, len); #endif }   I /************************************************************************C  *									*(  *			Output : to a FILE or in memory			*  *									*J  ************************************************************************/   #define BASE_BUFFER_SIZE 4000    /**>  * xmlBufferCreate:   *#  * routine to create an XML buffer.   * returns the new structure.   */r xmlBufferPtr xmlBufferCreate(void) {c     xmlBufferPtr ret;)  6     ret = (xmlBufferPtr) xmlMalloc(sizeof(xmlBuffer));     if (ret == NULL) {7 	fprintf(stderr, "xmlBufferCreate : out of memory!\n");e         return(NULL);t     }o     ret->use = 0;d!     ret->size = BASE_BUFFER_SIZE; &     ret->alloc = xmlBufferAllocScheme;F     ret->content = (xmlChar *) xmlMalloc(ret->size * sizeof(xmlChar));     if (ret->content == NULL) {e7 	fprintf(stderr, "xmlBufferCreate : out of memory!\n");B 	xmlFree(ret);         return(NULL);o     }C     ret->content[0] = 0;     return(ret); }r   /**   * xmlBufferCreateSize:=   * @size: initial size of buffer  *#  * routine to create an XML buffer.=  * returns the new structure.N  */{ xmlBufferPtr" xmlBufferCreateSize(size_t size) {     xmlBufferPtr ret;a  6     ret = (xmlBufferPtr) xmlMalloc(sizeof(xmlBuffer));     if (ret == NULL) {>         fprintf(stderr, "xmlBufferCreate : out of memory!\n");         return(NULL);      }      ret->use = 0;-&     ret->alloc = xmlBufferAllocScheme;E     ret->size = (size ? size+2 : 0);         /* +1 for ending null */      if (ret->size){ J         ret->content = (xmlChar *) xmlMalloc(ret->size * sizeof(xmlChar));#         if (ret->content == NULL) { B             fprintf(stderr, "xmlBufferCreate : out of memory!\n");             xmlFree(ret);              return(NULL);c	         }e         ret->content[0] = 0;
     } else 	ret->content = NULL;      return(ret); }n   /**s   * xmlBufferSetAllocationScheme:  * @buf:  the buffer to free%  * @scheme:  allocation scheme to usea  *-  * Sets the allocation scheme for this bufferm  */e void/ xmlBufferSetAllocationScheme(xmlBufferPtr buf, a@                              xmlBufferAllocationScheme scheme) {     if (buf == NULL) { #ifdef DEBUG_BUFFERnG         fprintf(stderr, "xmlBufferSetAllocationScheme: buf == NULL\n");e #endif         return;r     }a       buf->alloc = scheme; }R   /**t  * xmlBufferFree:d  * @buf:  the buffer to free  *  * Frees an XML buffer.e  */l void! xmlBufferFree(xmlBufferPtr buf) {N     if (buf == NULL) { #ifdef DEBUG_BUFFERr8         fprintf(stderr, "xmlBufferFree: buf == NULL\n"); #endif 	return;     }      if (buf->content != NULL) {n #ifndef XML_USE_BUFFER_CONTENT3         memset(buf->content, -1, BASE_BUFFER_SIZE);  #elseD,         memset(buf->content, -1, buf->size); #endif         xmlFree(buf->content);     }U'     memset(buf, -1, sizeof(xmlBuffer));i     xmlFree(buf);i }i   /**r  * xmlBufferEmpty:  * @buf:  the buffer  *  * empty a buffer.  */  void" xmlBufferEmpty(xmlBufferPtr buf) {%     if (buf->content == NULL) return;i     buf->use = 0;n<     memset(buf->content, -1, buf->size);/* just for debug */ }s   /**   * xmlBufferShrink:a  * @buf:  the buffer to dump)  * @len:  the number of xmlChar to removei  *)  * Remove the beginning of an XML buffer.o  *C  * Returns the number of xmlChar removed, or -1 in case of failure.   */r int 5 xmlBufferShrink(xmlBufferPtr buf, unsigned int len) {      if (len == 0) return(0);#     if (len > buf->use) return(-1);        buf->use -= len;J     memmove(buf->content, &buf->content[len], buf->use * sizeof(xmlChar));       buf->content[buf->use] = 0;r     return(len); }t   /**r  * xmlBufferGrow:   * @buf:  the buffer*  * @len:  the minimum free sie to allocate  *-  * Grow the available space of an XML buffer.s  *9  * Returns the new available space or -1 in case of errort  */  intu3 xmlBufferGrow(xmlBufferPtr buf, unsigned int len) {a
     int size;h     xmlChar *newbuf;  #     if (len <= buf->use) return(0);t        size = buf->use + len + 100;  8     newbuf = (xmlChar *) xmlRealloc(buf->content, size);#     if (newbuf == NULL) return(-1);      buf->content = newbuf;     buf->size = size;t!     return(buf->size - buf->use);  }a   /**-  * xmlBufferDump:t  * @file:  the file output  * @buf:  the buffer to dump  *$  * Dumps an XML buffer to  a FILE *.(  * Returns the number of xmlChar written  */  int - xmlBufferDump(FILE *file, xmlBufferPtr buf) {N     int ret;       if (buf == NULL) { #ifdef DEBUG_BUFFERi8         fprintf(stderr, "xmlBufferDump: buf == NULL\n"); #endif 	return(0);c     }/     if (buf->content == NULL) {/ #ifdef DEBUG_BUFFEReA         fprintf(stderr, "xmlBufferDump: buf->content == NULL\n");a #endif 	return(0);      }t$     if (file == NULL) file = stdout;@     ret = fwrite(buf->content, sizeof(xmlChar), buf->use, file);     return(ret); }:   /**   * xmlBufferContent:  * @buf:  the buffer to resize  *  * Returns the internal content   */e   const xmlChar* f( xmlBufferContent(const xmlBufferPtr buf) {l     if(!buf)         return NULL;       return buf->content; }u   /**o  * xmlBufferLength:f  * @buf:  the buffer +  *5  * Returns the length of data in the internal content=  */s   int	' xmlBufferLength(const xmlBufferPtr buf)b {h     if(!buf)         return 0;e       return buf->use; }c   /**i  * xmlBufferResize:m  * @buf:  the buffer to resize  * @size:  the desired size/  *7  * Resize a buffer to accomodate minimum size of @size.e  *.  * Returns  0 in case of problems, 1 otherwise  */a int=4 xmlBufferResize(xmlBufferPtr buf, unsigned int size) {N     unsigned int newSize;i     xmlChar* rebuf = NULL;       /*take care of empty case*/;/     newSize = (buf->size ? buf->size*2 : size);s  *     /* Don't resize if we don't have to */     if (size < buf->size)          return 1;}       /* figure out new size */l     switch (buf->alloc){#     case XML_BUFFER_ALLOC_DOUBLEIT:f,         while (size > newSize) newSize *= 2;         break;      case XML_BUFFER_ALLOC_EXACT:         newSize = size+10;         break;     default:         newSize = size+10;         break;     }N       if (buf->content == NULL)o: 	rebuf = (xmlChar *) xmlMalloc(newSize * sizeof(xmlChar));     else. 	rebuf = (xmlChar *) xmlRealloc(buf->content, & 				       newSize * sizeof(xmlChar));     if (rebuf == NULL) {;         fprintf(stderr, "xmlBufferAdd : out of memory!\n");n         return 0;e     }=     buf->content = rebuf;0     buf->size = newSize;  
     return 1;z }c   /**	  * xmlBufferAdd:  * @buf:  the buffer to dump  * @str:  the xmlChar string&  * @len:  the number of xmlChar to add  *C  * Add a string range to an XML buffer. if len == -1, the lenght of	  * str is recomputed.)  */	 void= xmlBufferAdd(xmlBufferPtr buf, const xmlChar *str, int len) {o     unsigned int needSize;       if (str == NULL) { #ifdef DEBUG_BUFFER=7         fprintf(stderr, "xmlBufferAdd: str == NULL\n");v #endif 	return;     }n     if (len < -1) {- #ifdef DEBUG_BUFFERC3         fprintf(stderr, "xmlBufferAdd: len < 0\n");  #endif 	return;     }      if (len == 0) return;w       if (len < 0)         len = xmlStrlen(str);=       if (len <= 0) return;?  "     needSize = buf->use + len + 2;     if (needSize > buf->size){-         if (!xmlBufferResize(buf, needSize)){z?             fprintf(stderr, "xmlBufferAdd : out of memory!\n");a             return;e	         })     }   ?     memmove(&buf->content[buf->use], str, len*sizeof(xmlChar));o     buf->use += len;     buf->content[buf->use] = 0;	 }u   /**o  * xmlBufferAddHead:  * @buf:  the buffer  * @str:  the xmlChar string&  * @len:  the number of xmlChar to add  *8  * Add a string range to the beginning of an XML buffer.2  * if len == -1, the lenght of @str is recomputed.  */u voidA xmlBufferAddHead(xmlBufferPtr buf, const xmlChar *str, int len) {t     unsigned int needSize;       if (str == NULL) { #ifdef DEBUG_BUFFER)7         fprintf(stderr, "xmlBufferAdd: str == NULL\n");  #endif 	return;     }l     if (len < -1) {  #ifdef DEBUG_BUFFER 3         fprintf(stderr, "xmlBufferAdd: len < 0\n");) #endif 	return;     }      if (len == 0) return;/       if (len < 0)         len = xmlStrlen(str);e       if (len <= 0) return;s  "     needSize = buf->use + len + 2;     if (needSize > buf->size){-         if (!xmlBufferResize(buf, needSize)){	C             fprintf(stderr, "xmlBufferAddHead : out of memory!\n");x             return; 	         }e     }t  N     memmove(&buf->content[len], &buf->content[0], buf->use * sizeof(xmlChar));:     memmove(&buf->content[0], str, len * sizeof(xmlChar));     buf->use += len;     buf->content[buf->use] = 0;  }@   /**t  * xmlBufferCat:  * @buf:  the buffer to dump  * @str:  the xmlChar string  *4  * Append a zero terminated string to an XML buffer.  */a void4 xmlBufferCat(xmlBufferPtr buf, const xmlChar *str) {     if (str != NULL) 	xmlBufferAdd(buf, str, -1); }u   /**h  * xmlBufferCCat:t  * @buf:  the buffer to dump  * @str:  the C char stringA  *6  * Append a zero terminated C string to an XML buffer.  */m void2 xmlBufferCCat(xmlBufferPtr buf, const char *str) {     const char *cur;       if (str == NULL) { #ifdef DEBUG_BUFFERp7         fprintf(stderr, "xmlBufferAdd: str == NULL\n");p #endif 	return;     }o%     for (cur = str;*cur != 0;cur++) {r*         if (buf->use  + 10 >= buf->size) {4             if (!xmlBufferResize(buf, buf->use+10)){D                 fprintf(stderr, "xmlBufferCCat : out of memory!\n");                 return;l
             }e	         }s(         buf->content[buf->use++] = *cur;     }= }L   /**   * xmlBufferWriteCHAR:  * @buf:  the XML buffer  * @string:  the string to add  *@  * routine which manage and grows an output buffer. This one add%  * xmlChars at the end of the buffer.!  */L void@ xmlBufferWriteCHAR_ZZ(xmlBufferPtr buf, const xmlChar *string) {     xmlBufferCat(buf, string); }n   /**t  * xmlBufferWriteChar:  * @buf:  the XML buffer output*  * @string:  the string to add  *@  * routine which manage and grows an output buffer. This one add#  * C chars at the end of the array.o  */* void: xmlBufferWriteChar(xmlBufferPtr buf, const char *string) {     xmlBufferCCat(buf, string);D }e     /**u  * xmlBufferWriteQuotedString:  * @buf:  the XML buffer output*  * @string:  the string to add  *C  * routine which manage and grows an output buffer. This one writesNG  * a quoted or double quoted xmlChar string, checking first if it holdsA$  * quote or double-quotes internally  */( voidE xmlBufferWriteQuotedString(xmlBufferPtr buf, const xmlChar *string) { !     if (xmlStrchr(string, '"')) { &         if (xmlStrchr(string, '\'')) { #ifdef DEBUG_BUFFER) 	    fprintf(stderr,L  "xmlBufferWriteQuotedString: string contains quote and double-quotes !\n"); #endif 	}          xmlBufferCCat(buf, "'");"         xmlBufferCat(buf, string);          xmlBufferCCat(buf, "'");     } else {!         xmlBufferCCat(buf, "\"");("         xmlBufferCat(buf, string);!         xmlBufferCCat(buf, "\"");u     }a }i    I /************************************************************************   *									*5  *   		Dumping XML tree content to a simple buffer		*   *									*J  ************************************************************************/   voidG xmlNodeDump(xmlBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur, int level,=             int format); static void-K xmlNodeListDump(xmlBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur, int level,u                 int format); void> htmlNodeDump(xmlBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur);   /**t  * xmlGlobalNsDump:*  * @buf:  the XML buffer outputs  * @cur:  a namespace   *A  * Dump a global Namespace, this is the old version based on PIs.a  */b static void 1 xmlGlobalNsDump(xmlBufferPtr buf, xmlNsPtr cur) {u     if (cur == NULL) { #ifdef DEBUG_TREE :         fprintf(stderr, "xmlGlobalNsDump : Ns == NULL\n"); #endif 	return;     }s,     if (cur->type == XML_GLOBAL_NAMESPACE) {( 	xmlBufferWriteChar(buf, "<?namespace"); 	if (cur->href != NULL) {t' 	    xmlBufferWriteChar(buf, " href=");p0 	    xmlBufferWriteQuotedString(buf, cur->href); 	} 	if (cur->prefix != NULL) {p% 	    xmlBufferWriteChar(buf, " AS="); 2 	    xmlBufferWriteQuotedString(buf, cur->prefix); 	}! 	xmlBufferWriteChar(buf, "?>\n");      }p }    /**)  * xmlGlobalNsListDump:   * @buf:  the XML buffer outputs  * @cur:  the first namespacer  *I  * Dump a list of global Namespace, this is the old version based on PIs.   */h static voidr5 xmlGlobalNsListDump(xmlBufferPtr buf, xmlNsPtr cur) {m     while (cur != NULL) { "         xmlGlobalNsDump(buf, cur); 	cur = cur->next;e     }r }    /**c
  * xmlNsDump:   * @buf:  the XML buffer outputa  * @cur:  a namespacep  *%  * Dump a local Namespace definition.=7  * Should be called in the context of attributes dumps.   */r static voide+ xmlNsDump(xmlBufferPtr buf, xmlNsPtr cur) {(     if (cur == NULL) { #ifdef DEBUG_TREE 4         fprintf(stderr, "xmlNsDump : Ns == NULL\n"); #endif 	return;     }a+     if (cur->type == XML_LOCAL_NAMESPACE) {o9         /* Within the context of an element attributes */f 	if (cur->prefix != NULL) {A( 	    xmlBufferWriteChar(buf, " xmlns:");* 	    xmlBufferWriteCHAR(buf, cur->prefix); 	} elses' 	    xmlBufferWriteChar(buf, " xmlns");  	xmlBufferWriteChar(buf, "=");, 	xmlBufferWriteQuotedString(buf, cur->href);     }d }>   /**e  * xmlNsListDump:)  * @buf:  the XML buffer output   * @cur:  the first namespaceT  *.  * Dump a list of local Namespace definitions.7  * Should be called in the context of attributes dumps.f  */  static voidx/ xmlNsListDump(xmlBufferPtr buf, xmlNsPtr cur) {x     while (cur != NULL) {a         xmlNsDump(buf, cur); 	cur = cur->next;X     }  }*   /**P  * xmlDtdDump:  * @buf:  the XML buffer outputu  * @doc:  the document  * r%  * Dump the XML document DTD, if any.a  */u static void - xmlDtdDump(xmlBufferPtr buf, xmlDtdPtr dtd) {*     if (dtd == NULL) { #ifdef DEBUG_TREE =         fprintf(stderr, "xmlDtdDump : no internal subset\n");o #endif 	return;     } *     xmlBufferWriteChar(buf, "<!DOCTYPE ");'     xmlBufferWriteCHAR(buf, dtd->name);o"     if (dtd->ExternalID != NULL) {% 	xmlBufferWriteChar(buf, " PUBLIC ");o2 	xmlBufferWriteQuotedString(buf, dtd->ExternalID); 	xmlBufferWriteChar(buf, " ");0 	xmlBufferWriteQuotedString(buf, dtd->SystemID);(     }  else if (dtd->SystemID != NULL) {% 	xmlBufferWriteChar(buf, " SYSTEM ");)0 	xmlBufferWriteQuotedString(buf, dtd->SystemID);     }	=     if ((dtd->entities == NULL) && (dtd->elements == NULL) &&L@         (dtd->attributes == NULL) && (dtd->notations == NULL)) { 	xmlBufferWriteChar(buf, ">"); 	return;     } $     xmlBufferWriteChar(buf, " [\n");9     xmlNodeListDump(buf, dtd->doc, dtd->children, -1, 0);u #if 0l     if (dtd->entities != NULL)@ 	xmlDumpEntitiesTable(buf, (xmlEntitiesTablePtr) dtd->entities);     if (dtd->notations != NULL)PA 	xmlDumpNotationTable(buf, (xmlNotationTablePtr) dtd->notations);=     if (dtd->elements != NULL)> 	xmlDumpElementTable(buf, (xmlElementTablePtr) dtd->elements);      if (dtd->attributes != NULL)D 	xmlDumpAttributeTable(buf, (xmlAttributeTablePtr) dtd->attributes); #endif"     xmlBufferWriteChar(buf, "]>"); }m   /**k  * xmlAttrDump:o  * @buf:  the XML buffer outputf  * @doc:  the document  * @cur:  the attribute pointerE  *  * Dump an XML attribute  */> static voidL> xmlAttrDump(xmlBufferPtr buf, xmlDocPtr doc, xmlAttrPtr cur) {     xmlChar *value;u       if (cur == NULL) { #ifdef DEBUG_TREEn<         fprintf(stderr, "xmlAttrDump : property == NULL\n"); #endif 	return;     } !     xmlBufferWriteChar(buf, " ");*9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {n1         xmlBufferWriteCHAR(buf, cur->ns->prefix);c 	xmlBufferWriteChar(buf, ":");     } '     xmlBufferWriteCHAR(buf, cur->name);d8     value = xmlNodeListGetString(doc, cur->children, 0);     if (value) { 	xmlBufferWriteChar(buf, "=");( 	xmlBufferWriteQuotedString(buf, value); 	xmlFree(value);
     } else  { " 	xmlBufferWriteChar(buf, "=\"\"");     }N }T   /**o  * xmlAttrListDump:c  * @buf:  the XML buffer output   * @doc:  the document%  * @cur:  the first attribute pointer   *   * Dump a list of XML attributes  */* static void*B xmlAttrListDump(xmlBufferPtr buf, xmlDocPtr doc, xmlAttrPtr cur) {     if (cur == NULL) { #ifdef DEBUG_TREE*@         fprintf(stderr, "xmlAttrListDump : property == NULL\n"); #endif 	return;     }      while (cur != NULL) { #         xmlAttrDump(buf, doc, cur);f 	cur = cur->next;e     }r }u       /**   * xmlNodeListDump:e  * @buf:  the XML buffer outputr  * @doc:  the document  * @cur:  the first node.  * @level: the imbrication level for indenting!  * @format: is formatting allowedm  *G  * Dump an XML node list, recursive behaviour,children are printed too.z  */A static voidEK xmlNodeListDump(xmlBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur, int level,l                 int format) {a
     int i;       if (cur == NULL) { #ifdef DEBUG_TREE"<         fprintf(stderr, "xmlNodeListDump : node == NULL\n"); #endif 	return;     }      while (cur != NULL) { ) 	if ((format) && (xmlIndentTreeOutput) &&a% 	    (cur->type == XML_ELEMENT_NODE))f 	    for (i = 0;i < level;i++)  		xmlBufferWriteChar(buf, "  ");2         xmlNodeDump(buf, doc, cur, level, format); 	if (format) {# 	    xmlBufferWriteChar(buf, "\n");x 	} 	cur = cur->next;s     }m }f   /**   * xmlNodeDump:L  * @buf:  the XML buffer outputl  * @doc:  the document  * @cur:  the current node.  * @level: the imbrication level for indenting!  * @format: is formatting allowed-  *B  * Dump an XML node, recursive behaviour,children are printed too.  */s voidG xmlNodeDump(xmlBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur, int level,)             int format) {t
     int i;     xmlNodePtr tmp;(       if (cur == NULL) { #ifdef DEBUG_TREE;8         fprintf(stderr, "xmlNodeDump : node == NULL\n"); #endif 	return;     }c$     if (cur->type == XML_DTD_NODE) {)         xmlDtdDump(buf, (xmlDtdPtr) cur);  	return;     }l(     if (cur->type == XML_ELEMENT_DECL) {5         xmlDumpElementDecl(buf, (xmlElementPtr) cur);  	return;     }h*     if (cur->type == XML_ATTRIBUTE_DECL) {9         xmlDumpAttributeDecl(buf, (xmlAttributePtr) cur);  	return;     }r'     if (cur->type == XML_ENTITY_DECL) {=3         xmlDumpEntityDecl(buf, (xmlEntityPtr) cur);r 	return;     }l%     if (cur->type == XML_TEXT_NODE) {f 	if (cur->content != NULL) {             xmlChar *buffer;   #ifndef XML_USE_BUFFER_CONTENTC             buffer = xmlEncodeEntitiesReentrant(doc, cur->content);B #elsee. 	    buffer = xmlEncodeEntitiesReentrant(doc, ) 					    xmlBufferContent(cur->content));r #endif 	    if (buffer != NULL) {" 		xmlBufferWriteCHAR(buf, buffer); 		xmlFree(buffer); 	    } 	} 	return;     }N#     if (cur->type == XML_PI_NODE) {, 	if (cur->content != NULL) {# 	    xmlBufferWriteChar(buf, "<?");>( 	    xmlBufferWriteCHAR(buf, cur->name);  	    if (cur->content != NULL) { 		xmlBufferWriteChar(buf, " ");( #ifndef XML_USE_BUFFER_CONTENT( 		xmlBufferWriteCHAR(buf, cur->content); #elsee: 		xmlBufferWriteCHAR(buf, xmlBufferContent(cur->content)); #endif 	    }# 	    xmlBufferWriteChar(buf, "?>"); 	 	} else {f# 	    xmlBufferWriteChar(buf, "<?"); ( 	    xmlBufferWriteCHAR(buf, cur->name);# 	    xmlBufferWriteChar(buf, "?>");e 	} 	return;     }C(     if (cur->type == XML_COMMENT_NODE) { 	if (cur->content != NULL) {% 	    xmlBufferWriteChar(buf, "<!--");r #ifndef XML_USE_BUFFER_CONTENT+ 	    xmlBufferWriteCHAR(buf, cur->content);n #elsel= 	    xmlBufferWriteCHAR(buf, xmlBufferContent(cur->content));e #endif$ 	    xmlBufferWriteChar(buf, "-->"); 	} 	return;     }>+     if (cur->type == XML_ENTITY_REF_NODE) { %         xmlBufferWriteChar(buf, "&");e$ 	xmlBufferWriteCHAR(buf, cur->name);%         xmlBufferWriteChar(buf, ";");h 	return;     }e.     if (cur->type == XML_CDATA_SECTION_NODE) {-         xmlBufferWriteChar(buf, "<![CDATA[");b 	if (cur->content != NULL) #ifndef XML_USE_BUFFER_CONTENT+ 	    xmlBufferWriteCHAR(buf, cur->content);n #elseh= 	    xmlBufferWriteCHAR(buf, xmlBufferContent(cur->content));  #endif'         xmlBufferWriteChar(buf, "]]>");= 	return;     }e       if (format == 1) { 	tmp = cur->children;L 	while (tmp != NULL) {) 	    if ((tmp->type == XML_TEXT_NODE) ||  ' 		(tmp->type == XML_ENTITY_REF_NODE)) { 
 		format = 0;f 		break; 	    } 	    tmp = tmp->next;@ 	}     }u!     xmlBufferWriteChar(buf, "<");u9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {n1         xmlBufferWriteCHAR(buf, cur->ns->prefix);r 	xmlBufferWriteChar(buf, ":");     }=  '     xmlBufferWriteCHAR(buf, cur->name);i     if (cur->nsDef)r'         xmlNsListDump(buf, cur->nsDef);)      if (cur->properties != NULL)3         xmlAttrListDump(buf, doc, cur->properties);e  <     if ((cur->content == NULL) && (cur->children == NULL) && 	(!xmlSaveNoEmptyTags)) {=&         xmlBufferWriteChar(buf, "/>"); 	return;     }z!     xmlBufferWriteChar(buf, ">");      if (cur->content != NULL) {u 	xmlChar *buffer;u   #ifndef XML_USE_BUFFER_CONTENT8 	buffer = xmlEncodeEntitiesReentrant(doc, cur->content); #elseC* 	buffer = xmlEncodeEntitiesReentrant(doc, > 		                            xmlBufferContent(cur->content)); #endif 	if (buffer != NULL) {% 	    xmlBufferWriteCHAR(buf, buffer);n 	    xmlFree(buffer);r 	}     }=      if (cur->children != NULL) {+ 	if (format) xmlBufferWriteChar(buf, "\n"); ) 	xmlNodeListDump(buf, doc, cur->children, + 		        (level >= 0?level+1:-1), format);u' 	if ((xmlIndentTreeOutput) && (format))z 	    for (i = 0;i < level;i++)  		xmlBufferWriteChar(buf, "  ");     }R"     xmlBufferWriteChar(buf, "</");9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {n1         xmlBufferWriteCHAR(buf, cur->ns->prefix);m 	xmlBufferWriteChar(buf, ":");     }   '     xmlBufferWriteCHAR(buf, cur->name);?!     xmlBufferWriteChar(buf, ">");n }r   /**f  * xmlElemDump: !  * @f:  the FILE * for the output   * @doc:  the document  * @cur:  the current node  *G  * Dump an XML/HTML node, recursive behaviour,children are printed too.s  */  void5 xmlElemDump(FILE *f, xmlDocPtr doc, xmlNodePtr cur) {L     xmlBufferPtr buf;S       if (cur == NULL) { #ifdef DEBUG_TREE 7         fprintf(stderr, "xmlElemDump : cur == NULL\n");  #endif 	return;     }o     if (doc == NULL) { #ifdef DEBUG_TREEs7         fprintf(stderr, "xmlElemDump : doc == NULL\n");o #endif     }      buf = xmlBufferCreate();     if (buf == NULL) return;     if ((doc != NULL) && e0         (doc->type == XML_HTML_DOCUMENT_NODE)) { #ifdef LIBXML_HTML_ENABLED$         htmlNodeDump(buf, doc, cur); #else	* 	printf("HTML support not compiled in\n");  #endif /* LIBXML_HTML_ENABLED */
     } else)         xmlNodeDump(buf, doc, cur, 0, 1);m     xmlBufferDump(f, buf);     xmlBufferFree(buf);f }    /**=  * xmlDocContentDump:*  * @buf:  the XML buffer output   * @cur:  the document  *  * Dump an XML document.  */  static voidn4 xmlDocContentDump(xmlBufferPtr buf, xmlDocPtr cur) {.     xmlBufferWriteChar(buf, "<?xml version=");     if (cur->version != NULL) / 	xmlBufferWriteQuotedString(buf, cur->version);G     else$ 	xmlBufferWriteChar(buf, "\"1.0\"");      if (cur->encoding != NULL) {.         xmlBufferWriteChar(buf, " encoding=");0 	xmlBufferWriteQuotedString(buf, cur->encoding);     }0     switch (cur->standalone) {         case 0: 3 	    xmlBufferWriteChar(buf, " standalone=\"no\"");r 	    break;e         case 1: 4 	    xmlBufferWriteChar(buf, " standalone=\"yes\""); 	    break;      }u$     xmlBufferWriteChar(buf, "?>\n");      if (cur->children != NULL) {)         xmlNodePtr child = cur->children;   0 	/* global namespace definitions, the old way */ 	if (oldXMLWDcompatibility) * 	    xmlGlobalNsListDump(buf, cur->oldNs); 	else  	    xmlUpgradeOldNs(cur); 	* 	while (child != NULL) {( 	    xmlNodeDump(buf, cur, child, 0, 1);# 	    xmlBufferWriteChar(buf, "\n");. 	    child = child->next;e 	}     }r }   I /************************************************************************t  *									*9  *   		Dumping XML tree content to an I/O output buffer	*:  *									*J  ************************************************************************/   voidH xmlNodeDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur,?                   int level, int format, const char *encoding);r static void L xmlNodeListDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur,?                   int level, int format, const char *encoding);	 /**   * xmlGlobalNsDumpOutput:l  * @buf:  the XML buffer output)  * @cur:  a namespace   *A  * Dump a global Namespace, this is the old version based on PIs.]  */- static void(= xmlGlobalNsDumpOutput(xmlOutputBufferPtr buf, xmlNsPtr cur) {C     if (cur == NULL) { #ifdef DEBUG_TREEe:         fprintf(stderr, "xmlGlobalNsDump : Ns == NULL\n"); #endif 	return;     }t,     if (cur->type == XML_GLOBAL_NAMESPACE) {0 	xmlOutputBufferWriteString(buf, "<?namespace"); 	if (cur->href != NULL) {,/ 	    xmlOutputBufferWriteString(buf, " href=");l8 	    xmlBufferWriteQuotedString(buf->buffer, cur->href); 	} 	if (cur->prefix != NULL) {@- 	    xmlOutputBufferWriteString(buf, " AS=");t: 	    xmlBufferWriteQuotedString(buf->buffer, cur->prefix); 	}) 	xmlOutputBufferWriteString(buf, "?>\n");o     }r }u   /**   * xmlGlobalNsListDumpOutput:B  * @buf:  the XML buffer outputr  * @cur:  the first namespace)  *I  * Dump a list of global Namespace, this is the old version based on PIs.f  */- static void A xmlGlobalNsListDumpOutput(xmlOutputBufferPtr buf, xmlNsPtr cur) {      while (cur != NULL) {e(         xmlGlobalNsDumpOutput(buf, cur); 	cur = cur->next;u     }  }    /**e  * xmlNsDumpOutput:   * @buf:  the XML buffer output   * @cur:  a namespacex  *%  * Dump a local Namespace definition.r7  * Should be called in the context of attributes dumps.n  */n static voidt7 xmlNsDumpOutput(xmlOutputBufferPtr buf, xmlNsPtr cur) {u     if (cur == NULL) { #ifdef DEBUG_TREEm4         fprintf(stderr, "xmlNsDump : Ns == NULL\n"); #endif 	return;     } D     if ((cur->type == XML_LOCAL_NAMESPACE) && (cur->href != NULL)) {9         /* Within the context of an element attributes */r 	if (cur->prefix != NULL) {e0 	    xmlOutputBufferWriteString(buf, " xmlns:");@ 	    xmlOutputBufferWriteString(buf, (const char *)cur->prefix); 	} elsef/ 	    xmlOutputBufferWriteString(buf, " xmlns");r& 	xmlOutputBufferWriteString(buf, "=");4 	xmlBufferWriteQuotedString(buf->buffer, cur->href);     }w }h   /**   * xmlNsListDumpOutput:r  * @buf:  the XML buffer outputr  * @cur:  the first namespacec  *.  * Dump a list of local Namespace definitions.7  * Should be called in the context of attributes dumps.u  */t static voidx; xmlNsListDumpOutput(xmlOutputBufferPtr buf, xmlNsPtr cur) {      while (cur != NULL) {'"         xmlNsDumpOutput(buf, cur); 	cur = cur->next;B     }i }u   /**i  * xmlDtdDumpOutput:  * @buf:  the XML buffer outputd  * @doc:  the document*  * @encoding:  an optional encoding string  * g%  * Dump the XML document DTD, if any.   */l static void O xmlDtdDumpOutput(xmlOutputBufferPtr buf, xmlDtdPtr dtd, const char *encoding) {C     if (dtd == NULL) { #ifdef DEBUG_TREE*=         fprintf(stderr, "xmlDtdDump : no internal subset\n");  #endif 	return;     }m2     xmlOutputBufferWriteString(buf, "<!DOCTYPE ");=     xmlOutputBufferWriteString(buf, (const char *)dtd->name);*"     if (dtd->ExternalID != NULL) {- 	xmlOutputBufferWriteString(buf, " PUBLIC "); : 	xmlBufferWriteQuotedString(buf->buffer, dtd->ExternalID);& 	xmlOutputBufferWriteString(buf, " ");8 	xmlBufferWriteQuotedString(buf->buffer, dtd->SystemID);(     }  else if (dtd->SystemID != NULL) {- 	xmlOutputBufferWriteString(buf, " SYSTEM ");x8 	xmlBufferWriteQuotedString(buf->buffer, dtd->SystemID);     }a=     if ((dtd->entities == NULL) && (dtd->elements == NULL) &&o@         (dtd->attributes == NULL) && (dtd->notations == NULL)) {& 	xmlOutputBufferWriteString(buf, ">"); 	return;     }B,     xmlOutputBufferWriteString(buf, " [\n");I     xmlNodeListDumpOutput(buf, dtd->doc, dtd->children, -1, 0, encoding);G #if 0A     if (dtd->entities != NULL)@ 	xmlDumpEntitiesTable(buf, (xmlEntitiesTablePtr) dtd->entities);     if (dtd->notations != NULL)lA 	xmlDumpNotationTable(buf, (xmlNotationTablePtr) dtd->notations);U     if (dtd->elements != NULL)> 	xmlDumpElementTable(buf, (xmlElementTablePtr) dtd->elements);      if (dtd->attributes != NULL)D 	xmlDumpAttributeTable(buf, (xmlAttributeTablePtr) dtd->attributes); #endif*     xmlOutputBufferWriteString(buf, "]>"); }    /**   * xmlAttrDumpOutput:a  * @buf:  the XML buffer output   * @doc:  the document  * @cur:  the attribute pointere*  * @encoding:  an optional encoding string  *  * Dump an XML attribute  */( static voidcH xmlAttrDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc, xmlAttrPtr cur," 	          const char *encoding) {     xmlChar *value;        if (cur == NULL) { #ifdef DEBUG_TREEn<         fprintf(stderr, "xmlAttrDump : property == NULL\n"); #endif 	return;     }N)     xmlOutputBufferWriteString(buf, " ");f9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {LG         xmlOutputBufferWriteString(buf, (const char *)cur->ns->prefix);E& 	xmlOutputBufferWriteString(buf, ":");     }n=     xmlOutputBufferWriteString(buf, (const char *)cur->name);r8     value = xmlNodeListGetString(doc, cur->children, 0);     if (value) {& 	xmlOutputBufferWriteString(buf, "=");0 	xmlBufferWriteQuotedString(buf->buffer, value); 	xmlFree(value);
     } else  { * 	xmlOutputBufferWriteString(buf, "=\"\"");     }h }M   /**r  * xmlAttrListDumpOutput:s  * @buf:  the XML buffer outputo  * @doc:  the document%  * @cur:  the first attribute pointere*  * @encoding:  an optional encoding string  *   * Dump a list of XML attributes  */c static voidh< xmlAttrListDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc,6 	              xmlAttrPtr cur, const char *encoding) {     if (cur == NULL) { #ifdef DEBUG_TREEe@         fprintf(stderr, "xmlAttrListDump : property == NULL\n"); #endif 	return;     }t     while (cur != NULL) { 3         xmlAttrDumpOutput(buf, doc, cur, encoding);i 	cur = cur->next;D     }o }t       /**t  * xmlNodeListDumpOutput:   * @buf:  the XML buffer output   * @doc:  the document  * @cur:  the first node.  * @level: the imbrication level for indenting!  * @format: is formatting allowed *  * @encoding:  an optional encoding string  *G  * Dump an XML node list, recursive behaviour,children are printed too.>  */m static voide< xmlNodeListDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc,N                 xmlNodePtr cur, int level, int format, const char *encoding) {
     int i;       if (cur == NULL) { #ifdef DEBUG_TREE <         fprintf(stderr, "xmlNodeListDump : node == NULL\n"); #endif 	return;     }"     while (cur != NULL) { ) 	if ((format) && (xmlIndentTreeOutput) &&d% 	    (cur->type == XML_ELEMENT_NODE))  	    for (i = 0;i < level;i++)( 		xmlOutputBufferWriteString(buf, "  ");B         xmlNodeDumpOutput(buf, doc, cur, level, format, encoding); 	if (format) {+ 	    xmlOutputBufferWriteString(buf, "\n");> 	} 	cur = cur->next;t     }e }    /**)  * xmlNodeDumpOutput:b  * @buf:  the XML buffer outputm  * @doc:  the document  * @cur:  the current node.  * @level: the imbrication level for indenting!  * @format: is formatting allowedi*  * @encoding:  an optional encoding string  *B  * Dump an XML node, recursive behaviour,children are printed too.  */  voidH xmlNodeDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc, xmlNodePtr cur,:             int level, int format, const char *encoding) {
     int i;     xmlNodePtr tmp;N       if (cur == NULL) { #ifdef DEBUG_TREEt8         fprintf(stderr, "xmlNodeDump : node == NULL\n"); #endif 	return;     }W$     if (cur->type == XML_DTD_NODE) {9         xmlDtdDumpOutput(buf, (xmlDtdPtr) cur, encoding);e 	return;     }u(     if (cur->type == XML_ELEMENT_DECL) {=         xmlDumpElementDecl(buf->buffer, (xmlElementPtr) cur);a 	return;     }G*     if (cur->type == XML_ATTRIBUTE_DECL) {A         xmlDumpAttributeDecl(buf->buffer, (xmlAttributePtr) cur);( 	return;     }l'     if (cur->type == XML_ENTITY_DECL) {r;         xmlDumpEntityDecl(buf->buffer, (xmlEntityPtr) cur);p 	return;     } %     if (cur->type == XML_TEXT_NODE) {e 	if (cur->content != NULL) {             xmlChar *buffer;   #ifndef XML_USE_BUFFER_CONTENT 	    if (encoding == NULL)9 		buffer = xmlEncodeEntitiesReentrant(doc, cur->content); 	 	    else 4 		buffer = xmlEncodeSpecialChars(doc, cur->content); #else: 	    if (encoding == NULL)+ 		buffer = xmlEncodeEntitiesReentrant(doc,  ( 				    xmlBufferContent(cur->content));	 	    else>& 		buffer = xmlEncodeSpecialChars(doc, ( 				    xmlBufferContent(cur->content)); #endif 	    if (buffer != NULL) {8 		xmlOutputBufferWriteString(buf, (const char *)buffer); 		xmlFree(buffer); 	    } 	} 	return;     } #     if (cur->type == XML_PI_NODE) {e 	if (cur->content != NULL) {+ 	    xmlOutputBufferWriteString(buf, "<?");B> 	    xmlOutputBufferWriteString(buf, (const char *)cur->name);  	    if (cur->content != NULL) {' 		xmlOutputBufferWriteString(buf, " ");G #ifndef XML_USE_BUFFER_CONTENT> 		xmlOutputBufferWriteString(buf, (const char *)cur->content); #elselP 		xmlOutputBufferWriteString(buf, (const char *)xmlBufferContent(cur->content)); #endif 	    }+ 	    xmlOutputBufferWriteString(buf, "?>");f	 	} else {r+ 	    xmlOutputBufferWriteString(buf, "<?");u> 	    xmlOutputBufferWriteString(buf, (const char *)cur->name);+ 	    xmlOutputBufferWriteString(buf, "?>");  	} 	return;     }p(     if (cur->type == XML_COMMENT_NODE) { 	if (cur->content != NULL) {- 	    xmlOutputBufferWriteString(buf, "<!--");v #ifndef XML_USE_BUFFER_CONTENTA 	    xmlOutputBufferWriteString(buf, (const char *)cur->content);c #else S 	    xmlOutputBufferWriteString(buf, (const char *)xmlBufferContent(cur->content));  #endif, 	    xmlOutputBufferWriteString(buf, "-->"); 	} 	return;     }p+     if (cur->type == XML_ENTITY_REF_NODE) {E-         xmlOutputBufferWriteString(buf, "&"); : 	xmlOutputBufferWriteString(buf, (const char *)cur->name);-         xmlOutputBufferWriteString(buf, ";");t 	return;     }t.     if (cur->type == XML_CDATA_SECTION_NODE) {5         xmlOutputBufferWriteString(buf, "<![CDATA[");  	if (cur->content != NULL) #ifndef XML_USE_BUFFER_CONTENTA 	    xmlOutputBufferWriteString(buf, (const char *)cur->content);  #elserS 	    xmlOutputBufferWriteString(buf, (const char *)xmlBufferContent(cur->content));( #endif/         xmlOutputBufferWriteString(buf, "]]>");  	return;     }        if (format == 1) { 	tmp = cur->children;C 	while (tmp != NULL) {) 	    if ((tmp->type == XML_TEXT_NODE) || =' 		(tmp->type == XML_ENTITY_REF_NODE)) {t
 		format = 0;  		break; 	    } 	    tmp = tmp->next;d 	}     } )     xmlOutputBufferWriteString(buf, "<");f9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {fG         xmlOutputBufferWriteString(buf, (const char *)cur->ns->prefix); & 	xmlOutputBufferWriteString(buf, ":");     }{  =     xmlOutputBufferWriteString(buf, (const char *)cur->name);u     if (cur->nsDef)i-         xmlNsListDumpOutput(buf, cur->nsDef);r      if (cur->properties != NULL)C         xmlAttrListDumpOutput(buf, doc, cur->properties, encoding);f  <     if ((cur->content == NULL) && (cur->children == NULL) && 	(!xmlSaveNoEmptyTags)) {(.         xmlOutputBufferWriteString(buf, "/>"); 	return;     } )     xmlOutputBufferWriteString(buf, ">");      if (cur->content != NULL) {  	xmlChar *buffer;C   #ifndef XML_USE_BUFFER_CONTENT 	if (encoding == NULL)< 	    buffer = xmlEncodeEntitiesReentrant(doc, cur->content); 	elseS7 	    buffer = xmlEncodeSpecialChars(doc, cur->content);n #elsee 	if (encoding == NULL). 	    buffer = xmlEncodeEntitiesReentrant(doc, $ 				xmlBufferContent(cur->content)); 	else}) 	    buffer = xmlEncodeSpecialChars(doc, L$ 				xmlBufferContent(cur->content)); #endif 	if (buffer != NULL) {; 	    xmlOutputBufferWriteString(buf, (const char *)buffer);  	    xmlFree(buffer);e 	}     }u      if (cur->children != NULL) {3 	if (format) xmlOutputBufferWriteString(buf, "\n");i/ 	xmlNodeListDumpOutput(buf, doc, cur->children,C5 		        (level >= 0?level+1:-1), format, encoding);e' 	if ((xmlIndentTreeOutput) && (format))f 	    for (i = 0;i < level;i++)( 		xmlOutputBufferWriteString(buf, "  ");     }t*     xmlOutputBufferWriteString(buf, "</");9     if ((cur->ns != NULL) && (cur->ns->prefix != NULL)) {tG         xmlOutputBufferWriteString(buf, (const char *)cur->ns->prefix);o& 	xmlOutputBufferWriteString(buf, ":");     }e  =     xmlOutputBufferWriteString(buf, (const char *)cur->name);r)     xmlOutputBufferWriteString(buf, ">");  }    /**   * xmlDocContentDumpOutput:n  * @buf:  the XML buffer output(  * @cur:  the document*  * @encoding:  an optional encoding string  *  * Dump an XML document.  */D static void>> xmlDocContentDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr cur,( 	                const char *encoding) {6     xmlOutputBufferWriteString(buf, "<?xml version=");     if (cur->version != NULL) 7 	xmlBufferWriteQuotedString(buf->buffer, cur->version);      else, 	xmlOutputBufferWriteString(buf, "\"1.0\"");     if (encoding == NULL) {  	if (cur->encoding != NULL)E- 	    encoding = (const char *) cur->encoding;u1 	else if (cur->charset != XML_CHAR_ENCODING_UTF8)eG 	    encoding = xmlGetCharEncodingName((xmlCharEncoding) cur->charset);)     }d     if (encoding != NULL) { 6         xmlOutputBufferWriteString(buf, " encoding=");? 	xmlBufferWriteQuotedString(buf->buffer, (xmlChar *) encoding);x     }r     switch (cur->standalone) {         case 0:,; 	    xmlOutputBufferWriteString(buf, " standalone=\"no\"");u 	    break;d         case 1: < 	    xmlOutputBufferWriteString(buf, " standalone=\"yes\""); 	    break;;     }R,     xmlOutputBufferWriteString(buf, "?>\n");      if (cur->children != NULL) {)         xmlNodePtr child = cur->children;R  0 	/* global namespace definitions, the old way */ 	if (oldXMLWDcompatibility)W0 	    xmlGlobalNsListDumpOutput(buf, cur->oldNs); 	else  	    xmlUpgradeOldNs(cur); 	p 	while (child != NULL) {8 	    xmlNodeDumpOutput(buf, cur, child, 0, 1, encoding);+ 	    xmlOutputBufferWriteString(buf, "\n");v 	    child = child->next;i 	}     }  }   I /************************************************************************P  *									*$  *		Saving functions front-ends				*  *									*J  ************************************************************************/   /**o  * xmlDocDumpMemory:  * @cur:  the document!  * @mem:  OUT: the memory pointerU!  * @size:  OUT: the memory lenght   *I  * Dump an XML document in memory and return the xmlChar * and it's size. ,  * It's up to the caller to free the memory.  */d void: xmlDocDumpMemory(xmlDocPtr cur, xmlChar**mem, int *size) {     xmlBufferPtr buf;r       if (cur == NULL) { #ifdef DEBUG_TREE_A         fprintf(stderr, "xmlDocDumpMemory : document == NULL\n");  #endif
 	*mem = NULL;f 	*size = 0;f 	return;     }      buf = xmlBufferCreate();     if (buf == NULL) {
 	*mem = NULL;* 	*size = 0;o 	return;     }m      xmlDocContentDump(buf, cur);.     *mem = xmlStrndup(buf->content, buf->use);     *size = buf->use;e     xmlBufferFree(buf);r }n   /**   * xmlGetDocCompressMode:   * @doc:  the document  *7  * get the compression ratio for a document, ZLIB based,2  * Returns 0 (uncompressed) to 9 (max compression)  */m inte' xmlGetDocCompressMode (xmlDocPtr doc) {r      if (doc == NULL) return(-1);     return(doc->compression);s }d   /**{  * xmlSetDocCompressMode:l  * @doc:  the document   * @mode:  the compression ratio  *7  * set the compression ratio for a document, ZLIB based=:  * Correct values: 0 (uncompressed) to 9 (max compression)  */\ void1 xmlSetDocCompressMode (xmlDocPtr doc, int mode) {r     if (doc == NULL) return;'     if (mode < 0) doc->compression = 0;a,     else if (mode > 9) doc->compression = 9;!     else doc->compression = mode;e }    /**x  * xmlGetCompressMode:  *5  * get the default compression mode used, ZLIB based.d2  * Returns 0 (uncompressed) to 9 (max compression)  */d inti  xmlGetCompressMode(void) {      return(xmlCompressMode); }*   /***  * xmlSetCompressMode:   * @mode:  the compression ratio  *4  * set the default compression mode used, ZLIB based:  * Correct values: 0 (uncompressed) to 9 (max compression)  */* void xmlSetCompressMode(int mode) {&     if (mode < 0) xmlCompressMode = 0;+     else if (mode > 9) xmlCompressMode = 9;e      else xmlCompressMode = mode; }r   /**c  * xmlDocDump:  * @f:  the FILE*t  * @cur:  the document  *(  * Dump an XML document to an open FILE.  *@  * returns: the number of byte written or -1 in case of failure.  */t int*$ xmlDocDump(FILE *f, xmlDocPtr cur) {     xmlOutputBufferPtr buf;      const char * encoding;-     xmlCharEncodingHandlerPtr handler = NULL;i     int ret;       if (cur == NULL) { #ifdef DEBUG_TREEc;         fprintf(stderr, "xmlDocDump : document == NULL\n");p #endif 	return(-1);     }p,     encoding = (const char *) cur->encoding;       if (encoding != NULL) {_ 	xmlCharEncoding enc;t  & 	enc = xmlParseCharEncoding(encoding);  . 	if (cur->charset != XML_CHAR_ENCODING_UTF8) {; 	    fprintf(stderr, "xmlDocDump: document not in UTF8\n");- 	    return(-1); 	}% 	if (enc != XML_CHAR_ENCODING_UTF8) {x4 	    handler = xmlFindCharEncodingHandler(encoding); 	    if (handler == NULL) {e" 		xmlFree((char *) cur->encoding); 		cur->encoding = NULL;) 	    } 	}     }*0     buf = xmlOutputBufferCreateFile(f, handler);      if (buf == NULL) return(-1);,     xmlDocContentDumpOutput(buf, cur, NULL);  $     ret = xmlOutputBufferClose(buf);     return(ret); }t   /**   * xmlSaveFileTo:m  * @buf:  an output I/O buffer  * @cur:  the documentP  * @encoding:  the encoding if any assuming the i/O layer handles the trancoding  *)  * Dump an XML document to an I/O buffer.@  *@  * returns: the number of byte written or -1 in case of failure.  */a intcJ xmlSaveFileTo(xmlOutputBuffer *buf, xmlDocPtr cur, const char *encoding) {     int ret;       if (buf == NULL) return(0);P0     xmlDocContentDumpOutput(buf, cur, encoding);$     ret = xmlOutputBufferClose(buf);     return(ret); }    /**\  * xmlSaveFileEnc:$  * @filename:  the filename (or URL)  * @cur:  the document0  * @encoding:  the name of an encoding (or NULL)  *<  * Dump an XML document, converting it to the given encoding  *@  * returns: the number of byte written or -1 in case of failure.  */( int(K xmlSaveFileEnc(const char *filename, xmlDocPtr cur, const char *encoding) {x     xmlOutputBufferPtr buf;t-     xmlCharEncodingHandlerPtr handler = NULL;(     int ret;       if (encoding != NULL) {  	xmlCharEncoding enc;r  & 	enc = xmlParseCharEncoding(encoding);. 	if (cur->charset != XML_CHAR_ENCODING_UTF8) {? 	    fprintf(stderr, "xmlSaveFileEnc: document not in UTF8\n");o 	    return(-1); 	}% 	if (enc != XML_CHAR_ENCODING_UTF8) {(4 	    handler = xmlFindCharEncodingHandler(encoding); 	    if (handler == NULL) {D
 		return(-1);c 	    } 	}     }e       /* i)      * save the content to a temp buffer.:      */ >     buf = xmlOutputBufferCreateFilename(filename, handler, 0);     if (buf == NULL) return(0);   0     xmlDocContentDumpOutput(buf, cur, encoding);  $     ret = xmlOutputBufferClose(buf);     return(ret); }    /**n  * xmlSaveFile:f$  * @filename:  the filename (or URL)  * @cur:  the document  *:  * Dump an XML document to a file. Will use compression ifB  * compiled in and enabled. If @filename is "-" the stdout file is  * used.@  * returns: the number of byte written or -1 in case of failure.  */) intx2 xmlSaveFile(const char *filename, xmlDocPtr cur) {     xmlOutputBufferPtr buf;f     const char *encoding;l-     xmlCharEncodingHandlerPtr handler = NULL;r     int ret;       if (cur == NULL) 	return(-1);,     encoding = (const char *) cur->encoding;       /* S)      * save the content to a temp buffer.o      */( #ifdef HAVE_ZLIB_HA     if (cur->compression < 0) cur->compression = xmlCompressMode;  #endif     if (encoding != NULL) {s 	xmlCharEncoding enc;t  & 	enc = xmlParseCharEncoding(encoding);  . 	if (cur->charset != XML_CHAR_ENCODING_UTF8) {< 	    fprintf(stderr, "xmlSaveFile: document not in UTF8\n"); 	    return(-1); 	}% 	if (enc != XML_CHAR_ENCODING_UTF8) {t4 	    handler = xmlFindCharEncodingHandler(encoding); 	    if (handler == NULL) {s" 		xmlFree((char *) cur->encoding); 		cur->encoding = NULL;u 	    } 	}     }e  M     buf = xmlOutputBufferCreateFilename(filename, handler, cur->compression);      if (buf == NULL) return(0);s  ,     xmlDocContentDumpOutput(buf, cur, NULL);  $     ret = xmlOutputBufferClose(buf);     return(ret); }e  *     xmlOutputBufferWriteString(buf, "]>"); }    /**   * xmlAttrDumpOutput:a  * @buf:  the XML buffer output   * @doc:  the document  * @cur:  the attribute pointere*  * @encoding:  an optional encoding string  *  * Dump an XML attribute  */( static voidcH xmlAttrDumpOutput(xmlOutputBufferPtr buf, xmlDocPtr doc, xmlAttrPtr cur," 	          const char *encoding) {     xmlChar *value;        if (cur == NULL) { #ifdef DEBUG_TREEn<         fprintf(stderr, "xmlAttrDump : property == N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                