 #include "includes.h"    #define DEBUGLEVEL 15    static pstring scope = ""; int smb_read_error = 0;  BOOL passive = False;   /* the client file descriptor */ int Client = -1; int extra_time_offset = 0; int serverzone=0;   ' /* this is used by the chaining code */  int chain_size = 0;   D /*******************************************************************( return the SMB offset into an SMB bufferE ********************************************************************/ ! int smb_offset(char *p,char *buf)  { )   return(PTR_DIFF(p,buf+4) + chain_size);  }     D /*******************************************************************> find the difference in milliseconds between two struct timeval valuesE ********************************************************************/ = int TvalDiff(struct timeval *tvalold,struct timeval *tvalnew)  { 4   return((tvalnew->tv_sec - tvalold->tv_sec)*1000 + : 	 ((int)tvalnew->tv_usec - (int)tvalold->tv_usec)/1000);	  }   M /****************************************************************************    create an outgoing socket M   **************************************************************************/ J int open_socket_out(int type, struct in_addr *addr, int port ,int timeout) {  struct sockaddr_in sock_out; int	res,ret;    	res = socket(PF_INET, type, 0);   	if (res == -1) 2 		{ syslog(LOG_ERR,"socket error\n"); return -1; }  & 	if (type != SOCK_STREAM) return(res);   + 	bzero((char *)&sock_out,sizeof(sock_out)); 0 	putip((char *)&sock_out.sin_addr,(char *)addr);   # 	sock_out.sin_port = htons( port );  	sock_out.sin_family = PF_INET;   I 	syslog(LOG_DEBUG,"Connecting to %s at port %d\n",inet_ntoa(*addr),port);   < 	connect(res,(struct sockaddr *)&sock_out,sizeof(sock_out));   	return	res; }   D /*******************************************************************- copy an IP address from one buffer to another E ********************************************************************/   void putip(void *dest,void *src) {    memcpy(dest,src,4);  }   M /**************************************************************************** ! mangle a name into netbios format   G   Note:  <Out> must be (33 + strlen(scope) + 2) bytes long, at minimum. M ****************************************************************************/ 6 int name_mangle( char *In, char *Out, char name_type )   { 
   int   i;
   int   c;   int   len;   char  buf[20];   char *p = Out;  5   /* Safely copy the input string, In, into buf[]. */    (void)memset( buf, 0, 20 );    if( '*' == In[0] )     buf[0] = '*';    else6     (void)sprintf( buf, "%-15.15s%c", In, name_type );  C   /* Place the length of the first field into the output buffer. */    p[0] = 32;   p++;  8   /* Now convert the name to the rfc1001/1002 format. */   for( i = 0; i < 16; i++ )      {      c = toupper( buf[i] );-     p[i*2]     = ( (c >> 4) & 0x000F ) + 'A'; $     p[(i*2)+1] = (c & 0x000F) + 'A';     } 
   p += 32;   p[0] = '\0';     /* Add the scope string. */ 2   for( i = 0, len = 0; NULL != scope; i++, len++ )     {      switch( scope[i] )       {        case '\0':         p[0]     = len;          if( len > 0 )            p[len+1] = 0;           return( name_len(Out) );       case '.':          p[0] = len;          p   += (len + 1);          len  = 0;          break;       default:         p[len+1] = scope[i];         break;       }      }      return( name_len(Out) );   } /* name_mangle */   M /**************************************************************************** 1 return the total storage length of a mangled name M ****************************************************************************/  int name_len( char *s )    { 
   int len;  ;   /* If the two high bits of the byte are set, return 2. */ ,   if( 0xC0 == (*(unsigned char *)s & 0xC0) )     return(2);      /* Add up the length bytes. */%   for( len = 1; (*s); s += (*s) + 1 )      {      len += *s + 1;     }      return( len );   } /* name_len */  D /*******************************************************************!   set the length of an smb packet E ********************************************************************/ # void _smb_setlen(char *buf,int len)  { 
   buf[0] = 0;    buf[1] = (len&0x10000)>>16;    buf[2] = (len&0xFF00)>>8;    buf[3] = len&0xFF; }   D /*******************************************************************" skip past some strings in a bufferE ********************************************************************/ " char *skip_string(char *buf,int n) { 
   while (n--)      buf += strlen(buf) + 1;    return(buf); }   M /****************************************************************************     close the socket communicationM ****************************************************************************/  void close_sockets(void )  {    close(Client);
   Client = 0;  }   M /****************************************************************************    send an smb to a fd M ****************************************************************************/ " BOOL send_smb(int fd,char *buffer) { 
   int len;   int ret,nwritten=0;    len = smb_len(buffer) + 4;     while (nwritten < len)     { <       ret = write_socket(fd,buffer+nwritten,len - nwritten);       if (ret <= 0)  	{M 	  syslog(LOG_ERR,"Error writing %d bytes to client. %d. Exiting\n",len,ret);            close_sockets(); 	  exit(1);  	}       nwritten += ret;     }      return True; }     M /****************************************************************************  write to a socket M ****************************************************************************/ * int write_socket(int fd,char *buf,int len) {    int ret=0;     if (passive)     return(len);3   syslog(LOG_DEBUG,"write_socket(%d,%d)\n",fd,len);    ret = write_data(fd,buf,len);        @   syslog(LOG_DEBUG,"write_socket(%d,%d) wrote %d\n",fd,len,ret);   if(ret <= 0)V     syslog(LOG_ERR,"write_socket: Error writing %d bytes to socket %d: ERRNO = %s\n", "        len, fd, strerror(errno) );     return(ret); }   M /**************************************************************************** 6   read data from the client, reading exactly N bytes. M ****************************************************************************/ ( int read_data(int fd,char *buffer,int N) {    int  ret;    int total=0;        smb_read_error = 0;      while (total < N)      { .       ret = read(fd,buffer + total,N - total);       if (ret == 0) {  	smb_read_error = READ_EOF; 
 	return 0;       }        if (ret == -1) { 	smb_read_error = READ_ERROR;  	return -1;        }        total += ret;      }    return total;  }     M /****************************************************************************    write data to a fd  M ****************************************************************************/ ) int write_data(int fd,char *buffer,int N)  {    int total=0;
   int ret;     while (total < N)      { /       ret = write(fd,buffer + total,N - total);          if (ret == -1) return -1; !       if (ret == 0) return total;          total += ret;      }    return total;  }   M /**************************************************************************** M   read an smb from a fd ignoring all keepalive packets. Note that the buffer  .   *MUST* be of size BUFFER_SIZE+SAFETY_MARGIN.!   The timeout is in milli seconds   F   This is exactly the same as receive_smb except that it never returns>   a session keepalive packet (just as receive_smb used to do).W   receive_smb was changed to return keepalives as the oplock processing means this call '   should never go into a blocking read. M ****************************************************************************/   9 BOOL client_receive_smb(int fd,char *buffer, int timeout)  {    BOOL ret;   	   for(;;)    { +     ret = receive_smb(fd, buffer, timeout);        if(ret == False)       return ret;   +     /* Ignore session keepalive packets. */      if(CVAL(buffer,0) != 0x85)       break;   } 
   return ret;  }     M /**************************************************************************** . read data from a device with a timout in msec.7 mincount = if timeout, minimum to read before returning  maxcount = number to be read. M ****************************************************************************/ K int read_with_timeout(int fd,char *buf,int mincnt,int maxcnt,long time_out)  { 
   int selrtn;    int readret;   int nread = 0;   struct timeval timeout;      /* just checking .... */   if (maxcnt <= 0) return(0);      smb_read_error = 0;     %     if (mincnt == 0) mincnt = maxcnt;        while (nread < mincnt) {6       readret = read(fd, buf + nread, maxcnt - nread);       if (readret == 0) {  	smb_read_error = READ_EOF;  	return -1;        }          if (readret == -1) { 	smb_read_error = READ_ERROR;  	return -1;        }        nread += readret;      }       return(nread); }   M /**************************************************************************** D read 4 bytes of a smb packet and return the smb length of the packet store the result in the bufferF This version of the function will return a length of zero on receiving a keepalive packet. M ****************************************************************************/ K static int read_smb_length_return_keepalive(int fd,char *inbuf,int timeout)  {    int len=0, msg_type;   BOOL ok=False;  
   while (!ok)      {        if (timeout > 0)5 	ok = (read_with_timeout(fd,inbuf,4,4,timeout) == 4);        else  # 	ok = (read_data(fd,inbuf,4) == 4);          if (!ok) 	return(-1);         len = smb_len(inbuf);        msg_type = CVAL(inbuf,0);          if (msg_type == 0x85) 3         syslog(LOG_DEBUG,"Got keepalive packet\n");      }   1   syslog(LOG_DEBUG,"got smb length of %d\n",len);      return(len); }   M /**************************************************************************** ?   read an smb from a fd. Note that the buffer *MUST* be of size    BUFFER_SIZE+SAFETY_MARGIN.#   The timeout is in milli seconds.        This function will return on a(   receipt of a session keepalive packet.M ****************************************************************************/ 2 BOOL receive_smb(int fd,char *buffer, int timeout) {    int len,ret;     smb_read_error = 0;      bzero(buffer,smb_size + 100);   <   len = read_smb_length_return_keepalive(fd,buffer,timeout);   if (len < 0)     return(False);     if (len > BUFFER_SIZE) {?     syslog(LOG_ERR,"Invalid packet length! (%d bytes).\n",len); .     if (len > BUFFER_SIZE + (SAFETY_MARGIN/2))       exit(1);   }      if(len > 0) { %     ret = read_data(fd,buffer+4,len);      if (ret != len) { "       smb_read_error = READ_ERROR;       return False;      }    }    return(True);  }   D /*******************************************************************$   return the length of an smb packetE ********************************************************************/  int smb_len(char *buf) { C   return( PVAL(buf,3) | (PVAL(buf,2)<<8) | ((PVAL(buf,1)&1)<<16) );  }   D /*******************************************************************7   setup the word count and byte count for a smb message E ********************************************************************/ @ int set_message(char *buf,int num_words,int num_bytes,BOOL zero) {    if (zero) 2     bzero(buf + smb_size,num_words*2 + num_bytes);    CVAL(buf,smb_wct) = num_words;8   SSVAL(buf,smb_vwv + num_words*SIZEOFWORD,num_bytes);  9   smb_setlen(buf,smb_size + num_words*2 + num_bytes - 4); .   return (smb_size + num_words*2 + num_bytes); }   D /*******************************************************************,   set the length and marker of an smb packetE ********************************************************************/ " void smb_setlen(char *buf,int len) {    _smb_setlen(buf,len);      CVAL(buf,4) = 0xFF;    CVAL(buf,5) = 'S';   CVAL(buf,6) = 'M';   CVAL(buf,7) = 'B'; }     D /******************************************************************* return the number of smb wordsE ********************************************************************/  int smb_numwords(char *buf)  {    return (CVAL(buf,smb_wct));  }   D /*******************************************************************2 return the size of the smb_buf region of a messageE ********************************************************************/  int smb_buflen(char *buf)  { 3   return(SVAL(buf,smb_vwv0 + smb_numwords(buf)*2));  }   D /*******************************************************************+   return a pointer to the smb_buf data area E ********************************************************************/  int smb_buf_ofs(char *buf) { *   return (smb_size + CVAL(buf,smb_wct)*2); }   D /*******************************************************************+   return a pointer to the smb_buf data area E ********************************************************************/  char *smb_buf(char *buf) { "   return (buf + smb_buf_ofs(buf)); }   D /*******************************************************************    convert a string to lower caseE ********************************************************************/  void strlower(char *s) {    while (*s)   {      {        if (isupper(*s))         *s = tolower(*s); 
       s++;     }    }  }   D /*******************************************************************    convert a string to upper caseE ********************************************************************/  void strupper(char *s) {    while (*s)   {      {        if (islower(*s))         *s = toupper(*s); 
       s++;     }    }  }   D /*******************************************************************<   interpret a 32 bit dos packed date/time to some parametersE ********************************************************************/ k static void interpret_dos_date(uint32 date,int *year,int *month,int *day,int *hour,int *minute,int *second)  {    uint32 p0,p1,p2,p3;   ,   p0=date&0xFF; p1=((date&0xFF00)>>8)&0xFF; A   p2=((date&0xFF0000)>>16)&0xFF; p3=((date&0xFF000000)>>24)&0xFF;      *second = 2*(p0 & 0x1F);+   *minute = ((p0>>5)&0xFF) + ((p1&0x7)<<3);    *hour = (p1>>3)&0xFF;    *day = (p2&0x1F); .   *month = ((p2>>5)&0xFF) + ((p3&0x1)<<3) - 1;   *year = ((p3>>1)&0xFF) + 80; }   D /*******************************************************************D   create a unix date (int GMT) from a dos date (which is actually in   localtime)E ********************************************************************/ % time_t make_unix_date(void *date_ptr)  {    uint32 dos_date=0;   struct tm t;
   time_t ret;      dos_date = IVAL(date_ptr,0);     if (dos_date == 0) return(0);    3   interpret_dos_date(dos_date,&t.tm_year,&t.tm_mon, 2 		     &t.tm_mday,&t.tm_hour,&t.tm_min,&t.tm_sec);   t.tm_isdst = -1;   B   /* mktime() also does the local to GMT time conversion for us */   ret = mktime(&t);      return(ret); }   D /*******************************************************************   show a smb message structure  	   Hacked. E ********************************************************************/  void show_msg(char *buf) { return; }    typedef struct { 
   char *name;    int code;    char *message; } err_code_struct;   /* Dos Error Messages */ err_code_struct dos_msgs[] = {'   {"ERRbadfunc",1,"Invalid function."}, %   {"ERRbadfile",2,"File not found."}, (   {"ERRbadpath",3,"Directory invalid."},2   {"ERRnofids",4,"No file descriptors available"},%   {"ERRnoaccess",5,"Access denied."}, )   {"ERRbadfid",6,"Invalid file handle."}, 5   {"ERRbadmcb",7,"Memory control blocks destroyed."}, P   {"ERRnomem",8,"Insufficient server memory to perform the requested function."} , 2   {"ERRbadmem",9,"Invalid memory block address."},*   {"ERRbadenv",10,"Invalid environment."},(   {"ERRbadformat",11,"Invalid format."},+   {"ERRbadaccess",12,"Invalid open mode."}, $   {"ERRbaddata",13,"Invalid data."},   {"ERR",14,"reserved."}, 0   {"ERRbaddrive",15,"Invalid drive specified."},\   {"ERRremcd",16,"A Delete Directory request attempted  to  remove  the  server's  current \
 directory."}, *   {"ERRdiffdevice",17,"Not same device."},d   {"ERRnofiles",18,"A File Search command can find no more files matching the specified criteria."},j   {"ERRbadshare",32,"The sharing mode specified for an Open conflicts with existing  FIDs  on the file."},`   {"ERRlock",33,"A Lock request conflicted with an existing lock or specified an invalid mode, \N  or an Unlock requested attempted to remove a lock held by another process."},@   {"ERRnosuchshare", 67, "You specified an invalid share name"},W   {"ERRfilexists",80,"The file named in a Create Directory, Make  New  File  or  Link \* request already exists."},%   {"ERRbadpipe",230,"Pipe invalid."},aF   {"ERRpipebusy",231,"All instances of the requested pipe are busy."},3   {"ERRpipeclosing",232,"Pipe close in progress."},*=   {"ERRnotconnected",233,"No process on other end of pipe."},w;   {"ERRmoredata",234,"There is more data to be returned."},*?   {"ERRinvgroup",2455,"Invalid workgroup (try the -W option)"},t   {NULL,-1,NULL}};   /* Server Error Messages */l! err_code_struct server_msgs[] = { ,   {"ERRerror",1,"Non-specific error code."},[   {"ERRbadpw",2,"Bad password - name/password pair in a Tree Connect or Session Setup are \* invalid."},r   {"ERRbadtype",3,"reserved."},*   {"ERRaccess",4,"The requester does not have  the  necessary  access  rights  within  the specified  context for the requested function. The context is defined by the TID or the UID."},J   {"ERRinvnid",5,"The tree ID (TID) specified in a command was invalid."},>   {"ERRinvnetname",6,"Invalid network name in tree connect."},Y   {"ERRinvdevice",7,"Invalid device - printer request made to non-printer connection or \t2 non-printer request made to printer connection."},M   {"ERRqfull",49,"Print queue full (files) -- returned by open print file."},n4   {"ERRqtoobig",50,"Print queue full -- no space."},,   {"ERRqeof",51,"EOF on print queue dump."},.   {"ERRinvpfid",52,"Invalid print file FID."},H   {"ERRsmbcmd",64,"The server did not recognize the command received."},`   {"ERRsrverror",65,"The server encountered an internal error, e.g., system file unavailable."},Z   {"ERRfilespecs",67,"The file handle (FID) and pathname parameters contained an invalid \ combination of values."},*!   {"ERRreserved",68,"reserved."},g   {"ERRbadpermits",69,"The access permissions specified for a file or directory are not a valid combination.  The server cannot set the requested attribute."},*!   {"ERRreserved",70,"reserved."},m[   {"ERRsetattrmode",71,"The attribute mode in the Set File Attribute request is invalid."},h'   {"ERRpaused",81,"Server is paused."},f-   {"ERRmsgoff",82,"Not receiving messages."}, 0   {"ERRnoroom",83,"No room to buffer message."},0   {"ERRrmuns",87,"Too many remote user names."},+   {"ERRtimeout",88,"Operation timed out."},PG   {"ERRnoresource",89,"No resources currently available for request."},3@   {"ERRtoomanyuids",90,"Too many UIDs active on this session."},I   {"ERRbaduid",91,"The UID is not known as a valid ID on this session."}, @   {"ERRusempx",250,"Temp unable to support Raw, use MPX mode."},K   {"ERRusestd",251,"Temp unable to support Raw, use standard read/write."},n-   {"ERRcontmpx",252,"Continue in MPX mode."},+"   {"ERRreserved",253,"reserved."},"   {"ERRreserved",254,"reserved."},4   {"ERRnosupport",0xFFFF,"Function not supported."},   {NULL,-1,NULL}};   /* Hard Error Messages */t err_code_struct hard_msgs[] = {[D   {"ERRnowrite",19,"Attempt to write on write-protected diskette."},$   {"ERRbadunit",20,"Unknown unit."},(   {"ERRnotready",21,"Drive not ready."},&   {"ERRbadcmd",22,"Unknown command."},%   {"ERRdata",23,"Data error (CRC)."},*3   {"ERRbadreq",24,"Bad request structure length."},*    {"ERRseek",25 ,"Seek error."},+   {"ERRbadmedia",26,"Unknown media type."},**   {"ERRbadsector",27,"Sector not found."},,   {"ERRnopaper",28,"Printer out of paper."},!   {"ERRwrite",29,"Write fault."},h   {"ERRread",30,"Read fault."}, '   {"ERRgeneral",31,"General failure."},s@   {"ERRbadshare",32,"An open conflicts with an existing open."},Q   {"ERRlock",33,"A Lock request conflicted with an existing lock or specified an\nQ  invalid mode, or an Unlock requested attempted to remove a lock held by another\*  process."},=   {"ERRwrongdisk",34,"The wrong disk was found in a drive."},*C   {"ERRFCBUnavail",35,"No FCBs are available to process request."}, >   {"ERRsharebufexc",36,"A sharing buffer has been exceeded."},   {NULL,-1,NULL}};   struct {    int code;n   char *class;   err_code_struct *err_msgs; } err_classes[] = {    {0,"SUCCESS",NULL},s   {0x01,"ERRDOS",dos_msgs},*   {0x02,"ERRSRV",server_msgs},   {0x03,"ERRHRD",hard_msgs},   {0x04,"ERRXOS",NULL},(   {0xE1,"ERRRMX1",NULL},   {0xE2,"ERRRMX2",NULL},   {0xE3,"ERRRMX3",NULL},   {0xFF,"ERRCMD",NULL},*   {-1,NULL,NULL}};  M /*****************************************************************************+ return a SMB error string from a SMB buffer*M ****************************************************************************/; char *smb_errstr(char *inbuf)* {*   static pstring ret;*#   int class = CVAL(inbuf,smb_rcls);*    int num = SVAL(inbuf,smb_err);
   int i,j;  $   for (i=0;err_classes[i].class;i++)%     if (err_classes[i].code == class)n       {  	if (err_classes[i].err_msgs)  	  {4 	    err_code_struct *err = err_classes[i].err_msgs; 	    for (j=0;err[j].name;j++) 	      if (num == err[j].code) 		{e 		  if (DEBUGLEVEL > 0)(6 		    sprintf(ret,"%s - %s (%s)",err_classes[i].class,# 			    err[j].name,err[j].message);  		  else> 		    sprintf(ret,"%s - %s",err_classes[i].class,err[j].name); 		  return ret;  		}  	  }  1 	sprintf(ret,"%s - %d",err_classes[i].class,num);* 	return ret;       }*   8   sprintf(ret,"Error: Unknown error (%d,%d)",class,num);   return(ret); }*   #ifndef TIME_T_MIN: #define TIME_T_MIN ((time_t)0 < (time_t) -1 ? (time_t) 0 \9 		    : ~ (time_t) 0 << (sizeof (time_t) * CHAR_BIT - 1))r #endif #ifndef TIME_T_MAX. #define TIME_T_MAX (~ (time_t) 0 - TIME_T_MIN) #endif   #define TM_YEAR_BASE 1900   L #define TIME_FIXUP_CONSTANT (369.0*365.25*24*60*60-(3.0*24*60*60+6.0*60*60))  M /**************************************************************************** N   return the UTC offset in seconds west of UTC, adjusted for extra time offsetM   **************************************************************************/s int TimeDiff(time_t t) {*2   return TimeZoneFaster(t) + 60*extra_time_offset; }   M /**************************************************************************** G   return the UTC offset in seconds west of UTC, adjusted for extra timefE   offset, for a local time value.  If ut = lt + LocTimeDiff(lt), then I   lt = ut - TimeDiff(ut), but the converse does not necessarily hold near F   daylight savings transitions because some local times are ambiguous.M   LocTimeDiff(t) equals TimeDiff(t) except near daylight savings transitions.*N   +**************************************************************************/" static int LocTimeDiff(time_t lte) {*)   time_t lt = lte - 60*extra_time_offset;t   int d = TimeZoneFaster(lt);    time_t t = lt + d;  ?   /* if overflow occurred, ignore all the adjustments so far */ F   if (((lte < lt) ^ (extra_time_offset < 0))  |  ((t < lt) ^ (d < 0)))     t = lte;  N   /* now t should be close enough to the true UTC to yield the right answer */   return TimeDiff(t);* }*  M /****************************************************************************u4 interpret an 8 byte "filetime" structure to a time_t3 It's originally in "100ns units since jan 1st 1601"c  D It appears to be kludge-GMT (at least for file listings). This means8 its the GMT you get by taking a localtime and adding theC serverzone. This is NOT the same as GMT in some cases. This routine  converts this to real GMT.M ****************************************************************************/*# time_t interpret_long_date(char *p)n {e   double d; 
   time_t ret;,   uint32 tlow,thigh;   tlow = IVAL(p,0);;   thigh = IVAL(p,4);     if (thigh == 0) return(0);  *   d = ((double)thigh)*4.0*(double)(1<<30);   d += (tlow&0xFFF00000);p   d *= 1.0e-7;   ;   /* now adjust by 369 years to make the secs since 1970 */r   d -= TIME_FIXUP_CONSTANT;*       ret = (time_t)(d+0.5);  1   /* this takes us from kludge-GMT to real GMT */v   ret -= serverzone;   ret += LocTimeDiff(ret);     return(ret); }r  D /*******************************************************************I yield the difference between *A and *B, in seconds, ignoring leap seconds(E ********************************************************************/n. static int tm_diff(struct tm *a, struct tm *b) {v+   int ay = a->tm_year + (TM_YEAR_BASE - 1); +   int by = b->tm_year + (TM_YEAR_BASE - 1);r   int intervening_leap_days = :     (ay/4 - by/4) - (ay/100 - by/100) + (ay/400 - by/400);   int years = ay - by;K   int days = 365*years + intervening_leap_days + (a->tm_yday - b->tm_yday);E2   int hours = 24*days + (a->tm_hour - b->tm_hour);3   int minutes = 60*hours + (a->tm_min - b->tm_min); 5   int seconds = 60*minutes + (a->tm_sec - b->tm_sec);n     return seconds;* }*  D /*******************************************************************.   return the UTC offset in seconds west of UTCE   ******************************************************************/  static int TimeZone(time_t t)f {r#   struct tm tm_utc = *(gmtime(&t)); (   return tm_diff(&tm_utc,localtime(&t)); }*  D /*******************************************************************C return the same value as TimeZone, but it should be more efficient.   F We keep a table of DST offsets to prevent calling localtime() on each ? call of this function. This saves a LOT of time on many unixes.   + Updated by Paul Eggert <eggert@twinsun.com>oE ********************************************************************/( int TimeZoneFaster(time_t t) {=J   static struct dst_table {time_t start,end; int zone;} *dst_table = NULL;   static int table_size = 0;   int i;   int zone = 0;u     if (t == 0) t = time(NULL);*  ?   /* Tunis has a 8 day DST region, we need to be careful ... */d$ #define MAX_DST_WIDTH (365*24*60*60)! #define MAX_DST_SKIP (7*24*60*60)+     for (i=0;i<table_size;i++)@     if (t >= dst_table[i].start && t <= dst_table[i].end) break;     if (i<table_size) {p     zone = dst_table[i].zone;*
   } else {     time_t low,high;       zone = TimeZone(t);r6     dst_table = (struct dst_table *)Realloc(dst_table,' 					      sizeof(dst_table[0])*(i+1));z     if (!dst_table) {0       table_size = 0;b     } else {       table_size++;t          dst_table[i].zone = zone; 0       dst_table[i].start = dst_table[i].end = t;     2       /* no entry will cover more than 6 months */        low = t - MAX_DST_WIDTH/2;       !       high = t + MAX_DST_WIDTH/2;n       <       /* widen the new entry using two bisection searches */.       while (low+60*60 < dst_table[i].start) {/ 	if (dst_table[i].start - low > MAX_DST_SKIP*2) ) 	  t = dst_table[i].start - MAX_DST_SKIP;* 	else*( 	  t = low + (dst_table[i].start-low)/2; 	if (TimeZone(t) == zone)* 	  dst_table[i].start = t; 	else* 	  low = t;*       }   -       while (high-60*60 > dst_table[i].end) { . 	if (high - dst_table[i].end > MAX_DST_SKIP*2)' 	  t = dst_table[i].end + MAX_DST_SKIP;* 	else*( 	  t = high - (high-dst_table[i].end)/2; 	if (TimeZone(t) == zone)  	  dst_table[i].end = t; 	else* 	  high = t;       }* #if 0**       DEBUG(1,("Added DST entry from %s ",2 	       asctime(localtime(&dst_table[i].start))));D       DEBUG(1,("to %s (%d)\n",asctime(localtime(&dst_table[i].end)), 	       dst_table[i].zone)); #endif     }    }o   return zone; }b    * /* Encryption stuff from samba:smbdes.c */6 void str_to_key(unsigned char *str,unsigned char *key) {m 	int i;    	key[0] = str[0]>>1;+ 	key[1] = ((str[0]&0x01)<<6) | (str[1]>>2);*+ 	key[2] = ((str[1]&0x03)<<5) | (str[2]>>3);a+ 	key[3] = ((str[2]&0x07)<<4) | (str[3]>>4);*+ 	key[4] = ((str[3]&0x0F)<<3) | (str[4]>>5);e+ 	key[5] = ((str[4]&0x1F)<<2) | (str[5]>>6);e+ 	key[6] = ((str[5]&0x3F)<<1) | (str[6]>>7);  	key[7] = str[6]&0x7F; 	for (i=0;i<8;i++) { 		key[i] = (key[i]<<1);* 	} }*    3 static int perm1[56] = {57, 49, 41, 33, 25, 17,  9,t 			 1, 58, 50, 42, 34, 26, 18, 			10,  2, 59, 51, 43, 35, 27, 			19, 11,  3, 60, 52, 44, 36, 			63, 55, 47, 39, 31, 23, 15, 			 7, 62, 54, 46, 38, 30, 22, 			14,  6, 61, 53, 45, 37, 29, 			21, 13,  5, 28, 20, 12,  4};*  / static int perm2[48] = {14, 17, 11, 24,  1,  5,f/                          3, 28, 15,  6, 21, 10,*/                         23, 19, 12,  4, 26,  8,c/                         16,  7, 27, 20, 13,  2,n/                         41, 52, 31, 37, 47, 55,*/                         30, 40, 51, 45, 33, 48,e/                         44, 49, 39, 56, 34, 53,*0                         46, 42, 50, 36, 29, 32};  7 static int perm3[64] = {58, 50, 42, 34, 26, 18, 10,  2,_" 			60, 52, 44, 36, 28, 20, 12,  4," 			62, 54, 46, 38, 30, 22, 14,  6," 			64, 56, 48, 40, 32, 24, 16,  8," 			57, 49, 41, 33, 25, 17,  9,  1," 			59, 51, 43, 35, 27, 19, 11,  3," 			61, 53, 45, 37, 29, 21, 13,  5,# 			63, 55, 47, 39, 31, 23, 15,  7};   2 static int perm4[48] = {   32,  1,  2,  3,  4,  5,2                             4,  5,  6,  7,  8,  9,2                             8,  9, 10, 11, 12, 13,2                            12, 13, 14, 15, 16, 17,2                            16, 17, 18, 19, 20, 21,2                            20, 21, 22, 23, 24, 25,2                            24, 25, 26, 27, 28, 29,3                            28, 29, 30, 31, 32,  1};*  - static int perm5[32] = {      16,  7, 20, 21,*-                               29, 12, 28, 17,*-                                1, 15, 23, 26,h-                                5, 18, 31, 10, -                                2,  8, 24, 14, -                               32, 27,  3,  9,*-                               19, 13, 30,  6, .                               22, 11,  4, 25};    7 static int perm6[64] ={ 40,  8, 48, 16, 56, 24, 64, 32,*7                         39,  7, 47, 15, 55, 23, 63, 31,*7                         38,  6, 46, 14, 54, 22, 62, 30,d7                         37,  5, 45, 13, 53, 21, 61, 29,t7                         36,  4, 44, 12, 52, 20, 60, 28,=7                         35,  3, 43, 11, 51, 19, 59, 27,F7                         34,  2, 42, 10, 50, 18, 58, 26, 8                         33,  1, 41,  9, 49, 17, 57, 25};    E static int sc[16] = {1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};*   static int sbox[8][4][16] = {*C 	{{14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7}, B 	 {0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8},B 	 {4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0},D 	 {15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13}},  C 	{{15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10},)B 	 {3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5},B 	 {0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15},D 	 {13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9}},  C 	{{10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8},*C 	 {13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1},cC 	 {13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7},*C 	 {1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12}},e  B 	{{7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15},C 	 {13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9},{C 	 {10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4},oC 	 {3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14}},"  B 	{{2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9},C 	 {14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6},"B 	 {4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14},D 	 {11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3}},  C 	{{12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11},nC 	 {10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8},,B 	 {9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6},C 	 {4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13}},d  B 	{{4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1},C 	 {13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6},NB 	 {1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2},C 	 {6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12}},"  C 	{{13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7},DB 	 {1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2},B 	 {7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8},D 	 {2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11}}};  7 static void permute(char *out, char *in, int *p, int n)  {R 	int i;s 	for (i=0;i<n;i++) 		out[i] = in[p[i]-1]; }e  - static void lshift(char *d, int count, int n)" {  	char out[64]; 	int i;  	for (i=0;i<n;i++) 		out[i] = d[(i+count)%n]; 	for (i=0;i<n;i++) 		d[i] = out[i]; }"  C static void concat(char *out, char *in1, char *in2, int l1, int l2)2 {"
 	while (l1--)t 		*out++ = *in1++;
 	while (l2--)t 		*out++ = *in2++; }a  7 static void xor(char *out, char *in1, char *in2, int n)g {p 	int i;  	for (i=0;i<n;i++) 		out[i] = in1[i] ^ in2[i];r }   < static void dohash(char *out, char *in, char *key, int forw) {N
 	int i, j, k;o 	char pk1[56]; 	char c[28]; 	char d[28];
 	char cd[56];a 	char ki[16][48];t 	char pd1[64]; 	char l[32], r[32];r
 	char rl[64];e   	permute(pk1, key, perm1, 56);   	for (i=0;i<28;i++)n 		c[i] = pk1[i]; 	for (i=0;i<28;i++)  		d[i] = pk1[i+28];d   	for (i=0;i<16;i++) {e 		lshift(c, sc[i], 28);s 		lshift(d, sc[i], 28);e   		concat(cd, c, d, 28, 28); ! 		permute(ki[i], cd, perm2, 48); d 	}   	permute(pd1, in, perm3, 64);6   	for (j=0;j<32;j++) {  		l[j] = pd1[j]; 		r[j] = pd1[j+32];I 	}   	for (i=0;i<16;i++) {s 		char er[48]; 		char erk[48];o 		char b[8][6];  		char cb[32]; 		char pcb[32];n 		char r2[32];   		permute(er, r, perm4, 48);  * 		xor(erk, er, ki[forw ? i : 15 - i], 48);   		for (j=0;j<8;j++)  			for (k=0;k<6;k++) 				b[j][k] = erk[j*6 + k];    		for (j=0;j<8;j++) {v 			int m, n; 			m = (b[j][0]<<1) | b[j][5];  = 			n = (b[j][1]<<3) | (b[j][2]<<2) | (b[j][3]<<1) | b[j][4];     			for (k=0;k<4;k++) s0 				b[j][k] = (sbox[j][m][n] & (1<<(3-k)))?1:0;  		}u   		for (j=0;j<8;j++)f 			for (k=0;k<4;k++) 				cb[j*4+k] = b[j][k]; 		permute(pcb, cb, perm5, 32);   		xor(r2, l, pcb, 32);   		for (j=0;j<32;j++) 			l[j] = r[j];    		for (j=0;j<32;j++) 			r[j] = r2[j]; 	}   	concat(rl, r, l, 32, 32);   	permute(out, rl, perm6, 64);  }   X static void smbhash(unsigned char *out, unsigned char *in, unsigned char *key, int forw) {t 	int i;1 	char outb[64];o 	char inb[64]; 	char keyb[64];e 	unsigned char key2[8];R   	str_to_key(key, key2);e   	for (i=0;i<64;i++) {,. 		inb[i] = (in[i/8] & (1<<(7-(i%8)))) ? 1 : 0;1 		keyb[i] = (key2[i/8] & (1<<(7-(i%8)))) ? 1 : 0;o 		outb[i] = 0; 	}   	dohash(outb, inb, keyb, forw);t   	for (i=0;i<8;i++) {
 		out[i] = 0;8 	}   	for (i=0;i<64;i++) {i 		if (outb[i]) 			out[i/8] |= (1<<(7-(i%8))); 	} }y  1 void E_P16(unsigned char *p14,unsigned char *p16)T {UI 	unsigned char sp8[8] = {0x4b, 0x47, 0x53, 0x21, 0x40, 0x23, 0x24, 0x25};p 	smbhash(p16, sp8, p14, 1);P 	smbhash(p16+8, sp8, p14+7, 1);e }u  N void E_old_pw_hash( unsigned char *p14, unsigned char *in, unsigned char *out) {M!         smbhash(out, in, p14, 1);"'         smbhash(out+8, in+8, p14+7, 1);v }"  E void E_P24(unsigned char *p21, unsigned char *c8, unsigned char *p24)} {  	smbhash(p24, c8, p21, 1); 	smbhash(p24+8, c8, p21+7, 1);  	smbhash(p24+16, c8, p21+14, 1); }i  E void D_P16(unsigned char *p14, unsigned char *in, unsigned char *out)  {" 	smbhash(out, in, p14, 0);'         smbhash(out+8, in+8, p14+7, 0);a }"   /*5    This implements the X/Open SMB password encryption,B    It takes a password, a 8 byte "crypt key" and puts 24 bytes of !    encrypted password into p24 */a5 void SMBencrypt(uchar *passwd, uchar *c8, uchar *p24)  {"   uchar p14[15], p21[21];      memset(p21,'\0',21);   memset(p14,'\0',14);)   StrnCpy((char *)p14,(char *)passwd,14);n     strupper((char *)p14);   E_P16(p14, p21); 3   E_P24(p21, c8, p24); }n    B void SamOEMhash( unsigned char *data, unsigned char *key, int val) {t   unsigned char s_box[256];i   unsigned char index_i = 0;   unsigned char index_j = 0;   unsigned char j = 0;
   int ind;  !   for (ind = 0; ind < 256; ind++)w   {u$     s_box[ind] = (unsigned char)ind;   }N  !   for( ind = 0; ind < 256; ind++)s   {       unsigned char tc;  %      j += (s_box[ind] + key[ind%16]);         tc = s_box[ind];u      s_box[ind] = s_box[j];*      s_box[j] = tc;r   }e  .   for( ind = 0; ind < (val ? 516 : 16); ind++)   {      unsigned char tc;g     unsigned char t;       index_i++;     index_j += s_box[index_i];       tc = s_box[index_i];$     s_box[index_i] = s_box[index_j];     s_box[index_j] = tc;  (     t = s_box[index_i] + s_box[index_j];%     data[ind] = data[ind] ^ s_box[t];*   }* }*  